#include <linux/kernel.h>
#include <linux/module.h>

#include <mach/upmu_sw.h>
#include <mach/upmu_hw.h>
#include <mt-plat/upmu_common.h>

const PMU_FLAG_TABLE_ENTRY pmu_flags_table[] = {
	{PMIC_THR_DET_DIS, MT6328_PMIC_THR_DET_DIS_ADDR, MT6328_PMIC_THR_DET_DIS_MASK,
	 MT6328_PMIC_THR_DET_DIS_SHIFT},
	{PMIC_RG_THR_TMODE, MT6328_PMIC_RG_THR_TMODE_ADDR, MT6328_PMIC_RG_THR_TMODE_MASK,
	 MT6328_PMIC_RG_THR_TMODE_SHIFT},
	{PMIC_RG_THR_TEMP_SEL, MT6328_PMIC_RG_THR_TEMP_SEL_ADDR, MT6328_PMIC_RG_THR_TEMP_SEL_MASK,
	 MT6328_PMIC_RG_THR_TEMP_SEL_SHIFT},
	{PMIC_RG_STRUP_THR_SEL, MT6328_PMIC_RG_STRUP_THR_SEL_ADDR,
	 MT6328_PMIC_RG_STRUP_THR_SEL_MASK, MT6328_PMIC_RG_STRUP_THR_SEL_SHIFT},
	{PMIC_THR_HWPDN_EN, MT6328_PMIC_THR_HWPDN_EN_ADDR, MT6328_PMIC_THR_HWPDN_EN_MASK,
	 MT6328_PMIC_THR_HWPDN_EN_SHIFT},
	{PMIC_RG_THRDET_SEL, MT6328_PMIC_RG_THRDET_SEL_ADDR, MT6328_PMIC_RG_THRDET_SEL_MASK,
	 MT6328_PMIC_RG_THRDET_SEL_SHIFT},
	{PMIC_RG_STRUP_IREF_TRIM, MT6328_PMIC_RG_STRUP_IREF_TRIM_ADDR,
	 MT6328_PMIC_RG_STRUP_IREF_TRIM_MASK, MT6328_PMIC_RG_STRUP_IREF_TRIM_SHIFT},
	{PMIC_RG_USBDL_EN, MT6328_PMIC_RG_USBDL_EN_ADDR, MT6328_PMIC_RG_USBDL_EN_MASK,
	 MT6328_PMIC_RG_USBDL_EN_SHIFT},
	{PMIC_RG_FCHR_KEYDET_EN, MT6328_PMIC_RG_FCHR_KEYDET_EN_ADDR,
	 MT6328_PMIC_RG_FCHR_KEYDET_EN_MASK, MT6328_PMIC_RG_FCHR_KEYDET_EN_SHIFT},
	{PMIC_RG_FCHR_PU_EN, MT6328_PMIC_RG_FCHR_PU_EN_ADDR, MT6328_PMIC_RG_FCHR_PU_EN_MASK,
	 MT6328_PMIC_RG_FCHR_PU_EN_SHIFT},
	{PMIC_RG_EN_DRVSEL, MT6328_PMIC_RG_EN_DRVSEL_ADDR, MT6328_PMIC_RG_EN_DRVSEL_MASK,
	 MT6328_PMIC_RG_EN_DRVSEL_SHIFT},
	{PMIC_RG_RSTB_DRV_SEL, MT6328_PMIC_RG_RSTB_DRV_SEL_ADDR, MT6328_PMIC_RG_RSTB_DRV_SEL_MASK,
	 MT6328_PMIC_RG_RSTB_DRV_SEL_SHIFT},
	{PMIC_RG_VREF_BG, MT6328_PMIC_RG_VREF_BG_ADDR, MT6328_PMIC_RG_VREF_BG_MASK,
	 MT6328_PMIC_RG_VREF_BG_SHIFT},
	{PMIC_RG_PMU_RSV, MT6328_PMIC_RG_PMU_RSV_ADDR, MT6328_PMIC_RG_PMU_RSV_MASK,
	 MT6328_PMIC_RG_PMU_RSV_SHIFT},
	{PMIC_THR_TEST, MT6328_PMIC_THR_TEST_ADDR, MT6328_PMIC_THR_TEST_MASK,
	 MT6328_PMIC_THR_TEST_SHIFT},
	{PMIC_PMU_THR_DEB, MT6328_PMIC_PMU_THR_DEB_ADDR, MT6328_PMIC_PMU_THR_DEB_MASK,
	 MT6328_PMIC_PMU_THR_DEB_SHIFT},
	{PMIC_PMU_THR_STATUS, MT6328_PMIC_PMU_THR_STATUS_ADDR, MT6328_PMIC_PMU_THR_STATUS_MASK,
	 MT6328_PMIC_PMU_THR_STATUS_SHIFT},
	{PMIC_DDUVLO_DEB_EN, MT6328_PMIC_DDUVLO_DEB_EN_ADDR, MT6328_PMIC_DDUVLO_DEB_EN_MASK,
	 MT6328_PMIC_DDUVLO_DEB_EN_SHIFT},
	{PMIC_PWRBB_DEB_EN, MT6328_PMIC_PWRBB_DEB_EN_ADDR, MT6328_PMIC_PWRBB_DEB_EN_MASK,
	 MT6328_PMIC_PWRBB_DEB_EN_SHIFT},
	{PMIC_STRUP_OSC_EN, MT6328_PMIC_STRUP_OSC_EN_ADDR, MT6328_PMIC_STRUP_OSC_EN_MASK,
	 MT6328_PMIC_STRUP_OSC_EN_SHIFT},
	{PMIC_STRUP_OSC_EN_SEL, MT6328_PMIC_STRUP_OSC_EN_SEL_ADDR,
	 MT6328_PMIC_STRUP_OSC_EN_SEL_MASK, MT6328_PMIC_STRUP_OSC_EN_SEL_SHIFT},
	{PMIC_STRUP_FT_CTRL, MT6328_PMIC_STRUP_FT_CTRL_ADDR, MT6328_PMIC_STRUP_FT_CTRL_MASK,
	 MT6328_PMIC_STRUP_FT_CTRL_SHIFT},
	{PMIC_STRUP_PWRON_FORCE, MT6328_PMIC_STRUP_PWRON_FORCE_ADDR,
	 MT6328_PMIC_STRUP_PWRON_FORCE_MASK, MT6328_PMIC_STRUP_PWRON_FORCE_SHIFT},
	{PMIC_BIAS_GEN_EN_FORCE, MT6328_PMIC_BIAS_GEN_EN_FORCE_ADDR,
	 MT6328_PMIC_BIAS_GEN_EN_FORCE_MASK, MT6328_PMIC_BIAS_GEN_EN_FORCE_SHIFT},
	{PMIC_STRUP_PWRON, MT6328_PMIC_STRUP_PWRON_ADDR, MT6328_PMIC_STRUP_PWRON_MASK,
	 MT6328_PMIC_STRUP_PWRON_SHIFT},
	{PMIC_STRUP_PWRON_SEL, MT6328_PMIC_STRUP_PWRON_SEL_ADDR, MT6328_PMIC_STRUP_PWRON_SEL_MASK,
	 MT6328_PMIC_STRUP_PWRON_SEL_SHIFT},
	{PMIC_BIAS_GEN_EN, MT6328_PMIC_BIAS_GEN_EN_ADDR, MT6328_PMIC_BIAS_GEN_EN_MASK,
	 MT6328_PMIC_BIAS_GEN_EN_SHIFT},
	{PMIC_BIAS_GEN_EN_SEL, MT6328_PMIC_BIAS_GEN_EN_SEL_ADDR, MT6328_PMIC_BIAS_GEN_EN_SEL_MASK,
	 MT6328_PMIC_BIAS_GEN_EN_SEL_SHIFT},
	{PMIC_RTC_XOSC32_ENB_SW, MT6328_PMIC_RTC_XOSC32_ENB_SW_ADDR,
	 MT6328_PMIC_RTC_XOSC32_ENB_SW_MASK, MT6328_PMIC_RTC_XOSC32_ENB_SW_SHIFT},
	{PMIC_RTC_XOSC32_ENB_SEL, MT6328_PMIC_RTC_XOSC32_ENB_SEL_ADDR,
	 MT6328_PMIC_RTC_XOSC32_ENB_SEL_MASK, MT6328_PMIC_RTC_XOSC32_ENB_SEL_SHIFT},
	{PMIC_STRUP_DIG_IO_PG_FORCE, MT6328_PMIC_STRUP_DIG_IO_PG_FORCE_ADDR,
	 MT6328_PMIC_STRUP_DIG_IO_PG_FORCE_MASK, MT6328_PMIC_STRUP_DIG_IO_PG_FORCE_SHIFT},
	{PMIC_VPROC_PG_H2L_EN, MT6328_PMIC_VPROC_PG_H2L_EN_ADDR, MT6328_PMIC_VPROC_PG_H2L_EN_MASK,
	 MT6328_PMIC_VPROC_PG_H2L_EN_SHIFT},
	{PMIC_VAUX18_PG_H2L_EN, MT6328_PMIC_VAUX18_PG_H2L_EN_ADDR,
	 MT6328_PMIC_VAUX18_PG_H2L_EN_MASK, MT6328_PMIC_VAUX18_PG_H2L_EN_SHIFT},
	{PMIC_VCORE1_PG_H2L_EN, MT6328_PMIC_VCORE1_PG_H2L_EN_ADDR,
	 MT6328_PMIC_VCORE1_PG_H2L_EN_MASK, MT6328_PMIC_VCORE1_PG_H2L_EN_SHIFT},
	{PMIC_VSYS22_PG_H2L_EN, MT6328_PMIC_VSYS22_PG_H2L_EN_ADDR,
	 MT6328_PMIC_VSYS22_PG_H2L_EN_MASK, MT6328_PMIC_VSYS22_PG_H2L_EN_SHIFT},
	{PMIC_VLTE_PG_H2L_EN, MT6328_PMIC_VLTE_PG_H2L_EN_ADDR, MT6328_PMIC_VLTE_PG_H2L_EN_MASK,
	 MT6328_PMIC_VLTE_PG_H2L_EN_SHIFT},
	{PMIC_VIO18_PG_H2L_EN, MT6328_PMIC_VIO18_PG_H2L_EN_ADDR, MT6328_PMIC_VIO18_PG_H2L_EN_MASK,
	 MT6328_PMIC_VIO18_PG_H2L_EN_SHIFT},
	{PMIC_VAUD28_PG_H2L_EN, MT6328_PMIC_VAUD28_PG_H2L_EN_ADDR,
	 MT6328_PMIC_VAUD28_PG_H2L_EN_MASK, MT6328_PMIC_VAUD28_PG_H2L_EN_SHIFT},
	{PMIC_VTCXO_PG_H2L_EN, MT6328_PMIC_VTCXO_PG_H2L_EN_ADDR, MT6328_PMIC_VTCXO_PG_H2L_EN_MASK,
	 MT6328_PMIC_VTCXO_PG_H2L_EN_SHIFT},
	{PMIC_VUSB_PG_H2L_EN, MT6328_PMIC_VUSB_PG_H2L_EN_ADDR, MT6328_PMIC_VUSB_PG_H2L_EN_MASK,
	 MT6328_PMIC_VUSB_PG_H2L_EN_SHIFT},
	{PMIC_VSRAM_PG_H2L_EN, MT6328_PMIC_VSRAM_PG_H2L_EN_ADDR, MT6328_PMIC_VSRAM_PG_H2L_EN_MASK,
	 MT6328_PMIC_VSRAM_PG_H2L_EN_SHIFT},
	{PMIC_VIO28_PG_H2L_EN, MT6328_PMIC_VIO28_PG_H2L_EN_ADDR, MT6328_PMIC_VIO28_PG_H2L_EN_MASK,
	 MT6328_PMIC_VIO28_PG_H2L_EN_SHIFT},
	{PMIC_VM_PG_H2L_EN, MT6328_PMIC_VM_PG_H2L_EN_ADDR, MT6328_PMIC_VM_PG_H2L_EN_MASK,
	 MT6328_PMIC_VM_PG_H2L_EN_SHIFT},
	{PMIC_VPROC_PG_ENB, MT6328_PMIC_VPROC_PG_ENB_ADDR, MT6328_PMIC_VPROC_PG_ENB_MASK,
	 MT6328_PMIC_VPROC_PG_ENB_SHIFT},
	{PMIC_VAUX18_PG_ENB, MT6328_PMIC_VAUX18_PG_ENB_ADDR, MT6328_PMIC_VAUX18_PG_ENB_MASK,
	 MT6328_PMIC_VAUX18_PG_ENB_SHIFT},
	{PMIC_VCORE1_PG_ENB, MT6328_PMIC_VCORE1_PG_ENB_ADDR, MT6328_PMIC_VCORE1_PG_ENB_MASK,
	 MT6328_PMIC_VCORE1_PG_ENB_SHIFT},
	{PMIC_VSYS22_PG_ENB, MT6328_PMIC_VSYS22_PG_ENB_ADDR, MT6328_PMIC_VSYS22_PG_ENB_MASK,
	 MT6328_PMIC_VSYS22_PG_ENB_SHIFT},
	{PMIC_VLTE_PG_ENB, MT6328_PMIC_VLTE_PG_ENB_ADDR, MT6328_PMIC_VLTE_PG_ENB_MASK,
	 MT6328_PMIC_VLTE_PG_ENB_SHIFT},
	{PMIC_VIO18_PG_ENB, MT6328_PMIC_VIO18_PG_ENB_ADDR, MT6328_PMIC_VIO18_PG_ENB_MASK,
	 MT6328_PMIC_VIO18_PG_ENB_SHIFT},
	{PMIC_VAUD28_PG_ENB, MT6328_PMIC_VAUD28_PG_ENB_ADDR, MT6328_PMIC_VAUD28_PG_ENB_MASK,
	 MT6328_PMIC_VAUD28_PG_ENB_SHIFT},
	{PMIC_VTCXO_PG_ENB, MT6328_PMIC_VTCXO_PG_ENB_ADDR, MT6328_PMIC_VTCXO_PG_ENB_MASK,
	 MT6328_PMIC_VTCXO_PG_ENB_SHIFT},
	{PMIC_VUSB_PG_ENB, MT6328_PMIC_VUSB_PG_ENB_ADDR, MT6328_PMIC_VUSB_PG_ENB_MASK,
	 MT6328_PMIC_VUSB_PG_ENB_SHIFT},
	{PMIC_VSRAM_PG_ENB, MT6328_PMIC_VSRAM_PG_ENB_ADDR, MT6328_PMIC_VSRAM_PG_ENB_MASK,
	 MT6328_PMIC_VSRAM_PG_ENB_SHIFT},
	{PMIC_VIO28_PG_ENB, MT6328_PMIC_VIO28_PG_ENB_ADDR, MT6328_PMIC_VIO28_PG_ENB_MASK,
	 MT6328_PMIC_VIO28_PG_ENB_SHIFT},
	{PMIC_VM_PG_ENB, MT6328_PMIC_VM_PG_ENB_ADDR, MT6328_PMIC_VM_PG_ENB_MASK,
	 MT6328_PMIC_VM_PG_ENB_SHIFT},
	{PMIC_RG_EXT_PMIC_EN_PG_ENB, MT6328_PMIC_RG_EXT_PMIC_EN_PG_ENB_ADDR,
	 MT6328_PMIC_RG_EXT_PMIC_EN_PG_ENB_MASK, MT6328_PMIC_RG_EXT_PMIC_EN_PG_ENB_SHIFT},
	{PMIC_CLR_JUST_RST, MT6328_PMIC_CLR_JUST_RST_ADDR, MT6328_PMIC_CLR_JUST_RST_MASK,
	 MT6328_PMIC_CLR_JUST_RST_SHIFT},
	{PMIC_UVLO_L2H_DEB_EN, MT6328_PMIC_UVLO_L2H_DEB_EN_ADDR, MT6328_PMIC_UVLO_L2H_DEB_EN_MASK,
	 MT6328_PMIC_UVLO_L2H_DEB_EN_SHIFT},
	{PMIC_JUST_PWRKEY_RST, MT6328_PMIC_JUST_PWRKEY_RST_ADDR, MT6328_PMIC_JUST_PWRKEY_RST_MASK,
	 MT6328_PMIC_JUST_PWRKEY_RST_SHIFT},
	{PMIC_QI_OSC_EN, MT6328_PMIC_QI_OSC_EN_ADDR, MT6328_PMIC_QI_OSC_EN_MASK,
	 MT6328_PMIC_QI_OSC_EN_SHIFT},
	{PMIC_STRUP_EXT_PMIC_EN, MT6328_PMIC_STRUP_EXT_PMIC_EN_ADDR,
	 MT6328_PMIC_STRUP_EXT_PMIC_EN_MASK, MT6328_PMIC_STRUP_EXT_PMIC_EN_SHIFT},
	{PMIC_STRUP_EXT_PMIC_SEL, MT6328_PMIC_STRUP_EXT_PMIC_SEL_ADDR,
	 MT6328_PMIC_STRUP_EXT_PMIC_SEL_MASK, MT6328_PMIC_STRUP_EXT_PMIC_SEL_SHIFT},
	{PMIC_STRUP_CON8_RSV0, MT6328_PMIC_STRUP_CON8_RSV0_ADDR, MT6328_PMIC_STRUP_CON8_RSV0_MASK,
	 MT6328_PMIC_STRUP_CON8_RSV0_SHIFT},
	{PMIC_QI_EXT_PMIC_EN, MT6328_PMIC_QI_EXT_PMIC_EN_ADDR, MT6328_PMIC_QI_EXT_PMIC_EN_MASK,
	 MT6328_PMIC_QI_EXT_PMIC_EN_SHIFT},
	{PMIC_STRUP_AUXADC_START_SW, MT6328_PMIC_STRUP_AUXADC_START_SW_ADDR,
	 MT6328_PMIC_STRUP_AUXADC_START_SW_MASK, MT6328_PMIC_STRUP_AUXADC_START_SW_SHIFT},
	{PMIC_STRUP_AUXADC_RSTB_SW, MT6328_PMIC_STRUP_AUXADC_RSTB_SW_ADDR,
	 MT6328_PMIC_STRUP_AUXADC_RSTB_SW_MASK, MT6328_PMIC_STRUP_AUXADC_RSTB_SW_SHIFT},
	{PMIC_STRUP_AUXADC_START_SEL, MT6328_PMIC_STRUP_AUXADC_START_SEL_ADDR,
	 MT6328_PMIC_STRUP_AUXADC_START_SEL_MASK, MT6328_PMIC_STRUP_AUXADC_START_SEL_SHIFT},
	{PMIC_STRUP_AUXADC_RSTB_SEL, MT6328_PMIC_STRUP_AUXADC_RSTB_SEL_ADDR,
	 MT6328_PMIC_STRUP_AUXADC_RSTB_SEL_MASK, MT6328_PMIC_STRUP_AUXADC_RSTB_SEL_SHIFT},
	{PMIC_STRUP_PWROFF_SEQ_EN, MT6328_PMIC_STRUP_PWROFF_SEQ_EN_ADDR,
	 MT6328_PMIC_STRUP_PWROFF_SEQ_EN_MASK, MT6328_PMIC_STRUP_PWROFF_SEQ_EN_SHIFT},
	{PMIC_STRUP_PWROFF_PREOFF_EN, MT6328_PMIC_STRUP_PWROFF_PREOFF_EN_ADDR,
	 MT6328_PMIC_STRUP_PWROFF_PREOFF_EN_MASK, MT6328_PMIC_STRUP_PWROFF_PREOFF_EN_SHIFT},
	{PMIC_STRUP_PP_EN, MT6328_PMIC_STRUP_PP_EN_ADDR, MT6328_PMIC_STRUP_PP_EN_MASK,
	 MT6328_PMIC_STRUP_PP_EN_SHIFT},
	{PMIC_STRUP_PP_EN_SEL, MT6328_PMIC_STRUP_PP_EN_SEL_ADDR, MT6328_PMIC_STRUP_PP_EN_SEL_MASK,
	 MT6328_PMIC_STRUP_PP_EN_SEL_SHIFT},
	{PMIC_STRUP_DIG0_RSV0, MT6328_PMIC_STRUP_DIG0_RSV0_ADDR, MT6328_PMIC_STRUP_DIG0_RSV0_MASK,
	 MT6328_PMIC_STRUP_DIG0_RSV0_SHIFT},
	{PMIC_STRUP_DIG1_RSV0, MT6328_PMIC_STRUP_DIG1_RSV0_ADDR, MT6328_PMIC_STRUP_DIG1_RSV0_MASK,
	 MT6328_PMIC_STRUP_DIG1_RSV0_SHIFT},
	{PMIC_RG_UVLO_VTHL_RSV0, MT6328_PMIC_RG_UVLO_VTHL_RSV0_ADDR,
	 MT6328_PMIC_RG_UVLO_VTHL_RSV0_MASK, MT6328_PMIC_RG_UVLO_VTHL_RSV0_SHIFT},
	{PMIC_RG_BGR_RSV6, MT6328_PMIC_RG_BGR_RSV6_ADDR, MT6328_PMIC_RG_BGR_RSV6_MASK,
	 MT6328_PMIC_RG_BGR_RSV6_SHIFT},
	{PMIC_RG_BGR_RSV5, MT6328_PMIC_RG_BGR_RSV5_ADDR, MT6328_PMIC_RG_BGR_RSV5_MASK,
	 MT6328_PMIC_RG_BGR_RSV5_SHIFT},
	{PMIC_RG_BGR_RSV4, MT6328_PMIC_RG_BGR_RSV4_ADDR, MT6328_PMIC_RG_BGR_RSV4_MASK,
	 MT6328_PMIC_RG_BGR_RSV4_SHIFT},
	{PMIC_RG_BGR_RSV3, MT6328_PMIC_RG_BGR_RSV3_ADDR, MT6328_PMIC_RG_BGR_RSV3_MASK,
	 MT6328_PMIC_RG_BGR_RSV3_SHIFT},
	{PMIC_RG_BGR_RSV2, MT6328_PMIC_RG_BGR_RSV2_ADDR, MT6328_PMIC_RG_BGR_RSV2_MASK,
	 MT6328_PMIC_RG_BGR_RSV2_SHIFT},
	{PMIC_RG_BGR_RSV1, MT6328_PMIC_RG_BGR_RSV1_ADDR, MT6328_PMIC_RG_BGR_RSV1_MASK,
	 MT6328_PMIC_RG_BGR_RSV1_SHIFT},
	{PMIC_RG_BGR_RSV0, MT6328_PMIC_RG_BGR_RSV0_ADDR, MT6328_PMIC_RG_BGR_RSV0_MASK,
	 MT6328_PMIC_RG_BGR_RSV0_SHIFT},
	{PMIC_RG_STRUP_RSV, MT6328_PMIC_RG_STRUP_RSV_ADDR, MT6328_PMIC_RG_STRUP_RSV_MASK,
	 MT6328_PMIC_RG_STRUP_RSV_SHIFT},
	{PMIC_RG_EN_SMT, MT6328_PMIC_RG_EN_SMT_ADDR, MT6328_PMIC_RG_EN_SMT_MASK,
	 MT6328_PMIC_RG_EN_SMT_SHIFT},
	{PMIC_RG_EN_SR, MT6328_PMIC_RG_EN_SR_ADDR, MT6328_PMIC_RG_EN_SR_MASK,
	 MT6328_PMIC_RG_EN_SR_SHIFT},
	{PMIC_RG_EN_E8, MT6328_PMIC_RG_EN_E8_ADDR, MT6328_PMIC_RG_EN_E8_MASK,
	 MT6328_PMIC_RG_EN_E8_SHIFT},
	{PMIC_RG_EN_E4, MT6328_PMIC_RG_EN_E4_ADDR, MT6328_PMIC_RG_EN_E4_MASK,
	 MT6328_PMIC_RG_EN_E4_SHIFT},
	{PMIC_RG_TESTMODE_SWEN, MT6328_PMIC_RG_TESTMODE_SWEN_ADDR,
	 MT6328_PMIC_RG_TESTMODE_SWEN_MASK, MT6328_PMIC_RG_TESTMODE_SWEN_SHIFT},
	{PMIC_STRUP_DIG0_RSV1, MT6328_PMIC_STRUP_DIG0_RSV1_ADDR, MT6328_PMIC_STRUP_DIG0_RSV1_MASK,
	 MT6328_PMIC_STRUP_DIG0_RSV1_SHIFT},
	{PMIC_RG_RSV_SWREG, MT6328_PMIC_RG_RSV_SWREG_ADDR, MT6328_PMIC_RG_RSV_SWREG_MASK,
	 MT6328_PMIC_RG_RSV_SWREG_SHIFT},
	{PMIC_USBDL, MT6328_PMIC_USBDL_ADDR, MT6328_PMIC_USBDL_MASK, MT6328_PMIC_USBDL_SHIFT},
	{PMIC_STRUP_PG_STATUS_CLR, MT6328_PMIC_STRUP_PG_STATUS_CLR_ADDR,
	 MT6328_PMIC_STRUP_PG_STATUS_CLR_MASK, MT6328_PMIC_STRUP_PG_STATUS_CLR_SHIFT},
	{PMIC_STRUP_PP_EN_PWROFF_CNT, MT6328_PMIC_STRUP_PP_EN_PWROFF_CNT_ADDR,
	 MT6328_PMIC_STRUP_PP_EN_PWROFF_CNT_MASK, MT6328_PMIC_STRUP_PP_EN_PWROFF_CNT_SHIFT},
	{PMIC_STRUP_DIG0_RSV2, MT6328_PMIC_STRUP_DIG0_RSV2_ADDR, MT6328_PMIC_STRUP_DIG0_RSV2_MASK,
	 MT6328_PMIC_STRUP_DIG0_RSV2_SHIFT},
	{PMIC_STRUP_UVLO_U1U2_SEL, MT6328_PMIC_STRUP_UVLO_U1U2_SEL_ADDR,
	 MT6328_PMIC_STRUP_UVLO_U1U2_SEL_MASK, MT6328_PMIC_STRUP_UVLO_U1U2_SEL_SHIFT},
	{PMIC_STRUP_UVLO_U1U2_SEL_SWCTRL, MT6328_PMIC_STRUP_UVLO_U1U2_SEL_SWCTRL_ADDR,
	 MT6328_PMIC_STRUP_UVLO_U1U2_SEL_SWCTRL_MASK, MT6328_PMIC_STRUP_UVLO_U1U2_SEL_SWCTRL_SHIFT},
	{PMIC_STRUP_LBAT_INT_SEL_CLR, MT6328_PMIC_STRUP_LBAT_INT_SEL_CLR_ADDR,
	 MT6328_PMIC_STRUP_LBAT_INT_SEL_CLR_MASK, MT6328_PMIC_STRUP_LBAT_INT_SEL_CLR_SHIFT},
	{PMIC_STRUP_LBAT_INT_SEL_SWCTRL, MT6328_PMIC_STRUP_LBAT_INT_SEL_SWCTRL_ADDR,
	 MT6328_PMIC_STRUP_LBAT_INT_SEL_SWCTRL_MASK, MT6328_PMIC_STRUP_LBAT_INT_SEL_SWCTRL_SHIFT},
	{PMIC_STRUP_LBAT_INT_SEL, MT6328_PMIC_STRUP_LBAT_INT_SEL_ADDR,
	 MT6328_PMIC_STRUP_LBAT_INT_SEL_MASK, MT6328_PMIC_STRUP_LBAT_INT_SEL_SHIFT},
	{PMIC_STRUP_LBAT_IRQ_SET, MT6328_PMIC_STRUP_LBAT_IRQ_SET_ADDR,
	 MT6328_PMIC_STRUP_LBAT_IRQ_SET_MASK, MT6328_PMIC_STRUP_LBAT_IRQ_SET_SHIFT},
	{PMIC_STRUP_LBAT_IRQ_CLR, MT6328_PMIC_STRUP_LBAT_IRQ_CLR_ADDR,
	 MT6328_PMIC_STRUP_LBAT_IRQ_CLR_MASK, MT6328_PMIC_STRUP_LBAT_IRQ_CLR_SHIFT},
	{PMIC_STRUP_LBAT_IRQ_SWCTRL, MT6328_PMIC_STRUP_LBAT_IRQ_SWCTRL_ADDR,
	 MT6328_PMIC_STRUP_LBAT_IRQ_SWCTRL_MASK, MT6328_PMIC_STRUP_LBAT_IRQ_SWCTRL_SHIFT},
	{PMIC_RG_UVLO_VSYS_DEB_75K_RPCNT_MAX, MT6328_PMIC_RG_UVLO_VSYS_DEB_75K_RPCNT_MAX_ADDR,
	 MT6328_PMIC_RG_UVLO_VSYS_DEB_75K_RPCNT_MAX_MASK,
	 MT6328_PMIC_RG_UVLO_VSYS_DEB_75K_RPCNT_MAX_SHIFT},
	{PMIC_RG_UVLO_VSYS_DEB_2M_RPCNT_MAX, MT6328_PMIC_RG_UVLO_VSYS_DEB_2M_RPCNT_MAX_ADDR,
	 MT6328_PMIC_RG_UVLO_VSYS_DEB_2M_RPCNT_MAX_MASK,
	 MT6328_PMIC_RG_UVLO_VSYS_DEB_2M_RPCNT_MAX_SHIFT},
	{PMIC_STRUP_AUXADC_RPCNT_MAX, MT6328_PMIC_STRUP_AUXADC_RPCNT_MAX_ADDR,
	 MT6328_PMIC_STRUP_AUXADC_RPCNT_MAX_MASK, MT6328_PMIC_STRUP_AUXADC_RPCNT_MAX_SHIFT},
	{PMIC_RG_STRUP_THR_OVER_110_CLR, MT6328_PMIC_RG_STRUP_THR_OVER_110_CLR_ADDR,
	 MT6328_PMIC_RG_STRUP_THR_OVER_110_CLR_MASK, MT6328_PMIC_RG_STRUP_THR_OVER_110_CLR_SHIFT},
	{PMIC_RG_STRUP_THR_110_CLR, MT6328_PMIC_RG_STRUP_THR_110_CLR_ADDR,
	 MT6328_PMIC_RG_STRUP_THR_110_CLR_MASK, MT6328_PMIC_RG_STRUP_THR_110_CLR_SHIFT},
	{PMIC_RG_STRUP_THR_125_CLR, MT6328_PMIC_RG_STRUP_THR_125_CLR_ADDR,
	 MT6328_PMIC_RG_STRUP_THR_125_CLR_MASK, MT6328_PMIC_RG_STRUP_THR_125_CLR_SHIFT},
	{PMIC_RG_STRUP_THR_CLR, MT6328_PMIC_RG_STRUP_THR_CLR_ADDR,
	 MT6328_PMIC_RG_STRUP_THR_CLR_MASK, MT6328_PMIC_RG_STRUP_THR_CLR_SHIFT},
	{PMIC_RG_STRUP_THR_OVER_110_IRQ_EN, MT6328_PMIC_RG_STRUP_THR_OVER_110_IRQ_EN_ADDR,
	 MT6328_PMIC_RG_STRUP_THR_OVER_110_IRQ_EN_MASK,
	 MT6328_PMIC_RG_STRUP_THR_OVER_110_IRQ_EN_SHIFT},
	{PMIC_RG_STRUP_THR_110_IRQ_EN, MT6328_PMIC_RG_STRUP_THR_110_IRQ_EN_ADDR,
	 MT6328_PMIC_RG_STRUP_THR_110_IRQ_EN_MASK, MT6328_PMIC_RG_STRUP_THR_110_IRQ_EN_SHIFT},
	{PMIC_RG_STRUP_THR_125_IRQ_EN, MT6328_PMIC_RG_STRUP_THR_125_IRQ_EN_ADDR,
	 MT6328_PMIC_RG_STRUP_THR_125_IRQ_EN_MASK, MT6328_PMIC_RG_STRUP_THR_125_IRQ_EN_SHIFT},
	{PMIC_RG_STRUP_THR_OVER_110_IRQ_STATUS, MT6328_PMIC_RG_STRUP_THR_OVER_110_IRQ_STATUS_ADDR,
	 MT6328_PMIC_RG_STRUP_THR_OVER_110_IRQ_STATUS_MASK,
	 MT6328_PMIC_RG_STRUP_THR_OVER_110_IRQ_STATUS_SHIFT},
	{PMIC_RG_STRUP_THR_110_IRQ_STATUS, MT6328_PMIC_RG_STRUP_THR_110_IRQ_STATUS_ADDR,
	 MT6328_PMIC_RG_STRUP_THR_110_IRQ_STATUS_MASK,
	 MT6328_PMIC_RG_STRUP_THR_110_IRQ_STATUS_SHIFT},
	{PMIC_RG_STRUP_THR_125_IRQ_STATUS, MT6328_PMIC_RG_STRUP_THR_125_IRQ_STATUS_ADDR,
	 MT6328_PMIC_RG_STRUP_THR_125_IRQ_STATUS_MASK,
	 MT6328_PMIC_RG_STRUP_THR_125_IRQ_STATUS_SHIFT},
	{PMIC_VSYS22_OC_H2L_EN, MT6328_PMIC_VSYS22_OC_H2L_EN_ADDR,
	 MT6328_PMIC_VSYS22_OC_H2L_EN_MASK, MT6328_PMIC_VSYS22_OC_H2L_EN_SHIFT},
	{PMIC_VCORE1_OC_H2L_EN, MT6328_PMIC_VCORE1_OC_H2L_EN_ADDR,
	 MT6328_PMIC_VCORE1_OC_H2L_EN_MASK, MT6328_PMIC_VCORE1_OC_H2L_EN_SHIFT},
	{PMIC_VLTE_OC_H2L_EN, MT6328_PMIC_VLTE_OC_H2L_EN_ADDR, MT6328_PMIC_VLTE_OC_H2L_EN_MASK,
	 MT6328_PMIC_VLTE_OC_H2L_EN_SHIFT},
	{PMIC_VPROC_OC_H2L_EN, MT6328_PMIC_VPROC_OC_H2L_EN_ADDR, MT6328_PMIC_VPROC_OC_H2L_EN_MASK,
	 MT6328_PMIC_VPROC_OC_H2L_EN_SHIFT},
	{PMIC_VSYS22_OC_ENB, MT6328_PMIC_VSYS22_OC_ENB_ADDR, MT6328_PMIC_VSYS22_OC_ENB_MASK,
	 MT6328_PMIC_VSYS22_OC_ENB_SHIFT},
	{PMIC_VCORE1_OC_ENB, MT6328_PMIC_VCORE1_OC_ENB_ADDR, MT6328_PMIC_VCORE1_OC_ENB_MASK,
	 MT6328_PMIC_VCORE1_OC_ENB_SHIFT},
	{PMIC_VLTE_OC_ENB, MT6328_PMIC_VLTE_OC_ENB_ADDR, MT6328_PMIC_VLTE_OC_ENB_MASK,
	 MT6328_PMIC_VLTE_OC_ENB_SHIFT},
	{PMIC_VPROC_OC_ENB, MT6328_PMIC_VPROC_OC_ENB_ADDR, MT6328_PMIC_VPROC_OC_ENB_MASK,
	 MT6328_PMIC_VPROC_OC_ENB_SHIFT},
	{PMIC_VSYS22_OC_DEB_BYPASS, MT6328_PMIC_VSYS22_OC_DEB_BYPASS_ADDR,
	 MT6328_PMIC_VSYS22_OC_DEB_BYPASS_MASK, MT6328_PMIC_VSYS22_OC_DEB_BYPASS_SHIFT},
	{PMIC_VCORE1_OC_DEB_BYPASS, MT6328_PMIC_VCORE1_OC_DEB_BYPASS_ADDR,
	 MT6328_PMIC_VCORE1_OC_DEB_BYPASS_MASK, MT6328_PMIC_VCORE1_OC_DEB_BYPASS_SHIFT},
	{PMIC_VLTE_OC_DEB_BYPASS, MT6328_PMIC_VLTE_OC_DEB_BYPASS_ADDR,
	 MT6328_PMIC_VLTE_OC_DEB_BYPASS_MASK, MT6328_PMIC_VLTE_OC_DEB_BYPASS_SHIFT},
	{PMIC_VPROC_OC_DEB_BYPASS, MT6328_PMIC_VPROC_OC_DEB_BYPASS_ADDR,
	 MT6328_PMIC_VPROC_OC_DEB_BYPASS_MASK, MT6328_PMIC_VPROC_OC_DEB_BYPASS_SHIFT},
	{PMIC_VPROC_PG_DEB_BYPASS, MT6328_PMIC_VPROC_PG_DEB_BYPASS_ADDR,
	 MT6328_PMIC_VPROC_PG_DEB_BYPASS_MASK, MT6328_PMIC_VPROC_PG_DEB_BYPASS_SHIFT},
	{PMIC_VAUX18_PG_DEB_BYPASS, MT6328_PMIC_VAUX18_PG_DEB_BYPASS_ADDR,
	 MT6328_PMIC_VAUX18_PG_DEB_BYPASS_MASK, MT6328_PMIC_VAUX18_PG_DEB_BYPASS_SHIFT},
	{PMIC_VCORE1_PG_DEB_BYPASS, MT6328_PMIC_VCORE1_PG_DEB_BYPASS_ADDR,
	 MT6328_PMIC_VCORE1_PG_DEB_BYPASS_MASK, MT6328_PMIC_VCORE1_PG_DEB_BYPASS_SHIFT},
	{PMIC_VSYS22_PG_DEB_BYPASS, MT6328_PMIC_VSYS22_PG_DEB_BYPASS_ADDR,
	 MT6328_PMIC_VSYS22_PG_DEB_BYPASS_MASK, MT6328_PMIC_VSYS22_PG_DEB_BYPASS_SHIFT},
	{PMIC_VLTE_PG_DEB_BYPASS, MT6328_PMIC_VLTE_PG_DEB_BYPASS_ADDR,
	 MT6328_PMIC_VLTE_PG_DEB_BYPASS_MASK, MT6328_PMIC_VLTE_PG_DEB_BYPASS_SHIFT},
	{PMIC_VIO18_PG_DEB_BYPASS, MT6328_PMIC_VIO18_PG_DEB_BYPASS_ADDR,
	 MT6328_PMIC_VIO18_PG_DEB_BYPASS_MASK, MT6328_PMIC_VIO18_PG_DEB_BYPASS_SHIFT},
	{PMIC_VAUD28_PG_DEB_BYPASS, MT6328_PMIC_VAUD28_PG_DEB_BYPASS_ADDR,
	 MT6328_PMIC_VAUD28_PG_DEB_BYPASS_MASK, MT6328_PMIC_VAUD28_PG_DEB_BYPASS_SHIFT},
	{PMIC_VTCXO_PG_DEB_BYPASS, MT6328_PMIC_VTCXO_PG_DEB_BYPASS_ADDR,
	 MT6328_PMIC_VTCXO_PG_DEB_BYPASS_MASK, MT6328_PMIC_VTCXO_PG_DEB_BYPASS_SHIFT},
	{PMIC_VUSB_PG_DEB_BYPASS, MT6328_PMIC_VUSB_PG_DEB_BYPASS_ADDR,
	 MT6328_PMIC_VUSB_PG_DEB_BYPASS_MASK, MT6328_PMIC_VUSB_PG_DEB_BYPASS_SHIFT},
	{PMIC_VSRAM_PG_DEB_BYPASS, MT6328_PMIC_VSRAM_PG_DEB_BYPASS_ADDR,
	 MT6328_PMIC_VSRAM_PG_DEB_BYPASS_MASK, MT6328_PMIC_VSRAM_PG_DEB_BYPASS_SHIFT},
	{PMIC_VIO28_PG_DEB_BYPASS, MT6328_PMIC_VIO28_PG_DEB_BYPASS_ADDR,
	 MT6328_PMIC_VIO28_PG_DEB_BYPASS_MASK, MT6328_PMIC_VIO28_PG_DEB_BYPASS_SHIFT},
	{PMIC_VM_PG_DEB_BYPASS, MT6328_PMIC_VM_PG_DEB_BYPASS_ADDR,
	 MT6328_PMIC_VM_PG_DEB_BYPASS_MASK, MT6328_PMIC_VM_PG_DEB_BYPASS_SHIFT},
	{PMIC_PMU_THERMAL_DEB, MT6328_PMIC_PMU_THERMAL_DEB_ADDR, MT6328_PMIC_PMU_THERMAL_DEB_MASK,
	 MT6328_PMIC_PMU_THERMAL_DEB_SHIFT},
	{PMIC_STRUP_THERMAL_DEB_SEL, MT6328_PMIC_STRUP_THERMAL_DEB_SEL_ADDR,
	 MT6328_PMIC_STRUP_THERMAL_DEB_SEL_MASK, MT6328_PMIC_STRUP_THERMAL_DEB_SEL_SHIFT},
	{PMIC_STRUP_THER_DEB_RMAX, MT6328_PMIC_STRUP_THER_DEB_RMAX_ADDR,
	 MT6328_PMIC_STRUP_THER_DEB_RMAX_MASK, MT6328_PMIC_STRUP_THER_DEB_RMAX_SHIFT},
	{PMIC_STRUP_THER_DEB_FMAX, MT6328_PMIC_STRUP_THER_DEB_FMAX_ADDR,
	 MT6328_PMIC_STRUP_THER_DEB_FMAX_MASK, MT6328_PMIC_STRUP_THER_DEB_FMAX_SHIFT},
	{PMIC_RG_STRUP_ENVTEM, MT6328_PMIC_RG_STRUP_ENVTEM_ADDR, MT6328_PMIC_RG_STRUP_ENVTEM_MASK,
	 MT6328_PMIC_RG_STRUP_ENVTEM_SHIFT},
	{PMIC_STRUP_ENVTEM_CTRL, MT6328_PMIC_STRUP_ENVTEM_CTRL_ADDR,
	 MT6328_PMIC_STRUP_ENVTEM_CTRL_MASK, MT6328_PMIC_STRUP_ENVTEM_CTRL_SHIFT},
	{PMIC_RG_RST_DRVSEL, MT6328_PMIC_RG_RST_DRVSEL_ADDR, MT6328_PMIC_RG_RST_DRVSEL_MASK,
	 MT6328_PMIC_RG_RST_DRVSEL_SHIFT},
	{PMIC_HWCID, MT6328_PMIC_HWCID_ADDR, MT6328_PMIC_HWCID_MASK, MT6328_PMIC_HWCID_SHIFT},
	{PMIC_SWCID, MT6328_PMIC_SWCID_ADDR, MT6328_PMIC_SWCID_MASK, MT6328_PMIC_SWCID_SHIFT},
	{PMIC_RG_SRCLKEN_IN0_EN, MT6328_PMIC_RG_SRCLKEN_IN0_EN_ADDR,
	 MT6328_PMIC_RG_SRCLKEN_IN0_EN_MASK, MT6328_PMIC_RG_SRCLKEN_IN0_EN_SHIFT},
	{PMIC_RG_SRCLKEN_IN1_EN, MT6328_PMIC_RG_SRCLKEN_IN1_EN_ADDR,
	 MT6328_PMIC_RG_SRCLKEN_IN1_EN_MASK, MT6328_PMIC_RG_SRCLKEN_IN1_EN_SHIFT},
	{PMIC_RG_OSC_SEL, MT6328_PMIC_RG_OSC_SEL_ADDR, MT6328_PMIC_RG_OSC_SEL_MASK,
	 MT6328_PMIC_RG_OSC_SEL_SHIFT},
	{PMIC_RG_SRCLKEN_IN0_HW_MODE, MT6328_PMIC_RG_SRCLKEN_IN0_HW_MODE_ADDR,
	 MT6328_PMIC_RG_SRCLKEN_IN0_HW_MODE_MASK, MT6328_PMIC_RG_SRCLKEN_IN0_HW_MODE_SHIFT},
	{PMIC_RG_SRCLKEN_IN1_HW_MODE, MT6328_PMIC_RG_SRCLKEN_IN1_HW_MODE_ADDR,
	 MT6328_PMIC_RG_SRCLKEN_IN1_HW_MODE_MASK, MT6328_PMIC_RG_SRCLKEN_IN1_HW_MODE_SHIFT},
	{PMIC_RG_OSC_SEL_HW_MODE, MT6328_PMIC_RG_OSC_SEL_HW_MODE_ADDR,
	 MT6328_PMIC_RG_OSC_SEL_HW_MODE_MASK, MT6328_PMIC_RG_OSC_SEL_HW_MODE_SHIFT},
	{PMIC_RG_SRCLKEN_IN_SYNC_EN, MT6328_PMIC_RG_SRCLKEN_IN_SYNC_EN_ADDR,
	 MT6328_PMIC_RG_SRCLKEN_IN_SYNC_EN_MASK, MT6328_PMIC_RG_SRCLKEN_IN_SYNC_EN_SHIFT},
	{PMIC_RG_OSC_EN_AUTO_OFF, MT6328_PMIC_RG_OSC_EN_AUTO_OFF_ADDR,
	 MT6328_PMIC_RG_OSC_EN_AUTO_OFF_MASK, MT6328_PMIC_RG_OSC_EN_AUTO_OFF_SHIFT},
	{PMIC_TEST_OUT, MT6328_PMIC_TEST_OUT_ADDR, MT6328_PMIC_TEST_OUT_MASK,
	 MT6328_PMIC_TEST_OUT_SHIFT},
	{PMIC_RG_MON_FLAG_SEL, MT6328_PMIC_RG_MON_FLAG_SEL_ADDR, MT6328_PMIC_RG_MON_FLAG_SEL_MASK,
	 MT6328_PMIC_RG_MON_FLAG_SEL_SHIFT},
	{PMIC_RG_MON_GRP_SEL, MT6328_PMIC_RG_MON_GRP_SEL_ADDR, MT6328_PMIC_RG_MON_GRP_SEL_MASK,
	 MT6328_PMIC_RG_MON_GRP_SEL_SHIFT},
	{PMIC_RG_NANDTREE_MODE, MT6328_PMIC_RG_NANDTREE_MODE_ADDR,
	 MT6328_PMIC_RG_NANDTREE_MODE_MASK, MT6328_PMIC_RG_NANDTREE_MODE_SHIFT},
	{PMIC_RG_TEST_AUXADC, MT6328_PMIC_RG_TEST_AUXADC_ADDR, MT6328_PMIC_RG_TEST_AUXADC_MASK,
	 MT6328_PMIC_RG_TEST_AUXADC_SHIFT},
	{PMIC_RG_EFUSE_MODE, MT6328_PMIC_RG_EFUSE_MODE_ADDR, MT6328_PMIC_RG_EFUSE_MODE_MASK,
	 MT6328_PMIC_RG_EFUSE_MODE_SHIFT},
	{PMIC_RG_TEST_STRUP, MT6328_PMIC_RG_TEST_STRUP_ADDR, MT6328_PMIC_RG_TEST_STRUP_MASK,
	 MT6328_PMIC_RG_TEST_STRUP_SHIFT},
	{PMIC_TESTMODE_SW, MT6328_PMIC_TESTMODE_SW_ADDR, MT6328_PMIC_TESTMODE_SW_MASK,
	 MT6328_PMIC_TESTMODE_SW_SHIFT},
	{PMIC_EN_STATUS_VPROC, MT6328_PMIC_EN_STATUS_VPROC_ADDR, MT6328_PMIC_EN_STATUS_VPROC_MASK,
	 MT6328_PMIC_EN_STATUS_VPROC_SHIFT},
	{PMIC_EN_STATUS_VLTE, MT6328_PMIC_EN_STATUS_VLTE_ADDR, MT6328_PMIC_EN_STATUS_VLTE_MASK,
	 MT6328_PMIC_EN_STATUS_VLTE_SHIFT},
	{PMIC_EN_STATUS_VCORE1, MT6328_PMIC_EN_STATUS_VCORE1_ADDR,
	 MT6328_PMIC_EN_STATUS_VCORE1_MASK, MT6328_PMIC_EN_STATUS_VCORE1_SHIFT},
	{PMIC_EN_STATUS_VSYS22, MT6328_PMIC_EN_STATUS_VSYS22_ADDR,
	 MT6328_PMIC_EN_STATUS_VSYS22_MASK, MT6328_PMIC_EN_STATUS_VSYS22_SHIFT},
	{PMIC_EN_STATUS_VPA, MT6328_PMIC_EN_STATUS_VPA_ADDR, MT6328_PMIC_EN_STATUS_VPA_MASK,
	 MT6328_PMIC_EN_STATUS_VPA_SHIFT},
	{PMIC_EN_STATUS_VRTC, MT6328_PMIC_EN_STATUS_VRTC_ADDR, MT6328_PMIC_EN_STATUS_VRTC_MASK,
	 MT6328_PMIC_EN_STATUS_VRTC_SHIFT},
	{PMIC_EN_STATUS_VTCXO_0, MT6328_PMIC_EN_STATUS_VTCXO_0_ADDR,
	 MT6328_PMIC_EN_STATUS_VTCXO_0_MASK, MT6328_PMIC_EN_STATUS_VTCXO_0_SHIFT},
	{PMIC_EN_STATUS_VTCXO_1, MT6328_PMIC_EN_STATUS_VTCXO_1_ADDR,
	 MT6328_PMIC_EN_STATUS_VTCXO_1_MASK, MT6328_PMIC_EN_STATUS_VTCXO_1_SHIFT},
	{PMIC_EN_STATUS_VAUD28, MT6328_PMIC_EN_STATUS_VAUD28_ADDR,
	 MT6328_PMIC_EN_STATUS_VAUD28_MASK, MT6328_PMIC_EN_STATUS_VAUD28_SHIFT},
	{PMIC_EN_STATUS_VAUX18, MT6328_PMIC_EN_STATUS_VAUX18_ADDR,
	 MT6328_PMIC_EN_STATUS_VAUX18_MASK, MT6328_PMIC_EN_STATUS_VAUX18_SHIFT},
	{PMIC_EN_STATUS_VCAMA, MT6328_PMIC_EN_STATUS_VCAMA_ADDR, MT6328_PMIC_EN_STATUS_VCAMA_MASK,
	 MT6328_PMIC_EN_STATUS_VCAMA_SHIFT},
	{PMIC_EN_STATUS_VIO28, MT6328_PMIC_EN_STATUS_VIO28_ADDR, MT6328_PMIC_EN_STATUS_VIO28_MASK,
	 MT6328_PMIC_EN_STATUS_VIO28_SHIFT},
	{PMIC_EN_STATUS_VCAM_AF, MT6328_PMIC_EN_STATUS_VCAM_AF_ADDR,
	 MT6328_PMIC_EN_STATUS_VCAM_AF_MASK, MT6328_PMIC_EN_STATUS_VCAM_AF_SHIFT},
	{PMIC_EN_STATUS_VMC, MT6328_PMIC_EN_STATUS_VMC_ADDR, MT6328_PMIC_EN_STATUS_VMC_MASK,
	 MT6328_PMIC_EN_STATUS_VMC_SHIFT},
	{PMIC_EN_STATUS_VMCH, MT6328_PMIC_EN_STATUS_VMCH_ADDR, MT6328_PMIC_EN_STATUS_VMCH_MASK,
	 MT6328_PMIC_EN_STATUS_VMCH_SHIFT},
	{PMIC_EN_STATUS_VEMC33, MT6328_PMIC_EN_STATUS_VEMC33_ADDR,
	 MT6328_PMIC_EN_STATUS_VEMC33_MASK, MT6328_PMIC_EN_STATUS_VEMC33_SHIFT},
	{PMIC_EN_STATUS_VGP1, MT6328_PMIC_EN_STATUS_VGP1_ADDR, MT6328_PMIC_EN_STATUS_VGP1_MASK,
	 MT6328_PMIC_EN_STATUS_VGP1_SHIFT},
	{PMIC_EN_STATUS_VEFUSE, MT6328_PMIC_EN_STATUS_VEFUSE_ADDR,
	 MT6328_PMIC_EN_STATUS_VEFUSE_MASK, MT6328_PMIC_EN_STATUS_VEFUSE_SHIFT},
	{PMIC_EN_STATUS_VSIM1, MT6328_PMIC_EN_STATUS_VSIM1_ADDR, MT6328_PMIC_EN_STATUS_VSIM1_MASK,
	 MT6328_PMIC_EN_STATUS_VSIM1_SHIFT},
	{PMIC_EN_STATUS_VSIM2, MT6328_PMIC_EN_STATUS_VSIM2_ADDR, MT6328_PMIC_EN_STATUS_VSIM2_MASK,
	 MT6328_PMIC_EN_STATUS_VSIM2_SHIFT},
	{PMIC_EN_STATUS_VCN28, MT6328_PMIC_EN_STATUS_VCN28_ADDR, MT6328_PMIC_EN_STATUS_VCN28_MASK,
	 MT6328_PMIC_EN_STATUS_VCN28_SHIFT},
	{PMIC_EN_STATUS_VRF18_0, MT6328_PMIC_EN_STATUS_VRF18_0_ADDR,
	 MT6328_PMIC_EN_STATUS_VRF18_0_MASK, MT6328_PMIC_EN_STATUS_VRF18_0_SHIFT},
	{PMIC_EN_STATUS_VIBR, MT6328_PMIC_EN_STATUS_VIBR_ADDR, MT6328_PMIC_EN_STATUS_VIBR_MASK,
	 MT6328_PMIC_EN_STATUS_VIBR_SHIFT},
	{PMIC_EN_STATUS_VCAMD, MT6328_PMIC_EN_STATUS_VCAMD_ADDR, MT6328_PMIC_EN_STATUS_VCAMD_MASK,
	 MT6328_PMIC_EN_STATUS_VCAMD_SHIFT},
	{PMIC_EN_STATUS_VUSB33, MT6328_PMIC_EN_STATUS_VUSB33_ADDR,
	 MT6328_PMIC_EN_STATUS_VUSB33_MASK, MT6328_PMIC_EN_STATUS_VUSB33_SHIFT},
	{PMIC_EN_STATUS_VCAM_IO, MT6328_PMIC_EN_STATUS_VCAM_IO_ADDR,
	 MT6328_PMIC_EN_STATUS_VCAM_IO_MASK, MT6328_PMIC_EN_STATUS_VCAM_IO_SHIFT},
	{PMIC_EN_STATUS_VSRAM, MT6328_PMIC_EN_STATUS_VSRAM_ADDR, MT6328_PMIC_EN_STATUS_VSRAM_MASK,
	 MT6328_PMIC_EN_STATUS_VSRAM_SHIFT},
	{PMIC_EN_STATUS_VIO18, MT6328_PMIC_EN_STATUS_VIO18_ADDR, MT6328_PMIC_EN_STATUS_VIO18_MASK,
	 MT6328_PMIC_EN_STATUS_VIO18_SHIFT},
	{PMIC_EN_STATUS_VM, MT6328_PMIC_EN_STATUS_VM_ADDR, MT6328_PMIC_EN_STATUS_VM_MASK,
	 MT6328_PMIC_EN_STATUS_VM_SHIFT},
	{PMIC_EN_STATUS_VCN33, MT6328_PMIC_EN_STATUS_VCN33_ADDR, MT6328_PMIC_EN_STATUS_VCN33_MASK,
	 MT6328_PMIC_EN_STATUS_VCN33_SHIFT},
	{PMIC_EN_STATUS_VCN_1V8, MT6328_PMIC_EN_STATUS_VCN_1V8_ADDR,
	 MT6328_PMIC_EN_STATUS_VCN_1V8_MASK, MT6328_PMIC_EN_STATUS_VCN_1V8_SHIFT},
	{PMIC_EN_STATUS_VRF18_1, MT6328_PMIC_EN_STATUS_VRF18_1_ADDR,
	 MT6328_PMIC_EN_STATUS_VRF18_1_MASK, MT6328_PMIC_EN_STATUS_VRF18_1_SHIFT},
	{PMIC_OC_STATUS_VPROC, MT6328_PMIC_OC_STATUS_VPROC_ADDR, MT6328_PMIC_OC_STATUS_VPROC_MASK,
	 MT6328_PMIC_OC_STATUS_VPROC_SHIFT},
	{PMIC_OC_STATUS_VLTE, MT6328_PMIC_OC_STATUS_VLTE_ADDR, MT6328_PMIC_OC_STATUS_VLTE_MASK,
	 MT6328_PMIC_OC_STATUS_VLTE_SHIFT},
	{PMIC_OC_STATUS_VCORE1, MT6328_PMIC_OC_STATUS_VCORE1_ADDR,
	 MT6328_PMIC_OC_STATUS_VCORE1_MASK, MT6328_PMIC_OC_STATUS_VCORE1_SHIFT},
	{PMIC_OC_STATUS_VSYS22, MT6328_PMIC_OC_STATUS_VSYS22_ADDR,
	 MT6328_PMIC_OC_STATUS_VSYS22_MASK, MT6328_PMIC_OC_STATUS_VSYS22_SHIFT},
	{PMIC_OC_STATUS_VPA, MT6328_PMIC_OC_STATUS_VPA_ADDR, MT6328_PMIC_OC_STATUS_VPA_MASK,
	 MT6328_PMIC_OC_STATUS_VPA_SHIFT},
	{PMIC_OC_STATUS_VTCXO_0, MT6328_PMIC_OC_STATUS_VTCXO_0_ADDR,
	 MT6328_PMIC_OC_STATUS_VTCXO_0_MASK, MT6328_PMIC_OC_STATUS_VTCXO_0_SHIFT},
	{PMIC_OC_STATUS_VTCXO_1, MT6328_PMIC_OC_STATUS_VTCXO_1_ADDR,
	 MT6328_PMIC_OC_STATUS_VTCXO_1_MASK, MT6328_PMIC_OC_STATUS_VTCXO_1_SHIFT},
	{PMIC_OC_STATUS_VAUD28, MT6328_PMIC_OC_STATUS_VAUD28_ADDR,
	 MT6328_PMIC_OC_STATUS_VAUD28_MASK, MT6328_PMIC_OC_STATUS_VAUD28_SHIFT},
	{PMIC_OC_STATUS_VAUX18, MT6328_PMIC_OC_STATUS_VAUX18_ADDR,
	 MT6328_PMIC_OC_STATUS_VAUX18_MASK, MT6328_PMIC_OC_STATUS_VAUX18_SHIFT},
	{PMIC_OC_STATUS_VCAMA, MT6328_PMIC_OC_STATUS_VCAMA_ADDR, MT6328_PMIC_OC_STATUS_VCAMA_MASK,
	 MT6328_PMIC_OC_STATUS_VCAMA_SHIFT},
	{PMIC_OC_STATUS_VIO28, MT6328_PMIC_OC_STATUS_VIO28_ADDR, MT6328_PMIC_OC_STATUS_VIO28_MASK,
	 MT6328_PMIC_OC_STATUS_VIO28_SHIFT},
	{PMIC_OC_STATUS_VCAM_AF, MT6328_PMIC_OC_STATUS_VCAM_AF_ADDR,
	 MT6328_PMIC_OC_STATUS_VCAM_AF_MASK, MT6328_PMIC_OC_STATUS_VCAM_AF_SHIFT},
	{PMIC_OC_STATUS_VMC, MT6328_PMIC_OC_STATUS_VMC_ADDR, MT6328_PMIC_OC_STATUS_VMC_MASK,
	 MT6328_PMIC_OC_STATUS_VMC_SHIFT},
	{PMIC_OC_STATUS_VMCH, MT6328_PMIC_OC_STATUS_VMCH_ADDR, MT6328_PMIC_OC_STATUS_VMCH_MASK,
	 MT6328_PMIC_OC_STATUS_VMCH_SHIFT},
	{PMIC_OC_STATUS_VEMC33, MT6328_PMIC_OC_STATUS_VEMC33_ADDR,
	 MT6328_PMIC_OC_STATUS_VEMC33_MASK, MT6328_PMIC_OC_STATUS_VEMC33_SHIFT},
	{PMIC_OC_STATUS_VGP1, MT6328_PMIC_OC_STATUS_VGP1_ADDR, MT6328_PMIC_OC_STATUS_VGP1_MASK,
	 MT6328_PMIC_OC_STATUS_VGP1_SHIFT},
	{PMIC_OC_STATUS_VEFUSE, MT6328_PMIC_OC_STATUS_VEFUSE_ADDR,
	 MT6328_PMIC_OC_STATUS_VEFUSE_MASK, MT6328_PMIC_OC_STATUS_VEFUSE_SHIFT},
	{PMIC_OC_STATUS_VSIM1, MT6328_PMIC_OC_STATUS_VSIM1_ADDR, MT6328_PMIC_OC_STATUS_VSIM1_MASK,
	 MT6328_PMIC_OC_STATUS_VSIM1_SHIFT},
	{PMIC_OC_STATUS_VSIM2, MT6328_PMIC_OC_STATUS_VSIM2_ADDR, MT6328_PMIC_OC_STATUS_VSIM2_MASK,
	 MT6328_PMIC_OC_STATUS_VSIM2_SHIFT},
	{PMIC_OC_STATUS_VCN28, MT6328_PMIC_OC_STATUS_VCN28_ADDR, MT6328_PMIC_OC_STATUS_VCN28_MASK,
	 MT6328_PMIC_OC_STATUS_VCN28_SHIFT},
	{PMIC_OC_STATUS_VRF18_0, MT6328_PMIC_OC_STATUS_VRF18_0_ADDR,
	 MT6328_PMIC_OC_STATUS_VRF18_0_MASK, MT6328_PMIC_OC_STATUS_VRF18_0_SHIFT},
	{PMIC_OC_STATUS_VIBR, MT6328_PMIC_OC_STATUS_VIBR_ADDR, MT6328_PMIC_OC_STATUS_VIBR_MASK,
	 MT6328_PMIC_OC_STATUS_VIBR_SHIFT},
	{PMIC_OC_STATUS_VCAMD, MT6328_PMIC_OC_STATUS_VCAMD_ADDR, MT6328_PMIC_OC_STATUS_VCAMD_MASK,
	 MT6328_PMIC_OC_STATUS_VCAMD_SHIFT},
	{PMIC_OC_STATUS_VUSB33, MT6328_PMIC_OC_STATUS_VUSB33_ADDR,
	 MT6328_PMIC_OC_STATUS_VUSB33_MASK, MT6328_PMIC_OC_STATUS_VUSB33_SHIFT},
	{PMIC_OC_STATUS_VCAM_IO, MT6328_PMIC_OC_STATUS_VCAM_IO_ADDR,
	 MT6328_PMIC_OC_STATUS_VCAM_IO_MASK, MT6328_PMIC_OC_STATUS_VCAM_IO_SHIFT},
	{PMIC_OC_STATUS_VSRAM, MT6328_PMIC_OC_STATUS_VSRAM_ADDR, MT6328_PMIC_OC_STATUS_VSRAM_MASK,
	 MT6328_PMIC_OC_STATUS_VSRAM_SHIFT},
	{PMIC_OC_STATUS_VIO18, MT6328_PMIC_OC_STATUS_VIO18_ADDR, MT6328_PMIC_OC_STATUS_VIO18_MASK,
	 MT6328_PMIC_OC_STATUS_VIO18_SHIFT},
	{PMIC_OC_STATUS_VM, MT6328_PMIC_OC_STATUS_VM_ADDR, MT6328_PMIC_OC_STATUS_VM_MASK,
	 MT6328_PMIC_OC_STATUS_VM_SHIFT},
	{PMIC_OC_STATUS_VCN33, MT6328_PMIC_OC_STATUS_VCN33_ADDR, MT6328_PMIC_OC_STATUS_VCN33_MASK,
	 MT6328_PMIC_OC_STATUS_VCN33_SHIFT},
	{PMIC_OC_STATUS_VCN_1V8, MT6328_PMIC_OC_STATUS_VCN_1V8_ADDR,
	 MT6328_PMIC_OC_STATUS_VCN_1V8_MASK, MT6328_PMIC_OC_STATUS_VCN_1V8_SHIFT},
	{PMIC_OC_STATUS_VRF18_1, MT6328_PMIC_OC_STATUS_VRF18_1_ADDR,
	 MT6328_PMIC_OC_STATUS_VRF18_1_MASK, MT6328_PMIC_OC_STATUS_VRF18_1_SHIFT},
	{PMIC_VAUX18_PG_DEB, MT6328_PMIC_VAUX18_PG_DEB_ADDR, MT6328_PMIC_VAUX18_PG_DEB_MASK,
	 MT6328_PMIC_VAUX18_PG_DEB_SHIFT},
	{PMIC_VCORE1_PG_DEB, MT6328_PMIC_VCORE1_PG_DEB_ADDR, MT6328_PMIC_VCORE1_PG_DEB_MASK,
	 MT6328_PMIC_VCORE1_PG_DEB_SHIFT},
	{PMIC_VLTE_PG_DEB, MT6328_PMIC_VLTE_PG_DEB_ADDR, MT6328_PMIC_VLTE_PG_DEB_MASK,
	 MT6328_PMIC_VLTE_PG_DEB_SHIFT},
	{PMIC_VSYS22_PG_DEB, MT6328_PMIC_VSYS22_PG_DEB_ADDR, MT6328_PMIC_VSYS22_PG_DEB_MASK,
	 MT6328_PMIC_VSYS22_PG_DEB_SHIFT},
	{PMIC_VIO18_PG_DEB, MT6328_PMIC_VIO18_PG_DEB_ADDR, MT6328_PMIC_VIO18_PG_DEB_MASK,
	 MT6328_PMIC_VIO18_PG_DEB_SHIFT},
	{PMIC_VIO28_PG_DEB, MT6328_PMIC_VIO28_PG_DEB_ADDR, MT6328_PMIC_VIO28_PG_DEB_MASK,
	 MT6328_PMIC_VIO28_PG_DEB_SHIFT},
	{PMIC_VPROC_PG_DEB, MT6328_PMIC_VPROC_PG_DEB_ADDR, MT6328_PMIC_VPROC_PG_DEB_MASK,
	 MT6328_PMIC_VPROC_PG_DEB_SHIFT},
	{PMIC_VSRAM_PG_DEB, MT6328_PMIC_VSRAM_PG_DEB_ADDR, MT6328_PMIC_VSRAM_PG_DEB_MASK,
	 MT6328_PMIC_VSRAM_PG_DEB_SHIFT},
	{PMIC_VM_PG_DEB, MT6328_PMIC_VM_PG_DEB_ADDR, MT6328_PMIC_VM_PG_DEB_MASK,
	 MT6328_PMIC_VM_PG_DEB_SHIFT},
	{PMIC_VAUD28_PG_DEB, MT6328_PMIC_VAUD28_PG_DEB_ADDR, MT6328_PMIC_VAUD28_PG_DEB_MASK,
	 MT6328_PMIC_VAUD28_PG_DEB_SHIFT},
	{PMIC_VUSB_PG_DEB, MT6328_PMIC_VUSB_PG_DEB_ADDR, MT6328_PMIC_VUSB_PG_DEB_MASK,
	 MT6328_PMIC_VUSB_PG_DEB_SHIFT},
	{PMIC_VTCXO_PG_DEB, MT6328_PMIC_VTCXO_PG_DEB_ADDR, MT6328_PMIC_VTCXO_PG_DEB_MASK,
	 MT6328_PMIC_VTCXO_PG_DEB_SHIFT},
	{PMIC_STRUP_VAUX18_PG_STATUS, MT6328_PMIC_STRUP_VAUX18_PG_STATUS_ADDR,
	 MT6328_PMIC_STRUP_VAUX18_PG_STATUS_MASK, MT6328_PMIC_STRUP_VAUX18_PG_STATUS_SHIFT},
	{PMIC_STRUP_VCORE1_PG_STATUS, MT6328_PMIC_STRUP_VCORE1_PG_STATUS_ADDR,
	 MT6328_PMIC_STRUP_VCORE1_PG_STATUS_MASK, MT6328_PMIC_STRUP_VCORE1_PG_STATUS_SHIFT},
	{PMIC_STRUP_VLTE_PG_STATUS, MT6328_PMIC_STRUP_VLTE_PG_STATUS_ADDR,
	 MT6328_PMIC_STRUP_VLTE_PG_STATUS_MASK, MT6328_PMIC_STRUP_VLTE_PG_STATUS_SHIFT},
	{PMIC_STRUP_VSYS22_PG_STATUS, MT6328_PMIC_STRUP_VSYS22_PG_STATUS_ADDR,
	 MT6328_PMIC_STRUP_VSYS22_PG_STATUS_MASK, MT6328_PMIC_STRUP_VSYS22_PG_STATUS_SHIFT},
	{PMIC_STRUP_VIO18_PG_STATUS, MT6328_PMIC_STRUP_VIO18_PG_STATUS_ADDR,
	 MT6328_PMIC_STRUP_VIO18_PG_STATUS_MASK, MT6328_PMIC_STRUP_VIO18_PG_STATUS_SHIFT},
	{PMIC_STRUP_VIO28_PG_STATUS, MT6328_PMIC_STRUP_VIO28_PG_STATUS_ADDR,
	 MT6328_PMIC_STRUP_VIO28_PG_STATUS_MASK, MT6328_PMIC_STRUP_VIO28_PG_STATUS_SHIFT},
	{PMIC_STRUP_VPROC_PG_STATUS, MT6328_PMIC_STRUP_VPROC_PG_STATUS_ADDR,
	 MT6328_PMIC_STRUP_VPROC_PG_STATUS_MASK, MT6328_PMIC_STRUP_VPROC_PG_STATUS_SHIFT},
	{PMIC_STRUP_VSRAM_PG_STATUS, MT6328_PMIC_STRUP_VSRAM_PG_STATUS_ADDR,
	 MT6328_PMIC_STRUP_VSRAM_PG_STATUS_MASK, MT6328_PMIC_STRUP_VSRAM_PG_STATUS_SHIFT},
	{PMIC_STRUP_VM_PG_STATUS, MT6328_PMIC_STRUP_VM_PG_STATUS_ADDR,
	 MT6328_PMIC_STRUP_VM_PG_STATUS_MASK, MT6328_PMIC_STRUP_VM_PG_STATUS_SHIFT},
	{PMIC_STRUP_VAUD28_PG_STATUS, MT6328_PMIC_STRUP_VAUD28_PG_STATUS_ADDR,
	 MT6328_PMIC_STRUP_VAUD28_PG_STATUS_MASK, MT6328_PMIC_STRUP_VAUD28_PG_STATUS_SHIFT},
	{PMIC_STRUP_VUSB_PG_STATUS, MT6328_PMIC_STRUP_VUSB_PG_STATUS_ADDR,
	 MT6328_PMIC_STRUP_VUSB_PG_STATUS_MASK, MT6328_PMIC_STRUP_VUSB_PG_STATUS_SHIFT},
	{PMIC_STRUP_VTCXO_PG_STATUS, MT6328_PMIC_STRUP_VTCXO_PG_STATUS_ADDR,
	 MT6328_PMIC_STRUP_VTCXO_PG_STATUS_MASK, MT6328_PMIC_STRUP_VTCXO_PG_STATUS_SHIFT},
	{PMIC_THERMAL_BACK110, MT6328_PMIC_THERMAL_BACK110_ADDR, MT6328_PMIC_THERMAL_BACK110_MASK,
	 MT6328_PMIC_THERMAL_BACK110_SHIFT},
	{PMIC_THERMAL_OVER110, MT6328_PMIC_THERMAL_OVER110_ADDR, MT6328_PMIC_THERMAL_OVER110_MASK,
	 MT6328_PMIC_THERMAL_OVER110_SHIFT},
	{PMIC_THERMAL_OVER125, MT6328_PMIC_THERMAL_OVER125_ADDR, MT6328_PMIC_THERMAL_OVER125_MASK,
	 MT6328_PMIC_THERMAL_OVER125_SHIFT},
	{PMIC_STRUP_THERMAL_STATUS, MT6328_PMIC_STRUP_THERMAL_STATUS_ADDR,
	 MT6328_PMIC_STRUP_THERMAL_STATUS_MASK, MT6328_PMIC_STRUP_THERMAL_STATUS_SHIFT},
	{PMIC_PMU_TEST_MODE_SCAN, MT6328_PMIC_PMU_TEST_MODE_SCAN_ADDR,
	 MT6328_PMIC_PMU_TEST_MODE_SCAN_MASK, MT6328_PMIC_PMU_TEST_MODE_SCAN_SHIFT},
	{PMIC_PWRKEY_DEB, MT6328_PMIC_PWRKEY_DEB_ADDR, MT6328_PMIC_PWRKEY_DEB_MASK,
	 MT6328_PMIC_PWRKEY_DEB_SHIFT},
	{PMIC_HOMEKEY_DEB, MT6328_PMIC_HOMEKEY_DEB_ADDR, MT6328_PMIC_HOMEKEY_DEB_MASK,
	 MT6328_PMIC_HOMEKEY_DEB_SHIFT},
	{PMIC_RTC_XTAL_DET_DONE, MT6328_PMIC_RTC_XTAL_DET_DONE_ADDR,
	 MT6328_PMIC_RTC_XTAL_DET_DONE_MASK, MT6328_PMIC_RTC_XTAL_DET_DONE_SHIFT},
	{PMIC_XOSC32_ENB_DET, MT6328_PMIC_XOSC32_ENB_DET_ADDR, MT6328_PMIC_XOSC32_ENB_DET_MASK,
	 MT6328_PMIC_XOSC32_ENB_DET_SHIFT},
	{PMIC_RTC_XTAL_DET_RSV, MT6328_PMIC_RTC_XTAL_DET_RSV_ADDR,
	 MT6328_PMIC_RTC_XTAL_DET_RSV_MASK, MT6328_PMIC_RTC_XTAL_DET_RSV_SHIFT},
	{PMIC_RG_PMU_TDSEL, MT6328_PMIC_RG_PMU_TDSEL_ADDR, MT6328_PMIC_RG_PMU_TDSEL_MASK,
	 MT6328_PMIC_RG_PMU_TDSEL_SHIFT},
	{PMIC_RG_SPI_TDSEL, MT6328_PMIC_RG_SPI_TDSEL_ADDR, MT6328_PMIC_RG_SPI_TDSEL_MASK,
	 MT6328_PMIC_RG_SPI_TDSEL_SHIFT},
	{PMIC_RG_AUD_TDSEL, MT6328_PMIC_RG_AUD_TDSEL_ADDR, MT6328_PMIC_RG_AUD_TDSEL_MASK,
	 MT6328_PMIC_RG_AUD_TDSEL_SHIFT},
	{PMIC_RG_E32CAL_TDSEL, MT6328_PMIC_RG_E32CAL_TDSEL_ADDR, MT6328_PMIC_RG_E32CAL_TDSEL_MASK,
	 MT6328_PMIC_RG_E32CAL_TDSEL_SHIFT},
	{PMIC_RG_PMU_RDSEL, MT6328_PMIC_RG_PMU_RDSEL_ADDR, MT6328_PMIC_RG_PMU_RDSEL_MASK,
	 MT6328_PMIC_RG_PMU_RDSEL_SHIFT},
	{PMIC_RG_SPI_RDSEL, MT6328_PMIC_RG_SPI_RDSEL_ADDR, MT6328_PMIC_RG_SPI_RDSEL_MASK,
	 MT6328_PMIC_RG_SPI_RDSEL_SHIFT},
	{PMIC_RG_AUD_RDSEL, MT6328_PMIC_RG_AUD_RDSEL_ADDR, MT6328_PMIC_RG_AUD_RDSEL_MASK,
	 MT6328_PMIC_RG_AUD_RDSEL_SHIFT},
	{PMIC_RG_E32CAL_RDSEL, MT6328_PMIC_RG_E32CAL_RDSEL_ADDR, MT6328_PMIC_RG_E32CAL_RDSEL_MASK,
	 MT6328_PMIC_RG_E32CAL_RDSEL_SHIFT},
	{PMIC_RG_SMT_WDTRSTB_IN, MT6328_PMIC_RG_SMT_WDTRSTB_IN_ADDR,
	 MT6328_PMIC_RG_SMT_WDTRSTB_IN_MASK, MT6328_PMIC_RG_SMT_WDTRSTB_IN_SHIFT},
	{PMIC_RG_SMT_HOMEKEY, MT6328_PMIC_RG_SMT_HOMEKEY_ADDR, MT6328_PMIC_RG_SMT_HOMEKEY_MASK,
	 MT6328_PMIC_RG_SMT_HOMEKEY_SHIFT},
	{PMIC_RG_SMT_SRCLKEN_IN0, MT6328_PMIC_RG_SMT_SRCLKEN_IN0_ADDR,
	 MT6328_PMIC_RG_SMT_SRCLKEN_IN0_MASK, MT6328_PMIC_RG_SMT_SRCLKEN_IN0_SHIFT},
	{PMIC_RG_SMT_SRCLKEN_IN1, MT6328_PMIC_RG_SMT_SRCLKEN_IN1_ADDR,
	 MT6328_PMIC_RG_SMT_SRCLKEN_IN1_MASK, MT6328_PMIC_RG_SMT_SRCLKEN_IN1_SHIFT},
	{PMIC_RG_SMT_RTC_32K1V8_0, MT6328_PMIC_RG_SMT_RTC_32K1V8_0_ADDR,
	 MT6328_PMIC_RG_SMT_RTC_32K1V8_0_MASK, MT6328_PMIC_RG_SMT_RTC_32K1V8_0_SHIFT},
	{PMIC_RG_SMT_RTC_32K1V8_1, MT6328_PMIC_RG_SMT_RTC_32K1V8_1_ADDR,
	 MT6328_PMIC_RG_SMT_RTC_32K1V8_1_MASK, MT6328_PMIC_RG_SMT_RTC_32K1V8_1_SHIFT},
	{PMIC_RG_SMT_SPI_CLK, MT6328_PMIC_RG_SMT_SPI_CLK_ADDR, MT6328_PMIC_RG_SMT_SPI_CLK_MASK,
	 MT6328_PMIC_RG_SMT_SPI_CLK_SHIFT},
	{PMIC_RG_SMT_SPI_CSN, MT6328_PMIC_RG_SMT_SPI_CSN_ADDR, MT6328_PMIC_RG_SMT_SPI_CSN_MASK,
	 MT6328_PMIC_RG_SMT_SPI_CSN_SHIFT},
	{PMIC_RG_SMT_SPI_MOSI, MT6328_PMIC_RG_SMT_SPI_MOSI_ADDR, MT6328_PMIC_RG_SMT_SPI_MOSI_MASK,
	 MT6328_PMIC_RG_SMT_SPI_MOSI_SHIFT},
	{PMIC_RG_SMT_SPI_MISO, MT6328_PMIC_RG_SMT_SPI_MISO_ADDR, MT6328_PMIC_RG_SMT_SPI_MISO_MASK,
	 MT6328_PMIC_RG_SMT_SPI_MISO_SHIFT},
	{PMIC_RG_SMT_AUD_CLK, MT6328_PMIC_RG_SMT_AUD_CLK_ADDR, MT6328_PMIC_RG_SMT_AUD_CLK_MASK,
	 MT6328_PMIC_RG_SMT_AUD_CLK_SHIFT},
	{PMIC_RG_SMT_AUD_DAT_MOSI, MT6328_PMIC_RG_SMT_AUD_DAT_MOSI_ADDR,
	 MT6328_PMIC_RG_SMT_AUD_DAT_MOSI_MASK, MT6328_PMIC_RG_SMT_AUD_DAT_MOSI_SHIFT},
	{PMIC_RG_SMT_AUD_DAT_MISO, MT6328_PMIC_RG_SMT_AUD_DAT_MISO_ADDR,
	 MT6328_PMIC_RG_SMT_AUD_DAT_MISO_MASK, MT6328_PMIC_RG_SMT_AUD_DAT_MISO_SHIFT},
	{PMIC_RG_SMT_ENBB, MT6328_PMIC_RG_SMT_ENBB_ADDR, MT6328_PMIC_RG_SMT_ENBB_MASK,
	 MT6328_PMIC_RG_SMT_ENBB_SHIFT},
	{PMIC_RG_SMT_XOSC_EN, MT6328_PMIC_RG_SMT_XOSC_EN_ADDR, MT6328_PMIC_RG_SMT_XOSC_EN_MASK,
	 MT6328_PMIC_RG_SMT_XOSC_EN_SHIFT},
	{PMIC_RG_OCTL_SRCLKEN_IN0, MT6328_PMIC_RG_OCTL_SRCLKEN_IN0_ADDR,
	 MT6328_PMIC_RG_OCTL_SRCLKEN_IN0_MASK, MT6328_PMIC_RG_OCTL_SRCLKEN_IN0_SHIFT},
	{PMIC_RG_OCTL_SRCLKEN_IN1, MT6328_PMIC_RG_OCTL_SRCLKEN_IN1_ADDR,
	 MT6328_PMIC_RG_OCTL_SRCLKEN_IN1_MASK, MT6328_PMIC_RG_OCTL_SRCLKEN_IN1_SHIFT},
	{PMIC_RG_OCTL_RTC_32K1V8_0, MT6328_PMIC_RG_OCTL_RTC_32K1V8_0_ADDR,
	 MT6328_PMIC_RG_OCTL_RTC_32K1V8_0_MASK, MT6328_PMIC_RG_OCTL_RTC_32K1V8_0_SHIFT},
	{PMIC_RG_OCTL_RTC_32K1V8_1, MT6328_PMIC_RG_OCTL_RTC_32K1V8_1_ADDR,
	 MT6328_PMIC_RG_OCTL_RTC_32K1V8_1_MASK, MT6328_PMIC_RG_OCTL_RTC_32K1V8_1_SHIFT},
	{PMIC_RG_OCTL_SPI_CLK, MT6328_PMIC_RG_OCTL_SPI_CLK_ADDR, MT6328_PMIC_RG_OCTL_SPI_CLK_MASK,
	 MT6328_PMIC_RG_OCTL_SPI_CLK_SHIFT},
	{PMIC_RG_OCTL_SPI_CSN, MT6328_PMIC_RG_OCTL_SPI_CSN_ADDR, MT6328_PMIC_RG_OCTL_SPI_CSN_MASK,
	 MT6328_PMIC_RG_OCTL_SPI_CSN_SHIFT},
	{PMIC_RG_OCTL_SPI_MOSI, MT6328_PMIC_RG_OCTL_SPI_MOSI_ADDR,
	 MT6328_PMIC_RG_OCTL_SPI_MOSI_MASK, MT6328_PMIC_RG_OCTL_SPI_MOSI_SHIFT},
	{PMIC_RG_OCTL_SPI_MISO, MT6328_PMIC_RG_OCTL_SPI_MISO_ADDR,
	 MT6328_PMIC_RG_OCTL_SPI_MISO_MASK, MT6328_PMIC_RG_OCTL_SPI_MISO_SHIFT},
	{PMIC_RG_OCTL_AUD_DAT_MOSI, MT6328_PMIC_RG_OCTL_AUD_DAT_MOSI_ADDR,
	 MT6328_PMIC_RG_OCTL_AUD_DAT_MOSI_MASK, MT6328_PMIC_RG_OCTL_AUD_DAT_MOSI_SHIFT},
	{PMIC_RG_OCTL_AUD_DAT_MISO, MT6328_PMIC_RG_OCTL_AUD_DAT_MISO_ADDR,
	 MT6328_PMIC_RG_OCTL_AUD_DAT_MISO_MASK, MT6328_PMIC_RG_OCTL_AUD_DAT_MISO_SHIFT},
	{PMIC_RG_OCTL_AUD_CLK, MT6328_PMIC_RG_OCTL_AUD_CLK_ADDR, MT6328_PMIC_RG_OCTL_AUD_CLK_MASK,
	 MT6328_PMIC_RG_OCTL_AUD_CLK_SHIFT},
	{PMIC_RG_OCTL_HOMEKEY, MT6328_PMIC_RG_OCTL_HOMEKEY_ADDR, MT6328_PMIC_RG_OCTL_HOMEKEY_MASK,
	 MT6328_PMIC_RG_OCTL_HOMEKEY_SHIFT},
	{PMIC_RG_OCTL_ENBB, MT6328_PMIC_RG_OCTL_ENBB_ADDR, MT6328_PMIC_RG_OCTL_ENBB_MASK,
	 MT6328_PMIC_RG_OCTL_ENBB_SHIFT},
	{PMIC_RG_OCTL_XOSC_EN, MT6328_PMIC_RG_OCTL_XOSC_EN_ADDR, MT6328_PMIC_RG_OCTL_XOSC_EN_MASK,
	 MT6328_PMIC_RG_OCTL_XOSC_EN_SHIFT},
	{PMIC_TOP_STATUS, MT6328_PMIC_TOP_STATUS_ADDR, MT6328_PMIC_TOP_STATUS_MASK,
	 MT6328_PMIC_TOP_STATUS_SHIFT},
	{PMIC_TOP_STATUS_SET, MT6328_PMIC_TOP_STATUS_SET_ADDR, MT6328_PMIC_TOP_STATUS_SET_MASK,
	 MT6328_PMIC_TOP_STATUS_SET_SHIFT},
	{PMIC_TOP_STATUS_CLR, MT6328_PMIC_TOP_STATUS_CLR_ADDR, MT6328_PMIC_TOP_STATUS_CLR_MASK,
	 MT6328_PMIC_TOP_STATUS_CLR_SHIFT},
	{PMIC_RGS_VPROC_ENPWM_STATUS, MT6328_PMIC_RGS_VPROC_ENPWM_STATUS_ADDR,
	 MT6328_PMIC_RGS_VPROC_ENPWM_STATUS_MASK, MT6328_PMIC_RGS_VPROC_ENPWM_STATUS_SHIFT},
	{PMIC_RGS_VLTE_ENPWM_STATUS, MT6328_PMIC_RGS_VLTE_ENPWM_STATUS_ADDR,
	 MT6328_PMIC_RGS_VLTE_ENPWM_STATUS_MASK, MT6328_PMIC_RGS_VLTE_ENPWM_STATUS_SHIFT},
	{PMIC_RGS_VCORE1_ENPWM_STATUS, MT6328_PMIC_RGS_VCORE1_ENPWM_STATUS_ADDR,
	 MT6328_PMIC_RGS_VCORE1_ENPWM_STATUS_MASK, MT6328_PMIC_RGS_VCORE1_ENPWM_STATUS_SHIFT},
	{PMIC_RGS_VSYS22_ENPWM_STATUS, MT6328_PMIC_RGS_VSYS22_ENPWM_STATUS_ADDR,
	 MT6328_PMIC_RGS_VSYS22_ENPWM_STATUS_MASK, MT6328_PMIC_RGS_VSYS22_ENPWM_STATUS_SHIFT},
	{PMIC_RG_G_SMPS_PD_CK_PDN, MT6328_PMIC_RG_G_SMPS_PD_CK_PDN_ADDR,
	 MT6328_PMIC_RG_G_SMPS_PD_CK_PDN_MASK, MT6328_PMIC_RG_G_SMPS_PD_CK_PDN_SHIFT},
	{PMIC_RG_G_SMPS_AUD_CK_PDN, MT6328_PMIC_RG_G_SMPS_AUD_CK_PDN_ADDR,
	 MT6328_PMIC_RG_G_SMPS_AUD_CK_PDN_MASK, MT6328_PMIC_RG_G_SMPS_AUD_CK_PDN_SHIFT},
	{PMIC_RG_G_DRV_2M_CK_PDN, MT6328_PMIC_RG_G_DRV_2M_CK_PDN_ADDR,
	 MT6328_PMIC_RG_G_DRV_2M_CK_PDN_MASK, MT6328_PMIC_RG_G_DRV_2M_CK_PDN_SHIFT},
	{PMIC_RG_DRV_32K_CK_PDN, MT6328_PMIC_RG_DRV_32K_CK_PDN_ADDR,
	 MT6328_PMIC_RG_DRV_32K_CK_PDN_MASK, MT6328_PMIC_RG_DRV_32K_CK_PDN_SHIFT},
	{PMIC_RG_DRV_ISINK0_CK_PDN, MT6328_PMIC_RG_DRV_ISINK0_CK_PDN_ADDR,
	 MT6328_PMIC_RG_DRV_ISINK0_CK_PDN_MASK, MT6328_PMIC_RG_DRV_ISINK0_CK_PDN_SHIFT},
	{PMIC_RG_DRV_ISINK1_CK_PDN, MT6328_PMIC_RG_DRV_ISINK1_CK_PDN_ADDR,
	 MT6328_PMIC_RG_DRV_ISINK1_CK_PDN_MASK, MT6328_PMIC_RG_DRV_ISINK1_CK_PDN_SHIFT},
	{PMIC_RG_DRV_ISINK2_CK_PDN, MT6328_PMIC_RG_DRV_ISINK2_CK_PDN_ADDR,
	 MT6328_PMIC_RG_DRV_ISINK2_CK_PDN_MASK, MT6328_PMIC_RG_DRV_ISINK2_CK_PDN_SHIFT},
	{PMIC_RG_DRV_ISINK3_CK_PDN, MT6328_PMIC_RG_DRV_ISINK3_CK_PDN_ADDR,
	 MT6328_PMIC_RG_DRV_ISINK3_CK_PDN_MASK, MT6328_PMIC_RG_DRV_ISINK3_CK_PDN_SHIFT},
	{PMIC_RG_AUXADC_1M_CK_PDN, MT6328_PMIC_RG_AUXADC_1M_CK_PDN_ADDR,
	 MT6328_PMIC_RG_AUXADC_1M_CK_PDN_MASK, MT6328_PMIC_RG_AUXADC_1M_CK_PDN_SHIFT},
	{PMIC_RG_AUXADC_SMPS_CK_PDN, MT6328_PMIC_RG_AUXADC_SMPS_CK_PDN_ADDR,
	 MT6328_PMIC_RG_AUXADC_SMPS_CK_PDN_MASK, MT6328_PMIC_RG_AUXADC_SMPS_CK_PDN_SHIFT},
	{PMIC_RG_AUXADC_RNG_CK_PDN, MT6328_PMIC_RG_AUXADC_RNG_CK_PDN_ADDR,
	 MT6328_PMIC_RG_AUXADC_RNG_CK_PDN_MASK, MT6328_PMIC_RG_AUXADC_RNG_CK_PDN_SHIFT},
	{PMIC_RG_AUXADC_26M_CK_PDN, MT6328_PMIC_RG_AUXADC_26M_CK_PDN_ADDR,
	 MT6328_PMIC_RG_AUXADC_26M_CK_PDN_MASK, MT6328_PMIC_RG_AUXADC_26M_CK_PDN_SHIFT},
	{PMIC_RG_AUDNCP_CK_PDN, MT6328_PMIC_RG_AUDNCP_CK_PDN_ADDR,
	 MT6328_PMIC_RG_AUDNCP_CK_PDN_MASK, MT6328_PMIC_RG_AUDNCP_CK_PDN_SHIFT},
	{PMIC_RG_AUDIF_CK_PDN, MT6328_PMIC_RG_AUDIF_CK_PDN_ADDR, MT6328_PMIC_RG_AUDIF_CK_PDN_MASK,
	 MT6328_PMIC_RG_AUDIF_CK_PDN_SHIFT},
	{PMIC_RG_AUD_CK_PDN, MT6328_PMIC_RG_AUD_CK_PDN_ADDR, MT6328_PMIC_RG_AUD_CK_PDN_MASK,
	 MT6328_PMIC_RG_AUD_CK_PDN_SHIFT},
	{PMIC_RG_ZCD13M_CK_PDN, MT6328_PMIC_RG_ZCD13M_CK_PDN_ADDR,
	 MT6328_PMIC_RG_ZCD13M_CK_PDN_MASK, MT6328_PMIC_RG_ZCD13M_CK_PDN_SHIFT},
	{PMIC_TOP_CKPDN_CON0_SET, MT6328_PMIC_TOP_CKPDN_CON0_SET_ADDR,
	 MT6328_PMIC_TOP_CKPDN_CON0_SET_MASK, MT6328_PMIC_TOP_CKPDN_CON0_SET_SHIFT},
	{PMIC_TOP_CKPDN_CON0_CLR, MT6328_PMIC_TOP_CKPDN_CON0_CLR_ADDR,
	 MT6328_PMIC_TOP_CKPDN_CON0_CLR_MASK, MT6328_PMIC_TOP_CKPDN_CON0_CLR_SHIFT},
	{PMIC_RG_RTC_32K_CK_PDN, MT6328_PMIC_RG_RTC_32K_CK_PDN_ADDR,
	 MT6328_PMIC_RG_RTC_32K_CK_PDN_MASK, MT6328_PMIC_RG_RTC_32K_CK_PDN_SHIFT},
	{PMIC_RG_RTC_MCLK_PDN, MT6328_PMIC_RG_RTC_MCLK_PDN_ADDR, MT6328_PMIC_RG_RTC_MCLK_PDN_MASK,
	 MT6328_PMIC_RG_RTC_MCLK_PDN_SHIFT},
	{PMIC_RG_RTC_75K_CK_PDN, MT6328_PMIC_RG_RTC_75K_CK_PDN_ADDR,
	 MT6328_PMIC_RG_RTC_75K_CK_PDN_MASK, MT6328_PMIC_RG_RTC_75K_CK_PDN_SHIFT},
	{PMIC_RG_RTCDET_CK_PDN, MT6328_PMIC_RG_RTCDET_CK_PDN_ADDR,
	 MT6328_PMIC_RG_RTCDET_CK_PDN_MASK, MT6328_PMIC_RG_RTCDET_CK_PDN_SHIFT},
	{PMIC_RG_RTC32K_1V8_0_O_PDN, MT6328_PMIC_RG_RTC32K_1V8_0_O_PDN_ADDR,
	 MT6328_PMIC_RG_RTC32K_1V8_0_O_PDN_MASK, MT6328_PMIC_RG_RTC32K_1V8_0_O_PDN_SHIFT},
	{PMIC_RG_RTC32K_1V8_1_O_PDN, MT6328_PMIC_RG_RTC32K_1V8_1_O_PDN_ADDR,
	 MT6328_PMIC_RG_RTC32K_1V8_1_O_PDN_MASK, MT6328_PMIC_RG_RTC32K_1V8_1_O_PDN_SHIFT},
	{PMIC_RG_RTC_2SEC_OFF_DET_PDN, MT6328_PMIC_RG_RTC_2SEC_OFF_DET_PDN_ADDR,
	 MT6328_PMIC_RG_RTC_2SEC_OFF_DET_PDN_MASK, MT6328_PMIC_RG_RTC_2SEC_OFF_DET_PDN_SHIFT},
	{PMIC_RG_FQMTR_CK_PDN, MT6328_PMIC_RG_FQMTR_CK_PDN_ADDR, MT6328_PMIC_RG_FQMTR_CK_PDN_MASK,
	 MT6328_PMIC_RG_FQMTR_CK_PDN_SHIFT},
	{PMIC_RG_STB_1M_CK_PDN, MT6328_PMIC_RG_STB_1M_CK_PDN_ADDR,
	 MT6328_PMIC_RG_STB_1M_CK_PDN_MASK, MT6328_PMIC_RG_STB_1M_CK_PDN_SHIFT},
	{PMIC_RG_BUCK_1M_CK_PDN, MT6328_PMIC_RG_BUCK_1M_CK_PDN_ADDR,
	 MT6328_PMIC_RG_BUCK_1M_CK_PDN_MASK, MT6328_PMIC_RG_BUCK_1M_CK_PDN_SHIFT},
	{PMIC_RG_AUXADC_CK_PDN, MT6328_PMIC_RG_AUXADC_CK_PDN_ADDR,
	 MT6328_PMIC_RG_AUXADC_CK_PDN_MASK, MT6328_PMIC_RG_AUXADC_CK_PDN_SHIFT},
	{PMIC_RG_PWMOC_6M_CK_PDN, MT6328_PMIC_RG_PWMOC_6M_CK_PDN_ADDR,
	 MT6328_PMIC_RG_PWMOC_6M_CK_PDN_MASK, MT6328_PMIC_RG_PWMOC_6M_CK_PDN_SHIFT},
	{PMIC_TOP_CKPDN_CON1_SET, MT6328_PMIC_TOP_CKPDN_CON1_SET_ADDR,
	 MT6328_PMIC_TOP_CKPDN_CON1_SET_MASK, MT6328_PMIC_TOP_CKPDN_CON1_SET_SHIFT},
	{PMIC_TOP_CKPDN_CON1_CLR, MT6328_PMIC_TOP_CKPDN_CON1_CLR_ADDR,
	 MT6328_PMIC_TOP_CKPDN_CON1_CLR_MASK, MT6328_PMIC_TOP_CKPDN_CON1_CLR_SHIFT},
	{PMIC_RG_SPK_CK_PDN, MT6328_PMIC_RG_SPK_CK_PDN_ADDR, MT6328_PMIC_RG_SPK_CK_PDN_MASK,
	 MT6328_PMIC_RG_SPK_CK_PDN_SHIFT},
	{PMIC_RG_SPK_PWM_CK_PDN, MT6328_PMIC_RG_SPK_PWM_CK_PDN_ADDR,
	 MT6328_PMIC_RG_SPK_PWM_CK_PDN_MASK, MT6328_PMIC_RG_SPK_PWM_CK_PDN_SHIFT},
	{PMIC_RG_FGADC_ANA_CK_PDN, MT6328_PMIC_RG_FGADC_ANA_CK_PDN_ADDR,
	 MT6328_PMIC_RG_FGADC_ANA_CK_PDN_MASK, MT6328_PMIC_RG_FGADC_ANA_CK_PDN_SHIFT},
	{PMIC_RG_FGADC_DIG_CK_PDN, MT6328_PMIC_RG_FGADC_DIG_CK_PDN_ADDR,
	 MT6328_PMIC_RG_FGADC_DIG_CK_PDN_MASK, MT6328_PMIC_RG_FGADC_DIG_CK_PDN_SHIFT},
	{PMIC_RG_BIF_X72_CK_PDN, MT6328_PMIC_RG_BIF_X72_CK_PDN_ADDR,
	 MT6328_PMIC_RG_BIF_X72_CK_PDN_MASK, MT6328_PMIC_RG_BIF_X72_CK_PDN_SHIFT},
	{PMIC_RG_BIF_X4_CK_PDN, MT6328_PMIC_RG_BIF_X4_CK_PDN_ADDR,
	 MT6328_PMIC_RG_BIF_X4_CK_PDN_MASK, MT6328_PMIC_RG_BIF_X4_CK_PDN_SHIFT},
	{PMIC_RG_BIF_X1_CK_PDN, MT6328_PMIC_RG_BIF_X1_CK_PDN_ADDR,
	 MT6328_PMIC_RG_BIF_X1_CK_PDN_MASK, MT6328_PMIC_RG_BIF_X1_CK_PDN_SHIFT},
	{PMIC_RG_PCHR_32K_CK_PDN, MT6328_PMIC_RG_PCHR_32K_CK_PDN_ADDR,
	 MT6328_PMIC_RG_PCHR_32K_CK_PDN_MASK, MT6328_PMIC_RG_PCHR_32K_CK_PDN_SHIFT},
	{PMIC_RG_ACCDET_CK_PDN, MT6328_PMIC_RG_ACCDET_CK_PDN_ADDR,
	 MT6328_PMIC_RG_ACCDET_CK_PDN_MASK, MT6328_PMIC_RG_ACCDET_CK_PDN_SHIFT},
	{PMIC_RG_FQMTR_32K_CK_PDN, MT6328_PMIC_RG_FQMTR_32K_CK_PDN_ADDR,
	 MT6328_PMIC_RG_FQMTR_32K_CK_PDN_MASK, MT6328_PMIC_RG_FQMTR_32K_CK_PDN_SHIFT},
	{PMIC_RG_INTRP_CK_PDN, MT6328_PMIC_RG_INTRP_CK_PDN_ADDR, MT6328_PMIC_RG_INTRP_CK_PDN_MASK,
	 MT6328_PMIC_RG_INTRP_CK_PDN_SHIFT},
	{PMIC_RG_RTC_26M_CK_PDN, MT6328_PMIC_RG_RTC_26M_CK_PDN_ADDR,
	 MT6328_PMIC_RG_RTC_26M_CK_PDN_MASK, MT6328_PMIC_RG_RTC_26M_CK_PDN_SHIFT},
	{PMIC_RG_RTC_EOSC32_CK_PDN, MT6328_PMIC_RG_RTC_EOSC32_CK_PDN_ADDR,
	 MT6328_PMIC_RG_RTC_EOSC32_CK_PDN_MASK, MT6328_PMIC_RG_RTC_EOSC32_CK_PDN_SHIFT},
	{PMIC_RG_TRIM_75K_CK_PDN, MT6328_PMIC_RG_TRIM_75K_CK_PDN_ADDR,
	 MT6328_PMIC_RG_TRIM_75K_CK_PDN_MASK, MT6328_PMIC_RG_TRIM_75K_CK_PDN_SHIFT},
	{PMIC_RG_STRUP_LBAT_SEL_CK_PDN, MT6328_PMIC_RG_STRUP_LBAT_SEL_CK_PDN_ADDR,
	 MT6328_PMIC_RG_STRUP_LBAT_SEL_CK_PDN_MASK, MT6328_PMIC_RG_STRUP_LBAT_SEL_CK_PDN_SHIFT},
	{PMIC_TOP_CKPDN_CON2_SET, MT6328_PMIC_TOP_CKPDN_CON2_SET_ADDR,
	 MT6328_PMIC_TOP_CKPDN_CON2_SET_MASK, MT6328_PMIC_TOP_CKPDN_CON2_SET_SHIFT},
	{PMIC_TOP_CKPDN_CON2_CLR, MT6328_PMIC_TOP_CKPDN_CON2_CLR_ADDR,
	 MT6328_PMIC_TOP_CKPDN_CON2_CLR_MASK, MT6328_PMIC_TOP_CKPDN_CON2_CLR_SHIFT},
	{PMIC_RG_STRUP_75K_CK_PDN, MT6328_PMIC_RG_STRUP_75K_CK_PDN_ADDR,
	 MT6328_PMIC_RG_STRUP_75K_CK_PDN_MASK, MT6328_PMIC_RG_STRUP_75K_CK_PDN_SHIFT},
	{PMIC_RG_STRUP_32K_CK_PDN, MT6328_PMIC_RG_STRUP_32K_CK_PDN_ADDR,
	 MT6328_PMIC_RG_STRUP_32K_CK_PDN_MASK, MT6328_PMIC_RG_STRUP_32K_CK_PDN_SHIFT},
	{PMIC_RG_EFUSE_CK_PDN, MT6328_PMIC_RG_EFUSE_CK_PDN_ADDR, MT6328_PMIC_RG_EFUSE_CK_PDN_MASK,
	 MT6328_PMIC_RG_EFUSE_CK_PDN_SHIFT},
	{PMIC_RG_SMPS_CK_DIV_PDN, MT6328_PMIC_RG_SMPS_CK_DIV_PDN_ADDR,
	 MT6328_PMIC_RG_SMPS_CK_DIV_PDN_MASK, MT6328_PMIC_RG_SMPS_CK_DIV_PDN_SHIFT},
	{PMIC_RG_SPI_CK_PDN, MT6328_PMIC_RG_SPI_CK_PDN_ADDR, MT6328_PMIC_RG_SPI_CK_PDN_MASK,
	 MT6328_PMIC_RG_SPI_CK_PDN_SHIFT},
	{PMIC_RG_BGR_TEST_CK_PDN, MT6328_PMIC_RG_BGR_TEST_CK_PDN_ADDR,
	 MT6328_PMIC_RG_BGR_TEST_CK_PDN_MASK, MT6328_PMIC_RG_BGR_TEST_CK_PDN_SHIFT},
	{PMIC_RG_FGADC_FT_CK_PDN, MT6328_PMIC_RG_FGADC_FT_CK_PDN_ADDR,
	 MT6328_PMIC_RG_FGADC_FT_CK_PDN_MASK, MT6328_PMIC_RG_FGADC_FT_CK_PDN_SHIFT},
	{PMIC_RG_PCHR_TEST_CK_PDN, MT6328_PMIC_RG_PCHR_TEST_CK_PDN_ADDR,
	 MT6328_PMIC_RG_PCHR_TEST_CK_PDN_MASK, MT6328_PMIC_RG_PCHR_TEST_CK_PDN_SHIFT},
	{PMIC_RG_BUCK_32K_CK_PDN, MT6328_PMIC_RG_BUCK_32K_CK_PDN_ADDR,
	 MT6328_PMIC_RG_BUCK_32K_CK_PDN_MASK, MT6328_PMIC_RG_BUCK_32K_CK_PDN_SHIFT},
	{PMIC_RG_BUCK_ANA_CK_PDN, MT6328_PMIC_RG_BUCK_ANA_CK_PDN_ADDR,
	 MT6328_PMIC_RG_BUCK_ANA_CK_PDN_MASK, MT6328_PMIC_RG_BUCK_ANA_CK_PDN_SHIFT},
	{PMIC_RG_EOSC_CALI_TEST_CK_PDN, MT6328_PMIC_RG_EOSC_CALI_TEST_CK_PDN_ADDR,
	 MT6328_PMIC_RG_EOSC_CALI_TEST_CK_PDN_MASK, MT6328_PMIC_RG_EOSC_CALI_TEST_CK_PDN_SHIFT},
	{PMIC_TOP_CKPDN_CON3_RSV, MT6328_PMIC_TOP_CKPDN_CON3_RSV_ADDR,
	 MT6328_PMIC_TOP_CKPDN_CON3_RSV_MASK, MT6328_PMIC_TOP_CKPDN_CON3_RSV_SHIFT},
	{PMIC_TOP_CKPDN_CON3_SET, MT6328_PMIC_TOP_CKPDN_CON3_SET_ADDR,
	 MT6328_PMIC_TOP_CKPDN_CON3_SET_MASK, MT6328_PMIC_TOP_CKPDN_CON3_SET_SHIFT},
	{PMIC_TOP_CKPDN_CON3_CLR, MT6328_PMIC_TOP_CKPDN_CON3_CLR_ADDR,
	 MT6328_PMIC_TOP_CKPDN_CON3_CLR_MASK, MT6328_PMIC_TOP_CKPDN_CON3_CLR_SHIFT},
	{PMIC_RG_BUCK_18M_CK_PDN, MT6328_PMIC_RG_BUCK_18M_CK_PDN_ADDR,
	 MT6328_PMIC_RG_BUCK_18M_CK_PDN_MASK, MT6328_PMIC_RG_BUCK_18M_CK_PDN_SHIFT},
	{PMIC_RG_BUCK_VSRAM_18M_CK_PDN, MT6328_PMIC_RG_BUCK_VSRAM_18M_CK_PDN_ADDR,
	 MT6328_PMIC_RG_BUCK_VSRAM_18M_CK_PDN_MASK, MT6328_PMIC_RG_BUCK_VSRAM_18M_CK_PDN_SHIFT},
	{PMIC_RG_BUCK_VPA_18M_CK_PDN, MT6328_PMIC_RG_BUCK_VPA_18M_CK_PDN_ADDR,
	 MT6328_PMIC_RG_BUCK_VPA_18M_CK_PDN_MASK, MT6328_PMIC_RG_BUCK_VPA_18M_CK_PDN_SHIFT},
	{PMIC_RG_BUCK_VLTE_18M_CK_PDN, MT6328_PMIC_RG_BUCK_VLTE_18M_CK_PDN_ADDR,
	 MT6328_PMIC_RG_BUCK_VLTE_18M_CK_PDN_MASK, MT6328_PMIC_RG_BUCK_VLTE_18M_CK_PDN_SHIFT},
	{PMIC_RG_BUCK_VSYS22_18M_CK_PDN, MT6328_PMIC_RG_BUCK_VSYS22_18M_CK_PDN_ADDR,
	 MT6328_PMIC_RG_BUCK_VSYS22_18M_CK_PDN_MASK, MT6328_PMIC_RG_BUCK_VSYS22_18M_CK_PDN_SHIFT},
	{PMIC_RG_BUCK_VCORE1_18M_CK_PDN, MT6328_PMIC_RG_BUCK_VCORE1_18M_CK_PDN_ADDR,
	 MT6328_PMIC_RG_BUCK_VCORE1_18M_CK_PDN_MASK, MT6328_PMIC_RG_BUCK_VCORE1_18M_CK_PDN_SHIFT},
	{PMIC_RG_BUCK_VPROC_18M_CK_PDN, MT6328_PMIC_RG_BUCK_VPROC_18M_CK_PDN_ADDR,
	 MT6328_PMIC_RG_BUCK_VPROC_18M_CK_PDN_MASK, MT6328_PMIC_RG_BUCK_VPROC_18M_CK_PDN_SHIFT},
	{PMIC_TOP_CKPDN_CON4_RSV, MT6328_PMIC_TOP_CKPDN_CON4_RSV_ADDR,
	 MT6328_PMIC_TOP_CKPDN_CON4_RSV_MASK, MT6328_PMIC_TOP_CKPDN_CON4_RSV_SHIFT},
	{PMIC_TOP_CKPDN_CON4_SET, MT6328_PMIC_TOP_CKPDN_CON4_SET_ADDR,
	 MT6328_PMIC_TOP_CKPDN_CON4_SET_MASK, MT6328_PMIC_TOP_CKPDN_CON4_SET_SHIFT},
	{PMIC_TOP_CKPDN_CON4_CLR, MT6328_PMIC_TOP_CKPDN_CON4_CLR_ADDR,
	 MT6328_PMIC_TOP_CKPDN_CON4_CLR_MASK, MT6328_PMIC_TOP_CKPDN_CON4_CLR_SHIFT},
	{PMIC_RG_AUDIF_CK_CKSEL, MT6328_PMIC_RG_AUDIF_CK_CKSEL_ADDR,
	 MT6328_PMIC_RG_AUDIF_CK_CKSEL_MASK, MT6328_PMIC_RG_AUDIF_CK_CKSEL_SHIFT},
	{PMIC_RG_AUD_CK_CKSEL, MT6328_PMIC_RG_AUD_CK_CKSEL_ADDR, MT6328_PMIC_RG_AUD_CK_CKSEL_MASK,
	 MT6328_PMIC_RG_AUD_CK_CKSEL_SHIFT},
	{PMIC_RG_DRV_ISINK0_CK_CKSEL, MT6328_PMIC_RG_DRV_ISINK0_CK_CKSEL_ADDR,
	 MT6328_PMIC_RG_DRV_ISINK0_CK_CKSEL_MASK, MT6328_PMIC_RG_DRV_ISINK0_CK_CKSEL_SHIFT},
	{PMIC_RG_DRV_ISINK1_CK_CKSEL, MT6328_PMIC_RG_DRV_ISINK1_CK_CKSEL_ADDR,
	 MT6328_PMIC_RG_DRV_ISINK1_CK_CKSEL_MASK, MT6328_PMIC_RG_DRV_ISINK1_CK_CKSEL_SHIFT},
	{PMIC_RG_DRV_ISINK2_CK_CKSEL, MT6328_PMIC_RG_DRV_ISINK2_CK_CKSEL_ADDR,
	 MT6328_PMIC_RG_DRV_ISINK2_CK_CKSEL_MASK, MT6328_PMIC_RG_DRV_ISINK2_CK_CKSEL_SHIFT},
	{PMIC_RG_DRV_ISINK3_CK_CKSEL, MT6328_PMIC_RG_DRV_ISINK3_CK_CKSEL_ADDR,
	 MT6328_PMIC_RG_DRV_ISINK3_CK_CKSEL_MASK, MT6328_PMIC_RG_DRV_ISINK3_CK_CKSEL_SHIFT},
	{PMIC_RG_FQMTR_CK_CKSEL, MT6328_PMIC_RG_FQMTR_CK_CKSEL_ADDR,
	 MT6328_PMIC_RG_FQMTR_CK_CKSEL_MASK, MT6328_PMIC_RG_FQMTR_CK_CKSEL_SHIFT},
	{PMIC_RG_75K_32K_SEL, MT6328_PMIC_RG_75K_32K_SEL_ADDR, MT6328_PMIC_RG_75K_32K_SEL_MASK,
	 MT6328_PMIC_RG_75K_32K_SEL_SHIFT},
	{PMIC_RG_AUXADC_CK_CKSEL, MT6328_PMIC_RG_AUXADC_CK_CKSEL_ADDR,
	 MT6328_PMIC_RG_AUXADC_CK_CKSEL_MASK, MT6328_PMIC_RG_AUXADC_CK_CKSEL_SHIFT},
	{PMIC_RG_OSC_SEL_HW_SRC_SEL, MT6328_PMIC_RG_OSC_SEL_HW_SRC_SEL_ADDR,
	 MT6328_PMIC_RG_OSC_SEL_HW_SRC_SEL_MASK, MT6328_PMIC_RG_OSC_SEL_HW_SRC_SEL_SHIFT},
	{PMIC_RG_SRCLKEN_SRC_SEL, MT6328_PMIC_RG_SRCLKEN_SRC_SEL_ADDR,
	 MT6328_PMIC_RG_SRCLKEN_SRC_SEL_MASK, MT6328_PMIC_RG_SRCLKEN_SRC_SEL_SHIFT},
	{PMIC_TOP_CKSEL_CON_SET, MT6328_PMIC_TOP_CKSEL_CON_SET_ADDR,
	 MT6328_PMIC_TOP_CKSEL_CON_SET_MASK, MT6328_PMIC_TOP_CKSEL_CON_SET_SHIFT},
	{PMIC_TOP_CKSEL_CON_CLR, MT6328_PMIC_TOP_CKSEL_CON_CLR_ADDR,
	 MT6328_PMIC_TOP_CKSEL_CON_CLR_MASK, MT6328_PMIC_TOP_CKSEL_CON_CLR_SHIFT},
	{PMIC_RG_STRUP_75K_CK_CKSEL, MT6328_PMIC_RG_STRUP_75K_CK_CKSEL_ADDR,
	 MT6328_PMIC_RG_STRUP_75K_CK_CKSEL_MASK, MT6328_PMIC_RG_STRUP_75K_CK_CKSEL_SHIFT},
	{PMIC_RG_BGR_TEST_CK_CKSEL, MT6328_PMIC_RG_BGR_TEST_CK_CKSEL_ADDR,
	 MT6328_PMIC_RG_BGR_TEST_CK_CKSEL_MASK, MT6328_PMIC_RG_BGR_TEST_CK_CKSEL_SHIFT},
	{PMIC_RG_PCHR_TEST_CK_CKSEL, MT6328_PMIC_RG_PCHR_TEST_CK_CKSEL_ADDR,
	 MT6328_PMIC_RG_PCHR_TEST_CK_CKSEL_MASK, MT6328_PMIC_RG_PCHR_TEST_CK_CKSEL_SHIFT},
	{PMIC_RG_FGADC_ANA_CK_CKSEL, MT6328_PMIC_RG_FGADC_ANA_CK_CKSEL_ADDR,
	 MT6328_PMIC_RG_FGADC_ANA_CK_CKSEL_MASK, MT6328_PMIC_RG_FGADC_ANA_CK_CKSEL_SHIFT},
	{PMIC_RG_VPROC_3M_CK_CKSEL, MT6328_PMIC_RG_VPROC_3M_CK_CKSEL_ADDR,
	 MT6328_PMIC_RG_VPROC_3M_CK_CKSEL_MASK, MT6328_PMIC_RG_VPROC_3M_CK_CKSEL_SHIFT},
	{PMIC_RG_VCORE1_3M_CK_CKSEL, MT6328_PMIC_RG_VCORE1_3M_CK_CKSEL_ADDR,
	 MT6328_PMIC_RG_VCORE1_3M_CK_CKSEL_MASK, MT6328_PMIC_RG_VCORE1_3M_CK_CKSEL_SHIFT},
	{PMIC_TOP_CKSEL_CON1_SET, MT6328_PMIC_TOP_CKSEL_CON1_SET_ADDR,
	 MT6328_PMIC_TOP_CKSEL_CON1_SET_MASK, MT6328_PMIC_TOP_CKSEL_CON1_SET_SHIFT},
	{PMIC_TOP_CKSEL_CON1_CLR, MT6328_PMIC_TOP_CKSEL_CON1_CLR_ADDR,
	 MT6328_PMIC_TOP_CKSEL_CON1_CLR_MASK, MT6328_PMIC_TOP_CKSEL_CON1_CLR_SHIFT},
	{PMIC_RG_SRCVOLTEN_SW, MT6328_PMIC_RG_SRCVOLTEN_SW_ADDR, MT6328_PMIC_RG_SRCVOLTEN_SW_MASK,
	 MT6328_PMIC_RG_SRCVOLTEN_SW_SHIFT},
	{PMIC_RG_BUCK_OSC_SEL_SW, MT6328_PMIC_RG_BUCK_OSC_SEL_SW_ADDR,
	 MT6328_PMIC_RG_BUCK_OSC_SEL_SW_MASK, MT6328_PMIC_RG_BUCK_OSC_SEL_SW_SHIFT},
	{PMIC_RG_VCORE2_OSC_SEL_SW, MT6328_PMIC_RG_VCORE2_OSC_SEL_SW_ADDR,
	 MT6328_PMIC_RG_VCORE2_OSC_SEL_SW_MASK, MT6328_PMIC_RG_VCORE2_OSC_SEL_SW_SHIFT},
	{PMIC_RG_SRCVOLTEN_MODE, MT6328_PMIC_RG_SRCVOLTEN_MODE_ADDR,
	 MT6328_PMIC_RG_SRCVOLTEN_MODE_MASK, MT6328_PMIC_RG_SRCVOLTEN_MODE_SHIFT},
	{PMIC_RG_BUCK_OSC_SEL_MODE, MT6328_PMIC_RG_BUCK_OSC_SEL_MODE_ADDR,
	 MT6328_PMIC_RG_BUCK_OSC_SEL_MODE_MASK, MT6328_PMIC_RG_BUCK_OSC_SEL_MODE_SHIFT},
	{PMIC_RG_VCORE2_OSC_SEL_MODE, MT6328_PMIC_RG_VCORE2_OSC_SEL_MODE_ADDR,
	 MT6328_PMIC_RG_VCORE2_OSC_SEL_MODE_MASK, MT6328_PMIC_RG_VCORE2_OSC_SEL_MODE_SHIFT},
	{PMIC_RG_VLTE_3M_CK_CKSEL, MT6328_PMIC_RG_VLTE_3M_CK_CKSEL_ADDR,
	 MT6328_PMIC_RG_VLTE_3M_CK_CKSEL_MASK, MT6328_PMIC_RG_VLTE_3M_CK_CKSEL_SHIFT},
	{PMIC_TOP_CKSEL_CON2_RSV, MT6328_PMIC_TOP_CKSEL_CON2_RSV_ADDR,
	 MT6328_PMIC_TOP_CKSEL_CON2_RSV_MASK, MT6328_PMIC_TOP_CKSEL_CON2_RSV_SHIFT},
	{PMIC_TOP_CKSEL_CON2_SET, MT6328_PMIC_TOP_CKSEL_CON2_SET_ADDR,
	 MT6328_PMIC_TOP_CKSEL_CON2_SET_MASK, MT6328_PMIC_TOP_CKSEL_CON2_SET_SHIFT},
	{PMIC_TOP_CKSEL_CON2_CLR, MT6328_PMIC_TOP_CKSEL_CON2_CLR_ADDR,
	 MT6328_PMIC_TOP_CKSEL_CON2_CLR_MASK, MT6328_PMIC_TOP_CKSEL_CON2_CLR_SHIFT},
	{PMIC_RG_STRUP_LBAT_SEL_CK_DIVSEL, MT6328_PMIC_RG_STRUP_LBAT_SEL_CK_DIVSEL_ADDR,
	 MT6328_PMIC_RG_STRUP_LBAT_SEL_CK_DIVSEL_MASK,
	 MT6328_PMIC_RG_STRUP_LBAT_SEL_CK_DIVSEL_SHIFT},
	{PMIC_TOP_CKDIVSEL_CON_RSV, MT6328_PMIC_TOP_CKDIVSEL_CON_RSV_ADDR,
	 MT6328_PMIC_TOP_CKDIVSEL_CON_RSV_MASK, MT6328_PMIC_TOP_CKDIVSEL_CON_RSV_SHIFT},
	{PMIC_RG_BIF_X4_CK_DIVSEL, MT6328_PMIC_RG_BIF_X4_CK_DIVSEL_ADDR,
	 MT6328_PMIC_RG_BIF_X4_CK_DIVSEL_MASK, MT6328_PMIC_RG_BIF_X4_CK_DIVSEL_SHIFT},
	{PMIC_RG_REG_CK_DIVSEL, MT6328_PMIC_RG_REG_CK_DIVSEL_ADDR,
	 MT6328_PMIC_RG_REG_CK_DIVSEL_MASK, MT6328_PMIC_RG_REG_CK_DIVSEL_SHIFT},
	{PMIC_RG_SPK_CK_DIVSEL, MT6328_PMIC_RG_SPK_CK_DIVSEL_ADDR,
	 MT6328_PMIC_RG_SPK_CK_DIVSEL_MASK, MT6328_PMIC_RG_SPK_CK_DIVSEL_SHIFT},
	{PMIC_RG_SPK_PWM_CK_DIVSEL, MT6328_PMIC_RG_SPK_PWM_CK_DIVSEL_ADDR,
	 MT6328_PMIC_RG_SPK_PWM_CK_DIVSEL_MASK, MT6328_PMIC_RG_SPK_PWM_CK_DIVSEL_SHIFT},
	{PMIC_TOP_CKDIVSEL_CON0_SET, MT6328_PMIC_TOP_CKDIVSEL_CON0_SET_ADDR,
	 MT6328_PMIC_TOP_CKDIVSEL_CON0_SET_MASK, MT6328_PMIC_TOP_CKDIVSEL_CON0_SET_SHIFT},
	{PMIC_TOP_CKDIVSEL_CON0_CLR, MT6328_PMIC_TOP_CKDIVSEL_CON0_CLR_ADDR,
	 MT6328_PMIC_TOP_CKDIVSEL_CON0_CLR_MASK, MT6328_PMIC_TOP_CKDIVSEL_CON0_CLR_SHIFT},
	{PMIC_RG_AUXADC_SMPS_CK_DIVSEL, MT6328_PMIC_RG_AUXADC_SMPS_CK_DIVSEL_ADDR,
	 MT6328_PMIC_RG_AUXADC_SMPS_CK_DIVSEL_MASK, MT6328_PMIC_RG_AUXADC_SMPS_CK_DIVSEL_SHIFT},
	{PMIC_RG_AUXADC_26M_CK_DIVSEL, MT6328_PMIC_RG_AUXADC_26M_CK_DIVSEL_ADDR,
	 MT6328_PMIC_RG_AUXADC_26M_CK_DIVSEL_MASK, MT6328_PMIC_RG_AUXADC_26M_CK_DIVSEL_SHIFT},
	{PMIC_RG_BUCK_18M_CK_DIVSEL, MT6328_PMIC_RG_BUCK_18M_CK_DIVSEL_ADDR,
	 MT6328_PMIC_RG_BUCK_18M_CK_DIVSEL_MASK, MT6328_PMIC_RG_BUCK_18M_CK_DIVSEL_SHIFT},
	{PMIC_TOP_CKDIVSEL_CON1_SET, MT6328_PMIC_TOP_CKDIVSEL_CON1_SET_ADDR,
	 MT6328_PMIC_TOP_CKDIVSEL_CON1_SET_MASK, MT6328_PMIC_TOP_CKDIVSEL_CON1_SET_SHIFT},
	{PMIC_TOP_CKDIVSEL_CON1_CLR, MT6328_PMIC_TOP_CKDIVSEL_CON1_CLR_ADDR,
	 MT6328_PMIC_TOP_CKDIVSEL_CON1_CLR_MASK, MT6328_PMIC_TOP_CKDIVSEL_CON1_CLR_SHIFT},
	{PMIC_RG_G_SMPS_PD_CK_PDN_HWEN, MT6328_PMIC_RG_G_SMPS_PD_CK_PDN_HWEN_ADDR,
	 MT6328_PMIC_RG_G_SMPS_PD_CK_PDN_HWEN_MASK, MT6328_PMIC_RG_G_SMPS_PD_CK_PDN_HWEN_SHIFT},
	{PMIC_RG_G_SMPS_AUD_CK_PDN_HWEN, MT6328_PMIC_RG_G_SMPS_AUD_CK_PDN_HWEN_ADDR,
	 MT6328_PMIC_RG_G_SMPS_AUD_CK_PDN_HWEN_MASK, MT6328_PMIC_RG_G_SMPS_AUD_CK_PDN_HWEN_SHIFT},
	{PMIC_RG_G_DRV_2M_CK_PDN_HWEN, MT6328_PMIC_RG_G_DRV_2M_CK_PDN_HWEN_ADDR,
	 MT6328_PMIC_RG_G_DRV_2M_CK_PDN_HWEN_MASK, MT6328_PMIC_RG_G_DRV_2M_CK_PDN_HWEN_SHIFT},
	{PMIC_RG_AUXADC_CK_PDN_HWEN, MT6328_PMIC_RG_AUXADC_CK_PDN_HWEN_ADDR,
	 MT6328_PMIC_RG_AUXADC_CK_PDN_HWEN_MASK, MT6328_PMIC_RG_AUXADC_CK_PDN_HWEN_SHIFT},
	{PMIC_RG_AUXADC_SMPS_CK_PDN_HWEN, MT6328_PMIC_RG_AUXADC_SMPS_CK_PDN_HWEN_ADDR,
	 MT6328_PMIC_RG_AUXADC_SMPS_CK_PDN_HWEN_MASK, MT6328_PMIC_RG_AUXADC_SMPS_CK_PDN_HWEN_SHIFT},
	{PMIC_RG_BUCK_1M_CK_PDN_HWEN, MT6328_PMIC_RG_BUCK_1M_CK_PDN_HWEN_ADDR,
	 MT6328_PMIC_RG_BUCK_1M_CK_PDN_HWEN_MASK, MT6328_PMIC_RG_BUCK_1M_CK_PDN_HWEN_SHIFT},
	{PMIC_RG_EFUSE_CK_PDN_HWEN, MT6328_PMIC_RG_EFUSE_CK_PDN_HWEN_ADDR,
	 MT6328_PMIC_RG_EFUSE_CK_PDN_HWEN_MASK, MT6328_PMIC_RG_EFUSE_CK_PDN_HWEN_SHIFT},
	{PMIC_RG_RTC_26M_CK_PDN_HWEN, MT6328_PMIC_RG_RTC_26M_CK_PDN_HWEN_ADDR,
	 MT6328_PMIC_RG_RTC_26M_CK_PDN_HWEN_MASK, MT6328_PMIC_RG_RTC_26M_CK_PDN_HWEN_SHIFT},
	{PMIC_RG_AUXADC_26M_CK_PDN_HWEN, MT6328_PMIC_RG_AUXADC_26M_CK_PDN_HWEN_ADDR,
	 MT6328_PMIC_RG_AUXADC_26M_CK_PDN_HWEN_MASK, MT6328_PMIC_RG_AUXADC_26M_CK_PDN_HWEN_SHIFT},
	{PMIC_RG_AUXADC_CK_CKSEL_HWEN, MT6328_PMIC_RG_AUXADC_CK_CKSEL_HWEN_ADDR,
	 MT6328_PMIC_RG_AUXADC_CK_CKSEL_HWEN_MASK, MT6328_PMIC_RG_AUXADC_CK_CKSEL_HWEN_SHIFT},
	{PMIC_TOP_CKHWEN_CON0_RSV, MT6328_PMIC_TOP_CKHWEN_CON0_RSV_ADDR,
	 MT6328_PMIC_TOP_CKHWEN_CON0_RSV_MASK, MT6328_PMIC_TOP_CKHWEN_CON0_RSV_SHIFT},
	{PMIC_TOP_CKHWEN_CON0_SET, MT6328_PMIC_TOP_CKHWEN_CON0_SET_ADDR,
	 MT6328_PMIC_TOP_CKHWEN_CON0_SET_MASK, MT6328_PMIC_TOP_CKHWEN_CON0_SET_SHIFT},
	{PMIC_TOP_CKHWEN_CON0_CLR, MT6328_PMIC_TOP_CKHWEN_CON0_CLR_ADDR,
	 MT6328_PMIC_TOP_CKHWEN_CON0_CLR_MASK, MT6328_PMIC_TOP_CKHWEN_CON0_CLR_SHIFT},
	{PMIC_RG_BUCK_VSRAM_18M_CK_PDN_HWEN, MT6328_PMIC_RG_BUCK_VSRAM_18M_CK_PDN_HWEN_ADDR,
	 MT6328_PMIC_RG_BUCK_VSRAM_18M_CK_PDN_HWEN_MASK,
	 MT6328_PMIC_RG_BUCK_VSRAM_18M_CK_PDN_HWEN_SHIFT},
	{PMIC_RG_BUCK_VPA_18M_CK_PDN_HWEN, MT6328_PMIC_RG_BUCK_VPA_18M_CK_PDN_HWEN_ADDR,
	 MT6328_PMIC_RG_BUCK_VPA_18M_CK_PDN_HWEN_MASK,
	 MT6328_PMIC_RG_BUCK_VPA_18M_CK_PDN_HWEN_SHIFT},
	{PMIC_RG_BUCK_VLTE_18M_CK_PDN_HWEN, MT6328_PMIC_RG_BUCK_VLTE_18M_CK_PDN_HWEN_ADDR,
	 MT6328_PMIC_RG_BUCK_VLTE_18M_CK_PDN_HWEN_MASK,
	 MT6328_PMIC_RG_BUCK_VLTE_18M_CK_PDN_HWEN_SHIFT},
	{PMIC_RG_BUCK_VSYS22_18M_CK_PDN_HWEN, MT6328_PMIC_RG_BUCK_VSYS22_18M_CK_PDN_HWEN_ADDR,
	 MT6328_PMIC_RG_BUCK_VSYS22_18M_CK_PDN_HWEN_MASK,
	 MT6328_PMIC_RG_BUCK_VSYS22_18M_CK_PDN_HWEN_SHIFT},
	{PMIC_RG_BUCK_VCORE1_18M_CK_PDN_HWEN, MT6328_PMIC_RG_BUCK_VCORE1_18M_CK_PDN_HWEN_ADDR,
	 MT6328_PMIC_RG_BUCK_VCORE1_18M_CK_PDN_HWEN_MASK,
	 MT6328_PMIC_RG_BUCK_VCORE1_18M_CK_PDN_HWEN_SHIFT},
	{PMIC_RG_BUCK_VPROC_18M_CK_PDN_HWEN, MT6328_PMIC_RG_BUCK_VPROC_18M_CK_PDN_HWEN_ADDR,
	 MT6328_PMIC_RG_BUCK_VPROC_18M_CK_PDN_HWEN_MASK,
	 MT6328_PMIC_RG_BUCK_VPROC_18M_CK_PDN_HWEN_SHIFT},
	{PMIC_TOP_CKHWEN_CON1_RSV, MT6328_PMIC_TOP_CKHWEN_CON1_RSV_ADDR,
	 MT6328_PMIC_TOP_CKHWEN_CON1_RSV_MASK, MT6328_PMIC_TOP_CKHWEN_CON1_RSV_SHIFT},
	{PMIC_TOP_CKHWEN_CON1_SET, MT6328_PMIC_TOP_CKHWEN_CON1_SET_ADDR,
	 MT6328_PMIC_TOP_CKHWEN_CON1_SET_MASK, MT6328_PMIC_TOP_CKHWEN_CON1_SET_SHIFT},
	{PMIC_TOP_CKHWEN_CON1_CLR, MT6328_PMIC_TOP_CKHWEN_CON1_CLR_ADDR,
	 MT6328_PMIC_TOP_CKHWEN_CON1_CLR_MASK, MT6328_PMIC_TOP_CKHWEN_CON1_CLR_SHIFT},
	{PMIC_RG_PMU75K_CK_TST_DIS, MT6328_PMIC_RG_PMU75K_CK_TST_DIS_ADDR,
	 MT6328_PMIC_RG_PMU75K_CK_TST_DIS_MASK, MT6328_PMIC_RG_PMU75K_CK_TST_DIS_SHIFT},
	{PMIC_RG_SMPS_CK_TST_DIS, MT6328_PMIC_RG_SMPS_CK_TST_DIS_ADDR,
	 MT6328_PMIC_RG_SMPS_CK_TST_DIS_MASK, MT6328_PMIC_RG_SMPS_CK_TST_DIS_SHIFT},
	{PMIC_RG_AUD26M_CK_TST_DIS, MT6328_PMIC_RG_AUD26M_CK_TST_DIS_ADDR,
	 MT6328_PMIC_RG_AUD26M_CK_TST_DIS_MASK, MT6328_PMIC_RG_AUD26M_CK_TST_DIS_SHIFT},
	{PMIC_RG_RTC32K_CK_TST_DIS, MT6328_PMIC_RG_RTC32K_CK_TST_DIS_ADDR,
	 MT6328_PMIC_RG_RTC32K_CK_TST_DIS_MASK, MT6328_PMIC_RG_RTC32K_CK_TST_DIS_SHIFT},
	{PMIC_RG_SPK_CK_TST_DIS, MT6328_PMIC_RG_SPK_CK_TST_DIS_ADDR,
	 MT6328_PMIC_RG_SPK_CK_TST_DIS_MASK, MT6328_PMIC_RG_SPK_CK_TST_DIS_SHIFT},
	{PMIC_RG_FG_CK_TST_DIS, MT6328_PMIC_RG_FG_CK_TST_DIS_ADDR,
	 MT6328_PMIC_RG_FG_CK_TST_DIS_MASK, MT6328_PMIC_RG_FG_CK_TST_DIS_SHIFT},
	{PMIC_RG_RTC26M_CK_TST_DIS, MT6328_PMIC_RG_RTC26M_CK_TST_DIS_ADDR,
	 MT6328_PMIC_RG_RTC26M_CK_TST_DIS_MASK, MT6328_PMIC_RG_RTC26M_CK_TST_DIS_SHIFT},
	{PMIC_TOP_CKTST_CON0_RSV, MT6328_PMIC_TOP_CKTST_CON0_RSV_ADDR,
	 MT6328_PMIC_TOP_CKTST_CON0_RSV_MASK, MT6328_PMIC_TOP_CKTST_CON0_RSV_SHIFT},
	{PMIC_RG_BUCK_ANA_AUTO_OFF_DIS, MT6328_PMIC_RG_BUCK_ANA_AUTO_OFF_DIS_ADDR,
	 MT6328_PMIC_RG_BUCK_ANA_AUTO_OFF_DIS_MASK, MT6328_PMIC_RG_BUCK_ANA_AUTO_OFF_DIS_SHIFT},
	{PMIC_RG_DRV_ISINK0_CK_TSTSEL, MT6328_PMIC_RG_DRV_ISINK0_CK_TSTSEL_ADDR,
	 MT6328_PMIC_RG_DRV_ISINK0_CK_TSTSEL_MASK, MT6328_PMIC_RG_DRV_ISINK0_CK_TSTSEL_SHIFT},
	{PMIC_RG_DRV_ISINK1_CK_TSTSEL, MT6328_PMIC_RG_DRV_ISINK1_CK_TSTSEL_ADDR,
	 MT6328_PMIC_RG_DRV_ISINK1_CK_TSTSEL_MASK, MT6328_PMIC_RG_DRV_ISINK1_CK_TSTSEL_SHIFT},
	{PMIC_RG_DRV_ISINK2_CK_TSTSEL, MT6328_PMIC_RG_DRV_ISINK2_CK_TSTSEL_ADDR,
	 MT6328_PMIC_RG_DRV_ISINK2_CK_TSTSEL_MASK, MT6328_PMIC_RG_DRV_ISINK2_CK_TSTSEL_SHIFT},
	{PMIC_RG_DRV_ISINK3_CK_TSTSEL, MT6328_PMIC_RG_DRV_ISINK3_CK_TSTSEL_ADDR,
	 MT6328_PMIC_RG_DRV_ISINK3_CK_TSTSEL_MASK, MT6328_PMIC_RG_DRV_ISINK3_CK_TSTSEL_SHIFT},
	{PMIC_RG_FQMTR_CK_TSTSEL, MT6328_PMIC_RG_FQMTR_CK_TSTSEL_ADDR,
	 MT6328_PMIC_RG_FQMTR_CK_TSTSEL_MASK, MT6328_PMIC_RG_FQMTR_CK_TSTSEL_SHIFT},
	{PMIC_RG_RTCDET_CK_TSTSEL, MT6328_PMIC_RG_RTCDET_CK_TSTSEL_ADDR,
	 MT6328_PMIC_RG_RTCDET_CK_TSTSEL_MASK, MT6328_PMIC_RG_RTCDET_CK_TSTSEL_SHIFT},
	{PMIC_RG_PMU75K_CK_TSTSEL, MT6328_PMIC_RG_PMU75K_CK_TSTSEL_ADDR,
	 MT6328_PMIC_RG_PMU75K_CK_TSTSEL_MASK, MT6328_PMIC_RG_PMU75K_CK_TSTSEL_SHIFT},
	{PMIC_RG_SMPS_CK_TSTSEL, MT6328_PMIC_RG_SMPS_CK_TSTSEL_ADDR,
	 MT6328_PMIC_RG_SMPS_CK_TSTSEL_MASK, MT6328_PMIC_RG_SMPS_CK_TSTSEL_SHIFT},
	{PMIC_RG_AUD26M_CK_TSTSEL, MT6328_PMIC_RG_AUD26M_CK_TSTSEL_ADDR,
	 MT6328_PMIC_RG_AUD26M_CK_TSTSEL_MASK, MT6328_PMIC_RG_AUD26M_CK_TSTSEL_SHIFT},
	{PMIC_RG_AUDIF_CK_TSTSEL, MT6328_PMIC_RG_AUDIF_CK_TSTSEL_ADDR,
	 MT6328_PMIC_RG_AUDIF_CK_TSTSEL_MASK, MT6328_PMIC_RG_AUDIF_CK_TSTSEL_SHIFT},
	{PMIC_RG_AUD_CK_TSTSEL, MT6328_PMIC_RG_AUD_CK_TSTSEL_ADDR,
	 MT6328_PMIC_RG_AUD_CK_TSTSEL_MASK, MT6328_PMIC_RG_AUD_CK_TSTSEL_SHIFT},
	{PMIC_RG_STRUP_75K_CK_TSTSEL, MT6328_PMIC_RG_STRUP_75K_CK_TSTSEL_ADDR,
	 MT6328_PMIC_RG_STRUP_75K_CK_TSTSEL_MASK, MT6328_PMIC_RG_STRUP_75K_CK_TSTSEL_SHIFT},
	{PMIC_RG_RTC32K_CK_TSTSEL, MT6328_PMIC_RG_RTC32K_CK_TSTSEL_ADDR,
	 MT6328_PMIC_RG_RTC32K_CK_TSTSEL_MASK, MT6328_PMIC_RG_RTC32K_CK_TSTSEL_SHIFT},
	{PMIC_RG_PCHR_TEST_CK_TSTSEL, MT6328_PMIC_RG_PCHR_TEST_CK_TSTSEL_ADDR,
	 MT6328_PMIC_RG_PCHR_TEST_CK_TSTSEL_MASK, MT6328_PMIC_RG_PCHR_TEST_CK_TSTSEL_SHIFT},
	{PMIC_RG_BGR_TEST_CK_TSTSEL, MT6328_PMIC_RG_BGR_TEST_CK_TSTSEL_ADDR,
	 MT6328_PMIC_RG_BGR_TEST_CK_TSTSEL_MASK, MT6328_PMIC_RG_BGR_TEST_CK_TSTSEL_SHIFT},
	{PMIC_RG_FG_CK_TSTSEL, MT6328_PMIC_RG_FG_CK_TSTSEL_ADDR, MT6328_PMIC_RG_FG_CK_TSTSEL_MASK,
	 MT6328_PMIC_RG_FG_CK_TSTSEL_SHIFT},
	{PMIC_RG_FGADC_ANA_CK_TSTSEL, MT6328_PMIC_RG_FGADC_ANA_CK_TSTSEL_ADDR,
	 MT6328_PMIC_RG_FGADC_ANA_CK_TSTSEL_MASK, MT6328_PMIC_RG_FGADC_ANA_CK_TSTSEL_SHIFT},
	{PMIC_RG_SPK_CK_TSTSEL, MT6328_PMIC_RG_SPK_CK_TSTSEL_ADDR,
	 MT6328_PMIC_RG_SPK_CK_TSTSEL_MASK, MT6328_PMIC_RG_SPK_CK_TSTSEL_SHIFT},
	{PMIC_RG_RTC26M_CK_TSTSEL, MT6328_PMIC_RG_RTC26M_CK_TSTSEL_ADDR,
	 MT6328_PMIC_RG_RTC26M_CK_TSTSEL_MASK, MT6328_PMIC_RG_RTC26M_CK_TSTSEL_SHIFT},
	{PMIC_RG_RTC_EOSC32_CK_TSTSEL, MT6328_PMIC_RG_RTC_EOSC32_CK_TSTSEL_ADDR,
	 MT6328_PMIC_RG_RTC_EOSC32_CK_TSTSEL_MASK, MT6328_PMIC_RG_RTC_EOSC32_CK_TSTSEL_SHIFT},
	{PMIC_RG_EOSC_CALI_TEST_CK_TSTSEL, MT6328_PMIC_RG_EOSC_CALI_TEST_CK_TSTSEL_ADDR,
	 MT6328_PMIC_RG_EOSC_CALI_TEST_CK_TSTSEL_MASK,
	 MT6328_PMIC_RG_EOSC_CALI_TEST_CK_TSTSEL_SHIFT},
	{PMIC_RG_AUXADC_CK_TSTSEL, MT6328_PMIC_RG_AUXADC_CK_TSTSEL_ADDR,
	 MT6328_PMIC_RG_AUXADC_CK_TSTSEL_MASK, MT6328_PMIC_RG_AUXADC_CK_TSTSEL_SHIFT},
	{PMIC_RG_AUXADC_SMPS_CK_TSTSEL, MT6328_PMIC_RG_AUXADC_SMPS_CK_TSTSEL_ADDR,
	 MT6328_PMIC_RG_AUXADC_SMPS_CK_TSTSEL_MASK, MT6328_PMIC_RG_AUXADC_SMPS_CK_TSTSEL_SHIFT},
	{PMIC_RG_AUXADC_26M_CK_TSTSEL, MT6328_PMIC_RG_AUXADC_26M_CK_TSTSEL_ADDR,
	 MT6328_PMIC_RG_AUXADC_26M_CK_TSTSEL_MASK, MT6328_PMIC_RG_AUXADC_26M_CK_TSTSEL_SHIFT},
	{PMIC_TOP_CKTST_CON2_RSV, MT6328_PMIC_TOP_CKTST_CON2_RSV_ADDR,
	 MT6328_PMIC_TOP_CKTST_CON2_RSV_MASK, MT6328_PMIC_TOP_CKTST_CON2_RSV_SHIFT},
	{PMIC_RG_CLKSQ_EN_AUD, MT6328_PMIC_RG_CLKSQ_EN_AUD_ADDR, MT6328_PMIC_RG_CLKSQ_EN_AUD_MASK,
	 MT6328_PMIC_RG_CLKSQ_EN_AUD_SHIFT},
	{PMIC_RG_CLKSQ_EN_FQR, MT6328_PMIC_RG_CLKSQ_EN_FQR_ADDR, MT6328_PMIC_RG_CLKSQ_EN_FQR_MASK,
	 MT6328_PMIC_RG_CLKSQ_EN_FQR_SHIFT},
	{PMIC_RG_CLKSQ_EN_AUX_AP, MT6328_PMIC_RG_CLKSQ_EN_AUX_AP_ADDR,
	 MT6328_PMIC_RG_CLKSQ_EN_AUX_AP_MASK, MT6328_PMIC_RG_CLKSQ_EN_AUX_AP_SHIFT},
	{PMIC_RG_CLKSQ_EN_AUX_MD, MT6328_PMIC_RG_CLKSQ_EN_AUX_MD_ADDR,
	 MT6328_PMIC_RG_CLKSQ_EN_AUX_MD_MASK, MT6328_PMIC_RG_CLKSQ_EN_AUX_MD_SHIFT},
	{PMIC_RG_CLKSQ_EN_AUX_GPS, MT6328_PMIC_RG_CLKSQ_EN_AUX_GPS_ADDR,
	 MT6328_PMIC_RG_CLKSQ_EN_AUX_GPS_MASK, MT6328_PMIC_RG_CLKSQ_EN_AUX_GPS_SHIFT},
	{PMIC_RG_CLKSQ_EN_AUX_RSV, MT6328_PMIC_RG_CLKSQ_EN_AUX_RSV_ADDR,
	 MT6328_PMIC_RG_CLKSQ_EN_AUX_RSV_MASK, MT6328_PMIC_RG_CLKSQ_EN_AUX_RSV_SHIFT},
	{PMIC_RG_CLKSQ_EN_AUX_AP_MODE, MT6328_PMIC_RG_CLKSQ_EN_AUX_AP_MODE_ADDR,
	 MT6328_PMIC_RG_CLKSQ_EN_AUX_AP_MODE_MASK, MT6328_PMIC_RG_CLKSQ_EN_AUX_AP_MODE_SHIFT},
	{PMIC_RG_CLKSQ_EN_AUX_MD_MODE, MT6328_PMIC_RG_CLKSQ_EN_AUX_MD_MODE_ADDR,
	 MT6328_PMIC_RG_CLKSQ_EN_AUX_MD_MODE_MASK, MT6328_PMIC_RG_CLKSQ_EN_AUX_MD_MODE_SHIFT},
	{PMIC_TOP_CLKSQ_RSV, MT6328_PMIC_TOP_CLKSQ_RSV_ADDR, MT6328_PMIC_TOP_CLKSQ_RSV_MASK,
	 MT6328_PMIC_TOP_CLKSQ_RSV_SHIFT},
	{PMIC_DA_CLKSQ_EN_VA28, MT6328_PMIC_DA_CLKSQ_EN_VA28_ADDR,
	 MT6328_PMIC_DA_CLKSQ_EN_VA28_MASK, MT6328_PMIC_DA_CLKSQ_EN_VA28_SHIFT},
	{PMIC_TOP_CLKSQ_SET, MT6328_PMIC_TOP_CLKSQ_SET_ADDR, MT6328_PMIC_TOP_CLKSQ_SET_MASK,
	 MT6328_PMIC_TOP_CLKSQ_SET_SHIFT},
	{PMIC_TOP_CLKSQ_CLR, MT6328_PMIC_TOP_CLKSQ_CLR_ADDR, MT6328_PMIC_TOP_CLKSQ_CLR_MASK,
	 MT6328_PMIC_TOP_CLKSQ_CLR_SHIFT},
	{PMIC_RG_CLKSQ_RTC_EN, MT6328_PMIC_RG_CLKSQ_RTC_EN_ADDR, MT6328_PMIC_RG_CLKSQ_RTC_EN_MASK,
	 MT6328_PMIC_RG_CLKSQ_RTC_EN_SHIFT},
	{PMIC_RG_CLKSQ_RTC_EN_HW_MODE, MT6328_PMIC_RG_CLKSQ_RTC_EN_HW_MODE_ADDR,
	 MT6328_PMIC_RG_CLKSQ_RTC_EN_HW_MODE_MASK, MT6328_PMIC_RG_CLKSQ_RTC_EN_HW_MODE_SHIFT},
	{PMIC_TOP_CLKSQ_RTC_RSV0, MT6328_PMIC_TOP_CLKSQ_RTC_RSV0_ADDR,
	 MT6328_PMIC_TOP_CLKSQ_RTC_RSV0_MASK, MT6328_PMIC_TOP_CLKSQ_RTC_RSV0_SHIFT},
	{PMIC_RG_ENBB_SEL, MT6328_PMIC_RG_ENBB_SEL_ADDR, MT6328_PMIC_RG_ENBB_SEL_MASK,
	 MT6328_PMIC_RG_ENBB_SEL_SHIFT},
	{PMIC_RG_XOSC_EN_SEL, MT6328_PMIC_RG_XOSC_EN_SEL_ADDR, MT6328_PMIC_RG_XOSC_EN_SEL_MASK,
	 MT6328_PMIC_RG_XOSC_EN_SEL_SHIFT},
	{PMIC_TOP_CLKSQ_RTC_RSV1, MT6328_PMIC_TOP_CLKSQ_RTC_RSV1_ADDR,
	 MT6328_PMIC_TOP_CLKSQ_RTC_RSV1_MASK, MT6328_PMIC_TOP_CLKSQ_RTC_RSV1_SHIFT},
	{PMIC_DA_CLKSQ_EN_VDIG18, MT6328_PMIC_DA_CLKSQ_EN_VDIG18_ADDR,
	 MT6328_PMIC_DA_CLKSQ_EN_VDIG18_MASK, MT6328_PMIC_DA_CLKSQ_EN_VDIG18_SHIFT},
	{PMIC_TOP_CLKSQ_RTC_SET, MT6328_PMIC_TOP_CLKSQ_RTC_SET_ADDR,
	 MT6328_PMIC_TOP_CLKSQ_RTC_SET_MASK, MT6328_PMIC_TOP_CLKSQ_RTC_SET_SHIFT},
	{PMIC_TOP_CLKSQ_RTC_CLR, MT6328_PMIC_TOP_CLKSQ_RTC_CLR_ADDR,
	 MT6328_PMIC_TOP_CLKSQ_RTC_CLR_MASK, MT6328_PMIC_TOP_CLKSQ_RTC_CLR_SHIFT},
	{PMIC_OSC_75K_TRIM, MT6328_PMIC_OSC_75K_TRIM_ADDR, MT6328_PMIC_OSC_75K_TRIM_MASK,
	 MT6328_PMIC_OSC_75K_TRIM_SHIFT},
	{PMIC_RG_OSC_75K_TRIM_EN, MT6328_PMIC_RG_OSC_75K_TRIM_EN_ADDR,
	 MT6328_PMIC_RG_OSC_75K_TRIM_EN_MASK, MT6328_PMIC_RG_OSC_75K_TRIM_EN_SHIFT},
	{PMIC_RG_OSC_75K_TRIM_RATE, MT6328_PMIC_RG_OSC_75K_TRIM_RATE_ADDR,
	 MT6328_PMIC_RG_OSC_75K_TRIM_RATE_MASK, MT6328_PMIC_RG_OSC_75K_TRIM_RATE_SHIFT},
	{PMIC_RG_OSC_75K_TRIM, MT6328_PMIC_RG_OSC_75K_TRIM_ADDR, MT6328_PMIC_RG_OSC_75K_TRIM_MASK,
	 MT6328_PMIC_RG_OSC_75K_TRIM_SHIFT},
	{PMIC_RG_EFUSE_MAN_RST, MT6328_PMIC_RG_EFUSE_MAN_RST_ADDR,
	 MT6328_PMIC_RG_EFUSE_MAN_RST_MASK, MT6328_PMIC_RG_EFUSE_MAN_RST_SHIFT},
	{PMIC_RG_AUXADC_RST, MT6328_PMIC_RG_AUXADC_RST_ADDR, MT6328_PMIC_RG_AUXADC_RST_MASK,
	 MT6328_PMIC_RG_AUXADC_RST_SHIFT},
	{PMIC_RG_AUXADC_REG_RST, MT6328_PMIC_RG_AUXADC_REG_RST_ADDR,
	 MT6328_PMIC_RG_AUXADC_REG_RST_MASK, MT6328_PMIC_RG_AUXADC_REG_RST_SHIFT},
	{PMIC_RG_AUDIO_RST, MT6328_PMIC_RG_AUDIO_RST_ADDR, MT6328_PMIC_RG_AUDIO_RST_MASK,
	 MT6328_PMIC_RG_AUDIO_RST_SHIFT},
	{PMIC_RG_ACCDET_RST, MT6328_PMIC_RG_ACCDET_RST_ADDR, MT6328_PMIC_RG_ACCDET_RST_MASK,
	 MT6328_PMIC_RG_ACCDET_RST_SHIFT},
	{PMIC_RG_BIF_RST, MT6328_PMIC_RG_BIF_RST_ADDR, MT6328_PMIC_RG_BIF_RST_MASK,
	 MT6328_PMIC_RG_BIF_RST_SHIFT},
	{PMIC_RG_DRIVER_RST, MT6328_PMIC_RG_DRIVER_RST_ADDR, MT6328_PMIC_RG_DRIVER_RST_MASK,
	 MT6328_PMIC_RG_DRIVER_RST_SHIFT},
	{PMIC_RG_FGADC_RST, MT6328_PMIC_RG_FGADC_RST_ADDR, MT6328_PMIC_RG_FGADC_RST_MASK,
	 MT6328_PMIC_RG_FGADC_RST_SHIFT},
	{PMIC_RG_FQMTR_RST, MT6328_PMIC_RG_FQMTR_RST_ADDR, MT6328_PMIC_RG_FQMTR_RST_MASK,
	 MT6328_PMIC_RG_FQMTR_RST_SHIFT},
	{PMIC_RG_RTC_RST, MT6328_PMIC_RG_RTC_RST_ADDR, MT6328_PMIC_RG_RTC_RST_MASK,
	 MT6328_PMIC_RG_RTC_RST_SHIFT},
	{PMIC_RG_SPK_RST, MT6328_PMIC_RG_SPK_RST_ADDR, MT6328_PMIC_RG_SPK_RST_MASK,
	 MT6328_PMIC_RG_SPK_RST_SHIFT},
	{PMIC_RG_CHRWDT_RST, MT6328_PMIC_RG_CHRWDT_RST_ADDR, MT6328_PMIC_RG_CHRWDT_RST_MASK,
	 MT6328_PMIC_RG_CHRWDT_RST_SHIFT},
	{PMIC_RG_ZCD_RST, MT6328_PMIC_RG_ZCD_RST_ADDR, MT6328_PMIC_RG_ZCD_RST_MASK,
	 MT6328_PMIC_RG_ZCD_RST_SHIFT},
	{PMIC_RG_AUDNCP_RST, MT6328_PMIC_RG_AUDNCP_RST_ADDR, MT6328_PMIC_RG_AUDNCP_RST_MASK,
	 MT6328_PMIC_RG_AUDNCP_RST_SHIFT},
	{PMIC_RG_CLK_TRIM_RST, MT6328_PMIC_RG_CLK_TRIM_RST_ADDR, MT6328_PMIC_RG_CLK_TRIM_RST_MASK,
	 MT6328_PMIC_RG_CLK_TRIM_RST_SHIFT},
	{PMIC_TOP_RST_CON0_RSV, MT6328_PMIC_TOP_RST_CON0_RSV_ADDR,
	 MT6328_PMIC_TOP_RST_CON0_RSV_MASK, MT6328_PMIC_TOP_RST_CON0_RSV_SHIFT},
	{PMIC_TOP_RST_CON_SET, MT6328_PMIC_TOP_RST_CON_SET_ADDR, MT6328_PMIC_TOP_RST_CON_SET_MASK,
	 MT6328_PMIC_TOP_RST_CON_SET_SHIFT},
	{PMIC_TOP_RST_CON_CLR, MT6328_PMIC_TOP_RST_CON_CLR_ADDR, MT6328_PMIC_TOP_RST_CON_CLR_MASK,
	 MT6328_PMIC_TOP_RST_CON_CLR_SHIFT},
	{PMIC_RG_CHR_LDO_DET_MODE, MT6328_PMIC_RG_CHR_LDO_DET_MODE_ADDR,
	 MT6328_PMIC_RG_CHR_LDO_DET_MODE_MASK, MT6328_PMIC_RG_CHR_LDO_DET_MODE_SHIFT},
	{PMIC_RG_CHR_LDO_DET_SW, MT6328_PMIC_RG_CHR_LDO_DET_SW_ADDR,
	 MT6328_PMIC_RG_CHR_LDO_DET_SW_MASK, MT6328_PMIC_RG_CHR_LDO_DET_SW_SHIFT},
	{PMIC_RG_CHRWDT_FLAG_MODE, MT6328_PMIC_RG_CHRWDT_FLAG_MODE_ADDR,
	 MT6328_PMIC_RG_CHRWDT_FLAG_MODE_MASK, MT6328_PMIC_RG_CHRWDT_FLAG_MODE_SHIFT},
	{PMIC_RG_CHRWDT_FLAG_SW, MT6328_PMIC_RG_CHRWDT_FLAG_SW_ADDR,
	 MT6328_PMIC_RG_CHRWDT_FLAG_SW_MASK, MT6328_PMIC_RG_CHRWDT_FLAG_SW_SHIFT},
	{PMIC_TOP_RST_CON1_RSV, MT6328_PMIC_TOP_RST_CON1_RSV_ADDR,
	 MT6328_PMIC_TOP_RST_CON1_RSV_MASK, MT6328_PMIC_TOP_RST_CON1_RSV_SHIFT},
	{PMIC_RG_WDTRSTB_EN, MT6328_PMIC_RG_WDTRSTB_EN_ADDR, MT6328_PMIC_RG_WDTRSTB_EN_MASK,
	 MT6328_PMIC_RG_WDTRSTB_EN_SHIFT},
	{PMIC_RG_WDTRSTB_MODE, MT6328_PMIC_RG_WDTRSTB_MODE_ADDR, MT6328_PMIC_RG_WDTRSTB_MODE_MASK,
	 MT6328_PMIC_RG_WDTRSTB_MODE_SHIFT},
	{PMIC_WDTRSTB_STATUS, MT6328_PMIC_WDTRSTB_STATUS_ADDR, MT6328_PMIC_WDTRSTB_STATUS_MASK,
	 MT6328_PMIC_WDTRSTB_STATUS_SHIFT},
	{PMIC_WDTRSTB_STATUS_CLR, MT6328_PMIC_WDTRSTB_STATUS_CLR_ADDR,
	 MT6328_PMIC_WDTRSTB_STATUS_CLR_MASK, MT6328_PMIC_WDTRSTB_STATUS_CLR_SHIFT},
	{PMIC_RG_WDTRSTB_FB_EN, MT6328_PMIC_RG_WDTRSTB_FB_EN_ADDR,
	 MT6328_PMIC_RG_WDTRSTB_FB_EN_MASK, MT6328_PMIC_RG_WDTRSTB_FB_EN_SHIFT},
	{PMIC_RG_HOMEKEY_RST_EN, MT6328_PMIC_RG_HOMEKEY_RST_EN_ADDR,
	 MT6328_PMIC_RG_HOMEKEY_RST_EN_MASK, MT6328_PMIC_RG_HOMEKEY_RST_EN_SHIFT},
	{PMIC_RG_PWRKEY_RST_EN, MT6328_PMIC_RG_PWRKEY_RST_EN_ADDR,
	 MT6328_PMIC_RG_PWRKEY_RST_EN_MASK, MT6328_PMIC_RG_PWRKEY_RST_EN_SHIFT},
	{PMIC_RG_PWRRST_TMR_DIS, MT6328_PMIC_RG_PWRRST_TMR_DIS_ADDR,
	 MT6328_PMIC_RG_PWRRST_TMR_DIS_MASK, MT6328_PMIC_RG_PWRRST_TMR_DIS_SHIFT},
	{PMIC_RG_PWRKEY_RST_TD, MT6328_PMIC_RG_PWRKEY_RST_TD_ADDR,
	 MT6328_PMIC_RG_PWRKEY_RST_TD_MASK, MT6328_PMIC_RG_PWRKEY_RST_TD_SHIFT},
	{PMIC_TOP_RST_MISC_SET, MT6328_PMIC_TOP_RST_MISC_SET_ADDR,
	 MT6328_PMIC_TOP_RST_MISC_SET_MASK, MT6328_PMIC_TOP_RST_MISC_SET_SHIFT},
	{PMIC_TOP_RST_MISC_CLR, MT6328_PMIC_TOP_RST_MISC_CLR_ADDR,
	 MT6328_PMIC_TOP_RST_MISC_CLR_MASK, MT6328_PMIC_TOP_RST_MISC_CLR_SHIFT},
	{PMIC_VPWRIN_RSTB_STATUS, MT6328_PMIC_VPWRIN_RSTB_STATUS_ADDR,
	 MT6328_PMIC_VPWRIN_RSTB_STATUS_MASK, MT6328_PMIC_VPWRIN_RSTB_STATUS_SHIFT},
	{PMIC_DDLO_RSTB_STATUS, MT6328_PMIC_DDLO_RSTB_STATUS_ADDR,
	 MT6328_PMIC_DDLO_RSTB_STATUS_MASK, MT6328_PMIC_DDLO_RSTB_STATUS_SHIFT},
	{PMIC_UVLO_RSTB_STATUS, MT6328_PMIC_UVLO_RSTB_STATUS_ADDR,
	 MT6328_PMIC_UVLO_RSTB_STATUS_MASK, MT6328_PMIC_UVLO_RSTB_STATUS_SHIFT},
	{PMIC_RTC_DDLO_RSTB_STATUS, MT6328_PMIC_RTC_DDLO_RSTB_STATUS_ADDR,
	 MT6328_PMIC_RTC_DDLO_RSTB_STATUS_MASK, MT6328_PMIC_RTC_DDLO_RSTB_STATUS_SHIFT},
	{PMIC_CHRWDT_REG_RSTB_STATUS, MT6328_PMIC_CHRWDT_REG_RSTB_STATUS_ADDR,
	 MT6328_PMIC_CHRWDT_REG_RSTB_STATUS_MASK, MT6328_PMIC_CHRWDT_REG_RSTB_STATUS_SHIFT},
	{PMIC_CHRDET_REG_RSTB_STATUS, MT6328_PMIC_CHRDET_REG_RSTB_STATUS_ADDR,
	 MT6328_PMIC_CHRDET_REG_RSTB_STATUS_MASK, MT6328_PMIC_CHRDET_REG_RSTB_STATUS_SHIFT},
	{PMIC_TOP_RST_STATUS_RSV, MT6328_PMIC_TOP_RST_STATUS_RSV_ADDR,
	 MT6328_PMIC_TOP_RST_STATUS_RSV_MASK, MT6328_PMIC_TOP_RST_STATUS_RSV_SHIFT},
	{PMIC_TOP_RST_STATUS_SET, MT6328_PMIC_TOP_RST_STATUS_SET_ADDR,
	 MT6328_PMIC_TOP_RST_STATUS_SET_MASK, MT6328_PMIC_TOP_RST_STATUS_SET_SHIFT},
	{PMIC_TOP_RST_STATUS_CLR, MT6328_PMIC_TOP_RST_STATUS_CLR_ADDR,
	 MT6328_PMIC_TOP_RST_STATUS_CLR_MASK, MT6328_PMIC_TOP_RST_STATUS_CLR_SHIFT},
	{PMIC_RG_INT_EN_PWRKEY, MT6328_PMIC_RG_INT_EN_PWRKEY_ADDR,
	 MT6328_PMIC_RG_INT_EN_PWRKEY_MASK, MT6328_PMIC_RG_INT_EN_PWRKEY_SHIFT},
	{PMIC_RG_INT_EN_HOMEKEY, MT6328_PMIC_RG_INT_EN_HOMEKEY_ADDR,
	 MT6328_PMIC_RG_INT_EN_HOMEKEY_MASK, MT6328_PMIC_RG_INT_EN_HOMEKEY_SHIFT},
	{PMIC_RG_INT_EN_PWRKEY_R, MT6328_PMIC_RG_INT_EN_PWRKEY_R_ADDR,
	 MT6328_PMIC_RG_INT_EN_PWRKEY_R_MASK, MT6328_PMIC_RG_INT_EN_PWRKEY_R_SHIFT},
	{PMIC_RG_INT_EN_HOMEKEY_R, MT6328_PMIC_RG_INT_EN_HOMEKEY_R_ADDR,
	 MT6328_PMIC_RG_INT_EN_HOMEKEY_R_MASK, MT6328_PMIC_RG_INT_EN_HOMEKEY_R_SHIFT},
	{PMIC_RG_INT_EN_THR_H, MT6328_PMIC_RG_INT_EN_THR_H_ADDR, MT6328_PMIC_RG_INT_EN_THR_H_MASK,
	 MT6328_PMIC_RG_INT_EN_THR_H_SHIFT},
	{PMIC_RG_INT_EN_THR_L, MT6328_PMIC_RG_INT_EN_THR_L_ADDR, MT6328_PMIC_RG_INT_EN_THR_L_MASK,
	 MT6328_PMIC_RG_INT_EN_THR_L_SHIFT},
	{PMIC_RG_INT_EN_BAT_H, MT6328_PMIC_RG_INT_EN_BAT_H_ADDR, MT6328_PMIC_RG_INT_EN_BAT_H_MASK,
	 MT6328_PMIC_RG_INT_EN_BAT_H_SHIFT},
	{PMIC_RG_INT_EN_BAT_L, MT6328_PMIC_RG_INT_EN_BAT_L_ADDR, MT6328_PMIC_RG_INT_EN_BAT_L_MASK,
	 MT6328_PMIC_RG_INT_EN_BAT_L_SHIFT},
	{PMIC_RG_INT_EN_RTC, MT6328_PMIC_RG_INT_EN_RTC_ADDR, MT6328_PMIC_RG_INT_EN_RTC_MASK,
	 MT6328_PMIC_RG_INT_EN_RTC_SHIFT},
	{PMIC_RG_INT_EN_AUDIO, MT6328_PMIC_RG_INT_EN_AUDIO_ADDR, MT6328_PMIC_RG_INT_EN_AUDIO_MASK,
	 MT6328_PMIC_RG_INT_EN_AUDIO_SHIFT},
	{PMIC_RG_INT_EN_ACCDET, MT6328_PMIC_RG_INT_EN_ACCDET_ADDR,
	 MT6328_PMIC_RG_INT_EN_ACCDET_MASK, MT6328_PMIC_RG_INT_EN_ACCDET_SHIFT},
	{PMIC_RG_INT_EN_ACCDET_EINT, MT6328_PMIC_RG_INT_EN_ACCDET_EINT_ADDR,
	 MT6328_PMIC_RG_INT_EN_ACCDET_EINT_MASK, MT6328_PMIC_RG_INT_EN_ACCDET_EINT_SHIFT},
	{PMIC_RG_INT_EN_ACCDET_NEGV, MT6328_PMIC_RG_INT_EN_ACCDET_NEGV_ADDR,
	 MT6328_PMIC_RG_INT_EN_ACCDET_NEGV_MASK, MT6328_PMIC_RG_INT_EN_ACCDET_NEGV_SHIFT},
	{PMIC_RG_INT_EN_NI_LBAT_INT, MT6328_PMIC_RG_INT_EN_NI_LBAT_INT_ADDR,
	 MT6328_PMIC_RG_INT_EN_NI_LBAT_INT_MASK, MT6328_PMIC_RG_INT_EN_NI_LBAT_INT_SHIFT},
	{PMIC_INT_CON0_SET, MT6328_PMIC_INT_CON0_SET_ADDR, MT6328_PMIC_INT_CON0_SET_MASK,
	 MT6328_PMIC_INT_CON0_SET_SHIFT},
	{PMIC_INT_CON0_CLR, MT6328_PMIC_INT_CON0_CLR_ADDR, MT6328_PMIC_INT_CON0_CLR_MASK,
	 MT6328_PMIC_INT_CON0_CLR_SHIFT},
	{PMIC_RG_INT_EN_VPROC_OC, MT6328_PMIC_RG_INT_EN_VPROC_OC_ADDR,
	 MT6328_PMIC_RG_INT_EN_VPROC_OC_MASK, MT6328_PMIC_RG_INT_EN_VPROC_OC_SHIFT},
	{PMIC_RG_INT_EN_VSYS_OC, MT6328_PMIC_RG_INT_EN_VSYS_OC_ADDR,
	 MT6328_PMIC_RG_INT_EN_VSYS_OC_MASK, MT6328_PMIC_RG_INT_EN_VSYS_OC_SHIFT},
	{PMIC_RG_INT_EN_VLTE_OC, MT6328_PMIC_RG_INT_EN_VLTE_OC_ADDR,
	 MT6328_PMIC_RG_INT_EN_VLTE_OC_MASK, MT6328_PMIC_RG_INT_EN_VLTE_OC_SHIFT},
	{PMIC_RG_INT_EN_VCORE_OC, MT6328_PMIC_RG_INT_EN_VCORE_OC_ADDR,
	 MT6328_PMIC_RG_INT_EN_VCORE_OC_MASK, MT6328_PMIC_RG_INT_EN_VCORE_OC_SHIFT},
	{PMIC_RG_INT_EN_VPA_OC, MT6328_PMIC_RG_INT_EN_VPA_OC_ADDR,
	 MT6328_PMIC_RG_INT_EN_VPA_OC_MASK, MT6328_PMIC_RG_INT_EN_VPA_OC_SHIFT},
	{PMIC_RG_INT_EN_LDO_OC, MT6328_PMIC_RG_INT_EN_LDO_OC_ADDR,
	 MT6328_PMIC_RG_INT_EN_LDO_OC_MASK, MT6328_PMIC_RG_INT_EN_LDO_OC_SHIFT},
	{PMIC_RG_INT_EN_BAT2_H, MT6328_PMIC_RG_INT_EN_BAT2_H_ADDR,
	 MT6328_PMIC_RG_INT_EN_BAT2_H_MASK, MT6328_PMIC_RG_INT_EN_BAT2_H_SHIFT},
	{PMIC_RG_INT_EN_BAT2_L, MT6328_PMIC_RG_INT_EN_BAT2_L_ADDR,
	 MT6328_PMIC_RG_INT_EN_BAT2_L_MASK, MT6328_PMIC_RG_INT_EN_BAT2_L_SHIFT},
	{PMIC_RG_INT_EN_VISMPS0_H, MT6328_PMIC_RG_INT_EN_VISMPS0_H_ADDR,
	 MT6328_PMIC_RG_INT_EN_VISMPS0_H_MASK, MT6328_PMIC_RG_INT_EN_VISMPS0_H_SHIFT},
	{PMIC_RG_INT_EN_VISMPS0_L, MT6328_PMIC_RG_INT_EN_VISMPS0_L_ADDR,
	 MT6328_PMIC_RG_INT_EN_VISMPS0_L_MASK, MT6328_PMIC_RG_INT_EN_VISMPS0_L_SHIFT},
	{PMIC_RG_INT_EN_AUXADC_IMP, MT6328_PMIC_RG_INT_EN_AUXADC_IMP_ADDR,
	 MT6328_PMIC_RG_INT_EN_AUXADC_IMP_MASK, MT6328_PMIC_RG_INT_EN_AUXADC_IMP_SHIFT},
	{PMIC_INT_CON1_SET, MT6328_PMIC_INT_CON1_SET_ADDR, MT6328_PMIC_INT_CON1_SET_MASK,
	 MT6328_PMIC_INT_CON1_SET_SHIFT},
	{PMIC_INT_CON1_CLR, MT6328_PMIC_INT_CON1_CLR_ADDR, MT6328_PMIC_INT_CON1_CLR_MASK,
	 MT6328_PMIC_INT_CON1_CLR_SHIFT},
	{PMIC_RG_INT_EN_OV, MT6328_PMIC_RG_INT_EN_OV_ADDR, MT6328_PMIC_RG_INT_EN_OV_MASK,
	 MT6328_PMIC_RG_INT_EN_OV_SHIFT},
	{PMIC_RG_INT_EN_BVALID_DET, MT6328_PMIC_RG_INT_EN_BVALID_DET_ADDR,
	 MT6328_PMIC_RG_INT_EN_BVALID_DET_MASK, MT6328_PMIC_RG_INT_EN_BVALID_DET_SHIFT},
	{PMIC_RG_INT_EN_VBATON_HV, MT6328_PMIC_RG_INT_EN_VBATON_HV_ADDR,
	 MT6328_PMIC_RG_INT_EN_VBATON_HV_MASK, MT6328_PMIC_RG_INT_EN_VBATON_HV_SHIFT},
	{PMIC_RG_INT_EN_VBATON_UNDET, MT6328_PMIC_RG_INT_EN_VBATON_UNDET_ADDR,
	 MT6328_PMIC_RG_INT_EN_VBATON_UNDET_MASK, MT6328_PMIC_RG_INT_EN_VBATON_UNDET_SHIFT},
	{PMIC_RG_INT_EN_WATCHDOG, MT6328_PMIC_RG_INT_EN_WATCHDOG_ADDR,
	 MT6328_PMIC_RG_INT_EN_WATCHDOG_MASK, MT6328_PMIC_RG_INT_EN_WATCHDOG_SHIFT},
	{PMIC_RG_INT_EN_PCHR_CM_VDEC, MT6328_PMIC_RG_INT_EN_PCHR_CM_VDEC_ADDR,
	 MT6328_PMIC_RG_INT_EN_PCHR_CM_VDEC_MASK, MT6328_PMIC_RG_INT_EN_PCHR_CM_VDEC_SHIFT},
	{PMIC_RG_INT_EN_CHRDET, MT6328_PMIC_RG_INT_EN_CHRDET_ADDR,
	 MT6328_PMIC_RG_INT_EN_CHRDET_MASK, MT6328_PMIC_RG_INT_EN_CHRDET_SHIFT},
	{PMIC_RG_INT_EN_PCHR_CM_VINC, MT6328_PMIC_RG_INT_EN_PCHR_CM_VINC_ADDR,
	 MT6328_PMIC_RG_INT_EN_PCHR_CM_VINC_MASK, MT6328_PMIC_RG_INT_EN_PCHR_CM_VINC_SHIFT},
	{PMIC_RG_INT_EN_FG_BAT_H, MT6328_PMIC_RG_INT_EN_FG_BAT_H_ADDR,
	 MT6328_PMIC_RG_INT_EN_FG_BAT_H_MASK, MT6328_PMIC_RG_INT_EN_FG_BAT_H_SHIFT},
	{PMIC_RG_INT_EN_FG_BAT_L, MT6328_PMIC_RG_INT_EN_FG_BAT_L_ADDR,
	 MT6328_PMIC_RG_INT_EN_FG_BAT_L_MASK, MT6328_PMIC_RG_INT_EN_FG_BAT_L_SHIFT},
	{PMIC_RG_INT_EN_FG_CUR_H, MT6328_PMIC_RG_INT_EN_FG_CUR_H_ADDR,
	 MT6328_PMIC_RG_INT_EN_FG_CUR_H_MASK, MT6328_PMIC_RG_INT_EN_FG_CUR_H_SHIFT},
	{PMIC_RG_INT_EN_FG_CUR_L, MT6328_PMIC_RG_INT_EN_FG_CUR_L_ADDR,
	 MT6328_PMIC_RG_INT_EN_FG_CUR_L_MASK, MT6328_PMIC_RG_INT_EN_FG_CUR_L_SHIFT},
	{PMIC_RG_INT_EN_FG_ZCV, MT6328_PMIC_RG_INT_EN_FG_ZCV_ADDR,
	 MT6328_PMIC_RG_INT_EN_FG_ZCV_MASK, MT6328_PMIC_RG_INT_EN_FG_ZCV_SHIFT},
	{PMIC_RG_INT_EN_SPKL_D, MT6328_PMIC_RG_INT_EN_SPKL_D_ADDR,
	 MT6328_PMIC_RG_INT_EN_SPKL_D_MASK, MT6328_PMIC_RG_INT_EN_SPKL_D_SHIFT},
	{PMIC_RG_INT_EN_SPKL_AB, MT6328_PMIC_RG_INT_EN_SPKL_AB_ADDR,
	 MT6328_PMIC_RG_INT_EN_SPKL_AB_MASK, MT6328_PMIC_RG_INT_EN_SPKL_AB_SHIFT},
	{PMIC_INT_CON2_SET, MT6328_PMIC_INT_CON2_SET_ADDR, MT6328_PMIC_INT_CON2_SET_MASK,
	 MT6328_PMIC_INT_CON2_SET_SHIFT},
	{PMIC_INT_CON2_CLR, MT6328_PMIC_INT_CON2_CLR_ADDR, MT6328_PMIC_INT_CON2_CLR_MASK,
	 MT6328_PMIC_INT_CON2_CLR_SHIFT},
	{PMIC_POLARITY, MT6328_PMIC_POLARITY_ADDR, MT6328_PMIC_POLARITY_MASK,
	 MT6328_PMIC_POLARITY_SHIFT},
	{PMIC_RG_HOMEKEY_INT_SEL, MT6328_PMIC_RG_HOMEKEY_INT_SEL_ADDR,
	 MT6328_PMIC_RG_HOMEKEY_INT_SEL_MASK, MT6328_PMIC_RG_HOMEKEY_INT_SEL_SHIFT},
	{PMIC_RG_PWRKEY_INT_SEL, MT6328_PMIC_RG_PWRKEY_INT_SEL_ADDR,
	 MT6328_PMIC_RG_PWRKEY_INT_SEL_MASK, MT6328_PMIC_RG_PWRKEY_INT_SEL_SHIFT},
	{PMIC_RG_CHRDET_INT_SEL, MT6328_PMIC_RG_CHRDET_INT_SEL_ADDR,
	 MT6328_PMIC_RG_CHRDET_INT_SEL_MASK, MT6328_PMIC_RG_CHRDET_INT_SEL_SHIFT},
	{PMIC_RG_PCHR_CM_VINC_POLARITY_RSV, MT6328_PMIC_RG_PCHR_CM_VINC_POLARITY_RSV_ADDR,
	 MT6328_PMIC_RG_PCHR_CM_VINC_POLARITY_RSV_MASK,
	 MT6328_PMIC_RG_PCHR_CM_VINC_POLARITY_RSV_SHIFT},
	{PMIC_RG_PCHR_CM_VDEC_POLARITY_RSV, MT6328_PMIC_RG_PCHR_CM_VDEC_POLARITY_RSV_ADDR,
	 MT6328_PMIC_RG_PCHR_CM_VDEC_POLARITY_RSV_MASK,
	 MT6328_PMIC_RG_PCHR_CM_VDEC_POLARITY_RSV_SHIFT},
	{PMIC_INT_MISC_CON_SET, MT6328_PMIC_INT_MISC_CON_SET_ADDR,
	 MT6328_PMIC_INT_MISC_CON_SET_MASK, MT6328_PMIC_INT_MISC_CON_SET_SHIFT},
	{PMIC_INT_MISC_CON_CLR, MT6328_PMIC_INT_MISC_CON_CLR_ADDR,
	 MT6328_PMIC_INT_MISC_CON_CLR_MASK, MT6328_PMIC_INT_MISC_CON_CLR_SHIFT},
	{PMIC_RG_INT_STATUS_PWRKEY, MT6328_PMIC_RG_INT_STATUS_PWRKEY_ADDR,
	 MT6328_PMIC_RG_INT_STATUS_PWRKEY_MASK, MT6328_PMIC_RG_INT_STATUS_PWRKEY_SHIFT},
	{PMIC_RG_INT_STATUS_HOMEKEY, MT6328_PMIC_RG_INT_STATUS_HOMEKEY_ADDR,
	 MT6328_PMIC_RG_INT_STATUS_HOMEKEY_MASK, MT6328_PMIC_RG_INT_STATUS_HOMEKEY_SHIFT},
	{PMIC_RG_INT_STATUS_PWRKEY_R, MT6328_PMIC_RG_INT_STATUS_PWRKEY_R_ADDR,
	 MT6328_PMIC_RG_INT_STATUS_PWRKEY_R_MASK, MT6328_PMIC_RG_INT_STATUS_PWRKEY_R_SHIFT},
	{PMIC_RG_INT_STATUS_HOMEKEY_R, MT6328_PMIC_RG_INT_STATUS_HOMEKEY_R_ADDR,
	 MT6328_PMIC_RG_INT_STATUS_HOMEKEY_R_MASK, MT6328_PMIC_RG_INT_STATUS_HOMEKEY_R_SHIFT},
	{PMIC_RG_INT_STATUS_THR_H, MT6328_PMIC_RG_INT_STATUS_THR_H_ADDR,
	 MT6328_PMIC_RG_INT_STATUS_THR_H_MASK, MT6328_PMIC_RG_INT_STATUS_THR_H_SHIFT},
	{PMIC_RG_INT_STATUS_THR_L, MT6328_PMIC_RG_INT_STATUS_THR_L_ADDR,
	 MT6328_PMIC_RG_INT_STATUS_THR_L_MASK, MT6328_PMIC_RG_INT_STATUS_THR_L_SHIFT},
	{PMIC_RG_INT_STATUS_BAT_H, MT6328_PMIC_RG_INT_STATUS_BAT_H_ADDR,
	 MT6328_PMIC_RG_INT_STATUS_BAT_H_MASK, MT6328_PMIC_RG_INT_STATUS_BAT_H_SHIFT},
	{PMIC_RG_INT_STATUS_BAT_L, MT6328_PMIC_RG_INT_STATUS_BAT_L_ADDR,
	 MT6328_PMIC_RG_INT_STATUS_BAT_L_MASK, MT6328_PMIC_RG_INT_STATUS_BAT_L_SHIFT},
	{PMIC_RG_INT_STATUS_RTC, MT6328_PMIC_RG_INT_STATUS_RTC_ADDR,
	 MT6328_PMIC_RG_INT_STATUS_RTC_MASK, MT6328_PMIC_RG_INT_STATUS_RTC_SHIFT},
	{PMIC_RG_INT_STATUS_AUDIO, MT6328_PMIC_RG_INT_STATUS_AUDIO_ADDR,
	 MT6328_PMIC_RG_INT_STATUS_AUDIO_MASK, MT6328_PMIC_RG_INT_STATUS_AUDIO_SHIFT},
	{PMIC_RG_INT_STATUS_ACCDET, MT6328_PMIC_RG_INT_STATUS_ACCDET_ADDR,
	 MT6328_PMIC_RG_INT_STATUS_ACCDET_MASK, MT6328_PMIC_RG_INT_STATUS_ACCDET_SHIFT},
	{PMIC_RG_INT_STATUS_ACCDET_EINT, MT6328_PMIC_RG_INT_STATUS_ACCDET_EINT_ADDR,
	 MT6328_PMIC_RG_INT_STATUS_ACCDET_EINT_MASK, MT6328_PMIC_RG_INT_STATUS_ACCDET_EINT_SHIFT},
	{PMIC_RG_INT_STATUS_ACCDET_NEGV, MT6328_PMIC_RG_INT_STATUS_ACCDET_NEGV_ADDR,
	 MT6328_PMIC_RG_INT_STATUS_ACCDET_NEGV_MASK, MT6328_PMIC_RG_INT_STATUS_ACCDET_NEGV_SHIFT},
	{PMIC_RG_INT_STATUS_NI_LBAT_INT, MT6328_PMIC_RG_INT_STATUS_NI_LBAT_INT_ADDR,
	 MT6328_PMIC_RG_INT_STATUS_NI_LBAT_INT_MASK, MT6328_PMIC_RG_INT_STATUS_NI_LBAT_INT_SHIFT},
	{PMIC_RG_INT_STATUS_VPROC_OC, MT6328_PMIC_RG_INT_STATUS_VPROC_OC_ADDR,
	 MT6328_PMIC_RG_INT_STATUS_VPROC_OC_MASK, MT6328_PMIC_RG_INT_STATUS_VPROC_OC_SHIFT},
	{PMIC_RG_INT_STATUS_VSYS_OC, MT6328_PMIC_RG_INT_STATUS_VSYS_OC_ADDR,
	 MT6328_PMIC_RG_INT_STATUS_VSYS_OC_MASK, MT6328_PMIC_RG_INT_STATUS_VSYS_OC_SHIFT},
	{PMIC_RG_INT_STATUS_VLTE_OC, MT6328_PMIC_RG_INT_STATUS_VLTE_OC_ADDR,
	 MT6328_PMIC_RG_INT_STATUS_VLTE_OC_MASK, MT6328_PMIC_RG_INT_STATUS_VLTE_OC_SHIFT},
	{PMIC_RG_INT_STATUS_VCORE_OC, MT6328_PMIC_RG_INT_STATUS_VCORE_OC_ADDR,
	 MT6328_PMIC_RG_INT_STATUS_VCORE_OC_MASK, MT6328_PMIC_RG_INT_STATUS_VCORE_OC_SHIFT},
	{PMIC_RG_INT_STATUS_VPA_OC, MT6328_PMIC_RG_INT_STATUS_VPA_OC_ADDR,
	 MT6328_PMIC_RG_INT_STATUS_VPA_OC_MASK, MT6328_PMIC_RG_INT_STATUS_VPA_OC_SHIFT},
	{PMIC_RG_INT_STATUS_LDO_OC, MT6328_PMIC_RG_INT_STATUS_LDO_OC_ADDR,
	 MT6328_PMIC_RG_INT_STATUS_LDO_OC_MASK, MT6328_PMIC_RG_INT_STATUS_LDO_OC_SHIFT},
	{PMIC_RG_INT_STATUS_BAT2_H, MT6328_PMIC_RG_INT_STATUS_BAT2_H_ADDR,
	 MT6328_PMIC_RG_INT_STATUS_BAT2_H_MASK, MT6328_PMIC_RG_INT_STATUS_BAT2_H_SHIFT},
	{PMIC_RG_INT_STATUS_BAT2_L, MT6328_PMIC_RG_INT_STATUS_BAT2_L_ADDR,
	 MT6328_PMIC_RG_INT_STATUS_BAT2_L_MASK, MT6328_PMIC_RG_INT_STATUS_BAT2_L_SHIFT},
	{PMIC_RG_INT_STATUS_VISMPS0_H, MT6328_PMIC_RG_INT_STATUS_VISMPS0_H_ADDR,
	 MT6328_PMIC_RG_INT_STATUS_VISMPS0_H_MASK, MT6328_PMIC_RG_INT_STATUS_VISMPS0_H_SHIFT},
	{PMIC_RG_INT_STATUS_VISMPS0_L, MT6328_PMIC_RG_INT_STATUS_VISMPS0_L_ADDR,
	 MT6328_PMIC_RG_INT_STATUS_VISMPS0_L_MASK, MT6328_PMIC_RG_INT_STATUS_VISMPS0_L_SHIFT},
	{PMIC_RG_INT_STATUS_AUXADC_IMP, MT6328_PMIC_RG_INT_STATUS_AUXADC_IMP_ADDR,
	 MT6328_PMIC_RG_INT_STATUS_AUXADC_IMP_MASK, MT6328_PMIC_RG_INT_STATUS_AUXADC_IMP_SHIFT},
	{PMIC_RG_INT_STATUS_OV, MT6328_PMIC_RG_INT_STATUS_OV_ADDR,
	 MT6328_PMIC_RG_INT_STATUS_OV_MASK, MT6328_PMIC_RG_INT_STATUS_OV_SHIFT},
	{PMIC_RG_INT_STATUS_BVALID_DET, MT6328_PMIC_RG_INT_STATUS_BVALID_DET_ADDR,
	 MT6328_PMIC_RG_INT_STATUS_BVALID_DET_MASK, MT6328_PMIC_RG_INT_STATUS_BVALID_DET_SHIFT},
	{PMIC_RG_INT_STATUS_VBATON_HV, MT6328_PMIC_RG_INT_STATUS_VBATON_HV_ADDR,
	 MT6328_PMIC_RG_INT_STATUS_VBATON_HV_MASK, MT6328_PMIC_RG_INT_STATUS_VBATON_HV_SHIFT},
	{PMIC_RG_INT_STATUS_VBATON_UNDET, MT6328_PMIC_RG_INT_STATUS_VBATON_UNDET_ADDR,
	 MT6328_PMIC_RG_INT_STATUS_VBATON_UNDET_MASK, MT6328_PMIC_RG_INT_STATUS_VBATON_UNDET_SHIFT},
	{PMIC_RG_INT_STATUS_WATCHDOG, MT6328_PMIC_RG_INT_STATUS_WATCHDOG_ADDR,
	 MT6328_PMIC_RG_INT_STATUS_WATCHDOG_MASK, MT6328_PMIC_RG_INT_STATUS_WATCHDOG_SHIFT},
	{PMIC_RG_INT_STATUS_PCHR_CM_VDEC, MT6328_PMIC_RG_INT_STATUS_PCHR_CM_VDEC_ADDR,
	 MT6328_PMIC_RG_INT_STATUS_PCHR_CM_VDEC_MASK, MT6328_PMIC_RG_INT_STATUS_PCHR_CM_VDEC_SHIFT},
	{PMIC_RG_INT_STATUS_CHRDET, MT6328_PMIC_RG_INT_STATUS_CHRDET_ADDR,
	 MT6328_PMIC_RG_INT_STATUS_CHRDET_MASK, MT6328_PMIC_RG_INT_STATUS_CHRDET_SHIFT},
	{PMIC_RG_INT_STATUS_PCHR_CM_VINC, MT6328_PMIC_RG_INT_STATUS_PCHR_CM_VINC_ADDR,
	 MT6328_PMIC_RG_INT_STATUS_PCHR_CM_VINC_MASK, MT6328_PMIC_RG_INT_STATUS_PCHR_CM_VINC_SHIFT},
	{PMIC_RG_INT_STATUS_FG_BAT_H, MT6328_PMIC_RG_INT_STATUS_FG_BAT_H_ADDR,
	 MT6328_PMIC_RG_INT_STATUS_FG_BAT_H_MASK, MT6328_PMIC_RG_INT_STATUS_FG_BAT_H_SHIFT},
	{PMIC_RG_INT_STATUS_FG_BAT_L, MT6328_PMIC_RG_INT_STATUS_FG_BAT_L_ADDR,
	 MT6328_PMIC_RG_INT_STATUS_FG_BAT_L_MASK, MT6328_PMIC_RG_INT_STATUS_FG_BAT_L_SHIFT},
	{PMIC_RG_INT_STATUS_FG_CUR_H, MT6328_PMIC_RG_INT_STATUS_FG_CUR_H_ADDR,
	 MT6328_PMIC_RG_INT_STATUS_FG_CUR_H_MASK, MT6328_PMIC_RG_INT_STATUS_FG_CUR_H_SHIFT},
	{PMIC_RG_INT_STATUS_FG_CUR_L, MT6328_PMIC_RG_INT_STATUS_FG_CUR_L_ADDR,
	 MT6328_PMIC_RG_INT_STATUS_FG_CUR_L_MASK, MT6328_PMIC_RG_INT_STATUS_FG_CUR_L_SHIFT},
	{PMIC_RG_INT_STATUS_FG_ZCV, MT6328_PMIC_RG_INT_STATUS_FG_ZCV_ADDR,
	 MT6328_PMIC_RG_INT_STATUS_FG_ZCV_MASK, MT6328_PMIC_RG_INT_STATUS_FG_ZCV_SHIFT},
	{PMIC_RG_INT_STATUS_SPKL_D, MT6328_PMIC_RG_INT_STATUS_SPKL_D_ADDR,
	 MT6328_PMIC_RG_INT_STATUS_SPKL_D_MASK, MT6328_PMIC_RG_INT_STATUS_SPKL_D_SHIFT},
	{PMIC_RG_INT_STATUS_SPKL_AB, MT6328_PMIC_RG_INT_STATUS_SPKL_AB_ADDR,
	 MT6328_PMIC_RG_INT_STATUS_SPKL_AB_MASK, MT6328_PMIC_RG_INT_STATUS_SPKL_AB_SHIFT},
	{PMIC_OC_GEAR_LDO, MT6328_PMIC_OC_GEAR_LDO_ADDR, MT6328_PMIC_OC_GEAR_LDO_MASK,
	 MT6328_PMIC_OC_GEAR_LDO_SHIFT},
	{PMIC_FQMTR_TCKSEL, MT6328_PMIC_FQMTR_TCKSEL_ADDR, MT6328_PMIC_FQMTR_TCKSEL_MASK,
	 MT6328_PMIC_FQMTR_TCKSEL_SHIFT},
	{PMIC_FQMTR_BUSY, MT6328_PMIC_FQMTR_BUSY_ADDR, MT6328_PMIC_FQMTR_BUSY_MASK,
	 MT6328_PMIC_FQMTR_BUSY_SHIFT},
	{PMIC_FQMTR_EN, MT6328_PMIC_FQMTR_EN_ADDR, MT6328_PMIC_FQMTR_EN_MASK,
	 MT6328_PMIC_FQMTR_EN_SHIFT},
	{PMIC_FQMTR_WINSET, MT6328_PMIC_FQMTR_WINSET_ADDR, MT6328_PMIC_FQMTR_WINSET_MASK,
	 MT6328_PMIC_FQMTR_WINSET_SHIFT},
	{PMIC_FQMTR_DATA, MT6328_PMIC_FQMTR_DATA_ADDR, MT6328_PMIC_FQMTR_DATA_MASK,
	 MT6328_PMIC_FQMTR_DATA_SHIFT},
	{PMIC_RG_SLP_RW_EN, MT6328_PMIC_RG_SLP_RW_EN_ADDR, MT6328_PMIC_RG_SLP_RW_EN_MASK,
	 MT6328_PMIC_RG_SLP_RW_EN_SHIFT},
	{PMIC_RG_SPI_RSV, MT6328_PMIC_RG_SPI_RSV_ADDR, MT6328_PMIC_RG_SPI_RSV_MASK,
	 MT6328_PMIC_RG_SPI_RSV_SHIFT},
	{PMIC_DEW_DIO_EN, MT6328_PMIC_DEW_DIO_EN_ADDR, MT6328_PMIC_DEW_DIO_EN_MASK,
	 MT6328_PMIC_DEW_DIO_EN_SHIFT},
	{PMIC_DEW_READ_TEST, MT6328_PMIC_DEW_READ_TEST_ADDR, MT6328_PMIC_DEW_READ_TEST_MASK,
	 MT6328_PMIC_DEW_READ_TEST_SHIFT},
	{PMIC_DEW_WRITE_TEST, MT6328_PMIC_DEW_WRITE_TEST_ADDR, MT6328_PMIC_DEW_WRITE_TEST_MASK,
	 MT6328_PMIC_DEW_WRITE_TEST_SHIFT},
	{PMIC_DEW_CRC_SWRST, MT6328_PMIC_DEW_CRC_SWRST_ADDR, MT6328_PMIC_DEW_CRC_SWRST_MASK,
	 MT6328_PMIC_DEW_CRC_SWRST_SHIFT},
	{PMIC_DEW_CRC_EN, MT6328_PMIC_DEW_CRC_EN_ADDR, MT6328_PMIC_DEW_CRC_EN_MASK,
	 MT6328_PMIC_DEW_CRC_EN_SHIFT},
	{PMIC_DEW_CRC_VAL, MT6328_PMIC_DEW_CRC_VAL_ADDR, MT6328_PMIC_DEW_CRC_VAL_MASK,
	 MT6328_PMIC_DEW_CRC_VAL_SHIFT},
	{PMIC_DEW_DBG_MON_SEL, MT6328_PMIC_DEW_DBG_MON_SEL_ADDR, MT6328_PMIC_DEW_DBG_MON_SEL_MASK,
	 MT6328_PMIC_DEW_DBG_MON_SEL_SHIFT},
	{PMIC_DEW_CIPHER_KEY_SEL, MT6328_PMIC_DEW_CIPHER_KEY_SEL_ADDR,
	 MT6328_PMIC_DEW_CIPHER_KEY_SEL_MASK, MT6328_PMIC_DEW_CIPHER_KEY_SEL_SHIFT},
	{PMIC_DEW_CIPHER_IV_SEL, MT6328_PMIC_DEW_CIPHER_IV_SEL_ADDR,
	 MT6328_PMIC_DEW_CIPHER_IV_SEL_MASK, MT6328_PMIC_DEW_CIPHER_IV_SEL_SHIFT},
	{PMIC_DEW_CIPHER_EN, MT6328_PMIC_DEW_CIPHER_EN_ADDR, MT6328_PMIC_DEW_CIPHER_EN_MASK,
	 MT6328_PMIC_DEW_CIPHER_EN_SHIFT},
	{PMIC_DEW_CIPHER_RDY, MT6328_PMIC_DEW_CIPHER_RDY_ADDR, MT6328_PMIC_DEW_CIPHER_RDY_MASK,
	 MT6328_PMIC_DEW_CIPHER_RDY_SHIFT},
	{PMIC_DEW_CIPHER_MODE, MT6328_PMIC_DEW_CIPHER_MODE_ADDR, MT6328_PMIC_DEW_CIPHER_MODE_MASK,
	 MT6328_PMIC_DEW_CIPHER_MODE_SHIFT},
	{PMIC_DEW_CIPHER_SWRST, MT6328_PMIC_DEW_CIPHER_SWRST_ADDR,
	 MT6328_PMIC_DEW_CIPHER_SWRST_MASK, MT6328_PMIC_DEW_CIPHER_SWRST_SHIFT},
	{PMIC_DEW_RDDMY_NO, MT6328_PMIC_DEW_RDDMY_NO_ADDR, MT6328_PMIC_DEW_RDDMY_NO_MASK,
	 MT6328_PMIC_DEW_RDDMY_NO_SHIFT},
	{PMIC_INT_TYPE_CON0, MT6328_PMIC_INT_TYPE_CON0_ADDR, MT6328_PMIC_INT_TYPE_CON0_MASK,
	 MT6328_PMIC_INT_TYPE_CON0_SHIFT},
	{PMIC_INT_TYPE_CON0_SET, MT6328_PMIC_INT_TYPE_CON0_SET_ADDR,
	 MT6328_PMIC_INT_TYPE_CON0_SET_MASK, MT6328_PMIC_INT_TYPE_CON0_SET_SHIFT},
	{PMIC_INT_TYPE_CON0_CLR, MT6328_PMIC_INT_TYPE_CON0_CLR_ADDR,
	 MT6328_PMIC_INT_TYPE_CON0_CLR_MASK, MT6328_PMIC_INT_TYPE_CON0_CLR_SHIFT},
	{PMIC_INT_TYPE_CON1, MT6328_PMIC_INT_TYPE_CON1_ADDR, MT6328_PMIC_INT_TYPE_CON1_MASK,
	 MT6328_PMIC_INT_TYPE_CON1_SHIFT},
	{PMIC_INT_TYPE_CON1_SET, MT6328_PMIC_INT_TYPE_CON1_SET_ADDR,
	 MT6328_PMIC_INT_TYPE_CON1_SET_MASK, MT6328_PMIC_INT_TYPE_CON1_SET_SHIFT},
	{PMIC_INT_TYPE_CON1_CLR, MT6328_PMIC_INT_TYPE_CON1_CLR_ADDR,
	 MT6328_PMIC_INT_TYPE_CON1_CLR_MASK, MT6328_PMIC_INT_TYPE_CON1_CLR_SHIFT},
	{PMIC_INT_TYPE_CON2, MT6328_PMIC_INT_TYPE_CON2_ADDR, MT6328_PMIC_INT_TYPE_CON2_MASK,
	 MT6328_PMIC_INT_TYPE_CON2_SHIFT},
	{PMIC_INT_TYPE_CON2_SET, MT6328_PMIC_INT_TYPE_CON2_SET_ADDR,
	 MT6328_PMIC_INT_TYPE_CON2_SET_MASK, MT6328_PMIC_INT_TYPE_CON2_SET_SHIFT},
	{PMIC_INT_TYPE_CON2_CLR, MT6328_PMIC_INT_TYPE_CON2_CLR_ADDR,
	 MT6328_PMIC_INT_TYPE_CON2_CLR_MASK, MT6328_PMIC_INT_TYPE_CON2_CLR_SHIFT},
	{PMIC_CPU_INT_STA, MT6328_PMIC_CPU_INT_STA_ADDR, MT6328_PMIC_CPU_INT_STA_MASK,
	 MT6328_PMIC_CPU_INT_STA_SHIFT},
	{PMIC_MD32_INT_STA, MT6328_PMIC_MD32_INT_STA_ADDR, MT6328_PMIC_MD32_INT_STA_MASK,
	 MT6328_PMIC_MD32_INT_STA_SHIFT},
	{PMIC_BUCK_ALL_RSV0, MT6328_PMIC_BUCK_ALL_RSV0_ADDR, MT6328_PMIC_BUCK_ALL_RSV0_MASK,
	 MT6328_PMIC_BUCK_ALL_RSV0_SHIFT},
	{PMIC_VSLEEP_SRC0, MT6328_PMIC_VSLEEP_SRC0_ADDR, MT6328_PMIC_VSLEEP_SRC0_MASK,
	 MT6328_PMIC_VSLEEP_SRC0_SHIFT},
	{PMIC_VSLEEP_SRC1, MT6328_PMIC_VSLEEP_SRC1_ADDR, MT6328_PMIC_VSLEEP_SRC1_MASK,
	 MT6328_PMIC_VSLEEP_SRC1_SHIFT},
	{PMIC_R2R_SRC0, MT6328_PMIC_R2R_SRC0_ADDR, MT6328_PMIC_R2R_SRC0_MASK,
	 MT6328_PMIC_R2R_SRC0_SHIFT},
	{PMIC_R2R_SRC1, MT6328_PMIC_R2R_SRC1_ADDR, MT6328_PMIC_R2R_SRC1_MASK,
	 MT6328_PMIC_R2R_SRC1_SHIFT},
	{PMIC_BUCK_OSC_SEL_SRC0, MT6328_PMIC_BUCK_OSC_SEL_SRC0_ADDR,
	 MT6328_PMIC_BUCK_OSC_SEL_SRC0_MASK, MT6328_PMIC_BUCK_OSC_SEL_SRC0_SHIFT},
	{PMIC_SRCLKEN_DLY_SRC1, MT6328_PMIC_SRCLKEN_DLY_SRC1_ADDR,
	 MT6328_PMIC_SRCLKEN_DLY_SRC1_MASK, MT6328_PMIC_SRCLKEN_DLY_SRC1_SHIFT},
	{PMIC_BUCK_CON5_RSV0, MT6328_PMIC_BUCK_CON5_RSV0_ADDR, MT6328_PMIC_BUCK_CON5_RSV0_MASK,
	 MT6328_PMIC_BUCK_CON5_RSV0_SHIFT},
	{PMIC_QI_VSYS22_DIG_MON, MT6328_PMIC_QI_VSYS22_DIG_MON_ADDR,
	 MT6328_PMIC_QI_VSYS22_DIG_MON_MASK, MT6328_PMIC_QI_VSYS22_DIG_MON_SHIFT},
	{PMIC_QI_VPROC_DIG_MON, MT6328_PMIC_QI_VPROC_DIG_MON_ADDR,
	 MT6328_PMIC_QI_VPROC_DIG_MON_MASK, MT6328_PMIC_QI_VPROC_DIG_MON_SHIFT},
	{PMIC_QI_VLTE_DIG_MON, MT6328_PMIC_QI_VLTE_DIG_MON_ADDR, MT6328_PMIC_QI_VLTE_DIG_MON_MASK,
	 MT6328_PMIC_QI_VLTE_DIG_MON_SHIFT},
	{PMIC_QI_VCORE1_DIG_MON, MT6328_PMIC_QI_VCORE1_DIG_MON_ADDR,
	 MT6328_PMIC_QI_VCORE1_DIG_MON_MASK, MT6328_PMIC_QI_VCORE1_DIG_MON_SHIFT},
	{PMIC_VPROC_OC_EN, MT6328_PMIC_VPROC_OC_EN_ADDR, MT6328_PMIC_VPROC_OC_EN_MASK,
	 MT6328_PMIC_VPROC_OC_EN_SHIFT},
	{PMIC_VPROC_OC_DEG_EN, MT6328_PMIC_VPROC_OC_DEG_EN_ADDR, MT6328_PMIC_VPROC_OC_DEG_EN_MASK,
	 MT6328_PMIC_VPROC_OC_DEG_EN_SHIFT},
	{PMIC_VPROC_OC_WND, MT6328_PMIC_VPROC_OC_WND_ADDR, MT6328_PMIC_VPROC_OC_WND_MASK,
	 MT6328_PMIC_VPROC_OC_WND_SHIFT},
	{PMIC_VPROC_OC_THD, MT6328_PMIC_VPROC_OC_THD_ADDR, MT6328_PMIC_VPROC_OC_THD_MASK,
	 MT6328_PMIC_VPROC_OC_THD_SHIFT},
	{PMIC_VPA_OC_EN, MT6328_PMIC_VPA_OC_EN_ADDR, MT6328_PMIC_VPA_OC_EN_MASK,
	 MT6328_PMIC_VPA_OC_EN_SHIFT},
	{PMIC_VPA_OC_DEG_EN, MT6328_PMIC_VPA_OC_DEG_EN_ADDR, MT6328_PMIC_VPA_OC_DEG_EN_MASK,
	 MT6328_PMIC_VPA_OC_DEG_EN_SHIFT},
	{PMIC_VPA_OC_WND, MT6328_PMIC_VPA_OC_WND_ADDR, MT6328_PMIC_VPA_OC_WND_MASK,
	 MT6328_PMIC_VPA_OC_WND_SHIFT},
	{PMIC_VPA_OC_THD, MT6328_PMIC_VPA_OC_THD_ADDR, MT6328_PMIC_VPA_OC_THD_MASK,
	 MT6328_PMIC_VPA_OC_THD_SHIFT},
	{PMIC_VLTE_OC_EN, MT6328_PMIC_VLTE_OC_EN_ADDR, MT6328_PMIC_VLTE_OC_EN_MASK,
	 MT6328_PMIC_VLTE_OC_EN_SHIFT},
	{PMIC_VLTE_OC_DEG_EN, MT6328_PMIC_VLTE_OC_DEG_EN_ADDR, MT6328_PMIC_VLTE_OC_DEG_EN_MASK,
	 MT6328_PMIC_VLTE_OC_DEG_EN_SHIFT},
	{PMIC_VLTE_OC_WND, MT6328_PMIC_VLTE_OC_WND_ADDR, MT6328_PMIC_VLTE_OC_WND_MASK,
	 MT6328_PMIC_VLTE_OC_WND_SHIFT},
	{PMIC_VLTE_OC_THD, MT6328_PMIC_VLTE_OC_THD_ADDR, MT6328_PMIC_VLTE_OC_THD_MASK,
	 MT6328_PMIC_VLTE_OC_THD_SHIFT},
	{PMIC_VCORE1_OC_EN, MT6328_PMIC_VCORE1_OC_EN_ADDR, MT6328_PMIC_VCORE1_OC_EN_MASK,
	 MT6328_PMIC_VCORE1_OC_EN_SHIFT},
	{PMIC_VCORE1_OC_DEG_EN, MT6328_PMIC_VCORE1_OC_DEG_EN_ADDR,
	 MT6328_PMIC_VCORE1_OC_DEG_EN_MASK, MT6328_PMIC_VCORE1_OC_DEG_EN_SHIFT},
	{PMIC_VCORE1_OC_WND, MT6328_PMIC_VCORE1_OC_WND_ADDR, MT6328_PMIC_VCORE1_OC_WND_MASK,
	 MT6328_PMIC_VCORE1_OC_WND_SHIFT},
	{PMIC_VCORE1_OC_THD, MT6328_PMIC_VCORE1_OC_THD_ADDR, MT6328_PMIC_VCORE1_OC_THD_MASK,
	 MT6328_PMIC_VCORE1_OC_THD_SHIFT},
	{PMIC_VSYS22_OC_EN, MT6328_PMIC_VSYS22_OC_EN_ADDR, MT6328_PMIC_VSYS22_OC_EN_MASK,
	 MT6328_PMIC_VSYS22_OC_EN_SHIFT},
	{PMIC_VSYS22_OC_DEG_EN, MT6328_PMIC_VSYS22_OC_DEG_EN_ADDR,
	 MT6328_PMIC_VSYS22_OC_DEG_EN_MASK, MT6328_PMIC_VSYS22_OC_DEG_EN_SHIFT},
	{PMIC_VSYS22_OC_WND, MT6328_PMIC_VSYS22_OC_WND_ADDR, MT6328_PMIC_VSYS22_OC_WND_MASK,
	 MT6328_PMIC_VSYS22_OC_WND_SHIFT},
	{PMIC_VSYS22_OC_THD, MT6328_PMIC_VSYS22_OC_THD_ADDR, MT6328_PMIC_VSYS22_OC_THD_MASK,
	 MT6328_PMIC_VSYS22_OC_THD_SHIFT},
	{PMIC_VPROC_OC_FLAG_CLR, MT6328_PMIC_VPROC_OC_FLAG_CLR_ADDR,
	 MT6328_PMIC_VPROC_OC_FLAG_CLR_MASK, MT6328_PMIC_VPROC_OC_FLAG_CLR_SHIFT},
	{PMIC_VLTE_OC_FLAG_CLR, MT6328_PMIC_VLTE_OC_FLAG_CLR_ADDR,
	 MT6328_PMIC_VLTE_OC_FLAG_CLR_MASK, MT6328_PMIC_VLTE_OC_FLAG_CLR_SHIFT},
	{PMIC_VCORE1_OC_FLAG_CLR, MT6328_PMIC_VCORE1_OC_FLAG_CLR_ADDR,
	 MT6328_PMIC_VCORE1_OC_FLAG_CLR_MASK, MT6328_PMIC_VCORE1_OC_FLAG_CLR_SHIFT},
	{PMIC_VSYS22_OC_FLAG_CLR, MT6328_PMIC_VSYS22_OC_FLAG_CLR_ADDR,
	 MT6328_PMIC_VSYS22_OC_FLAG_CLR_MASK, MT6328_PMIC_VSYS22_OC_FLAG_CLR_SHIFT},
	{PMIC_VPA_OC_FLAG_CLR, MT6328_PMIC_VPA_OC_FLAG_CLR_ADDR, MT6328_PMIC_VPA_OC_FLAG_CLR_MASK,
	 MT6328_PMIC_VPA_OC_FLAG_CLR_SHIFT},
	{PMIC_VPROC_OC_FLAG_CLR_SEL, MT6328_PMIC_VPROC_OC_FLAG_CLR_SEL_ADDR,
	 MT6328_PMIC_VPROC_OC_FLAG_CLR_SEL_MASK, MT6328_PMIC_VPROC_OC_FLAG_CLR_SEL_SHIFT},
	{PMIC_VLTE_OC_FLAG_CLR_SEL, MT6328_PMIC_VLTE_OC_FLAG_CLR_SEL_ADDR,
	 MT6328_PMIC_VLTE_OC_FLAG_CLR_SEL_MASK, MT6328_PMIC_VLTE_OC_FLAG_CLR_SEL_SHIFT},
	{PMIC_VCORE1_OC_FLAG_CLR_SEL, MT6328_PMIC_VCORE1_OC_FLAG_CLR_SEL_ADDR,
	 MT6328_PMIC_VCORE1_OC_FLAG_CLR_SEL_MASK, MT6328_PMIC_VCORE1_OC_FLAG_CLR_SEL_SHIFT},
	{PMIC_VSYS22_OC_FLAG_CLR_SEL, MT6328_PMIC_VSYS22_OC_FLAG_CLR_SEL_ADDR,
	 MT6328_PMIC_VSYS22_OC_FLAG_CLR_SEL_MASK, MT6328_PMIC_VSYS22_OC_FLAG_CLR_SEL_SHIFT},
	{PMIC_VPA_OC_FLAG_CLR_SEL, MT6328_PMIC_VPA_OC_FLAG_CLR_SEL_ADDR,
	 MT6328_PMIC_VPA_OC_FLAG_CLR_SEL_MASK, MT6328_PMIC_VPA_OC_FLAG_CLR_SEL_SHIFT},
	{PMIC_VPROC_OC_STATUS, MT6328_PMIC_VPROC_OC_STATUS_ADDR, MT6328_PMIC_VPROC_OC_STATUS_MASK,
	 MT6328_PMIC_VPROC_OC_STATUS_SHIFT},
	{PMIC_VLTE_OC_STATUS, MT6328_PMIC_VLTE_OC_STATUS_ADDR, MT6328_PMIC_VLTE_OC_STATUS_MASK,
	 MT6328_PMIC_VLTE_OC_STATUS_SHIFT},
	{PMIC_VCORE1_OC_STATUS, MT6328_PMIC_VCORE1_OC_STATUS_ADDR,
	 MT6328_PMIC_VCORE1_OC_STATUS_MASK, MT6328_PMIC_VCORE1_OC_STATUS_SHIFT},
	{PMIC_VSYS22_OC_STATUS, MT6328_PMIC_VSYS22_OC_STATUS_ADDR,
	 MT6328_PMIC_VSYS22_OC_STATUS_MASK, MT6328_PMIC_VSYS22_OC_STATUS_SHIFT},
	{PMIC_VPA_OC_STATUS, MT6328_PMIC_VPA_OC_STATUS_ADDR, MT6328_PMIC_VPA_OC_STATUS_MASK,
	 MT6328_PMIC_VPA_OC_STATUS_SHIFT},
	{PMIC_VPROC_OC_INT_EN, MT6328_PMIC_VPROC_OC_INT_EN_ADDR, MT6328_PMIC_VPROC_OC_INT_EN_MASK,
	 MT6328_PMIC_VPROC_OC_INT_EN_SHIFT},
	{PMIC_VLTE_OC_INT_EN, MT6328_PMIC_VLTE_OC_INT_EN_ADDR, MT6328_PMIC_VLTE_OC_INT_EN_MASK,
	 MT6328_PMIC_VLTE_OC_INT_EN_SHIFT},
	{PMIC_VCORE1_OC_INT_EN, MT6328_PMIC_VCORE1_OC_INT_EN_ADDR,
	 MT6328_PMIC_VCORE1_OC_INT_EN_MASK, MT6328_PMIC_VCORE1_OC_INT_EN_SHIFT},
	{PMIC_VSYS22_OC_INT_EN, MT6328_PMIC_VSYS22_OC_INT_EN_ADDR,
	 MT6328_PMIC_VSYS22_OC_INT_EN_MASK, MT6328_PMIC_VSYS22_OC_INT_EN_SHIFT},
	{PMIC_VPA_OC_INT_EN, MT6328_PMIC_VPA_OC_INT_EN_ADDR, MT6328_PMIC_VPA_OC_INT_EN_MASK,
	 MT6328_PMIC_VPA_OC_INT_EN_SHIFT},
	{PMIC_VPROC_EN_OC_SDN_SEL, MT6328_PMIC_VPROC_EN_OC_SDN_SEL_ADDR,
	 MT6328_PMIC_VPROC_EN_OC_SDN_SEL_MASK, MT6328_PMIC_VPROC_EN_OC_SDN_SEL_SHIFT},
	{PMIC_VLTE_EN_OC_SDN_SEL, MT6328_PMIC_VLTE_EN_OC_SDN_SEL_ADDR,
	 MT6328_PMIC_VLTE_EN_OC_SDN_SEL_MASK, MT6328_PMIC_VLTE_EN_OC_SDN_SEL_SHIFT},
	{PMIC_VCORE1_EN_OC_SDN_SEL, MT6328_PMIC_VCORE1_EN_OC_SDN_SEL_ADDR,
	 MT6328_PMIC_VCORE1_EN_OC_SDN_SEL_MASK, MT6328_PMIC_VCORE1_EN_OC_SDN_SEL_SHIFT},
	{PMIC_VSYS22_EN_OC_SDN_SEL, MT6328_PMIC_VSYS22_EN_OC_SDN_SEL_ADDR,
	 MT6328_PMIC_VSYS22_EN_OC_SDN_SEL_MASK, MT6328_PMIC_VSYS22_EN_OC_SDN_SEL_SHIFT},
	{PMIC_VPA_EN_OC_SDN_SEL, MT6328_PMIC_VPA_EN_OC_SDN_SEL_ADDR,
	 MT6328_PMIC_VPA_EN_OC_SDN_SEL_MASK, MT6328_PMIC_VPA_EN_OC_SDN_SEL_SHIFT},
	{PMIC_VSRAM_TRACK_SLEEP_CTRL, MT6328_PMIC_VSRAM_TRACK_SLEEP_CTRL_ADDR,
	 MT6328_PMIC_VSRAM_TRACK_SLEEP_CTRL_MASK, MT6328_PMIC_VSRAM_TRACK_SLEEP_CTRL_SHIFT},
	{PMIC_VSRAM_TRACK_ON_CTRL, MT6328_PMIC_VSRAM_TRACK_ON_CTRL_ADDR,
	 MT6328_PMIC_VSRAM_TRACK_ON_CTRL_MASK, MT6328_PMIC_VSRAM_TRACK_ON_CTRL_SHIFT},
	{PMIC_VPROC_TRACK_ON_CTRL, MT6328_PMIC_VPROC_TRACK_ON_CTRL_ADDR,
	 MT6328_PMIC_VPROC_TRACK_ON_CTRL_MASK, MT6328_PMIC_VPROC_TRACK_ON_CTRL_SHIFT},
	{PMIC_VSRAM_VOSEL_DELTA, MT6328_PMIC_VSRAM_VOSEL_DELTA_ADDR,
	 MT6328_PMIC_VSRAM_VOSEL_DELTA_MASK, MT6328_PMIC_VSRAM_VOSEL_DELTA_SHIFT},
	{PMIC_VSRAM_VOSEL_OFFSET, MT6328_PMIC_VSRAM_VOSEL_OFFSET_ADDR,
	 MT6328_PMIC_VSRAM_VOSEL_OFFSET_MASK, MT6328_PMIC_VSRAM_VOSEL_OFFSET_SHIFT},
	{PMIC_VSRAM_VOSEL_ON_LB, MT6328_PMIC_VSRAM_VOSEL_ON_LB_ADDR,
	 MT6328_PMIC_VSRAM_VOSEL_ON_LB_MASK, MT6328_PMIC_VSRAM_VOSEL_ON_LB_SHIFT},
	{PMIC_VSRAM_VOSEL_ON_HB, MT6328_PMIC_VSRAM_VOSEL_ON_HB_ADDR,
	 MT6328_PMIC_VSRAM_VOSEL_ON_HB_MASK, MT6328_PMIC_VSRAM_VOSEL_ON_HB_SHIFT},
	{PMIC_VSRAM_VOSEL_SLEEP_LB, MT6328_PMIC_VSRAM_VOSEL_SLEEP_LB_ADDR,
	 MT6328_PMIC_VSRAM_VOSEL_SLEEP_LB_MASK, MT6328_PMIC_VSRAM_VOSEL_SLEEP_LB_SHIFT},
	{PMIC_QI_VPROC_VSLEEP, MT6328_PMIC_QI_VPROC_VSLEEP_ADDR, MT6328_PMIC_QI_VPROC_VSLEEP_MASK,
	 MT6328_PMIC_QI_VPROC_VSLEEP_SHIFT},
	{PMIC_QI_VLTE_VSLEEP, MT6328_PMIC_QI_VLTE_VSLEEP_ADDR, MT6328_PMIC_QI_VLTE_VSLEEP_MASK,
	 MT6328_PMIC_QI_VLTE_VSLEEP_SHIFT},
	{PMIC_QI_VCORE1_VSLEEP, MT6328_PMIC_QI_VCORE1_VSLEEP_ADDR,
	 MT6328_PMIC_QI_VCORE1_VSLEEP_MASK, MT6328_PMIC_QI_VCORE1_VSLEEP_SHIFT},
	{PMIC_QI_VSYS22_VSLEEP, MT6328_PMIC_QI_VSYS22_VSLEEP_ADDR,
	 MT6328_PMIC_QI_VSYS22_VSLEEP_MASK, MT6328_PMIC_QI_VSYS22_VSLEEP_SHIFT},
	{PMIC_QI_VSRAM_VSLEEP, MT6328_PMIC_QI_VSRAM_VSLEEP_ADDR, MT6328_PMIC_QI_VSRAM_VSLEEP_MASK,
	 MT6328_PMIC_QI_VSRAM_VSLEEP_SHIFT},
	{PMIC_RG_BUCK_RSV, MT6328_PMIC_RG_BUCK_RSV_ADDR, MT6328_PMIC_RG_BUCK_RSV_MASK,
	 MT6328_PMIC_RG_BUCK_RSV_SHIFT},
	{PMIC_RG_SMPS_TESTMODE_B, MT6328_PMIC_RG_SMPS_TESTMODE_B_ADDR,
	 MT6328_PMIC_RG_SMPS_TESTMODE_B_MASK, MT6328_PMIC_RG_SMPS_TESTMODE_B_SHIFT},
	{PMIC_RG_VPROC_TRIMH, MT6328_PMIC_RG_VPROC_TRIMH_ADDR, MT6328_PMIC_RG_VPROC_TRIMH_MASK,
	 MT6328_PMIC_RG_VPROC_TRIMH_SHIFT},
	{PMIC_RG_VPROC_TRIML, MT6328_PMIC_RG_VPROC_TRIML_ADDR, MT6328_PMIC_RG_VPROC_TRIML_MASK,
	 MT6328_PMIC_RG_VPROC_TRIML_SHIFT},
	{PMIC_RG_VCORE1_TRIMH, MT6328_PMIC_RG_VCORE1_TRIMH_ADDR, MT6328_PMIC_RG_VCORE1_TRIMH_MASK,
	 MT6328_PMIC_RG_VCORE1_TRIMH_SHIFT},
	{PMIC_RG_VCORE1_TRIML, MT6328_PMIC_RG_VCORE1_TRIML_ADDR, MT6328_PMIC_RG_VCORE1_TRIML_MASK,
	 MT6328_PMIC_RG_VCORE1_TRIML_SHIFT},
	{PMIC_RG_VLTE_TRIMH, MT6328_PMIC_RG_VLTE_TRIMH_ADDR, MT6328_PMIC_RG_VLTE_TRIMH_MASK,
	 MT6328_PMIC_RG_VLTE_TRIMH_SHIFT},
	{PMIC_RG_VLTE_TRIML, MT6328_PMIC_RG_VLTE_TRIML_ADDR, MT6328_PMIC_RG_VLTE_TRIML_MASK,
	 MT6328_PMIC_RG_VLTE_TRIML_SHIFT},
	{PMIC_RG_VSYS22_TRIMH, MT6328_PMIC_RG_VSYS22_TRIMH_ADDR, MT6328_PMIC_RG_VSYS22_TRIMH_MASK,
	 MT6328_PMIC_RG_VSYS22_TRIMH_SHIFT},
	{PMIC_RG_VSYS22_TRIML, MT6328_PMIC_RG_VSYS22_TRIML_ADDR, MT6328_PMIC_RG_VSYS22_TRIML_MASK,
	 MT6328_PMIC_RG_VSYS22_TRIML_SHIFT},
	{PMIC_RG_VPA_TRIMH, MT6328_PMIC_RG_VPA_TRIMH_ADDR, MT6328_PMIC_RG_VPA_TRIMH_MASK,
	 MT6328_PMIC_RG_VPA_TRIMH_SHIFT},
	{PMIC_RG_VPA_TRIML, MT6328_PMIC_RG_VPA_TRIML_ADDR, MT6328_PMIC_RG_VPA_TRIML_MASK,
	 MT6328_PMIC_RG_VPA_TRIML_SHIFT},
	{PMIC_RG_VSRAM_TRIMH, MT6328_PMIC_RG_VSRAM_TRIMH_ADDR, MT6328_PMIC_RG_VSRAM_TRIMH_MASK,
	 MT6328_PMIC_RG_VSRAM_TRIMH_SHIFT},
	{PMIC_RG_VSRAM_TRIML, MT6328_PMIC_RG_VSRAM_TRIML_ADDR, MT6328_PMIC_RG_VSRAM_TRIML_MASK,
	 MT6328_PMIC_RG_VSRAM_TRIML_SHIFT},
	{PMIC_RG_VPA_TRIM_REF, MT6328_PMIC_RG_VPA_TRIM_REF_ADDR, MT6328_PMIC_RG_VPA_TRIM_REF_MASK,
	 MT6328_PMIC_RG_VPA_TRIM_REF_SHIFT},
	{PMIC_RG_VPROC_VSLEEP, MT6328_PMIC_RG_VPROC_VSLEEP_ADDR, MT6328_PMIC_RG_VPROC_VSLEEP_MASK,
	 MT6328_PMIC_RG_VPROC_VSLEEP_SHIFT},
	{PMIC_RG_VCORE1_VSLEEP, MT6328_PMIC_RG_VCORE1_VSLEEP_ADDR,
	 MT6328_PMIC_RG_VCORE1_VSLEEP_MASK, MT6328_PMIC_RG_VCORE1_VSLEEP_SHIFT},
	{PMIC_RG_VLTE_VSLEEP, MT6328_PMIC_RG_VLTE_VSLEEP_ADDR, MT6328_PMIC_RG_VLTE_VSLEEP_MASK,
	 MT6328_PMIC_RG_VLTE_VSLEEP_SHIFT},
	{PMIC_RG_VPA_BURSTH, MT6328_PMIC_RG_VPA_BURSTH_ADDR, MT6328_PMIC_RG_VPA_BURSTH_MASK,
	 MT6328_PMIC_RG_VPA_BURSTH_SHIFT},
	{PMIC_RG_VPA_BURSTL, MT6328_PMIC_RG_VPA_BURSTL_ADDR, MT6328_PMIC_RG_VPA_BURSTL_MASK,
	 MT6328_PMIC_RG_VPA_BURSTL_SHIFT},
	{PMIC_RG_VSRAM_DVFS1_VSLEEP, MT6328_PMIC_RG_VSRAM_DVFS1_VSLEEP_ADDR,
	 MT6328_PMIC_RG_VSRAM_DVFS1_VSLEEP_MASK, MT6328_PMIC_RG_VSRAM_DVFS1_VSLEEP_SHIFT},
	{PMIC_RG_DMY100MA_EN, MT6328_PMIC_RG_DMY100MA_EN_ADDR, MT6328_PMIC_RG_DMY100MA_EN_MASK,
	 MT6328_PMIC_RG_DMY100MA_EN_SHIFT},
	{PMIC_RG_DMY100MA_SEL, MT6328_PMIC_RG_DMY100MA_SEL_ADDR, MT6328_PMIC_RG_DMY100MA_SEL_MASK,
	 MT6328_PMIC_RG_DMY100MA_SEL_SHIFT},
	{PMIC_RG_VSRAM_VSLEEP, MT6328_PMIC_RG_VSRAM_VSLEEP_ADDR, MT6328_PMIC_RG_VSRAM_VSLEEP_MASK,
	 MT6328_PMIC_RG_VSRAM_VSLEEP_SHIFT},
	{PMIC_RG_VCORE1_MIN_OFF, MT6328_PMIC_RG_VCORE1_MIN_OFF_ADDR,
	 MT6328_PMIC_RG_VCORE1_MIN_OFF_MASK, MT6328_PMIC_RG_VCORE1_MIN_OFF_SHIFT},
	{PMIC_RG_VCORE1_VRF18_SSTART_EN, MT6328_PMIC_RG_VCORE1_VRF18_SSTART_EN_ADDR,
	 MT6328_PMIC_RG_VCORE1_VRF18_SSTART_EN_MASK, MT6328_PMIC_RG_VCORE1_VRF18_SSTART_EN_SHIFT},
	{PMIC_RG_VCORE1_1P35UP_SEL_EN, MT6328_PMIC_RG_VCORE1_1P35UP_SEL_EN_ADDR,
	 MT6328_PMIC_RG_VCORE1_1P35UP_SEL_EN_MASK, MT6328_PMIC_RG_VCORE1_1P35UP_SEL_EN_SHIFT},
	{PMIC_RG_VCORE1_RZSEL, MT6328_PMIC_RG_VCORE1_RZSEL_ADDR, MT6328_PMIC_RG_VCORE1_RZSEL_MASK,
	 MT6328_PMIC_RG_VCORE1_RZSEL_SHIFT},
	{PMIC_RG_VCORE1_CSR, MT6328_PMIC_RG_VCORE1_CSR_ADDR, MT6328_PMIC_RG_VCORE1_CSR_MASK,
	 MT6328_PMIC_RG_VCORE1_CSR_SHIFT},
	{PMIC_RG_VCORE1_CSL, MT6328_PMIC_RG_VCORE1_CSL_ADDR, MT6328_PMIC_RG_VCORE1_CSL_MASK,
	 MT6328_PMIC_RG_VCORE1_CSL_SHIFT},
	{PMIC_RG_VCORE1_SLP, MT6328_PMIC_RG_VCORE1_SLP_ADDR, MT6328_PMIC_RG_VCORE1_SLP_MASK,
	 MT6328_PMIC_RG_VCORE1_SLP_SHIFT},
	{PMIC_RG_VCORE1_ZX_OS, MT6328_PMIC_RG_VCORE1_ZX_OS_ADDR, MT6328_PMIC_RG_VCORE1_ZX_OS_MASK,
	 MT6328_PMIC_RG_VCORE1_ZX_OS_SHIFT},
	{PMIC_RG_VCORE1_ZXOS_TRIM, MT6328_PMIC_RG_VCORE1_ZXOS_TRIM_ADDR,
	 MT6328_PMIC_RG_VCORE1_ZXOS_TRIM_MASK, MT6328_PMIC_RG_VCORE1_ZXOS_TRIM_SHIFT},
	{PMIC_RG_VCORE1_MODESET, MT6328_PMIC_RG_VCORE1_MODESET_ADDR,
	 MT6328_PMIC_RG_VCORE1_MODESET_MASK, MT6328_PMIC_RG_VCORE1_MODESET_SHIFT},
	{PMIC_RG_VCORE1_NDIS_EN, MT6328_PMIC_RG_VCORE1_NDIS_EN_ADDR,
	 MT6328_PMIC_RG_VCORE1_NDIS_EN_MASK, MT6328_PMIC_RG_VCORE1_NDIS_EN_SHIFT},
	{PMIC_RG_VCORE1_CSM_N, MT6328_PMIC_RG_VCORE1_CSM_N_ADDR, MT6328_PMIC_RG_VCORE1_CSM_N_MASK,
	 MT6328_PMIC_RG_VCORE1_CSM_N_SHIFT},
	{PMIC_RG_VCORE1_CSM_P, MT6328_PMIC_RG_VCORE1_CSM_P_ADDR, MT6328_PMIC_RG_VCORE1_CSM_P_MASK,
	 MT6328_PMIC_RG_VCORE1_CSM_P_SHIFT},
	{PMIC_RG_VCORE1_RSV, MT6328_PMIC_RG_VCORE1_RSV_ADDR, MT6328_PMIC_RG_VCORE1_RSV_MASK,
	 MT6328_PMIC_RG_VCORE1_RSV_SHIFT},
	{PMIC_RG_VCORE1_PFM_RIP, MT6328_PMIC_RG_VCORE1_PFM_RIP_ADDR,
	 MT6328_PMIC_RG_VCORE1_PFM_RIP_MASK, MT6328_PMIC_RG_VCORE1_PFM_RIP_SHIFT},
	{PMIC_RG_VCORE1_TRAN_BST, MT6328_PMIC_RG_VCORE1_TRAN_BST_ADDR,
	 MT6328_PMIC_RG_VCORE1_TRAN_BST_MASK, MT6328_PMIC_RG_VCORE1_TRAN_BST_SHIFT},
	{PMIC_RG_VCORE1_DTS_ENB, MT6328_PMIC_RG_VCORE1_DTS_ENB_ADDR,
	 MT6328_PMIC_RG_VCORE1_DTS_ENB_MASK, MT6328_PMIC_RG_VCORE1_DTS_ENB_SHIFT},
	{PMIC_RG_VSYS22_MIN_OFF, MT6328_PMIC_RG_VSYS22_MIN_OFF_ADDR,
	 MT6328_PMIC_RG_VSYS22_MIN_OFF_MASK, MT6328_PMIC_RG_VSYS22_MIN_OFF_SHIFT},
	{PMIC_RG_VSYS22_NVT_BUFF_OFF_EN, MT6328_PMIC_RG_VSYS22_NVT_BUFF_OFF_EN_ADDR,
	 MT6328_PMIC_RG_VSYS22_NVT_BUFF_OFF_EN_MASK, MT6328_PMIC_RG_VSYS22_NVT_BUFF_OFF_EN_SHIFT},
	{PMIC_RG_VSYS22_VRF18_SSTART_EN, MT6328_PMIC_RG_VSYS22_VRF18_SSTART_EN_ADDR,
	 MT6328_PMIC_RG_VSYS22_VRF18_SSTART_EN_MASK, MT6328_PMIC_RG_VSYS22_VRF18_SSTART_EN_SHIFT},
	{PMIC_RG_VSYS22_1P35UP_SEL_EN, MT6328_PMIC_RG_VSYS22_1P35UP_SEL_EN_ADDR,
	 MT6328_PMIC_RG_VSYS22_1P35UP_SEL_EN_MASK, MT6328_PMIC_RG_VSYS22_1P35UP_SEL_EN_SHIFT},
	{PMIC_RG_VSYS22_RZSEL, MT6328_PMIC_RG_VSYS22_RZSEL_ADDR, MT6328_PMIC_RG_VSYS22_RZSEL_MASK,
	 MT6328_PMIC_RG_VSYS22_RZSEL_SHIFT},
	{PMIC_RG_VSYS22_CSR, MT6328_PMIC_RG_VSYS22_CSR_ADDR, MT6328_PMIC_RG_VSYS22_CSR_MASK,
	 MT6328_PMIC_RG_VSYS22_CSR_SHIFT},
	{PMIC_RG_VSYS22_AUTO_MODE, MT6328_PMIC_RG_VSYS22_AUTO_MODE_ADDR,
	 MT6328_PMIC_RG_VSYS22_AUTO_MODE_MASK, MT6328_PMIC_RG_VSYS22_AUTO_MODE_SHIFT},
	{PMIC_RG_VSYS22_CSL, MT6328_PMIC_RG_VSYS22_CSL_ADDR, MT6328_PMIC_RG_VSYS22_CSL_MASK,
	 MT6328_PMIC_RG_VSYS22_CSL_SHIFT},
	{PMIC_RG_VSYS22_SLP, MT6328_PMIC_RG_VSYS22_SLP_ADDR, MT6328_PMIC_RG_VSYS22_SLP_MASK,
	 MT6328_PMIC_RG_VSYS22_SLP_SHIFT},
	{PMIC_RG_VSYS22_ZX_OS, MT6328_PMIC_RG_VSYS22_ZX_OS_ADDR, MT6328_PMIC_RG_VSYS22_ZX_OS_MASK,
	 MT6328_PMIC_RG_VSYS22_ZX_OS_SHIFT},
	{PMIC_RG_VSYS22_MODESET, MT6328_PMIC_RG_VSYS22_MODESET_ADDR,
	 MT6328_PMIC_RG_VSYS22_MODESET_MASK, MT6328_PMIC_RG_VSYS22_MODESET_SHIFT},
	{PMIC_RG_VSYS22_NDIS_EN, MT6328_PMIC_RG_VSYS22_NDIS_EN_ADDR,
	 MT6328_PMIC_RG_VSYS22_NDIS_EN_MASK, MT6328_PMIC_RG_VSYS22_NDIS_EN_SHIFT},
	{PMIC_RG_VSYS22_CSM_N, MT6328_PMIC_RG_VSYS22_CSM_N_ADDR, MT6328_PMIC_RG_VSYS22_CSM_N_MASK,
	 MT6328_PMIC_RG_VSYS22_CSM_N_SHIFT},
	{PMIC_RG_VSYS22_CSM_P, MT6328_PMIC_RG_VSYS22_CSM_P_ADDR, MT6328_PMIC_RG_VSYS22_CSM_P_MASK,
	 MT6328_PMIC_RG_VSYS22_CSM_P_SHIFT},
	{PMIC_RG_VSYS22_RSV, MT6328_PMIC_RG_VSYS22_RSV_ADDR, MT6328_PMIC_RG_VSYS22_RSV_MASK,
	 MT6328_PMIC_RG_VSYS22_RSV_SHIFT},
	{PMIC_RG_VSYS22_ZXOS_TRIM, MT6328_PMIC_RG_VSYS22_ZXOS_TRIM_ADDR,
	 MT6328_PMIC_RG_VSYS22_ZXOS_TRIM_MASK, MT6328_PMIC_RG_VSYS22_ZXOS_TRIM_SHIFT},
	{PMIC_RG_VSYS22_PFM_RIP, MT6328_PMIC_RG_VSYS22_PFM_RIP_ADDR,
	 MT6328_PMIC_RG_VSYS22_PFM_RIP_MASK, MT6328_PMIC_RG_VSYS22_PFM_RIP_SHIFT},
	{PMIC_RG_VSYS22_TRAN_BST, MT6328_PMIC_RG_VSYS22_TRAN_BST_ADDR,
	 MT6328_PMIC_RG_VSYS22_TRAN_BST_MASK, MT6328_PMIC_RG_VSYS22_TRAN_BST_SHIFT},
	{PMIC_RG_VSYS22_DTS_ENB, MT6328_PMIC_RG_VSYS22_DTS_ENB_ADDR,
	 MT6328_PMIC_RG_VSYS22_DTS_ENB_MASK, MT6328_PMIC_RG_VSYS22_DTS_ENB_SHIFT},
	{PMIC_RG_VPROC_MIN_OFF, MT6328_PMIC_RG_VPROC_MIN_OFF_ADDR,
	 MT6328_PMIC_RG_VPROC_MIN_OFF_MASK, MT6328_PMIC_RG_VPROC_MIN_OFF_SHIFT},
	{PMIC_RG_VPROC_VRF18_SSTART_EN, MT6328_PMIC_RG_VPROC_VRF18_SSTART_EN_ADDR,
	 MT6328_PMIC_RG_VPROC_VRF18_SSTART_EN_MASK, MT6328_PMIC_RG_VPROC_VRF18_SSTART_EN_SHIFT},
	{PMIC_RG_VPROC_1P35UP_SEL_EN, MT6328_PMIC_RG_VPROC_1P35UP_SEL_EN_ADDR,
	 MT6328_PMIC_RG_VPROC_1P35UP_SEL_EN_MASK, MT6328_PMIC_RG_VPROC_1P35UP_SEL_EN_SHIFT},
	{PMIC_RG_VPROC_RZSEL, MT6328_PMIC_RG_VPROC_RZSEL_ADDR, MT6328_PMIC_RG_VPROC_RZSEL_MASK,
	 MT6328_PMIC_RG_VPROC_RZSEL_SHIFT},
	{PMIC_RG_VPROC_CSR, MT6328_PMIC_RG_VPROC_CSR_ADDR, MT6328_PMIC_RG_VPROC_CSR_MASK,
	 MT6328_PMIC_RG_VPROC_CSR_SHIFT},
	{PMIC_RG_VPROC_CSL, MT6328_PMIC_RG_VPROC_CSL_ADDR, MT6328_PMIC_RG_VPROC_CSL_MASK,
	 MT6328_PMIC_RG_VPROC_CSL_SHIFT},
	{PMIC_RG_VPROC_AUTO_MODE, MT6328_PMIC_RG_VPROC_AUTO_MODE_ADDR,
	 MT6328_PMIC_RG_VPROC_AUTO_MODE_MASK, MT6328_PMIC_RG_VPROC_AUTO_MODE_SHIFT},
	{PMIC_RG_VPROC_SLP, MT6328_PMIC_RG_VPROC_SLP_ADDR, MT6328_PMIC_RG_VPROC_SLP_MASK,
	 MT6328_PMIC_RG_VPROC_SLP_SHIFT},
	{PMIC_RG_VPROC_ZX_OS, MT6328_PMIC_RG_VPROC_ZX_OS_ADDR, MT6328_PMIC_RG_VPROC_ZX_OS_MASK,
	 MT6328_PMIC_RG_VPROC_ZX_OS_SHIFT},
	{PMIC_RG_VPROC_ZXOS_TRIM, MT6328_PMIC_RG_VPROC_ZXOS_TRIM_ADDR,
	 MT6328_PMIC_RG_VPROC_ZXOS_TRIM_MASK, MT6328_PMIC_RG_VPROC_ZXOS_TRIM_SHIFT},
	{PMIC_RG_VPROC_MODESET, MT6328_PMIC_RG_VPROC_MODESET_ADDR,
	 MT6328_PMIC_RG_VPROC_MODESET_MASK, MT6328_PMIC_RG_VPROC_MODESET_SHIFT},
	{PMIC_RG_VPROC_NDIS_EN, MT6328_PMIC_RG_VPROC_NDIS_EN_ADDR,
	 MT6328_PMIC_RG_VPROC_NDIS_EN_MASK, MT6328_PMIC_RG_VPROC_NDIS_EN_SHIFT},
	{PMIC_RG_VCORE1_AUTO_MODE, MT6328_PMIC_RG_VCORE1_AUTO_MODE_ADDR,
	 MT6328_PMIC_RG_VCORE1_AUTO_MODE_MASK, MT6328_PMIC_RG_VCORE1_AUTO_MODE_SHIFT},
	{PMIC_RG_VPROC_CSM_N, MT6328_PMIC_RG_VPROC_CSM_N_ADDR, MT6328_PMIC_RG_VPROC_CSM_N_MASK,
	 MT6328_PMIC_RG_VPROC_CSM_N_SHIFT},
	{PMIC_RG_VPROC_CSM_P, MT6328_PMIC_RG_VPROC_CSM_P_ADDR, MT6328_PMIC_RG_VPROC_CSM_P_MASK,
	 MT6328_PMIC_RG_VPROC_CSM_P_SHIFT},
	{PMIC_RG_VPROC_RSV, MT6328_PMIC_RG_VPROC_RSV_ADDR, MT6328_PMIC_RG_VPROC_RSV_MASK,
	 MT6328_PMIC_RG_VPROC_RSV_SHIFT},
	{PMIC_RG_VPROC_PFM_RIP, MT6328_PMIC_RG_VPROC_PFM_RIP_ADDR,
	 MT6328_PMIC_RG_VPROC_PFM_RIP_MASK, MT6328_PMIC_RG_VPROC_PFM_RIP_SHIFT},
	{PMIC_RG_VPROC_TRAN_BST, MT6328_PMIC_RG_VPROC_TRAN_BST_ADDR,
	 MT6328_PMIC_RG_VPROC_TRAN_BST_MASK, MT6328_PMIC_RG_VPROC_TRAN_BST_SHIFT},
	{PMIC_RG_VPROC_DTS_ENB, MT6328_PMIC_RG_VPROC_DTS_ENB_ADDR,
	 MT6328_PMIC_RG_VPROC_DTS_ENB_MASK, MT6328_PMIC_RG_VPROC_DTS_ENB_SHIFT},
	{PMIC_RG_XOSC_CALI, MT6328_PMIC_RG_XOSC_CALI_ADDR, MT6328_PMIC_RG_XOSC_CALI_MASK,
	 MT6328_PMIC_RG_XOSC_CALI_SHIFT},
	{PMIC_RG_LPD_EN, MT6328_PMIC_RG_LPD_EN_ADDR, MT6328_PMIC_RG_LPD_EN_MASK,
	 MT6328_PMIC_RG_LPD_EN_SHIFT},
	{PMIC_RG_LPD_RESET, MT6328_PMIC_RG_LPD_RESET_ADDR, MT6328_PMIC_RG_LPD_RESET_MASK,
	 MT6328_PMIC_RG_LPD_RESET_SHIFT},
	{PMIC_RG_EOSC_CALI, MT6328_PMIC_RG_EOSC_CALI_ADDR, MT6328_PMIC_RG_EOSC_CALI_MASK,
	 MT6328_PMIC_RG_EOSC_CALI_SHIFT},
	{PMIC_RG_EOSC_PWDB, MT6328_PMIC_RG_EOSC_PWDB_ADDR, MT6328_PMIC_RG_EOSC_PWDB_MASK,
	 MT6328_PMIC_RG_EOSC_PWDB_SHIFT},
	{PMIC_RG_XOSC_PWDB, MT6328_PMIC_RG_XOSC_PWDB_ADDR, MT6328_PMIC_RG_XOSC_PWDB_MASK,
	 MT6328_PMIC_RG_XOSC_PWDB_SHIFT},
	{PMIC_RG_EOSC_CHOP_EN, MT6328_PMIC_RG_EOSC_CHOP_EN_ADDR, MT6328_PMIC_RG_EOSC_CHOP_EN_MASK,
	 MT6328_PMIC_RG_EOSC_CHOP_EN_SHIFT},
	{PMIC_RG_EOSC_LPD_EN, MT6328_PMIC_RG_EOSC_LPD_EN_ADDR, MT6328_PMIC_RG_EOSC_LPD_EN_MASK,
	 MT6328_PMIC_RG_EOSC_LPD_EN_SHIFT},
	{PMIC_RG_EOSC_LPD_RST, MT6328_PMIC_RG_EOSC_LPD_RST_ADDR, MT6328_PMIC_RG_EOSC_LPD_RST_MASK,
	 MT6328_PMIC_RG_EOSC_LPD_RST_SHIFT},
	{PMIC_RG_EOSC_VCT_EN, MT6328_PMIC_RG_EOSC_VCT_EN_ADDR, MT6328_PMIC_RG_EOSC_VCT_EN_MASK,
	 MT6328_PMIC_RG_EOSC_VCT_EN_SHIFT},
	{PMIC_RG_EOSC_OPT, MT6328_PMIC_RG_EOSC_OPT_ADDR, MT6328_PMIC_RG_EOSC_OPT_MASK,
	 MT6328_PMIC_RG_EOSC_OPT_SHIFT},
	{PMIC_RG_EOSC_RSV, MT6328_PMIC_RG_EOSC_RSV_ADDR, MT6328_PMIC_RG_EOSC_RSV_MASK,
	 MT6328_PMIC_RG_EOSC_RSV_SHIFT},
	{PMIC_RG_VPA_RZSEL, MT6328_PMIC_RG_VPA_RZSEL_ADDR, MT6328_PMIC_RG_VPA_RZSEL_MASK,
	 MT6328_PMIC_RG_VPA_RZSEL_SHIFT},
	{PMIC_RG_VPA_CC, MT6328_PMIC_RG_VPA_CC_ADDR, MT6328_PMIC_RG_VPA_CC_MASK,
	 MT6328_PMIC_RG_VPA_CC_SHIFT},
	{PMIC_RG_VPA_CSR, MT6328_PMIC_RG_VPA_CSR_ADDR, MT6328_PMIC_RG_VPA_CSR_MASK,
	 MT6328_PMIC_RG_VPA_CSR_SHIFT},
	{PMIC_RG_VPA_CSMIR, MT6328_PMIC_RG_VPA_CSMIR_ADDR, MT6328_PMIC_RG_VPA_CSMIR_MASK,
	 MT6328_PMIC_RG_VPA_CSMIR_SHIFT},
	{PMIC_RG_VPA_CSL, MT6328_PMIC_RG_VPA_CSL_ADDR, MT6328_PMIC_RG_VPA_CSL_MASK,
	 MT6328_PMIC_RG_VPA_CSL_SHIFT},
	{PMIC_RG_VPA_SLP, MT6328_PMIC_RG_VPA_SLP_ADDR, MT6328_PMIC_RG_VPA_SLP_MASK,
	 MT6328_PMIC_RG_VPA_SLP_SHIFT},
	{PMIC_RG_VPA_ZX_OS_TRIM, MT6328_PMIC_RG_VPA_ZX_OS_TRIM_ADDR,
	 MT6328_PMIC_RG_VPA_ZX_OS_TRIM_MASK, MT6328_PMIC_RG_VPA_ZX_OS_TRIM_SHIFT},
	{PMIC_RG_VPA_ZX_OS, MT6328_PMIC_RG_VPA_ZX_OS_ADDR, MT6328_PMIC_RG_VPA_ZX_OS_MASK,
	 MT6328_PMIC_RG_VPA_ZX_OS_SHIFT},
	{PMIC_RG_VPA_HZP, MT6328_PMIC_RG_VPA_HZP_ADDR, MT6328_PMIC_RG_VPA_HZP_MASK,
	 MT6328_PMIC_RG_VPA_HZP_SHIFT},
	{PMIC_RG_VPA_BWEX_GAT, MT6328_PMIC_RG_VPA_BWEX_GAT_ADDR, MT6328_PMIC_RG_VPA_BWEX_GAT_MASK,
	 MT6328_PMIC_RG_VPA_BWEX_GAT_SHIFT},
	{PMIC_RG_VPA_MODESET, MT6328_PMIC_RG_VPA_MODESET_ADDR, MT6328_PMIC_RG_VPA_MODESET_MASK,
	 MT6328_PMIC_RG_VPA_MODESET_SHIFT},
	{PMIC_RG_VPA_SLEW, MT6328_PMIC_RG_VPA_SLEW_ADDR, MT6328_PMIC_RG_VPA_SLEW_MASK,
	 MT6328_PMIC_RG_VPA_SLEW_SHIFT},
	{PMIC_RG_VPA_SLEW_NMOS, MT6328_PMIC_RG_VPA_SLEW_NMOS_ADDR,
	 MT6328_PMIC_RG_VPA_SLEW_NMOS_MASK, MT6328_PMIC_RG_VPA_SLEW_NMOS_SHIFT},
	{PMIC_RG_VPA_NDIS_EN, MT6328_PMIC_RG_VPA_NDIS_EN_ADDR, MT6328_PMIC_RG_VPA_NDIS_EN_MASK,
	 MT6328_PMIC_RG_VPA_NDIS_EN_SHIFT},
	{PMIC_RG_VPA_MIN_ON, MT6328_PMIC_RG_VPA_MIN_ON_ADDR, MT6328_PMIC_RG_VPA_MIN_ON_MASK,
	 MT6328_PMIC_RG_VPA_MIN_ON_SHIFT},
	{PMIC_RG_VPA_VBAT_DEL, MT6328_PMIC_RG_VPA_VBAT_DEL_ADDR, MT6328_PMIC_RG_VPA_VBAT_DEL_MASK,
	 MT6328_PMIC_RG_VPA_VBAT_DEL_SHIFT},
	{PMIC_RG_VPA_EN, MT6328_PMIC_RG_VPA_EN_ADDR, MT6328_PMIC_RG_VPA_EN_MASK,
	 MT6328_PMIC_RG_VPA_EN_SHIFT},
	{PMIC_RG_VPA_RSV1, MT6328_PMIC_RG_VPA_RSV1_ADDR, MT6328_PMIC_RG_VPA_RSV1_MASK,
	 MT6328_PMIC_RG_VPA_RSV1_SHIFT},
	{PMIC_RG_VPA_RSV2, MT6328_PMIC_RG_VPA_RSV2_ADDR, MT6328_PMIC_RG_VPA_RSV2_MASK,
	 MT6328_PMIC_RG_VPA_RSV2_SHIFT},
	{PMIC_RG_VLTE_MIN_OFF, MT6328_PMIC_RG_VLTE_MIN_OFF_ADDR, MT6328_PMIC_RG_VLTE_MIN_OFF_MASK,
	 MT6328_PMIC_RG_VLTE_MIN_OFF_SHIFT},
	{PMIC_RG_VLTE_VRF18_SSTART_EN, MT6328_PMIC_RG_VLTE_VRF18_SSTART_EN_ADDR,
	 MT6328_PMIC_RG_VLTE_VRF18_SSTART_EN_MASK, MT6328_PMIC_RG_VLTE_VRF18_SSTART_EN_SHIFT},
	{PMIC_RG_VLTE_1P35UP_SEL_EN, MT6328_PMIC_RG_VLTE_1P35UP_SEL_EN_ADDR,
	 MT6328_PMIC_RG_VLTE_1P35UP_SEL_EN_MASK, MT6328_PMIC_RG_VLTE_1P35UP_SEL_EN_SHIFT},
	{PMIC_RG_VLTE_RZSEL, MT6328_PMIC_RG_VLTE_RZSEL_ADDR, MT6328_PMIC_RG_VLTE_RZSEL_MASK,
	 MT6328_PMIC_RG_VLTE_RZSEL_SHIFT},
	{PMIC_RG_VLTE_CSR, MT6328_PMIC_RG_VLTE_CSR_ADDR, MT6328_PMIC_RG_VLTE_CSR_MASK,
	 MT6328_PMIC_RG_VLTE_CSR_SHIFT},
	{PMIC_RG_VLTE_CSL, MT6328_PMIC_RG_VLTE_CSL_ADDR, MT6328_PMIC_RG_VLTE_CSL_MASK,
	 MT6328_PMIC_RG_VLTE_CSL_SHIFT},
	{PMIC_RG_VLTE_SLP, MT6328_PMIC_RG_VLTE_SLP_ADDR, MT6328_PMIC_RG_VLTE_SLP_MASK,
	 MT6328_PMIC_RG_VLTE_SLP_SHIFT},
	{PMIC_RG_VLTE_ZX_OS, MT6328_PMIC_RG_VLTE_ZX_OS_ADDR, MT6328_PMIC_RG_VLTE_ZX_OS_MASK,
	 MT6328_PMIC_RG_VLTE_ZX_OS_SHIFT},
	{PMIC_RG_VLTE_ZXOS_TRIM, MT6328_PMIC_RG_VLTE_ZXOS_TRIM_ADDR,
	 MT6328_PMIC_RG_VLTE_ZXOS_TRIM_MASK, MT6328_PMIC_RG_VLTE_ZXOS_TRIM_SHIFT},
	{PMIC_RG_VLTE_MODESET, MT6328_PMIC_RG_VLTE_MODESET_ADDR, MT6328_PMIC_RG_VLTE_MODESET_MASK,
	 MT6328_PMIC_RG_VLTE_MODESET_SHIFT},
	{PMIC_RG_VLTE_NDIS_EN, MT6328_PMIC_RG_VLTE_NDIS_EN_ADDR, MT6328_PMIC_RG_VLTE_NDIS_EN_MASK,
	 MT6328_PMIC_RG_VLTE_NDIS_EN_SHIFT},
	{PMIC_RG_VLTE_AUTO_MODE, MT6328_PMIC_RG_VLTE_AUTO_MODE_ADDR,
	 MT6328_PMIC_RG_VLTE_AUTO_MODE_MASK, MT6328_PMIC_RG_VLTE_AUTO_MODE_SHIFT},
	{PMIC_RG_VLTE_CSM_N, MT6328_PMIC_RG_VLTE_CSM_N_ADDR, MT6328_PMIC_RG_VLTE_CSM_N_MASK,
	 MT6328_PMIC_RG_VLTE_CSM_N_SHIFT},
	{PMIC_RG_VLTE_CSM_P, MT6328_PMIC_RG_VLTE_CSM_P_ADDR, MT6328_PMIC_RG_VLTE_CSM_P_MASK,
	 MT6328_PMIC_RG_VLTE_CSM_P_SHIFT},
	{PMIC_RG_VLTE_RSV, MT6328_PMIC_RG_VLTE_RSV_ADDR, MT6328_PMIC_RG_VLTE_RSV_MASK,
	 MT6328_PMIC_RG_VLTE_RSV_SHIFT},
	{PMIC_RG_VLTE_PFM_RIP, MT6328_PMIC_RG_VLTE_PFM_RIP_ADDR, MT6328_PMIC_RG_VLTE_PFM_RIP_MASK,
	 MT6328_PMIC_RG_VLTE_PFM_RIP_SHIFT},
	{PMIC_RG_VLTE_TRAN_BST, MT6328_PMIC_RG_VLTE_TRAN_BST_ADDR,
	 MT6328_PMIC_RG_VLTE_TRAN_BST_MASK, MT6328_PMIC_RG_VLTE_TRAN_BST_SHIFT},
	{PMIC_RG_VLTE_DTS_ENB, MT6328_PMIC_RG_VLTE_DTS_ENB_ADDR, MT6328_PMIC_RG_VLTE_DTS_ENB_MASK,
	 MT6328_PMIC_RG_VLTE_DTS_ENB_SHIFT},
	{PMIC_VPROC_DIG0_RSV0, MT6328_PMIC_VPROC_DIG0_RSV0_ADDR, MT6328_PMIC_VPROC_DIG0_RSV0_MASK,
	 MT6328_PMIC_VPROC_DIG0_RSV0_SHIFT},
	{PMIC_VPROC_DUMMY_RSV1, MT6328_PMIC_VPROC_DUMMY_RSV1_ADDR,
	 MT6328_PMIC_VPROC_DUMMY_RSV1_MASK, MT6328_PMIC_VPROC_DUMMY_RSV1_SHIFT},
	{PMIC_VPROC_DUMMY_RSV2, MT6328_PMIC_VPROC_DUMMY_RSV2_ADDR,
	 MT6328_PMIC_VPROC_DUMMY_RSV2_MASK, MT6328_PMIC_VPROC_DUMMY_RSV2_SHIFT},
	{PMIC_VPROC_DUMMY_RSV3, MT6328_PMIC_VPROC_DUMMY_RSV3_ADDR,
	 MT6328_PMIC_VPROC_DUMMY_RSV3_MASK, MT6328_PMIC_VPROC_DUMMY_RSV3_SHIFT},
	{PMIC_VPROC_DUMMY_RSV4, MT6328_PMIC_VPROC_DUMMY_RSV4_ADDR,
	 MT6328_PMIC_VPROC_DUMMY_RSV4_MASK, MT6328_PMIC_VPROC_DUMMY_RSV4_SHIFT},
	{PMIC_VPROC_DUMMY_RSV5, MT6328_PMIC_VPROC_DUMMY_RSV5_ADDR,
	 MT6328_PMIC_VPROC_DUMMY_RSV5_MASK, MT6328_PMIC_VPROC_DUMMY_RSV5_SHIFT},
	{PMIC_VPROC_DUMMY_RSV6, MT6328_PMIC_VPROC_DUMMY_RSV6_ADDR,
	 MT6328_PMIC_VPROC_DUMMY_RSV6_MASK, MT6328_PMIC_VPROC_DUMMY_RSV6_SHIFT},
	{PMIC_VPROC_EN_CTRL, MT6328_PMIC_VPROC_EN_CTRL_ADDR, MT6328_PMIC_VPROC_EN_CTRL_MASK,
	 MT6328_PMIC_VPROC_EN_CTRL_SHIFT},
	{PMIC_VPROC_VOSEL_CTRL, MT6328_PMIC_VPROC_VOSEL_CTRL_ADDR,
	 MT6328_PMIC_VPROC_VOSEL_CTRL_MASK, MT6328_PMIC_VPROC_VOSEL_CTRL_SHIFT},
	{PMIC_VPROC_DIG0_RSV1, MT6328_PMIC_VPROC_DIG0_RSV1_ADDR, MT6328_PMIC_VPROC_DIG0_RSV1_MASK,
	 MT6328_PMIC_VPROC_DIG0_RSV1_SHIFT},
	{PMIC_VPROC_DIG1_RSV1, MT6328_PMIC_VPROC_DIG1_RSV1_ADDR, MT6328_PMIC_VPROC_DIG1_RSV1_MASK,
	 MT6328_PMIC_VPROC_DIG1_RSV1_SHIFT},
	{PMIC_VPROC_EN_SEL, MT6328_PMIC_VPROC_EN_SEL_ADDR, MT6328_PMIC_VPROC_EN_SEL_MASK,
	 MT6328_PMIC_VPROC_EN_SEL_SHIFT},
	{PMIC_VPROC_VOSEL_SEL, MT6328_PMIC_VPROC_VOSEL_SEL_ADDR, MT6328_PMIC_VPROC_VOSEL_SEL_MASK,
	 MT6328_PMIC_VPROC_VOSEL_SEL_SHIFT},
	{PMIC_VPROC_DIG0_RSV2, MT6328_PMIC_VPROC_DIG0_RSV2_ADDR, MT6328_PMIC_VPROC_DIG0_RSV2_MASK,
	 MT6328_PMIC_VPROC_DIG0_RSV2_SHIFT},
	{PMIC_VPROC_DIG1_RSV2, MT6328_PMIC_VPROC_DIG1_RSV2_ADDR, MT6328_PMIC_VPROC_DIG1_RSV2_MASK,
	 MT6328_PMIC_VPROC_DIG1_RSV2_SHIFT},
	{PMIC_VPROC_EN, MT6328_PMIC_VPROC_EN_ADDR, MT6328_PMIC_VPROC_EN_MASK,
	 MT6328_PMIC_VPROC_EN_SHIFT},
	{PMIC_VPROC_STBTD, MT6328_PMIC_VPROC_STBTD_ADDR, MT6328_PMIC_VPROC_STBTD_MASK,
	 MT6328_PMIC_VPROC_STBTD_SHIFT},
	{PMIC_QI_VPROC_STB, MT6328_PMIC_QI_VPROC_STB_ADDR, MT6328_PMIC_QI_VPROC_STB_MASK,
	 MT6328_PMIC_QI_VPROC_STB_SHIFT},
	{PMIC_QI_VPROC_EN, MT6328_PMIC_QI_VPROC_EN_ADDR, MT6328_PMIC_QI_VPROC_EN_MASK,
	 MT6328_PMIC_QI_VPROC_EN_SHIFT},
	{PMIC_QI_VPROC_OC_STATUS, MT6328_PMIC_QI_VPROC_OC_STATUS_ADDR,
	 MT6328_PMIC_QI_VPROC_OC_STATUS_MASK, MT6328_PMIC_QI_VPROC_OC_STATUS_SHIFT},
	{PMIC_VPROC_SFCHG_FRATE, MT6328_PMIC_VPROC_SFCHG_FRATE_ADDR,
	 MT6328_PMIC_VPROC_SFCHG_FRATE_MASK, MT6328_PMIC_VPROC_SFCHG_FRATE_SHIFT},
	{PMIC_VPROC_SFCHG_FEN, MT6328_PMIC_VPROC_SFCHG_FEN_ADDR, MT6328_PMIC_VPROC_SFCHG_FEN_MASK,
	 MT6328_PMIC_VPROC_SFCHG_FEN_SHIFT},
	{PMIC_VPROC_SFCHG_RRATE, MT6328_PMIC_VPROC_SFCHG_RRATE_ADDR,
	 MT6328_PMIC_VPROC_SFCHG_RRATE_MASK, MT6328_PMIC_VPROC_SFCHG_RRATE_SHIFT},
	{PMIC_VPROC_SFCHG_REN, MT6328_PMIC_VPROC_SFCHG_REN_ADDR, MT6328_PMIC_VPROC_SFCHG_REN_MASK,
	 MT6328_PMIC_VPROC_SFCHG_REN_SHIFT},
	{PMIC_VPROC_VOSEL, MT6328_PMIC_VPROC_VOSEL_ADDR, MT6328_PMIC_VPROC_VOSEL_MASK,
	 MT6328_PMIC_VPROC_VOSEL_SHIFT},
	{PMIC_VPROC_VOSEL_ON, MT6328_PMIC_VPROC_VOSEL_ON_ADDR, MT6328_PMIC_VPROC_VOSEL_ON_MASK,
	 MT6328_PMIC_VPROC_VOSEL_ON_SHIFT},
	{PMIC_VPROC_VOSEL_SLEEP, MT6328_PMIC_VPROC_VOSEL_SLEEP_ADDR,
	 MT6328_PMIC_VPROC_VOSEL_SLEEP_MASK, MT6328_PMIC_VPROC_VOSEL_SLEEP_SHIFT},
	{PMIC_NI_VPROC_VOSEL, MT6328_PMIC_NI_VPROC_VOSEL_ADDR, MT6328_PMIC_NI_VPROC_VOSEL_MASK,
	 MT6328_PMIC_NI_VPROC_VOSEL_SHIFT},
	{PMIC_VPROC_BURST, MT6328_PMIC_VPROC_BURST_ADDR, MT6328_PMIC_VPROC_BURST_MASK,
	 MT6328_PMIC_VPROC_BURST_SHIFT},
	{PMIC_QI_VPROC_BURST, MT6328_PMIC_QI_VPROC_BURST_ADDR, MT6328_PMIC_QI_VPROC_BURST_MASK,
	 MT6328_PMIC_QI_VPROC_BURST_SHIFT},
	{PMIC_VPROC_DLC, MT6328_PMIC_VPROC_DLC_ADDR, MT6328_PMIC_VPROC_DLC_MASK,
	 MT6328_PMIC_VPROC_DLC_SHIFT},
	{PMIC_QI_VPROC_DLC, MT6328_PMIC_QI_VPROC_DLC_ADDR, MT6328_PMIC_QI_VPROC_DLC_MASK,
	 MT6328_PMIC_QI_VPROC_DLC_SHIFT},
	{PMIC_VPROC_DLC_N, MT6328_PMIC_VPROC_DLC_N_ADDR, MT6328_PMIC_VPROC_DLC_N_MASK,
	 MT6328_PMIC_VPROC_DLC_N_SHIFT},
	{PMIC_QI_VPROC_DLC_N, MT6328_PMIC_QI_VPROC_DLC_N_ADDR, MT6328_PMIC_QI_VPROC_DLC_N_MASK,
	 MT6328_PMIC_QI_VPROC_DLC_N_SHIFT},
	{PMIC_VPROC_TRANS_TD, MT6328_PMIC_VPROC_TRANS_TD_ADDR, MT6328_PMIC_VPROC_TRANS_TD_MASK,
	 MT6328_PMIC_VPROC_TRANS_TD_SHIFT},
	{PMIC_VPROC_TRANS_CTRL, MT6328_PMIC_VPROC_TRANS_CTRL_ADDR,
	 MT6328_PMIC_VPROC_TRANS_CTRL_MASK, MT6328_PMIC_VPROC_TRANS_CTRL_SHIFT},
	{PMIC_VPROC_TRANS_ONCE, MT6328_PMIC_VPROC_TRANS_ONCE_ADDR,
	 MT6328_PMIC_VPROC_TRANS_ONCE_MASK, MT6328_PMIC_VPROC_TRANS_ONCE_SHIFT},
	{PMIC_NI_VPROC_VOSEL_TRANS, MT6328_PMIC_NI_VPROC_VOSEL_TRANS_ADDR,
	 MT6328_PMIC_NI_VPROC_VOSEL_TRANS_MASK, MT6328_PMIC_NI_VPROC_VOSEL_TRANS_SHIFT},
	{PMIC_VPROC_VSLEEP_EN, MT6328_PMIC_VPROC_VSLEEP_EN_ADDR, MT6328_PMIC_VPROC_VSLEEP_EN_MASK,
	 MT6328_PMIC_VPROC_VSLEEP_EN_SHIFT},
	{PMIC_VPROC_R2R_PDN, MT6328_PMIC_VPROC_R2R_PDN_ADDR, MT6328_PMIC_VPROC_R2R_PDN_MASK,
	 MT6328_PMIC_VPROC_R2R_PDN_SHIFT},
	{PMIC_VPROC_VSLEEP_SEL, MT6328_PMIC_VPROC_VSLEEP_SEL_ADDR,
	 MT6328_PMIC_VPROC_VSLEEP_SEL_MASK, MT6328_PMIC_VPROC_VSLEEP_SEL_SHIFT},
	{PMIC_NI_VPROC_R2R_PDN, MT6328_PMIC_NI_VPROC_R2R_PDN_ADDR,
	 MT6328_PMIC_NI_VPROC_R2R_PDN_MASK, MT6328_PMIC_NI_VPROC_R2R_PDN_SHIFT},
	{PMIC_NI_VPROC_VSLEEP_SEL, MT6328_PMIC_NI_VPROC_VSLEEP_SEL_ADDR,
	 MT6328_PMIC_NI_VPROC_VSLEEP_SEL_MASK, MT6328_PMIC_NI_VPROC_VSLEEP_SEL_SHIFT},
	{PMIC_VPROC_OSC_SEL_SRCLKEN_SEL, MT6328_PMIC_VPROC_OSC_SEL_SRCLKEN_SEL_ADDR,
	 MT6328_PMIC_VPROC_OSC_SEL_SRCLKEN_SEL_MASK, MT6328_PMIC_VPROC_OSC_SEL_SRCLKEN_SEL_SHIFT},
	{PMIC_VPROC_R2R_PDN_SRCLKEN_SEL, MT6328_PMIC_VPROC_R2R_PDN_SRCLKEN_SEL_ADDR,
	 MT6328_PMIC_VPROC_R2R_PDN_SRCLKEN_SEL_MASK, MT6328_PMIC_VPROC_R2R_PDN_SRCLKEN_SEL_SHIFT},
	{PMIC_VPROC_VSLEEP_SRCLKEN_SEL, MT6328_PMIC_VPROC_VSLEEP_SRCLKEN_SEL_ADDR,
	 MT6328_PMIC_VPROC_VSLEEP_SRCLKEN_SEL_MASK, MT6328_PMIC_VPROC_VSLEEP_SRCLKEN_SEL_SHIFT},
	{PMIC_VSRAM_DIG0_RSV0, MT6328_PMIC_VSRAM_DIG0_RSV0_ADDR, MT6328_PMIC_VSRAM_DIG0_RSV0_MASK,
	 MT6328_PMIC_VSRAM_DIG0_RSV0_SHIFT},
	{PMIC_VSRAM_DUMMY_RSV1, MT6328_PMIC_VSRAM_DUMMY_RSV1_ADDR,
	 MT6328_PMIC_VSRAM_DUMMY_RSV1_MASK, MT6328_PMIC_VSRAM_DUMMY_RSV1_SHIFT},
	{PMIC_VSRAM_DUMMY_RSV2, MT6328_PMIC_VSRAM_DUMMY_RSV2_ADDR,
	 MT6328_PMIC_VSRAM_DUMMY_RSV2_MASK, MT6328_PMIC_VSRAM_DUMMY_RSV2_SHIFT},
	{PMIC_VSRAM_DUMMY_RSV3, MT6328_PMIC_VSRAM_DUMMY_RSV3_ADDR,
	 MT6328_PMIC_VSRAM_DUMMY_RSV3_MASK, MT6328_PMIC_VSRAM_DUMMY_RSV3_SHIFT},
	{PMIC_VSRAM_DUMMY_RSV4, MT6328_PMIC_VSRAM_DUMMY_RSV4_ADDR,
	 MT6328_PMIC_VSRAM_DUMMY_RSV4_MASK, MT6328_PMIC_VSRAM_DUMMY_RSV4_SHIFT},
	{PMIC_VSRAM_DUMMY_RSV5, MT6328_PMIC_VSRAM_DUMMY_RSV5_ADDR,
	 MT6328_PMIC_VSRAM_DUMMY_RSV5_MASK, MT6328_PMIC_VSRAM_DUMMY_RSV5_SHIFT},
	{PMIC_VSRAM_DUMMY_RSV6, MT6328_PMIC_VSRAM_DUMMY_RSV6_ADDR,
	 MT6328_PMIC_VSRAM_DUMMY_RSV6_MASK, MT6328_PMIC_VSRAM_DUMMY_RSV6_SHIFT},
	{PMIC_VSRAM_EN_CTRL, MT6328_PMIC_VSRAM_EN_CTRL_ADDR, MT6328_PMIC_VSRAM_EN_CTRL_MASK,
	 MT6328_PMIC_VSRAM_EN_CTRL_SHIFT},
	{PMIC_VSRAM_VOSEL_CTRL, MT6328_PMIC_VSRAM_VOSEL_CTRL_ADDR,
	 MT6328_PMIC_VSRAM_VOSEL_CTRL_MASK, MT6328_PMIC_VSRAM_VOSEL_CTRL_SHIFT},
	{PMIC_VSRAM_DIG0_RSV1, MT6328_PMIC_VSRAM_DIG0_RSV1_ADDR, MT6328_PMIC_VSRAM_DIG0_RSV1_MASK,
	 MT6328_PMIC_VSRAM_DIG0_RSV1_SHIFT},
	{PMIC_VSRAM_DIG1_RSV1, MT6328_PMIC_VSRAM_DIG1_RSV1_ADDR, MT6328_PMIC_VSRAM_DIG1_RSV1_MASK,
	 MT6328_PMIC_VSRAM_DIG1_RSV1_SHIFT},
	{PMIC_VSRAM_EN_SEL, MT6328_PMIC_VSRAM_EN_SEL_ADDR, MT6328_PMIC_VSRAM_EN_SEL_MASK,
	 MT6328_PMIC_VSRAM_EN_SEL_SHIFT},
	{PMIC_VSRAM_VOSEL_SEL, MT6328_PMIC_VSRAM_VOSEL_SEL_ADDR, MT6328_PMIC_VSRAM_VOSEL_SEL_MASK,
	 MT6328_PMIC_VSRAM_VOSEL_SEL_SHIFT},
	{PMIC_VSRAM_DIG0_RSV2, MT6328_PMIC_VSRAM_DIG0_RSV2_ADDR, MT6328_PMIC_VSRAM_DIG0_RSV2_MASK,
	 MT6328_PMIC_VSRAM_DIG0_RSV2_SHIFT},
	{PMIC_VSRAM_DIG1_RSV2, MT6328_PMIC_VSRAM_DIG1_RSV2_ADDR, MT6328_PMIC_VSRAM_DIG1_RSV2_MASK,
	 MT6328_PMIC_VSRAM_DIG1_RSV2_SHIFT},
	{PMIC_VSRAM_EN, MT6328_PMIC_VSRAM_EN_ADDR, MT6328_PMIC_VSRAM_EN_MASK,
	 MT6328_PMIC_VSRAM_EN_SHIFT},
	{PMIC_VSRAM_STBTD, MT6328_PMIC_VSRAM_STBTD_ADDR, MT6328_PMIC_VSRAM_STBTD_MASK,
	 MT6328_PMIC_VSRAM_STBTD_SHIFT},
	{PMIC_VSRAM_DIG0_RSV4, MT6328_PMIC_VSRAM_DIG0_RSV4_ADDR, MT6328_PMIC_VSRAM_DIG0_RSV4_MASK,
	 MT6328_PMIC_VSRAM_DIG0_RSV4_SHIFT},
	{PMIC_VSRAM_DIG0_RSV3, MT6328_PMIC_VSRAM_DIG0_RSV3_ADDR, MT6328_PMIC_VSRAM_DIG0_RSV3_MASK,
	 MT6328_PMIC_VSRAM_DIG0_RSV3_SHIFT},
	{PMIC_QI_VSRAM_OC_STATUS, MT6328_PMIC_QI_VSRAM_OC_STATUS_ADDR,
	 MT6328_PMIC_QI_VSRAM_OC_STATUS_MASK, MT6328_PMIC_QI_VSRAM_OC_STATUS_SHIFT},
	{PMIC_VSRAM_SFCHG_FRATE, MT6328_PMIC_VSRAM_SFCHG_FRATE_ADDR,
	 MT6328_PMIC_VSRAM_SFCHG_FRATE_MASK, MT6328_PMIC_VSRAM_SFCHG_FRATE_SHIFT},
	{PMIC_VSRAM_SFCHG_FEN, MT6328_PMIC_VSRAM_SFCHG_FEN_ADDR, MT6328_PMIC_VSRAM_SFCHG_FEN_MASK,
	 MT6328_PMIC_VSRAM_SFCHG_FEN_SHIFT},
	{PMIC_VSRAM_SFCHG_RRATE, MT6328_PMIC_VSRAM_SFCHG_RRATE_ADDR,
	 MT6328_PMIC_VSRAM_SFCHG_RRATE_MASK, MT6328_PMIC_VSRAM_SFCHG_RRATE_SHIFT},
	{PMIC_VSRAM_SFCHG_REN, MT6328_PMIC_VSRAM_SFCHG_REN_ADDR, MT6328_PMIC_VSRAM_SFCHG_REN_MASK,
	 MT6328_PMIC_VSRAM_SFCHG_REN_SHIFT},
	{PMIC_VSRAM_VOSEL_RSV, MT6328_PMIC_VSRAM_VOSEL_RSV_ADDR, MT6328_PMIC_VSRAM_VOSEL_RSV_MASK,
	 MT6328_PMIC_VSRAM_VOSEL_RSV_SHIFT},
	{PMIC_VSRAM_VOSEL_ON, MT6328_PMIC_VSRAM_VOSEL_ON_ADDR, MT6328_PMIC_VSRAM_VOSEL_ON_MASK,
	 MT6328_PMIC_VSRAM_VOSEL_ON_SHIFT},
	{PMIC_VSRAM_VOSEL_SLEEP, MT6328_PMIC_VSRAM_VOSEL_SLEEP_ADDR,
	 MT6328_PMIC_VSRAM_VOSEL_SLEEP_MASK, MT6328_PMIC_VSRAM_VOSEL_SLEEP_SHIFT},
	{PMIC_NI_VSRAM_VOSEL, MT6328_PMIC_NI_VSRAM_VOSEL_ADDR, MT6328_PMIC_NI_VSRAM_VOSEL_MASK,
	 MT6328_PMIC_NI_VSRAM_VOSEL_SHIFT},
	{PMIC_VSRAM_DUMMY_RSV15, MT6328_PMIC_VSRAM_DUMMY_RSV15_ADDR,
	 MT6328_PMIC_VSRAM_DUMMY_RSV15_MASK, MT6328_PMIC_VSRAM_DUMMY_RSV15_SHIFT},
	{PMIC_VSRAM_DUMMY_RSV16, MT6328_PMIC_VSRAM_DUMMY_RSV16_ADDR,
	 MT6328_PMIC_VSRAM_DUMMY_RSV16_MASK, MT6328_PMIC_VSRAM_DUMMY_RSV16_SHIFT},
	{PMIC_VSRAM_DUMMY_RSV17, MT6328_PMIC_VSRAM_DUMMY_RSV17_ADDR,
	 MT6328_PMIC_VSRAM_DUMMY_RSV17_MASK, MT6328_PMIC_VSRAM_DUMMY_RSV17_SHIFT},
	{PMIC_VSRAM_TRANS_TD, MT6328_PMIC_VSRAM_TRANS_TD_ADDR, MT6328_PMIC_VSRAM_TRANS_TD_MASK,
	 MT6328_PMIC_VSRAM_TRANS_TD_SHIFT},
	{PMIC_VSRAM_TRANS_CTRL, MT6328_PMIC_VSRAM_TRANS_CTRL_ADDR,
	 MT6328_PMIC_VSRAM_TRANS_CTRL_MASK, MT6328_PMIC_VSRAM_TRANS_CTRL_SHIFT},
	{PMIC_VSRAM_TRANS_ONCE, MT6328_PMIC_VSRAM_TRANS_ONCE_ADDR,
	 MT6328_PMIC_VSRAM_TRANS_ONCE_MASK, MT6328_PMIC_VSRAM_TRANS_ONCE_SHIFT},
	{PMIC_NI_VSRAM_VOSEL_TRANS, MT6328_PMIC_NI_VSRAM_VOSEL_TRANS_ADDR,
	 MT6328_PMIC_NI_VSRAM_VOSEL_TRANS_MASK, MT6328_PMIC_NI_VSRAM_VOSEL_TRANS_SHIFT},
	{PMIC_VSRAM_VSLEEP_EN, MT6328_PMIC_VSRAM_VSLEEP_EN_ADDR, MT6328_PMIC_VSRAM_VSLEEP_EN_MASK,
	 MT6328_PMIC_VSRAM_VSLEEP_EN_SHIFT},
	{PMIC_VSRAM_R2R_PDN, MT6328_PMIC_VSRAM_R2R_PDN_ADDR, MT6328_PMIC_VSRAM_R2R_PDN_MASK,
	 MT6328_PMIC_VSRAM_R2R_PDN_SHIFT},
	{PMIC_VSRAM_VSLEEP_SEL, MT6328_PMIC_VSRAM_VSLEEP_SEL_ADDR,
	 MT6328_PMIC_VSRAM_VSLEEP_SEL_MASK, MT6328_PMIC_VSRAM_VSLEEP_SEL_SHIFT},
	{PMIC_NI_VSRAM_R2R_PDN, MT6328_PMIC_NI_VSRAM_R2R_PDN_ADDR,
	 MT6328_PMIC_NI_VSRAM_R2R_PDN_MASK, MT6328_PMIC_NI_VSRAM_R2R_PDN_SHIFT},
	{PMIC_NI_VSRAM_VSLEEP_SEL, MT6328_PMIC_NI_VSRAM_VSLEEP_SEL_ADDR,
	 MT6328_PMIC_NI_VSRAM_VSLEEP_SEL_MASK, MT6328_PMIC_NI_VSRAM_VSLEEP_SEL_SHIFT},
	{PMIC_VSRAM_OSC_SEL_SRCLKEN_SEL, MT6328_PMIC_VSRAM_OSC_SEL_SRCLKEN_SEL_ADDR,
	 MT6328_PMIC_VSRAM_OSC_SEL_SRCLKEN_SEL_MASK, MT6328_PMIC_VSRAM_OSC_SEL_SRCLKEN_SEL_SHIFT},
	{PMIC_VSRAM_R2R_PDN_SRCLKEN_SEL, MT6328_PMIC_VSRAM_R2R_PDN_SRCLKEN_SEL_ADDR,
	 MT6328_PMIC_VSRAM_R2R_PDN_SRCLKEN_SEL_MASK, MT6328_PMIC_VSRAM_R2R_PDN_SRCLKEN_SEL_SHIFT},
	{PMIC_VSRAM_VSLEEP_SRCLKEN_SEL, MT6328_PMIC_VSRAM_VSLEEP_SRCLKEN_SEL_ADDR,
	 MT6328_PMIC_VSRAM_VSLEEP_SRCLKEN_SEL_MASK, MT6328_PMIC_VSRAM_VSLEEP_SRCLKEN_SEL_SHIFT},
	{PMIC_VLTE_DIG0_RSV0, MT6328_PMIC_VLTE_DIG0_RSV0_ADDR, MT6328_PMIC_VLTE_DIG0_RSV0_MASK,
	 MT6328_PMIC_VLTE_DIG0_RSV0_SHIFT},
	{PMIC_VLTE_DUMMY_RSV1, MT6328_PMIC_VLTE_DUMMY_RSV1_ADDR, MT6328_PMIC_VLTE_DUMMY_RSV1_MASK,
	 MT6328_PMIC_VLTE_DUMMY_RSV1_SHIFT},
	{PMIC_VLTE_DUMMY_RSV2, MT6328_PMIC_VLTE_DUMMY_RSV2_ADDR, MT6328_PMIC_VLTE_DUMMY_RSV2_MASK,
	 MT6328_PMIC_VLTE_DUMMY_RSV2_SHIFT},
	{PMIC_VLTE_DUMMY_RSV3, MT6328_PMIC_VLTE_DUMMY_RSV3_ADDR, MT6328_PMIC_VLTE_DUMMY_RSV3_MASK,
	 MT6328_PMIC_VLTE_DUMMY_RSV3_SHIFT},
	{PMIC_VLTE_DUMMY_RSV4, MT6328_PMIC_VLTE_DUMMY_RSV4_ADDR, MT6328_PMIC_VLTE_DUMMY_RSV4_MASK,
	 MT6328_PMIC_VLTE_DUMMY_RSV4_SHIFT},
	{PMIC_VLTE_DUMMY_RSV5, MT6328_PMIC_VLTE_DUMMY_RSV5_ADDR, MT6328_PMIC_VLTE_DUMMY_RSV5_MASK,
	 MT6328_PMIC_VLTE_DUMMY_RSV5_SHIFT},
	{PMIC_VLTE_DUMMY_RSV6, MT6328_PMIC_VLTE_DUMMY_RSV6_ADDR, MT6328_PMIC_VLTE_DUMMY_RSV6_MASK,
	 MT6328_PMIC_VLTE_DUMMY_RSV6_SHIFT},
	{PMIC_VLTE_EN_CTRL, MT6328_PMIC_VLTE_EN_CTRL_ADDR, MT6328_PMIC_VLTE_EN_CTRL_MASK,
	 MT6328_PMIC_VLTE_EN_CTRL_SHIFT},
	{PMIC_VLTE_VOSEL_CTRL, MT6328_PMIC_VLTE_VOSEL_CTRL_ADDR, MT6328_PMIC_VLTE_VOSEL_CTRL_MASK,
	 MT6328_PMIC_VLTE_VOSEL_CTRL_SHIFT},
	{PMIC_VLTE_DIG0_RSV1, MT6328_PMIC_VLTE_DIG0_RSV1_ADDR, MT6328_PMIC_VLTE_DIG0_RSV1_MASK,
	 MT6328_PMIC_VLTE_DIG0_RSV1_SHIFT},
	{PMIC_VLTE_DIG1_RSV1, MT6328_PMIC_VLTE_DIG1_RSV1_ADDR, MT6328_PMIC_VLTE_DIG1_RSV1_MASK,
	 MT6328_PMIC_VLTE_DIG1_RSV1_SHIFT},
	{PMIC_VLTE_EN_SEL, MT6328_PMIC_VLTE_EN_SEL_ADDR, MT6328_PMIC_VLTE_EN_SEL_MASK,
	 MT6328_PMIC_VLTE_EN_SEL_SHIFT},
	{PMIC_VLTE_VOSEL_SEL, MT6328_PMIC_VLTE_VOSEL_SEL_ADDR, MT6328_PMIC_VLTE_VOSEL_SEL_MASK,
	 MT6328_PMIC_VLTE_VOSEL_SEL_SHIFT},
	{PMIC_VLTE_DIG0_RSV2, MT6328_PMIC_VLTE_DIG0_RSV2_ADDR, MT6328_PMIC_VLTE_DIG0_RSV2_MASK,
	 MT6328_PMIC_VLTE_DIG0_RSV2_SHIFT},
	{PMIC_VLTE_DIG1_RSV2, MT6328_PMIC_VLTE_DIG1_RSV2_ADDR, MT6328_PMIC_VLTE_DIG1_RSV2_MASK,
	 MT6328_PMIC_VLTE_DIG1_RSV2_SHIFT},
	{PMIC_VLTE_EN, MT6328_PMIC_VLTE_EN_ADDR, MT6328_PMIC_VLTE_EN_MASK,
	 MT6328_PMIC_VLTE_EN_SHIFT},
	{PMIC_VLTE_STBTD, MT6328_PMIC_VLTE_STBTD_ADDR, MT6328_PMIC_VLTE_STBTD_MASK,
	 MT6328_PMIC_VLTE_STBTD_SHIFT},
	{PMIC_QI_VLTE_STB, MT6328_PMIC_QI_VLTE_STB_ADDR, MT6328_PMIC_QI_VLTE_STB_MASK,
	 MT6328_PMIC_QI_VLTE_STB_SHIFT},
	{PMIC_QI_VLTE_EN, MT6328_PMIC_QI_VLTE_EN_ADDR, MT6328_PMIC_QI_VLTE_EN_MASK,
	 MT6328_PMIC_QI_VLTE_EN_SHIFT},
	{PMIC_QI_VLTE_OC_STATUS, MT6328_PMIC_QI_VLTE_OC_STATUS_ADDR,
	 MT6328_PMIC_QI_VLTE_OC_STATUS_MASK, MT6328_PMIC_QI_VLTE_OC_STATUS_SHIFT},
	{PMIC_VLTE_SFCHG_FRATE, MT6328_PMIC_VLTE_SFCHG_FRATE_ADDR,
	 MT6328_PMIC_VLTE_SFCHG_FRATE_MASK, MT6328_PMIC_VLTE_SFCHG_FRATE_SHIFT},
	{PMIC_VLTE_SFCHG_FEN, MT6328_PMIC_VLTE_SFCHG_FEN_ADDR, MT6328_PMIC_VLTE_SFCHG_FEN_MASK,
	 MT6328_PMIC_VLTE_SFCHG_FEN_SHIFT},
	{PMIC_VLTE_SFCHG_RRATE, MT6328_PMIC_VLTE_SFCHG_RRATE_ADDR,
	 MT6328_PMIC_VLTE_SFCHG_RRATE_MASK, MT6328_PMIC_VLTE_SFCHG_RRATE_SHIFT},
	{PMIC_VLTE_SFCHG_REN, MT6328_PMIC_VLTE_SFCHG_REN_ADDR, MT6328_PMIC_VLTE_SFCHG_REN_MASK,
	 MT6328_PMIC_VLTE_SFCHG_REN_SHIFT},
	{PMIC_VLTE_VOSEL, MT6328_PMIC_VLTE_VOSEL_ADDR, MT6328_PMIC_VLTE_VOSEL_MASK,
	 MT6328_PMIC_VLTE_VOSEL_SHIFT},
	{PMIC_VLTE_VOSEL_ON, MT6328_PMIC_VLTE_VOSEL_ON_ADDR, MT6328_PMIC_VLTE_VOSEL_ON_MASK,
	 MT6328_PMIC_VLTE_VOSEL_ON_SHIFT},
	{PMIC_VLTE_VOSEL_SLEEP, MT6328_PMIC_VLTE_VOSEL_SLEEP_ADDR,
	 MT6328_PMIC_VLTE_VOSEL_SLEEP_MASK, MT6328_PMIC_VLTE_VOSEL_SLEEP_SHIFT},
	{PMIC_NI_VLTE_VOSEL, MT6328_PMIC_NI_VLTE_VOSEL_ADDR, MT6328_PMIC_NI_VLTE_VOSEL_MASK,
	 MT6328_PMIC_NI_VLTE_VOSEL_SHIFT},
	{PMIC_VLTE_BURST, MT6328_PMIC_VLTE_BURST_ADDR, MT6328_PMIC_VLTE_BURST_MASK,
	 MT6328_PMIC_VLTE_BURST_SHIFT},
	{PMIC_QI_VLTE_BURST, MT6328_PMIC_QI_VLTE_BURST_ADDR, MT6328_PMIC_QI_VLTE_BURST_MASK,
	 MT6328_PMIC_QI_VLTE_BURST_SHIFT},
	{PMIC_VLTE_DLC, MT6328_PMIC_VLTE_DLC_ADDR, MT6328_PMIC_VLTE_DLC_MASK,
	 MT6328_PMIC_VLTE_DLC_SHIFT},
	{PMIC_QI_VLTE_DLC, MT6328_PMIC_QI_VLTE_DLC_ADDR, MT6328_PMIC_QI_VLTE_DLC_MASK,
	 MT6328_PMIC_QI_VLTE_DLC_SHIFT},
	{PMIC_VLTE_DLC_N, MT6328_PMIC_VLTE_DLC_N_ADDR, MT6328_PMIC_VLTE_DLC_N_MASK,
	 MT6328_PMIC_VLTE_DLC_N_SHIFT},
	{PMIC_QI_VLTE_DLC_N, MT6328_PMIC_QI_VLTE_DLC_N_ADDR, MT6328_PMIC_QI_VLTE_DLC_N_MASK,
	 MT6328_PMIC_QI_VLTE_DLC_N_SHIFT},
	{PMIC_VLTE_TRANS_TD, MT6328_PMIC_VLTE_TRANS_TD_ADDR, MT6328_PMIC_VLTE_TRANS_TD_MASK,
	 MT6328_PMIC_VLTE_TRANS_TD_SHIFT},
	{PMIC_VLTE_TRANS_CTRL, MT6328_PMIC_VLTE_TRANS_CTRL_ADDR, MT6328_PMIC_VLTE_TRANS_CTRL_MASK,
	 MT6328_PMIC_VLTE_TRANS_CTRL_SHIFT},
	{PMIC_VLTE_TRANS_ONCE, MT6328_PMIC_VLTE_TRANS_ONCE_ADDR, MT6328_PMIC_VLTE_TRANS_ONCE_MASK,
	 MT6328_PMIC_VLTE_TRANS_ONCE_SHIFT},
	{PMIC_NI_VLTE_VOSEL_TRANS, MT6328_PMIC_NI_VLTE_VOSEL_TRANS_ADDR,
	 MT6328_PMIC_NI_VLTE_VOSEL_TRANS_MASK, MT6328_PMIC_NI_VLTE_VOSEL_TRANS_SHIFT},
	{PMIC_VLTE_VSLEEP_EN, MT6328_PMIC_VLTE_VSLEEP_EN_ADDR, MT6328_PMIC_VLTE_VSLEEP_EN_MASK,
	 MT6328_PMIC_VLTE_VSLEEP_EN_SHIFT},
	{PMIC_VLTE_R2R_PDN, MT6328_PMIC_VLTE_R2R_PDN_ADDR, MT6328_PMIC_VLTE_R2R_PDN_MASK,
	 MT6328_PMIC_VLTE_R2R_PDN_SHIFT},
	{PMIC_VLTE_VSLEEP_SEL, MT6328_PMIC_VLTE_VSLEEP_SEL_ADDR, MT6328_PMIC_VLTE_VSLEEP_SEL_MASK,
	 MT6328_PMIC_VLTE_VSLEEP_SEL_SHIFT},
	{PMIC_NI_VLTE_R2R_PDN, MT6328_PMIC_NI_VLTE_R2R_PDN_ADDR, MT6328_PMIC_NI_VLTE_R2R_PDN_MASK,
	 MT6328_PMIC_NI_VLTE_R2R_PDN_SHIFT},
	{PMIC_NI_VLTE_VSLEEP_SEL, MT6328_PMIC_NI_VLTE_VSLEEP_SEL_ADDR,
	 MT6328_PMIC_NI_VLTE_VSLEEP_SEL_MASK, MT6328_PMIC_NI_VLTE_VSLEEP_SEL_SHIFT},
	{PMIC_VLTE_OSC_SEL_SRCLKEN_SEL, MT6328_PMIC_VLTE_OSC_SEL_SRCLKEN_SEL_ADDR,
	 MT6328_PMIC_VLTE_OSC_SEL_SRCLKEN_SEL_MASK, MT6328_PMIC_VLTE_OSC_SEL_SRCLKEN_SEL_SHIFT},
	{PMIC_VLTE_R2R_PDN_SRCLKEN_SEL, MT6328_PMIC_VLTE_R2R_PDN_SRCLKEN_SEL_ADDR,
	 MT6328_PMIC_VLTE_R2R_PDN_SRCLKEN_SEL_MASK, MT6328_PMIC_VLTE_R2R_PDN_SRCLKEN_SEL_SHIFT},
	{PMIC_VLTE_VSLEEP_SRCLKEN_SEL, MT6328_PMIC_VLTE_VSLEEP_SRCLKEN_SEL_ADDR,
	 MT6328_PMIC_VLTE_VSLEEP_SRCLKEN_SEL_MASK, MT6328_PMIC_VLTE_VSLEEP_SRCLKEN_SEL_SHIFT},
	{PMIC_VCORE1_DIG0_RSV0, MT6328_PMIC_VCORE1_DIG0_RSV0_ADDR,
	 MT6328_PMIC_VCORE1_DIG0_RSV0_MASK, MT6328_PMIC_VCORE1_DIG0_RSV0_SHIFT},
	{PMIC_VCORE1_DUMMY_RSV1, MT6328_PMIC_VCORE1_DUMMY_RSV1_ADDR,
	 MT6328_PMIC_VCORE1_DUMMY_RSV1_MASK, MT6328_PMIC_VCORE1_DUMMY_RSV1_SHIFT},
	{PMIC_VCORE1_DUMMY_RSV2, MT6328_PMIC_VCORE1_DUMMY_RSV2_ADDR,
	 MT6328_PMIC_VCORE1_DUMMY_RSV2_MASK, MT6328_PMIC_VCORE1_DUMMY_RSV2_SHIFT},
	{PMIC_VCORE1_DUMMY_RSV3, MT6328_PMIC_VCORE1_DUMMY_RSV3_ADDR,
	 MT6328_PMIC_VCORE1_DUMMY_RSV3_MASK, MT6328_PMIC_VCORE1_DUMMY_RSV3_SHIFT},
	{PMIC_VCORE1_DUMMY_RSV4, MT6328_PMIC_VCORE1_DUMMY_RSV4_ADDR,
	 MT6328_PMIC_VCORE1_DUMMY_RSV4_MASK, MT6328_PMIC_VCORE1_DUMMY_RSV4_SHIFT},
	{PMIC_VCORE1_DUMMY_RSV5, MT6328_PMIC_VCORE1_DUMMY_RSV5_ADDR,
	 MT6328_PMIC_VCORE1_DUMMY_RSV5_MASK, MT6328_PMIC_VCORE1_DUMMY_RSV5_SHIFT},
	{PMIC_VCORE1_DUMMY_RSV6, MT6328_PMIC_VCORE1_DUMMY_RSV6_ADDR,
	 MT6328_PMIC_VCORE1_DUMMY_RSV6_MASK, MT6328_PMIC_VCORE1_DUMMY_RSV6_SHIFT},
	{PMIC_VCORE1_EN_CTRL, MT6328_PMIC_VCORE1_EN_CTRL_ADDR, MT6328_PMIC_VCORE1_EN_CTRL_MASK,
	 MT6328_PMIC_VCORE1_EN_CTRL_SHIFT},
	{PMIC_VCORE1_VOSEL_CTRL, MT6328_PMIC_VCORE1_VOSEL_CTRL_ADDR,
	 MT6328_PMIC_VCORE1_VOSEL_CTRL_MASK, MT6328_PMIC_VCORE1_VOSEL_CTRL_SHIFT},
	{PMIC_VCORE1_DIG0_RSV1, MT6328_PMIC_VCORE1_DIG0_RSV1_ADDR,
	 MT6328_PMIC_VCORE1_DIG0_RSV1_MASK, MT6328_PMIC_VCORE1_DIG0_RSV1_SHIFT},
	{PMIC_VCORE1_DIG1_RSV1, MT6328_PMIC_VCORE1_DIG1_RSV1_ADDR,
	 MT6328_PMIC_VCORE1_DIG1_RSV1_MASK, MT6328_PMIC_VCORE1_DIG1_RSV1_SHIFT},
	{PMIC_VCORE1_EN_SEL, MT6328_PMIC_VCORE1_EN_SEL_ADDR, MT6328_PMIC_VCORE1_EN_SEL_MASK,
	 MT6328_PMIC_VCORE1_EN_SEL_SHIFT},
	{PMIC_VCORE1_VOSEL_SEL, MT6328_PMIC_VCORE1_VOSEL_SEL_ADDR,
	 MT6328_PMIC_VCORE1_VOSEL_SEL_MASK, MT6328_PMIC_VCORE1_VOSEL_SEL_SHIFT},
	{PMIC_VCORE1_DIG0_RSV2, MT6328_PMIC_VCORE1_DIG0_RSV2_ADDR,
	 MT6328_PMIC_VCORE1_DIG0_RSV2_MASK, MT6328_PMIC_VCORE1_DIG0_RSV2_SHIFT},
	{PMIC_VCORE1_DIG1_RSV2, MT6328_PMIC_VCORE1_DIG1_RSV2_ADDR,
	 MT6328_PMIC_VCORE1_DIG1_RSV2_MASK, MT6328_PMIC_VCORE1_DIG1_RSV2_SHIFT},
	{PMIC_VCORE1_EN, MT6328_PMIC_VCORE1_EN_ADDR, MT6328_PMIC_VCORE1_EN_MASK,
	 MT6328_PMIC_VCORE1_EN_SHIFT},
	{PMIC_VCORE1_STBTD, MT6328_PMIC_VCORE1_STBTD_ADDR, MT6328_PMIC_VCORE1_STBTD_MASK,
	 MT6328_PMIC_VCORE1_STBTD_SHIFT},
	{PMIC_QI_VCORE1_STB, MT6328_PMIC_QI_VCORE1_STB_ADDR, MT6328_PMIC_QI_VCORE1_STB_MASK,
	 MT6328_PMIC_QI_VCORE1_STB_SHIFT},
	{PMIC_QI_VCORE1_EN, MT6328_PMIC_QI_VCORE1_EN_ADDR, MT6328_PMIC_QI_VCORE1_EN_MASK,
	 MT6328_PMIC_QI_VCORE1_EN_SHIFT},
	{PMIC_QI_VCORE1_OC_STATUS, MT6328_PMIC_QI_VCORE1_OC_STATUS_ADDR,
	 MT6328_PMIC_QI_VCORE1_OC_STATUS_MASK, MT6328_PMIC_QI_VCORE1_OC_STATUS_SHIFT},
	{PMIC_VCORE1_SFCHG_FRATE, MT6328_PMIC_VCORE1_SFCHG_FRATE_ADDR,
	 MT6328_PMIC_VCORE1_SFCHG_FRATE_MASK, MT6328_PMIC_VCORE1_SFCHG_FRATE_SHIFT},
	{PMIC_VCORE1_SFCHG_FEN, MT6328_PMIC_VCORE1_SFCHG_FEN_ADDR,
	 MT6328_PMIC_VCORE1_SFCHG_FEN_MASK, MT6328_PMIC_VCORE1_SFCHG_FEN_SHIFT},
	{PMIC_VCORE1_SFCHG_RRATE, MT6328_PMIC_VCORE1_SFCHG_RRATE_ADDR,
	 MT6328_PMIC_VCORE1_SFCHG_RRATE_MASK, MT6328_PMIC_VCORE1_SFCHG_RRATE_SHIFT},
	{PMIC_VCORE1_SFCHG_REN, MT6328_PMIC_VCORE1_SFCHG_REN_ADDR,
	 MT6328_PMIC_VCORE1_SFCHG_REN_MASK, MT6328_PMIC_VCORE1_SFCHG_REN_SHIFT},
	{PMIC_VCORE1_VOSEL, MT6328_PMIC_VCORE1_VOSEL_ADDR, MT6328_PMIC_VCORE1_VOSEL_MASK,
	 MT6328_PMIC_VCORE1_VOSEL_SHIFT},
	{PMIC_VCORE1_VOSEL_ON, MT6328_PMIC_VCORE1_VOSEL_ON_ADDR, MT6328_PMIC_VCORE1_VOSEL_ON_MASK,
	 MT6328_PMIC_VCORE1_VOSEL_ON_SHIFT},
	{PMIC_VCORE1_VOSEL_SLEEP, MT6328_PMIC_VCORE1_VOSEL_SLEEP_ADDR,
	 MT6328_PMIC_VCORE1_VOSEL_SLEEP_MASK, MT6328_PMIC_VCORE1_VOSEL_SLEEP_SHIFT},
	{PMIC_NI_VCORE1_VOSEL, MT6328_PMIC_NI_VCORE1_VOSEL_ADDR, MT6328_PMIC_NI_VCORE1_VOSEL_MASK,
	 MT6328_PMIC_NI_VCORE1_VOSEL_SHIFT},
	{PMIC_VCORE1_BURST, MT6328_PMIC_VCORE1_BURST_ADDR, MT6328_PMIC_VCORE1_BURST_MASK,
	 MT6328_PMIC_VCORE1_BURST_SHIFT},
	{PMIC_QI_VCORE1_BURST, MT6328_PMIC_QI_VCORE1_BURST_ADDR, MT6328_PMIC_QI_VCORE1_BURST_MASK,
	 MT6328_PMIC_QI_VCORE1_BURST_SHIFT},
	{PMIC_VCORE1_DLC, MT6328_PMIC_VCORE1_DLC_ADDR, MT6328_PMIC_VCORE1_DLC_MASK,
	 MT6328_PMIC_VCORE1_DLC_SHIFT},
	{PMIC_QI_VCORE1_DLC, MT6328_PMIC_QI_VCORE1_DLC_ADDR, MT6328_PMIC_QI_VCORE1_DLC_MASK,
	 MT6328_PMIC_QI_VCORE1_DLC_SHIFT},
	{PMIC_VCORE1_DLC_N, MT6328_PMIC_VCORE1_DLC_N_ADDR, MT6328_PMIC_VCORE1_DLC_N_MASK,
	 MT6328_PMIC_VCORE1_DLC_N_SHIFT},
	{PMIC_QI_VCORE1_DLC_N, MT6328_PMIC_QI_VCORE1_DLC_N_ADDR, MT6328_PMIC_QI_VCORE1_DLC_N_MASK,
	 MT6328_PMIC_QI_VCORE1_DLC_N_SHIFT},
	{PMIC_VCORE1_TRANS_TD, MT6328_PMIC_VCORE1_TRANS_TD_ADDR, MT6328_PMIC_VCORE1_TRANS_TD_MASK,
	 MT6328_PMIC_VCORE1_TRANS_TD_SHIFT},
	{PMIC_VCORE1_TRANS_CTRL, MT6328_PMIC_VCORE1_TRANS_CTRL_ADDR,
	 MT6328_PMIC_VCORE1_TRANS_CTRL_MASK, MT6328_PMIC_VCORE1_TRANS_CTRL_SHIFT},
	{PMIC_VCORE1_TRANS_ONCE, MT6328_PMIC_VCORE1_TRANS_ONCE_ADDR,
	 MT6328_PMIC_VCORE1_TRANS_ONCE_MASK, MT6328_PMIC_VCORE1_TRANS_ONCE_SHIFT},
	{PMIC_NI_VCORE1_VOSEL_TRANS, MT6328_PMIC_NI_VCORE1_VOSEL_TRANS_ADDR,
	 MT6328_PMIC_NI_VCORE1_VOSEL_TRANS_MASK, MT6328_PMIC_NI_VCORE1_VOSEL_TRANS_SHIFT},
	{PMIC_VCORE1_VSLEEP_EN, MT6328_PMIC_VCORE1_VSLEEP_EN_ADDR,
	 MT6328_PMIC_VCORE1_VSLEEP_EN_MASK, MT6328_PMIC_VCORE1_VSLEEP_EN_SHIFT},
	{PMIC_VCORE1_R2R_PDN, MT6328_PMIC_VCORE1_R2R_PDN_ADDR, MT6328_PMIC_VCORE1_R2R_PDN_MASK,
	 MT6328_PMIC_VCORE1_R2R_PDN_SHIFT},
	{PMIC_VCORE1_VSLEEP_SEL, MT6328_PMIC_VCORE1_VSLEEP_SEL_ADDR,
	 MT6328_PMIC_VCORE1_VSLEEP_SEL_MASK, MT6328_PMIC_VCORE1_VSLEEP_SEL_SHIFT},
	{PMIC_NI_VCORE1_R2R_PDN, MT6328_PMIC_NI_VCORE1_R2R_PDN_ADDR,
	 MT6328_PMIC_NI_VCORE1_R2R_PDN_MASK, MT6328_PMIC_NI_VCORE1_R2R_PDN_SHIFT},
	{PMIC_NI_VCORE1_VSLEEP_SEL, MT6328_PMIC_NI_VCORE1_VSLEEP_SEL_ADDR,
	 MT6328_PMIC_NI_VCORE1_VSLEEP_SEL_MASK, MT6328_PMIC_NI_VCORE1_VSLEEP_SEL_SHIFT},
	{PMIC_VCORE1_OSC_SEL_SRCLKEN_SEL, MT6328_PMIC_VCORE1_OSC_SEL_SRCLKEN_SEL_ADDR,
	 MT6328_PMIC_VCORE1_OSC_SEL_SRCLKEN_SEL_MASK, MT6328_PMIC_VCORE1_OSC_SEL_SRCLKEN_SEL_SHIFT},
	{PMIC_VCORE1_R2R_PDN_SRCLKEN_SEL, MT6328_PMIC_VCORE1_R2R_PDN_SRCLKEN_SEL_ADDR,
	 MT6328_PMIC_VCORE1_R2R_PDN_SRCLKEN_SEL_MASK, MT6328_PMIC_VCORE1_R2R_PDN_SRCLKEN_SEL_SHIFT},
	{PMIC_VCORE1_VSLEEP_SRCLKEN_SEL, MT6328_PMIC_VCORE1_VSLEEP_SRCLKEN_SEL_ADDR,
	 MT6328_PMIC_VCORE1_VSLEEP_SRCLKEN_SEL_MASK, MT6328_PMIC_VCORE1_VSLEEP_SRCLKEN_SEL_SHIFT},
	{PMIC_VSYS22_DIG0_RSV0, MT6328_PMIC_VSYS22_DIG0_RSV0_ADDR,
	 MT6328_PMIC_VSYS22_DIG0_RSV0_MASK, MT6328_PMIC_VSYS22_DIG0_RSV0_SHIFT},
	{PMIC_VSYS22_DUMMY_RSV1, MT6328_PMIC_VSYS22_DUMMY_RSV1_ADDR,
	 MT6328_PMIC_VSYS22_DUMMY_RSV1_MASK, MT6328_PMIC_VSYS22_DUMMY_RSV1_SHIFT},
	{PMIC_VSYS22_DUMMY_RSV2, MT6328_PMIC_VSYS22_DUMMY_RSV2_ADDR,
	 MT6328_PMIC_VSYS22_DUMMY_RSV2_MASK, MT6328_PMIC_VSYS22_DUMMY_RSV2_SHIFT},
	{PMIC_VSYS22_DUMMY_RSV3, MT6328_PMIC_VSYS22_DUMMY_RSV3_ADDR,
	 MT6328_PMIC_VSYS22_DUMMY_RSV3_MASK, MT6328_PMIC_VSYS22_DUMMY_RSV3_SHIFT},
	{PMIC_VSYS22_DUMMY_RSV4, MT6328_PMIC_VSYS22_DUMMY_RSV4_ADDR,
	 MT6328_PMIC_VSYS22_DUMMY_RSV4_MASK, MT6328_PMIC_VSYS22_DUMMY_RSV4_SHIFT},
	{PMIC_VSYS22_DUMMY_RSV5, MT6328_PMIC_VSYS22_DUMMY_RSV5_ADDR,
	 MT6328_PMIC_VSYS22_DUMMY_RSV5_MASK, MT6328_PMIC_VSYS22_DUMMY_RSV5_SHIFT},
	{PMIC_VSYS22_DUMMY_RSV6, MT6328_PMIC_VSYS22_DUMMY_RSV6_ADDR,
	 MT6328_PMIC_VSYS22_DUMMY_RSV6_MASK, MT6328_PMIC_VSYS22_DUMMY_RSV6_SHIFT},
	{PMIC_VSYS22_EN_CTRL, MT6328_PMIC_VSYS22_EN_CTRL_ADDR, MT6328_PMIC_VSYS22_EN_CTRL_MASK,
	 MT6328_PMIC_VSYS22_EN_CTRL_SHIFT},
	{PMIC_VSYS22_VOSEL_CTRL, MT6328_PMIC_VSYS22_VOSEL_CTRL_ADDR,
	 MT6328_PMIC_VSYS22_VOSEL_CTRL_MASK, MT6328_PMIC_VSYS22_VOSEL_CTRL_SHIFT},
	{PMIC_VSYS22_DIG0_RSV1, MT6328_PMIC_VSYS22_DIG0_RSV1_ADDR,
	 MT6328_PMIC_VSYS22_DIG0_RSV1_MASK, MT6328_PMIC_VSYS22_DIG0_RSV1_SHIFT},
	{PMIC_VSYS22_DIG1_RSV1, MT6328_PMIC_VSYS22_DIG1_RSV1_ADDR,
	 MT6328_PMIC_VSYS22_DIG1_RSV1_MASK, MT6328_PMIC_VSYS22_DIG1_RSV1_SHIFT},
	{PMIC_VSYS22_EN_SEL, MT6328_PMIC_VSYS22_EN_SEL_ADDR, MT6328_PMIC_VSYS22_EN_SEL_MASK,
	 MT6328_PMIC_VSYS22_EN_SEL_SHIFT},
	{PMIC_VSYS22_VOSEL_SEL, MT6328_PMIC_VSYS22_VOSEL_SEL_ADDR,
	 MT6328_PMIC_VSYS22_VOSEL_SEL_MASK, MT6328_PMIC_VSYS22_VOSEL_SEL_SHIFT},
	{PMIC_VSYS22_DIG0_RSV2, MT6328_PMIC_VSYS22_DIG0_RSV2_ADDR,
	 MT6328_PMIC_VSYS22_DIG0_RSV2_MASK, MT6328_PMIC_VSYS22_DIG0_RSV2_SHIFT},
	{PMIC_VSYS22_DIG1_RSV2, MT6328_PMIC_VSYS22_DIG1_RSV2_ADDR,
	 MT6328_PMIC_VSYS22_DIG1_RSV2_MASK, MT6328_PMIC_VSYS22_DIG1_RSV2_SHIFT},
	{PMIC_VSYS22_EN, MT6328_PMIC_VSYS22_EN_ADDR, MT6328_PMIC_VSYS22_EN_MASK,
	 MT6328_PMIC_VSYS22_EN_SHIFT},
	{PMIC_VSYS22_STBTD, MT6328_PMIC_VSYS22_STBTD_ADDR, MT6328_PMIC_VSYS22_STBTD_MASK,
	 MT6328_PMIC_VSYS22_STBTD_SHIFT},
	{PMIC_QI_VSYS22_STB, MT6328_PMIC_QI_VSYS22_STB_ADDR, MT6328_PMIC_QI_VSYS22_STB_MASK,
	 MT6328_PMIC_QI_VSYS22_STB_SHIFT},
	{PMIC_QI_VSYS22_EN, MT6328_PMIC_QI_VSYS22_EN_ADDR, MT6328_PMIC_QI_VSYS22_EN_MASK,
	 MT6328_PMIC_QI_VSYS22_EN_SHIFT},
	{PMIC_QI_VSYS22_OC_STATUS, MT6328_PMIC_QI_VSYS22_OC_STATUS_ADDR,
	 MT6328_PMIC_QI_VSYS22_OC_STATUS_MASK, MT6328_PMIC_QI_VSYS22_OC_STATUS_SHIFT},
	{PMIC_VSYS22_SFCHG_FRATE, MT6328_PMIC_VSYS22_SFCHG_FRATE_ADDR,
	 MT6328_PMIC_VSYS22_SFCHG_FRATE_MASK, MT6328_PMIC_VSYS22_SFCHG_FRATE_SHIFT},
	{PMIC_VSYS22_SFCHG_FEN, MT6328_PMIC_VSYS22_SFCHG_FEN_ADDR,
	 MT6328_PMIC_VSYS22_SFCHG_FEN_MASK, MT6328_PMIC_VSYS22_SFCHG_FEN_SHIFT},
	{PMIC_VSYS22_SFCHG_RRATE, MT6328_PMIC_VSYS22_SFCHG_RRATE_ADDR,
	 MT6328_PMIC_VSYS22_SFCHG_RRATE_MASK, MT6328_PMIC_VSYS22_SFCHG_RRATE_SHIFT},
	{PMIC_VSYS22_SFCHG_REN, MT6328_PMIC_VSYS22_SFCHG_REN_ADDR,
	 MT6328_PMIC_VSYS22_SFCHG_REN_MASK, MT6328_PMIC_VSYS22_SFCHG_REN_SHIFT},
	{PMIC_VSYS22_VOSEL, MT6328_PMIC_VSYS22_VOSEL_ADDR, MT6328_PMIC_VSYS22_VOSEL_MASK,
	 MT6328_PMIC_VSYS22_VOSEL_SHIFT},
	{PMIC_VSYS22_VOSEL_ON, MT6328_PMIC_VSYS22_VOSEL_ON_ADDR, MT6328_PMIC_VSYS22_VOSEL_ON_MASK,
	 MT6328_PMIC_VSYS22_VOSEL_ON_SHIFT},
	{PMIC_VSYS22_VOSEL_SLEEP, MT6328_PMIC_VSYS22_VOSEL_SLEEP_ADDR,
	 MT6328_PMIC_VSYS22_VOSEL_SLEEP_MASK, MT6328_PMIC_VSYS22_VOSEL_SLEEP_SHIFT},
	{PMIC_NI_VSYS22_VOSEL, MT6328_PMIC_NI_VSYS22_VOSEL_ADDR, MT6328_PMIC_NI_VSYS22_VOSEL_MASK,
	 MT6328_PMIC_NI_VSYS22_VOSEL_SHIFT},
	{PMIC_VSYS22_BURST, MT6328_PMIC_VSYS22_BURST_ADDR, MT6328_PMIC_VSYS22_BURST_MASK,
	 MT6328_PMIC_VSYS22_BURST_SHIFT},
	{PMIC_QI_VSYS22_BURST, MT6328_PMIC_QI_VSYS22_BURST_ADDR, MT6328_PMIC_QI_VSYS22_BURST_MASK,
	 MT6328_PMIC_QI_VSYS22_BURST_SHIFT},
	{PMIC_VSYS22_DLC, MT6328_PMIC_VSYS22_DLC_ADDR, MT6328_PMIC_VSYS22_DLC_MASK,
	 MT6328_PMIC_VSYS22_DLC_SHIFT},
	{PMIC_QI_VSYS22_DLC, MT6328_PMIC_QI_VSYS22_DLC_ADDR, MT6328_PMIC_QI_VSYS22_DLC_MASK,
	 MT6328_PMIC_QI_VSYS22_DLC_SHIFT},
	{PMIC_VSYS22_DLC_N, MT6328_PMIC_VSYS22_DLC_N_ADDR, MT6328_PMIC_VSYS22_DLC_N_MASK,
	 MT6328_PMIC_VSYS22_DLC_N_SHIFT},
	{PMIC_QI_VSYS22_DLC_N, MT6328_PMIC_QI_VSYS22_DLC_N_ADDR, MT6328_PMIC_QI_VSYS22_DLC_N_MASK,
	 MT6328_PMIC_QI_VSYS22_DLC_N_SHIFT},
	{PMIC_VSYS22_TRANS_TD, MT6328_PMIC_VSYS22_TRANS_TD_ADDR, MT6328_PMIC_VSYS22_TRANS_TD_MASK,
	 MT6328_PMIC_VSYS22_TRANS_TD_SHIFT},
	{PMIC_VSYS22_TRANS_CTRL, MT6328_PMIC_VSYS22_TRANS_CTRL_ADDR,
	 MT6328_PMIC_VSYS22_TRANS_CTRL_MASK, MT6328_PMIC_VSYS22_TRANS_CTRL_SHIFT},
	{PMIC_VSYS22_TRANS_ONCE, MT6328_PMIC_VSYS22_TRANS_ONCE_ADDR,
	 MT6328_PMIC_VSYS22_TRANS_ONCE_MASK, MT6328_PMIC_VSYS22_TRANS_ONCE_SHIFT},
	{PMIC_NI_VSYS22_VOSEL_TRANS, MT6328_PMIC_NI_VSYS22_VOSEL_TRANS_ADDR,
	 MT6328_PMIC_NI_VSYS22_VOSEL_TRANS_MASK, MT6328_PMIC_NI_VSYS22_VOSEL_TRANS_SHIFT},
	{PMIC_VSYS22_VSLEEP_EN, MT6328_PMIC_VSYS22_VSLEEP_EN_ADDR,
	 MT6328_PMIC_VSYS22_VSLEEP_EN_MASK, MT6328_PMIC_VSYS22_VSLEEP_EN_SHIFT},
	{PMIC_VSYS22_R2R_PDN, MT6328_PMIC_VSYS22_R2R_PDN_ADDR, MT6328_PMIC_VSYS22_R2R_PDN_MASK,
	 MT6328_PMIC_VSYS22_R2R_PDN_SHIFT},
	{PMIC_VSYS22_VSLEEP_SEL, MT6328_PMIC_VSYS22_VSLEEP_SEL_ADDR,
	 MT6328_PMIC_VSYS22_VSLEEP_SEL_MASK, MT6328_PMIC_VSYS22_VSLEEP_SEL_SHIFT},
	{PMIC_NI_VSYS22_R2R_PDN, MT6328_PMIC_NI_VSYS22_R2R_PDN_ADDR,
	 MT6328_PMIC_NI_VSYS22_R2R_PDN_MASK, MT6328_PMIC_NI_VSYS22_R2R_PDN_SHIFT},
	{PMIC_NI_VSYS22_VSLEEP_SEL, MT6328_PMIC_NI_VSYS22_VSLEEP_SEL_ADDR,
	 MT6328_PMIC_NI_VSYS22_VSLEEP_SEL_MASK, MT6328_PMIC_NI_VSYS22_VSLEEP_SEL_SHIFT},
	{PMIC_VSYS22_OSC_SEL_SRCLKEN_SEL, MT6328_PMIC_VSYS22_OSC_SEL_SRCLKEN_SEL_ADDR,
	 MT6328_PMIC_VSYS22_OSC_SEL_SRCLKEN_SEL_MASK, MT6328_PMIC_VSYS22_OSC_SEL_SRCLKEN_SEL_SHIFT},
	{PMIC_VSYS22_R2R_PDN_SRCLKEN_SEL, MT6328_PMIC_VSYS22_R2R_PDN_SRCLKEN_SEL_ADDR,
	 MT6328_PMIC_VSYS22_R2R_PDN_SRCLKEN_SEL_MASK, MT6328_PMIC_VSYS22_R2R_PDN_SRCLKEN_SEL_SHIFT},
	{PMIC_VSYS22_VSLEEP_SRCLKEN_SEL, MT6328_PMIC_VSYS22_VSLEEP_SRCLKEN_SEL_ADDR,
	 MT6328_PMIC_VSYS22_VSLEEP_SRCLKEN_SEL_MASK, MT6328_PMIC_VSYS22_VSLEEP_SRCLKEN_SEL_SHIFT},
	{PMIC_VPA_DIG0_RSV0, MT6328_PMIC_VPA_DIG0_RSV0_ADDR, MT6328_PMIC_VPA_DIG0_RSV0_MASK,
	 MT6328_PMIC_VPA_DIG0_RSV0_SHIFT},
	{PMIC_VPA_DUMMY_RSV1, MT6328_PMIC_VPA_DUMMY_RSV1_ADDR, MT6328_PMIC_VPA_DUMMY_RSV1_MASK,
	 MT6328_PMIC_VPA_DUMMY_RSV1_SHIFT},
	{PMIC_VPA_DUMMY_RSV2, MT6328_PMIC_VPA_DUMMY_RSV2_ADDR, MT6328_PMIC_VPA_DUMMY_RSV2_MASK,
	 MT6328_PMIC_VPA_DUMMY_RSV2_SHIFT},
	{PMIC_VPA_DUMMY_RSV3, MT6328_PMIC_VPA_DUMMY_RSV3_ADDR, MT6328_PMIC_VPA_DUMMY_RSV3_MASK,
	 MT6328_PMIC_VPA_DUMMY_RSV3_SHIFT},
	{PMIC_VPA_DUMMY_RSV4, MT6328_PMIC_VPA_DUMMY_RSV4_ADDR, MT6328_PMIC_VPA_DUMMY_RSV4_MASK,
	 MT6328_PMIC_VPA_DUMMY_RSV4_SHIFT},
	{PMIC_VPA_DUMMY_RSV5, MT6328_PMIC_VPA_DUMMY_RSV5_ADDR, MT6328_PMIC_VPA_DUMMY_RSV5_MASK,
	 MT6328_PMIC_VPA_DUMMY_RSV5_SHIFT},
	{PMIC_VPA_DUMMY_RSV6, MT6328_PMIC_VPA_DUMMY_RSV6_ADDR, MT6328_PMIC_VPA_DUMMY_RSV6_MASK,
	 MT6328_PMIC_VPA_DUMMY_RSV6_SHIFT},
	{PMIC_VPA_EN_CTRL, MT6328_PMIC_VPA_EN_CTRL_ADDR, MT6328_PMIC_VPA_EN_CTRL_MASK,
	 MT6328_PMIC_VPA_EN_CTRL_SHIFT},
	{PMIC_VPA_VOSEL_CTRL, MT6328_PMIC_VPA_VOSEL_CTRL_ADDR, MT6328_PMIC_VPA_VOSEL_CTRL_MASK,
	 MT6328_PMIC_VPA_VOSEL_CTRL_SHIFT},
	{PMIC_VPA_VPA_DIG0_RSV1, MT6328_PMIC_VPA_VPA_DIG0_RSV1_ADDR,
	 MT6328_PMIC_VPA_VPA_DIG0_RSV1_MASK, MT6328_PMIC_VPA_VPA_DIG0_RSV1_SHIFT},
	{PMIC_VPA_VPA_DIG1_RSV1, MT6328_PMIC_VPA_VPA_DIG1_RSV1_ADDR,
	 MT6328_PMIC_VPA_VPA_DIG1_RSV1_MASK, MT6328_PMIC_VPA_VPA_DIG1_RSV1_SHIFT},
	{PMIC_VPA_EN_SEL, MT6328_PMIC_VPA_EN_SEL_ADDR, MT6328_PMIC_VPA_EN_SEL_MASK,
	 MT6328_PMIC_VPA_EN_SEL_SHIFT},
	{PMIC_VPA_VOSEL_SEL, MT6328_PMIC_VPA_VOSEL_SEL_ADDR, MT6328_PMIC_VPA_VOSEL_SEL_MASK,
	 MT6328_PMIC_VPA_VOSEL_SEL_SHIFT},
	{PMIC_VPA_VPA_DIG0_RSV2, MT6328_PMIC_VPA_VPA_DIG0_RSV2_ADDR,
	 MT6328_PMIC_VPA_VPA_DIG0_RSV2_MASK, MT6328_PMIC_VPA_VPA_DIG0_RSV2_SHIFT},
	{PMIC_VPA_VPA_DIG1_RSV2, MT6328_PMIC_VPA_VPA_DIG1_RSV2_ADDR,
	 MT6328_PMIC_VPA_VPA_DIG1_RSV2_MASK, MT6328_PMIC_VPA_VPA_DIG1_RSV2_SHIFT},
	{PMIC_VPA_EN, MT6328_PMIC_VPA_EN_ADDR, MT6328_PMIC_VPA_EN_MASK, MT6328_PMIC_VPA_EN_SHIFT},
	{PMIC_VPA_STBTD, MT6328_PMIC_VPA_STBTD_ADDR, MT6328_PMIC_VPA_STBTD_MASK,
	 MT6328_PMIC_VPA_STBTD_SHIFT},
	{PMIC_QI_VPA_STB, MT6328_PMIC_QI_VPA_STB_ADDR, MT6328_PMIC_QI_VPA_STB_MASK,
	 MT6328_PMIC_QI_VPA_STB_SHIFT},
	{PMIC_QI_VPA_EN, MT6328_PMIC_QI_VPA_EN_ADDR, MT6328_PMIC_QI_VPA_EN_MASK,
	 MT6328_PMIC_QI_VPA_EN_SHIFT},
	{PMIC_QI_VPA_OC_STATUS, MT6328_PMIC_QI_VPA_OC_STATUS_ADDR,
	 MT6328_PMIC_QI_VPA_OC_STATUS_MASK, MT6328_PMIC_QI_VPA_OC_STATUS_SHIFT},
	{PMIC_VPA_SFCHG_FRATE, MT6328_PMIC_VPA_SFCHG_FRATE_ADDR, MT6328_PMIC_VPA_SFCHG_FRATE_MASK,
	 MT6328_PMIC_VPA_SFCHG_FRATE_SHIFT},
	{PMIC_VPA_SFCHG_FEN, MT6328_PMIC_VPA_SFCHG_FEN_ADDR, MT6328_PMIC_VPA_SFCHG_FEN_MASK,
	 MT6328_PMIC_VPA_SFCHG_FEN_SHIFT},
	{PMIC_VPA_SFCHG_RRATE, MT6328_PMIC_VPA_SFCHG_RRATE_ADDR, MT6328_PMIC_VPA_SFCHG_RRATE_MASK,
	 MT6328_PMIC_VPA_SFCHG_RRATE_SHIFT},
	{PMIC_VPA_SFCHG_REN, MT6328_PMIC_VPA_SFCHG_REN_ADDR, MT6328_PMIC_VPA_SFCHG_REN_MASK,
	 MT6328_PMIC_VPA_SFCHG_REN_SHIFT},
	{PMIC_VPA_VOSEL, MT6328_PMIC_VPA_VOSEL_ADDR, MT6328_PMIC_VPA_VOSEL_MASK,
	 MT6328_PMIC_VPA_VOSEL_SHIFT},
	{PMIC_VPA_VOSEL_ON, MT6328_PMIC_VPA_VOSEL_ON_ADDR, MT6328_PMIC_VPA_VOSEL_ON_MASK,
	 MT6328_PMIC_VPA_VOSEL_ON_SHIFT},
	{PMIC_VPA_VOSEL_SLEEP, MT6328_PMIC_VPA_VOSEL_SLEEP_ADDR, MT6328_PMIC_VPA_VOSEL_SLEEP_MASK,
	 MT6328_PMIC_VPA_VOSEL_SLEEP_SHIFT},
	{PMIC_NI_VPA_VOSEL, MT6328_PMIC_NI_VPA_VOSEL_ADDR, MT6328_PMIC_NI_VPA_VOSEL_MASK,
	 MT6328_PMIC_NI_VPA_VOSEL_SHIFT},
	{PMIC_VPA_DIG0_RSV, MT6328_PMIC_VPA_DIG0_RSV_ADDR, MT6328_PMIC_VPA_DIG0_RSV_MASK,
	 MT6328_PMIC_VPA_DIG0_RSV_SHIFT},
	{PMIC_VPA_DLC, MT6328_PMIC_VPA_DLC_ADDR, MT6328_PMIC_VPA_DLC_MASK,
	 MT6328_PMIC_VPA_DLC_SHIFT},
	{PMIC_QI_VPA_DLC, MT6328_PMIC_QI_VPA_DLC_ADDR, MT6328_PMIC_QI_VPA_DLC_MASK,
	 MT6328_PMIC_QI_VPA_DLC_SHIFT},
	{PMIC_VPA_DIG0_RSV3, MT6328_PMIC_VPA_DIG0_RSV3_ADDR, MT6328_PMIC_VPA_DIG0_RSV3_MASK,
	 MT6328_PMIC_VPA_DIG0_RSV3_SHIFT},
	{PMIC_VPA_DIG1_RSV3, MT6328_PMIC_VPA_DIG1_RSV3_ADDR, MT6328_PMIC_VPA_DIG1_RSV3_MASK,
	 MT6328_PMIC_VPA_DIG1_RSV3_SHIFT},
	{PMIC_VPA_TRANS_TD, MT6328_PMIC_VPA_TRANS_TD_ADDR, MT6328_PMIC_VPA_TRANS_TD_MASK,
	 MT6328_PMIC_VPA_TRANS_TD_SHIFT},
	{PMIC_VPA_TRANS_CTRL, MT6328_PMIC_VPA_TRANS_CTRL_ADDR, MT6328_PMIC_VPA_TRANS_CTRL_MASK,
	 MT6328_PMIC_VPA_TRANS_CTRL_SHIFT},
	{PMIC_VPA_TRANS_ONCE, MT6328_PMIC_VPA_TRANS_ONCE_ADDR, MT6328_PMIC_VPA_TRANS_ONCE_MASK,
	 MT6328_PMIC_VPA_TRANS_ONCE_SHIFT},
	{PMIC_NI_VPA_DVS_BW, MT6328_PMIC_NI_VPA_DVS_BW_ADDR, MT6328_PMIC_NI_VPA_DVS_BW_MASK,
	 MT6328_PMIC_NI_VPA_DVS_BW_SHIFT},
	{PMIC_VPA_DIG0_RSV4, MT6328_PMIC_VPA_DIG0_RSV4_ADDR, MT6328_PMIC_VPA_DIG0_RSV4_MASK,
	 MT6328_PMIC_VPA_DIG0_RSV4_SHIFT},
	{PMIC_VPA_DIG1_RSV4, MT6328_PMIC_VPA_DIG1_RSV4_ADDR, MT6328_PMIC_VPA_DIG1_RSV4_MASK,
	 MT6328_PMIC_VPA_DIG1_RSV4_SHIFT},
	{PMIC_VPA_BURSTH, MT6328_PMIC_VPA_BURSTH_ADDR, MT6328_PMIC_VPA_BURSTH_MASK,
	 MT6328_PMIC_VPA_BURSTH_SHIFT},
	{PMIC_QI_VPA_BURSTH, MT6328_PMIC_QI_VPA_BURSTH_ADDR, MT6328_PMIC_QI_VPA_BURSTH_MASK,
	 MT6328_PMIC_QI_VPA_BURSTH_SHIFT},
	{PMIC_VPA_BURSTL, MT6328_PMIC_VPA_BURSTL_ADDR, MT6328_PMIC_VPA_BURSTL_MASK,
	 MT6328_PMIC_VPA_BURSTL_SHIFT},
	{PMIC_QI_VPA_BURSTL, MT6328_PMIC_QI_VPA_BURSTL_ADDR, MT6328_PMIC_QI_VPA_BURSTL_MASK,
	 MT6328_PMIC_QI_VPA_BURSTL_SHIFT},
	{PMIC_VPA_VOSEL_DLC011, MT6328_PMIC_VPA_VOSEL_DLC011_ADDR,
	 MT6328_PMIC_VPA_VOSEL_DLC011_MASK, MT6328_PMIC_VPA_VOSEL_DLC011_SHIFT},
	{PMIC_VPA_VOSEL_DLC111, MT6328_PMIC_VPA_VOSEL_DLC111_ADDR,
	 MT6328_PMIC_VPA_VOSEL_DLC111_MASK, MT6328_PMIC_VPA_VOSEL_DLC111_SHIFT},
	{PMIC_VPA_DLC_MAP_EN, MT6328_PMIC_VPA_DLC_MAP_EN_ADDR, MT6328_PMIC_VPA_DLC_MAP_EN_MASK,
	 MT6328_PMIC_VPA_DLC_MAP_EN_SHIFT},
	{PMIC_VPA_VOSEL_DLC001, MT6328_PMIC_VPA_VOSEL_DLC001_ADDR,
	 MT6328_PMIC_VPA_VOSEL_DLC001_MASK, MT6328_PMIC_VPA_VOSEL_DLC001_SHIFT},
	{PMIC_VPA_DVS_TRANS_TD, MT6328_PMIC_VPA_DVS_TRANS_TD_ADDR,
	 MT6328_PMIC_VPA_DVS_TRANS_TD_MASK, MT6328_PMIC_VPA_DVS_TRANS_TD_SHIFT},
	{PMIC_VPA_DVS_TRANS_CTRL, MT6328_PMIC_VPA_DVS_TRANS_CTRL_ADDR,
	 MT6328_PMIC_VPA_DVS_TRANS_CTRL_MASK, MT6328_PMIC_VPA_DVS_TRANS_CTRL_SHIFT},
	{PMIC_VPA_DVS_TRANS_ONCE, MT6328_PMIC_VPA_DVS_TRANS_ONCE_ADDR,
	 MT6328_PMIC_VPA_DVS_TRANS_ONCE_MASK, MT6328_PMIC_VPA_DVS_TRANS_ONCE_SHIFT},
	{PMIC_NI_VPA_DVS_TRANST, MT6328_PMIC_NI_VPA_DVS_TRANST_ADDR,
	 MT6328_PMIC_NI_VPA_DVS_TRANST_MASK, MT6328_PMIC_NI_VPA_DVS_TRANST_SHIFT},
	{PMIC_VPA_DIG0_RSV5, MT6328_PMIC_VPA_DIG0_RSV5_ADDR, MT6328_PMIC_VPA_DIG0_RSV5_MASK,
	 MT6328_PMIC_VPA_DIG0_RSV5_SHIFT},
	{PMIC_VPA_DIG1_RSV5, MT6328_PMIC_VPA_DIG1_RSV5_ADDR, MT6328_PMIC_VPA_DIG1_RSV5_MASK,
	 MT6328_PMIC_VPA_DIG1_RSV5_SHIFT},
	{PMIC_VPA_OSC_SEL_SRCLKEN_SEL, MT6328_PMIC_VPA_OSC_SEL_SRCLKEN_SEL_ADDR,
	 MT6328_PMIC_VPA_OSC_SEL_SRCLKEN_SEL_MASK, MT6328_PMIC_VPA_OSC_SEL_SRCLKEN_SEL_SHIFT},
	{PMIC_VPA_R2R_PDN_SRCLKEN_SEL, MT6328_PMIC_VPA_R2R_PDN_SRCLKEN_SEL_ADDR,
	 MT6328_PMIC_VPA_R2R_PDN_SRCLKEN_SEL_MASK, MT6328_PMIC_VPA_R2R_PDN_SRCLKEN_SEL_SHIFT},
	{PMIC_VPA_VSLEEP_SRCLKEN_SEL, MT6328_PMIC_VPA_VSLEEP_SRCLKEN_SEL_ADDR,
	 MT6328_PMIC_VPA_VSLEEP_SRCLKEN_SEL_MASK, MT6328_PMIC_VPA_VSLEEP_SRCLKEN_SEL_SHIFT},
	{PMIC_K_RST_DONE, MT6328_PMIC_K_RST_DONE_ADDR, MT6328_PMIC_K_RST_DONE_MASK,
	 MT6328_PMIC_K_RST_DONE_SHIFT},
	{PMIC_K_MAP_SEL, MT6328_PMIC_K_MAP_SEL_ADDR, MT6328_PMIC_K_MAP_SEL_MASK,
	 MT6328_PMIC_K_MAP_SEL_SHIFT},
	{PMIC_K_ONCE_EN, MT6328_PMIC_K_ONCE_EN_ADDR, MT6328_PMIC_K_ONCE_EN_MASK,
	 MT6328_PMIC_K_ONCE_EN_SHIFT},
	{PMIC_K_ONCE, MT6328_PMIC_K_ONCE_ADDR, MT6328_PMIC_K_ONCE_MASK, MT6328_PMIC_K_ONCE_SHIFT},
	{PMIC_K_START_MANUAL, MT6328_PMIC_K_START_MANUAL_ADDR, MT6328_PMIC_K_START_MANUAL_MASK,
	 MT6328_PMIC_K_START_MANUAL_SHIFT},
	{PMIC_K_SRC_SEL, MT6328_PMIC_K_SRC_SEL_ADDR, MT6328_PMIC_K_SRC_SEL_MASK,
	 MT6328_PMIC_K_SRC_SEL_SHIFT},
	{PMIC_K_AUTO_EN, MT6328_PMIC_K_AUTO_EN_ADDR, MT6328_PMIC_K_AUTO_EN_MASK,
	 MT6328_PMIC_K_AUTO_EN_SHIFT},
	{PMIC_K_INV, MT6328_PMIC_K_INV_ADDR, MT6328_PMIC_K_INV_MASK, MT6328_PMIC_K_INV_SHIFT},
	{PMIC_K_CONTROL_SMPS, MT6328_PMIC_K_CONTROL_SMPS_ADDR, MT6328_PMIC_K_CONTROL_SMPS_MASK,
	 MT6328_PMIC_K_CONTROL_SMPS_SHIFT},
	{PMIC_K_RESULT, MT6328_PMIC_K_RESULT_ADDR, MT6328_PMIC_K_RESULT_MASK,
	 MT6328_PMIC_K_RESULT_SHIFT},
	{PMIC_K_DONE, MT6328_PMIC_K_DONE_ADDR, MT6328_PMIC_K_DONE_MASK, MT6328_PMIC_K_DONE_SHIFT},
	{PMIC_K_CONTROL, MT6328_PMIC_K_CONTROL_ADDR, MT6328_PMIC_K_CONTROL_MASK,
	 MT6328_PMIC_K_CONTROL_SHIFT},
	{PMIC_QI_SMPS_OSC_CAL, MT6328_PMIC_QI_SMPS_OSC_CAL_ADDR, MT6328_PMIC_QI_SMPS_OSC_CAL_MASK,
	 MT6328_PMIC_QI_SMPS_OSC_CAL_SHIFT},
	{PMIC_K_BUCK_CK_CNT, MT6328_PMIC_K_BUCK_CK_CNT_ADDR, MT6328_PMIC_K_BUCK_CK_CNT_MASK,
	 MT6328_PMIC_K_BUCK_CK_CNT_SHIFT},
	{PMIC_RG_AUDZCDENABLE, MT6328_PMIC_RG_AUDZCDENABLE_ADDR, MT6328_PMIC_RG_AUDZCDENABLE_MASK,
	 MT6328_PMIC_RG_AUDZCDENABLE_SHIFT},
	{PMIC_RG_AUDZCDGAINSTEPTIME, MT6328_PMIC_RG_AUDZCDGAINSTEPTIME_ADDR,
	 MT6328_PMIC_RG_AUDZCDGAINSTEPTIME_MASK, MT6328_PMIC_RG_AUDZCDGAINSTEPTIME_SHIFT},
	{PMIC_RG_AUDZCDGAINSTEPSIZE, MT6328_PMIC_RG_AUDZCDGAINSTEPSIZE_ADDR,
	 MT6328_PMIC_RG_AUDZCDGAINSTEPSIZE_MASK, MT6328_PMIC_RG_AUDZCDGAINSTEPSIZE_SHIFT},
	{PMIC_RG_AUDZCDTIMEOUTMODESEL, MT6328_PMIC_RG_AUDZCDTIMEOUTMODESEL_ADDR,
	 MT6328_PMIC_RG_AUDZCDTIMEOUTMODESEL_MASK, MT6328_PMIC_RG_AUDZCDTIMEOUTMODESEL_SHIFT},
	{PMIC_RG_AUDZCDCLKSEL_VAUDP15, MT6328_PMIC_RG_AUDZCDCLKSEL_VAUDP15_ADDR,
	 MT6328_PMIC_RG_AUDZCDCLKSEL_VAUDP15_MASK, MT6328_PMIC_RG_AUDZCDCLKSEL_VAUDP15_SHIFT},
	{PMIC_RG_AUDZCDMUXSEL_VAUDP15, MT6328_PMIC_RG_AUDZCDMUXSEL_VAUDP15_ADDR,
	 MT6328_PMIC_RG_AUDZCDMUXSEL_VAUDP15_MASK, MT6328_PMIC_RG_AUDZCDMUXSEL_VAUDP15_SHIFT},
	{PMIC_RG_AUDLOLGAIN, MT6328_PMIC_RG_AUDLOLGAIN_ADDR, MT6328_PMIC_RG_AUDLOLGAIN_MASK,
	 MT6328_PMIC_RG_AUDLOLGAIN_SHIFT},
	{PMIC_RG_AUDLORGAIN, MT6328_PMIC_RG_AUDLORGAIN_ADDR, MT6328_PMIC_RG_AUDLORGAIN_MASK,
	 MT6328_PMIC_RG_AUDLORGAIN_SHIFT},
	{PMIC_RG_AUDHPLGAIN, MT6328_PMIC_RG_AUDHPLGAIN_ADDR, MT6328_PMIC_RG_AUDHPLGAIN_MASK,
	 MT6328_PMIC_RG_AUDHPLGAIN_SHIFT},
	{PMIC_RG_AUDHPRGAIN, MT6328_PMIC_RG_AUDHPRGAIN_ADDR, MT6328_PMIC_RG_AUDHPRGAIN_MASK,
	 MT6328_PMIC_RG_AUDHPRGAIN_SHIFT},
	{PMIC_RG_AUDHSGAIN, MT6328_PMIC_RG_AUDHSGAIN_ADDR, MT6328_PMIC_RG_AUDHSGAIN_MASK,
	 MT6328_PMIC_RG_AUDHSGAIN_SHIFT},
	{PMIC_RG_AUDIVLGAIN, MT6328_PMIC_RG_AUDIVLGAIN_ADDR, MT6328_PMIC_RG_AUDIVLGAIN_MASK,
	 MT6328_PMIC_RG_AUDIVLGAIN_SHIFT},
	{PMIC_RG_AUDIVRGAIN, MT6328_PMIC_RG_AUDIVRGAIN_ADDR, MT6328_PMIC_RG_AUDIVRGAIN_MASK,
	 MT6328_PMIC_RG_AUDIVRGAIN_SHIFT},
	{PMIC_RG_AUDINTGAIN1, MT6328_PMIC_RG_AUDINTGAIN1_ADDR, MT6328_PMIC_RG_AUDINTGAIN1_MASK,
	 MT6328_PMIC_RG_AUDINTGAIN1_SHIFT},
	{PMIC_RG_AUDINTGAIN2, MT6328_PMIC_RG_AUDINTGAIN2_ADDR, MT6328_PMIC_RG_AUDINTGAIN2_MASK,
	 MT6328_PMIC_RG_AUDINTGAIN2_SHIFT},
	{PMIC_ISINK_DIM0_FSEL, MT6328_PMIC_ISINK_DIM0_FSEL_ADDR, MT6328_PMIC_ISINK_DIM0_FSEL_MASK,
	 MT6328_PMIC_ISINK_DIM0_FSEL_SHIFT},
	{PMIC_ISINK0_RSV1, MT6328_PMIC_ISINK0_RSV1_ADDR, MT6328_PMIC_ISINK0_RSV1_MASK,
	 MT6328_PMIC_ISINK0_RSV1_SHIFT},
	{PMIC_ISINK0_RSV0, MT6328_PMIC_ISINK0_RSV0_ADDR, MT6328_PMIC_ISINK0_RSV0_MASK,
	 MT6328_PMIC_ISINK0_RSV0_SHIFT},
	{PMIC_ISINK_DIM0_DUTY, MT6328_PMIC_ISINK_DIM0_DUTY_ADDR, MT6328_PMIC_ISINK_DIM0_DUTY_MASK,
	 MT6328_PMIC_ISINK_DIM0_DUTY_SHIFT},
	{PMIC_ISINK_CH0_STEP, MT6328_PMIC_ISINK_CH0_STEP_ADDR, MT6328_PMIC_ISINK_CH0_STEP_MASK,
	 MT6328_PMIC_ISINK_CH0_STEP_SHIFT},
	{PMIC_ISINK_BREATH0_TF2_SEL, MT6328_PMIC_ISINK_BREATH0_TF2_SEL_ADDR,
	 MT6328_PMIC_ISINK_BREATH0_TF2_SEL_MASK, MT6328_PMIC_ISINK_BREATH0_TF2_SEL_SHIFT},
	{PMIC_ISINK_BREATH0_TF1_SEL, MT6328_PMIC_ISINK_BREATH0_TF1_SEL_ADDR,
	 MT6328_PMIC_ISINK_BREATH0_TF1_SEL_MASK, MT6328_PMIC_ISINK_BREATH0_TF1_SEL_SHIFT},
	{PMIC_ISINK_BREATH0_TR2_SEL, MT6328_PMIC_ISINK_BREATH0_TR2_SEL_ADDR,
	 MT6328_PMIC_ISINK_BREATH0_TR2_SEL_MASK, MT6328_PMIC_ISINK_BREATH0_TR2_SEL_SHIFT},
	{PMIC_ISINK_BREATH0_TR1_SEL, MT6328_PMIC_ISINK_BREATH0_TR1_SEL_ADDR,
	 MT6328_PMIC_ISINK_BREATH0_TR1_SEL_MASK, MT6328_PMIC_ISINK_BREATH0_TR1_SEL_SHIFT},
	{PMIC_ISINK_BREATH0_TOFF_SEL, MT6328_PMIC_ISINK_BREATH0_TOFF_SEL_ADDR,
	 MT6328_PMIC_ISINK_BREATH0_TOFF_SEL_MASK, MT6328_PMIC_ISINK_BREATH0_TOFF_SEL_SHIFT},
	{PMIC_ISINK_BREATH0_TON_SEL, MT6328_PMIC_ISINK_BREATH0_TON_SEL_ADDR,
	 MT6328_PMIC_ISINK_BREATH0_TON_SEL_MASK, MT6328_PMIC_ISINK_BREATH0_TON_SEL_SHIFT},
	{PMIC_ISINK_DIM1_FSEL, MT6328_PMIC_ISINK_DIM1_FSEL_ADDR, MT6328_PMIC_ISINK_DIM1_FSEL_MASK,
	 MT6328_PMIC_ISINK_DIM1_FSEL_SHIFT},
	{PMIC_ISINK1_RSV1, MT6328_PMIC_ISINK1_RSV1_ADDR, MT6328_PMIC_ISINK1_RSV1_MASK,
	 MT6328_PMIC_ISINK1_RSV1_SHIFT},
	{PMIC_ISINK1_RSV0, MT6328_PMIC_ISINK1_RSV0_ADDR, MT6328_PMIC_ISINK1_RSV0_MASK,
	 MT6328_PMIC_ISINK1_RSV0_SHIFT},
	{PMIC_ISINK_DIM1_DUTY, MT6328_PMIC_ISINK_DIM1_DUTY_ADDR, MT6328_PMIC_ISINK_DIM1_DUTY_MASK,
	 MT6328_PMIC_ISINK_DIM1_DUTY_SHIFT},
	{PMIC_ISINK_CH1_STEP, MT6328_PMIC_ISINK_CH1_STEP_ADDR, MT6328_PMIC_ISINK_CH1_STEP_MASK,
	 MT6328_PMIC_ISINK_CH1_STEP_SHIFT},
	{PMIC_ISINK_BREATH1_TF2_SEL, MT6328_PMIC_ISINK_BREATH1_TF2_SEL_ADDR,
	 MT6328_PMIC_ISINK_BREATH1_TF2_SEL_MASK, MT6328_PMIC_ISINK_BREATH1_TF2_SEL_SHIFT},
	{PMIC_ISINK_BREATH1_TF1_SEL, MT6328_PMIC_ISINK_BREATH1_TF1_SEL_ADDR,
	 MT6328_PMIC_ISINK_BREATH1_TF1_SEL_MASK, MT6328_PMIC_ISINK_BREATH1_TF1_SEL_SHIFT},
	{PMIC_ISINK_BREATH1_TR2_SEL, MT6328_PMIC_ISINK_BREATH1_TR2_SEL_ADDR,
	 MT6328_PMIC_ISINK_BREATH1_TR2_SEL_MASK, MT6328_PMIC_ISINK_BREATH1_TR2_SEL_SHIFT},
	{PMIC_ISINK_BREATH1_TR1_SEL, MT6328_PMIC_ISINK_BREATH1_TR1_SEL_ADDR,
	 MT6328_PMIC_ISINK_BREATH1_TR1_SEL_MASK, MT6328_PMIC_ISINK_BREATH1_TR1_SEL_SHIFT},
	{PMIC_ISINK_BREATH1_TOFF_SEL, MT6328_PMIC_ISINK_BREATH1_TOFF_SEL_ADDR,
	 MT6328_PMIC_ISINK_BREATH1_TOFF_SEL_MASK, MT6328_PMIC_ISINK_BREATH1_TOFF_SEL_SHIFT},
	{PMIC_ISINK_BREATH1_TON_SEL, MT6328_PMIC_ISINK_BREATH1_TON_SEL_ADDR,
	 MT6328_PMIC_ISINK_BREATH1_TON_SEL_MASK, MT6328_PMIC_ISINK_BREATH1_TON_SEL_SHIFT},
	{PMIC_ISINK2_RSV1, MT6328_PMIC_ISINK2_RSV1_ADDR, MT6328_PMIC_ISINK2_RSV1_MASK,
	 MT6328_PMIC_ISINK2_RSV1_SHIFT},
	{PMIC_ISINK2_RSV0, MT6328_PMIC_ISINK2_RSV0_ADDR, MT6328_PMIC_ISINK2_RSV0_MASK,
	 MT6328_PMIC_ISINK2_RSV0_SHIFT},
	{PMIC_ISINK_CH2_STEP, MT6328_PMIC_ISINK_CH2_STEP_ADDR, MT6328_PMIC_ISINK_CH2_STEP_MASK,
	 MT6328_PMIC_ISINK_CH2_STEP_SHIFT},
	{PMIC_ISINK3_RSV1, MT6328_PMIC_ISINK3_RSV1_ADDR, MT6328_PMIC_ISINK3_RSV1_MASK,
	 MT6328_PMIC_ISINK3_RSV1_SHIFT},
	{PMIC_ISINK3_RSV0, MT6328_PMIC_ISINK3_RSV0_ADDR, MT6328_PMIC_ISINK3_RSV0_MASK,
	 MT6328_PMIC_ISINK3_RSV0_SHIFT},
	{PMIC_ISINK_CH3_STEP, MT6328_PMIC_ISINK_CH3_STEP_ADDR, MT6328_PMIC_ISINK_CH3_STEP_MASK,
	 MT6328_PMIC_ISINK_CH3_STEP_SHIFT},
	{PMIC_RG_ISINKS_RSV, MT6328_PMIC_RG_ISINKS_RSV_ADDR, MT6328_PMIC_RG_ISINKS_RSV_MASK,
	 MT6328_PMIC_RG_ISINKS_RSV_SHIFT},
	{PMIC_RG_ISINK3_DOUBLE_EN, MT6328_PMIC_RG_ISINK3_DOUBLE_EN_ADDR,
	 MT6328_PMIC_RG_ISINK3_DOUBLE_EN_MASK, MT6328_PMIC_RG_ISINK3_DOUBLE_EN_SHIFT},
	{PMIC_RG_ISINK2_DOUBLE_EN, MT6328_PMIC_RG_ISINK2_DOUBLE_EN_ADDR,
	 MT6328_PMIC_RG_ISINK2_DOUBLE_EN_MASK, MT6328_PMIC_RG_ISINK2_DOUBLE_EN_SHIFT},
	{PMIC_RG_ISINK1_DOUBLE_EN, MT6328_PMIC_RG_ISINK1_DOUBLE_EN_ADDR,
	 MT6328_PMIC_RG_ISINK1_DOUBLE_EN_MASK, MT6328_PMIC_RG_ISINK1_DOUBLE_EN_SHIFT},
	{PMIC_RG_ISINK0_DOUBLE_EN, MT6328_PMIC_RG_ISINK0_DOUBLE_EN_ADDR,
	 MT6328_PMIC_RG_ISINK0_DOUBLE_EN_MASK, MT6328_PMIC_RG_ISINK0_DOUBLE_EN_SHIFT},
	{PMIC_RG_TRIM_SEL, MT6328_PMIC_RG_TRIM_SEL_ADDR, MT6328_PMIC_RG_TRIM_SEL_MASK,
	 MT6328_PMIC_RG_TRIM_SEL_SHIFT},
	{PMIC_RG_TRIM_EN, MT6328_PMIC_RG_TRIM_EN_ADDR, MT6328_PMIC_RG_TRIM_EN_MASK,
	 MT6328_PMIC_RG_TRIM_EN_SHIFT},
	{PMIC_NI_ISINK3_STATUS, MT6328_PMIC_NI_ISINK3_STATUS_ADDR,
	 MT6328_PMIC_NI_ISINK3_STATUS_MASK, MT6328_PMIC_NI_ISINK3_STATUS_SHIFT},
	{PMIC_NI_ISINK2_STATUS, MT6328_PMIC_NI_ISINK2_STATUS_ADDR,
	 MT6328_PMIC_NI_ISINK2_STATUS_MASK, MT6328_PMIC_NI_ISINK2_STATUS_SHIFT},
	{PMIC_NI_ISINK1_STATUS, MT6328_PMIC_NI_ISINK1_STATUS_ADDR,
	 MT6328_PMIC_NI_ISINK1_STATUS_MASK, MT6328_PMIC_NI_ISINK1_STATUS_SHIFT},
	{PMIC_NI_ISINK0_STATUS, MT6328_PMIC_NI_ISINK0_STATUS_ADDR,
	 MT6328_PMIC_NI_ISINK0_STATUS_MASK, MT6328_PMIC_NI_ISINK0_STATUS_SHIFT},
	{PMIC_ISINK_PHASE0_DLY_EN, MT6328_PMIC_ISINK_PHASE0_DLY_EN_ADDR,
	 MT6328_PMIC_ISINK_PHASE0_DLY_EN_MASK, MT6328_PMIC_ISINK_PHASE0_DLY_EN_SHIFT},
	{PMIC_ISINK_PHASE1_DLY_EN, MT6328_PMIC_ISINK_PHASE1_DLY_EN_ADDR,
	 MT6328_PMIC_ISINK_PHASE1_DLY_EN_MASK, MT6328_PMIC_ISINK_PHASE1_DLY_EN_SHIFT},
	{PMIC_ISINK_PHASE_DLY_TC, MT6328_PMIC_ISINK_PHASE_DLY_TC_ADDR,
	 MT6328_PMIC_ISINK_PHASE_DLY_TC_MASK, MT6328_PMIC_ISINK_PHASE_DLY_TC_SHIFT},
	{PMIC_ISINK_CHOP0_SW, MT6328_PMIC_ISINK_CHOP0_SW_ADDR, MT6328_PMIC_ISINK_CHOP0_SW_MASK,
	 MT6328_PMIC_ISINK_CHOP0_SW_SHIFT},
	{PMIC_ISINK_CHOP1_SW, MT6328_PMIC_ISINK_CHOP1_SW_ADDR, MT6328_PMIC_ISINK_CHOP1_SW_MASK,
	 MT6328_PMIC_ISINK_CHOP1_SW_SHIFT},
	{PMIC_ISINK_CHOP2_SW, MT6328_PMIC_ISINK_CHOP2_SW_ADDR, MT6328_PMIC_ISINK_CHOP2_SW_MASK,
	 MT6328_PMIC_ISINK_CHOP2_SW_SHIFT},
	{PMIC_ISINK_CHOP3_SW, MT6328_PMIC_ISINK_CHOP3_SW_ADDR, MT6328_PMIC_ISINK_CHOP3_SW_MASK,
	 MT6328_PMIC_ISINK_CHOP3_SW_SHIFT},
	{PMIC_ISINK_SFSTR1_EN, MT6328_PMIC_ISINK_SFSTR1_EN_ADDR, MT6328_PMIC_ISINK_SFSTR1_EN_MASK,
	 MT6328_PMIC_ISINK_SFSTR1_EN_SHIFT},
	{PMIC_ISINK_SFSTR1_TC, MT6328_PMIC_ISINK_SFSTR1_TC_ADDR, MT6328_PMIC_ISINK_SFSTR1_TC_MASK,
	 MT6328_PMIC_ISINK_SFSTR1_TC_SHIFT},
	{PMIC_ISINK_SFSTR0_EN, MT6328_PMIC_ISINK_SFSTR0_EN_ADDR, MT6328_PMIC_ISINK_SFSTR0_EN_MASK,
	 MT6328_PMIC_ISINK_SFSTR0_EN_SHIFT},
	{PMIC_ISINK_SFSTR0_TC, MT6328_PMIC_ISINK_SFSTR0_TC_ADDR, MT6328_PMIC_ISINK_SFSTR0_TC_MASK,
	 MT6328_PMIC_ISINK_SFSTR0_TC_SHIFT},
	{PMIC_ISINK_CH0_EN, MT6328_PMIC_ISINK_CH0_EN_ADDR, MT6328_PMIC_ISINK_CH0_EN_MASK,
	 MT6328_PMIC_ISINK_CH0_EN_SHIFT},
	{PMIC_ISINK_CH1_EN, MT6328_PMIC_ISINK_CH1_EN_ADDR, MT6328_PMIC_ISINK_CH1_EN_MASK,
	 MT6328_PMIC_ISINK_CH1_EN_SHIFT},
	{PMIC_ISINK_CH2_EN, MT6328_PMIC_ISINK_CH2_EN_ADDR, MT6328_PMIC_ISINK_CH2_EN_MASK,
	 MT6328_PMIC_ISINK_CH2_EN_SHIFT},
	{PMIC_ISINK_CH3_EN, MT6328_PMIC_ISINK_CH3_EN_ADDR, MT6328_PMIC_ISINK_CH3_EN_MASK,
	 MT6328_PMIC_ISINK_CH3_EN_SHIFT},
	{PMIC_ISINK_CHOP0_EN, MT6328_PMIC_ISINK_CHOP0_EN_ADDR, MT6328_PMIC_ISINK_CHOP0_EN_MASK,
	 MT6328_PMIC_ISINK_CHOP0_EN_SHIFT},
	{PMIC_ISINK_CHOP1_EN, MT6328_PMIC_ISINK_CHOP1_EN_ADDR, MT6328_PMIC_ISINK_CHOP1_EN_MASK,
	 MT6328_PMIC_ISINK_CHOP1_EN_SHIFT},
	{PMIC_ISINK_CHOP2_EN, MT6328_PMIC_ISINK_CHOP2_EN_ADDR, MT6328_PMIC_ISINK_CHOP2_EN_MASK,
	 MT6328_PMIC_ISINK_CHOP2_EN_SHIFT},
	{PMIC_ISINK_CHOP3_EN, MT6328_PMIC_ISINK_CHOP3_EN_ADDR, MT6328_PMIC_ISINK_CHOP3_EN_MASK,
	 MT6328_PMIC_ISINK_CHOP3_EN_SHIFT},
	{PMIC_ISINK_CH0_BIAS_EN, MT6328_PMIC_ISINK_CH0_BIAS_EN_ADDR,
	 MT6328_PMIC_ISINK_CH0_BIAS_EN_MASK, MT6328_PMIC_ISINK_CH0_BIAS_EN_SHIFT},
	{PMIC_ISINK_CH1_BIAS_EN, MT6328_PMIC_ISINK_CH1_BIAS_EN_ADDR,
	 MT6328_PMIC_ISINK_CH1_BIAS_EN_MASK, MT6328_PMIC_ISINK_CH1_BIAS_EN_SHIFT},
	{PMIC_ISINK_CH2_BIAS_EN, MT6328_PMIC_ISINK_CH2_BIAS_EN_ADDR,
	 MT6328_PMIC_ISINK_CH2_BIAS_EN_MASK, MT6328_PMIC_ISINK_CH2_BIAS_EN_SHIFT},
	{PMIC_ISINK_CH3_BIAS_EN, MT6328_PMIC_ISINK_CH3_BIAS_EN_ADDR,
	 MT6328_PMIC_ISINK_CH3_BIAS_EN_MASK, MT6328_PMIC_ISINK_CH3_BIAS_EN_SHIFT},
	{PMIC_ISINK_RSV, MT6328_PMIC_ISINK_RSV_ADDR, MT6328_PMIC_ISINK_RSV_MASK,
	 MT6328_PMIC_ISINK_RSV_SHIFT},
	{PMIC_ISINK_CH1_MODE, MT6328_PMIC_ISINK_CH1_MODE_ADDR, MT6328_PMIC_ISINK_CH1_MODE_MASK,
	 MT6328_PMIC_ISINK_CH1_MODE_SHIFT},
	{PMIC_ISINK_CH0_MODE, MT6328_PMIC_ISINK_CH0_MODE_ADDR, MT6328_PMIC_ISINK_CH0_MODE_MASK,
	 MT6328_PMIC_ISINK_CH0_MODE_SHIFT},
	{PMIC_RG_VTCXO_0_MODE_SET, MT6328_PMIC_RG_VTCXO_0_MODE_SET_ADDR,
	 MT6328_PMIC_RG_VTCXO_0_MODE_SET_MASK, MT6328_PMIC_RG_VTCXO_0_MODE_SET_SHIFT},
	{PMIC_RG_VTCXO_0_EN, MT6328_PMIC_RG_VTCXO_0_EN_ADDR, MT6328_PMIC_RG_VTCXO_0_EN_MASK,
	 MT6328_PMIC_RG_VTCXO_0_EN_SHIFT},
	{PMIC_RG_VTCXO_0_MODE_CTRL, MT6328_PMIC_RG_VTCXO_0_MODE_CTRL_ADDR,
	 MT6328_PMIC_RG_VTCXO_0_MODE_CTRL_MASK, MT6328_PMIC_RG_VTCXO_0_MODE_CTRL_SHIFT},
	{PMIC_RG_VTCXO_0_ON_CTRL, MT6328_PMIC_RG_VTCXO_0_ON_CTRL_ADDR,
	 MT6328_PMIC_RG_VTCXO_0_ON_CTRL_MASK, MT6328_PMIC_RG_VTCXO_0_ON_CTRL_SHIFT},
	{PMIC_RG_VTCXO_0_SRCLK_MODE_SEL, MT6328_PMIC_RG_VTCXO_0_SRCLK_MODE_SEL_ADDR,
	 MT6328_PMIC_RG_VTCXO_0_SRCLK_MODE_SEL_MASK, MT6328_PMIC_RG_VTCXO_0_SRCLK_MODE_SEL_SHIFT},
	{PMIC_QI_VTCXO_0_MODE, MT6328_PMIC_QI_VTCXO_0_MODE_ADDR, MT6328_PMIC_QI_VTCXO_0_MODE_MASK,
	 MT6328_PMIC_QI_VTCXO_0_MODE_SHIFT},
	{PMIC_RG_VTCXO_0_STBTD, MT6328_PMIC_RG_VTCXO_0_STBTD_ADDR,
	 MT6328_PMIC_RG_VTCXO_0_STBTD_MASK, MT6328_PMIC_RG_VTCXO_0_STBTD_SHIFT},
	{PMIC_RG_VTCXO_0_OCFB_EN, MT6328_PMIC_RG_VTCXO_0_OCFB_EN_ADDR,
	 MT6328_PMIC_RG_VTCXO_0_OCFB_EN_MASK, MT6328_PMIC_RG_VTCXO_0_OCFB_EN_SHIFT},
	{PMIC_QI_VTCXO_0_OCFB_EN, MT6328_PMIC_QI_VTCXO_0_OCFB_EN_ADDR,
	 MT6328_PMIC_QI_VTCXO_0_OCFB_EN_MASK, MT6328_PMIC_QI_VTCXO_0_OCFB_EN_SHIFT},
	{PMIC_RG_VTCXO_0_SRCLK_EN_SEL, MT6328_PMIC_RG_VTCXO_0_SRCLK_EN_SEL_ADDR,
	 MT6328_PMIC_RG_VTCXO_0_SRCLK_EN_SEL_MASK, MT6328_PMIC_RG_VTCXO_0_SRCLK_EN_SEL_SHIFT},
	{PMIC_QI_VTCXO_0_STB, MT6328_PMIC_QI_VTCXO_0_STB_ADDR, MT6328_PMIC_QI_VTCXO_0_STB_MASK,
	 MT6328_PMIC_QI_VTCXO_0_STB_SHIFT},
	{PMIC_QI_VTCXO_0_EN, MT6328_PMIC_QI_VTCXO_0_EN_ADDR, MT6328_PMIC_QI_VTCXO_0_EN_MASK,
	 MT6328_PMIC_QI_VTCXO_0_EN_SHIFT},
	{PMIC_RG_VTCXO_1_MODE_SET, MT6328_PMIC_RG_VTCXO_1_MODE_SET_ADDR,
	 MT6328_PMIC_RG_VTCXO_1_MODE_SET_MASK, MT6328_PMIC_RG_VTCXO_1_MODE_SET_SHIFT},
	{PMIC_RG_VTCXO_1_EN, MT6328_PMIC_RG_VTCXO_1_EN_ADDR, MT6328_PMIC_RG_VTCXO_1_EN_MASK,
	 MT6328_PMIC_RG_VTCXO_1_EN_SHIFT},
	{PMIC_RG_VTCXO_1_MODE_CTRL, MT6328_PMIC_RG_VTCXO_1_MODE_CTRL_ADDR,
	 MT6328_PMIC_RG_VTCXO_1_MODE_CTRL_MASK, MT6328_PMIC_RG_VTCXO_1_MODE_CTRL_SHIFT},
	{PMIC_RG_VTCXO_1_ON_CTRL, MT6328_PMIC_RG_VTCXO_1_ON_CTRL_ADDR,
	 MT6328_PMIC_RG_VTCXO_1_ON_CTRL_MASK, MT6328_PMIC_RG_VTCXO_1_ON_CTRL_SHIFT},
	{PMIC_RG_VTCXO_1_SRCLK_MODE_SEL, MT6328_PMIC_RG_VTCXO_1_SRCLK_MODE_SEL_ADDR,
	 MT6328_PMIC_RG_VTCXO_1_SRCLK_MODE_SEL_MASK, MT6328_PMIC_RG_VTCXO_1_SRCLK_MODE_SEL_SHIFT},
	{PMIC_QI_VTCXO_1_MODE, MT6328_PMIC_QI_VTCXO_1_MODE_ADDR, MT6328_PMIC_QI_VTCXO_1_MODE_MASK,
	 MT6328_PMIC_QI_VTCXO_1_MODE_SHIFT},
	{PMIC_RG_VTCXO_1_STBTD, MT6328_PMIC_RG_VTCXO_1_STBTD_ADDR,
	 MT6328_PMIC_RG_VTCXO_1_STBTD_MASK, MT6328_PMIC_RG_VTCXO_1_STBTD_SHIFT},
	{PMIC_RG_VTCXO_1_OCFB_EN, MT6328_PMIC_RG_VTCXO_1_OCFB_EN_ADDR,
	 MT6328_PMIC_RG_VTCXO_1_OCFB_EN_MASK, MT6328_PMIC_RG_VTCXO_1_OCFB_EN_SHIFT},
	{PMIC_QI_VTCXO_1_OCFB_EN, MT6328_PMIC_QI_VTCXO_1_OCFB_EN_ADDR,
	 MT6328_PMIC_QI_VTCXO_1_OCFB_EN_MASK, MT6328_PMIC_QI_VTCXO_1_OCFB_EN_SHIFT},
	{PMIC_RG_VTCXO_1_SRCLK_EN_SEL, MT6328_PMIC_RG_VTCXO_1_SRCLK_EN_SEL_ADDR,
	 MT6328_PMIC_RG_VTCXO_1_SRCLK_EN_SEL_MASK, MT6328_PMIC_RG_VTCXO_1_SRCLK_EN_SEL_SHIFT},
	{PMIC_QI_VTCXO_1_STB, MT6328_PMIC_QI_VTCXO_1_STB_ADDR, MT6328_PMIC_QI_VTCXO_1_STB_MASK,
	 MT6328_PMIC_QI_VTCXO_1_STB_SHIFT},
	{PMIC_QI_VTCXO_1_EN, MT6328_PMIC_QI_VTCXO_1_EN_ADDR, MT6328_PMIC_QI_VTCXO_1_EN_MASK,
	 MT6328_PMIC_QI_VTCXO_1_EN_SHIFT},
	{PMIC_RG_VAUD28_MODE_SET, MT6328_PMIC_RG_VAUD28_MODE_SET_ADDR,
	 MT6328_PMIC_RG_VAUD28_MODE_SET_MASK, MT6328_PMIC_RG_VAUD28_MODE_SET_SHIFT},
	{PMIC_RG_VAUD28_EN, MT6328_PMIC_RG_VAUD28_EN_ADDR, MT6328_PMIC_RG_VAUD28_EN_MASK,
	 MT6328_PMIC_RG_VAUD28_EN_SHIFT},
	{PMIC_RG_VAUD28_MODE_CTRL, MT6328_PMIC_RG_VAUD28_MODE_CTRL_ADDR,
	 MT6328_PMIC_RG_VAUD28_MODE_CTRL_MASK, MT6328_PMIC_RG_VAUD28_MODE_CTRL_SHIFT},
	{PMIC_RG_VAUD28_ON_CTRL, MT6328_PMIC_RG_VAUD28_ON_CTRL_ADDR,
	 MT6328_PMIC_RG_VAUD28_ON_CTRL_MASK, MT6328_PMIC_RG_VAUD28_ON_CTRL_SHIFT},
	{PMIC_RG_VAUD28_SRCLK_MODE_SEL, MT6328_PMIC_RG_VAUD28_SRCLK_MODE_SEL_ADDR,
	 MT6328_PMIC_RG_VAUD28_SRCLK_MODE_SEL_MASK, MT6328_PMIC_RG_VAUD28_SRCLK_MODE_SEL_SHIFT},
	{PMIC_QI_VAUD28_MODE, MT6328_PMIC_QI_VAUD28_MODE_ADDR, MT6328_PMIC_QI_VAUD28_MODE_MASK,
	 MT6328_PMIC_QI_VAUD28_MODE_SHIFT},
	{PMIC_RG_VAUD28_STBTD, MT6328_PMIC_RG_VAUD28_STBTD_ADDR, MT6328_PMIC_RG_VAUD28_STBTD_MASK,
	 MT6328_PMIC_RG_VAUD28_STBTD_SHIFT},
	{PMIC_RG_VAUD28_OCFB_EN, MT6328_PMIC_RG_VAUD28_OCFB_EN_ADDR,
	 MT6328_PMIC_RG_VAUD28_OCFB_EN_MASK, MT6328_PMIC_RG_VAUD28_OCFB_EN_SHIFT},
	{PMIC_QI_VAUD28_OCFB_EN, MT6328_PMIC_QI_VAUD28_OCFB_EN_ADDR,
	 MT6328_PMIC_QI_VAUD28_OCFB_EN_MASK, MT6328_PMIC_QI_VAUD28_OCFB_EN_SHIFT},
	{PMIC_RG_VAUD28_SRCLK_EN_SEL, MT6328_PMIC_RG_VAUD28_SRCLK_EN_SEL_ADDR,
	 MT6328_PMIC_RG_VAUD28_SRCLK_EN_SEL_MASK, MT6328_PMIC_RG_VAUD28_SRCLK_EN_SEL_SHIFT},
	{PMIC_QI_VAUD28_STB, MT6328_PMIC_QI_VAUD28_STB_ADDR, MT6328_PMIC_QI_VAUD28_STB_MASK,
	 MT6328_PMIC_QI_VAUD28_STB_SHIFT},
	{PMIC_QI_VAUD28_EN, MT6328_PMIC_QI_VAUD28_EN_ADDR, MT6328_PMIC_QI_VAUD28_EN_MASK,
	 MT6328_PMIC_QI_VAUD28_EN_SHIFT},
	{PMIC_RG_VAUX18_MODE_SET, MT6328_PMIC_RG_VAUX18_MODE_SET_ADDR,
	 MT6328_PMIC_RG_VAUX18_MODE_SET_MASK, MT6328_PMIC_RG_VAUX18_MODE_SET_SHIFT},
	{PMIC_RG_VAUX18_EN, MT6328_PMIC_RG_VAUX18_EN_ADDR, MT6328_PMIC_RG_VAUX18_EN_MASK,
	 MT6328_PMIC_RG_VAUX18_EN_SHIFT},
	{PMIC_RG_VAUX18_MODE_CTRL, MT6328_PMIC_RG_VAUX18_MODE_CTRL_ADDR,
	 MT6328_PMIC_RG_VAUX18_MODE_CTRL_MASK, MT6328_PMIC_RG_VAUX18_MODE_CTRL_SHIFT},
	{PMIC_RG_VAUX18_ON_CTRL, MT6328_PMIC_RG_VAUX18_ON_CTRL_ADDR,
	 MT6328_PMIC_RG_VAUX18_ON_CTRL_MASK, MT6328_PMIC_RG_VAUX18_ON_CTRL_SHIFT},
	{PMIC_RG_VAUX18_SRCLK_MODE_SEL, MT6328_PMIC_RG_VAUX18_SRCLK_MODE_SEL_ADDR,
	 MT6328_PMIC_RG_VAUX18_SRCLK_MODE_SEL_MASK, MT6328_PMIC_RG_VAUX18_SRCLK_MODE_SEL_SHIFT},
	{PMIC_RG_VAUX18_AUXADC_PWDB_EN, MT6328_PMIC_RG_VAUX18_AUXADC_PWDB_EN_ADDR,
	 MT6328_PMIC_RG_VAUX18_AUXADC_PWDB_EN_MASK, MT6328_PMIC_RG_VAUX18_AUXADC_PWDB_EN_SHIFT},
	{PMIC_QI_VAUX18_MODE, MT6328_PMIC_QI_VAUX18_MODE_ADDR, MT6328_PMIC_QI_VAUX18_MODE_MASK,
	 MT6328_PMIC_QI_VAUX18_MODE_SHIFT},
	{PMIC_RG_VAUX18_STBTD, MT6328_PMIC_RG_VAUX18_STBTD_ADDR, MT6328_PMIC_RG_VAUX18_STBTD_MASK,
	 MT6328_PMIC_RG_VAUX18_STBTD_SHIFT},
	{PMIC_RG_VAUX18_OCFB_EN, MT6328_PMIC_RG_VAUX18_OCFB_EN_ADDR,
	 MT6328_PMIC_RG_VAUX18_OCFB_EN_MASK, MT6328_PMIC_RG_VAUX18_OCFB_EN_SHIFT},
	{PMIC_QI_VAUX18_OCFB_EN, MT6328_PMIC_QI_VAUX18_OCFB_EN_ADDR,
	 MT6328_PMIC_QI_VAUX18_OCFB_EN_MASK, MT6328_PMIC_QI_VAUX18_OCFB_EN_SHIFT},
	{PMIC_RG_VAUX18_SRCLK_EN_SEL, MT6328_PMIC_RG_VAUX18_SRCLK_EN_SEL_ADDR,
	 MT6328_PMIC_RG_VAUX18_SRCLK_EN_SEL_MASK, MT6328_PMIC_RG_VAUX18_SRCLK_EN_SEL_SHIFT},
	{PMIC_QI_VAUX18_STB, MT6328_PMIC_QI_VAUX18_STB_ADDR, MT6328_PMIC_QI_VAUX18_STB_MASK,
	 MT6328_PMIC_QI_VAUX18_STB_SHIFT},
	{PMIC_QI_VAUX18_EN, MT6328_PMIC_QI_VAUX18_EN_ADDR, MT6328_PMIC_QI_VAUX18_EN_MASK,
	 MT6328_PMIC_QI_VAUX18_EN_SHIFT},
	{PMIC_RG_VRF18_0_MODE_SET, MT6328_PMIC_RG_VRF18_0_MODE_SET_ADDR,
	 MT6328_PMIC_RG_VRF18_0_MODE_SET_MASK, MT6328_PMIC_RG_VRF18_0_MODE_SET_SHIFT},
	{PMIC_RG_VRF18_0_EN, MT6328_PMIC_RG_VRF18_0_EN_ADDR, MT6328_PMIC_RG_VRF18_0_EN_MASK,
	 MT6328_PMIC_RG_VRF18_0_EN_SHIFT},
	{PMIC_RG_VRF18_0_MODE_CTRL, MT6328_PMIC_RG_VRF18_0_MODE_CTRL_ADDR,
	 MT6328_PMIC_RG_VRF18_0_MODE_CTRL_MASK, MT6328_PMIC_RG_VRF18_0_MODE_CTRL_SHIFT},
	{PMIC_RG_VRF18_0_ON_CTRL, MT6328_PMIC_RG_VRF18_0_ON_CTRL_ADDR,
	 MT6328_PMIC_RG_VRF18_0_ON_CTRL_MASK, MT6328_PMIC_RG_VRF18_0_ON_CTRL_SHIFT},
	{PMIC_RG_VRF18_0_SRCLK_MODE_SEL, MT6328_PMIC_RG_VRF18_0_SRCLK_MODE_SEL_ADDR,
	 MT6328_PMIC_RG_VRF18_0_SRCLK_MODE_SEL_MASK, MT6328_PMIC_RG_VRF18_0_SRCLK_MODE_SEL_SHIFT},
	{PMIC_QI_VRF18_0_MODE, MT6328_PMIC_QI_VRF18_0_MODE_ADDR, MT6328_PMIC_QI_VRF18_0_MODE_MASK,
	 MT6328_PMIC_QI_VRF18_0_MODE_SHIFT},
	{PMIC_RG_VRF18_0_STBTD, MT6328_PMIC_RG_VRF18_0_STBTD_ADDR,
	 MT6328_PMIC_RG_VRF18_0_STBTD_MASK, MT6328_PMIC_RG_VRF18_0_STBTD_SHIFT},
	{PMIC_RG_VRF18_0_OCFB_EN, MT6328_PMIC_RG_VRF18_0_OCFB_EN_ADDR,
	 MT6328_PMIC_RG_VRF18_0_OCFB_EN_MASK, MT6328_PMIC_RG_VRF18_0_OCFB_EN_SHIFT},
	{PMIC_QI_VRF18_0_OCFB_EN, MT6328_PMIC_QI_VRF18_0_OCFB_EN_ADDR,
	 MT6328_PMIC_QI_VRF18_0_OCFB_EN_MASK, MT6328_PMIC_QI_VRF18_0_OCFB_EN_SHIFT},
	{PMIC_RG_VRF18_0_SRCLK_EN_SEL, MT6328_PMIC_RG_VRF18_0_SRCLK_EN_SEL_ADDR,
	 MT6328_PMIC_RG_VRF18_0_SRCLK_EN_SEL_MASK, MT6328_PMIC_RG_VRF18_0_SRCLK_EN_SEL_SHIFT},
	{PMIC_QI_VRF18_0_STB, MT6328_PMIC_QI_VRF18_0_STB_ADDR, MT6328_PMIC_QI_VRF18_0_STB_MASK,
	 MT6328_PMIC_QI_VRF18_0_STB_SHIFT},
	{PMIC_QI_VRF18_0_EN, MT6328_PMIC_QI_VRF18_0_EN_ADDR, MT6328_PMIC_QI_VRF18_0_EN_MASK,
	 MT6328_PMIC_QI_VRF18_0_EN_SHIFT},
	{PMIC_RG_VRF18_0_FAST_TRAN_EN, MT6328_PMIC_RG_VRF18_0_FAST_TRAN_EN_ADDR,
	 MT6328_PMIC_RG_VRF18_0_FAST_TRAN_EN_MASK, MT6328_PMIC_RG_VRF18_0_FAST_TRAN_EN_SHIFT},
	{PMIC_RG_VRF18_0_SRCLK_FAST_TRAN_SEL, MT6328_PMIC_RG_VRF18_0_SRCLK_FAST_TRAN_SEL_ADDR,
	 MT6328_PMIC_RG_VRF18_0_SRCLK_FAST_TRAN_SEL_MASK,
	 MT6328_PMIC_RG_VRF18_0_SRCLK_FAST_TRAN_SEL_SHIFT},
	{PMIC_QI_VRF18_0_FAST_TRAN_EN, MT6328_PMIC_QI_VRF18_0_FAST_TRAN_EN_ADDR,
	 MT6328_PMIC_QI_VRF18_0_FAST_TRAN_EN_MASK, MT6328_PMIC_QI_VRF18_0_FAST_TRAN_EN_SHIFT},
	{PMIC_RG_VCAMA_EN, MT6328_PMIC_RG_VCAMA_EN_ADDR, MT6328_PMIC_RG_VCAMA_EN_MASK,
	 MT6328_PMIC_RG_VCAMA_EN_SHIFT},
	{PMIC_RG_VCAMA_STBTD, MT6328_PMIC_RG_VCAMA_STBTD_ADDR, MT6328_PMIC_RG_VCAMA_STBTD_MASK,
	 MT6328_PMIC_RG_VCAMA_STBTD_SHIFT},
	{PMIC_RG_VCAMA_OCFB_EN, MT6328_PMIC_RG_VCAMA_OCFB_EN_ADDR,
	 MT6328_PMIC_RG_VCAMA_OCFB_EN_MASK, MT6328_PMIC_RG_VCAMA_OCFB_EN_SHIFT},
	{PMIC_QI_VCAMA_OCFB_EN, MT6328_PMIC_QI_VCAMA_OCFB_EN_ADDR,
	 MT6328_PMIC_QI_VCAMA_OCFB_EN_MASK, MT6328_PMIC_QI_VCAMA_OCFB_EN_SHIFT},
	{PMIC_QI_VCAMA_STB, MT6328_PMIC_QI_VCAMA_STB_ADDR, MT6328_PMIC_QI_VCAMA_STB_MASK,
	 MT6328_PMIC_QI_VCAMA_STB_SHIFT},
	{PMIC_QI_VCAMA_EN, MT6328_PMIC_QI_VCAMA_EN_ADDR, MT6328_PMIC_QI_VCAMA_EN_MASK,
	 MT6328_PMIC_QI_VCAMA_EN_SHIFT},
	{PMIC_RG_VCN28_MODE_SET, MT6328_PMIC_RG_VCN28_MODE_SET_ADDR,
	 MT6328_PMIC_RG_VCN28_MODE_SET_MASK, MT6328_PMIC_RG_VCN28_MODE_SET_SHIFT},
	{PMIC_RG_VCN28_EN, MT6328_PMIC_RG_VCN28_EN_ADDR, MT6328_PMIC_RG_VCN28_EN_MASK,
	 MT6328_PMIC_RG_VCN28_EN_SHIFT},
	{PMIC_RG_VCN28_MODE_CTRL, MT6328_PMIC_RG_VCN28_MODE_CTRL_ADDR,
	 MT6328_PMIC_RG_VCN28_MODE_CTRL_MASK, MT6328_PMIC_RG_VCN28_MODE_CTRL_SHIFT},
	{PMIC_RG_VCN28_ON_CTRL, MT6328_PMIC_RG_VCN28_ON_CTRL_ADDR,
	 MT6328_PMIC_RG_VCN28_ON_CTRL_MASK, MT6328_PMIC_RG_VCN28_ON_CTRL_SHIFT},
	{PMIC_RG_VCN28_SRCLK_MODE_SEL, MT6328_PMIC_RG_VCN28_SRCLK_MODE_SEL_ADDR,
	 MT6328_PMIC_RG_VCN28_SRCLK_MODE_SEL_MASK, MT6328_PMIC_RG_VCN28_SRCLK_MODE_SEL_SHIFT},
	{PMIC_QI_VCN28_MODE, MT6328_PMIC_QI_VCN28_MODE_ADDR, MT6328_PMIC_QI_VCN28_MODE_MASK,
	 MT6328_PMIC_QI_VCN28_MODE_SHIFT},
	{PMIC_RG_VCN28_STBTD, MT6328_PMIC_RG_VCN28_STBTD_ADDR, MT6328_PMIC_RG_VCN28_STBTD_MASK,
	 MT6328_PMIC_RG_VCN28_STBTD_SHIFT},
	{PMIC_RG_VCN28_OCFB_EN, MT6328_PMIC_RG_VCN28_OCFB_EN_ADDR,
	 MT6328_PMIC_RG_VCN28_OCFB_EN_MASK, MT6328_PMIC_RG_VCN28_OCFB_EN_SHIFT},
	{PMIC_QI_VCN28_OCFB_EN, MT6328_PMIC_QI_VCN28_OCFB_EN_ADDR,
	 MT6328_PMIC_QI_VCN28_OCFB_EN_MASK, MT6328_PMIC_QI_VCN28_OCFB_EN_SHIFT},
	{PMIC_RG_VCN28_SRCLK_EN_SEL, MT6328_PMIC_RG_VCN28_SRCLK_EN_SEL_ADDR,
	 MT6328_PMIC_RG_VCN28_SRCLK_EN_SEL_MASK, MT6328_PMIC_RG_VCN28_SRCLK_EN_SEL_SHIFT},
	{PMIC_QI_VCN28_STB, MT6328_PMIC_QI_VCN28_STB_ADDR, MT6328_PMIC_QI_VCN28_STB_MASK,
	 MT6328_PMIC_QI_VCN28_STB_SHIFT},
	{PMIC_QI_VCN28_EN, MT6328_PMIC_QI_VCN28_EN_ADDR, MT6328_PMIC_QI_VCN28_EN_MASK,
	 MT6328_PMIC_QI_VCN28_EN_SHIFT},
	{PMIC_RG_VCN33_MODE_SET, MT6328_PMIC_RG_VCN33_MODE_SET_ADDR,
	 MT6328_PMIC_RG_VCN33_MODE_SET_MASK, MT6328_PMIC_RG_VCN33_MODE_SET_SHIFT},
	{PMIC_RG_VCN33_MODE_CTRL, MT6328_PMIC_RG_VCN33_MODE_CTRL_ADDR,
	 MT6328_PMIC_RG_VCN33_MODE_CTRL_MASK, MT6328_PMIC_RG_VCN33_MODE_CTRL_SHIFT},
	{PMIC_RG_VCN33_SRCLK_MODE_SEL, MT6328_PMIC_RG_VCN33_SRCLK_MODE_SEL_ADDR,
	 MT6328_PMIC_RG_VCN33_SRCLK_MODE_SEL_MASK, MT6328_PMIC_RG_VCN33_SRCLK_MODE_SEL_SHIFT},
	{PMIC_QI_VCN33_MODE, MT6328_PMIC_QI_VCN33_MODE_ADDR, MT6328_PMIC_QI_VCN33_MODE_MASK,
	 MT6328_PMIC_QI_VCN33_MODE_SHIFT},
	{PMIC_RG_VCN33_STBTD, MT6328_PMIC_RG_VCN33_STBTD_ADDR, MT6328_PMIC_RG_VCN33_STBTD_MASK,
	 MT6328_PMIC_RG_VCN33_STBTD_SHIFT},
	{PMIC_RG_VCN33_OCFB_EN, MT6328_PMIC_RG_VCN33_OCFB_EN_ADDR,
	 MT6328_PMIC_RG_VCN33_OCFB_EN_MASK, MT6328_PMIC_RG_VCN33_OCFB_EN_SHIFT},
	{PMIC_QI_VCN33_OCFB_EN, MT6328_PMIC_QI_VCN33_OCFB_EN_ADDR,
	 MT6328_PMIC_QI_VCN33_OCFB_EN_MASK, MT6328_PMIC_QI_VCN33_OCFB_EN_SHIFT},
	{PMIC_QI_VCN33_STB, MT6328_PMIC_QI_VCN33_STB_ADDR, MT6328_PMIC_QI_VCN33_STB_MASK,
	 MT6328_PMIC_QI_VCN33_STB_SHIFT},
	{PMIC_QI_VCN33_EN, MT6328_PMIC_QI_VCN33_EN_ADDR, MT6328_PMIC_QI_VCN33_EN_MASK,
	 MT6328_PMIC_QI_VCN33_EN_SHIFT},
	{PMIC_RG_VCN33_EN_WIFI, MT6328_PMIC_RG_VCN33_EN_WIFI_ADDR,
	 MT6328_PMIC_RG_VCN33_EN_WIFI_MASK, MT6328_PMIC_RG_VCN33_EN_WIFI_SHIFT},
	{PMIC_RG_VCN33_ON_CTRL_WIFI, MT6328_PMIC_RG_VCN33_ON_CTRL_WIFI_ADDR,
	 MT6328_PMIC_RG_VCN33_ON_CTRL_WIFI_MASK, MT6328_PMIC_RG_VCN33_ON_CTRL_WIFI_SHIFT},
	{PMIC_RG_VCN33_SRCLK_EN_SEL_WIFI, MT6328_PMIC_RG_VCN33_SRCLK_EN_SEL_WIFI_ADDR,
	 MT6328_PMIC_RG_VCN33_SRCLK_EN_SEL_WIFI_MASK, MT6328_PMIC_RG_VCN33_SRCLK_EN_SEL_WIFI_SHIFT},
	{PMIC_RG_VCN33_EN_BT, MT6328_PMIC_RG_VCN33_EN_BT_ADDR, MT6328_PMIC_RG_VCN33_EN_BT_MASK,
	 MT6328_PMIC_RG_VCN33_EN_BT_SHIFT},
	{PMIC_RG_VCN33_ON_CTRL_BT, MT6328_PMIC_RG_VCN33_ON_CTRL_BT_ADDR,
	 MT6328_PMIC_RG_VCN33_ON_CTRL_BT_MASK, MT6328_PMIC_RG_VCN33_ON_CTRL_BT_SHIFT},
	{PMIC_RG_VCN33_SRCLK_EN_SEL_BT, MT6328_PMIC_RG_VCN33_SRCLK_EN_SEL_BT_ADDR,
	 MT6328_PMIC_RG_VCN33_SRCLK_EN_SEL_BT_MASK, MT6328_PMIC_RG_VCN33_SRCLK_EN_SEL_BT_SHIFT},
	{PMIC_RG_VRF18_1_MODE_SET, MT6328_PMIC_RG_VRF18_1_MODE_SET_ADDR,
	 MT6328_PMIC_RG_VRF18_1_MODE_SET_MASK, MT6328_PMIC_RG_VRF18_1_MODE_SET_SHIFT},
	{PMIC_RG_VRF18_1_EN, MT6328_PMIC_RG_VRF18_1_EN_ADDR, MT6328_PMIC_RG_VRF18_1_EN_MASK,
	 MT6328_PMIC_RG_VRF18_1_EN_SHIFT},
	{PMIC_RG_VRF18_1_MODE_CTRL, MT6328_PMIC_RG_VRF18_1_MODE_CTRL_ADDR,
	 MT6328_PMIC_RG_VRF18_1_MODE_CTRL_MASK, MT6328_PMIC_RG_VRF18_1_MODE_CTRL_SHIFT},
	{PMIC_RG_VRF18_1_ON_CTRL, MT6328_PMIC_RG_VRF18_1_ON_CTRL_ADDR,
	 MT6328_PMIC_RG_VRF18_1_ON_CTRL_MASK, MT6328_PMIC_RG_VRF18_1_ON_CTRL_SHIFT},
	{PMIC_RG_VRF18_1_SRCLK_MODE_SEL, MT6328_PMIC_RG_VRF18_1_SRCLK_MODE_SEL_ADDR,
	 MT6328_PMIC_RG_VRF18_1_SRCLK_MODE_SEL_MASK, MT6328_PMIC_RG_VRF18_1_SRCLK_MODE_SEL_SHIFT},
	{PMIC_QI_VRF18_1_MODE, MT6328_PMIC_QI_VRF18_1_MODE_ADDR, MT6328_PMIC_QI_VRF18_1_MODE_MASK,
	 MT6328_PMIC_QI_VRF18_1_MODE_SHIFT},
	{PMIC_RG_VRF18_1_STBTD, MT6328_PMIC_RG_VRF18_1_STBTD_ADDR,
	 MT6328_PMIC_RG_VRF18_1_STBTD_MASK, MT6328_PMIC_RG_VRF18_1_STBTD_SHIFT},
	{PMIC_RG_VRF18_1_OCFB_EN, MT6328_PMIC_RG_VRF18_1_OCFB_EN_ADDR,
	 MT6328_PMIC_RG_VRF18_1_OCFB_EN_MASK, MT6328_PMIC_RG_VRF18_1_OCFB_EN_SHIFT},
	{PMIC_QI_VRF18_1_OCFB_EN, MT6328_PMIC_QI_VRF18_1_OCFB_EN_ADDR,
	 MT6328_PMIC_QI_VRF18_1_OCFB_EN_MASK, MT6328_PMIC_QI_VRF18_1_OCFB_EN_SHIFT},
	{PMIC_RG_VRF18_1_SRCLK_EN_SEL, MT6328_PMIC_RG_VRF18_1_SRCLK_EN_SEL_ADDR,
	 MT6328_PMIC_RG_VRF18_1_SRCLK_EN_SEL_MASK, MT6328_PMIC_RG_VRF18_1_SRCLK_EN_SEL_SHIFT},
	{PMIC_QI_VRF18_1_STB, MT6328_PMIC_QI_VRF18_1_STB_ADDR, MT6328_PMIC_QI_VRF18_1_STB_MASK,
	 MT6328_PMIC_QI_VRF18_1_STB_SHIFT},
	{PMIC_QI_VRF18_1_EN, MT6328_PMIC_QI_VRF18_1_EN_ADDR, MT6328_PMIC_QI_VRF18_1_EN_MASK,
	 MT6328_PMIC_QI_VRF18_1_EN_SHIFT},
	{PMIC_RG_VRF18_1_FAST_TRAN_EN, MT6328_PMIC_RG_VRF18_1_FAST_TRAN_EN_ADDR,
	 MT6328_PMIC_RG_VRF18_1_FAST_TRAN_EN_MASK, MT6328_PMIC_RG_VRF18_1_FAST_TRAN_EN_SHIFT},
	{PMIC_RG_VRF18_1_SRCLK_FAST_TRAN_SEL, MT6328_PMIC_RG_VRF18_1_SRCLK_FAST_TRAN_SEL_ADDR,
	 MT6328_PMIC_RG_VRF18_1_SRCLK_FAST_TRAN_SEL_MASK,
	 MT6328_PMIC_RG_VRF18_1_SRCLK_FAST_TRAN_SEL_SHIFT},
	{PMIC_QI_VRF18_1_FAST_TRAN_EN, MT6328_PMIC_QI_VRF18_1_FAST_TRAN_EN_ADDR,
	 MT6328_PMIC_QI_VRF18_1_FAST_TRAN_EN_MASK, MT6328_PMIC_QI_VRF18_1_FAST_TRAN_EN_SHIFT},
	{PMIC_RG_VUSB33_MODE_SET, MT6328_PMIC_RG_VUSB33_MODE_SET_ADDR,
	 MT6328_PMIC_RG_VUSB33_MODE_SET_MASK, MT6328_PMIC_RG_VUSB33_MODE_SET_SHIFT},
	{PMIC_RG_VUSB33_EN, MT6328_PMIC_RG_VUSB33_EN_ADDR, MT6328_PMIC_RG_VUSB33_EN_MASK,
	 MT6328_PMIC_RG_VUSB33_EN_SHIFT},
	{PMIC_RG_VUSB33_MODE_CTRL, MT6328_PMIC_RG_VUSB33_MODE_CTRL_ADDR,
	 MT6328_PMIC_RG_VUSB33_MODE_CTRL_MASK, MT6328_PMIC_RG_VUSB33_MODE_CTRL_SHIFT},
	{PMIC_RG_VUSB33_ON_CTRL, MT6328_PMIC_RG_VUSB33_ON_CTRL_ADDR,
	 MT6328_PMIC_RG_VUSB33_ON_CTRL_MASK, MT6328_PMIC_RG_VUSB33_ON_CTRL_SHIFT},
	{PMIC_RG_VUSB33_SRCLK_MODE_SEL, MT6328_PMIC_RG_VUSB33_SRCLK_MODE_SEL_ADDR,
	 MT6328_PMIC_RG_VUSB33_SRCLK_MODE_SEL_MASK, MT6328_PMIC_RG_VUSB33_SRCLK_MODE_SEL_SHIFT},
	{PMIC_QI_VUSB33_MODE, MT6328_PMIC_QI_VUSB33_MODE_ADDR, MT6328_PMIC_QI_VUSB33_MODE_MASK,
	 MT6328_PMIC_QI_VUSB33_MODE_SHIFT},
	{PMIC_RG_VUSB33_STBTD, MT6328_PMIC_RG_VUSB33_STBTD_ADDR, MT6328_PMIC_RG_VUSB33_STBTD_MASK,
	 MT6328_PMIC_RG_VUSB33_STBTD_SHIFT},
	{PMIC_RG_VUSB33_OCFB_EN, MT6328_PMIC_RG_VUSB33_OCFB_EN_ADDR,
	 MT6328_PMIC_RG_VUSB33_OCFB_EN_MASK, MT6328_PMIC_RG_VUSB33_OCFB_EN_SHIFT},
	{PMIC_QI_VUSB33_OCFB_EN, MT6328_PMIC_QI_VUSB33_OCFB_EN_ADDR,
	 MT6328_PMIC_QI_VUSB33_OCFB_EN_MASK, MT6328_PMIC_QI_VUSB33_OCFB_EN_SHIFT},
	{PMIC_RG_VUSB33_SRCLK_EN_SEL, MT6328_PMIC_RG_VUSB33_SRCLK_EN_SEL_ADDR,
	 MT6328_PMIC_RG_VUSB33_SRCLK_EN_SEL_MASK, MT6328_PMIC_RG_VUSB33_SRCLK_EN_SEL_SHIFT},
	{PMIC_QI_VUSB33_STB, MT6328_PMIC_QI_VUSB33_STB_ADDR, MT6328_PMIC_QI_VUSB33_STB_MASK,
	 MT6328_PMIC_QI_VUSB33_STB_SHIFT},
	{PMIC_QI_VUSB33_EN, MT6328_PMIC_QI_VUSB33_EN_ADDR, MT6328_PMIC_QI_VUSB33_EN_MASK,
	 MT6328_PMIC_QI_VUSB33_EN_SHIFT},
	{PMIC_RG_VMCH_MODE_SET, MT6328_PMIC_RG_VMCH_MODE_SET_ADDR,
	 MT6328_PMIC_RG_VMCH_MODE_SET_MASK, MT6328_PMIC_RG_VMCH_MODE_SET_SHIFT},
	{PMIC_RG_VMCH_EN, MT6328_PMIC_RG_VMCH_EN_ADDR, MT6328_PMIC_RG_VMCH_EN_MASK,
	 MT6328_PMIC_RG_VMCH_EN_SHIFT},
	{PMIC_RG_VMCH_MODE_CTRL, MT6328_PMIC_RG_VMCH_MODE_CTRL_ADDR,
	 MT6328_PMIC_RG_VMCH_MODE_CTRL_MASK, MT6328_PMIC_RG_VMCH_MODE_CTRL_SHIFT},
	{PMIC_RG_VMCH_ON_CTRL, MT6328_PMIC_RG_VMCH_ON_CTRL_ADDR, MT6328_PMIC_RG_VMCH_ON_CTRL_MASK,
	 MT6328_PMIC_RG_VMCH_ON_CTRL_SHIFT},
	{PMIC_RG_VMCH_SRCLK_MODE_SEL, MT6328_PMIC_RG_VMCH_SRCLK_MODE_SEL_ADDR,
	 MT6328_PMIC_RG_VMCH_SRCLK_MODE_SEL_MASK, MT6328_PMIC_RG_VMCH_SRCLK_MODE_SEL_SHIFT},
	{PMIC_QI_VMCH_MODE, MT6328_PMIC_QI_VMCH_MODE_ADDR, MT6328_PMIC_QI_VMCH_MODE_MASK,
	 MT6328_PMIC_QI_VMCH_MODE_SHIFT},
	{PMIC_RG_VMCH_STBTD, MT6328_PMIC_RG_VMCH_STBTD_ADDR, MT6328_PMIC_RG_VMCH_STBTD_MASK,
	 MT6328_PMIC_RG_VMCH_STBTD_SHIFT},
	{PMIC_RG_VMCH_OCFB_EN, MT6328_PMIC_RG_VMCH_OCFB_EN_ADDR, MT6328_PMIC_RG_VMCH_OCFB_EN_MASK,
	 MT6328_PMIC_RG_VMCH_OCFB_EN_SHIFT},
	{PMIC_QI_VMCH_OCFB_EN, MT6328_PMIC_QI_VMCH_OCFB_EN_ADDR, MT6328_PMIC_QI_VMCH_OCFB_EN_MASK,
	 MT6328_PMIC_QI_VMCH_OCFB_EN_SHIFT},
	{PMIC_RG_VMCH_SRCLK_EN_SEL, MT6328_PMIC_RG_VMCH_SRCLK_EN_SEL_ADDR,
	 MT6328_PMIC_RG_VMCH_SRCLK_EN_SEL_MASK, MT6328_PMIC_RG_VMCH_SRCLK_EN_SEL_SHIFT},
	{PMIC_QI_VMCH_STB, MT6328_PMIC_QI_VMCH_STB_ADDR, MT6328_PMIC_QI_VMCH_STB_MASK,
	 MT6328_PMIC_QI_VMCH_STB_SHIFT},
	{PMIC_QI_VMCH_EN, MT6328_PMIC_QI_VMCH_EN_ADDR, MT6328_PMIC_QI_VMCH_EN_MASK,
	 MT6328_PMIC_QI_VMCH_EN_SHIFT},
	{PMIC_RG_VMCH_FAST_TRAN_EN, MT6328_PMIC_RG_VMCH_FAST_TRAN_EN_ADDR,
	 MT6328_PMIC_RG_VMCH_FAST_TRAN_EN_MASK, MT6328_PMIC_RG_VMCH_FAST_TRAN_EN_SHIFT},
	{PMIC_RG_VMCH_SRCLK_FAST_TRAN_SEL, MT6328_PMIC_RG_VMCH_SRCLK_FAST_TRAN_SEL_ADDR,
	 MT6328_PMIC_RG_VMCH_SRCLK_FAST_TRAN_SEL_MASK,
	 MT6328_PMIC_RG_VMCH_SRCLK_FAST_TRAN_SEL_SHIFT},
	{PMIC_QI_VMCH_FAST_TRAN_EN, MT6328_PMIC_QI_VMCH_FAST_TRAN_EN_ADDR,
	 MT6328_PMIC_QI_VMCH_FAST_TRAN_EN_MASK, MT6328_PMIC_QI_VMCH_FAST_TRAN_EN_SHIFT},
	{PMIC_RG_VMC_MODE_SET, MT6328_PMIC_RG_VMC_MODE_SET_ADDR, MT6328_PMIC_RG_VMC_MODE_SET_MASK,
	 MT6328_PMIC_RG_VMC_MODE_SET_SHIFT},
	{PMIC_RG_VMC_EN, MT6328_PMIC_RG_VMC_EN_ADDR, MT6328_PMIC_RG_VMC_EN_MASK,
	 MT6328_PMIC_RG_VMC_EN_SHIFT},
	{PMIC_RG_VMC_MODE_CTRL, MT6328_PMIC_RG_VMC_MODE_CTRL_ADDR,
	 MT6328_PMIC_RG_VMC_MODE_CTRL_MASK, MT6328_PMIC_RG_VMC_MODE_CTRL_SHIFT},
	{PMIC_RG_VMC_ON_CTRL, MT6328_PMIC_RG_VMC_ON_CTRL_ADDR, MT6328_PMIC_RG_VMC_ON_CTRL_MASK,
	 MT6328_PMIC_RG_VMC_ON_CTRL_SHIFT},
	{PMIC_RG_VMC_SRCLK_MODE_SEL, MT6328_PMIC_RG_VMC_SRCLK_MODE_SEL_ADDR,
	 MT6328_PMIC_RG_VMC_SRCLK_MODE_SEL_MASK, MT6328_PMIC_RG_VMC_SRCLK_MODE_SEL_SHIFT},
	{PMIC_QI_VMC_MODE, MT6328_PMIC_QI_VMC_MODE_ADDR, MT6328_PMIC_QI_VMC_MODE_MASK,
	 MT6328_PMIC_QI_VMC_MODE_SHIFT},
	{PMIC_RG_VMC_STBTD, MT6328_PMIC_RG_VMC_STBTD_ADDR, MT6328_PMIC_RG_VMC_STBTD_MASK,
	 MT6328_PMIC_RG_VMC_STBTD_SHIFT},
	{PMIC_RG_VMC_OCFB_EN, MT6328_PMIC_RG_VMC_OCFB_EN_ADDR, MT6328_PMIC_RG_VMC_OCFB_EN_MASK,
	 MT6328_PMIC_RG_VMC_OCFB_EN_SHIFT},
	{PMIC_QI_VMC_OCFB_EN, MT6328_PMIC_QI_VMC_OCFB_EN_ADDR, MT6328_PMIC_QI_VMC_OCFB_EN_MASK,
	 MT6328_PMIC_QI_VMC_OCFB_EN_SHIFT},
	{PMIC_RG_VMC_SRCLK_EN_SEL, MT6328_PMIC_RG_VMC_SRCLK_EN_SEL_ADDR,
	 MT6328_PMIC_RG_VMC_SRCLK_EN_SEL_MASK, MT6328_PMIC_RG_VMC_SRCLK_EN_SEL_SHIFT},
	{PMIC_QI_VMC_STB, MT6328_PMIC_QI_VMC_STB_ADDR, MT6328_PMIC_QI_VMC_STB_MASK,
	 MT6328_PMIC_QI_VMC_STB_SHIFT},
	{PMIC_QI_VMC_EN, MT6328_PMIC_QI_VMC_EN_ADDR, MT6328_PMIC_QI_VMC_EN_MASK,
	 MT6328_PMIC_QI_VMC_EN_SHIFT},
	{PMIC_RG_VMC_TRANS_EN, MT6328_PMIC_RG_VMC_TRANS_EN_ADDR, MT6328_PMIC_RG_VMC_TRANS_EN_MASK,
	 MT6328_PMIC_RG_VMC_TRANS_EN_SHIFT},
	{PMIC_RG_VMC_TRANS_CTRL, MT6328_PMIC_RG_VMC_TRANS_CTRL_ADDR,
	 MT6328_PMIC_RG_VMC_TRANS_CTRL_MASK, MT6328_PMIC_RG_VMC_TRANS_CTRL_SHIFT},
	{PMIC_RG_VMC_TRANS_ONCE, MT6328_PMIC_RG_VMC_TRANS_ONCE_ADDR,
	 MT6328_PMIC_RG_VMC_TRANS_ONCE_MASK, MT6328_PMIC_RG_VMC_TRANS_ONCE_SHIFT},
	{PMIC_RG_VMC_INT_DIS_SEL, MT6328_PMIC_RG_VMC_INT_DIS_SEL_ADDR,
	 MT6328_PMIC_RG_VMC_INT_DIS_SEL_MASK, MT6328_PMIC_RG_VMC_INT_DIS_SEL_SHIFT},
	{PMIC_QI_VMC_INT_DIS, MT6328_PMIC_QI_VMC_INT_DIS_ADDR, MT6328_PMIC_QI_VMC_INT_DIS_MASK,
	 MT6328_PMIC_QI_VMC_INT_DIS_SHIFT},
	{PMIC_RG_VEMC_3V3_MODE_SET, MT6328_PMIC_RG_VEMC_3V3_MODE_SET_ADDR,
	 MT6328_PMIC_RG_VEMC_3V3_MODE_SET_MASK, MT6328_PMIC_RG_VEMC_3V3_MODE_SET_SHIFT},
	{PMIC_RG_VEMC_3V3_EN, MT6328_PMIC_RG_VEMC_3V3_EN_ADDR, MT6328_PMIC_RG_VEMC_3V3_EN_MASK,
	 MT6328_PMIC_RG_VEMC_3V3_EN_SHIFT},
	{PMIC_RG_VEMC_3V3_MODE_CTRL, MT6328_PMIC_RG_VEMC_3V3_MODE_CTRL_ADDR,
	 MT6328_PMIC_RG_VEMC_3V3_MODE_CTRL_MASK, MT6328_PMIC_RG_VEMC_3V3_MODE_CTRL_SHIFT},
	{PMIC_RG_VEMC_3V3_ON_CTRL, MT6328_PMIC_RG_VEMC_3V3_ON_CTRL_ADDR,
	 MT6328_PMIC_RG_VEMC_3V3_ON_CTRL_MASK, MT6328_PMIC_RG_VEMC_3V3_ON_CTRL_SHIFT},
	{PMIC_RG_VEMC_3V3_SRCLK_MODE_SEL, MT6328_PMIC_RG_VEMC_3V3_SRCLK_MODE_SEL_ADDR,
	 MT6328_PMIC_RG_VEMC_3V3_SRCLK_MODE_SEL_MASK, MT6328_PMIC_RG_VEMC_3V3_SRCLK_MODE_SEL_SHIFT},
	{PMIC_QI_VEMC_3V3_MODE, MT6328_PMIC_QI_VEMC_3V3_MODE_ADDR,
	 MT6328_PMIC_QI_VEMC_3V3_MODE_MASK, MT6328_PMIC_QI_VEMC_3V3_MODE_SHIFT},
	{PMIC_RG_VEMC_3V3_STBTD, MT6328_PMIC_RG_VEMC_3V3_STBTD_ADDR,
	 MT6328_PMIC_RG_VEMC_3V3_STBTD_MASK, MT6328_PMIC_RG_VEMC_3V3_STBTD_SHIFT},
	{PMIC_RG_VEMC_3V3_OCFB_EN, MT6328_PMIC_RG_VEMC_3V3_OCFB_EN_ADDR,
	 MT6328_PMIC_RG_VEMC_3V3_OCFB_EN_MASK, MT6328_PMIC_RG_VEMC_3V3_OCFB_EN_SHIFT},
	{PMIC_QI_VEMC_3V3_OCFB_EN, MT6328_PMIC_QI_VEMC_3V3_OCFB_EN_ADDR,
	 MT6328_PMIC_QI_VEMC_3V3_OCFB_EN_MASK, MT6328_PMIC_QI_VEMC_3V3_OCFB_EN_SHIFT},
	{PMIC_RG_VEMC_3V3_SRCLK_EN_SEL, MT6328_PMIC_RG_VEMC_3V3_SRCLK_EN_SEL_ADDR,
	 MT6328_PMIC_RG_VEMC_3V3_SRCLK_EN_SEL_MASK, MT6328_PMIC_RG_VEMC_3V3_SRCLK_EN_SEL_SHIFT},
	{PMIC_QI_VEMC_3V3_STB, MT6328_PMIC_QI_VEMC_3V3_STB_ADDR, MT6328_PMIC_QI_VEMC_3V3_STB_MASK,
	 MT6328_PMIC_QI_VEMC_3V3_STB_SHIFT},
	{PMIC_QI_VEMC_3V3_EN, MT6328_PMIC_QI_VEMC_3V3_EN_ADDR, MT6328_PMIC_QI_VEMC_3V3_EN_MASK,
	 MT6328_PMIC_QI_VEMC_3V3_EN_SHIFT},
	{PMIC_RG_VEMC_3V3_FAST_TRAN_EN, MT6328_PMIC_RG_VEMC_3V3_FAST_TRAN_EN_ADDR,
	 MT6328_PMIC_RG_VEMC_3V3_FAST_TRAN_EN_MASK, MT6328_PMIC_RG_VEMC_3V3_FAST_TRAN_EN_SHIFT},
	{PMIC_RG_VEMC_3V3_SRCLK_FAST_TRAN_SEL, MT6328_PMIC_RG_VEMC_3V3_SRCLK_FAST_TRAN_SEL_ADDR,
	 MT6328_PMIC_RG_VEMC_3V3_SRCLK_FAST_TRAN_SEL_MASK,
	 MT6328_PMIC_RG_VEMC_3V3_SRCLK_FAST_TRAN_SEL_SHIFT},
	{PMIC_QI_VEMC_3V3_FAST_TRAN_EN, MT6328_PMIC_QI_VEMC_3V3_FAST_TRAN_EN_ADDR,
	 MT6328_PMIC_QI_VEMC_3V3_FAST_TRAN_EN_MASK, MT6328_PMIC_QI_VEMC_3V3_FAST_TRAN_EN_SHIFT},
	{PMIC_RG_VIO28_MODE_SET, MT6328_PMIC_RG_VIO28_MODE_SET_ADDR,
	 MT6328_PMIC_RG_VIO28_MODE_SET_MASK, MT6328_PMIC_RG_VIO28_MODE_SET_SHIFT},
	{PMIC_RG_VIO28_EN, MT6328_PMIC_RG_VIO28_EN_ADDR, MT6328_PMIC_RG_VIO28_EN_MASK,
	 MT6328_PMIC_RG_VIO28_EN_SHIFT},
	{PMIC_RG_VIO28_MODE_CTRL, MT6328_PMIC_RG_VIO28_MODE_CTRL_ADDR,
	 MT6328_PMIC_RG_VIO28_MODE_CTRL_MASK, MT6328_PMIC_RG_VIO28_MODE_CTRL_SHIFT},
	{PMIC_RG_VIO28_ON_CTRL, MT6328_PMIC_RG_VIO28_ON_CTRL_ADDR,
	 MT6328_PMIC_RG_VIO28_ON_CTRL_MASK, MT6328_PMIC_RG_VIO28_ON_CTRL_SHIFT},
	{PMIC_RG_VIO28_SRCLK_MODE_SEL, MT6328_PMIC_RG_VIO28_SRCLK_MODE_SEL_ADDR,
	 MT6328_PMIC_RG_VIO28_SRCLK_MODE_SEL_MASK, MT6328_PMIC_RG_VIO28_SRCLK_MODE_SEL_SHIFT},
	{PMIC_QI_VIO28_MODE, MT6328_PMIC_QI_VIO28_MODE_ADDR, MT6328_PMIC_QI_VIO28_MODE_MASK,
	 MT6328_PMIC_QI_VIO28_MODE_SHIFT},
	{PMIC_RG_VIO28_STBTD, MT6328_PMIC_RG_VIO28_STBTD_ADDR, MT6328_PMIC_RG_VIO28_STBTD_MASK,
	 MT6328_PMIC_RG_VIO28_STBTD_SHIFT},
	{PMIC_RG_VIO28_OCFB_EN, MT6328_PMIC_RG_VIO28_OCFB_EN_ADDR,
	 MT6328_PMIC_RG_VIO28_OCFB_EN_MASK, MT6328_PMIC_RG_VIO28_OCFB_EN_SHIFT},
	{PMIC_QI_VIO28_OCFB_EN, MT6328_PMIC_QI_VIO28_OCFB_EN_ADDR,
	 MT6328_PMIC_QI_VIO28_OCFB_EN_MASK, MT6328_PMIC_QI_VIO28_OCFB_EN_SHIFT},
	{PMIC_RG_VIO28_SRCLK_EN_SEL, MT6328_PMIC_RG_VIO28_SRCLK_EN_SEL_ADDR,
	 MT6328_PMIC_RG_VIO28_SRCLK_EN_SEL_MASK, MT6328_PMIC_RG_VIO28_SRCLK_EN_SEL_SHIFT},
	{PMIC_QI_VIO28_STB, MT6328_PMIC_QI_VIO28_STB_ADDR, MT6328_PMIC_QI_VIO28_STB_MASK,
	 MT6328_PMIC_QI_VIO28_STB_SHIFT},
	{PMIC_QI_VIO28_EN, MT6328_PMIC_QI_VIO28_EN_ADDR, MT6328_PMIC_QI_VIO28_EN_MASK,
	 MT6328_PMIC_QI_VIO28_EN_SHIFT},
	{PMIC_RG_VCAMAF_MODE_SET, MT6328_PMIC_RG_VCAMAF_MODE_SET_ADDR,
	 MT6328_PMIC_RG_VCAMAF_MODE_SET_MASK, MT6328_PMIC_RG_VCAMAF_MODE_SET_SHIFT},
	{PMIC_RG_VCAMAF_EN, MT6328_PMIC_RG_VCAMAF_EN_ADDR, MT6328_PMIC_RG_VCAMAF_EN_MASK,
	 MT6328_PMIC_RG_VCAMAF_EN_SHIFT},
	{PMIC_RG_VCAMAF_MODE_CTRL, MT6328_PMIC_RG_VCAMAF_MODE_CTRL_ADDR,
	 MT6328_PMIC_RG_VCAMAF_MODE_CTRL_MASK, MT6328_PMIC_RG_VCAMAF_MODE_CTRL_SHIFT},
	{PMIC_RG_VCAMAF_SRCLK_MODE_SEL, MT6328_PMIC_RG_VCAMAF_SRCLK_MODE_SEL_ADDR,
	 MT6328_PMIC_RG_VCAMAF_SRCLK_MODE_SEL_MASK, MT6328_PMIC_RG_VCAMAF_SRCLK_MODE_SEL_SHIFT},
	{PMIC_QI_VCAMAF_MODE, MT6328_PMIC_QI_VCAMAF_MODE_ADDR, MT6328_PMIC_QI_VCAMAF_MODE_MASK,
	 MT6328_PMIC_QI_VCAMAF_MODE_SHIFT},
	{PMIC_RG_VCAMAF_STBTD, MT6328_PMIC_RG_VCAMAF_STBTD_ADDR, MT6328_PMIC_RG_VCAMAF_STBTD_MASK,
	 MT6328_PMIC_RG_VCAMAF_STBTD_SHIFT},
	{PMIC_RG_VCAMAF_OCFB_EN, MT6328_PMIC_RG_VCAMAF_OCFB_EN_ADDR,
	 MT6328_PMIC_RG_VCAMAF_OCFB_EN_MASK, MT6328_PMIC_RG_VCAMAF_OCFB_EN_SHIFT},
	{PMIC_QI_VCAMAF_OCFB_EN, MT6328_PMIC_QI_VCAMAF_OCFB_EN_ADDR,
	 MT6328_PMIC_QI_VCAMAF_OCFB_EN_MASK, MT6328_PMIC_QI_VCAMAF_OCFB_EN_SHIFT},
	{PMIC_QI_VCAMAF_STB, MT6328_PMIC_QI_VCAMAF_STB_ADDR, MT6328_PMIC_QI_VCAMAF_STB_MASK,
	 MT6328_PMIC_QI_VCAMAF_STB_SHIFT},
	{PMIC_QI_VCAMAF_EN, MT6328_PMIC_QI_VCAMAF_EN_ADDR, MT6328_PMIC_QI_VCAMAF_EN_MASK,
	 MT6328_PMIC_QI_VCAMAF_EN_SHIFT},
	{PMIC_RG_VGP1_MODE_SET, MT6328_PMIC_RG_VGP1_MODE_SET_ADDR,
	 MT6328_PMIC_RG_VGP1_MODE_SET_MASK, MT6328_PMIC_RG_VGP1_MODE_SET_SHIFT},
	{PMIC_RG_VGP1_EN, MT6328_PMIC_RG_VGP1_EN_ADDR, MT6328_PMIC_RG_VGP1_EN_MASK,
	 MT6328_PMIC_RG_VGP1_EN_SHIFT},
	{PMIC_RG_VGP1_MODE_CTRL, MT6328_PMIC_RG_VGP1_MODE_CTRL_ADDR,
	 MT6328_PMIC_RG_VGP1_MODE_CTRL_MASK, MT6328_PMIC_RG_VGP1_MODE_CTRL_SHIFT},
	{PMIC_RG_VGP1_ON_CTRL, MT6328_PMIC_RG_VGP1_ON_CTRL_ADDR, MT6328_PMIC_RG_VGP1_ON_CTRL_MASK,
	 MT6328_PMIC_RG_VGP1_ON_CTRL_SHIFT},
	{PMIC_RG_VGP1_SRCLK_MODE_SEL, MT6328_PMIC_RG_VGP1_SRCLK_MODE_SEL_ADDR,
	 MT6328_PMIC_RG_VGP1_SRCLK_MODE_SEL_MASK, MT6328_PMIC_RG_VGP1_SRCLK_MODE_SEL_SHIFT},
	{PMIC_QI_VGP1_MODE, MT6328_PMIC_QI_VGP1_MODE_ADDR, MT6328_PMIC_QI_VGP1_MODE_MASK,
	 MT6328_PMIC_QI_VGP1_MODE_SHIFT},
	{PMIC_RG_VGP1_STBTD, MT6328_PMIC_RG_VGP1_STBTD_ADDR, MT6328_PMIC_RG_VGP1_STBTD_MASK,
	 MT6328_PMIC_RG_VGP1_STBTD_SHIFT},
	{PMIC_RG_VGP1_OCFB_EN, MT6328_PMIC_RG_VGP1_OCFB_EN_ADDR, MT6328_PMIC_RG_VGP1_OCFB_EN_MASK,
	 MT6328_PMIC_RG_VGP1_OCFB_EN_SHIFT},
	{PMIC_QI_VGP1_OCFB_EN, MT6328_PMIC_QI_VGP1_OCFB_EN_ADDR, MT6328_PMIC_QI_VGP1_OCFB_EN_MASK,
	 MT6328_PMIC_QI_VGP1_OCFB_EN_SHIFT},
	{PMIC_RG_VGP1_SRCLK_EN_SEL, MT6328_PMIC_RG_VGP1_SRCLK_EN_SEL_ADDR,
	 MT6328_PMIC_RG_VGP1_SRCLK_EN_SEL_MASK, MT6328_PMIC_RG_VGP1_SRCLK_EN_SEL_SHIFT},
	{PMIC_QI_VGP1_STB, MT6328_PMIC_QI_VGP1_STB_ADDR, MT6328_PMIC_QI_VGP1_STB_MASK,
	 MT6328_PMIC_QI_VGP1_STB_SHIFT},
	{PMIC_QI_VGP1_EN, MT6328_PMIC_QI_VGP1_EN_ADDR, MT6328_PMIC_QI_VGP1_EN_MASK,
	 MT6328_PMIC_QI_VGP1_EN_SHIFT},
	{PMIC_RG_VGP1_FAST_TRAN_EN, MT6328_PMIC_RG_VGP1_FAST_TRAN_EN_ADDR,
	 MT6328_PMIC_RG_VGP1_FAST_TRAN_EN_MASK, MT6328_PMIC_RG_VGP1_FAST_TRAN_EN_SHIFT},
	{PMIC_RG_VGP1_SRCLK_FAST_TRAN_SEL, MT6328_PMIC_RG_VGP1_SRCLK_FAST_TRAN_SEL_ADDR,
	 MT6328_PMIC_RG_VGP1_SRCLK_FAST_TRAN_SEL_MASK,
	 MT6328_PMIC_RG_VGP1_SRCLK_FAST_TRAN_SEL_SHIFT},
	{PMIC_QI_VGP1_FAST_TRAN_EN, MT6328_PMIC_QI_VGP1_FAST_TRAN_EN_ADDR,
	 MT6328_PMIC_QI_VGP1_FAST_TRAN_EN_MASK, MT6328_PMIC_QI_VGP1_FAST_TRAN_EN_SHIFT},
	{PMIC_RG_VEFUSE_MODE_SET, MT6328_PMIC_RG_VEFUSE_MODE_SET_ADDR,
	 MT6328_PMIC_RG_VEFUSE_MODE_SET_MASK, MT6328_PMIC_RG_VEFUSE_MODE_SET_SHIFT},
	{PMIC_RG_VEFUSE_EN, MT6328_PMIC_RG_VEFUSE_EN_ADDR, MT6328_PMIC_RG_VEFUSE_EN_MASK,
	 MT6328_PMIC_RG_VEFUSE_EN_SHIFT},
	{PMIC_RG_VEFUSE_MODE_CTRL, MT6328_PMIC_RG_VEFUSE_MODE_CTRL_ADDR,
	 MT6328_PMIC_RG_VEFUSE_MODE_CTRL_MASK, MT6328_PMIC_RG_VEFUSE_MODE_CTRL_SHIFT},
	{PMIC_RG_VEFUSE_SRCLK_MODE_SEL, MT6328_PMIC_RG_VEFUSE_SRCLK_MODE_SEL_ADDR,
	 MT6328_PMIC_RG_VEFUSE_SRCLK_MODE_SEL_MASK, MT6328_PMIC_RG_VEFUSE_SRCLK_MODE_SEL_SHIFT},
	{PMIC_QI_VEFUSE_MODE, MT6328_PMIC_QI_VEFUSE_MODE_ADDR, MT6328_PMIC_QI_VEFUSE_MODE_MASK,
	 MT6328_PMIC_QI_VEFUSE_MODE_SHIFT},
	{PMIC_RG_VEFUSE_STBTD, MT6328_PMIC_RG_VEFUSE_STBTD_ADDR, MT6328_PMIC_RG_VEFUSE_STBTD_MASK,
	 MT6328_PMIC_RG_VEFUSE_STBTD_SHIFT},
	{PMIC_RG_VEFUSE_OCFB_EN, MT6328_PMIC_RG_VEFUSE_OCFB_EN_ADDR,
	 MT6328_PMIC_RG_VEFUSE_OCFB_EN_MASK, MT6328_PMIC_RG_VEFUSE_OCFB_EN_SHIFT},
	{PMIC_QI_VEFUSE_OCFB_EN, MT6328_PMIC_QI_VEFUSE_OCFB_EN_ADDR,
	 MT6328_PMIC_QI_VEFUSE_OCFB_EN_MASK, MT6328_PMIC_QI_VEFUSE_OCFB_EN_SHIFT},
	{PMIC_QI_VEFUSE_STB, MT6328_PMIC_QI_VEFUSE_STB_ADDR, MT6328_PMIC_QI_VEFUSE_STB_MASK,
	 MT6328_PMIC_QI_VEFUSE_STB_SHIFT},
	{PMIC_QI_VEFUSE_EN, MT6328_PMIC_QI_VEFUSE_EN_ADDR, MT6328_PMIC_QI_VEFUSE_EN_MASK,
	 MT6328_PMIC_QI_VEFUSE_EN_SHIFT},
	{PMIC_RG_VSIM1_MODE_SET, MT6328_PMIC_RG_VSIM1_MODE_SET_ADDR,
	 MT6328_PMIC_RG_VSIM1_MODE_SET_MASK, MT6328_PMIC_RG_VSIM1_MODE_SET_SHIFT},
	{PMIC_RG_VSIM1_EN, MT6328_PMIC_RG_VSIM1_EN_ADDR, MT6328_PMIC_RG_VSIM1_EN_MASK,
	 MT6328_PMIC_RG_VSIM1_EN_SHIFT},
	{PMIC_RG_VSIM1_MODE_CTRL, MT6328_PMIC_RG_VSIM1_MODE_CTRL_ADDR,
	 MT6328_PMIC_RG_VSIM1_MODE_CTRL_MASK, MT6328_PMIC_RG_VSIM1_MODE_CTRL_SHIFT},
	{PMIC_RG_VSIM1_ON_CTRL, MT6328_PMIC_RG_VSIM1_ON_CTRL_ADDR,
	 MT6328_PMIC_RG_VSIM1_ON_CTRL_MASK, MT6328_PMIC_RG_VSIM1_ON_CTRL_SHIFT},
	{PMIC_RG_VSIM1_SRCLK_MODE_SEL, MT6328_PMIC_RG_VSIM1_SRCLK_MODE_SEL_ADDR,
	 MT6328_PMIC_RG_VSIM1_SRCLK_MODE_SEL_MASK, MT6328_PMIC_RG_VSIM1_SRCLK_MODE_SEL_SHIFT},
	{PMIC_QI_VSIM1_MODE, MT6328_PMIC_QI_VSIM1_MODE_ADDR, MT6328_PMIC_QI_VSIM1_MODE_MASK,
	 MT6328_PMIC_QI_VSIM1_MODE_SHIFT},
	{PMIC_RG_VSIM1_STBTD, MT6328_PMIC_RG_VSIM1_STBTD_ADDR, MT6328_PMIC_RG_VSIM1_STBTD_MASK,
	 MT6328_PMIC_RG_VSIM1_STBTD_SHIFT},
	{PMIC_RG_VSIM1_OCFB_EN, MT6328_PMIC_RG_VSIM1_OCFB_EN_ADDR,
	 MT6328_PMIC_RG_VSIM1_OCFB_EN_MASK, MT6328_PMIC_RG_VSIM1_OCFB_EN_SHIFT},
	{PMIC_QI_VSIM1_OCFB_EN, MT6328_PMIC_QI_VSIM1_OCFB_EN_ADDR,
	 MT6328_PMIC_QI_VSIM1_OCFB_EN_MASK, MT6328_PMIC_QI_VSIM1_OCFB_EN_SHIFT},
	{PMIC_RG_VSIM1_SRCLK_EN_SEL, MT6328_PMIC_RG_VSIM1_SRCLK_EN_SEL_ADDR,
	 MT6328_PMIC_RG_VSIM1_SRCLK_EN_SEL_MASK, MT6328_PMIC_RG_VSIM1_SRCLK_EN_SEL_SHIFT},
	{PMIC_QI_VSIM1_STB, MT6328_PMIC_QI_VSIM1_STB_ADDR, MT6328_PMIC_QI_VSIM1_STB_MASK,
	 MT6328_PMIC_QI_VSIM1_STB_SHIFT},
	{PMIC_QI_VSIM1_EN, MT6328_PMIC_QI_VSIM1_EN_ADDR, MT6328_PMIC_QI_VSIM1_EN_MASK,
	 MT6328_PMIC_QI_VSIM1_EN_SHIFT},
	{PMIC_RG_VSIM2_MODE_SET, MT6328_PMIC_RG_VSIM2_MODE_SET_ADDR,
	 MT6328_PMIC_RG_VSIM2_MODE_SET_MASK, MT6328_PMIC_RG_VSIM2_MODE_SET_SHIFT},
	{PMIC_RG_VSIM2_EN, MT6328_PMIC_RG_VSIM2_EN_ADDR, MT6328_PMIC_RG_VSIM2_EN_MASK,
	 MT6328_PMIC_RG_VSIM2_EN_SHIFT},
	{PMIC_RG_VSIM2_MODE_CTRL, MT6328_PMIC_RG_VSIM2_MODE_CTRL_ADDR,
	 MT6328_PMIC_RG_VSIM2_MODE_CTRL_MASK, MT6328_PMIC_RG_VSIM2_MODE_CTRL_SHIFT},
	{PMIC_RG_VSIM2_ON_CTRL, MT6328_PMIC_RG_VSIM2_ON_CTRL_ADDR,
	 MT6328_PMIC_RG_VSIM2_ON_CTRL_MASK, MT6328_PMIC_RG_VSIM2_ON_CTRL_SHIFT},
	{PMIC_RG_VSIM2_SRCLK_MODE_SEL, MT6328_PMIC_RG_VSIM2_SRCLK_MODE_SEL_ADDR,
	 MT6328_PMIC_RG_VSIM2_SRCLK_MODE_SEL_MASK, MT6328_PMIC_RG_VSIM2_SRCLK_MODE_SEL_SHIFT},
	{PMIC_QI_VSIM2_MODE, MT6328_PMIC_QI_VSIM2_MODE_ADDR, MT6328_PMIC_QI_VSIM2_MODE_MASK,
	 MT6328_PMIC_QI_VSIM2_MODE_SHIFT},
	{PMIC_RG_VSIM2_STBTD, MT6328_PMIC_RG_VSIM2_STBTD_ADDR, MT6328_PMIC_RG_VSIM2_STBTD_MASK,
	 MT6328_PMIC_RG_VSIM2_STBTD_SHIFT},
	{PMIC_RG_VSIM2_OCFB_EN, MT6328_PMIC_RG_VSIM2_OCFB_EN_ADDR,
	 MT6328_PMIC_RG_VSIM2_OCFB_EN_MASK, MT6328_PMIC_RG_VSIM2_OCFB_EN_SHIFT},
	{PMIC_QI_VSIM2_OCFB_EN, MT6328_PMIC_QI_VSIM2_OCFB_EN_ADDR,
	 MT6328_PMIC_QI_VSIM2_OCFB_EN_MASK, MT6328_PMIC_QI_VSIM2_OCFB_EN_SHIFT},
	{PMIC_RG_VSIM2_SRCLK_EN_SEL, MT6328_PMIC_RG_VSIM2_SRCLK_EN_SEL_ADDR,
	 MT6328_PMIC_RG_VSIM2_SRCLK_EN_SEL_MASK, MT6328_PMIC_RG_VSIM2_SRCLK_EN_SEL_SHIFT},
	{PMIC_QI_VSIM2_STB, MT6328_PMIC_QI_VSIM2_STB_ADDR, MT6328_PMIC_QI_VSIM2_STB_MASK,
	 MT6328_PMIC_QI_VSIM2_STB_SHIFT},
	{PMIC_QI_VSIM2_EN, MT6328_PMIC_QI_VSIM2_EN_ADDR, MT6328_PMIC_QI_VSIM2_EN_MASK,
	 MT6328_PMIC_QI_VSIM2_EN_SHIFT},
	{PMIC_RG_VIO18_MODE_SET, MT6328_PMIC_RG_VIO18_MODE_SET_ADDR,
	 MT6328_PMIC_RG_VIO18_MODE_SET_MASK, MT6328_PMIC_RG_VIO18_MODE_SET_SHIFT},
	{PMIC_RG_VIO18_EN, MT6328_PMIC_RG_VIO18_EN_ADDR, MT6328_PMIC_RG_VIO18_EN_MASK,
	 MT6328_PMIC_RG_VIO18_EN_SHIFT},
	{PMIC_RG_VIO18_MODE_CTRL, MT6328_PMIC_RG_VIO18_MODE_CTRL_ADDR,
	 MT6328_PMIC_RG_VIO18_MODE_CTRL_MASK, MT6328_PMIC_RG_VIO18_MODE_CTRL_SHIFT},
	{PMIC_RG_VIO18_ON_CTRL, MT6328_PMIC_RG_VIO18_ON_CTRL_ADDR,
	 MT6328_PMIC_RG_VIO18_ON_CTRL_MASK, MT6328_PMIC_RG_VIO18_ON_CTRL_SHIFT},
	{PMIC_RG_VIO18_SRCLK_MODE_SEL, MT6328_PMIC_RG_VIO18_SRCLK_MODE_SEL_ADDR,
	 MT6328_PMIC_RG_VIO18_SRCLK_MODE_SEL_MASK, MT6328_PMIC_RG_VIO18_SRCLK_MODE_SEL_SHIFT},
	{PMIC_QI_VIO18_MODE, MT6328_PMIC_QI_VIO18_MODE_ADDR, MT6328_PMIC_QI_VIO18_MODE_MASK,
	 MT6328_PMIC_QI_VIO18_MODE_SHIFT},
	{PMIC_RG_VIO18_STBTD, MT6328_PMIC_RG_VIO18_STBTD_ADDR, MT6328_PMIC_RG_VIO18_STBTD_MASK,
	 MT6328_PMIC_RG_VIO18_STBTD_SHIFT},
	{PMIC_RG_VIO18_OCFB_EN, MT6328_PMIC_RG_VIO18_OCFB_EN_ADDR,
	 MT6328_PMIC_RG_VIO18_OCFB_EN_MASK, MT6328_PMIC_RG_VIO18_OCFB_EN_SHIFT},
	{PMIC_QI_VIO18_OCFB_EN, MT6328_PMIC_QI_VIO18_OCFB_EN_ADDR,
	 MT6328_PMIC_QI_VIO18_OCFB_EN_MASK, MT6328_PMIC_QI_VIO18_OCFB_EN_SHIFT},
	{PMIC_RG_VIO18_SRCLK_EN_SEL, MT6328_PMIC_RG_VIO18_SRCLK_EN_SEL_ADDR,
	 MT6328_PMIC_RG_VIO18_SRCLK_EN_SEL_MASK, MT6328_PMIC_RG_VIO18_SRCLK_EN_SEL_SHIFT},
	{PMIC_QI_VIO18_STB, MT6328_PMIC_QI_VIO18_STB_ADDR, MT6328_PMIC_QI_VIO18_STB_MASK,
	 MT6328_PMIC_QI_VIO18_STB_SHIFT},
	{PMIC_QI_VIO18_EN, MT6328_PMIC_QI_VIO18_EN_ADDR, MT6328_PMIC_QI_VIO18_EN_MASK,
	 MT6328_PMIC_QI_VIO18_EN_SHIFT},
	{PMIC_RG_VIBR_MODE_SET, MT6328_PMIC_RG_VIBR_MODE_SET_ADDR,
	 MT6328_PMIC_RG_VIBR_MODE_SET_MASK, MT6328_PMIC_RG_VIBR_MODE_SET_SHIFT},
	{PMIC_RG_VIBR_EN, MT6328_PMIC_RG_VIBR_EN_ADDR, MT6328_PMIC_RG_VIBR_EN_MASK,
	 MT6328_PMIC_RG_VIBR_EN_SHIFT},
	{PMIC_RG_VIBR_MODE_CTRL, MT6328_PMIC_RG_VIBR_MODE_CTRL_ADDR,
	 MT6328_PMIC_RG_VIBR_MODE_CTRL_MASK, MT6328_PMIC_RG_VIBR_MODE_CTRL_SHIFT},
	{PMIC_RG_VIBR_SRCLK_MODE_SEL, MT6328_PMIC_RG_VIBR_SRCLK_MODE_SEL_ADDR,
	 MT6328_PMIC_RG_VIBR_SRCLK_MODE_SEL_MASK, MT6328_PMIC_RG_VIBR_SRCLK_MODE_SEL_SHIFT},
	{PMIC_RG_VIBR_THER_SHEN_EN, MT6328_PMIC_RG_VIBR_THER_SHEN_EN_ADDR,
	 MT6328_PMIC_RG_VIBR_THER_SHEN_EN_MASK, MT6328_PMIC_RG_VIBR_THER_SHEN_EN_SHIFT},
	{PMIC_QI_VIBR_MODE, MT6328_PMIC_QI_VIBR_MODE_ADDR, MT6328_PMIC_QI_VIBR_MODE_MASK,
	 MT6328_PMIC_QI_VIBR_MODE_SHIFT},
	{PMIC_RG_VIBR_STBTD, MT6328_PMIC_RG_VIBR_STBTD_ADDR, MT6328_PMIC_RG_VIBR_STBTD_MASK,
	 MT6328_PMIC_RG_VIBR_STBTD_SHIFT},
	{PMIC_RG_VIBR_OCFB_EN, MT6328_PMIC_RG_VIBR_OCFB_EN_ADDR, MT6328_PMIC_RG_VIBR_OCFB_EN_MASK,
	 MT6328_PMIC_RG_VIBR_OCFB_EN_SHIFT},
	{PMIC_QI_VIBR_OCFB_EN, MT6328_PMIC_QI_VIBR_OCFB_EN_ADDR, MT6328_PMIC_QI_VIBR_OCFB_EN_MASK,
	 MT6328_PMIC_QI_VIBR_OCFB_EN_SHIFT},
	{PMIC_QI_VIBR_STB, MT6328_PMIC_QI_VIBR_STB_ADDR, MT6328_PMIC_QI_VIBR_STB_MASK,
	 MT6328_PMIC_QI_VIBR_STB_SHIFT},
	{PMIC_QI_VIBR_EN, MT6328_PMIC_QI_VIBR_EN_ADDR, MT6328_PMIC_QI_VIBR_EN_MASK,
	 MT6328_PMIC_QI_VIBR_EN_SHIFT},
	{PMIC_RG_VCN18_MODE_SET, MT6328_PMIC_RG_VCN18_MODE_SET_ADDR,
	 MT6328_PMIC_RG_VCN18_MODE_SET_MASK, MT6328_PMIC_RG_VCN18_MODE_SET_SHIFT},
	{PMIC_RG_VCN18_EN, MT6328_PMIC_RG_VCN18_EN_ADDR, MT6328_PMIC_RG_VCN18_EN_MASK,
	 MT6328_PMIC_RG_VCN18_EN_SHIFT},
	{PMIC_RG_VCN18_MODE_CTRL, MT6328_PMIC_RG_VCN18_MODE_CTRL_ADDR,
	 MT6328_PMIC_RG_VCN18_MODE_CTRL_MASK, MT6328_PMIC_RG_VCN18_MODE_CTRL_SHIFT},
	{PMIC_RG_VCN18_ON_CTRL, MT6328_PMIC_RG_VCN18_ON_CTRL_ADDR,
	 MT6328_PMIC_RG_VCN18_ON_CTRL_MASK, MT6328_PMIC_RG_VCN18_ON_CTRL_SHIFT},
	{PMIC_RG_VCN18_SRCLK_MODE_SEL, MT6328_PMIC_RG_VCN18_SRCLK_MODE_SEL_ADDR,
	 MT6328_PMIC_RG_VCN18_SRCLK_MODE_SEL_MASK, MT6328_PMIC_RG_VCN18_SRCLK_MODE_SEL_SHIFT},
	{PMIC_QI_VCN18_MODE, MT6328_PMIC_QI_VCN18_MODE_ADDR, MT6328_PMIC_QI_VCN18_MODE_MASK,
	 MT6328_PMIC_QI_VCN18_MODE_SHIFT},
	{PMIC_RG_VCN18_STBTD, MT6328_PMIC_RG_VCN18_STBTD_ADDR, MT6328_PMIC_RG_VCN18_STBTD_MASK,
	 MT6328_PMIC_RG_VCN18_STBTD_SHIFT},
	{PMIC_RG_VCN18_OCFB_EN, MT6328_PMIC_RG_VCN18_OCFB_EN_ADDR,
	 MT6328_PMIC_RG_VCN18_OCFB_EN_MASK, MT6328_PMIC_RG_VCN18_OCFB_EN_SHIFT},
	{PMIC_QI_VCN18_OCFB_EN, MT6328_PMIC_QI_VCN18_OCFB_EN_ADDR,
	 MT6328_PMIC_QI_VCN18_OCFB_EN_MASK, MT6328_PMIC_QI_VCN18_OCFB_EN_SHIFT},
	{PMIC_RG_VCN18_SRCLK_EN_SEL, MT6328_PMIC_RG_VCN18_SRCLK_EN_SEL_ADDR,
	 MT6328_PMIC_RG_VCN18_SRCLK_EN_SEL_MASK, MT6328_PMIC_RG_VCN18_SRCLK_EN_SEL_SHIFT},
	{PMIC_QI_VCN18_STB, MT6328_PMIC_QI_VCN18_STB_ADDR, MT6328_PMIC_QI_VCN18_STB_MASK,
	 MT6328_PMIC_QI_VCN18_STB_SHIFT},
	{PMIC_QI_VCN18_EN, MT6328_PMIC_QI_VCN18_EN_ADDR, MT6328_PMIC_QI_VCN18_EN_MASK,
	 MT6328_PMIC_QI_VCN18_EN_SHIFT},
	{PMIC_RG_VCAMD_MODE_SET, MT6328_PMIC_RG_VCAMD_MODE_SET_ADDR,
	 MT6328_PMIC_RG_VCAMD_MODE_SET_MASK, MT6328_PMIC_RG_VCAMD_MODE_SET_SHIFT},
	{PMIC_RG_VCAMD_EN, MT6328_PMIC_RG_VCAMD_EN_ADDR, MT6328_PMIC_RG_VCAMD_EN_MASK,
	 MT6328_PMIC_RG_VCAMD_EN_SHIFT},
	{PMIC_RG_VCAMD_MODE_CTRL, MT6328_PMIC_RG_VCAMD_MODE_CTRL_ADDR,
	 MT6328_PMIC_RG_VCAMD_MODE_CTRL_MASK, MT6328_PMIC_RG_VCAMD_MODE_CTRL_SHIFT},
	{PMIC_RG_VCAMD_SRCLK_MODE_SEL, MT6328_PMIC_RG_VCAMD_SRCLK_MODE_SEL_ADDR,
	 MT6328_PMIC_RG_VCAMD_SRCLK_MODE_SEL_MASK, MT6328_PMIC_RG_VCAMD_SRCLK_MODE_SEL_SHIFT},
	{PMIC_QI_VCAMD_MODE, MT6328_PMIC_QI_VCAMD_MODE_ADDR, MT6328_PMIC_QI_VCAMD_MODE_MASK,
	 MT6328_PMIC_QI_VCAMD_MODE_SHIFT},
	{PMIC_RG_VCAMD_STBTD, MT6328_PMIC_RG_VCAMD_STBTD_ADDR, MT6328_PMIC_RG_VCAMD_STBTD_MASK,
	 MT6328_PMIC_RG_VCAMD_STBTD_SHIFT},
	{PMIC_RG_VCAMD_OCFB_EN, MT6328_PMIC_RG_VCAMD_OCFB_EN_ADDR,
	 MT6328_PMIC_RG_VCAMD_OCFB_EN_MASK, MT6328_PMIC_RG_VCAMD_OCFB_EN_SHIFT},
	{PMIC_QI_VCAMD_OCFB_EN, MT6328_PMIC_QI_VCAMD_OCFB_EN_ADDR,
	 MT6328_PMIC_QI_VCAMD_OCFB_EN_MASK, MT6328_PMIC_QI_VCAMD_OCFB_EN_SHIFT},
	{PMIC_QI_VCAMD_STB, MT6328_PMIC_QI_VCAMD_STB_ADDR, MT6328_PMIC_QI_VCAMD_STB_MASK,
	 MT6328_PMIC_QI_VCAMD_STB_SHIFT},
	{PMIC_QI_VCAMD_EN, MT6328_PMIC_QI_VCAMD_EN_ADDR, MT6328_PMIC_QI_VCAMD_EN_MASK,
	 MT6328_PMIC_QI_VCAMD_EN_SHIFT},
	{PMIC_RG_VCAMIO_MODE_SET, MT6328_PMIC_RG_VCAMIO_MODE_SET_ADDR,
	 MT6328_PMIC_RG_VCAMIO_MODE_SET_MASK, MT6328_PMIC_RG_VCAMIO_MODE_SET_SHIFT},
	{PMIC_RG_VCAMIO_EN, MT6328_PMIC_RG_VCAMIO_EN_ADDR, MT6328_PMIC_RG_VCAMIO_EN_MASK,
	 MT6328_PMIC_RG_VCAMIO_EN_SHIFT},
	{PMIC_RG_VCAMIO_MODE_CTRL, MT6328_PMIC_RG_VCAMIO_MODE_CTRL_ADDR,
	 MT6328_PMIC_RG_VCAMIO_MODE_CTRL_MASK, MT6328_PMIC_RG_VCAMIO_MODE_CTRL_SHIFT},
	{PMIC_RG_VCAMIO_SRCLK_MODE_SEL, MT6328_PMIC_RG_VCAMIO_SRCLK_MODE_SEL_ADDR,
	 MT6328_PMIC_RG_VCAMIO_SRCLK_MODE_SEL_MASK, MT6328_PMIC_RG_VCAMIO_SRCLK_MODE_SEL_SHIFT},
	{PMIC_QI_VCAMIO_MODE, MT6328_PMIC_QI_VCAMIO_MODE_ADDR, MT6328_PMIC_QI_VCAMIO_MODE_MASK,
	 MT6328_PMIC_QI_VCAMIO_MODE_SHIFT},
	{PMIC_RG_VCAMIO_STBTD, MT6328_PMIC_RG_VCAMIO_STBTD_ADDR, MT6328_PMIC_RG_VCAMIO_STBTD_MASK,
	 MT6328_PMIC_RG_VCAMIO_STBTD_SHIFT},
	{PMIC_RG_VCAMIO_OCFB_EN, MT6328_PMIC_RG_VCAMIO_OCFB_EN_ADDR,
	 MT6328_PMIC_RG_VCAMIO_OCFB_EN_MASK, MT6328_PMIC_RG_VCAMIO_OCFB_EN_SHIFT},
	{PMIC_QI_VCAMIO_OCFB_EN, MT6328_PMIC_QI_VCAMIO_OCFB_EN_ADDR,
	 MT6328_PMIC_QI_VCAMIO_OCFB_EN_MASK, MT6328_PMIC_QI_VCAMIO_OCFB_EN_SHIFT},
	{PMIC_QI_VCAMIO_STB, MT6328_PMIC_QI_VCAMIO_STB_ADDR, MT6328_PMIC_QI_VCAMIO_STB_MASK,
	 MT6328_PMIC_QI_VCAMIO_STB_SHIFT},
	{PMIC_QI_VCAMIO_EN, MT6328_PMIC_QI_VCAMIO_EN_ADDR, MT6328_PMIC_QI_VCAMIO_EN_MASK,
	 MT6328_PMIC_QI_VCAMIO_EN_SHIFT},
	{PMIC_RG_VSRAM_MODE_SET, MT6328_PMIC_RG_VSRAM_MODE_SET_ADDR,
	 MT6328_PMIC_RG_VSRAM_MODE_SET_MASK, MT6328_PMIC_RG_VSRAM_MODE_SET_SHIFT},
	{PMIC_RG_VSRAM_EN, MT6328_PMIC_RG_VSRAM_EN_ADDR, MT6328_PMIC_RG_VSRAM_EN_MASK,
	 MT6328_PMIC_RG_VSRAM_EN_SHIFT},
	{PMIC_RG_VSRAM_MODE_CTRL, MT6328_PMIC_RG_VSRAM_MODE_CTRL_ADDR,
	 MT6328_PMIC_RG_VSRAM_MODE_CTRL_MASK, MT6328_PMIC_RG_VSRAM_MODE_CTRL_SHIFT},
	{PMIC_RG_VSRAM_ON_CTRL, MT6328_PMIC_RG_VSRAM_ON_CTRL_ADDR,
	 MT6328_PMIC_RG_VSRAM_ON_CTRL_MASK, MT6328_PMIC_RG_VSRAM_ON_CTRL_SHIFT},
	{PMIC_RG_VSRAM_SRCLK_MODE_SEL, MT6328_PMIC_RG_VSRAM_SRCLK_MODE_SEL_ADDR,
	 MT6328_PMIC_RG_VSRAM_SRCLK_MODE_SEL_MASK, MT6328_PMIC_RG_VSRAM_SRCLK_MODE_SEL_SHIFT},
	{PMIC_QI_VSRAM_MODE, MT6328_PMIC_QI_VSRAM_MODE_ADDR, MT6328_PMIC_QI_VSRAM_MODE_MASK,
	 MT6328_PMIC_QI_VSRAM_MODE_SHIFT},
	{PMIC_RG_VSRAM_STBTD, MT6328_PMIC_RG_VSRAM_STBTD_ADDR, MT6328_PMIC_RG_VSRAM_STBTD_MASK,
	 MT6328_PMIC_RG_VSRAM_STBTD_SHIFT},
	{PMIC_RG_VSRAM_OCFB_EN, MT6328_PMIC_RG_VSRAM_OCFB_EN_ADDR,
	 MT6328_PMIC_RG_VSRAM_OCFB_EN_MASK, MT6328_PMIC_RG_VSRAM_OCFB_EN_SHIFT},
	{PMIC_QI_VSRAM_OCFB_EN, MT6328_PMIC_QI_VSRAM_OCFB_EN_ADDR,
	 MT6328_PMIC_QI_VSRAM_OCFB_EN_MASK, MT6328_PMIC_QI_VSRAM_OCFB_EN_SHIFT},
	{PMIC_RG_VSRAM_SRCLK_EN_SEL, MT6328_PMIC_RG_VSRAM_SRCLK_EN_SEL_ADDR,
	 MT6328_PMIC_RG_VSRAM_SRCLK_EN_SEL_MASK, MT6328_PMIC_RG_VSRAM_SRCLK_EN_SEL_SHIFT},
	{PMIC_QI_VSRAM_STB, MT6328_PMIC_QI_VSRAM_STB_ADDR, MT6328_PMIC_QI_VSRAM_STB_MASK,
	 MT6328_PMIC_QI_VSRAM_STB_SHIFT},
	{PMIC_QI_VSRAM_EN, MT6328_PMIC_QI_VSRAM_EN_ADDR, MT6328_PMIC_QI_VSRAM_EN_MASK,
	 MT6328_PMIC_QI_VSRAM_EN_SHIFT},
	{PMIC_RG_VSRAM_FAST_TRAN_EN, MT6328_PMIC_RG_VSRAM_FAST_TRAN_EN_ADDR,
	 MT6328_PMIC_RG_VSRAM_FAST_TRAN_EN_MASK, MT6328_PMIC_RG_VSRAM_FAST_TRAN_EN_SHIFT},
	{PMIC_RG_VSRAM_SRCLK_FAST_TRAN_SEL, MT6328_PMIC_RG_VSRAM_SRCLK_FAST_TRAN_SEL_ADDR,
	 MT6328_PMIC_RG_VSRAM_SRCLK_FAST_TRAN_SEL_MASK,
	 MT6328_PMIC_RG_VSRAM_SRCLK_FAST_TRAN_SEL_SHIFT},
	{PMIC_QI_VSRAM_FAST_TRAN_EN, MT6328_PMIC_QI_VSRAM_FAST_TRAN_EN_ADDR,
	 MT6328_PMIC_QI_VSRAM_FAST_TRAN_EN_MASK, MT6328_PMIC_QI_VSRAM_FAST_TRAN_EN_SHIFT},
	{PMIC_RG_TREF_EN, MT6328_PMIC_RG_TREF_EN_ADDR, MT6328_PMIC_RG_TREF_EN_MASK,
	 MT6328_PMIC_RG_TREF_EN_SHIFT},
	{PMIC_RG_TREF_ON_CTRL, MT6328_PMIC_RG_TREF_ON_CTRL_ADDR, MT6328_PMIC_RG_TREF_ON_CTRL_MASK,
	 MT6328_PMIC_RG_TREF_ON_CTRL_SHIFT},
	{PMIC_RG_TREF_STBTD, MT6328_PMIC_RG_TREF_STBTD_ADDR, MT6328_PMIC_RG_TREF_STBTD_MASK,
	 MT6328_PMIC_RG_TREF_STBTD_SHIFT},
	{PMIC_RG_TREF_SRCLK_EN_SEL, MT6328_PMIC_RG_TREF_SRCLK_EN_SEL_ADDR,
	 MT6328_PMIC_RG_TREF_SRCLK_EN_SEL_MASK, MT6328_PMIC_RG_TREF_SRCLK_EN_SEL_SHIFT},
	{PMIC_QI_TREF_STB, MT6328_PMIC_QI_TREF_STB_ADDR, MT6328_PMIC_QI_TREF_STB_MASK,
	 MT6328_PMIC_QI_TREF_STB_SHIFT},
	{PMIC_QI_TREF_EN, MT6328_PMIC_QI_TREF_EN_ADDR, MT6328_PMIC_QI_TREF_EN_MASK,
	 MT6328_PMIC_QI_TREF_EN_SHIFT},
	{PMIC_RG_VM_MODE_SET, MT6328_PMIC_RG_VM_MODE_SET_ADDR, MT6328_PMIC_RG_VM_MODE_SET_MASK,
	 MT6328_PMIC_RG_VM_MODE_SET_SHIFT},
	{PMIC_RG_VM_EN, MT6328_PMIC_RG_VM_EN_ADDR, MT6328_PMIC_RG_VM_EN_MASK,
	 MT6328_PMIC_RG_VM_EN_SHIFT},
	{PMIC_RG_VM_MODE_CTRL, MT6328_PMIC_RG_VM_MODE_CTRL_ADDR, MT6328_PMIC_RG_VM_MODE_CTRL_MASK,
	 MT6328_PMIC_RG_VM_MODE_CTRL_SHIFT},
	{PMIC_RG_VM_ON_CTRL, MT6328_PMIC_RG_VM_ON_CTRL_ADDR, MT6328_PMIC_RG_VM_ON_CTRL_MASK,
	 MT6328_PMIC_RG_VM_ON_CTRL_SHIFT},
	{PMIC_RG_VM_SRCLK_MODE_SEL, MT6328_PMIC_RG_VM_SRCLK_MODE_SEL_ADDR,
	 MT6328_PMIC_RG_VM_SRCLK_MODE_SEL_MASK, MT6328_PMIC_RG_VM_SRCLK_MODE_SEL_SHIFT},
	{PMIC_QI_VM_MODE, MT6328_PMIC_QI_VM_MODE_ADDR, MT6328_PMIC_QI_VM_MODE_MASK,
	 MT6328_PMIC_QI_VM_MODE_SHIFT},
	{PMIC_RG_VM_STBTD, MT6328_PMIC_RG_VM_STBTD_ADDR, MT6328_PMIC_RG_VM_STBTD_MASK,
	 MT6328_PMIC_RG_VM_STBTD_SHIFT},
	{PMIC_RG_VM_OCFB_EN, MT6328_PMIC_RG_VM_OCFB_EN_ADDR, MT6328_PMIC_RG_VM_OCFB_EN_MASK,
	 MT6328_PMIC_RG_VM_OCFB_EN_SHIFT},
	{PMIC_QI_VM_OCFB_EN, MT6328_PMIC_QI_VM_OCFB_EN_ADDR, MT6328_PMIC_QI_VM_OCFB_EN_MASK,
	 MT6328_PMIC_QI_VM_OCFB_EN_SHIFT},
	{PMIC_RG_VM_SRCLK_EN_SEL, MT6328_PMIC_RG_VM_SRCLK_EN_SEL_ADDR,
	 MT6328_PMIC_RG_VM_SRCLK_EN_SEL_MASK, MT6328_PMIC_RG_VM_SRCLK_EN_SEL_SHIFT},
	{PMIC_QI_VM_STB, MT6328_PMIC_QI_VM_STB_ADDR, MT6328_PMIC_QI_VM_STB_MASK,
	 MT6328_PMIC_QI_VM_STB_SHIFT},
	{PMIC_QI_VM_EN, MT6328_PMIC_QI_VM_EN_ADDR, MT6328_PMIC_QI_VM_EN_MASK,
	 MT6328_PMIC_QI_VM_EN_SHIFT},
	{PMIC_RG_VM_FAST_TRAN_EN, MT6328_PMIC_RG_VM_FAST_TRAN_EN_ADDR,
	 MT6328_PMIC_RG_VM_FAST_TRAN_EN_MASK, MT6328_PMIC_RG_VM_FAST_TRAN_EN_SHIFT},
	{PMIC_RG_VM_SRCLK_FAST_TRAN_SEL, MT6328_PMIC_RG_VM_SRCLK_FAST_TRAN_SEL_ADDR,
	 MT6328_PMIC_RG_VM_SRCLK_FAST_TRAN_SEL_MASK, MT6328_PMIC_RG_VM_SRCLK_FAST_TRAN_SEL_SHIFT},
	{PMIC_QI_VM_FAST_TRAN_EN, MT6328_PMIC_QI_VM_FAST_TRAN_EN_ADDR,
	 MT6328_PMIC_QI_VM_FAST_TRAN_EN_MASK, MT6328_PMIC_QI_VM_FAST_TRAN_EN_SHIFT},
	{PMIC_RG_VRTC_EN, MT6328_PMIC_RG_VRTC_EN_ADDR, MT6328_PMIC_RG_VRTC_EN_MASK,
	 MT6328_PMIC_RG_VRTC_EN_SHIFT},
	{PMIC_QI_VRTC_EN, MT6328_PMIC_QI_VRTC_EN_ADDR, MT6328_PMIC_QI_VRTC_EN_MASK,
	 MT6328_PMIC_QI_VRTC_EN_SHIFT},
	{PMIC_LDO_DEGTD_SEL, MT6328_PMIC_LDO_DEGTD_SEL_ADDR, MT6328_PMIC_LDO_DEGTD_SEL_MASK,
	 MT6328_PMIC_LDO_DEGTD_SEL_SHIFT},
	{PMIC_RG_VAUX18_CAL, MT6328_PMIC_RG_VAUX18_CAL_ADDR, MT6328_PMIC_RG_VAUX18_CAL_MASK,
	 MT6328_PMIC_RG_VAUX18_CAL_SHIFT},
	{PMIC_RG_VAUX18_NDIS_EN, MT6328_PMIC_RG_VAUX18_NDIS_EN_ADDR,
	 MT6328_PMIC_RG_VAUX18_NDIS_EN_MASK, MT6328_PMIC_RG_VAUX18_NDIS_EN_SHIFT},
	{PMIC_RG_VTCXO_0_CAL, MT6328_PMIC_RG_VTCXO_0_CAL_ADDR, MT6328_PMIC_RG_VTCXO_0_CAL_MASK,
	 MT6328_PMIC_RG_VTCXO_0_CAL_SHIFT},
	{PMIC_RG_VTCXO_0_NDIS_EN, MT6328_PMIC_RG_VTCXO_0_NDIS_EN_ADDR,
	 MT6328_PMIC_RG_VTCXO_0_NDIS_EN_MASK, MT6328_PMIC_RG_VTCXO_0_NDIS_EN_SHIFT},
	{PMIC_RG_VTCXO_1_CAL, MT6328_PMIC_RG_VTCXO_1_CAL_ADDR, MT6328_PMIC_RG_VTCXO_1_CAL_MASK,
	 MT6328_PMIC_RG_VTCXO_1_CAL_SHIFT},
	{PMIC_RG_VTCXO_1_NDIS_EN, MT6328_PMIC_RG_VTCXO_1_NDIS_EN_ADDR,
	 MT6328_PMIC_RG_VTCXO_1_NDIS_EN_MASK, MT6328_PMIC_RG_VTCXO_1_NDIS_EN_SHIFT},
	{PMIC_RG_VAUD28_CAL, MT6328_PMIC_RG_VAUD28_CAL_ADDR, MT6328_PMIC_RG_VAUD28_CAL_MASK,
	 MT6328_PMIC_RG_VAUD28_CAL_SHIFT},
	{PMIC_RG_VAUD28_NDIS_EN, MT6328_PMIC_RG_VAUD28_NDIS_EN_ADDR,
	 MT6328_PMIC_RG_VAUD28_NDIS_EN_MASK, MT6328_PMIC_RG_VAUD28_NDIS_EN_SHIFT},
	{PMIC_RG_VCN28_CAL, MT6328_PMIC_RG_VCN28_CAL_ADDR, MT6328_PMIC_RG_VCN28_CAL_MASK,
	 MT6328_PMIC_RG_VCN28_CAL_SHIFT},
	{PMIC_RG_VCN28_NDIS_EN, MT6328_PMIC_RG_VCN28_NDIS_EN_ADDR,
	 MT6328_PMIC_RG_VCN28_NDIS_EN_MASK, MT6328_PMIC_RG_VCN28_NDIS_EN_SHIFT},
	{PMIC_RG_VCAMA_VOSEL, MT6328_PMIC_RG_VCAMA_VOSEL_ADDR, MT6328_PMIC_RG_VCAMA_VOSEL_MASK,
	 MT6328_PMIC_RG_VCAMA_VOSEL_SHIFT},
	{PMIC_RG_VCAMA_CAL, MT6328_PMIC_RG_VCAMA_CAL_ADDR, MT6328_PMIC_RG_VCAMA_CAL_MASK,
	 MT6328_PMIC_RG_VCAMA_CAL_SHIFT},
	{PMIC_RG_VCAMA_NDIS_EN, MT6328_PMIC_RG_VCAMA_NDIS_EN_ADDR,
	 MT6328_PMIC_RG_VCAMA_NDIS_EN_MASK, MT6328_PMIC_RG_VCAMA_NDIS_EN_SHIFT},
	{PMIC_RG_VCN33_VOSEL, MT6328_PMIC_RG_VCN33_VOSEL_ADDR, MT6328_PMIC_RG_VCN33_VOSEL_MASK,
	 MT6328_PMIC_RG_VCN33_VOSEL_SHIFT},
	{PMIC_RG_VCN33_CAL, MT6328_PMIC_RG_VCN33_CAL_ADDR, MT6328_PMIC_RG_VCN33_CAL_MASK,
	 MT6328_PMIC_RG_VCN33_CAL_SHIFT},
	{PMIC_RG_VCN33_NDIS_EN, MT6328_PMIC_RG_VCN33_NDIS_EN_ADDR,
	 MT6328_PMIC_RG_VCN33_NDIS_EN_MASK, MT6328_PMIC_RG_VCN33_NDIS_EN_SHIFT},
	{PMIC_RG_VUSB33_CAL, MT6328_PMIC_RG_VUSB33_CAL_ADDR, MT6328_PMIC_RG_VUSB33_CAL_MASK,
	 MT6328_PMIC_RG_VUSB33_CAL_SHIFT},
	{PMIC_RG_VUSB33_NDIS_EN, MT6328_PMIC_RG_VUSB33_NDIS_EN_ADDR,
	 MT6328_PMIC_RG_VUSB33_NDIS_EN_MASK, MT6328_PMIC_RG_VUSB33_NDIS_EN_SHIFT},
	{PMIC_RG_VEFUSE_VOSEL, MT6328_PMIC_RG_VEFUSE_VOSEL_ADDR, MT6328_PMIC_RG_VEFUSE_VOSEL_MASK,
	 MT6328_PMIC_RG_VEFUSE_VOSEL_SHIFT},
	{PMIC_RG_VEFUSE_CAL, MT6328_PMIC_RG_VEFUSE_CAL_ADDR, MT6328_PMIC_RG_VEFUSE_CAL_MASK,
	 MT6328_PMIC_RG_VEFUSE_CAL_SHIFT},
	{PMIC_RG_VEFUSE_NDIS_EN, MT6328_PMIC_RG_VEFUSE_NDIS_EN_ADDR,
	 MT6328_PMIC_RG_VEFUSE_NDIS_EN_MASK, MT6328_PMIC_RG_VEFUSE_NDIS_EN_SHIFT},
	{PMIC_RG_VSIM1_VOSEL, MT6328_PMIC_RG_VSIM1_VOSEL_ADDR, MT6328_PMIC_RG_VSIM1_VOSEL_MASK,
	 MT6328_PMIC_RG_VSIM1_VOSEL_SHIFT},
	{PMIC_RG_VSIM1_CAL, MT6328_PMIC_RG_VSIM1_CAL_ADDR, MT6328_PMIC_RG_VSIM1_CAL_MASK,
	 MT6328_PMIC_RG_VSIM1_CAL_SHIFT},
	{PMIC_RG_VSIM1_NDIS_EN, MT6328_PMIC_RG_VSIM1_NDIS_EN_ADDR,
	 MT6328_PMIC_RG_VSIM1_NDIS_EN_MASK, MT6328_PMIC_RG_VSIM1_NDIS_EN_SHIFT},
	{PMIC_RG_VSIM2_VOSEL, MT6328_PMIC_RG_VSIM2_VOSEL_ADDR, MT6328_PMIC_RG_VSIM2_VOSEL_MASK,
	 MT6328_PMIC_RG_VSIM2_VOSEL_SHIFT},
	{PMIC_RG_VSIM2_CAL, MT6328_PMIC_RG_VSIM2_CAL_ADDR, MT6328_PMIC_RG_VSIM2_CAL_MASK,
	 MT6328_PMIC_RG_VSIM2_CAL_SHIFT},
	{PMIC_RG_VSIM2_NDIS_EN, MT6328_PMIC_RG_VSIM2_NDIS_EN_ADDR,
	 MT6328_PMIC_RG_VSIM2_NDIS_EN_MASK, MT6328_PMIC_RG_VSIM2_NDIS_EN_SHIFT},
	{PMIC_RG_VEMC_3V3_VOSEL, MT6328_PMIC_RG_VEMC_3V3_VOSEL_ADDR,
	 MT6328_PMIC_RG_VEMC_3V3_VOSEL_MASK, MT6328_PMIC_RG_VEMC_3V3_VOSEL_SHIFT},
	{PMIC_RG_VEMC_3V3_CAL, MT6328_PMIC_RG_VEMC_3V3_CAL_ADDR, MT6328_PMIC_RG_VEMC_3V3_CAL_MASK,
	 MT6328_PMIC_RG_VEMC_3V3_CAL_SHIFT},
	{PMIC_RG_VEMC_3V3_NDIS_EN, MT6328_PMIC_RG_VEMC_3V3_NDIS_EN_ADDR,
	 MT6328_PMIC_RG_VEMC_3V3_NDIS_EN_MASK, MT6328_PMIC_RG_VEMC_3V3_NDIS_EN_SHIFT},
	{PMIC_RG_VMCH_VOSEL, MT6328_PMIC_RG_VMCH_VOSEL_ADDR, MT6328_PMIC_RG_VMCH_VOSEL_MASK,
	 MT6328_PMIC_RG_VMCH_VOSEL_SHIFT},
	{PMIC_RG_VMCH_CAL, MT6328_PMIC_RG_VMCH_CAL_ADDR, MT6328_PMIC_RG_VMCH_CAL_MASK,
	 MT6328_PMIC_RG_VMCH_CAL_SHIFT},
	{PMIC_RG_VMCH_NDIS_EN, MT6328_PMIC_RG_VMCH_NDIS_EN_ADDR, MT6328_PMIC_RG_VMCH_NDIS_EN_MASK,
	 MT6328_PMIC_RG_VMCH_NDIS_EN_SHIFT},
	{PMIC_RG_ADLDO_RSV_L, MT6328_PMIC_RG_ADLDO_RSV_L_ADDR, MT6328_PMIC_RG_ADLDO_RSV_L_MASK,
	 MT6328_PMIC_RG_ADLDO_RSV_L_SHIFT},
	{PMIC_RG_ADLDO_RSV_H, MT6328_PMIC_RG_ADLDO_RSV_H_ADDR, MT6328_PMIC_RG_ADLDO_RSV_H_MASK,
	 MT6328_PMIC_RG_ADLDO_RSV_H_SHIFT},
	{PMIC_RG_VMC_VOSEL, MT6328_PMIC_RG_VMC_VOSEL_ADDR, MT6328_PMIC_RG_VMC_VOSEL_MASK,
	 MT6328_PMIC_RG_VMC_VOSEL_SHIFT},
	{PMIC_RG_VMC_CAL, MT6328_PMIC_RG_VMC_CAL_ADDR, MT6328_PMIC_RG_VMC_CAL_MASK,
	 MT6328_PMIC_RG_VMC_CAL_SHIFT},
	{PMIC_RG_VMC_NDIS_EN, MT6328_PMIC_RG_VMC_NDIS_EN_ADDR, MT6328_PMIC_RG_VMC_NDIS_EN_MASK,
	 MT6328_PMIC_RG_VMC_NDIS_EN_SHIFT},
	{PMIC_RG_VCAMAF_VOSEL, MT6328_PMIC_RG_VCAMAF_VOSEL_ADDR, MT6328_PMIC_RG_VCAMAF_VOSEL_MASK,
	 MT6328_PMIC_RG_VCAMAF_VOSEL_SHIFT},
	{PMIC_RG_VCAMAF_CAL, MT6328_PMIC_RG_VCAMAF_CAL_ADDR, MT6328_PMIC_RG_VCAMAF_CAL_MASK,
	 MT6328_PMIC_RG_VCAMAF_CAL_SHIFT},
	{PMIC_RG_VCAMAF_NDIS_EN, MT6328_PMIC_RG_VCAMAF_NDIS_EN_ADDR,
	 MT6328_PMIC_RG_VCAMAF_NDIS_EN_MASK, MT6328_PMIC_RG_VCAMAF_NDIS_EN_SHIFT},
	{PMIC_RG_VIBR_VOSEL, MT6328_PMIC_RG_VIBR_VOSEL_ADDR, MT6328_PMIC_RG_VIBR_VOSEL_MASK,
	 MT6328_PMIC_RG_VIBR_VOSEL_SHIFT},
	{PMIC_RG_VIBR_CAL, MT6328_PMIC_RG_VIBR_CAL_ADDR, MT6328_PMIC_RG_VIBR_CAL_MASK,
	 MT6328_PMIC_RG_VIBR_CAL_SHIFT},
	{PMIC_RG_VIBR_NDIS_EN, MT6328_PMIC_RG_VIBR_NDIS_EN_ADDR, MT6328_PMIC_RG_VIBR_NDIS_EN_MASK,
	 MT6328_PMIC_RG_VIBR_NDIS_EN_SHIFT},
	{PMIC_RG_VIO28_CAL, MT6328_PMIC_RG_VIO28_CAL_ADDR, MT6328_PMIC_RG_VIO28_CAL_MASK,
	 MT6328_PMIC_RG_VIO28_CAL_SHIFT},
	{PMIC_RG_VIO28_NDIS_EN, MT6328_PMIC_RG_VIO28_NDIS_EN_ADDR,
	 MT6328_PMIC_RG_VIO28_NDIS_EN_MASK, MT6328_PMIC_RG_VIO28_NDIS_EN_SHIFT},
	{PMIC_RG_VGP1_VOSEL, MT6328_PMIC_RG_VGP1_VOSEL_ADDR, MT6328_PMIC_RG_VGP1_VOSEL_MASK,
	 MT6328_PMIC_RG_VGP1_VOSEL_SHIFT},
	{PMIC_RG_VGP1_CAL, MT6328_PMIC_RG_VGP1_CAL_ADDR, MT6328_PMIC_RG_VGP1_CAL_MASK,
	 MT6328_PMIC_RG_VGP1_CAL_SHIFT},
	{PMIC_RG_VGP1_NDIS_EN, MT6328_PMIC_RG_VGP1_NDIS_EN_ADDR, MT6328_PMIC_RG_VGP1_NDIS_EN_MASK,
	 MT6328_PMIC_RG_VGP1_NDIS_EN_SHIFT},
	{PMIC_RG_DLDO_RSV_L, MT6328_PMIC_RG_DLDO_RSV_L_ADDR, MT6328_PMIC_RG_DLDO_RSV_L_MASK,
	 MT6328_PMIC_RG_DLDO_RSV_L_SHIFT},
	{PMIC_RG_DLDO_RSV_H, MT6328_PMIC_RG_DLDO_RSV_H_ADDR, MT6328_PMIC_RG_DLDO_RSV_H_MASK,
	 MT6328_PMIC_RG_DLDO_RSV_H_SHIFT},
	{PMIC_RG_VM_VOSEL, MT6328_PMIC_RG_VM_VOSEL_ADDR, MT6328_PMIC_RG_VM_VOSEL_MASK,
	 MT6328_PMIC_RG_VM_VOSEL_SHIFT},
	{PMIC_RG_VM_CAL, MT6328_PMIC_RG_VM_CAL_ADDR, MT6328_PMIC_RG_VM_CAL_MASK,
	 MT6328_PMIC_RG_VM_CAL_SHIFT},
	{PMIC_RG_VM_NDIS_EN, MT6328_PMIC_RG_VM_NDIS_EN_ADDR, MT6328_PMIC_RG_VM_NDIS_EN_MASK,
	 MT6328_PMIC_RG_VM_NDIS_EN_SHIFT},
	{PMIC_RG_VCAMD_VOSEL, MT6328_PMIC_RG_VCAMD_VOSEL_ADDR, MT6328_PMIC_RG_VCAMD_VOSEL_MASK,
	 MT6328_PMIC_RG_VCAMD_VOSEL_SHIFT},
	{PMIC_RG_VCAMD_CAL, MT6328_PMIC_RG_VCAMD_CAL_ADDR, MT6328_PMIC_RG_VCAMD_CAL_MASK,
	 MT6328_PMIC_RG_VCAMD_CAL_SHIFT},
	{PMIC_RG_VCAMD_NDIS_EN, MT6328_PMIC_RG_VCAMD_NDIS_EN_ADDR,
	 MT6328_PMIC_RG_VCAMD_NDIS_EN_MASK, MT6328_PMIC_RG_VCAMD_NDIS_EN_SHIFT},
	{PMIC_RG_VRF18_0_CAL, MT6328_PMIC_RG_VRF18_0_CAL_ADDR, MT6328_PMIC_RG_VRF18_0_CAL_MASK,
	 MT6328_PMIC_RG_VRF18_0_CAL_SHIFT},
	{PMIC_RG_VRF18_0_NDIS_EN, MT6328_PMIC_RG_VRF18_0_NDIS_EN_ADDR,
	 MT6328_PMIC_RG_VRF18_0_NDIS_EN_MASK, MT6328_PMIC_RG_VRF18_0_NDIS_EN_SHIFT},
	{PMIC_RG_VRF18_1_VOSEL, MT6328_PMIC_RG_VRF18_1_VOSEL_ADDR,
	 MT6328_PMIC_RG_VRF18_1_VOSEL_MASK, MT6328_PMIC_RG_VRF18_1_VOSEL_SHIFT},
	{PMIC_RG_VRF18_1_CAL, MT6328_PMIC_RG_VRF18_1_CAL_ADDR, MT6328_PMIC_RG_VRF18_1_CAL_MASK,
	 MT6328_PMIC_RG_VRF18_1_CAL_SHIFT},
	{PMIC_RG_VRF18_1_NDIS_EN, MT6328_PMIC_RG_VRF18_1_NDIS_EN_ADDR,
	 MT6328_PMIC_RG_VRF18_1_NDIS_EN_MASK, MT6328_PMIC_RG_VRF18_1_NDIS_EN_SHIFT},
	{PMIC_RG_VIO18_CAL, MT6328_PMIC_RG_VIO18_CAL_ADDR, MT6328_PMIC_RG_VIO18_CAL_MASK,
	 MT6328_PMIC_RG_VIO18_CAL_SHIFT},
	{PMIC_RG_VIO18_NDIS_EN, MT6328_PMIC_RG_VIO18_NDIS_EN_ADDR,
	 MT6328_PMIC_RG_VIO18_NDIS_EN_MASK, MT6328_PMIC_RG_VIO18_NDIS_EN_SHIFT},
	{PMIC_RG_VCN18_CAL, MT6328_PMIC_RG_VCN18_CAL_ADDR, MT6328_PMIC_RG_VCN18_CAL_MASK,
	 MT6328_PMIC_RG_VCN18_CAL_SHIFT},
	{PMIC_RG_VCN18_NDIS_EN, MT6328_PMIC_RG_VCN18_NDIS_EN_ADDR,
	 MT6328_PMIC_RG_VCN18_NDIS_EN_MASK, MT6328_PMIC_RG_VCN18_NDIS_EN_SHIFT},
	{PMIC_RG_VCAMIO_VOSEL, MT6328_PMIC_RG_VCAMIO_VOSEL_ADDR, MT6328_PMIC_RG_VCAMIO_VOSEL_MASK,
	 MT6328_PMIC_RG_VCAMIO_VOSEL_SHIFT},
	{PMIC_RG_VCAMIO_CAL, MT6328_PMIC_RG_VCAMIO_CAL_ADDR, MT6328_PMIC_RG_VCAMIO_CAL_MASK,
	 MT6328_PMIC_RG_VCAMIO_CAL_SHIFT},
	{PMIC_RG_VCAMIO_NDIS_EN, MT6328_PMIC_RG_VCAMIO_NDIS_EN_ADDR,
	 MT6328_PMIC_RG_VCAMIO_NDIS_EN_MASK, MT6328_PMIC_RG_VCAMIO_NDIS_EN_SHIFT},
	{PMIC_RG_SLDO_RSV_L, MT6328_PMIC_RG_SLDO_RSV_L_ADDR, MT6328_PMIC_RG_SLDO_RSV_L_MASK,
	 MT6328_PMIC_RG_SLDO_RSV_L_SHIFT},
	{PMIC_RG_SLDO_RSV_H, MT6328_PMIC_RG_SLDO_RSV_H_ADDR, MT6328_PMIC_RG_SLDO_RSV_H_MASK,
	 MT6328_PMIC_RG_SLDO_RSV_H_SHIFT},
	{PMIC_RG_VSRAM_VOSEL, MT6328_PMIC_RG_VSRAM_VOSEL_ADDR, MT6328_PMIC_RG_VSRAM_VOSEL_MASK,
	 MT6328_PMIC_RG_VSRAM_VOSEL_SHIFT},
	{PMIC_RG_VSRAM_PLCUR_EN, MT6328_PMIC_RG_VSRAM_PLCUR_EN_ADDR,
	 MT6328_PMIC_RG_VSRAM_PLCUR_EN_MASK, MT6328_PMIC_RG_VSRAM_PLCUR_EN_SHIFT},
	{PMIC_RG_VSRAM_NDIS_PLCUR, MT6328_PMIC_RG_VSRAM_NDIS_PLCUR_ADDR,
	 MT6328_PMIC_RG_VSRAM_NDIS_PLCUR_MASK, MT6328_PMIC_RG_VSRAM_NDIS_PLCUR_SHIFT},
	{PMIC_RG_VSRAM_NDIS_EN, MT6328_PMIC_RG_VSRAM_NDIS_EN_ADDR,
	 MT6328_PMIC_RG_VSRAM_NDIS_EN_MASK, MT6328_PMIC_RG_VSRAM_NDIS_EN_SHIFT},
	{PMIC_RG_LDO_RSV1, MT6328_PMIC_RG_LDO_RSV1_ADDR, MT6328_PMIC_RG_LDO_RSV1_MASK,
	 MT6328_PMIC_RG_LDO_RSV1_SHIFT},
	{PMIC_RG_LDO_RSV0, MT6328_PMIC_RG_LDO_RSV0_ADDR, MT6328_PMIC_RG_LDO_RSV0_MASK,
	 MT6328_PMIC_RG_LDO_RSV0_SHIFT},
	{PMIC_RG_LDO_RSV2, MT6328_PMIC_RG_LDO_RSV2_ADDR, MT6328_PMIC_RG_LDO_RSV2_MASK,
	 MT6328_PMIC_RG_LDO_RSV2_SHIFT},
	{PMIC_SPK_EN_L, MT6328_PMIC_SPK_EN_L_ADDR, MT6328_PMIC_SPK_EN_L_MASK,
	 MT6328_PMIC_SPK_EN_L_SHIFT},
	{PMIC_SPKMODE_L, MT6328_PMIC_SPKMODE_L_ADDR, MT6328_PMIC_SPKMODE_L_MASK,
	 MT6328_PMIC_SPKMODE_L_SHIFT},
	{PMIC_SPK_TRIM_EN_L, MT6328_PMIC_SPK_TRIM_EN_L_ADDR, MT6328_PMIC_SPK_TRIM_EN_L_MASK,
	 MT6328_PMIC_SPK_TRIM_EN_L_SHIFT},
	{PMIC_SPK_OC_SHDN_DL, MT6328_PMIC_SPK_OC_SHDN_DL_ADDR, MT6328_PMIC_SPK_OC_SHDN_DL_MASK,
	 MT6328_PMIC_SPK_OC_SHDN_DL_SHIFT},
	{PMIC_SPK_THER_SHDN_L_EN, MT6328_PMIC_SPK_THER_SHDN_L_EN_ADDR,
	 MT6328_PMIC_SPK_THER_SHDN_L_EN_MASK, MT6328_PMIC_SPK_THER_SHDN_L_EN_SHIFT},
	{PMIC_SPK_OUT_STAGE_SEL, MT6328_PMIC_SPK_OUT_STAGE_SEL_ADDR,
	 MT6328_PMIC_SPK_OUT_STAGE_SEL_MASK, MT6328_PMIC_SPK_OUT_STAGE_SEL_SHIFT},
	{PMIC_RG_SPK_GAINL, MT6328_PMIC_RG_SPK_GAINL_ADDR, MT6328_PMIC_RG_SPK_GAINL_MASK,
	 MT6328_PMIC_RG_SPK_GAINL_SHIFT},
	{PMIC_DA_SPK_OFFSET_L, MT6328_PMIC_DA_SPK_OFFSET_L_ADDR, MT6328_PMIC_DA_SPK_OFFSET_L_MASK,
	 MT6328_PMIC_DA_SPK_OFFSET_L_SHIFT},
	{PMIC_DA_SPK_LEAD_DGLH_L, MT6328_PMIC_DA_SPK_LEAD_DGLH_L_ADDR,
	 MT6328_PMIC_DA_SPK_LEAD_DGLH_L_MASK, MT6328_PMIC_DA_SPK_LEAD_DGLH_L_SHIFT},
	{PMIC_NI_SPK_LEAD_L, MT6328_PMIC_NI_SPK_LEAD_L_ADDR, MT6328_PMIC_NI_SPK_LEAD_L_MASK,
	 MT6328_PMIC_NI_SPK_LEAD_L_SHIFT},
	{PMIC_SPK_OFFSET_L_OV, MT6328_PMIC_SPK_OFFSET_L_OV_ADDR, MT6328_PMIC_SPK_OFFSET_L_OV_MASK,
	 MT6328_PMIC_SPK_OFFSET_L_OV_SHIFT},
	{PMIC_SPK_OFFSET_L_SW, MT6328_PMIC_SPK_OFFSET_L_SW_ADDR, MT6328_PMIC_SPK_OFFSET_L_SW_MASK,
	 MT6328_PMIC_SPK_OFFSET_L_SW_SHIFT},
	{PMIC_SPK_LEAD_L_SW, MT6328_PMIC_SPK_LEAD_L_SW_ADDR, MT6328_PMIC_SPK_LEAD_L_SW_MASK,
	 MT6328_PMIC_SPK_LEAD_L_SW_SHIFT},
	{PMIC_SPK_OFFSET_L_MODE, MT6328_PMIC_SPK_OFFSET_L_MODE_ADDR,
	 MT6328_PMIC_SPK_OFFSET_L_MODE_MASK, MT6328_PMIC_SPK_OFFSET_L_MODE_SHIFT},
	{PMIC_SPK_TRIM_DONE_L, MT6328_PMIC_SPK_TRIM_DONE_L_ADDR, MT6328_PMIC_SPK_TRIM_DONE_L_MASK,
	 MT6328_PMIC_SPK_TRIM_DONE_L_SHIFT},
	{PMIC_RG_SPK_INTG_RST_L, MT6328_PMIC_RG_SPK_INTG_RST_L_ADDR,
	 MT6328_PMIC_RG_SPK_INTG_RST_L_MASK, MT6328_PMIC_RG_SPK_INTG_RST_L_SHIFT},
	{PMIC_RG_SPK_FORCE_EN_L, MT6328_PMIC_RG_SPK_FORCE_EN_L_ADDR,
	 MT6328_PMIC_RG_SPK_FORCE_EN_L_MASK, MT6328_PMIC_RG_SPK_FORCE_EN_L_SHIFT},
	{PMIC_RG_SPK_SLEW_L, MT6328_PMIC_RG_SPK_SLEW_L_ADDR, MT6328_PMIC_RG_SPK_SLEW_L_MASK,
	 MT6328_PMIC_RG_SPK_SLEW_L_SHIFT},
	{PMIC_RG_SPKAB_OBIAS_L, MT6328_PMIC_RG_SPKAB_OBIAS_L_ADDR,
	 MT6328_PMIC_RG_SPKAB_OBIAS_L_MASK, MT6328_PMIC_RG_SPKAB_OBIAS_L_SHIFT},
	{PMIC_RG_SPKRCV_EN_L, MT6328_PMIC_RG_SPKRCV_EN_L_ADDR, MT6328_PMIC_RG_SPKRCV_EN_L_MASK,
	 MT6328_PMIC_RG_SPKRCV_EN_L_SHIFT},
	{PMIC_RG_SPK_DRC_EN_L, MT6328_PMIC_RG_SPK_DRC_EN_L_ADDR, MT6328_PMIC_RG_SPK_DRC_EN_L_MASK,
	 MT6328_PMIC_RG_SPK_DRC_EN_L_SHIFT},
	{PMIC_RG_SPK_TEST_EN_L, MT6328_PMIC_RG_SPK_TEST_EN_L_ADDR,
	 MT6328_PMIC_RG_SPK_TEST_EN_L_MASK, MT6328_PMIC_RG_SPK_TEST_EN_L_SHIFT},
	{PMIC_RG_SPKAB_OC_EN_L, MT6328_PMIC_RG_SPKAB_OC_EN_L_ADDR,
	 MT6328_PMIC_RG_SPKAB_OC_EN_L_MASK, MT6328_PMIC_RG_SPKAB_OC_EN_L_SHIFT},
	{PMIC_RG_SPK_OC_EN_L, MT6328_PMIC_RG_SPK_OC_EN_L_ADDR, MT6328_PMIC_RG_SPK_OC_EN_L_MASK,
	 MT6328_PMIC_RG_SPK_OC_EN_L_SHIFT},
	{PMIC_SPK_EN_R, MT6328_PMIC_SPK_EN_R_ADDR, MT6328_PMIC_SPK_EN_R_MASK,
	 MT6328_PMIC_SPK_EN_R_SHIFT},
	{PMIC_SPKMODE_R, MT6328_PMIC_SPKMODE_R_ADDR, MT6328_PMIC_SPKMODE_R_MASK,
	 MT6328_PMIC_SPKMODE_R_SHIFT},
	{PMIC_SPK_TRIM_EN_R, MT6328_PMIC_SPK_TRIM_EN_R_ADDR, MT6328_PMIC_SPK_TRIM_EN_R_MASK,
	 MT6328_PMIC_SPK_TRIM_EN_R_SHIFT},
	{PMIC_SPK_OC_SHDN_DR, MT6328_PMIC_SPK_OC_SHDN_DR_ADDR, MT6328_PMIC_SPK_OC_SHDN_DR_MASK,
	 MT6328_PMIC_SPK_OC_SHDN_DR_SHIFT},
	{PMIC_SPK_THER_SHDN_R_EN, MT6328_PMIC_SPK_THER_SHDN_R_EN_ADDR,
	 MT6328_PMIC_SPK_THER_SHDN_R_EN_MASK, MT6328_PMIC_SPK_THER_SHDN_R_EN_SHIFT},
	{PMIC_RG_SPK_GAINR, MT6328_PMIC_RG_SPK_GAINR_ADDR, MT6328_PMIC_RG_SPK_GAINR_MASK,
	 MT6328_PMIC_RG_SPK_GAINR_SHIFT},
	{PMIC_DA_SPK_OFFSET_R, MT6328_PMIC_DA_SPK_OFFSET_R_ADDR, MT6328_PMIC_DA_SPK_OFFSET_R_MASK,
	 MT6328_PMIC_DA_SPK_OFFSET_R_SHIFT},
	{PMIC_DA_SPK_LEAD_DGLH_R, MT6328_PMIC_DA_SPK_LEAD_DGLH_R_ADDR,
	 MT6328_PMIC_DA_SPK_LEAD_DGLH_R_MASK, MT6328_PMIC_DA_SPK_LEAD_DGLH_R_SHIFT},
	{PMIC_NI_SPK_LEAD_R, MT6328_PMIC_NI_SPK_LEAD_R_ADDR, MT6328_PMIC_NI_SPK_LEAD_R_MASK,
	 MT6328_PMIC_NI_SPK_LEAD_R_SHIFT},
	{PMIC_SPK_OFFSET_R_OV, MT6328_PMIC_SPK_OFFSET_R_OV_ADDR, MT6328_PMIC_SPK_OFFSET_R_OV_MASK,
	 MT6328_PMIC_SPK_OFFSET_R_OV_SHIFT},
	{PMIC_SPK_OFFSET_R_SW, MT6328_PMIC_SPK_OFFSET_R_SW_ADDR, MT6328_PMIC_SPK_OFFSET_R_SW_MASK,
	 MT6328_PMIC_SPK_OFFSET_R_SW_SHIFT},
	{PMIC_SPK_LEAD_R_SW, MT6328_PMIC_SPK_LEAD_R_SW_ADDR, MT6328_PMIC_SPK_LEAD_R_SW_MASK,
	 MT6328_PMIC_SPK_LEAD_R_SW_SHIFT},
	{PMIC_SPK_OFFSET_R_MODE, MT6328_PMIC_SPK_OFFSET_R_MODE_ADDR,
	 MT6328_PMIC_SPK_OFFSET_R_MODE_MASK, MT6328_PMIC_SPK_OFFSET_R_MODE_SHIFT},
	{PMIC_SPK_TRIM_DONE_R, MT6328_PMIC_SPK_TRIM_DONE_R_ADDR, MT6328_PMIC_SPK_TRIM_DONE_R_MASK,
	 MT6328_PMIC_SPK_TRIM_DONE_R_SHIFT},
	{PMIC_RG_SPK_INTG_RST_R, MT6328_PMIC_RG_SPK_INTG_RST_R_ADDR,
	 MT6328_PMIC_RG_SPK_INTG_RST_R_MASK, MT6328_PMIC_RG_SPK_INTG_RST_R_SHIFT},
	{PMIC_RG_SPK_FORCE_EN_R, MT6328_PMIC_RG_SPK_FORCE_EN_R_ADDR,
	 MT6328_PMIC_RG_SPK_FORCE_EN_R_MASK, MT6328_PMIC_RG_SPK_FORCE_EN_R_SHIFT},
	{PMIC_RG_SPK_SLEW_R, MT6328_PMIC_RG_SPK_SLEW_R_ADDR, MT6328_PMIC_RG_SPK_SLEW_R_MASK,
	 MT6328_PMIC_RG_SPK_SLEW_R_SHIFT},
	{PMIC_RG_SPKAB_OBIAS_R, MT6328_PMIC_RG_SPKAB_OBIAS_R_ADDR,
	 MT6328_PMIC_RG_SPKAB_OBIAS_R_MASK, MT6328_PMIC_RG_SPKAB_OBIAS_R_SHIFT},
	{PMIC_RG_SPKRCV_EN_R, MT6328_PMIC_RG_SPKRCV_EN_R_ADDR, MT6328_PMIC_RG_SPKRCV_EN_R_MASK,
	 MT6328_PMIC_RG_SPKRCV_EN_R_SHIFT},
	{PMIC_RG_SPK_DRC_EN_R, MT6328_PMIC_RG_SPK_DRC_EN_R_ADDR, MT6328_PMIC_RG_SPK_DRC_EN_R_MASK,
	 MT6328_PMIC_RG_SPK_DRC_EN_R_SHIFT},
	{PMIC_RG_SPK_TEST_EN_R, MT6328_PMIC_RG_SPK_TEST_EN_R_ADDR,
	 MT6328_PMIC_RG_SPK_TEST_EN_R_MASK, MT6328_PMIC_RG_SPK_TEST_EN_R_SHIFT},
	{PMIC_RG_SPKAB_OC_EN_R, MT6328_PMIC_RG_SPKAB_OC_EN_R_ADDR,
	 MT6328_PMIC_RG_SPKAB_OC_EN_R_MASK, MT6328_PMIC_RG_SPKAB_OC_EN_R_SHIFT},
	{PMIC_RG_SPK_OC_EN_R, MT6328_PMIC_RG_SPK_OC_EN_R_ADDR, MT6328_PMIC_RG_SPK_OC_EN_R_MASK,
	 MT6328_PMIC_RG_SPK_OC_EN_R_SHIFT},
	{PMIC_RG_SPKPGA_GAINR, MT6328_PMIC_RG_SPKPGA_GAINR_ADDR, MT6328_PMIC_RG_SPKPGA_GAINR_MASK,
	 MT6328_PMIC_RG_SPKPGA_GAINR_SHIFT},
	{PMIC_SPK_TRIM_WND, MT6328_PMIC_SPK_TRIM_WND_ADDR, MT6328_PMIC_SPK_TRIM_WND_MASK,
	 MT6328_PMIC_SPK_TRIM_WND_SHIFT},
	{PMIC_SPK_TRIM_THD, MT6328_PMIC_SPK_TRIM_THD_ADDR, MT6328_PMIC_SPK_TRIM_THD_MASK,
	 MT6328_PMIC_SPK_TRIM_THD_SHIFT},
	{PMIC_SPK_OC_WND, MT6328_PMIC_SPK_OC_WND_ADDR, MT6328_PMIC_SPK_OC_WND_MASK,
	 MT6328_PMIC_SPK_OC_WND_SHIFT},
	{PMIC_SPK_OC_THD, MT6328_PMIC_SPK_OC_THD_ADDR, MT6328_PMIC_SPK_OC_THD_MASK,
	 MT6328_PMIC_SPK_OC_THD_SHIFT},
	{PMIC_SPK_D_OC_R_DEG, MT6328_PMIC_SPK_D_OC_R_DEG_ADDR, MT6328_PMIC_SPK_D_OC_R_DEG_MASK,
	 MT6328_PMIC_SPK_D_OC_R_DEG_SHIFT},
	{PMIC_SPK_AB_OC_R_DEG, MT6328_PMIC_SPK_AB_OC_R_DEG_ADDR, MT6328_PMIC_SPK_AB_OC_R_DEG_MASK,
	 MT6328_PMIC_SPK_AB_OC_R_DEG_SHIFT},
	{PMIC_SPK_D_OC_L_DEG, MT6328_PMIC_SPK_D_OC_L_DEG_ADDR, MT6328_PMIC_SPK_D_OC_L_DEG_MASK,
	 MT6328_PMIC_SPK_D_OC_L_DEG_SHIFT},
	{PMIC_SPK_AB_OC_L_DEG, MT6328_PMIC_SPK_AB_OC_L_DEG_ADDR, MT6328_PMIC_SPK_AB_OC_L_DEG_MASK,
	 MT6328_PMIC_SPK_AB_OC_L_DEG_SHIFT},
	{PMIC_SPK_TD1, MT6328_PMIC_SPK_TD1_ADDR, MT6328_PMIC_SPK_TD1_MASK,
	 MT6328_PMIC_SPK_TD1_SHIFT},
	{PMIC_SPK_TD2, MT6328_PMIC_SPK_TD2_ADDR, MT6328_PMIC_SPK_TD2_MASK,
	 MT6328_PMIC_SPK_TD2_SHIFT},
	{PMIC_SPK_TD3, MT6328_PMIC_SPK_TD3_ADDR, MT6328_PMIC_SPK_TD3_MASK,
	 MT6328_PMIC_SPK_TD3_SHIFT},
	{PMIC_SPK_TRIM_DIV, MT6328_PMIC_SPK_TRIM_DIV_ADDR, MT6328_PMIC_SPK_TRIM_DIV_MASK,
	 MT6328_PMIC_SPK_TRIM_DIV_SHIFT},
	{PMIC_RG_BTL_SET, MT6328_PMIC_RG_BTL_SET_ADDR, MT6328_PMIC_RG_BTL_SET_MASK,
	 MT6328_PMIC_RG_BTL_SET_SHIFT},
	{PMIC_RG_SPK_IBIAS_SEL, MT6328_PMIC_RG_SPK_IBIAS_SEL_ADDR,
	 MT6328_PMIC_RG_SPK_IBIAS_SEL_MASK, MT6328_PMIC_RG_SPK_IBIAS_SEL_SHIFT},
	{PMIC_RG_SPK_CCODE, MT6328_PMIC_RG_SPK_CCODE_ADDR, MT6328_PMIC_RG_SPK_CCODE_MASK,
	 MT6328_PMIC_RG_SPK_CCODE_SHIFT},
	{PMIC_RG_SPK_EN_VIEW_VCM, MT6328_PMIC_RG_SPK_EN_VIEW_VCM_ADDR,
	 MT6328_PMIC_RG_SPK_EN_VIEW_VCM_MASK, MT6328_PMIC_RG_SPK_EN_VIEW_VCM_SHIFT},
	{PMIC_RG_SPK_EN_VIEW_CLK, MT6328_PMIC_RG_SPK_EN_VIEW_CLK_ADDR,
	 MT6328_PMIC_RG_SPK_EN_VIEW_CLK_MASK, MT6328_PMIC_RG_SPK_EN_VIEW_CLK_SHIFT},
	{PMIC_RG_SPK_VCM_SEL, MT6328_PMIC_RG_SPK_VCM_SEL_ADDR, MT6328_PMIC_RG_SPK_VCM_SEL_MASK,
	 MT6328_PMIC_RG_SPK_VCM_SEL_SHIFT},
	{PMIC_RG_SPK_VCM_IBSEL, MT6328_PMIC_RG_SPK_VCM_IBSEL_ADDR,
	 MT6328_PMIC_RG_SPK_VCM_IBSEL_MASK, MT6328_PMIC_RG_SPK_VCM_IBSEL_SHIFT},
	{PMIC_RG_SPK_FBRC_EN, MT6328_PMIC_RG_SPK_FBRC_EN_ADDR, MT6328_PMIC_RG_SPK_FBRC_EN_MASK,
	 MT6328_PMIC_RG_SPK_FBRC_EN_SHIFT},
	{PMIC_RG_SPKAB_OVDRV, MT6328_PMIC_RG_SPKAB_OVDRV_ADDR, MT6328_PMIC_RG_SPKAB_OVDRV_MASK,
	 MT6328_PMIC_RG_SPKAB_OVDRV_SHIFT},
	{PMIC_RG_SPK_OCTH_D, MT6328_PMIC_RG_SPK_OCTH_D_ADDR, MT6328_PMIC_RG_SPK_OCTH_D_MASK,
	 MT6328_PMIC_RG_SPK_OCTH_D_SHIFT},
	{PMIC_RG_SPKPGA_GAINL, MT6328_PMIC_RG_SPKPGA_GAINL_ADDR, MT6328_PMIC_RG_SPKPGA_GAINL_MASK,
	 MT6328_PMIC_RG_SPKPGA_GAINL_SHIFT},
	{PMIC_SPK_RSV0, MT6328_PMIC_SPK_RSV0_ADDR, MT6328_PMIC_SPK_RSV0_MASK,
	 MT6328_PMIC_SPK_RSV0_SHIFT},
	{PMIC_SPK_VCM_FAST_EN, MT6328_PMIC_SPK_VCM_FAST_EN_ADDR, MT6328_PMIC_SPK_VCM_FAST_EN_MASK,
	 MT6328_PMIC_SPK_VCM_FAST_EN_SHIFT},
	{PMIC_SPK_TEST_MODE0, MT6328_PMIC_SPK_TEST_MODE0_ADDR, MT6328_PMIC_SPK_TEST_MODE0_MASK,
	 MT6328_PMIC_SPK_TEST_MODE0_SHIFT},
	{PMIC_SPK_TEST_MODE1, MT6328_PMIC_SPK_TEST_MODE1_ADDR, MT6328_PMIC_SPK_TEST_MODE1_MASK,
	 MT6328_PMIC_SPK_TEST_MODE1_SHIFT},
	{PMIC_SPK_TD_WAIT, MT6328_PMIC_SPK_TD_WAIT_ADDR, MT6328_PMIC_SPK_TD_WAIT_MASK,
	 MT6328_PMIC_SPK_TD_WAIT_SHIFT},
	{PMIC_SPK_TD_DONE, MT6328_PMIC_SPK_TD_DONE_ADDR, MT6328_PMIC_SPK_TD_DONE_MASK,
	 MT6328_PMIC_SPK_TD_DONE_SHIFT},
	{PMIC_SPK_EN_MODE, MT6328_PMIC_SPK_EN_MODE_ADDR, MT6328_PMIC_SPK_EN_MODE_MASK,
	 MT6328_PMIC_SPK_EN_MODE_SHIFT},
	{PMIC_SPK_VCM_FAST_SW, MT6328_PMIC_SPK_VCM_FAST_SW_ADDR, MT6328_PMIC_SPK_VCM_FAST_SW_MASK,
	 MT6328_PMIC_SPK_VCM_FAST_SW_SHIFT},
	{PMIC_SPK_RST_R_SW, MT6328_PMIC_SPK_RST_R_SW_ADDR, MT6328_PMIC_SPK_RST_R_SW_MASK,
	 MT6328_PMIC_SPK_RST_R_SW_SHIFT},
	{PMIC_SPK_RST_L_SW, MT6328_PMIC_SPK_RST_L_SW_ADDR, MT6328_PMIC_SPK_RST_L_SW_MASK,
	 MT6328_PMIC_SPK_RST_L_SW_SHIFT},
	{PMIC_SPKMODE_R_SW, MT6328_PMIC_SPKMODE_R_SW_ADDR, MT6328_PMIC_SPKMODE_R_SW_MASK,
	 MT6328_PMIC_SPKMODE_R_SW_SHIFT},
	{PMIC_SPKMODE_L_SW, MT6328_PMIC_SPKMODE_L_SW_ADDR, MT6328_PMIC_SPKMODE_L_SW_MASK,
	 MT6328_PMIC_SPKMODE_L_SW_SHIFT},
	{PMIC_SPK_DEPOP_EN_R_SW, MT6328_PMIC_SPK_DEPOP_EN_R_SW_ADDR,
	 MT6328_PMIC_SPK_DEPOP_EN_R_SW_MASK, MT6328_PMIC_SPK_DEPOP_EN_R_SW_SHIFT},
	{PMIC_SPK_DEPOP_EN_L_SW, MT6328_PMIC_SPK_DEPOP_EN_L_SW_ADDR,
	 MT6328_PMIC_SPK_DEPOP_EN_L_SW_MASK, MT6328_PMIC_SPK_DEPOP_EN_L_SW_SHIFT},
	{PMIC_SPK_EN_R_SW, MT6328_PMIC_SPK_EN_R_SW_ADDR, MT6328_PMIC_SPK_EN_R_SW_MASK,
	 MT6328_PMIC_SPK_EN_R_SW_SHIFT},
	{PMIC_SPK_EN_L_SW, MT6328_PMIC_SPK_EN_L_SW_ADDR, MT6328_PMIC_SPK_EN_L_SW_MASK,
	 MT6328_PMIC_SPK_EN_L_SW_SHIFT},
	{PMIC_SPK_OUTSTG_EN_R_SW, MT6328_PMIC_SPK_OUTSTG_EN_R_SW_ADDR,
	 MT6328_PMIC_SPK_OUTSTG_EN_R_SW_MASK, MT6328_PMIC_SPK_OUTSTG_EN_R_SW_SHIFT},
	{PMIC_SPK_OUTSTG_EN_L_SW, MT6328_PMIC_SPK_OUTSTG_EN_L_SW_ADDR,
	 MT6328_PMIC_SPK_OUTSTG_EN_L_SW_MASK, MT6328_PMIC_SPK_OUTSTG_EN_L_SW_SHIFT},
	{PMIC_SPK_TRIM_EN_R_SW, MT6328_PMIC_SPK_TRIM_EN_R_SW_ADDR,
	 MT6328_PMIC_SPK_TRIM_EN_R_SW_MASK, MT6328_PMIC_SPK_TRIM_EN_R_SW_SHIFT},
	{PMIC_SPK_TRIM_EN_L_SW, MT6328_PMIC_SPK_TRIM_EN_L_SW_ADDR,
	 MT6328_PMIC_SPK_TRIM_EN_L_SW_MASK, MT6328_PMIC_SPK_TRIM_EN_L_SW_SHIFT},
	{PMIC_SPK_TRIM_STOP_R_SW, MT6328_PMIC_SPK_TRIM_STOP_R_SW_ADDR,
	 MT6328_PMIC_SPK_TRIM_STOP_R_SW_MASK, MT6328_PMIC_SPK_TRIM_STOP_R_SW_SHIFT},
	{PMIC_SPK_TRIM_STOP_L_SW, MT6328_PMIC_SPK_TRIM_STOP_L_SW_ADDR,
	 MT6328_PMIC_SPK_TRIM_STOP_L_SW_MASK, MT6328_PMIC_SPK_TRIM_STOP_L_SW_SHIFT},
	{PMIC_RG_SPK_ISENSE_TEST_EN, MT6328_PMIC_RG_SPK_ISENSE_TEST_EN_ADDR,
	 MT6328_PMIC_RG_SPK_ISENSE_TEST_EN_MASK, MT6328_PMIC_RG_SPK_ISENSE_TEST_EN_SHIFT},
	{PMIC_RG_SPK_ISENSE_REFSEL, MT6328_PMIC_RG_SPK_ISENSE_REFSEL_ADDR,
	 MT6328_PMIC_RG_SPK_ISENSE_REFSEL_MASK, MT6328_PMIC_RG_SPK_ISENSE_REFSEL_SHIFT},
	{PMIC_RG_SPK_ISENSE_GAINSEL, MT6328_PMIC_RG_SPK_ISENSE_GAINSEL_ADDR,
	 MT6328_PMIC_RG_SPK_ISENSE_GAINSEL_MASK, MT6328_PMIC_RG_SPK_ISENSE_GAINSEL_SHIFT},
	{PMIC_RG_SPK_ISENSE_PDRESET, MT6328_PMIC_RG_SPK_ISENSE_PDRESET_ADDR,
	 MT6328_PMIC_RG_SPK_ISENSE_PDRESET_MASK, MT6328_PMIC_RG_SPK_ISENSE_PDRESET_SHIFT},
	{PMIC_RG_SPK_ISENSE_EN, MT6328_PMIC_RG_SPK_ISENSE_EN_ADDR,
	 MT6328_PMIC_RG_SPK_ISENSE_EN_MASK, MT6328_PMIC_RG_SPK_ISENSE_EN_SHIFT},
	{PMIC_RG_SPK_RSV1, MT6328_PMIC_RG_SPK_RSV1_ADDR, MT6328_PMIC_RG_SPK_RSV1_MASK,
	 MT6328_PMIC_RG_SPK_RSV1_SHIFT},
	{PMIC_RG_SPK_RSV0, MT6328_PMIC_RG_SPK_RSV0_ADDR, MT6328_PMIC_RG_SPK_RSV0_MASK,
	 MT6328_PMIC_RG_SPK_RSV0_SHIFT},
	{PMIC_RG_SPK_ABD_VOLSEN_GAIN, MT6328_PMIC_RG_SPK_ABD_VOLSEN_GAIN_ADDR,
	 MT6328_PMIC_RG_SPK_ABD_VOLSEN_GAIN_MASK, MT6328_PMIC_RG_SPK_ABD_VOLSEN_GAIN_SHIFT},
	{PMIC_RG_SPK_ABD_VOLSEN_EN, MT6328_PMIC_RG_SPK_ABD_VOLSEN_EN_ADDR,
	 MT6328_PMIC_RG_SPK_ABD_VOLSEN_EN_MASK, MT6328_PMIC_RG_SPK_ABD_VOLSEN_EN_SHIFT},
	{PMIC_RG_SPK_ABD_CURSEN_SEL, MT6328_PMIC_RG_SPK_ABD_CURSEN_SEL_ADDR,
	 MT6328_PMIC_RG_SPK_ABD_CURSEN_SEL_MASK, MT6328_PMIC_RG_SPK_ABD_CURSEN_SEL_SHIFT},
	{PMIC_RG_SPK_RSV2, MT6328_PMIC_RG_SPK_RSV2_ADDR, MT6328_PMIC_RG_SPK_RSV2_MASK,
	 MT6328_PMIC_RG_SPK_RSV2_SHIFT},
	{PMIC_RG_SPK_TRIM2, MT6328_PMIC_RG_SPK_TRIM2_ADDR, MT6328_PMIC_RG_SPK_TRIM2_MASK,
	 MT6328_PMIC_RG_SPK_TRIM2_SHIFT},
	{PMIC_RG_SPK_TRIM1, MT6328_PMIC_RG_SPK_TRIM1_ADDR, MT6328_PMIC_RG_SPK_TRIM1_MASK,
	 MT6328_PMIC_RG_SPK_TRIM1_SHIFT},
	{PMIC_RG_SPK_D_CURSEN_RSETSEL, MT6328_PMIC_RG_SPK_D_CURSEN_RSETSEL_ADDR,
	 MT6328_PMIC_RG_SPK_D_CURSEN_RSETSEL_MASK, MT6328_PMIC_RG_SPK_D_CURSEN_RSETSEL_SHIFT},
	{PMIC_RG_SPK_D_CURSEN_GAIN, MT6328_PMIC_RG_SPK_D_CURSEN_GAIN_ADDR,
	 MT6328_PMIC_RG_SPK_D_CURSEN_GAIN_MASK, MT6328_PMIC_RG_SPK_D_CURSEN_GAIN_SHIFT},
	{PMIC_RG_SPK_D_CURSEN_EN, MT6328_PMIC_RG_SPK_D_CURSEN_EN_ADDR,
	 MT6328_PMIC_RG_SPK_D_CURSEN_EN_MASK, MT6328_PMIC_RG_SPK_D_CURSEN_EN_SHIFT},
	{PMIC_RG_SPK_AB_CURSEN_RSETSEL, MT6328_PMIC_RG_SPK_AB_CURSEN_RSETSEL_ADDR,
	 MT6328_PMIC_RG_SPK_AB_CURSEN_RSETSEL_MASK, MT6328_PMIC_RG_SPK_AB_CURSEN_RSETSEL_SHIFT},
	{PMIC_RG_SPK_AB_CURSEN_GAIN, MT6328_PMIC_RG_SPK_AB_CURSEN_GAIN_ADDR,
	 MT6328_PMIC_RG_SPK_AB_CURSEN_GAIN_MASK, MT6328_PMIC_RG_SPK_AB_CURSEN_GAIN_SHIFT},
	{PMIC_RG_SPK_AB_CURSEN_EN, MT6328_PMIC_RG_SPK_AB_CURSEN_EN_ADDR,
	 MT6328_PMIC_RG_SPK_AB_CURSEN_EN_MASK, MT6328_PMIC_RG_SPK_AB_CURSEN_EN_SHIFT},
	{PMIC_RG_SPKPGA_GAIN, MT6328_PMIC_RG_SPKPGA_GAIN_ADDR, MT6328_PMIC_RG_SPKPGA_GAIN_MASK,
	 MT6328_PMIC_RG_SPKPGA_GAIN_SHIFT},
	{PMIC_RG_SPK_RSV, MT6328_PMIC_RG_SPK_RSV_ADDR, MT6328_PMIC_RG_SPK_RSV_MASK,
	 MT6328_PMIC_RG_SPK_RSV_SHIFT},
	{PMIC_RG_ISENSE_PD_RESET, MT6328_PMIC_RG_ISENSE_PD_RESET_ADDR,
	 MT6328_PMIC_RG_ISENSE_PD_RESET_MASK, MT6328_PMIC_RG_ISENSE_PD_RESET_SHIFT},
	{PMIC_RG_AUDIVLPWRUP_VAUDP12, MT6328_PMIC_RG_AUDIVLPWRUP_VAUDP12_ADDR,
	 MT6328_PMIC_RG_AUDIVLPWRUP_VAUDP12_MASK, MT6328_PMIC_RG_AUDIVLPWRUP_VAUDP12_SHIFT},
	{PMIC_RG_AUDIVLSTARTUP_VAUDP12, MT6328_PMIC_RG_AUDIVLSTARTUP_VAUDP12_ADDR,
	 MT6328_PMIC_RG_AUDIVLSTARTUP_VAUDP12_MASK, MT6328_PMIC_RG_AUDIVLSTARTUP_VAUDP12_SHIFT},
	{PMIC_RG_AUDIVLMUXSEL_VAUDP12, MT6328_PMIC_RG_AUDIVLMUXSEL_VAUDP12_ADDR,
	 MT6328_PMIC_RG_AUDIVLMUXSEL_VAUDP12_MASK, MT6328_PMIC_RG_AUDIVLMUXSEL_VAUDP12_SHIFT},
	{PMIC_RG_AUDIVLMUTE_VAUDP12, MT6328_PMIC_RG_AUDIVLMUTE_VAUDP12_ADDR,
	 MT6328_PMIC_RG_AUDIVLMUTE_VAUDP12_MASK, MT6328_PMIC_RG_AUDIVLMUTE_VAUDP12_SHIFT},
	{PMIC_RG_OTP_PA, MT6328_PMIC_RG_OTP_PA_ADDR, MT6328_PMIC_RG_OTP_PA_MASK,
	 MT6328_PMIC_RG_OTP_PA_SHIFT},
	{PMIC_RG_OTP_PDIN, MT6328_PMIC_RG_OTP_PDIN_ADDR, MT6328_PMIC_RG_OTP_PDIN_MASK,
	 MT6328_PMIC_RG_OTP_PDIN_SHIFT},
	{PMIC_RG_OTP_PTM, MT6328_PMIC_RG_OTP_PTM_ADDR, MT6328_PMIC_RG_OTP_PTM_MASK,
	 MT6328_PMIC_RG_OTP_PTM_SHIFT},
	{PMIC_RG_OTP_PWE, MT6328_PMIC_RG_OTP_PWE_ADDR, MT6328_PMIC_RG_OTP_PWE_MASK,
	 MT6328_PMIC_RG_OTP_PWE_SHIFT},
	{PMIC_RG_OTP_PPROG, MT6328_PMIC_RG_OTP_PPROG_ADDR, MT6328_PMIC_RG_OTP_PPROG_MASK,
	 MT6328_PMIC_RG_OTP_PPROG_SHIFT},
	{PMIC_RG_OTP_PWE_SRC, MT6328_PMIC_RG_OTP_PWE_SRC_ADDR, MT6328_PMIC_RG_OTP_PWE_SRC_MASK,
	 MT6328_PMIC_RG_OTP_PWE_SRC_SHIFT},
	{PMIC_RG_OTP_PROG_PKEY, MT6328_PMIC_RG_OTP_PROG_PKEY_ADDR,
	 MT6328_PMIC_RG_OTP_PROG_PKEY_MASK, MT6328_PMIC_RG_OTP_PROG_PKEY_SHIFT},
	{PMIC_RG_OTP_RD_PKEY, MT6328_PMIC_RG_OTP_RD_PKEY_ADDR, MT6328_PMIC_RG_OTP_RD_PKEY_MASK,
	 MT6328_PMIC_RG_OTP_RD_PKEY_SHIFT},
	{PMIC_RG_OTP_RD_TRIG, MT6328_PMIC_RG_OTP_RD_TRIG_ADDR, MT6328_PMIC_RG_OTP_RD_TRIG_MASK,
	 MT6328_PMIC_RG_OTP_RD_TRIG_SHIFT},
	{PMIC_RG_RD_RDY_BYPASS, MT6328_PMIC_RG_RD_RDY_BYPASS_ADDR,
	 MT6328_PMIC_RG_RD_RDY_BYPASS_MASK, MT6328_PMIC_RG_RD_RDY_BYPASS_SHIFT},
	{PMIC_RG_SKIP_OTP_OUT, MT6328_PMIC_RG_SKIP_OTP_OUT_ADDR, MT6328_PMIC_RG_SKIP_OTP_OUT_MASK,
	 MT6328_PMIC_RG_SKIP_OTP_OUT_SHIFT},
	{PMIC_RG_OTP_RD_SW, MT6328_PMIC_RG_OTP_RD_SW_ADDR, MT6328_PMIC_RG_OTP_RD_SW_MASK,
	 MT6328_PMIC_RG_OTP_RD_SW_SHIFT},
	{PMIC_RG_OTP_DOUT_SW, MT6328_PMIC_RG_OTP_DOUT_SW_ADDR, MT6328_PMIC_RG_OTP_DOUT_SW_MASK,
	 MT6328_PMIC_RG_OTP_DOUT_SW_SHIFT},
	{PMIC_RG_OTP_RD_BUSY, MT6328_PMIC_RG_OTP_RD_BUSY_ADDR, MT6328_PMIC_RG_OTP_RD_BUSY_MASK,
	 MT6328_PMIC_RG_OTP_RD_BUSY_SHIFT},
	{PMIC_RG_OTP_RD_ACK, MT6328_PMIC_RG_OTP_RD_ACK_ADDR, MT6328_PMIC_RG_OTP_RD_ACK_MASK,
	 MT6328_PMIC_RG_OTP_RD_ACK_SHIFT},
	{PMIC_RG_OTP_PA_SW, MT6328_PMIC_RG_OTP_PA_SW_ADDR, MT6328_PMIC_RG_OTP_PA_SW_MASK,
	 MT6328_PMIC_RG_OTP_PA_SW_SHIFT},
	{PMIC_RG_OTP_DOUT_0_15, MT6328_PMIC_RG_OTP_DOUT_0_15_ADDR,
	 MT6328_PMIC_RG_OTP_DOUT_0_15_MASK, MT6328_PMIC_RG_OTP_DOUT_0_15_SHIFT},
	{PMIC_RG_OTP_DOUT_16_31, MT6328_PMIC_RG_OTP_DOUT_16_31_ADDR,
	 MT6328_PMIC_RG_OTP_DOUT_16_31_MASK, MT6328_PMIC_RG_OTP_DOUT_16_31_SHIFT},
	{PMIC_RG_OTP_DOUT_32_47, MT6328_PMIC_RG_OTP_DOUT_32_47_ADDR,
	 MT6328_PMIC_RG_OTP_DOUT_32_47_MASK, MT6328_PMIC_RG_OTP_DOUT_32_47_SHIFT},
	{PMIC_RG_OTP_DOUT_48_63, MT6328_PMIC_RG_OTP_DOUT_48_63_ADDR,
	 MT6328_PMIC_RG_OTP_DOUT_48_63_MASK, MT6328_PMIC_RG_OTP_DOUT_48_63_SHIFT},
	{PMIC_RG_OTP_DOUT_64_79, MT6328_PMIC_RG_OTP_DOUT_64_79_ADDR,
	 MT6328_PMIC_RG_OTP_DOUT_64_79_MASK, MT6328_PMIC_RG_OTP_DOUT_64_79_SHIFT},
	{PMIC_RG_OTP_DOUT_80_95, MT6328_PMIC_RG_OTP_DOUT_80_95_ADDR,
	 MT6328_PMIC_RG_OTP_DOUT_80_95_MASK, MT6328_PMIC_RG_OTP_DOUT_80_95_SHIFT},
	{PMIC_RG_OTP_DOUT_96_111, MT6328_PMIC_RG_OTP_DOUT_96_111_ADDR,
	 MT6328_PMIC_RG_OTP_DOUT_96_111_MASK, MT6328_PMIC_RG_OTP_DOUT_96_111_SHIFT},
	{PMIC_RG_OTP_DOUT_112_127, MT6328_PMIC_RG_OTP_DOUT_112_127_ADDR,
	 MT6328_PMIC_RG_OTP_DOUT_112_127_MASK, MT6328_PMIC_RG_OTP_DOUT_112_127_SHIFT},
	{PMIC_RG_OTP_DOUT_128_143, MT6328_PMIC_RG_OTP_DOUT_128_143_ADDR,
	 MT6328_PMIC_RG_OTP_DOUT_128_143_MASK, MT6328_PMIC_RG_OTP_DOUT_128_143_SHIFT},
	{PMIC_RG_OTP_DOUT_144_159, MT6328_PMIC_RG_OTP_DOUT_144_159_ADDR,
	 MT6328_PMIC_RG_OTP_DOUT_144_159_MASK, MT6328_PMIC_RG_OTP_DOUT_144_159_SHIFT},
	{PMIC_RG_OTP_DOUT_160_175, MT6328_PMIC_RG_OTP_DOUT_160_175_ADDR,
	 MT6328_PMIC_RG_OTP_DOUT_160_175_MASK, MT6328_PMIC_RG_OTP_DOUT_160_175_SHIFT},
	{PMIC_RG_OTP_DOUT_176_191, MT6328_PMIC_RG_OTP_DOUT_176_191_ADDR,
	 MT6328_PMIC_RG_OTP_DOUT_176_191_MASK, MT6328_PMIC_RG_OTP_DOUT_176_191_SHIFT},
	{PMIC_RG_OTP_DOUT_192_207, MT6328_PMIC_RG_OTP_DOUT_192_207_ADDR,
	 MT6328_PMIC_RG_OTP_DOUT_192_207_MASK, MT6328_PMIC_RG_OTP_DOUT_192_207_SHIFT},
	{PMIC_RG_OTP_DOUT_208_223, MT6328_PMIC_RG_OTP_DOUT_208_223_ADDR,
	 MT6328_PMIC_RG_OTP_DOUT_208_223_MASK, MT6328_PMIC_RG_OTP_DOUT_208_223_SHIFT},
	{PMIC_RG_OTP_DOUT_224_239, MT6328_PMIC_RG_OTP_DOUT_224_239_ADDR,
	 MT6328_PMIC_RG_OTP_DOUT_224_239_MASK, MT6328_PMIC_RG_OTP_DOUT_224_239_SHIFT},
	{PMIC_RG_OTP_DOUT_240_255, MT6328_PMIC_RG_OTP_DOUT_240_255_ADDR,
	 MT6328_PMIC_RG_OTP_DOUT_240_255_MASK, MT6328_PMIC_RG_OTP_DOUT_240_255_SHIFT},
	{PMIC_RG_OTP_DOUT_256_271, MT6328_PMIC_RG_OTP_DOUT_256_271_ADDR,
	 MT6328_PMIC_RG_OTP_DOUT_256_271_MASK, MT6328_PMIC_RG_OTP_DOUT_256_271_SHIFT},
	{PMIC_RG_OTP_DOUT_272_287, MT6328_PMIC_RG_OTP_DOUT_272_287_ADDR,
	 MT6328_PMIC_RG_OTP_DOUT_272_287_MASK, MT6328_PMIC_RG_OTP_DOUT_272_287_SHIFT},
	{PMIC_RG_OTP_DOUT_288_303, MT6328_PMIC_RG_OTP_DOUT_288_303_ADDR,
	 MT6328_PMIC_RG_OTP_DOUT_288_303_MASK, MT6328_PMIC_RG_OTP_DOUT_288_303_SHIFT},
	{PMIC_RG_OTP_DOUT_304_319, MT6328_PMIC_RG_OTP_DOUT_304_319_ADDR,
	 MT6328_PMIC_RG_OTP_DOUT_304_319_MASK, MT6328_PMIC_RG_OTP_DOUT_304_319_SHIFT},
	{PMIC_RG_OTP_DOUT_320_335, MT6328_PMIC_RG_OTP_DOUT_320_335_ADDR,
	 MT6328_PMIC_RG_OTP_DOUT_320_335_MASK, MT6328_PMIC_RG_OTP_DOUT_320_335_SHIFT},
	{PMIC_RG_OTP_DOUT_336_351, MT6328_PMIC_RG_OTP_DOUT_336_351_ADDR,
	 MT6328_PMIC_RG_OTP_DOUT_336_351_MASK, MT6328_PMIC_RG_OTP_DOUT_336_351_SHIFT},
	{PMIC_RG_OTP_DOUT_352_367, MT6328_PMIC_RG_OTP_DOUT_352_367_ADDR,
	 MT6328_PMIC_RG_OTP_DOUT_352_367_MASK, MT6328_PMIC_RG_OTP_DOUT_352_367_SHIFT},
	{PMIC_RG_OTP_DOUT_368_383, MT6328_PMIC_RG_OTP_DOUT_368_383_ADDR,
	 MT6328_PMIC_RG_OTP_DOUT_368_383_MASK, MT6328_PMIC_RG_OTP_DOUT_368_383_SHIFT},
	{PMIC_RG_OTP_DOUT_384_399, MT6328_PMIC_RG_OTP_DOUT_384_399_ADDR,
	 MT6328_PMIC_RG_OTP_DOUT_384_399_MASK, MT6328_PMIC_RG_OTP_DOUT_384_399_SHIFT},
	{PMIC_RG_OTP_DOUT_400_415, MT6328_PMIC_RG_OTP_DOUT_400_415_ADDR,
	 MT6328_PMIC_RG_OTP_DOUT_400_415_MASK, MT6328_PMIC_RG_OTP_DOUT_400_415_SHIFT},
	{PMIC_RG_OTP_DOUT_416_431, MT6328_PMIC_RG_OTP_DOUT_416_431_ADDR,
	 MT6328_PMIC_RG_OTP_DOUT_416_431_MASK, MT6328_PMIC_RG_OTP_DOUT_416_431_SHIFT},
	{PMIC_RG_OTP_DOUT_432_447, MT6328_PMIC_RG_OTP_DOUT_432_447_ADDR,
	 MT6328_PMIC_RG_OTP_DOUT_432_447_MASK, MT6328_PMIC_RG_OTP_DOUT_432_447_SHIFT},
	{PMIC_RG_OTP_DOUT_448_463, MT6328_PMIC_RG_OTP_DOUT_448_463_ADDR,
	 MT6328_PMIC_RG_OTP_DOUT_448_463_MASK, MT6328_PMIC_RG_OTP_DOUT_448_463_SHIFT},
	{PMIC_RG_OTP_DOUT_464_479, MT6328_PMIC_RG_OTP_DOUT_464_479_ADDR,
	 MT6328_PMIC_RG_OTP_DOUT_464_479_MASK, MT6328_PMIC_RG_OTP_DOUT_464_479_SHIFT},
	{PMIC_RG_OTP_DOUT_480_495, MT6328_PMIC_RG_OTP_DOUT_480_495_ADDR,
	 MT6328_PMIC_RG_OTP_DOUT_480_495_MASK, MT6328_PMIC_RG_OTP_DOUT_480_495_SHIFT},
	{PMIC_RG_OTP_DOUT_496_511, MT6328_PMIC_RG_OTP_DOUT_496_511_ADDR,
	 MT6328_PMIC_RG_OTP_DOUT_496_511_MASK, MT6328_PMIC_RG_OTP_DOUT_496_511_SHIFT},
	{PMIC_RG_OTP_VAL_0_15, MT6328_PMIC_RG_OTP_VAL_0_15_ADDR, MT6328_PMIC_RG_OTP_VAL_0_15_MASK,
	 MT6328_PMIC_RG_OTP_VAL_0_15_SHIFT},
	{PMIC_RG_OTP_VAL_16_31, MT6328_PMIC_RG_OTP_VAL_16_31_ADDR,
	 MT6328_PMIC_RG_OTP_VAL_16_31_MASK, MT6328_PMIC_RG_OTP_VAL_16_31_SHIFT},
	{PMIC_RG_OTP_VAL_32_47, MT6328_PMIC_RG_OTP_VAL_32_47_ADDR,
	 MT6328_PMIC_RG_OTP_VAL_32_47_MASK, MT6328_PMIC_RG_OTP_VAL_32_47_SHIFT},
	{PMIC_RG_OTP_VAL_48_63, MT6328_PMIC_RG_OTP_VAL_48_63_ADDR,
	 MT6328_PMIC_RG_OTP_VAL_48_63_MASK, MT6328_PMIC_RG_OTP_VAL_48_63_SHIFT},
	{PMIC_RG_OTP_VAL_64_79, MT6328_PMIC_RG_OTP_VAL_64_79_ADDR,
	 MT6328_PMIC_RG_OTP_VAL_64_79_MASK, MT6328_PMIC_RG_OTP_VAL_64_79_SHIFT},
	{PMIC_RG_OTP_VAL_80_95, MT6328_PMIC_RG_OTP_VAL_80_95_ADDR,
	 MT6328_PMIC_RG_OTP_VAL_80_95_MASK, MT6328_PMIC_RG_OTP_VAL_80_95_SHIFT},
	{PMIC_RG_OTP_VAL_96_111, MT6328_PMIC_RG_OTP_VAL_96_111_ADDR,
	 MT6328_PMIC_RG_OTP_VAL_96_111_MASK, MT6328_PMIC_RG_OTP_VAL_96_111_SHIFT},
	{PMIC_RG_OTP_VAL_112_127, MT6328_PMIC_RG_OTP_VAL_112_127_ADDR,
	 MT6328_PMIC_RG_OTP_VAL_112_127_MASK, MT6328_PMIC_RG_OTP_VAL_112_127_SHIFT},
	{PMIC_RG_OTP_VAL_128_143, MT6328_PMIC_RG_OTP_VAL_128_143_ADDR,
	 MT6328_PMIC_RG_OTP_VAL_128_143_MASK, MT6328_PMIC_RG_OTP_VAL_128_143_SHIFT},
	{PMIC_RG_OTP_VAL_144_159, MT6328_PMIC_RG_OTP_VAL_144_159_ADDR,
	 MT6328_PMIC_RG_OTP_VAL_144_159_MASK, MT6328_PMIC_RG_OTP_VAL_144_159_SHIFT},
	{PMIC_RG_OTP_VAL_160_175, MT6328_PMIC_RG_OTP_VAL_160_175_ADDR,
	 MT6328_PMIC_RG_OTP_VAL_160_175_MASK, MT6328_PMIC_RG_OTP_VAL_160_175_SHIFT},
	{PMIC_RG_OTP_VAL_176_191, MT6328_PMIC_RG_OTP_VAL_176_191_ADDR,
	 MT6328_PMIC_RG_OTP_VAL_176_191_MASK, MT6328_PMIC_RG_OTP_VAL_176_191_SHIFT},
	{PMIC_RG_OTP_VAL_192_207, MT6328_PMIC_RG_OTP_VAL_192_207_ADDR,
	 MT6328_PMIC_RG_OTP_VAL_192_207_MASK, MT6328_PMIC_RG_OTP_VAL_192_207_SHIFT},
	{PMIC_RG_OTP_VAL_208_223, MT6328_PMIC_RG_OTP_VAL_208_223_ADDR,
	 MT6328_PMIC_RG_OTP_VAL_208_223_MASK, MT6328_PMIC_RG_OTP_VAL_208_223_SHIFT},
	{PMIC_RG_OTP_VAL_224_239, MT6328_PMIC_RG_OTP_VAL_224_239_ADDR,
	 MT6328_PMIC_RG_OTP_VAL_224_239_MASK, MT6328_PMIC_RG_OTP_VAL_224_239_SHIFT},
	{PMIC_RG_OTP_VAL_240_255, MT6328_PMIC_RG_OTP_VAL_240_255_ADDR,
	 MT6328_PMIC_RG_OTP_VAL_240_255_MASK, MT6328_PMIC_RG_OTP_VAL_240_255_SHIFT},
	{PMIC_RG_OTP_VAL_256_271, MT6328_PMIC_RG_OTP_VAL_256_271_ADDR,
	 MT6328_PMIC_RG_OTP_VAL_256_271_MASK, MT6328_PMIC_RG_OTP_VAL_256_271_SHIFT},
	{PMIC_RG_OTP_VAL_272_287, MT6328_PMIC_RG_OTP_VAL_272_287_ADDR,
	 MT6328_PMIC_RG_OTP_VAL_272_287_MASK, MT6328_PMIC_RG_OTP_VAL_272_287_SHIFT},
	{PMIC_RG_OTP_VAL_288_303, MT6328_PMIC_RG_OTP_VAL_288_303_ADDR,
	 MT6328_PMIC_RG_OTP_VAL_288_303_MASK, MT6328_PMIC_RG_OTP_VAL_288_303_SHIFT},
	{PMIC_RG_OTP_VAL_304_319, MT6328_PMIC_RG_OTP_VAL_304_319_ADDR,
	 MT6328_PMIC_RG_OTP_VAL_304_319_MASK, MT6328_PMIC_RG_OTP_VAL_304_319_SHIFT},
	{PMIC_RG_OTP_VAL_320_335, MT6328_PMIC_RG_OTP_VAL_320_335_ADDR,
	 MT6328_PMIC_RG_OTP_VAL_320_335_MASK, MT6328_PMIC_RG_OTP_VAL_320_335_SHIFT},
	{PMIC_RG_OTP_VAL_336_351, MT6328_PMIC_RG_OTP_VAL_336_351_ADDR,
	 MT6328_PMIC_RG_OTP_VAL_336_351_MASK, MT6328_PMIC_RG_OTP_VAL_336_351_SHIFT},
	{PMIC_RG_OTP_VAL_352_367, MT6328_PMIC_RG_OTP_VAL_352_367_ADDR,
	 MT6328_PMIC_RG_OTP_VAL_352_367_MASK, MT6328_PMIC_RG_OTP_VAL_352_367_SHIFT},
	{PMIC_RG_OTP_VAL_368_383, MT6328_PMIC_RG_OTP_VAL_368_383_ADDR,
	 MT6328_PMIC_RG_OTP_VAL_368_383_MASK, MT6328_PMIC_RG_OTP_VAL_368_383_SHIFT},
	{PMIC_RG_OTP_VAL_384_399, MT6328_PMIC_RG_OTP_VAL_384_399_ADDR,
	 MT6328_PMIC_RG_OTP_VAL_384_399_MASK, MT6328_PMIC_RG_OTP_VAL_384_399_SHIFT},
	{PMIC_RG_OTP_VAL_400_415, MT6328_PMIC_RG_OTP_VAL_400_415_ADDR,
	 MT6328_PMIC_RG_OTP_VAL_400_415_MASK, MT6328_PMIC_RG_OTP_VAL_400_415_SHIFT},
	{PMIC_RG_OTP_VAL_416_431, MT6328_PMIC_RG_OTP_VAL_416_431_ADDR,
	 MT6328_PMIC_RG_OTP_VAL_416_431_MASK, MT6328_PMIC_RG_OTP_VAL_416_431_SHIFT},
	{PMIC_RG_OTP_VAL_432_447, MT6328_PMIC_RG_OTP_VAL_432_447_ADDR,
	 MT6328_PMIC_RG_OTP_VAL_432_447_MASK, MT6328_PMIC_RG_OTP_VAL_432_447_SHIFT},
	{PMIC_RG_OTP_VAL_448_463, MT6328_PMIC_RG_OTP_VAL_448_463_ADDR,
	 MT6328_PMIC_RG_OTP_VAL_448_463_MASK, MT6328_PMIC_RG_OTP_VAL_448_463_SHIFT},
	{PMIC_RG_OTP_VAL_464_479, MT6328_PMIC_RG_OTP_VAL_464_479_ADDR,
	 MT6328_PMIC_RG_OTP_VAL_464_479_MASK, MT6328_PMIC_RG_OTP_VAL_464_479_SHIFT},
	{PMIC_RG_OTP_VAL_480_495, MT6328_PMIC_RG_OTP_VAL_480_495_ADDR,
	 MT6328_PMIC_RG_OTP_VAL_480_495_MASK, MT6328_PMIC_RG_OTP_VAL_480_495_SHIFT},
	{PMIC_RG_OTP_VAL_496_511, MT6328_PMIC_RG_OTP_VAL_496_511_ADDR,
	 MT6328_PMIC_RG_OTP_VAL_496_511_MASK, MT6328_PMIC_RG_OTP_VAL_496_511_SHIFT},
	{PMIC_MIX_EOSC32_STP_LPDTB, MT6328_PMIC_MIX_EOSC32_STP_LPDTB_ADDR,
	 MT6328_PMIC_MIX_EOSC32_STP_LPDTB_MASK, MT6328_PMIC_MIX_EOSC32_STP_LPDTB_SHIFT},
	{PMIC_MIX_EOSC32_STP_LPDEN, MT6328_PMIC_MIX_EOSC32_STP_LPDEN_ADDR,
	 MT6328_PMIC_MIX_EOSC32_STP_LPDEN_MASK, MT6328_PMIC_MIX_EOSC32_STP_LPDEN_SHIFT},
	{PMIC_MIX_XOSC32_STP_PWDB, MT6328_PMIC_MIX_XOSC32_STP_PWDB_ADDR,
	 MT6328_PMIC_MIX_XOSC32_STP_PWDB_MASK, MT6328_PMIC_MIX_XOSC32_STP_PWDB_SHIFT},
	{PMIC_MIX_XOSC32_STP_LPDTB, MT6328_PMIC_MIX_XOSC32_STP_LPDTB_ADDR,
	 MT6328_PMIC_MIX_XOSC32_STP_LPDTB_MASK, MT6328_PMIC_MIX_XOSC32_STP_LPDTB_SHIFT},
	{PMIC_MIX_XOSC32_STP_LPDEN, MT6328_PMIC_MIX_XOSC32_STP_LPDEN_ADDR,
	 MT6328_PMIC_MIX_XOSC32_STP_LPDEN_MASK, MT6328_PMIC_MIX_XOSC32_STP_LPDEN_SHIFT},
	{PMIC_MIX_XOSC32_STP_LPDRST, MT6328_PMIC_MIX_XOSC32_STP_LPDRST_ADDR,
	 MT6328_PMIC_MIX_XOSC32_STP_LPDRST_MASK, MT6328_PMIC_MIX_XOSC32_STP_LPDRST_SHIFT},
	{PMIC_MIX_XOSC32_STP_CALI, MT6328_PMIC_MIX_XOSC32_STP_CALI_ADDR,
	 MT6328_PMIC_MIX_XOSC32_STP_CALI_MASK, MT6328_PMIC_MIX_XOSC32_STP_CALI_SHIFT},
	{PMIC_STMP_MODE, MT6328_PMIC_STMP_MODE_ADDR, MT6328_PMIC_STMP_MODE_MASK,
	 MT6328_PMIC_STMP_MODE_SHIFT},
	{PMIC_MIX_EOSC32_STP_CHOP_EN, MT6328_PMIC_MIX_EOSC32_STP_CHOP_EN_ADDR,
	 MT6328_PMIC_MIX_EOSC32_STP_CHOP_EN_MASK, MT6328_PMIC_MIX_EOSC32_STP_CHOP_EN_SHIFT},
	{PMIC_MIX_DCXO_STP_LVSH_EN, MT6328_PMIC_MIX_DCXO_STP_LVSH_EN_ADDR,
	 MT6328_PMIC_MIX_DCXO_STP_LVSH_EN_MASK, MT6328_PMIC_MIX_DCXO_STP_LVSH_EN_SHIFT},
	{PMIC_MIX_PMU_STP_DDLO_VRTC, MT6328_PMIC_MIX_PMU_STP_DDLO_VRTC_ADDR,
	 MT6328_PMIC_MIX_PMU_STP_DDLO_VRTC_MASK, MT6328_PMIC_MIX_PMU_STP_DDLO_VRTC_SHIFT},
	{PMIC_MIX_PMU_STP_DDLO_VRTC_EN, MT6328_PMIC_MIX_PMU_STP_DDLO_VRTC_EN_ADDR,
	 MT6328_PMIC_MIX_PMU_STP_DDLO_VRTC_EN_MASK, MT6328_PMIC_MIX_PMU_STP_DDLO_VRTC_EN_SHIFT},
	{PMIC_MIX_RTC_STP_XOSC32_ENB, MT6328_PMIC_MIX_RTC_STP_XOSC32_ENB_ADDR,
	 MT6328_PMIC_MIX_RTC_STP_XOSC32_ENB_MASK, MT6328_PMIC_MIX_RTC_STP_XOSC32_ENB_SHIFT},
	{PMIC_MIX_DCXO_STP_TEST_DEGLITCH_MODE, MT6328_PMIC_MIX_DCXO_STP_TEST_DEGLITCH_MODE_ADDR,
	 MT6328_PMIC_MIX_DCXO_STP_TEST_DEGLITCH_MODE_MASK,
	 MT6328_PMIC_MIX_DCXO_STP_TEST_DEGLITCH_MODE_SHIFT},
	{PMIC_MIX_EOSC32_STP_RSV, MT6328_PMIC_MIX_EOSC32_STP_RSV_ADDR,
	 MT6328_PMIC_MIX_EOSC32_STP_RSV_MASK, MT6328_PMIC_MIX_EOSC32_STP_RSV_SHIFT},
	{PMIC_MIX_EOSC32_VCT_EN, MT6328_PMIC_MIX_EOSC32_VCT_EN_ADDR,
	 MT6328_PMIC_MIX_EOSC32_VCT_EN_MASK, MT6328_PMIC_MIX_EOSC32_VCT_EN_SHIFT},
	{PMIC_MIX_EOSC32_OPT, MT6328_PMIC_MIX_EOSC32_OPT_ADDR, MT6328_PMIC_MIX_EOSC32_OPT_MASK,
	 MT6328_PMIC_MIX_EOSC32_OPT_SHIFT},
	{PMIC_MIX_RTC_GPIO_COREDETB, MT6328_PMIC_MIX_RTC_GPIO_COREDETB_ADDR,
	 MT6328_PMIC_MIX_RTC_GPIO_COREDETB_MASK, MT6328_PMIC_MIX_RTC_GPIO_COREDETB_SHIFT},
	{PMIC_MIX_RTC_GPIO_F32KOB, MT6328_PMIC_MIX_RTC_GPIO_F32KOB_ADDR,
	 MT6328_PMIC_MIX_RTC_GPIO_F32KOB_MASK, MT6328_PMIC_MIX_RTC_GPIO_F32KOB_SHIFT},
	{PMIC_MIX_RTC_GPIO_GPO, MT6328_PMIC_MIX_RTC_GPIO_GPO_ADDR,
	 MT6328_PMIC_MIX_RTC_GPIO_GPO_MASK, MT6328_PMIC_MIX_RTC_GPIO_GPO_SHIFT},
	{PMIC_MIX_RTC_GPIO_OE, MT6328_PMIC_MIX_RTC_GPIO_OE_ADDR, MT6328_PMIC_MIX_RTC_GPIO_OE_MASK,
	 MT6328_PMIC_MIX_RTC_GPIO_OE_SHIFT},
	{PMIC_MIX_RTC_STP_DEBUG_OUT, MT6328_PMIC_MIX_RTC_STP_DEBUG_OUT_ADDR,
	 MT6328_PMIC_MIX_RTC_STP_DEBUG_OUT_MASK, MT6328_PMIC_MIX_RTC_STP_DEBUG_OUT_SHIFT},
	{PMIC_MIX_RTC_STP_DEBUG_SEL, MT6328_PMIC_MIX_RTC_STP_DEBUG_SEL_ADDR,
	 MT6328_PMIC_MIX_RTC_STP_DEBUG_SEL_MASK, MT6328_PMIC_MIX_RTC_STP_DEBUG_SEL_SHIFT},
	{PMIC_MIX_RTC_STP_K_EOSC32_EN, MT6328_PMIC_MIX_RTC_STP_K_EOSC32_EN_ADDR,
	 MT6328_PMIC_MIX_RTC_STP_K_EOSC32_EN_MASK, MT6328_PMIC_MIX_RTC_STP_K_EOSC32_EN_SHIFT},
	{PMIC_MIX_RTC_STP_EMBCK_SEL, MT6328_PMIC_MIX_RTC_STP_EMBCK_SEL_ADDR,
	 MT6328_PMIC_MIX_RTC_STP_EMBCK_SEL_MASK, MT6328_PMIC_MIX_RTC_STP_EMBCK_SEL_SHIFT},
	{PMIC_MIX_STP_BBWAKEUP, MT6328_PMIC_MIX_STP_BBWAKEUP_ADDR,
	 MT6328_PMIC_MIX_STP_BBWAKEUP_MASK, MT6328_PMIC_MIX_STP_BBWAKEUP_SHIFT},
	{PMIC_MIX_STP_RTC_DDLO, MT6328_PMIC_MIX_STP_RTC_DDLO_ADDR,
	 MT6328_PMIC_MIX_STP_RTC_DDLO_MASK, MT6328_PMIC_MIX_STP_RTC_DDLO_SHIFT},
	{PMIC_MIX_RTC_XOSC32_ENB, MT6328_PMIC_MIX_RTC_XOSC32_ENB_ADDR,
	 MT6328_PMIC_MIX_RTC_XOSC32_ENB_MASK, MT6328_PMIC_MIX_RTC_XOSC32_ENB_SHIFT},
	{PMIC_MIX_EFUSE_XOSC32_ENB_OPT, MT6328_PMIC_MIX_EFUSE_XOSC32_ENB_OPT_ADDR,
	 MT6328_PMIC_MIX_EFUSE_XOSC32_ENB_OPT_MASK, MT6328_PMIC_MIX_EFUSE_XOSC32_ENB_OPT_SHIFT},
	{PMIC_FG_ON, MT6328_PMIC_FG_ON_ADDR, MT6328_PMIC_FG_ON_MASK, MT6328_PMIC_FG_ON_SHIFT},
	{PMIC_FG_CAL, MT6328_PMIC_FG_CAL_ADDR, MT6328_PMIC_FG_CAL_MASK, MT6328_PMIC_FG_CAL_SHIFT},
	{PMIC_FG_AUTOCALRATE, MT6328_PMIC_FG_AUTOCALRATE_ADDR, MT6328_PMIC_FG_AUTOCALRATE_MASK,
	 MT6328_PMIC_FG_AUTOCALRATE_SHIFT},
	{PMIC_FG_SW_CR, MT6328_PMIC_FG_SW_CR_ADDR, MT6328_PMIC_FG_SW_CR_MASK,
	 MT6328_PMIC_FG_SW_CR_SHIFT},
	{PMIC_FG_SW_READ_PRE, MT6328_PMIC_FG_SW_READ_PRE_ADDR, MT6328_PMIC_FG_SW_READ_PRE_MASK,
	 MT6328_PMIC_FG_SW_READ_PRE_SHIFT},
	{PMIC_FG_LATCHDATA_ST, MT6328_PMIC_FG_LATCHDATA_ST_ADDR, MT6328_PMIC_FG_LATCHDATA_ST_MASK,
	 MT6328_PMIC_FG_LATCHDATA_ST_SHIFT},
	{PMIC_FG_SW_CLEAR, MT6328_PMIC_FG_SW_CLEAR_ADDR, MT6328_PMIC_FG_SW_CLEAR_MASK,
	 MT6328_PMIC_FG_SW_CLEAR_SHIFT},
	{PMIC_FG_OFFSET_RST, MT6328_PMIC_FG_OFFSET_RST_ADDR, MT6328_PMIC_FG_OFFSET_RST_MASK,
	 MT6328_PMIC_FG_OFFSET_RST_SHIFT},
	{PMIC_FG_TIME_RST, MT6328_PMIC_FG_TIME_RST_ADDR, MT6328_PMIC_FG_TIME_RST_MASK,
	 MT6328_PMIC_FG_TIME_RST_SHIFT},
	{PMIC_FG_CHARGE_RST, MT6328_PMIC_FG_CHARGE_RST_ADDR, MT6328_PMIC_FG_CHARGE_RST_MASK,
	 MT6328_PMIC_FG_CHARGE_RST_SHIFT},
	{PMIC_FG_SW_RSTCLR, MT6328_PMIC_FG_SW_RSTCLR_ADDR, MT6328_PMIC_FG_SW_RSTCLR_MASK,
	 MT6328_PMIC_FG_SW_RSTCLR_SHIFT},
	{PMIC_FG_CAR_31_16, MT6328_PMIC_FG_CAR_31_16_ADDR, MT6328_PMIC_FG_CAR_31_16_MASK,
	 MT6328_PMIC_FG_CAR_31_16_SHIFT},
	{PMIC_FG_CAR_15_00, MT6328_PMIC_FG_CAR_15_00_ADDR, MT6328_PMIC_FG_CAR_15_00_MASK,
	 MT6328_PMIC_FG_CAR_15_00_SHIFT},
	{PMIC_FG_NTER_29_16, MT6328_PMIC_FG_NTER_29_16_ADDR, MT6328_PMIC_FG_NTER_29_16_MASK,
	 MT6328_PMIC_FG_NTER_29_16_SHIFT},
	{PMIC_FG_NTER_15_00, MT6328_PMIC_FG_NTER_15_00_ADDR, MT6328_PMIC_FG_NTER_15_00_MASK,
	 MT6328_PMIC_FG_NTER_15_00_SHIFT},
	{PMIC_FG_BLTR, MT6328_PMIC_FG_BLTR_ADDR, MT6328_PMIC_FG_BLTR_MASK,
	 MT6328_PMIC_FG_BLTR_SHIFT},
	{PMIC_FG_BFTR, MT6328_PMIC_FG_BFTR_ADDR, MT6328_PMIC_FG_BFTR_MASK,
	 MT6328_PMIC_FG_BFTR_SHIFT},
	{PMIC_FG_CURRENT_OUT, MT6328_PMIC_FG_CURRENT_OUT_ADDR, MT6328_PMIC_FG_CURRENT_OUT_MASK,
	 MT6328_PMIC_FG_CURRENT_OUT_SHIFT},
	{PMIC_FG_ADJUST_OFFSET_VALUE, MT6328_PMIC_FG_ADJUST_OFFSET_VALUE_ADDR,
	 MT6328_PMIC_FG_ADJUST_OFFSET_VALUE_MASK, MT6328_PMIC_FG_ADJUST_OFFSET_VALUE_SHIFT},
	{PMIC_FG_OFFSET, MT6328_PMIC_FG_OFFSET_ADDR, MT6328_PMIC_FG_OFFSET_MASK,
	 MT6328_PMIC_FG_OFFSET_SHIFT},
	{PMIC_RG_FGANALOGTEST, MT6328_PMIC_RG_FGANALOGTEST_ADDR, MT6328_PMIC_RG_FGANALOGTEST_MASK,
	 MT6328_PMIC_RG_FGANALOGTEST_SHIFT},
	{PMIC_RG_FGINTMODE, MT6328_PMIC_RG_FGINTMODE_ADDR, MT6328_PMIC_RG_FGINTMODE_MASK,
	 MT6328_PMIC_RG_FGINTMODE_SHIFT},
	{PMIC_RG_SPARE, MT6328_PMIC_RG_SPARE_ADDR, MT6328_PMIC_RG_SPARE_MASK,
	 MT6328_PMIC_RG_SPARE_SHIFT},
	{PMIC_FG_OSR, MT6328_PMIC_FG_OSR_ADDR, MT6328_PMIC_FG_OSR_MASK, MT6328_PMIC_FG_OSR_SHIFT},
	{PMIC_FG_ADJ_OFFSET_EN, MT6328_PMIC_FG_ADJ_OFFSET_EN_ADDR,
	 MT6328_PMIC_FG_ADJ_OFFSET_EN_MASK, MT6328_PMIC_FG_ADJ_OFFSET_EN_SHIFT},
	{PMIC_FG_ADC_AUTORST, MT6328_PMIC_FG_ADC_AUTORST_ADDR, MT6328_PMIC_FG_ADC_AUTORST_MASK,
	 MT6328_PMIC_FG_ADC_AUTORST_SHIFT},
	{PMIC_FG_FIR1BYPASS, MT6328_PMIC_FG_FIR1BYPASS_ADDR, MT6328_PMIC_FG_FIR1BYPASS_MASK,
	 MT6328_PMIC_FG_FIR1BYPASS_SHIFT},
	{PMIC_FG_FIR2BYPASS, MT6328_PMIC_FG_FIR2BYPASS_ADDR, MT6328_PMIC_FG_FIR2BYPASS_MASK,
	 MT6328_PMIC_FG_FIR2BYPASS_SHIFT},
	{PMIC_FG_L_CUR_INT_STS, MT6328_PMIC_FG_L_CUR_INT_STS_ADDR,
	 MT6328_PMIC_FG_L_CUR_INT_STS_MASK, MT6328_PMIC_FG_L_CUR_INT_STS_SHIFT},
	{PMIC_FG_H_CUR_INT_STS, MT6328_PMIC_FG_H_CUR_INT_STS_ADDR,
	 MT6328_PMIC_FG_H_CUR_INT_STS_MASK, MT6328_PMIC_FG_H_CUR_INT_STS_SHIFT},
	{PMIC_FG_L_INT_STS, MT6328_PMIC_FG_L_INT_STS_ADDR, MT6328_PMIC_FG_L_INT_STS_MASK,
	 MT6328_PMIC_FG_L_INT_STS_SHIFT},
	{PMIC_FG_H_INT_STS, MT6328_PMIC_FG_H_INT_STS_ADDR, MT6328_PMIC_FG_H_INT_STS_MASK,
	 MT6328_PMIC_FG_H_INT_STS_SHIFT},
	{PMIC_FG_ADC_RSTDETECT, MT6328_PMIC_FG_ADC_RSTDETECT_ADDR,
	 MT6328_PMIC_FG_ADC_RSTDETECT_MASK, MT6328_PMIC_FG_ADC_RSTDETECT_SHIFT},
	{PMIC_FG_SLP_EN, MT6328_PMIC_FG_SLP_EN_ADDR, MT6328_PMIC_FG_SLP_EN_MASK,
	 MT6328_PMIC_FG_SLP_EN_SHIFT},
	{PMIC_FG_ZCV_DET_EN, MT6328_PMIC_FG_ZCV_DET_EN_ADDR, MT6328_PMIC_FG_ZCV_DET_EN_MASK,
	 MT6328_PMIC_FG_ZCV_DET_EN_SHIFT},
	{PMIC_RG_FG_AUXADC_R, MT6328_PMIC_RG_FG_AUXADC_R_ADDR, MT6328_PMIC_RG_FG_AUXADC_R_MASK,
	 MT6328_PMIC_RG_FG_AUXADC_R_SHIFT},
	{PMIC_FGADC_EN, MT6328_PMIC_FGADC_EN_ADDR, MT6328_PMIC_FGADC_EN_MASK,
	 MT6328_PMIC_FGADC_EN_SHIFT},
	{PMIC_FGCAL_EN, MT6328_PMIC_FGCAL_EN_ADDR, MT6328_PMIC_FGCAL_EN_MASK,
	 MT6328_PMIC_FGCAL_EN_SHIFT},
	{PMIC_FG_RST, MT6328_PMIC_FG_RST_ADDR, MT6328_PMIC_FG_RST_MASK, MT6328_PMIC_FG_RST_SHIFT},
	{PMIC_FG_CIC2, MT6328_PMIC_FG_CIC2_ADDR, MT6328_PMIC_FG_CIC2_MASK,
	 MT6328_PMIC_FG_CIC2_SHIFT},
	{PMIC_FG_SLP_CUR_TH, MT6328_PMIC_FG_SLP_CUR_TH_ADDR, MT6328_PMIC_FG_SLP_CUR_TH_MASK,
	 MT6328_PMIC_FG_SLP_CUR_TH_SHIFT},
	{PMIC_FG_SLP_TIME, MT6328_PMIC_FG_SLP_TIME_ADDR, MT6328_PMIC_FG_SLP_TIME_MASK,
	 MT6328_PMIC_FG_SLP_TIME_SHIFT},
	{PMIC_FG_SRCVOLTEN_FTIME, MT6328_PMIC_FG_SRCVOLTEN_FTIME_ADDR,
	 MT6328_PMIC_FG_SRCVOLTEN_FTIME_MASK, MT6328_PMIC_FG_SRCVOLTEN_FTIME_SHIFT},
	{PMIC_FG_DET_TIME, MT6328_PMIC_FG_DET_TIME_ADDR, MT6328_PMIC_FG_DET_TIME_MASK,
	 MT6328_PMIC_FG_DET_TIME_SHIFT},
	{PMIC_FG_ZCV_CAR_31_16, MT6328_PMIC_FG_ZCV_CAR_31_16_ADDR,
	 MT6328_PMIC_FG_ZCV_CAR_31_16_MASK, MT6328_PMIC_FG_ZCV_CAR_31_16_SHIFT},
	{PMIC_FG_ZCV_CAR_15_00, MT6328_PMIC_FG_ZCV_CAR_15_00_ADDR,
	 MT6328_PMIC_FG_ZCV_CAR_15_00_MASK, MT6328_PMIC_FG_ZCV_CAR_15_00_SHIFT},
	{PMIC_FG_ZCV_CURR, MT6328_PMIC_FG_ZCV_CURR_ADDR, MT6328_PMIC_FG_ZCV_CURR_MASK,
	 MT6328_PMIC_FG_ZCV_CURR_SHIFT},
	{PMIC_FG_R_CURR, MT6328_PMIC_FG_R_CURR_ADDR, MT6328_PMIC_FG_R_CURR_MASK,
	 MT6328_PMIC_FG_R_CURR_SHIFT},
	{PMIC_FG_MODE, MT6328_PMIC_FG_MODE_ADDR, MT6328_PMIC_FG_MODE_MASK,
	 MT6328_PMIC_FG_MODE_SHIFT},
	{PMIC_FG_RST_SW, MT6328_PMIC_FG_RST_SW_ADDR, MT6328_PMIC_FG_RST_SW_MASK,
	 MT6328_PMIC_FG_RST_SW_SHIFT},
	{PMIC_FG_FGCAL_EN_SW, MT6328_PMIC_FG_FGCAL_EN_SW_ADDR, MT6328_PMIC_FG_FGCAL_EN_SW_MASK,
	 MT6328_PMIC_FG_FGCAL_EN_SW_SHIFT},
	{PMIC_FG_FGADC_EN_SW, MT6328_PMIC_FG_FGADC_EN_SW_ADDR, MT6328_PMIC_FG_FGADC_EN_SW_MASK,
	 MT6328_PMIC_FG_FGADC_EN_SW_SHIFT},
	{PMIC_FG_RSV1, MT6328_PMIC_FG_RSV1_ADDR, MT6328_PMIC_FG_RSV1_MASK,
	 MT6328_PMIC_FG_RSV1_SHIFT},
	{PMIC_FG_TEST_MODE0, MT6328_PMIC_FG_TEST_MODE0_ADDR, MT6328_PMIC_FG_TEST_MODE0_MASK,
	 MT6328_PMIC_FG_TEST_MODE0_SHIFT},
	{PMIC_FG_TEST_MODE1, MT6328_PMIC_FG_TEST_MODE1_ADDR, MT6328_PMIC_FG_TEST_MODE1_MASK,
	 MT6328_PMIC_FG_TEST_MODE1_SHIFT},
	{PMIC_FG_GAIN, MT6328_PMIC_FG_GAIN_ADDR, MT6328_PMIC_FG_GAIN_MASK,
	 MT6328_PMIC_FG_GAIN_SHIFT},
	{PMIC_FG_CUR_HTH, MT6328_PMIC_FG_CUR_HTH_ADDR, MT6328_PMIC_FG_CUR_HTH_MASK,
	 MT6328_PMIC_FG_CUR_HTH_SHIFT},
	{PMIC_FG_CUR_LTH, MT6328_PMIC_FG_CUR_LTH_ADDR, MT6328_PMIC_FG_CUR_LTH_MASK,
	 MT6328_PMIC_FG_CUR_LTH_SHIFT},
	{PMIC_FG_ZCV_DET_TIME, MT6328_PMIC_FG_ZCV_DET_TIME_ADDR, MT6328_PMIC_FG_ZCV_DET_TIME_MASK,
	 MT6328_PMIC_FG_ZCV_DET_TIME_SHIFT},
	{PMIC_FG_ZCV_CAR_TH_30_16, MT6328_PMIC_FG_ZCV_CAR_TH_30_16_ADDR,
	 MT6328_PMIC_FG_ZCV_CAR_TH_30_16_MASK, MT6328_PMIC_FG_ZCV_CAR_TH_30_16_SHIFT},
	{PMIC_FG_ZCV_CAR_TH_15_00, MT6328_PMIC_FG_ZCV_CAR_TH_15_00_ADDR,
	 MT6328_PMIC_FG_ZCV_CAR_TH_15_00_MASK, MT6328_PMIC_FG_ZCV_CAR_TH_15_00_SHIFT},
	{PMIC_RG_AUDDACLPWRUP_VAUDP15, MT6328_PMIC_RG_AUDDACLPWRUP_VAUDP15_ADDR,
	 MT6328_PMIC_RG_AUDDACLPWRUP_VAUDP15_MASK, MT6328_PMIC_RG_AUDDACLPWRUP_VAUDP15_SHIFT},
	{PMIC_RG_AUDDACRPWRUP_VAUDP15, MT6328_PMIC_RG_AUDDACRPWRUP_VAUDP15_ADDR,
	 MT6328_PMIC_RG_AUDDACRPWRUP_VAUDP15_MASK, MT6328_PMIC_RG_AUDDACRPWRUP_VAUDP15_SHIFT},
	{PMIC_RG_AUD_DAC_PWR_UP_VA28, MT6328_PMIC_RG_AUD_DAC_PWR_UP_VA28_ADDR,
	 MT6328_PMIC_RG_AUD_DAC_PWR_UP_VA28_MASK, MT6328_PMIC_RG_AUD_DAC_PWR_UP_VA28_SHIFT},
	{PMIC_RG_AUD_DAC_PWL_UP_VA28, MT6328_PMIC_RG_AUD_DAC_PWL_UP_VA28_ADDR,
	 MT6328_PMIC_RG_AUD_DAC_PWL_UP_VA28_MASK, MT6328_PMIC_RG_AUD_DAC_PWL_UP_VA28_SHIFT},
	{PMIC_RG_AUDHSPWRUP_VAUDP15, MT6328_PMIC_RG_AUDHSPWRUP_VAUDP15_ADDR,
	 MT6328_PMIC_RG_AUDHSPWRUP_VAUDP15_MASK, MT6328_PMIC_RG_AUDHSPWRUP_VAUDP15_SHIFT},
	{PMIC_RG_AUDHPLPWRUP_VAUDP15, MT6328_PMIC_RG_AUDHPLPWRUP_VAUDP15_ADDR,
	 MT6328_PMIC_RG_AUDHPLPWRUP_VAUDP15_MASK, MT6328_PMIC_RG_AUDHPLPWRUP_VAUDP15_SHIFT},
	{PMIC_RG_AUDHPRPWRUP_VAUDP15, MT6328_PMIC_RG_AUDHPRPWRUP_VAUDP15_ADDR,
	 MT6328_PMIC_RG_AUDHPRPWRUP_VAUDP15_MASK, MT6328_PMIC_RG_AUDHPRPWRUP_VAUDP15_SHIFT},
	{PMIC_RG_AUDHSMUXINPUTSEL_VAUDP15, MT6328_PMIC_RG_AUDHSMUXINPUTSEL_VAUDP15_ADDR,
	 MT6328_PMIC_RG_AUDHSMUXINPUTSEL_VAUDP15_MASK,
	 MT6328_PMIC_RG_AUDHSMUXINPUTSEL_VAUDP15_SHIFT},
	{PMIC_RG_AUDHPLMUXINPUTSEL_VAUDP15, MT6328_PMIC_RG_AUDHPLMUXINPUTSEL_VAUDP15_ADDR,
	 MT6328_PMIC_RG_AUDHPLMUXINPUTSEL_VAUDP15_MASK,
	 MT6328_PMIC_RG_AUDHPLMUXINPUTSEL_VAUDP15_SHIFT},
	{PMIC_RG_AUDHPRMUXINPUTSEL_VAUDP15, MT6328_PMIC_RG_AUDHPRMUXINPUTSEL_VAUDP15_ADDR,
	 MT6328_PMIC_RG_AUDHPRMUXINPUTSEL_VAUDP15_MASK,
	 MT6328_PMIC_RG_AUDHPRMUXINPUTSEL_VAUDP15_SHIFT},
	{PMIC_RG_AUDHSSCDISABLE_VAUDP15, MT6328_PMIC_RG_AUDHSSCDISABLE_VAUDP15_ADDR,
	 MT6328_PMIC_RG_AUDHSSCDISABLE_VAUDP15_MASK, MT6328_PMIC_RG_AUDHSSCDISABLE_VAUDP15_SHIFT},
	{PMIC_RG_AUDHPLSCDISABLE_VAUDP15, MT6328_PMIC_RG_AUDHPLSCDISABLE_VAUDP15_ADDR,
	 MT6328_PMIC_RG_AUDHPLSCDISABLE_VAUDP15_MASK, MT6328_PMIC_RG_AUDHPLSCDISABLE_VAUDP15_SHIFT},
	{PMIC_RG_AUDHPRSCDISABLE_VAUDP15, MT6328_PMIC_RG_AUDHPRSCDISABLE_VAUDP15_ADDR,
	 MT6328_PMIC_RG_AUDHPRSCDISABLE_VAUDP15_MASK, MT6328_PMIC_RG_AUDHPRSCDISABLE_VAUDP15_SHIFT},
	{PMIC_RG_AUDHPLBSCCURRENT_VAUDP15, MT6328_PMIC_RG_AUDHPLBSCCURRENT_VAUDP15_ADDR,
	 MT6328_PMIC_RG_AUDHPLBSCCURRENT_VAUDP15_MASK,
	 MT6328_PMIC_RG_AUDHPLBSCCURRENT_VAUDP15_SHIFT},
	{PMIC_RG_AUDHPRBSCCURRENT_VAUDP15, MT6328_PMIC_RG_AUDHPRBSCCURRENT_VAUDP15_ADDR,
	 MT6328_PMIC_RG_AUDHPRBSCCURRENT_VAUDP15_MASK,
	 MT6328_PMIC_RG_AUDHPRBSCCURRENT_VAUDP15_SHIFT},
	{PMIC_RG_AUDHSBSCCURRENT_VAUDP15, MT6328_PMIC_RG_AUDHSBSCCURRENT_VAUDP15_ADDR,
	 MT6328_PMIC_RG_AUDHSBSCCURRENT_VAUDP15_MASK, MT6328_PMIC_RG_AUDHSBSCCURRENT_VAUDP15_SHIFT},
	{PMIC_RG_AUDHPSTARTUP_VAUDP15, MT6328_PMIC_RG_AUDHPSTARTUP_VAUDP15_ADDR,
	 MT6328_PMIC_RG_AUDHPSTARTUP_VAUDP15_MASK, MT6328_PMIC_RG_AUDHPSTARTUP_VAUDP15_SHIFT},
	{PMIC_RG_AUDHSSTARTUP_VAUDP15, MT6328_PMIC_RG_AUDHSSTARTUP_VAUDP15_ADDR,
	 MT6328_PMIC_RG_AUDHSSTARTUP_VAUDP15_MASK, MT6328_PMIC_RG_AUDHSSTARTUP_VAUDP15_SHIFT},
	{PMIC_RG_PRECHARGEBUF_EN_VAUDP15, MT6328_PMIC_RG_PRECHARGEBUF_EN_VAUDP15_ADDR,
	 MT6328_PMIC_RG_PRECHARGEBUF_EN_VAUDP15_MASK, MT6328_PMIC_RG_PRECHARGEBUF_EN_VAUDP15_SHIFT},
	{PMIC_RG_HPINPUTSTBENH_VAUDP15, MT6328_PMIC_RG_HPINPUTSTBENH_VAUDP15_ADDR,
	 MT6328_PMIC_RG_HPINPUTSTBENH_VAUDP15_MASK, MT6328_PMIC_RG_HPINPUTSTBENH_VAUDP15_SHIFT},
	{PMIC_RG_HPOUTPUTSTBENH_VAUDP15, MT6328_PMIC_RG_HPOUTPUTSTBENH_VAUDP15_ADDR,
	 MT6328_PMIC_RG_HPOUTPUTSTBENH_VAUDP15_MASK, MT6328_PMIC_RG_HPOUTPUTSTBENH_VAUDP15_SHIFT},
	{PMIC_RG_HPINPUTRESET0_VAUDP15, MT6328_PMIC_RG_HPINPUTRESET0_VAUDP15_ADDR,
	 MT6328_PMIC_RG_HPINPUTRESET0_VAUDP15_MASK, MT6328_PMIC_RG_HPINPUTRESET0_VAUDP15_SHIFT},
	{PMIC_RG_HPOUTPUTRESET0_VAUDP15, MT6328_PMIC_RG_HPOUTPUTRESET0_VAUDP15_ADDR,
	 MT6328_PMIC_RG_HPOUTPUTRESET0_VAUDP15_MASK, MT6328_PMIC_RG_HPOUTPUTRESET0_VAUDP15_SHIFT},
	{PMIC_RG_HPOUT_SHORTVCM_VAUDP15, MT6328_PMIC_RG_HPOUT_SHORTVCM_VAUDP15_ADDR,
	 MT6328_PMIC_RG_HPOUT_SHORTVCM_VAUDP15_MASK, MT6328_PMIC_RG_HPOUT_SHORTVCM_VAUDP15_SHIFT},
	{PMIC_RG_HSINPUTSTBENH_VAUDP15, MT6328_PMIC_RG_HSINPUTSTBENH_VAUDP15_ADDR,
	 MT6328_PMIC_RG_HSINPUTSTBENH_VAUDP15_MASK, MT6328_PMIC_RG_HSINPUTSTBENH_VAUDP15_SHIFT},
	{PMIC_RG_HSOUTPUTSTBENH_VAUDP15, MT6328_PMIC_RG_HSOUTPUTSTBENH_VAUDP15_ADDR,
	 MT6328_PMIC_RG_HSOUTPUTSTBENH_VAUDP15_MASK, MT6328_PMIC_RG_HSOUTPUTSTBENH_VAUDP15_SHIFT},
	{PMIC_RG_HSINPUTRESET0_VAUDP15, MT6328_PMIC_RG_HSINPUTRESET0_VAUDP15_ADDR,
	 MT6328_PMIC_RG_HSINPUTRESET0_VAUDP15_MASK, MT6328_PMIC_RG_HSINPUTRESET0_VAUDP15_SHIFT},
	{PMIC_RG_HSOUTPUTRESET0_VAUDP15, MT6328_PMIC_RG_HSOUTPUTRESET0_VAUDP15_ADDR,
	 MT6328_PMIC_RG_HSOUTPUTRESET0_VAUDP15_MASK, MT6328_PMIC_RG_HSOUTPUTRESET0_VAUDP15_SHIFT},
	{PMIC_RG_HPOUTSTB_RSEL_VAUDP15, MT6328_PMIC_RG_HPOUTSTB_RSEL_VAUDP15_ADDR,
	 MT6328_PMIC_RG_HPOUTSTB_RSEL_VAUDP15_MASK, MT6328_PMIC_RG_HPOUTSTB_RSEL_VAUDP15_SHIFT},
	{PMIC_RG_HSOUT_SHORTVCM_VAUDP15, MT6328_PMIC_RG_HSOUT_SHORTVCM_VAUDP15_ADDR,
	 MT6328_PMIC_RG_HSOUT_SHORTVCM_VAUDP15_MASK, MT6328_PMIC_RG_HSOUT_SHORTVCM_VAUDP15_SHIFT},
	{PMIC_RG_AUDHPLTRIM_VAUDP15, MT6328_PMIC_RG_AUDHPLTRIM_VAUDP15_ADDR,
	 MT6328_PMIC_RG_AUDHPLTRIM_VAUDP15_MASK, MT6328_PMIC_RG_AUDHPLTRIM_VAUDP15_SHIFT},
	{PMIC_RG_AUDHPRTRIM_VAUDP15, MT6328_PMIC_RG_AUDHPRTRIM_VAUDP15_ADDR,
	 MT6328_PMIC_RG_AUDHPRTRIM_VAUDP15_MASK, MT6328_PMIC_RG_AUDHPRTRIM_VAUDP15_SHIFT},
	{PMIC_RG_AUDHPTRIM_EN_VAUDP15, MT6328_PMIC_RG_AUDHPTRIM_EN_VAUDP15_ADDR,
	 MT6328_PMIC_RG_AUDHPTRIM_EN_VAUDP15_MASK, MT6328_PMIC_RG_AUDHPTRIM_EN_VAUDP15_SHIFT},
	{PMIC_RG_AUDHPLFINETRIM_VAUDP15, MT6328_PMIC_RG_AUDHPLFINETRIM_VAUDP15_ADDR,
	 MT6328_PMIC_RG_AUDHPLFINETRIM_VAUDP15_MASK, MT6328_PMIC_RG_AUDHPLFINETRIM_VAUDP15_SHIFT},
	{PMIC_RG_AUDHPRFINETRIM_VAUDP15, MT6328_PMIC_RG_AUDHPRFINETRIM_VAUDP15_ADDR,
	 MT6328_PMIC_RG_AUDHPRFINETRIM_VAUDP15_MASK, MT6328_PMIC_RG_AUDHPRFINETRIM_VAUDP15_SHIFT},
	{PMIC_RG_AUDTRIMBUF_EN_VAUDP15, MT6328_PMIC_RG_AUDTRIMBUF_EN_VAUDP15_ADDR,
	 MT6328_PMIC_RG_AUDTRIMBUF_EN_VAUDP15_MASK, MT6328_PMIC_RG_AUDTRIMBUF_EN_VAUDP15_SHIFT},
	{PMIC_RG_AUDTRIMBUF_INPUTMUXSEL_VAUDP15, MT6328_PMIC_RG_AUDTRIMBUF_INPUTMUXSEL_VAUDP15_ADDR,
	 MT6328_PMIC_RG_AUDTRIMBUF_INPUTMUXSEL_VAUDP15_MASK,
	 MT6328_PMIC_RG_AUDTRIMBUF_INPUTMUXSEL_VAUDP15_SHIFT},
	{PMIC_RG_AUDTRIMBUF_GAINSEL_VAUDP15, MT6328_PMIC_RG_AUDTRIMBUF_GAINSEL_VAUDP15_ADDR,
	 MT6328_PMIC_RG_AUDTRIMBUF_GAINSEL_VAUDP15_MASK,
	 MT6328_PMIC_RG_AUDTRIMBUF_GAINSEL_VAUDP15_SHIFT},
	{PMIC_RG_AUDHPSPKDET_EN_VAUDP15, MT6328_PMIC_RG_AUDHPSPKDET_EN_VAUDP15_ADDR,
	 MT6328_PMIC_RG_AUDHPSPKDET_EN_VAUDP15_MASK, MT6328_PMIC_RG_AUDHPSPKDET_EN_VAUDP15_SHIFT},
	{PMIC_RG_AUDHPSPKDET_INPUTMUXSEL_VAUDP15,
	 MT6328_PMIC_RG_AUDHPSPKDET_INPUTMUXSEL_VAUDP15_ADDR,
	 MT6328_PMIC_RG_AUDHPSPKDET_INPUTMUXSEL_VAUDP15_MASK,
	 MT6328_PMIC_RG_AUDHPSPKDET_INPUTMUXSEL_VAUDP15_SHIFT},
	{PMIC_RG_AUDHPSPKDET_OUTPUTMUXSEL_VAUDP15,
	 MT6328_PMIC_RG_AUDHPSPKDET_OUTPUTMUXSEL_VAUDP15_ADDR,
	 MT6328_PMIC_RG_AUDHPSPKDET_OUTPUTMUXSEL_VAUDP15_MASK,
	 MT6328_PMIC_RG_AUDHPSPKDET_OUTPUTMUXSEL_VAUDP15_SHIFT},
	{PMIC_RG_ABIDEC_RESERVED_VA28, MT6328_PMIC_RG_ABIDEC_RESERVED_VA28_ADDR,
	 MT6328_PMIC_RG_ABIDEC_RESERVED_VA28_MASK, MT6328_PMIC_RG_ABIDEC_RESERVED_VA28_SHIFT},
	{PMIC_RG_ABIDEC_RESERVED_VAUDP15, MT6328_PMIC_RG_ABIDEC_RESERVED_VAUDP15_ADDR,
	 MT6328_PMIC_RG_ABIDEC_RESERVED_VAUDP15_MASK, MT6328_PMIC_RG_ABIDEC_RESERVED_VAUDP15_SHIFT},
	{PMIC_RG_AUDBIASADJ_0_VAUDP15, MT6328_PMIC_RG_AUDBIASADJ_0_VAUDP15_ADDR,
	 MT6328_PMIC_RG_AUDBIASADJ_0_VAUDP15_MASK, MT6328_PMIC_RG_AUDBIASADJ_0_VAUDP15_SHIFT},
	{PMIC_RG_AUDBIASADJ_1_VAUDP15, MT6328_PMIC_RG_AUDBIASADJ_1_VAUDP15_ADDR,
	 MT6328_PMIC_RG_AUDBIASADJ_1_VAUDP15_MASK, MT6328_PMIC_RG_AUDBIASADJ_1_VAUDP15_SHIFT},
	{PMIC_RG_AUDIBIASPWRDN_VAUDP15, MT6328_PMIC_RG_AUDIBIASPWRDN_VAUDP15_ADDR,
	 MT6328_PMIC_RG_AUDIBIASPWRDN_VAUDP15_MASK, MT6328_PMIC_RG_AUDIBIASPWRDN_VAUDP15_SHIFT},
	{PMIC_RG_RSTB_DECODER_VA28, MT6328_PMIC_RG_RSTB_DECODER_VA28_ADDR,
	 MT6328_PMIC_RG_RSTB_DECODER_VA28_MASK, MT6328_PMIC_RG_RSTB_DECODER_VA28_SHIFT},
	{PMIC_RG_RSTB_ENCODER_VA28, MT6328_PMIC_RG_RSTB_ENCODER_VA28_ADDR,
	 MT6328_PMIC_RG_RSTB_ENCODER_VA28_MASK, MT6328_PMIC_RG_RSTB_ENCODER_VA28_SHIFT},
	{PMIC_RG_SEL_DECODER_96K_VA28, MT6328_PMIC_RG_SEL_DECODER_96K_VA28_ADDR,
	 MT6328_PMIC_RG_SEL_DECODER_96K_VA28_MASK, MT6328_PMIC_RG_SEL_DECODER_96K_VA28_SHIFT},
	{PMIC_RG_SEL_ENCODER_96K_VA28, MT6328_PMIC_RG_SEL_ENCODER_96K_VA28_ADDR,
	 MT6328_PMIC_RG_SEL_ENCODER_96K_VA28_MASK, MT6328_PMIC_RG_SEL_ENCODER_96K_VA28_SHIFT},
	{PMIC_RG_SEL_DELAY_VCORE, MT6328_PMIC_RG_SEL_DELAY_VCORE_ADDR,
	 MT6328_PMIC_RG_SEL_DELAY_VCORE_MASK, MT6328_PMIC_RG_SEL_DELAY_VCORE_SHIFT},
	{PMIC_RG_HCLDO_EN_VA18, MT6328_PMIC_RG_HCLDO_EN_VA18_ADDR,
	 MT6328_PMIC_RG_HCLDO_EN_VA18_MASK, MT6328_PMIC_RG_HCLDO_EN_VA18_SHIFT},
	{PMIC_RG_LCLDO_EN_VA18, MT6328_PMIC_RG_LCLDO_EN_VA18_ADDR,
	 MT6328_PMIC_RG_LCLDO_EN_VA18_MASK, MT6328_PMIC_RG_LCLDO_EN_VA18_SHIFT},
	{PMIC_RG_LCLDO_ENC_EN_VA28, MT6328_PMIC_RG_LCLDO_ENC_EN_VA28_ADDR,
	 MT6328_PMIC_RG_LCLDO_ENC_EN_VA28_MASK, MT6328_PMIC_RG_LCLDO_ENC_EN_VA28_SHIFT},
	{PMIC_RG_VA33REFGEN_EN_VA18, MT6328_PMIC_RG_VA33REFGEN_EN_VA18_ADDR,
	 MT6328_PMIC_RG_VA33REFGEN_EN_VA18_MASK, MT6328_PMIC_RG_VA33REFGEN_EN_VA18_SHIFT},
	{PMIC_RG_HCLDO_PDDIS_EN_VA18, MT6328_PMIC_RG_HCLDO_PDDIS_EN_VA18_ADDR,
	 MT6328_PMIC_RG_HCLDO_PDDIS_EN_VA18_MASK, MT6328_PMIC_RG_HCLDO_PDDIS_EN_VA18_SHIFT},
	{PMIC_RG_HCLDO_REMOTE_SENSE_VA18, MT6328_PMIC_RG_HCLDO_REMOTE_SENSE_VA18_ADDR,
	 MT6328_PMIC_RG_HCLDO_REMOTE_SENSE_VA18_MASK, MT6328_PMIC_RG_HCLDO_REMOTE_SENSE_VA18_SHIFT},
	{PMIC_RG_LCLDO_PDDIS_EN_VA18, MT6328_PMIC_RG_LCLDO_PDDIS_EN_VA18_ADDR,
	 MT6328_PMIC_RG_LCLDO_PDDIS_EN_VA18_MASK, MT6328_PMIC_RG_LCLDO_PDDIS_EN_VA18_SHIFT},
	{PMIC_RG_LCLDO_REMOTE_SENSE_VA18, MT6328_PMIC_RG_LCLDO_REMOTE_SENSE_VA18_ADDR,
	 MT6328_PMIC_RG_LCLDO_REMOTE_SENSE_VA18_MASK, MT6328_PMIC_RG_LCLDO_REMOTE_SENSE_VA18_SHIFT},
	{PMIC_RG_LCLDO_VOSEL_VA18, MT6328_PMIC_RG_LCLDO_VOSEL_VA18_ADDR,
	 MT6328_PMIC_RG_LCLDO_VOSEL_VA18_MASK, MT6328_PMIC_RG_LCLDO_VOSEL_VA18_SHIFT},
	{PMIC_RG_HCLDO_VOSEL_VA18, MT6328_PMIC_RG_HCLDO_VOSEL_VA18_ADDR,
	 MT6328_PMIC_RG_HCLDO_VOSEL_VA18_MASK, MT6328_PMIC_RG_HCLDO_VOSEL_VA18_SHIFT},
	{PMIC_RG_LCLDO_ENC_PDDIS_EN_VA28, MT6328_PMIC_RG_LCLDO_ENC_PDDIS_EN_VA28_ADDR,
	 MT6328_PMIC_RG_LCLDO_ENC_PDDIS_EN_VA28_MASK, MT6328_PMIC_RG_LCLDO_ENC_PDDIS_EN_VA28_SHIFT},
	{PMIC_RG_LCLDO_ENC_REMOTE_SENSE_VA28, MT6328_PMIC_RG_LCLDO_ENC_REMOTE_SENSE_VA28_ADDR,
	 MT6328_PMIC_RG_LCLDO_ENC_REMOTE_SENSE_VA28_MASK,
	 MT6328_PMIC_RG_LCLDO_ENC_REMOTE_SENSE_VA28_SHIFT},
	{PMIC_RG_VA28REFGEN_EN_VA28, MT6328_PMIC_RG_VA28REFGEN_EN_VA28_ADDR,
	 MT6328_PMIC_RG_VA28REFGEN_EN_VA28_MASK, MT6328_PMIC_RG_VA28REFGEN_EN_VA28_SHIFT},
	{PMIC_RG_AUDPMU_RESERVED_VA28, MT6328_PMIC_RG_AUDPMU_RESERVED_VA28_ADDR,
	 MT6328_PMIC_RG_AUDPMU_RESERVED_VA28_MASK, MT6328_PMIC_RG_AUDPMU_RESERVED_VA28_SHIFT},
	{PMIC_RG_AUDPMU_RESERVED_VA18, MT6328_PMIC_RG_AUDPMU_RESERVED_VA18_ADDR,
	 MT6328_PMIC_RG_AUDPMU_RESERVED_VA18_MASK, MT6328_PMIC_RG_AUDPMU_RESERVED_VA18_SHIFT},
	{PMIC_RG_AUDPMU_RESERVED_VAUDP15, MT6328_PMIC_RG_AUDPMU_RESERVED_VAUDP15_ADDR,
	 MT6328_PMIC_RG_AUDPMU_RESERVED_VAUDP15_MASK, MT6328_PMIC_RG_AUDPMU_RESERVED_VAUDP15_SHIFT},
	{PMIC_RG_NVREG_EN_VAUDP15, MT6328_PMIC_RG_NVREG_EN_VAUDP15_ADDR,
	 MT6328_PMIC_RG_NVREG_EN_VAUDP15_MASK, MT6328_PMIC_RG_NVREG_EN_VAUDP15_SHIFT},
	{PMIC_RG_NVREG_PULL0V_VAUDP15, MT6328_PMIC_RG_NVREG_PULL0V_VAUDP15_ADDR,
	 MT6328_PMIC_RG_NVREG_PULL0V_VAUDP15_MASK, MT6328_PMIC_RG_NVREG_PULL0V_VAUDP15_SHIFT},
	{PMIC_RG_AUDGLB_PWRDN_VA28, MT6328_PMIC_RG_AUDGLB_PWRDN_VA28_ADDR,
	 MT6328_PMIC_RG_AUDGLB_PWRDN_VA28_MASK, MT6328_PMIC_RG_AUDGLB_PWRDN_VA28_SHIFT},
	{PMIC_RG_AUDPREAMPLON, MT6328_PMIC_RG_AUDPREAMPLON_ADDR, MT6328_PMIC_RG_AUDPREAMPLON_MASK,
	 MT6328_PMIC_RG_AUDPREAMPLON_SHIFT},
	{PMIC_RG_AUDPREAMPLDCCEN, MT6328_PMIC_RG_AUDPREAMPLDCCEN_ADDR,
	 MT6328_PMIC_RG_AUDPREAMPLDCCEN_MASK, MT6328_PMIC_RG_AUDPREAMPLDCCEN_SHIFT},
	{PMIC_RG_AUDPREAMPLDCRPECHARGE, MT6328_PMIC_RG_AUDPREAMPLDCRPECHARGE_ADDR,
	 MT6328_PMIC_RG_AUDPREAMPLDCRPECHARGE_MASK, MT6328_PMIC_RG_AUDPREAMPLDCRPECHARGE_SHIFT},
	{PMIC_RG_AUDPREAMPLPGATEST, MT6328_PMIC_RG_AUDPREAMPLPGATEST_ADDR,
	 MT6328_PMIC_RG_AUDPREAMPLPGATEST_MASK, MT6328_PMIC_RG_AUDPREAMPLPGATEST_SHIFT},
	{PMIC_RG_AUDPREAMPLVSCALE, MT6328_PMIC_RG_AUDPREAMPLVSCALE_ADDR,
	 MT6328_PMIC_RG_AUDPREAMPLVSCALE_MASK, MT6328_PMIC_RG_AUDPREAMPLVSCALE_SHIFT},
	{PMIC_RG_AUDPREAMPLINPUTSEL, MT6328_PMIC_RG_AUDPREAMPLINPUTSEL_ADDR,
	 MT6328_PMIC_RG_AUDPREAMPLINPUTSEL_MASK, MT6328_PMIC_RG_AUDPREAMPLINPUTSEL_SHIFT},
	{PMIC_RG_AUDADCLPWRUP, MT6328_PMIC_RG_AUDADCLPWRUP_ADDR, MT6328_PMIC_RG_AUDADCLPWRUP_MASK,
	 MT6328_PMIC_RG_AUDADCLPWRUP_SHIFT},
	{PMIC_RG_AUDADCLINPUTSEL, MT6328_PMIC_RG_AUDADCLINPUTSEL_ADDR,
	 MT6328_PMIC_RG_AUDADCLINPUTSEL_MASK, MT6328_PMIC_RG_AUDADCLINPUTSEL_SHIFT},
	{PMIC_RG_AUDPREAMPRON, MT6328_PMIC_RG_AUDPREAMPRON_ADDR, MT6328_PMIC_RG_AUDPREAMPRON_MASK,
	 MT6328_PMIC_RG_AUDPREAMPRON_SHIFT},
	{PMIC_RG_AUDPREAMPRDCCEN, MT6328_PMIC_RG_AUDPREAMPRDCCEN_ADDR,
	 MT6328_PMIC_RG_AUDPREAMPRDCCEN_MASK, MT6328_PMIC_RG_AUDPREAMPRDCCEN_SHIFT},
	{PMIC_RG_AUDPREAMPRDCRPECHARGE, MT6328_PMIC_RG_AUDPREAMPRDCRPECHARGE_ADDR,
	 MT6328_PMIC_RG_AUDPREAMPRDCRPECHARGE_MASK, MT6328_PMIC_RG_AUDPREAMPRDCRPECHARGE_SHIFT},
	{PMIC_RG_AUDPREAMPRPGATEST, MT6328_PMIC_RG_AUDPREAMPRPGATEST_ADDR,
	 MT6328_PMIC_RG_AUDPREAMPRPGATEST_MASK, MT6328_PMIC_RG_AUDPREAMPRPGATEST_SHIFT},
	{PMIC_RG_AUDPREAMPRVSCALE, MT6328_PMIC_RG_AUDPREAMPRVSCALE_ADDR,
	 MT6328_PMIC_RG_AUDPREAMPRVSCALE_MASK, MT6328_PMIC_RG_AUDPREAMPRVSCALE_SHIFT},
	{PMIC_RG_AUDPREAMPRINPUTSEL, MT6328_PMIC_RG_AUDPREAMPRINPUTSEL_ADDR,
	 MT6328_PMIC_RG_AUDPREAMPRINPUTSEL_MASK, MT6328_PMIC_RG_AUDPREAMPRINPUTSEL_SHIFT},
	{PMIC_RG_AUDADCRPWRUP, MT6328_PMIC_RG_AUDADCRPWRUP_ADDR, MT6328_PMIC_RG_AUDADCRPWRUP_MASK,
	 MT6328_PMIC_RG_AUDADCRPWRUP_SHIFT},
	{PMIC_RG_AUDADCRINPUTSEL, MT6328_PMIC_RG_AUDADCRINPUTSEL_ADDR,
	 MT6328_PMIC_RG_AUDADCRINPUTSEL_MASK, MT6328_PMIC_RG_AUDADCRINPUTSEL_SHIFT},
	{PMIC_RG_AUDULHALFBIAS, MT6328_PMIC_RG_AUDULHALFBIAS_ADDR,
	 MT6328_PMIC_RG_AUDULHALFBIAS_MASK, MT6328_PMIC_RG_AUDULHALFBIAS_SHIFT},
	{PMIC_RG_AUDGLBMADLPWEN, MT6328_PMIC_RG_AUDGLBMADLPWEN_ADDR,
	 MT6328_PMIC_RG_AUDGLBMADLPWEN_MASK, MT6328_PMIC_RG_AUDGLBMADLPWEN_SHIFT},
	{PMIC_RG_AUDPREAMPLPEN, MT6328_PMIC_RG_AUDPREAMPLPEN_ADDR,
	 MT6328_PMIC_RG_AUDPREAMPLPEN_MASK, MT6328_PMIC_RG_AUDPREAMPLPEN_SHIFT},
	{PMIC_RG_AUDADC1STSTAGELPEN, MT6328_PMIC_RG_AUDADC1STSTAGELPEN_ADDR,
	 MT6328_PMIC_RG_AUDADC1STSTAGELPEN_MASK, MT6328_PMIC_RG_AUDADC1STSTAGELPEN_SHIFT},
	{PMIC_RG_AUDADC2NDSTAGELPEN, MT6328_PMIC_RG_AUDADC2NDSTAGELPEN_ADDR,
	 MT6328_PMIC_RG_AUDADC2NDSTAGELPEN_MASK, MT6328_PMIC_RG_AUDADC2NDSTAGELPEN_SHIFT},
	{PMIC_RG_AUDADCFLASHLPEN, MT6328_PMIC_RG_AUDADCFLASHLPEN_ADDR,
	 MT6328_PMIC_RG_AUDADCFLASHLPEN_MASK, MT6328_PMIC_RG_AUDADCFLASHLPEN_SHIFT},
	{PMIC_RG_AUDPREAMPIDDTEST, MT6328_PMIC_RG_AUDPREAMPIDDTEST_ADDR,
	 MT6328_PMIC_RG_AUDPREAMPIDDTEST_MASK, MT6328_PMIC_RG_AUDPREAMPIDDTEST_SHIFT},
	{PMIC_RG_AUDADC1STSTAGEIDDTEST, MT6328_PMIC_RG_AUDADC1STSTAGEIDDTEST_ADDR,
	 MT6328_PMIC_RG_AUDADC1STSTAGEIDDTEST_MASK, MT6328_PMIC_RG_AUDADC1STSTAGEIDDTEST_SHIFT},
	{PMIC_RG_AUDADC2NDSTAGEIDDTEST, MT6328_PMIC_RG_AUDADC2NDSTAGEIDDTEST_ADDR,
	 MT6328_PMIC_RG_AUDADC2NDSTAGEIDDTEST_MASK, MT6328_PMIC_RG_AUDADC2NDSTAGEIDDTEST_SHIFT},
	{PMIC_RG_AUDADCREFBUFIDDTEST, MT6328_PMIC_RG_AUDADCREFBUFIDDTEST_ADDR,
	 MT6328_PMIC_RG_AUDADCREFBUFIDDTEST_MASK, MT6328_PMIC_RG_AUDADCREFBUFIDDTEST_SHIFT},
	{PMIC_RG_AUDADCFLASHIDDTEST, MT6328_PMIC_RG_AUDADCFLASHIDDTEST_ADDR,
	 MT6328_PMIC_RG_AUDADCFLASHIDDTEST_MASK, MT6328_PMIC_RG_AUDADCFLASHIDDTEST_SHIFT},
	{PMIC_RG_AUDADCDAC0P25FS, MT6328_PMIC_RG_AUDADCDAC0P25FS_ADDR,
	 MT6328_PMIC_RG_AUDADCDAC0P25FS_MASK, MT6328_PMIC_RG_AUDADCDAC0P25FS_SHIFT},
	{PMIC_RG_AUDADCCLKSEL, MT6328_PMIC_RG_AUDADCCLKSEL_ADDR, MT6328_PMIC_RG_AUDADCCLKSEL_MASK,
	 MT6328_PMIC_RG_AUDADCCLKSEL_SHIFT},
	{PMIC_RG_AUDADCCLKSOURCE, MT6328_PMIC_RG_AUDADCCLKSOURCE_ADDR,
	 MT6328_PMIC_RG_AUDADCCLKSOURCE_MASK, MT6328_PMIC_RG_AUDADCCLKSOURCE_SHIFT},
	{PMIC_RG_AUDADCCLKGENMODE, MT6328_PMIC_RG_AUDADCCLKGENMODE_ADDR,
	 MT6328_PMIC_RG_AUDADCCLKGENMODE_MASK, MT6328_PMIC_RG_AUDADCCLKGENMODE_SHIFT},
	{PMIC_RG_AUDPREAMPAAFEN, MT6328_PMIC_RG_AUDPREAMPAAFEN_ADDR,
	 MT6328_PMIC_RG_AUDPREAMPAAFEN_MASK, MT6328_PMIC_RG_AUDPREAMPAAFEN_SHIFT},
	{PMIC_RG_DCCVCMBUFLPMODSEL, MT6328_PMIC_RG_DCCVCMBUFLPMODSEL_ADDR,
	 MT6328_PMIC_RG_DCCVCMBUFLPMODSEL_MASK, MT6328_PMIC_RG_DCCVCMBUFLPMODSEL_SHIFT},
	{PMIC_RG_DCCVCMBUFLPSWEN, MT6328_PMIC_RG_DCCVCMBUFLPSWEN_ADDR,
	 MT6328_PMIC_RG_DCCVCMBUFLPSWEN_MASK, MT6328_PMIC_RG_DCCVCMBUFLPSWEN_SHIFT},
	{PMIC_RG_AUDSPAREPGA, MT6328_PMIC_RG_AUDSPAREPGA_ADDR, MT6328_PMIC_RG_AUDSPAREPGA_MASK,
	 MT6328_PMIC_RG_AUDSPAREPGA_SHIFT},
	{PMIC_RG_AUDADC1STSTAGESDENB, MT6328_PMIC_RG_AUDADC1STSTAGESDENB_ADDR,
	 MT6328_PMIC_RG_AUDADC1STSTAGESDENB_MASK, MT6328_PMIC_RG_AUDADC1STSTAGESDENB_SHIFT},
	{PMIC_RG_AUDADC2NDSTAGERESET, MT6328_PMIC_RG_AUDADC2NDSTAGERESET_ADDR,
	 MT6328_PMIC_RG_AUDADC2NDSTAGERESET_MASK, MT6328_PMIC_RG_AUDADC2NDSTAGERESET_SHIFT},
	{PMIC_RG_AUDADC3RDSTAGERESET, MT6328_PMIC_RG_AUDADC3RDSTAGERESET_ADDR,
	 MT6328_PMIC_RG_AUDADC3RDSTAGERESET_MASK, MT6328_PMIC_RG_AUDADC3RDSTAGERESET_SHIFT},
	{PMIC_RG_AUDADCFSRESET, MT6328_PMIC_RG_AUDADCFSRESET_ADDR,
	 MT6328_PMIC_RG_AUDADCFSRESET_MASK, MT6328_PMIC_RG_AUDADCFSRESET_SHIFT},
	{PMIC_RG_AUDADCWIDECM, MT6328_PMIC_RG_AUDADCWIDECM_ADDR, MT6328_PMIC_RG_AUDADCWIDECM_MASK,
	 MT6328_PMIC_RG_AUDADCWIDECM_SHIFT},
	{PMIC_RG_AUDADCNOPATEST, MT6328_PMIC_RG_AUDADCNOPATEST_ADDR,
	 MT6328_PMIC_RG_AUDADCNOPATEST_MASK, MT6328_PMIC_RG_AUDADCNOPATEST_SHIFT},
	{PMIC_RG_AUDADCBYPASS, MT6328_PMIC_RG_AUDADCBYPASS_ADDR, MT6328_PMIC_RG_AUDADCBYPASS_MASK,
	 MT6328_PMIC_RG_AUDADCBYPASS_SHIFT},
	{PMIC_RG_AUDADCFFBYPASS, MT6328_PMIC_RG_AUDADCFFBYPASS_ADDR,
	 MT6328_PMIC_RG_AUDADCFFBYPASS_MASK, MT6328_PMIC_RG_AUDADCFFBYPASS_SHIFT},
	{PMIC_RG_AUDADCDACFBCURRENT, MT6328_PMIC_RG_AUDADCDACFBCURRENT_ADDR,
	 MT6328_PMIC_RG_AUDADCDACFBCURRENT_MASK, MT6328_PMIC_RG_AUDADCDACFBCURRENT_SHIFT},
	{PMIC_RG_AUDADCDACIDDTEST, MT6328_PMIC_RG_AUDADCDACIDDTEST_ADDR,
	 MT6328_PMIC_RG_AUDADCDACIDDTEST_MASK, MT6328_PMIC_RG_AUDADCDACIDDTEST_SHIFT},
	{PMIC_RG_AUDADCDACNRZ, MT6328_PMIC_RG_AUDADCDACNRZ_ADDR, MT6328_PMIC_RG_AUDADCDACNRZ_MASK,
	 MT6328_PMIC_RG_AUDADCDACNRZ_SHIFT},
	{PMIC_RG_AUDADCNODEM, MT6328_PMIC_RG_AUDADCNODEM_ADDR, MT6328_PMIC_RG_AUDADCNODEM_MASK,
	 MT6328_PMIC_RG_AUDADCNODEM_SHIFT},
	{PMIC_RG_AUDADCDACTEST, MT6328_PMIC_RG_AUDADCDACTEST_ADDR,
	 MT6328_PMIC_RG_AUDADCDACTEST_MASK, MT6328_PMIC_RG_AUDADCDACTEST_SHIFT},
	{PMIC_RG_AUDADCTESTDATA, MT6328_PMIC_RG_AUDADCTESTDATA_ADDR,
	 MT6328_PMIC_RG_AUDADCTESTDATA_MASK, MT6328_PMIC_RG_AUDADCTESTDATA_SHIFT},
	{PMIC_RG_AUDRCTUNEL, MT6328_PMIC_RG_AUDRCTUNEL_ADDR, MT6328_PMIC_RG_AUDRCTUNEL_MASK,
	 MT6328_PMIC_RG_AUDRCTUNEL_SHIFT},
	{PMIC_RG_AUDRCTUNELSEL, MT6328_PMIC_RG_AUDRCTUNELSEL_ADDR,
	 MT6328_PMIC_RG_AUDRCTUNELSEL_MASK, MT6328_PMIC_RG_AUDRCTUNELSEL_SHIFT},
	{PMIC_RG_AUDRCTUNER, MT6328_PMIC_RG_AUDRCTUNER_ADDR, MT6328_PMIC_RG_AUDRCTUNER_MASK,
	 MT6328_PMIC_RG_AUDRCTUNER_SHIFT},
	{PMIC_RG_AUDRCTUNERSEL, MT6328_PMIC_RG_AUDRCTUNERSEL_ADDR,
	 MT6328_PMIC_RG_AUDRCTUNERSEL_MASK, MT6328_PMIC_RG_AUDRCTUNERSEL_SHIFT},
	{PMIC_RG_AUDSPAREVA28, MT6328_PMIC_RG_AUDSPAREVA28_ADDR, MT6328_PMIC_RG_AUDSPAREVA28_MASK,
	 MT6328_PMIC_RG_AUDSPAREVA28_SHIFT},
	{PMIC_RG_AUDSPAREVA18, MT6328_PMIC_RG_AUDSPAREVA18_ADDR, MT6328_PMIC_RG_AUDSPAREVA18_MASK,
	 MT6328_PMIC_RG_AUDSPAREVA18_SHIFT},
	{PMIC_RG_AUDENCSPAREVA28, MT6328_PMIC_RG_AUDENCSPAREVA28_ADDR,
	 MT6328_PMIC_RG_AUDENCSPAREVA28_MASK, MT6328_PMIC_RG_AUDENCSPAREVA28_SHIFT},
	{PMIC_RG_AUDENCSPAREVA18, MT6328_PMIC_RG_AUDENCSPAREVA18_ADDR,
	 MT6328_PMIC_RG_AUDENCSPAREVA18_MASK, MT6328_PMIC_RG_AUDENCSPAREVA18_SHIFT},
	{PMIC_RG_AUDDIGMICEN, MT6328_PMIC_RG_AUDDIGMICEN_ADDR, MT6328_PMIC_RG_AUDDIGMICEN_MASK,
	 MT6328_PMIC_RG_AUDDIGMICEN_SHIFT},
	{PMIC_RG_AUDDIGMICBIAS, MT6328_PMIC_RG_AUDDIGMICBIAS_ADDR,
	 MT6328_PMIC_RG_AUDDIGMICBIAS_MASK, MT6328_PMIC_RG_AUDDIGMICBIAS_SHIFT},
	{PMIC_RG_DMICHPCLKEN, MT6328_PMIC_RG_DMICHPCLKEN_ADDR, MT6328_PMIC_RG_DMICHPCLKEN_MASK,
	 MT6328_PMIC_RG_DMICHPCLKEN_SHIFT},
	{PMIC_RG_AUDDIGMICPDUTY, MT6328_PMIC_RG_AUDDIGMICPDUTY_ADDR,
	 MT6328_PMIC_RG_AUDDIGMICPDUTY_MASK, MT6328_PMIC_RG_AUDDIGMICPDUTY_SHIFT},
	{PMIC_RG_AUDDIGMICNDUTY, MT6328_PMIC_RG_AUDDIGMICNDUTY_ADDR,
	 MT6328_PMIC_RG_AUDDIGMICNDUTY_MASK, MT6328_PMIC_RG_AUDDIGMICNDUTY_SHIFT},
	{PMIC_RG_DMICMONEN, MT6328_PMIC_RG_DMICMONEN_ADDR, MT6328_PMIC_RG_DMICMONEN_MASK,
	 MT6328_PMIC_RG_DMICMONEN_SHIFT},
	{PMIC_RG_DMICMONSEL, MT6328_PMIC_RG_DMICMONSEL_ADDR, MT6328_PMIC_RG_DMICMONSEL_MASK,
	 MT6328_PMIC_RG_DMICMONSEL_SHIFT},
	{PMIC_RG_AUDSPAREVMIC, MT6328_PMIC_RG_AUDSPAREVMIC_ADDR, MT6328_PMIC_RG_AUDSPAREVMIC_MASK,
	 MT6328_PMIC_RG_AUDSPAREVMIC_SHIFT},
	{PMIC_RG_AUDPWDBMICBIAS0, MT6328_PMIC_RG_AUDPWDBMICBIAS0_ADDR,
	 MT6328_PMIC_RG_AUDPWDBMICBIAS0_MASK, MT6328_PMIC_RG_AUDPWDBMICBIAS0_SHIFT},
	{PMIC_RG_AUDMICBIAS0DCSWPEN, MT6328_PMIC_RG_AUDMICBIAS0DCSWPEN_ADDR,
	 MT6328_PMIC_RG_AUDMICBIAS0DCSWPEN_MASK, MT6328_PMIC_RG_AUDMICBIAS0DCSWPEN_SHIFT},
	{PMIC_RG_AUDMICBIAS0DCSWNEN, MT6328_PMIC_RG_AUDMICBIAS0DCSWNEN_ADDR,
	 MT6328_PMIC_RG_AUDMICBIAS0DCSWNEN_MASK, MT6328_PMIC_RG_AUDMICBIAS0DCSWNEN_SHIFT},
	{PMIC_RG_AUDMICBIAS0BYPASSEN, MT6328_PMIC_RG_AUDMICBIAS0BYPASSEN_ADDR,
	 MT6328_PMIC_RG_AUDMICBIAS0BYPASSEN_MASK, MT6328_PMIC_RG_AUDMICBIAS0BYPASSEN_SHIFT},
	{PMIC_RG_AUDPWDBMICBIAS1, MT6328_PMIC_RG_AUDPWDBMICBIAS1_ADDR,
	 MT6328_PMIC_RG_AUDPWDBMICBIAS1_MASK, MT6328_PMIC_RG_AUDPWDBMICBIAS1_SHIFT},
	{PMIC_RG_AUDMICBIAS1DCSWPEN, MT6328_PMIC_RG_AUDMICBIAS1DCSWPEN_ADDR,
	 MT6328_PMIC_RG_AUDMICBIAS1DCSWPEN_MASK, MT6328_PMIC_RG_AUDMICBIAS1DCSWPEN_SHIFT},
	{PMIC_RG_AUDMICBIAS1DCSWNEN, MT6328_PMIC_RG_AUDMICBIAS1DCSWNEN_ADDR,
	 MT6328_PMIC_RG_AUDMICBIAS1DCSWNEN_MASK, MT6328_PMIC_RG_AUDMICBIAS1DCSWNEN_SHIFT},
	{PMIC_RG_AUDMICBIAS1BYPASSEN, MT6328_PMIC_RG_AUDMICBIAS1BYPASSEN_ADDR,
	 MT6328_PMIC_RG_AUDMICBIAS1BYPASSEN_MASK, MT6328_PMIC_RG_AUDMICBIAS1BYPASSEN_SHIFT},
	{PMIC_RG_AUDMICBIASVREF, MT6328_PMIC_RG_AUDMICBIASVREF_ADDR,
	 MT6328_PMIC_RG_AUDMICBIASVREF_MASK, MT6328_PMIC_RG_AUDMICBIASVREF_SHIFT},
	{PMIC_RG_AUDMICBIASLOWPEN, MT6328_PMIC_RG_AUDMICBIASLOWPEN_ADDR,
	 MT6328_PMIC_RG_AUDMICBIASLOWPEN_MASK, MT6328_PMIC_RG_AUDMICBIASLOWPEN_SHIFT},
	{PMIC_RG_BANDGAPGEN, MT6328_PMIC_RG_BANDGAPGEN_ADDR, MT6328_PMIC_RG_BANDGAPGEN_MASK,
	 MT6328_PMIC_RG_BANDGAPGEN_SHIFT},
	{PMIC_RG_AUDPREAMPLGAIN, MT6328_PMIC_RG_AUDPREAMPLGAIN_ADDR,
	 MT6328_PMIC_RG_AUDPREAMPLGAIN_MASK, MT6328_PMIC_RG_AUDPREAMPLGAIN_SHIFT},
	{PMIC_RG_AUDPREAMPRGAIN, MT6328_PMIC_RG_AUDPREAMPRGAIN_ADDR,
	 MT6328_PMIC_RG_AUDPREAMPRGAIN_MASK, MT6328_PMIC_RG_AUDPREAMPRGAIN_SHIFT},
	{PMIC_RG_DIVCKS_CHG, MT6328_PMIC_RG_DIVCKS_CHG_ADDR, MT6328_PMIC_RG_DIVCKS_CHG_MASK,
	 MT6328_PMIC_RG_DIVCKS_CHG_SHIFT},
	{PMIC_RG_DIVCKS_ON, MT6328_PMIC_RG_DIVCKS_ON_ADDR, MT6328_PMIC_RG_DIVCKS_ON_MASK,
	 MT6328_PMIC_RG_DIVCKS_ON_SHIFT},
	{PMIC_RG_DIVCKS_PRG, MT6328_PMIC_RG_DIVCKS_PRG_ADDR, MT6328_PMIC_RG_DIVCKS_PRG_MASK,
	 MT6328_PMIC_RG_DIVCKS_PRG_SHIFT},
	{PMIC_RG_DIVCKS_PWD_NCP, MT6328_PMIC_RG_DIVCKS_PWD_NCP_ADDR,
	 MT6328_PMIC_RG_DIVCKS_PWD_NCP_MASK, MT6328_PMIC_RG_DIVCKS_PWD_NCP_SHIFT},
	{PMIC_RG_DIVCKS_PWD_NCP_ST_SEL, MT6328_PMIC_RG_DIVCKS_PWD_NCP_ST_SEL_ADDR,
	 MT6328_PMIC_RG_DIVCKS_PWD_NCP_ST_SEL_MASK, MT6328_PMIC_RG_DIVCKS_PWD_NCP_ST_SEL_SHIFT},
	{PMIC_AUXADC_ADC_OUT_CH0, MT6328_PMIC_AUXADC_ADC_OUT_CH0_ADDR,
	 MT6328_PMIC_AUXADC_ADC_OUT_CH0_MASK, MT6328_PMIC_AUXADC_ADC_OUT_CH0_SHIFT},
	{PMIC_AUXADC_ADC_RDY_CH0, MT6328_PMIC_AUXADC_ADC_RDY_CH0_ADDR,
	 MT6328_PMIC_AUXADC_ADC_RDY_CH0_MASK, MT6328_PMIC_AUXADC_ADC_RDY_CH0_SHIFT},
	{PMIC_AUXADC_ADC_OUT_CH1, MT6328_PMIC_AUXADC_ADC_OUT_CH1_ADDR,
	 MT6328_PMIC_AUXADC_ADC_OUT_CH1_MASK, MT6328_PMIC_AUXADC_ADC_OUT_CH1_SHIFT},
	{PMIC_AUXADC_ADC_RDY_CH1, MT6328_PMIC_AUXADC_ADC_RDY_CH1_ADDR,
	 MT6328_PMIC_AUXADC_ADC_RDY_CH1_MASK, MT6328_PMIC_AUXADC_ADC_RDY_CH1_SHIFT},
	{PMIC_AUXADC_ADC_OUT_CH2, MT6328_PMIC_AUXADC_ADC_OUT_CH2_ADDR,
	 MT6328_PMIC_AUXADC_ADC_OUT_CH2_MASK, MT6328_PMIC_AUXADC_ADC_OUT_CH2_SHIFT},
	{PMIC_AUXADC_ADC_RDY_CH2, MT6328_PMIC_AUXADC_ADC_RDY_CH2_ADDR,
	 MT6328_PMIC_AUXADC_ADC_RDY_CH2_MASK, MT6328_PMIC_AUXADC_ADC_RDY_CH2_SHIFT},
	{PMIC_AUXADC_ADC_OUT_CH3, MT6328_PMIC_AUXADC_ADC_OUT_CH3_ADDR,
	 MT6328_PMIC_AUXADC_ADC_OUT_CH3_MASK, MT6328_PMIC_AUXADC_ADC_OUT_CH3_SHIFT},
	{PMIC_AUXADC_ADC_RDY_CH3, MT6328_PMIC_AUXADC_ADC_RDY_CH3_ADDR,
	 MT6328_PMIC_AUXADC_ADC_RDY_CH3_MASK, MT6328_PMIC_AUXADC_ADC_RDY_CH3_SHIFT},
	{PMIC_AUXADC_ADC_OUT_CH4, MT6328_PMIC_AUXADC_ADC_OUT_CH4_ADDR,
	 MT6328_PMIC_AUXADC_ADC_OUT_CH4_MASK, MT6328_PMIC_AUXADC_ADC_OUT_CH4_SHIFT},
	{PMIC_AUXADC_ADC_RDY_CH4, MT6328_PMIC_AUXADC_ADC_RDY_CH4_ADDR,
	 MT6328_PMIC_AUXADC_ADC_RDY_CH4_MASK, MT6328_PMIC_AUXADC_ADC_RDY_CH4_SHIFT},
	{PMIC_AUXADC_ADC_OUT_CH5, MT6328_PMIC_AUXADC_ADC_OUT_CH5_ADDR,
	 MT6328_PMIC_AUXADC_ADC_OUT_CH5_MASK, MT6328_PMIC_AUXADC_ADC_OUT_CH5_SHIFT},
	{PMIC_AUXADC_ADC_RDY_CH5, MT6328_PMIC_AUXADC_ADC_RDY_CH5_ADDR,
	 MT6328_PMIC_AUXADC_ADC_RDY_CH5_MASK, MT6328_PMIC_AUXADC_ADC_RDY_CH5_SHIFT},
	{PMIC_AUXADC_ADC_OUT_CH6, MT6328_PMIC_AUXADC_ADC_OUT_CH6_ADDR,
	 MT6328_PMIC_AUXADC_ADC_OUT_CH6_MASK, MT6328_PMIC_AUXADC_ADC_OUT_CH6_SHIFT},
	{PMIC_AUXADC_ADC_RDY_CH6, MT6328_PMIC_AUXADC_ADC_RDY_CH6_ADDR,
	 MT6328_PMIC_AUXADC_ADC_RDY_CH6_MASK, MT6328_PMIC_AUXADC_ADC_RDY_CH6_SHIFT},
	{PMIC_AUXADC_ADC_OUT_CH7, MT6328_PMIC_AUXADC_ADC_OUT_CH7_ADDR,
	 MT6328_PMIC_AUXADC_ADC_OUT_CH7_MASK, MT6328_PMIC_AUXADC_ADC_OUT_CH7_SHIFT},
	{PMIC_AUXADC_ADC_RDY_CH7, MT6328_PMIC_AUXADC_ADC_RDY_CH7_ADDR,
	 MT6328_PMIC_AUXADC_ADC_RDY_CH7_MASK, MT6328_PMIC_AUXADC_ADC_RDY_CH7_SHIFT},
	{PMIC_AUXADC_ADC_OUT_CH8, MT6328_PMIC_AUXADC_ADC_OUT_CH8_ADDR,
	 MT6328_PMIC_AUXADC_ADC_OUT_CH8_MASK, MT6328_PMIC_AUXADC_ADC_OUT_CH8_SHIFT},
	{PMIC_AUXADC_ADC_RDY_CH8, MT6328_PMIC_AUXADC_ADC_RDY_CH8_ADDR,
	 MT6328_PMIC_AUXADC_ADC_RDY_CH8_MASK, MT6328_PMIC_AUXADC_ADC_RDY_CH8_SHIFT},
	{PMIC_AUXADC_ADC_OUT_CH9, MT6328_PMIC_AUXADC_ADC_OUT_CH9_ADDR,
	 MT6328_PMIC_AUXADC_ADC_OUT_CH9_MASK, MT6328_PMIC_AUXADC_ADC_OUT_CH9_SHIFT},
	{PMIC_AUXADC_ADC_RDY_CH9, MT6328_PMIC_AUXADC_ADC_RDY_CH9_ADDR,
	 MT6328_PMIC_AUXADC_ADC_RDY_CH9_MASK, MT6328_PMIC_AUXADC_ADC_RDY_CH9_SHIFT},
	{PMIC_AUXADC_ADC_OUT_CH10, MT6328_PMIC_AUXADC_ADC_OUT_CH10_ADDR,
	 MT6328_PMIC_AUXADC_ADC_OUT_CH10_MASK, MT6328_PMIC_AUXADC_ADC_OUT_CH10_SHIFT},
	{PMIC_AUXADC_ADC_RDY_CH10, MT6328_PMIC_AUXADC_ADC_RDY_CH10_ADDR,
	 MT6328_PMIC_AUXADC_ADC_RDY_CH10_MASK, MT6328_PMIC_AUXADC_ADC_RDY_CH10_SHIFT},
	{PMIC_AUXADC_ADC_OUT_CH11, MT6328_PMIC_AUXADC_ADC_OUT_CH11_ADDR,
	 MT6328_PMIC_AUXADC_ADC_OUT_CH11_MASK, MT6328_PMIC_AUXADC_ADC_OUT_CH11_SHIFT},
	{PMIC_AUXADC_ADC_RDY_CH11, MT6328_PMIC_AUXADC_ADC_RDY_CH11_ADDR,
	 MT6328_PMIC_AUXADC_ADC_RDY_CH11_MASK, MT6328_PMIC_AUXADC_ADC_RDY_CH11_SHIFT},
	{PMIC_AUXADC_ADC_OUT_CH12_15, MT6328_PMIC_AUXADC_ADC_OUT_CH12_15_ADDR,
	 MT6328_PMIC_AUXADC_ADC_OUT_CH12_15_MASK, MT6328_PMIC_AUXADC_ADC_OUT_CH12_15_SHIFT},
	{PMIC_AUXADC_ADC_RDY_CH12_15, MT6328_PMIC_AUXADC_ADC_RDY_CH12_15_ADDR,
	 MT6328_PMIC_AUXADC_ADC_RDY_CH12_15_MASK, MT6328_PMIC_AUXADC_ADC_RDY_CH12_15_SHIFT},
	{PMIC_AUXADC_ADC_OUT_THR_HW, MT6328_PMIC_AUXADC_ADC_OUT_THR_HW_ADDR,
	 MT6328_PMIC_AUXADC_ADC_OUT_THR_HW_MASK, MT6328_PMIC_AUXADC_ADC_OUT_THR_HW_SHIFT},
	{PMIC_AUXADC_ADC_RDY_THR_HW, MT6328_PMIC_AUXADC_ADC_RDY_THR_HW_ADDR,
	 MT6328_PMIC_AUXADC_ADC_RDY_THR_HW_MASK, MT6328_PMIC_AUXADC_ADC_RDY_THR_HW_SHIFT},
	{PMIC_AUXADC_ADC_OUT_LBAT, MT6328_PMIC_AUXADC_ADC_OUT_LBAT_ADDR,
	 MT6328_PMIC_AUXADC_ADC_OUT_LBAT_MASK, MT6328_PMIC_AUXADC_ADC_OUT_LBAT_SHIFT},
	{PMIC_AUXADC_ADC_RDY_LBAT, MT6328_PMIC_AUXADC_ADC_RDY_LBAT_ADDR,
	 MT6328_PMIC_AUXADC_ADC_RDY_LBAT_MASK, MT6328_PMIC_AUXADC_ADC_RDY_LBAT_SHIFT},
	{PMIC_AUXADC_ADC_OUT_LBAT2, MT6328_PMIC_AUXADC_ADC_OUT_LBAT2_ADDR,
	 MT6328_PMIC_AUXADC_ADC_OUT_LBAT2_MASK, MT6328_PMIC_AUXADC_ADC_OUT_LBAT2_SHIFT},
	{PMIC_AUXADC_ADC_RDY_LBAT2, MT6328_PMIC_AUXADC_ADC_RDY_LBAT2_ADDR,
	 MT6328_PMIC_AUXADC_ADC_RDY_LBAT2_MASK, MT6328_PMIC_AUXADC_ADC_RDY_LBAT2_SHIFT},
	{PMIC_AUXADC_ADC_OUT_CH7_BY_GPS, MT6328_PMIC_AUXADC_ADC_OUT_CH7_BY_GPS_ADDR,
	 MT6328_PMIC_AUXADC_ADC_OUT_CH7_BY_GPS_MASK, MT6328_PMIC_AUXADC_ADC_OUT_CH7_BY_GPS_SHIFT},
	{PMIC_AUXADC_ADC_RDY_CH7_BY_GPS, MT6328_PMIC_AUXADC_ADC_RDY_CH7_BY_GPS_ADDR,
	 MT6328_PMIC_AUXADC_ADC_RDY_CH7_BY_GPS_MASK, MT6328_PMIC_AUXADC_ADC_RDY_CH7_BY_GPS_SHIFT},
	{PMIC_AUXADC_ADC_OUT_CH7_BY_MD, MT6328_PMIC_AUXADC_ADC_OUT_CH7_BY_MD_ADDR,
	 MT6328_PMIC_AUXADC_ADC_OUT_CH7_BY_MD_MASK, MT6328_PMIC_AUXADC_ADC_OUT_CH7_BY_MD_SHIFT},
	{PMIC_AUXADC_ADC_RDY_CH7_BY_MD, MT6328_PMIC_AUXADC_ADC_RDY_CH7_BY_MD_ADDR,
	 MT6328_PMIC_AUXADC_ADC_RDY_CH7_BY_MD_MASK, MT6328_PMIC_AUXADC_ADC_RDY_CH7_BY_MD_SHIFT},
	{PMIC_AUXADC_ADC_OUT_CH7_BY_AP, MT6328_PMIC_AUXADC_ADC_OUT_CH7_BY_AP_ADDR,
	 MT6328_PMIC_AUXADC_ADC_OUT_CH7_BY_AP_MASK, MT6328_PMIC_AUXADC_ADC_OUT_CH7_BY_AP_SHIFT},
	{PMIC_AUXADC_ADC_RDY_CH7_BY_AP, MT6328_PMIC_AUXADC_ADC_RDY_CH7_BY_AP_ADDR,
	 MT6328_PMIC_AUXADC_ADC_RDY_CH7_BY_AP_MASK, MT6328_PMIC_AUXADC_ADC_RDY_CH7_BY_AP_SHIFT},
	{PMIC_AUXADC_ADC_OUT_CH4_BY_MD, MT6328_PMIC_AUXADC_ADC_OUT_CH4_BY_MD_ADDR,
	 MT6328_PMIC_AUXADC_ADC_OUT_CH4_BY_MD_MASK, MT6328_PMIC_AUXADC_ADC_OUT_CH4_BY_MD_SHIFT},
	{PMIC_AUXADC_ADC_RDY_CH4_BY_MD, MT6328_PMIC_AUXADC_ADC_RDY_CH4_BY_MD_ADDR,
	 MT6328_PMIC_AUXADC_ADC_RDY_CH4_BY_MD_MASK, MT6328_PMIC_AUXADC_ADC_RDY_CH4_BY_MD_SHIFT},
	{PMIC_AUXADC_ADC_OUT_WAKEUP_PCHR, MT6328_PMIC_AUXADC_ADC_OUT_WAKEUP_PCHR_ADDR,
	 MT6328_PMIC_AUXADC_ADC_OUT_WAKEUP_PCHR_MASK, MT6328_PMIC_AUXADC_ADC_OUT_WAKEUP_PCHR_SHIFT},
	{PMIC_AUXADC_ADC_RDY_WAKEUP_PCHR, MT6328_PMIC_AUXADC_ADC_RDY_WAKEUP_PCHR_ADDR,
	 MT6328_PMIC_AUXADC_ADC_RDY_WAKEUP_PCHR_MASK, MT6328_PMIC_AUXADC_ADC_RDY_WAKEUP_PCHR_SHIFT},
	{PMIC_AUXADC_ADC_OUT_WAKEUP_SWCHR, MT6328_PMIC_AUXADC_ADC_OUT_WAKEUP_SWCHR_ADDR,
	 MT6328_PMIC_AUXADC_ADC_OUT_WAKEUP_SWCHR_MASK,
	 MT6328_PMIC_AUXADC_ADC_OUT_WAKEUP_SWCHR_SHIFT},
	{PMIC_AUXADC_ADC_RDY_WAKEUP_SWCHR, MT6328_PMIC_AUXADC_ADC_RDY_WAKEUP_SWCHR_ADDR,
	 MT6328_PMIC_AUXADC_ADC_RDY_WAKEUP_SWCHR_MASK,
	 MT6328_PMIC_AUXADC_ADC_RDY_WAKEUP_SWCHR_SHIFT},
	{PMIC_AUXADC_ADC_OUT_CH0_BY_MD, MT6328_PMIC_AUXADC_ADC_OUT_CH0_BY_MD_ADDR,
	 MT6328_PMIC_AUXADC_ADC_OUT_CH0_BY_MD_MASK, MT6328_PMIC_AUXADC_ADC_OUT_CH0_BY_MD_SHIFT},
	{PMIC_AUXADC_ADC_RDY_CH0_BY_MD, MT6328_PMIC_AUXADC_ADC_RDY_CH0_BY_MD_ADDR,
	 MT6328_PMIC_AUXADC_ADC_RDY_CH0_BY_MD_MASK, MT6328_PMIC_AUXADC_ADC_RDY_CH0_BY_MD_SHIFT},
	{PMIC_AUXADC_ADC_OUT_CH0_BY_AP, MT6328_PMIC_AUXADC_ADC_OUT_CH0_BY_AP_ADDR,
	 MT6328_PMIC_AUXADC_ADC_OUT_CH0_BY_AP_MASK, MT6328_PMIC_AUXADC_ADC_OUT_CH0_BY_AP_SHIFT},
	{PMIC_AUXADC_ADC_RDY_CH0_BY_AP, MT6328_PMIC_AUXADC_ADC_RDY_CH0_BY_AP_ADDR,
	 MT6328_PMIC_AUXADC_ADC_RDY_CH0_BY_AP_MASK, MT6328_PMIC_AUXADC_ADC_RDY_CH0_BY_AP_SHIFT},
	{PMIC_AUXADC_ADC_OUT_CH1_BY_MD, MT6328_PMIC_AUXADC_ADC_OUT_CH1_BY_MD_ADDR,
	 MT6328_PMIC_AUXADC_ADC_OUT_CH1_BY_MD_MASK, MT6328_PMIC_AUXADC_ADC_OUT_CH1_BY_MD_SHIFT},
	{PMIC_AUXADC_ADC_RDY_CH1_BY_MD, MT6328_PMIC_AUXADC_ADC_RDY_CH1_BY_MD_ADDR,
	 MT6328_PMIC_AUXADC_ADC_RDY_CH1_BY_MD_MASK, MT6328_PMIC_AUXADC_ADC_RDY_CH1_BY_MD_SHIFT},
	{PMIC_AUXADC_ADC_OUT_CH1_BY_AP, MT6328_PMIC_AUXADC_ADC_OUT_CH1_BY_AP_ADDR,
	 MT6328_PMIC_AUXADC_ADC_OUT_CH1_BY_AP_MASK, MT6328_PMIC_AUXADC_ADC_OUT_CH1_BY_AP_SHIFT},
	{PMIC_AUXADC_ADC_RDY_CH1_BY_AP, MT6328_PMIC_AUXADC_ADC_RDY_CH1_BY_AP_ADDR,
	 MT6328_PMIC_AUXADC_ADC_RDY_CH1_BY_AP_MASK, MT6328_PMIC_AUXADC_ADC_RDY_CH1_BY_AP_SHIFT},
	{PMIC_AUXADC_ADC_OUT_VISMPS0, MT6328_PMIC_AUXADC_ADC_OUT_VISMPS0_ADDR,
	 MT6328_PMIC_AUXADC_ADC_OUT_VISMPS0_MASK, MT6328_PMIC_AUXADC_ADC_OUT_VISMPS0_SHIFT},
	{PMIC_AUXADC_ADC_RDY_VISMPS0, MT6328_PMIC_AUXADC_ADC_RDY_VISMPS0_ADDR,
	 MT6328_PMIC_AUXADC_ADC_RDY_VISMPS0_MASK, MT6328_PMIC_AUXADC_ADC_RDY_VISMPS0_SHIFT},
	{PMIC_AUXADC_ADC_OUT_FGADC1, MT6328_PMIC_AUXADC_ADC_OUT_FGADC1_ADDR,
	 MT6328_PMIC_AUXADC_ADC_OUT_FGADC1_MASK, MT6328_PMIC_AUXADC_ADC_OUT_FGADC1_SHIFT},
	{PMIC_AUXADC_ADC_RDY_FGADC1, MT6328_PMIC_AUXADC_ADC_RDY_FGADC1_ADDR,
	 MT6328_PMIC_AUXADC_ADC_RDY_FGADC1_MASK, MT6328_PMIC_AUXADC_ADC_RDY_FGADC1_SHIFT},
	{PMIC_AUXADC_ADC_OUT_FGADC2, MT6328_PMIC_AUXADC_ADC_OUT_FGADC2_ADDR,
	 MT6328_PMIC_AUXADC_ADC_OUT_FGADC2_MASK, MT6328_PMIC_AUXADC_ADC_OUT_FGADC2_SHIFT},
	{PMIC_AUXADC_ADC_RDY_FGADC2, MT6328_PMIC_AUXADC_ADC_RDY_FGADC2_ADDR,
	 MT6328_PMIC_AUXADC_ADC_RDY_FGADC2_MASK, MT6328_PMIC_AUXADC_ADC_RDY_FGADC2_SHIFT},
	{PMIC_AUXADC_ADC_OUT_IMP, MT6328_PMIC_AUXADC_ADC_OUT_IMP_ADDR,
	 MT6328_PMIC_AUXADC_ADC_OUT_IMP_MASK, MT6328_PMIC_AUXADC_ADC_OUT_IMP_SHIFT},
	{PMIC_AUXADC_ADC_RDY_IMP, MT6328_PMIC_AUXADC_ADC_RDY_IMP_ADDR,
	 MT6328_PMIC_AUXADC_ADC_RDY_IMP_MASK, MT6328_PMIC_AUXADC_ADC_RDY_IMP_SHIFT},
	{PMIC_AUXADC_ADC_OUT_IMP_AVG, MT6328_PMIC_AUXADC_ADC_OUT_IMP_AVG_ADDR,
	 MT6328_PMIC_AUXADC_ADC_OUT_IMP_AVG_MASK, MT6328_PMIC_AUXADC_ADC_OUT_IMP_AVG_SHIFT},
	{PMIC_AUXADC_ADC_RDY_IMP_AVG, MT6328_PMIC_AUXADC_ADC_RDY_IMP_AVG_ADDR,
	 MT6328_PMIC_AUXADC_ADC_RDY_IMP_AVG_MASK, MT6328_PMIC_AUXADC_ADC_RDY_IMP_AVG_SHIFT},
	{PMIC_AUXADC_ADC_OUT_RAW, MT6328_PMIC_AUXADC_ADC_OUT_RAW_ADDR,
	 MT6328_PMIC_AUXADC_ADC_OUT_RAW_MASK, MT6328_PMIC_AUXADC_ADC_OUT_RAW_SHIFT},
	{PMIC_AUXADC_ADC_OUT_MDRT, MT6328_PMIC_AUXADC_ADC_OUT_MDRT_ADDR,
	 MT6328_PMIC_AUXADC_ADC_OUT_MDRT_MASK, MT6328_PMIC_AUXADC_ADC_OUT_MDRT_SHIFT},
	{PMIC_AUXADC_ADC_RDY_MDRT, MT6328_PMIC_AUXADC_ADC_RDY_MDRT_ADDR,
	 MT6328_PMIC_AUXADC_ADC_RDY_MDRT_MASK, MT6328_PMIC_AUXADC_ADC_RDY_MDRT_SHIFT},
	{PMIC_AUXADC_ADC_OUT_MDBG, MT6328_PMIC_AUXADC_ADC_OUT_MDBG_ADDR,
	 MT6328_PMIC_AUXADC_ADC_OUT_MDBG_MASK, MT6328_PMIC_AUXADC_ADC_OUT_MDBG_SHIFT},
	{PMIC_AUXADC_ADC_RDY_MDBG, MT6328_PMIC_AUXADC_ADC_RDY_MDBG_ADDR,
	 MT6328_PMIC_AUXADC_ADC_RDY_MDBG_MASK, MT6328_PMIC_AUXADC_ADC_RDY_MDBG_SHIFT},
	{PMIC_AUXADC_BUF_OUT_00, MT6328_PMIC_AUXADC_BUF_OUT_00_ADDR,
	 MT6328_PMIC_AUXADC_BUF_OUT_00_MASK, MT6328_PMIC_AUXADC_BUF_OUT_00_SHIFT},
	{PMIC_AUXADC_BUF_RDY_00, MT6328_PMIC_AUXADC_BUF_RDY_00_ADDR,
	 MT6328_PMIC_AUXADC_BUF_RDY_00_MASK, MT6328_PMIC_AUXADC_BUF_RDY_00_SHIFT},
	{PMIC_AUXADC_BUF_OUT_01, MT6328_PMIC_AUXADC_BUF_OUT_01_ADDR,
	 MT6328_PMIC_AUXADC_BUF_OUT_01_MASK, MT6328_PMIC_AUXADC_BUF_OUT_01_SHIFT},
	{PMIC_AUXADC_BUF_RDY_01, MT6328_PMIC_AUXADC_BUF_RDY_01_ADDR,
	 MT6328_PMIC_AUXADC_BUF_RDY_01_MASK, MT6328_PMIC_AUXADC_BUF_RDY_01_SHIFT},
	{PMIC_AUXADC_BUF_OUT_02, MT6328_PMIC_AUXADC_BUF_OUT_02_ADDR,
	 MT6328_PMIC_AUXADC_BUF_OUT_02_MASK, MT6328_PMIC_AUXADC_BUF_OUT_02_SHIFT},
	{PMIC_AUXADC_BUF_RDY_02, MT6328_PMIC_AUXADC_BUF_RDY_02_ADDR,
	 MT6328_PMIC_AUXADC_BUF_RDY_02_MASK, MT6328_PMIC_AUXADC_BUF_RDY_02_SHIFT},
	{PMIC_AUXADC_BUF_OUT_03, MT6328_PMIC_AUXADC_BUF_OUT_03_ADDR,
	 MT6328_PMIC_AUXADC_BUF_OUT_03_MASK, MT6328_PMIC_AUXADC_BUF_OUT_03_SHIFT},
	{PMIC_AUXADC_BUF_RDY_03, MT6328_PMIC_AUXADC_BUF_RDY_03_ADDR,
	 MT6328_PMIC_AUXADC_BUF_RDY_03_MASK, MT6328_PMIC_AUXADC_BUF_RDY_03_SHIFT},
	{PMIC_AUXADC_BUF_OUT_04, MT6328_PMIC_AUXADC_BUF_OUT_04_ADDR,
	 MT6328_PMIC_AUXADC_BUF_OUT_04_MASK, MT6328_PMIC_AUXADC_BUF_OUT_04_SHIFT},
	{PMIC_AUXADC_BUF_RDY_04, MT6328_PMIC_AUXADC_BUF_RDY_04_ADDR,
	 MT6328_PMIC_AUXADC_BUF_RDY_04_MASK, MT6328_PMIC_AUXADC_BUF_RDY_04_SHIFT},
	{PMIC_AUXADC_BUF_OUT_05, MT6328_PMIC_AUXADC_BUF_OUT_05_ADDR,
	 MT6328_PMIC_AUXADC_BUF_OUT_05_MASK, MT6328_PMIC_AUXADC_BUF_OUT_05_SHIFT},
	{PMIC_AUXADC_BUF_RDY_05, MT6328_PMIC_AUXADC_BUF_RDY_05_ADDR,
	 MT6328_PMIC_AUXADC_BUF_RDY_05_MASK, MT6328_PMIC_AUXADC_BUF_RDY_05_SHIFT},
	{PMIC_AUXADC_BUF_OUT_06, MT6328_PMIC_AUXADC_BUF_OUT_06_ADDR,
	 MT6328_PMIC_AUXADC_BUF_OUT_06_MASK, MT6328_PMIC_AUXADC_BUF_OUT_06_SHIFT},
	{PMIC_AUXADC_BUF_RDY_06, MT6328_PMIC_AUXADC_BUF_RDY_06_ADDR,
	 MT6328_PMIC_AUXADC_BUF_RDY_06_MASK, MT6328_PMIC_AUXADC_BUF_RDY_06_SHIFT},
	{PMIC_AUXADC_BUF_OUT_07, MT6328_PMIC_AUXADC_BUF_OUT_07_ADDR,
	 MT6328_PMIC_AUXADC_BUF_OUT_07_MASK, MT6328_PMIC_AUXADC_BUF_OUT_07_SHIFT},
	{PMIC_AUXADC_BUF_RDY_07, MT6328_PMIC_AUXADC_BUF_RDY_07_ADDR,
	 MT6328_PMIC_AUXADC_BUF_RDY_07_MASK, MT6328_PMIC_AUXADC_BUF_RDY_07_SHIFT},
	{PMIC_AUXADC_BUF_OUT_08, MT6328_PMIC_AUXADC_BUF_OUT_08_ADDR,
	 MT6328_PMIC_AUXADC_BUF_OUT_08_MASK, MT6328_PMIC_AUXADC_BUF_OUT_08_SHIFT},
	{PMIC_AUXADC_BUF_RDY_08, MT6328_PMIC_AUXADC_BUF_RDY_08_ADDR,
	 MT6328_PMIC_AUXADC_BUF_RDY_08_MASK, MT6328_PMIC_AUXADC_BUF_RDY_08_SHIFT},
	{PMIC_AUXADC_BUF_OUT_09, MT6328_PMIC_AUXADC_BUF_OUT_09_ADDR,
	 MT6328_PMIC_AUXADC_BUF_OUT_09_MASK, MT6328_PMIC_AUXADC_BUF_OUT_09_SHIFT},
	{PMIC_AUXADC_BUF_RDY_09, MT6328_PMIC_AUXADC_BUF_RDY_09_ADDR,
	 MT6328_PMIC_AUXADC_BUF_RDY_09_MASK, MT6328_PMIC_AUXADC_BUF_RDY_09_SHIFT},
	{PMIC_AUXADC_BUF_OUT_10, MT6328_PMIC_AUXADC_BUF_OUT_10_ADDR,
	 MT6328_PMIC_AUXADC_BUF_OUT_10_MASK, MT6328_PMIC_AUXADC_BUF_OUT_10_SHIFT},
	{PMIC_AUXADC_BUF_RDY_10, MT6328_PMIC_AUXADC_BUF_RDY_10_ADDR,
	 MT6328_PMIC_AUXADC_BUF_RDY_10_MASK, MT6328_PMIC_AUXADC_BUF_RDY_10_SHIFT},
	{PMIC_AUXADC_BUF_OUT_11, MT6328_PMIC_AUXADC_BUF_OUT_11_ADDR,
	 MT6328_PMIC_AUXADC_BUF_OUT_11_MASK, MT6328_PMIC_AUXADC_BUF_OUT_11_SHIFT},
	{PMIC_AUXADC_BUF_RDY_11, MT6328_PMIC_AUXADC_BUF_RDY_11_ADDR,
	 MT6328_PMIC_AUXADC_BUF_RDY_11_MASK, MT6328_PMIC_AUXADC_BUF_RDY_11_SHIFT},
	{PMIC_AUXADC_BUF_OUT_12, MT6328_PMIC_AUXADC_BUF_OUT_12_ADDR,
	 MT6328_PMIC_AUXADC_BUF_OUT_12_MASK, MT6328_PMIC_AUXADC_BUF_OUT_12_SHIFT},
	{PMIC_AUXADC_BUF_RDY_12, MT6328_PMIC_AUXADC_BUF_RDY_12_ADDR,
	 MT6328_PMIC_AUXADC_BUF_RDY_12_MASK, MT6328_PMIC_AUXADC_BUF_RDY_12_SHIFT},
	{PMIC_AUXADC_BUF_OUT_13, MT6328_PMIC_AUXADC_BUF_OUT_13_ADDR,
	 MT6328_PMIC_AUXADC_BUF_OUT_13_MASK, MT6328_PMIC_AUXADC_BUF_OUT_13_SHIFT},
	{PMIC_AUXADC_BUF_RDY_13, MT6328_PMIC_AUXADC_BUF_RDY_13_ADDR,
	 MT6328_PMIC_AUXADC_BUF_RDY_13_MASK, MT6328_PMIC_AUXADC_BUF_RDY_13_SHIFT},
	{PMIC_AUXADC_BUF_OUT_14, MT6328_PMIC_AUXADC_BUF_OUT_14_ADDR,
	 MT6328_PMIC_AUXADC_BUF_OUT_14_MASK, MT6328_PMIC_AUXADC_BUF_OUT_14_SHIFT},
	{PMIC_AUXADC_BUF_RDY_14, MT6328_PMIC_AUXADC_BUF_RDY_14_ADDR,
	 MT6328_PMIC_AUXADC_BUF_RDY_14_MASK, MT6328_PMIC_AUXADC_BUF_RDY_14_SHIFT},
	{PMIC_AUXADC_BUF_OUT_15, MT6328_PMIC_AUXADC_BUF_OUT_15_ADDR,
	 MT6328_PMIC_AUXADC_BUF_OUT_15_MASK, MT6328_PMIC_AUXADC_BUF_OUT_15_SHIFT},
	{PMIC_AUXADC_BUF_RDY_15, MT6328_PMIC_AUXADC_BUF_RDY_15_ADDR,
	 MT6328_PMIC_AUXADC_BUF_RDY_15_MASK, MT6328_PMIC_AUXADC_BUF_RDY_15_SHIFT},
	{PMIC_AUXADC_BUF_OUT_16, MT6328_PMIC_AUXADC_BUF_OUT_16_ADDR,
	 MT6328_PMIC_AUXADC_BUF_OUT_16_MASK, MT6328_PMIC_AUXADC_BUF_OUT_16_SHIFT},
	{PMIC_AUXADC_BUF_RDY_16, MT6328_PMIC_AUXADC_BUF_RDY_16_ADDR,
	 MT6328_PMIC_AUXADC_BUF_RDY_16_MASK, MT6328_PMIC_AUXADC_BUF_RDY_16_SHIFT},
	{PMIC_AUXADC_BUF_OUT_17, MT6328_PMIC_AUXADC_BUF_OUT_17_ADDR,
	 MT6328_PMIC_AUXADC_BUF_OUT_17_MASK, MT6328_PMIC_AUXADC_BUF_OUT_17_SHIFT},
	{PMIC_AUXADC_BUF_RDY_17, MT6328_PMIC_AUXADC_BUF_RDY_17_ADDR,
	 MT6328_PMIC_AUXADC_BUF_RDY_17_MASK, MT6328_PMIC_AUXADC_BUF_RDY_17_SHIFT},
	{PMIC_AUXADC_BUF_OUT_18, MT6328_PMIC_AUXADC_BUF_OUT_18_ADDR,
	 MT6328_PMIC_AUXADC_BUF_OUT_18_MASK, MT6328_PMIC_AUXADC_BUF_OUT_18_SHIFT},
	{PMIC_AUXADC_BUF_RDY_18, MT6328_PMIC_AUXADC_BUF_RDY_18_ADDR,
	 MT6328_PMIC_AUXADC_BUF_RDY_18_MASK, MT6328_PMIC_AUXADC_BUF_RDY_18_SHIFT},
	{PMIC_AUXADC_BUF_OUT_19, MT6328_PMIC_AUXADC_BUF_OUT_19_ADDR,
	 MT6328_PMIC_AUXADC_BUF_OUT_19_MASK, MT6328_PMIC_AUXADC_BUF_OUT_19_SHIFT},
	{PMIC_AUXADC_BUF_RDY_19, MT6328_PMIC_AUXADC_BUF_RDY_19_ADDR,
	 MT6328_PMIC_AUXADC_BUF_RDY_19_MASK, MT6328_PMIC_AUXADC_BUF_RDY_19_SHIFT},
	{PMIC_AUXADC_BUF_OUT_20, MT6328_PMIC_AUXADC_BUF_OUT_20_ADDR,
	 MT6328_PMIC_AUXADC_BUF_OUT_20_MASK, MT6328_PMIC_AUXADC_BUF_OUT_20_SHIFT},
	{PMIC_AUXADC_BUF_RDY_20, MT6328_PMIC_AUXADC_BUF_RDY_20_ADDR,
	 MT6328_PMIC_AUXADC_BUF_RDY_20_MASK, MT6328_PMIC_AUXADC_BUF_RDY_20_SHIFT},
	{PMIC_AUXADC_BUF_OUT_21, MT6328_PMIC_AUXADC_BUF_OUT_21_ADDR,
	 MT6328_PMIC_AUXADC_BUF_OUT_21_MASK, MT6328_PMIC_AUXADC_BUF_OUT_21_SHIFT},
	{PMIC_AUXADC_BUF_RDY_21, MT6328_PMIC_AUXADC_BUF_RDY_21_ADDR,
	 MT6328_PMIC_AUXADC_BUF_RDY_21_MASK, MT6328_PMIC_AUXADC_BUF_RDY_21_SHIFT},
	{PMIC_AUXADC_BUF_OUT_22, MT6328_PMIC_AUXADC_BUF_OUT_22_ADDR,
	 MT6328_PMIC_AUXADC_BUF_OUT_22_MASK, MT6328_PMIC_AUXADC_BUF_OUT_22_SHIFT},
	{PMIC_AUXADC_BUF_RDY_22, MT6328_PMIC_AUXADC_BUF_RDY_22_ADDR,
	 MT6328_PMIC_AUXADC_BUF_RDY_22_MASK, MT6328_PMIC_AUXADC_BUF_RDY_22_SHIFT},
	{PMIC_AUXADC_BUF_OUT_23, MT6328_PMIC_AUXADC_BUF_OUT_23_ADDR,
	 MT6328_PMIC_AUXADC_BUF_OUT_23_MASK, MT6328_PMIC_AUXADC_BUF_OUT_23_SHIFT},
	{PMIC_AUXADC_BUF_RDY_23, MT6328_PMIC_AUXADC_BUF_RDY_23_ADDR,
	 MT6328_PMIC_AUXADC_BUF_RDY_23_MASK, MT6328_PMIC_AUXADC_BUF_RDY_23_SHIFT},
	{PMIC_AUXADC_BUF_OUT_24, MT6328_PMIC_AUXADC_BUF_OUT_24_ADDR,
	 MT6328_PMIC_AUXADC_BUF_OUT_24_MASK, MT6328_PMIC_AUXADC_BUF_OUT_24_SHIFT},
	{PMIC_AUXADC_BUF_RDY_24, MT6328_PMIC_AUXADC_BUF_RDY_24_ADDR,
	 MT6328_PMIC_AUXADC_BUF_RDY_24_MASK, MT6328_PMIC_AUXADC_BUF_RDY_24_SHIFT},
	{PMIC_AUXADC_BUF_OUT_25, MT6328_PMIC_AUXADC_BUF_OUT_25_ADDR,
	 MT6328_PMIC_AUXADC_BUF_OUT_25_MASK, MT6328_PMIC_AUXADC_BUF_OUT_25_SHIFT},
	{PMIC_AUXADC_BUF_RDY_25, MT6328_PMIC_AUXADC_BUF_RDY_25_ADDR,
	 MT6328_PMIC_AUXADC_BUF_RDY_25_MASK, MT6328_PMIC_AUXADC_BUF_RDY_25_SHIFT},
	{PMIC_AUXADC_BUF_OUT_26, MT6328_PMIC_AUXADC_BUF_OUT_26_ADDR,
	 MT6328_PMIC_AUXADC_BUF_OUT_26_MASK, MT6328_PMIC_AUXADC_BUF_OUT_26_SHIFT},
	{PMIC_AUXADC_BUF_RDY_26, MT6328_PMIC_AUXADC_BUF_RDY_26_ADDR,
	 MT6328_PMIC_AUXADC_BUF_RDY_26_MASK, MT6328_PMIC_AUXADC_BUF_RDY_26_SHIFT},
	{PMIC_AUXADC_BUF_OUT_27, MT6328_PMIC_AUXADC_BUF_OUT_27_ADDR,
	 MT6328_PMIC_AUXADC_BUF_OUT_27_MASK, MT6328_PMIC_AUXADC_BUF_OUT_27_SHIFT},
	{PMIC_AUXADC_BUF_RDY_27, MT6328_PMIC_AUXADC_BUF_RDY_27_ADDR,
	 MT6328_PMIC_AUXADC_BUF_RDY_27_MASK, MT6328_PMIC_AUXADC_BUF_RDY_27_SHIFT},
	{PMIC_AUXADC_BUF_OUT_28, MT6328_PMIC_AUXADC_BUF_OUT_28_ADDR,
	 MT6328_PMIC_AUXADC_BUF_OUT_28_MASK, MT6328_PMIC_AUXADC_BUF_OUT_28_SHIFT},
	{PMIC_AUXADC_BUF_RDY_28, MT6328_PMIC_AUXADC_BUF_RDY_28_ADDR,
	 MT6328_PMIC_AUXADC_BUF_RDY_28_MASK, MT6328_PMIC_AUXADC_BUF_RDY_28_SHIFT},
	{PMIC_AUXADC_BUF_OUT_29, MT6328_PMIC_AUXADC_BUF_OUT_29_ADDR,
	 MT6328_PMIC_AUXADC_BUF_OUT_29_MASK, MT6328_PMIC_AUXADC_BUF_OUT_29_SHIFT},
	{PMIC_AUXADC_BUF_RDY_29, MT6328_PMIC_AUXADC_BUF_RDY_29_ADDR,
	 MT6328_PMIC_AUXADC_BUF_RDY_29_MASK, MT6328_PMIC_AUXADC_BUF_RDY_29_SHIFT},
	{PMIC_AUXADC_BUF_OUT_30, MT6328_PMIC_AUXADC_BUF_OUT_30_ADDR,
	 MT6328_PMIC_AUXADC_BUF_OUT_30_MASK, MT6328_PMIC_AUXADC_BUF_OUT_30_SHIFT},
	{PMIC_AUXADC_BUF_RDY_30, MT6328_PMIC_AUXADC_BUF_RDY_30_ADDR,
	 MT6328_PMIC_AUXADC_BUF_RDY_30_MASK, MT6328_PMIC_AUXADC_BUF_RDY_30_SHIFT},
	{PMIC_AUXADC_BUF_OUT_31, MT6328_PMIC_AUXADC_BUF_OUT_31_ADDR,
	 MT6328_PMIC_AUXADC_BUF_OUT_31_MASK, MT6328_PMIC_AUXADC_BUF_OUT_31_SHIFT},
	{PMIC_AUXADC_BUF_RDY_31, MT6328_PMIC_AUXADC_BUF_RDY_31_ADDR,
	 MT6328_PMIC_AUXADC_BUF_RDY_31_MASK, MT6328_PMIC_AUXADC_BUF_RDY_31_SHIFT},
	{PMIC_AUXADC_ADC_BUSY_IN, MT6328_PMIC_AUXADC_ADC_BUSY_IN_ADDR,
	 MT6328_PMIC_AUXADC_ADC_BUSY_IN_MASK, MT6328_PMIC_AUXADC_ADC_BUSY_IN_SHIFT},
	{PMIC_AUXADC_ADC_BUSY_IN_LBAT, MT6328_PMIC_AUXADC_ADC_BUSY_IN_LBAT_ADDR,
	 MT6328_PMIC_AUXADC_ADC_BUSY_IN_LBAT_MASK, MT6328_PMIC_AUXADC_ADC_BUSY_IN_LBAT_SHIFT},
	{PMIC_AUXADC_ADC_BUSY_IN_LBAT2, MT6328_PMIC_AUXADC_ADC_BUSY_IN_LBAT2_ADDR,
	 MT6328_PMIC_AUXADC_ADC_BUSY_IN_LBAT2_MASK, MT6328_PMIC_AUXADC_ADC_BUSY_IN_LBAT2_SHIFT},
	{PMIC_AUXADC_ADC_BUSY_IN_VISMPS0, MT6328_PMIC_AUXADC_ADC_BUSY_IN_VISMPS0_ADDR,
	 MT6328_PMIC_AUXADC_ADC_BUSY_IN_VISMPS0_MASK, MT6328_PMIC_AUXADC_ADC_BUSY_IN_VISMPS0_SHIFT},
	{PMIC_AUXADC_ADC_BUSY_IN_WAKEUP, MT6328_PMIC_AUXADC_ADC_BUSY_IN_WAKEUP_ADDR,
	 MT6328_PMIC_AUXADC_ADC_BUSY_IN_WAKEUP_MASK, MT6328_PMIC_AUXADC_ADC_BUSY_IN_WAKEUP_SHIFT},
	{PMIC_AUXADC_ADC_BUSY_IN_MDRT, MT6328_PMIC_AUXADC_ADC_BUSY_IN_MDRT_ADDR,
	 MT6328_PMIC_AUXADC_ADC_BUSY_IN_MDRT_MASK, MT6328_PMIC_AUXADC_ADC_BUSY_IN_MDRT_SHIFT},
	{PMIC_AUXADC_ADC_BUSY_IN_MDBG, MT6328_PMIC_AUXADC_ADC_BUSY_IN_MDBG_ADDR,
	 MT6328_PMIC_AUXADC_ADC_BUSY_IN_MDBG_MASK, MT6328_PMIC_AUXADC_ADC_BUSY_IN_MDBG_SHIFT},
	{PMIC_AUXADC_ADC_BUSY_IN_SHARE, MT6328_PMIC_AUXADC_ADC_BUSY_IN_SHARE_ADDR,
	 MT6328_PMIC_AUXADC_ADC_BUSY_IN_SHARE_MASK, MT6328_PMIC_AUXADC_ADC_BUSY_IN_SHARE_SHIFT},
	{PMIC_AUXADC_ADC_BUSY_IN_IMP, MT6328_PMIC_AUXADC_ADC_BUSY_IN_IMP_ADDR,
	 MT6328_PMIC_AUXADC_ADC_BUSY_IN_IMP_MASK, MT6328_PMIC_AUXADC_ADC_BUSY_IN_IMP_SHIFT},
	{PMIC_AUXADC_ADC_BUSY_IN_FGADC1, MT6328_PMIC_AUXADC_ADC_BUSY_IN_FGADC1_ADDR,
	 MT6328_PMIC_AUXADC_ADC_BUSY_IN_FGADC1_MASK, MT6328_PMIC_AUXADC_ADC_BUSY_IN_FGADC1_SHIFT},
	{PMIC_AUXADC_ADC_BUSY_IN_FGADC2, MT6328_PMIC_AUXADC_ADC_BUSY_IN_FGADC2_ADDR,
	 MT6328_PMIC_AUXADC_ADC_BUSY_IN_FGADC2_MASK, MT6328_PMIC_AUXADC_ADC_BUSY_IN_FGADC2_SHIFT},
	{PMIC_AUXADC_ADC_BUSY_IN_GPS_AP, MT6328_PMIC_AUXADC_ADC_BUSY_IN_GPS_AP_ADDR,
	 MT6328_PMIC_AUXADC_ADC_BUSY_IN_GPS_AP_MASK, MT6328_PMIC_AUXADC_ADC_BUSY_IN_GPS_AP_SHIFT},
	{PMIC_AUXADC_ADC_BUSY_IN_GPS_MD, MT6328_PMIC_AUXADC_ADC_BUSY_IN_GPS_MD_ADDR,
	 MT6328_PMIC_AUXADC_ADC_BUSY_IN_GPS_MD_MASK, MT6328_PMIC_AUXADC_ADC_BUSY_IN_GPS_MD_SHIFT},
	{PMIC_AUXADC_ADC_BUSY_IN_GPS, MT6328_PMIC_AUXADC_ADC_BUSY_IN_GPS_ADDR,
	 MT6328_PMIC_AUXADC_ADC_BUSY_IN_GPS_MASK, MT6328_PMIC_AUXADC_ADC_BUSY_IN_GPS_SHIFT},
	{PMIC_AUXADC_ADC_BUSY_IN_THR_HW, MT6328_PMIC_AUXADC_ADC_BUSY_IN_THR_HW_ADDR,
	 MT6328_PMIC_AUXADC_ADC_BUSY_IN_THR_HW_MASK, MT6328_PMIC_AUXADC_ADC_BUSY_IN_THR_HW_SHIFT},
	{PMIC_AUXADC_ADC_BUSY_IN_THR_MD, MT6328_PMIC_AUXADC_ADC_BUSY_IN_THR_MD_ADDR,
	 MT6328_PMIC_AUXADC_ADC_BUSY_IN_THR_MD_MASK, MT6328_PMIC_AUXADC_ADC_BUSY_IN_THR_MD_SHIFT},
	{PMIC_AUXADC_RQST_CH0, MT6328_PMIC_AUXADC_RQST_CH0_ADDR, MT6328_PMIC_AUXADC_RQST_CH0_MASK,
	 MT6328_PMIC_AUXADC_RQST_CH0_SHIFT},
	{PMIC_AUXADC_RQST_CH1, MT6328_PMIC_AUXADC_RQST_CH1_ADDR, MT6328_PMIC_AUXADC_RQST_CH1_MASK,
	 MT6328_PMIC_AUXADC_RQST_CH1_SHIFT},
	{PMIC_AUXADC_RQST_CH2, MT6328_PMIC_AUXADC_RQST_CH2_ADDR, MT6328_PMIC_AUXADC_RQST_CH2_MASK,
	 MT6328_PMIC_AUXADC_RQST_CH2_SHIFT},
	{PMIC_AUXADC_RQST_CH3, MT6328_PMIC_AUXADC_RQST_CH3_ADDR, MT6328_PMIC_AUXADC_RQST_CH3_MASK,
	 MT6328_PMIC_AUXADC_RQST_CH3_SHIFT},
	{PMIC_AUXADC_RQST_CH4, MT6328_PMIC_AUXADC_RQST_CH4_ADDR, MT6328_PMIC_AUXADC_RQST_CH4_MASK,
	 MT6328_PMIC_AUXADC_RQST_CH4_SHIFT},
	{PMIC_AUXADC_RQST_CH5, MT6328_PMIC_AUXADC_RQST_CH5_ADDR, MT6328_PMIC_AUXADC_RQST_CH5_MASK,
	 MT6328_PMIC_AUXADC_RQST_CH5_SHIFT},
	{PMIC_AUXADC_RQST_CH6, MT6328_PMIC_AUXADC_RQST_CH6_ADDR, MT6328_PMIC_AUXADC_RQST_CH6_MASK,
	 MT6328_PMIC_AUXADC_RQST_CH6_SHIFT},
	{PMIC_AUXADC_RQST_CH7, MT6328_PMIC_AUXADC_RQST_CH7_ADDR, MT6328_PMIC_AUXADC_RQST_CH7_MASK,
	 MT6328_PMIC_AUXADC_RQST_CH7_SHIFT},
	{PMIC_AUXADC_RQST_CH8, MT6328_PMIC_AUXADC_RQST_CH8_ADDR, MT6328_PMIC_AUXADC_RQST_CH8_MASK,
	 MT6328_PMIC_AUXADC_RQST_CH8_SHIFT},
	{PMIC_AUXADC_RQST_CH9, MT6328_PMIC_AUXADC_RQST_CH9_ADDR, MT6328_PMIC_AUXADC_RQST_CH9_MASK,
	 MT6328_PMIC_AUXADC_RQST_CH9_SHIFT},
	{PMIC_AUXADC_RQST_CH10, MT6328_PMIC_AUXADC_RQST_CH10_ADDR,
	 MT6328_PMIC_AUXADC_RQST_CH10_MASK, MT6328_PMIC_AUXADC_RQST_CH10_SHIFT},
	{PMIC_AUXADC_RQST_CH11, MT6328_PMIC_AUXADC_RQST_CH11_ADDR,
	 MT6328_PMIC_AUXADC_RQST_CH11_MASK, MT6328_PMIC_AUXADC_RQST_CH11_SHIFT},
	{PMIC_AUXADC_RQST_CH12, MT6328_PMIC_AUXADC_RQST_CH12_ADDR,
	 MT6328_PMIC_AUXADC_RQST_CH12_MASK, MT6328_PMIC_AUXADC_RQST_CH12_SHIFT},
	{PMIC_AUXADC_RQST_CH13, MT6328_PMIC_AUXADC_RQST_CH13_ADDR,
	 MT6328_PMIC_AUXADC_RQST_CH13_MASK, MT6328_PMIC_AUXADC_RQST_CH13_SHIFT},
	{PMIC_AUXADC_RQST_CH14, MT6328_PMIC_AUXADC_RQST_CH14_ADDR,
	 MT6328_PMIC_AUXADC_RQST_CH14_MASK, MT6328_PMIC_AUXADC_RQST_CH14_SHIFT},
	{PMIC_AUXADC_RQST_CH15, MT6328_PMIC_AUXADC_RQST_CH15_ADDR,
	 MT6328_PMIC_AUXADC_RQST_CH15_MASK, MT6328_PMIC_AUXADC_RQST_CH15_SHIFT},
	{PMIC_AUXADC_RQST0_SET, MT6328_PMIC_AUXADC_RQST0_SET_ADDR,
	 MT6328_PMIC_AUXADC_RQST0_SET_MASK, MT6328_PMIC_AUXADC_RQST0_SET_SHIFT},
	{PMIC_AUXADC_RQST0_CLR, MT6328_PMIC_AUXADC_RQST0_CLR_ADDR,
	 MT6328_PMIC_AUXADC_RQST0_CLR_MASK, MT6328_PMIC_AUXADC_RQST0_CLR_SHIFT},
	{PMIC_AUXADC_RQST_CH0_BY_MD, MT6328_PMIC_AUXADC_RQST_CH0_BY_MD_ADDR,
	 MT6328_PMIC_AUXADC_RQST_CH0_BY_MD_MASK, MT6328_PMIC_AUXADC_RQST_CH0_BY_MD_SHIFT},
	{PMIC_AUXADC_RQST_CH1_BY_MD, MT6328_PMIC_AUXADC_RQST_CH1_BY_MD_ADDR,
	 MT6328_PMIC_AUXADC_RQST_CH1_BY_MD_MASK, MT6328_PMIC_AUXADC_RQST_CH1_BY_MD_SHIFT},
	{PMIC_AUXADC_RQST_RSV0, MT6328_PMIC_AUXADC_RQST_RSV0_ADDR,
	 MT6328_PMIC_AUXADC_RQST_RSV0_MASK, MT6328_PMIC_AUXADC_RQST_RSV0_SHIFT},
	{PMIC_AUXADC_RQST_CH4_BY_MD, MT6328_PMIC_AUXADC_RQST_CH4_BY_MD_ADDR,
	 MT6328_PMIC_AUXADC_RQST_CH4_BY_MD_MASK, MT6328_PMIC_AUXADC_RQST_CH4_BY_MD_SHIFT},
	{PMIC_AUXADC_RQST_CH7_BY_MD, MT6328_PMIC_AUXADC_RQST_CH7_BY_MD_ADDR,
	 MT6328_PMIC_AUXADC_RQST_CH7_BY_MD_MASK, MT6328_PMIC_AUXADC_RQST_CH7_BY_MD_SHIFT},
	{PMIC_AUXADC_RQST_CH7_BY_GPS, MT6328_PMIC_AUXADC_RQST_CH7_BY_GPS_ADDR,
	 MT6328_PMIC_AUXADC_RQST_CH7_BY_GPS_MASK, MT6328_PMIC_AUXADC_RQST_CH7_BY_GPS_SHIFT},
	{PMIC_AUXADC_RQST_RSV1, MT6328_PMIC_AUXADC_RQST_RSV1_ADDR,
	 MT6328_PMIC_AUXADC_RQST_RSV1_MASK, MT6328_PMIC_AUXADC_RQST_RSV1_SHIFT},
	{PMIC_AUXADC_RQST1_SET, MT6328_PMIC_AUXADC_RQST1_SET_ADDR,
	 MT6328_PMIC_AUXADC_RQST1_SET_MASK, MT6328_PMIC_AUXADC_RQST1_SET_SHIFT},
	{PMIC_AUXADC_RQST1_CLR, MT6328_PMIC_AUXADC_RQST1_CLR_ADDR,
	 MT6328_PMIC_AUXADC_RQST1_CLR_MASK, MT6328_PMIC_AUXADC_RQST1_CLR_SHIFT},
	{PMIC_AUXADC_CK_ON_EXTD, MT6328_PMIC_AUXADC_CK_ON_EXTD_ADDR,
	 MT6328_PMIC_AUXADC_CK_ON_EXTD_MASK, MT6328_PMIC_AUXADC_CK_ON_EXTD_SHIFT},
	{PMIC_AUXADC_SRCLKEN_SRC_SEL, MT6328_PMIC_AUXADC_SRCLKEN_SRC_SEL_ADDR,
	 MT6328_PMIC_AUXADC_SRCLKEN_SRC_SEL_MASK, MT6328_PMIC_AUXADC_SRCLKEN_SRC_SEL_SHIFT},
	{PMIC_AUXADC_ADC_PWDB, MT6328_PMIC_AUXADC_ADC_PWDB_ADDR, MT6328_PMIC_AUXADC_ADC_PWDB_MASK,
	 MT6328_PMIC_AUXADC_ADC_PWDB_SHIFT},
	{PMIC_AUXADC_ADC_PWDB_SWCTRL, MT6328_PMIC_AUXADC_ADC_PWDB_SWCTRL_ADDR,
	 MT6328_PMIC_AUXADC_ADC_PWDB_SWCTRL_MASK, MT6328_PMIC_AUXADC_ADC_PWDB_SWCTRL_SHIFT},
	{PMIC_AUXADC_STRUP_CK_ON_ENB, MT6328_PMIC_AUXADC_STRUP_CK_ON_ENB_ADDR,
	 MT6328_PMIC_AUXADC_STRUP_CK_ON_ENB_MASK, MT6328_PMIC_AUXADC_STRUP_CK_ON_ENB_SHIFT},
	{PMIC_AUXADC_ADC_RDY_WAKEUP_CLR, MT6328_PMIC_AUXADC_ADC_RDY_WAKEUP_CLR_ADDR,
	 MT6328_PMIC_AUXADC_ADC_RDY_WAKEUP_CLR_MASK, MT6328_PMIC_AUXADC_ADC_RDY_WAKEUP_CLR_SHIFT},
	{PMIC_AUXADC_SRCLKEN_CK_EN, MT6328_PMIC_AUXADC_SRCLKEN_CK_EN_ADDR,
	 MT6328_PMIC_AUXADC_SRCLKEN_CK_EN_MASK, MT6328_PMIC_AUXADC_SRCLKEN_CK_EN_SHIFT},
	{PMIC_AUXADC_CK_AON_GPS, MT6328_PMIC_AUXADC_CK_AON_GPS_ADDR,
	 MT6328_PMIC_AUXADC_CK_AON_GPS_MASK, MT6328_PMIC_AUXADC_CK_AON_GPS_SHIFT},
	{PMIC_AUXADC_CK_AON_MD, MT6328_PMIC_AUXADC_CK_AON_MD_ADDR,
	 MT6328_PMIC_AUXADC_CK_AON_MD_MASK, MT6328_PMIC_AUXADC_CK_AON_MD_SHIFT},
	{PMIC_AUXADC_CK_AON, MT6328_PMIC_AUXADC_CK_AON_ADDR, MT6328_PMIC_AUXADC_CK_AON_MASK,
	 MT6328_PMIC_AUXADC_CK_AON_SHIFT},
	{PMIC_AUXADC_CON0_SET, MT6328_PMIC_AUXADC_CON0_SET_ADDR, MT6328_PMIC_AUXADC_CON0_SET_MASK,
	 MT6328_PMIC_AUXADC_CON0_SET_SHIFT},
	{PMIC_AUXADC_CON0_CLR, MT6328_PMIC_AUXADC_CON0_CLR_ADDR, MT6328_PMIC_AUXADC_CON0_CLR_MASK,
	 MT6328_PMIC_AUXADC_CON0_CLR_SHIFT},
	{PMIC_AUXADC_AVG_NUM_SMALL, MT6328_PMIC_AUXADC_AVG_NUM_SMALL_ADDR,
	 MT6328_PMIC_AUXADC_AVG_NUM_SMALL_MASK, MT6328_PMIC_AUXADC_AVG_NUM_SMALL_SHIFT},
	{PMIC_AUXADC_AVG_NUM_LARGE, MT6328_PMIC_AUXADC_AVG_NUM_LARGE_ADDR,
	 MT6328_PMIC_AUXADC_AVG_NUM_LARGE_MASK, MT6328_PMIC_AUXADC_AVG_NUM_LARGE_SHIFT},
	{PMIC_AUXADC_SPL_NUM, MT6328_PMIC_AUXADC_SPL_NUM_ADDR, MT6328_PMIC_AUXADC_SPL_NUM_MASK,
	 MT6328_PMIC_AUXADC_SPL_NUM_SHIFT},
	{PMIC_AUXADC_AVG_NUM_SEL, MT6328_PMIC_AUXADC_AVG_NUM_SEL_ADDR,
	 MT6328_PMIC_AUXADC_AVG_NUM_SEL_MASK, MT6328_PMIC_AUXADC_AVG_NUM_SEL_SHIFT},
	{PMIC_AUXADC_AVG_NUM_SEL_SHARE, MT6328_PMIC_AUXADC_AVG_NUM_SEL_SHARE_ADDR,
	 MT6328_PMIC_AUXADC_AVG_NUM_SEL_SHARE_MASK, MT6328_PMIC_AUXADC_AVG_NUM_SEL_SHARE_SHIFT},
	{PMIC_AUXADC_AVG_NUM_SEL_LBAT, MT6328_PMIC_AUXADC_AVG_NUM_SEL_LBAT_ADDR,
	 MT6328_PMIC_AUXADC_AVG_NUM_SEL_LBAT_MASK, MT6328_PMIC_AUXADC_AVG_NUM_SEL_LBAT_SHIFT},
	{PMIC_AUXADC_AVG_NUM_SEL_VISMPS, MT6328_PMIC_AUXADC_AVG_NUM_SEL_VISMPS_ADDR,
	 MT6328_PMIC_AUXADC_AVG_NUM_SEL_VISMPS_MASK, MT6328_PMIC_AUXADC_AVG_NUM_SEL_VISMPS_SHIFT},
	{PMIC_AUXADC_AVG_NUM_SEL_WAKEUP, MT6328_PMIC_AUXADC_AVG_NUM_SEL_WAKEUP_ADDR,
	 MT6328_PMIC_AUXADC_AVG_NUM_SEL_WAKEUP_MASK, MT6328_PMIC_AUXADC_AVG_NUM_SEL_WAKEUP_SHIFT},
	{PMIC_AUXADC_SPL_NUM_LARGE, MT6328_PMIC_AUXADC_SPL_NUM_LARGE_ADDR,
	 MT6328_PMIC_AUXADC_SPL_NUM_LARGE_MASK, MT6328_PMIC_AUXADC_SPL_NUM_LARGE_SHIFT},
	{PMIC_AUXADC_SPL_NUM_SLEEP, MT6328_PMIC_AUXADC_SPL_NUM_SLEEP_ADDR,
	 MT6328_PMIC_AUXADC_SPL_NUM_SLEEP_MASK, MT6328_PMIC_AUXADC_SPL_NUM_SLEEP_SHIFT},
	{PMIC_AUXADC_SPL_NUM_SLEEP_SEL, MT6328_PMIC_AUXADC_SPL_NUM_SLEEP_SEL_ADDR,
	 MT6328_PMIC_AUXADC_SPL_NUM_SLEEP_SEL_MASK, MT6328_PMIC_AUXADC_SPL_NUM_SLEEP_SEL_SHIFT},
	{PMIC_AUXADC_SPL_NUM_SEL, MT6328_PMIC_AUXADC_SPL_NUM_SEL_ADDR,
	 MT6328_PMIC_AUXADC_SPL_NUM_SEL_MASK, MT6328_PMIC_AUXADC_SPL_NUM_SEL_SHIFT},
	{PMIC_AUXADC_SPL_NUM_SEL_SHARE, MT6328_PMIC_AUXADC_SPL_NUM_SEL_SHARE_ADDR,
	 MT6328_PMIC_AUXADC_SPL_NUM_SEL_SHARE_MASK, MT6328_PMIC_AUXADC_SPL_NUM_SEL_SHARE_SHIFT},
	{PMIC_AUXADC_SPL_NUM_SEL_LBAT, MT6328_PMIC_AUXADC_SPL_NUM_SEL_LBAT_ADDR,
	 MT6328_PMIC_AUXADC_SPL_NUM_SEL_LBAT_MASK, MT6328_PMIC_AUXADC_SPL_NUM_SEL_LBAT_SHIFT},
	{PMIC_AUXADC_SPL_NUM_SEL_VISMPS, MT6328_PMIC_AUXADC_SPL_NUM_SEL_VISMPS_ADDR,
	 MT6328_PMIC_AUXADC_SPL_NUM_SEL_VISMPS_MASK, MT6328_PMIC_AUXADC_SPL_NUM_SEL_VISMPS_SHIFT},
	{PMIC_AUXADC_SPL_NUM_SEL_WAKEUP, MT6328_PMIC_AUXADC_SPL_NUM_SEL_WAKEUP_ADDR,
	 MT6328_PMIC_AUXADC_SPL_NUM_SEL_WAKEUP_MASK, MT6328_PMIC_AUXADC_SPL_NUM_SEL_WAKEUP_SHIFT},
	{PMIC_AUXADC_TRIM_CH0_SEL, MT6328_PMIC_AUXADC_TRIM_CH0_SEL_ADDR,
	 MT6328_PMIC_AUXADC_TRIM_CH0_SEL_MASK, MT6328_PMIC_AUXADC_TRIM_CH0_SEL_SHIFT},
	{PMIC_AUXADC_TRIM_CH1_SEL, MT6328_PMIC_AUXADC_TRIM_CH1_SEL_ADDR,
	 MT6328_PMIC_AUXADC_TRIM_CH1_SEL_MASK, MT6328_PMIC_AUXADC_TRIM_CH1_SEL_SHIFT},
	{PMIC_AUXADC_TRIM_CH2_SEL, MT6328_PMIC_AUXADC_TRIM_CH2_SEL_ADDR,
	 MT6328_PMIC_AUXADC_TRIM_CH2_SEL_MASK, MT6328_PMIC_AUXADC_TRIM_CH2_SEL_SHIFT},
	{PMIC_AUXADC_TRIM_CH3_SEL, MT6328_PMIC_AUXADC_TRIM_CH3_SEL_ADDR,
	 MT6328_PMIC_AUXADC_TRIM_CH3_SEL_MASK, MT6328_PMIC_AUXADC_TRIM_CH3_SEL_SHIFT},
	{PMIC_AUXADC_TRIM_CH4_SEL, MT6328_PMIC_AUXADC_TRIM_CH4_SEL_ADDR,
	 MT6328_PMIC_AUXADC_TRIM_CH4_SEL_MASK, MT6328_PMIC_AUXADC_TRIM_CH4_SEL_SHIFT},
	{PMIC_AUXADC_TRIM_CH5_SEL, MT6328_PMIC_AUXADC_TRIM_CH5_SEL_ADDR,
	 MT6328_PMIC_AUXADC_TRIM_CH5_SEL_MASK, MT6328_PMIC_AUXADC_TRIM_CH5_SEL_SHIFT},
	{PMIC_AUXADC_TRIM_CH6_SEL, MT6328_PMIC_AUXADC_TRIM_CH6_SEL_ADDR,
	 MT6328_PMIC_AUXADC_TRIM_CH6_SEL_MASK, MT6328_PMIC_AUXADC_TRIM_CH6_SEL_SHIFT},
	{PMIC_AUXADC_TRIM_CH7_SEL, MT6328_PMIC_AUXADC_TRIM_CH7_SEL_ADDR,
	 MT6328_PMIC_AUXADC_TRIM_CH7_SEL_MASK, MT6328_PMIC_AUXADC_TRIM_CH7_SEL_SHIFT},
	{PMIC_AUXADC_TRIM_CH8_SEL, MT6328_PMIC_AUXADC_TRIM_CH8_SEL_ADDR,
	 MT6328_PMIC_AUXADC_TRIM_CH8_SEL_MASK, MT6328_PMIC_AUXADC_TRIM_CH8_SEL_SHIFT},
	{PMIC_AUXADC_TRIM_CH9_SEL, MT6328_PMIC_AUXADC_TRIM_CH9_SEL_ADDR,
	 MT6328_PMIC_AUXADC_TRIM_CH9_SEL_MASK, MT6328_PMIC_AUXADC_TRIM_CH9_SEL_SHIFT},
	{PMIC_AUXADC_TRIM_CH10_SEL, MT6328_PMIC_AUXADC_TRIM_CH10_SEL_ADDR,
	 MT6328_PMIC_AUXADC_TRIM_CH10_SEL_MASK, MT6328_PMIC_AUXADC_TRIM_CH10_SEL_SHIFT},
	{PMIC_AUXADC_TRIM_CH11_SEL, MT6328_PMIC_AUXADC_TRIM_CH11_SEL_ADDR,
	 MT6328_PMIC_AUXADC_TRIM_CH11_SEL_MASK, MT6328_PMIC_AUXADC_TRIM_CH11_SEL_SHIFT},
	{PMIC_AUXADC_ADC_2S_COMP_ENB, MT6328_PMIC_AUXADC_ADC_2S_COMP_ENB_ADDR,
	 MT6328_PMIC_AUXADC_ADC_2S_COMP_ENB_MASK, MT6328_PMIC_AUXADC_ADC_2S_COMP_ENB_SHIFT},
	{PMIC_AUXADC_ADC_TRIM_COMP, MT6328_PMIC_AUXADC_ADC_TRIM_COMP_ADDR,
	 MT6328_PMIC_AUXADC_ADC_TRIM_COMP_MASK, MT6328_PMIC_AUXADC_ADC_TRIM_COMP_SHIFT},
	{PMIC_AUXADC_SW_GAIN_TRIM, MT6328_PMIC_AUXADC_SW_GAIN_TRIM_ADDR,
	 MT6328_PMIC_AUXADC_SW_GAIN_TRIM_MASK, MT6328_PMIC_AUXADC_SW_GAIN_TRIM_SHIFT},
	{PMIC_AUXADC_SW_OFFSET_TRIM, MT6328_PMIC_AUXADC_SW_OFFSET_TRIM_ADDR,
	 MT6328_PMIC_AUXADC_SW_OFFSET_TRIM_MASK, MT6328_PMIC_AUXADC_SW_OFFSET_TRIM_SHIFT},
	{PMIC_AUXADC_RNG_EN, MT6328_PMIC_AUXADC_RNG_EN_ADDR, MT6328_PMIC_AUXADC_RNG_EN_MASK,
	 MT6328_PMIC_AUXADC_RNG_EN_SHIFT},
	{PMIC_AUXADC_DATA_REUSE_SEL, MT6328_PMIC_AUXADC_DATA_REUSE_SEL_ADDR,
	 MT6328_PMIC_AUXADC_DATA_REUSE_SEL_MASK, MT6328_PMIC_AUXADC_DATA_REUSE_SEL_SHIFT},
	{PMIC_AUXADC_TEST_MODE, MT6328_PMIC_AUXADC_TEST_MODE_ADDR,
	 MT6328_PMIC_AUXADC_TEST_MODE_MASK, MT6328_PMIC_AUXADC_TEST_MODE_SHIFT},
	{PMIC_AUXADC_BIT_SEL, MT6328_PMIC_AUXADC_BIT_SEL_ADDR, MT6328_PMIC_AUXADC_BIT_SEL_MASK,
	 MT6328_PMIC_AUXADC_BIT_SEL_SHIFT},
	{PMIC_AUXADC_START_SW, MT6328_PMIC_AUXADC_START_SW_ADDR, MT6328_PMIC_AUXADC_START_SW_MASK,
	 MT6328_PMIC_AUXADC_START_SW_SHIFT},
	{PMIC_AUXADC_START_SWCTRL, MT6328_PMIC_AUXADC_START_SWCTRL_ADDR,
	 MT6328_PMIC_AUXADC_START_SWCTRL_MASK, MT6328_PMIC_AUXADC_START_SWCTRL_SHIFT},
	{PMIC_AUXADC_OUT_SEL, MT6328_PMIC_AUXADC_OUT_SEL_ADDR, MT6328_PMIC_AUXADC_OUT_SEL_MASK,
	 MT6328_PMIC_AUXADC_OUT_SEL_SHIFT},
	{PMIC_AUXADC_DA_DAC, MT6328_PMIC_AUXADC_DA_DAC_ADDR, MT6328_PMIC_AUXADC_DA_DAC_MASK,
	 MT6328_PMIC_AUXADC_DA_DAC_SHIFT},
	{PMIC_AUXADC_DA_DAC_SWCTRL, MT6328_PMIC_AUXADC_DA_DAC_SWCTRL_ADDR,
	 MT6328_PMIC_AUXADC_DA_DAC_SWCTRL_MASK, MT6328_PMIC_AUXADC_DA_DAC_SWCTRL_SHIFT},
	{PMIC_AD_AUXADC_COMP, MT6328_PMIC_AD_AUXADC_COMP_ADDR, MT6328_PMIC_AD_AUXADC_COMP_MASK,
	 MT6328_PMIC_AD_AUXADC_COMP_SHIFT},
	{PMIC_RG_VBUF_EXTEN, MT6328_PMIC_RG_VBUF_EXTEN_ADDR, MT6328_PMIC_RG_VBUF_EXTEN_MASK,
	 MT6328_PMIC_RG_VBUF_EXTEN_SHIFT},
	{PMIC_RG_VBUF_CALEN, MT6328_PMIC_RG_VBUF_CALEN_ADDR, MT6328_PMIC_RG_VBUF_CALEN_MASK,
	 MT6328_PMIC_RG_VBUF_CALEN_SHIFT},
	{PMIC_RG_VBUF_BYP, MT6328_PMIC_RG_VBUF_BYP_ADDR, MT6328_PMIC_RG_VBUF_BYP_MASK,
	 MT6328_PMIC_RG_VBUF_BYP_SHIFT},
	{PMIC_RG_VBUF_EN, MT6328_PMIC_RG_VBUF_EN_ADDR, MT6328_PMIC_RG_VBUF_EN_MASK,
	 MT6328_PMIC_RG_VBUF_EN_SHIFT},
	{PMIC_RG_AUX_RSV, MT6328_PMIC_RG_AUX_RSV_ADDR, MT6328_PMIC_RG_AUX_RSV_MASK,
	 MT6328_PMIC_RG_AUX_RSV_SHIFT},
	{PMIC_RG_AUXADC_CALI, MT6328_PMIC_RG_AUXADC_CALI_ADDR, MT6328_PMIC_RG_AUXADC_CALI_MASK,
	 MT6328_PMIC_RG_AUXADC_CALI_SHIFT},
	{PMIC_AUXADC_ADCIN_VSEN_EN, MT6328_PMIC_AUXADC_ADCIN_VSEN_EN_ADDR,
	 MT6328_PMIC_AUXADC_ADCIN_VSEN_EN_MASK, MT6328_PMIC_AUXADC_ADCIN_VSEN_EN_SHIFT},
	{PMIC_AUXADC_ADCIN_VBAT_EN, MT6328_PMIC_AUXADC_ADCIN_VBAT_EN_ADDR,
	 MT6328_PMIC_AUXADC_ADCIN_VBAT_EN_MASK, MT6328_PMIC_AUXADC_ADCIN_VBAT_EN_SHIFT},
	{PMIC_AUXADC_ADCIN_VSEN_MUX_EN, MT6328_PMIC_AUXADC_ADCIN_VSEN_MUX_EN_ADDR,
	 MT6328_PMIC_AUXADC_ADCIN_VSEN_MUX_EN_MASK, MT6328_PMIC_AUXADC_ADCIN_VSEN_MUX_EN_SHIFT},
	{PMIC_AUXADC_ADCIN_VSEN_EXT_BATON_EN, MT6328_PMIC_AUXADC_ADCIN_VSEN_EXT_BATON_EN_ADDR,
	 MT6328_PMIC_AUXADC_ADCIN_VSEN_EXT_BATON_EN_MASK,
	 MT6328_PMIC_AUXADC_ADCIN_VSEN_EXT_BATON_EN_SHIFT},
	{PMIC_AUXADC_ADCIN_CHR_EN, MT6328_PMIC_AUXADC_ADCIN_CHR_EN_ADDR,
	 MT6328_PMIC_AUXADC_ADCIN_CHR_EN_MASK, MT6328_PMIC_AUXADC_ADCIN_CHR_EN_SHIFT},
	{PMIC_AUXADC_ADCIN_BATON_TDET_EN, MT6328_PMIC_AUXADC_ADCIN_BATON_TDET_EN_ADDR,
	 MT6328_PMIC_AUXADC_ADCIN_BATON_TDET_EN_MASK, MT6328_PMIC_AUXADC_ADCIN_BATON_TDET_EN_SHIFT},
	{PMIC_AUXADC_ACCDET_ANASWCTRL_EN, MT6328_PMIC_AUXADC_ACCDET_ANASWCTRL_EN_ADDR,
	 MT6328_PMIC_AUXADC_ACCDET_ANASWCTRL_EN_MASK, MT6328_PMIC_AUXADC_ACCDET_ANASWCTRL_EN_SHIFT},
	{PMIC_AUXADC_DIG0_RSV0, MT6328_PMIC_AUXADC_DIG0_RSV0_ADDR,
	 MT6328_PMIC_AUXADC_DIG0_RSV0_MASK, MT6328_PMIC_AUXADC_DIG0_RSV0_SHIFT},
	{PMIC_AUXADC_CHSEL, MT6328_PMIC_AUXADC_CHSEL_ADDR, MT6328_PMIC_AUXADC_CHSEL_MASK,
	 MT6328_PMIC_AUXADC_CHSEL_SHIFT},
	{PMIC_AUXADC_SWCTRL_EN, MT6328_PMIC_AUXADC_SWCTRL_EN_ADDR,
	 MT6328_PMIC_AUXADC_SWCTRL_EN_MASK, MT6328_PMIC_AUXADC_SWCTRL_EN_SHIFT},
	{PMIC_AUXADC_SOURCE_LBAT_SEL, MT6328_PMIC_AUXADC_SOURCE_LBAT_SEL_ADDR,
	 MT6328_PMIC_AUXADC_SOURCE_LBAT_SEL_MASK, MT6328_PMIC_AUXADC_SOURCE_LBAT_SEL_SHIFT},
	{PMIC_AUXADC_SOURCE_LBAT2_SEL, MT6328_PMIC_AUXADC_SOURCE_LBAT2_SEL_ADDR,
	 MT6328_PMIC_AUXADC_SOURCE_LBAT2_SEL_MASK, MT6328_PMIC_AUXADC_SOURCE_LBAT2_SEL_SHIFT},
	{PMIC_AUXADC_DIG0_RSV2, MT6328_PMIC_AUXADC_DIG0_RSV2_ADDR,
	 MT6328_PMIC_AUXADC_DIG0_RSV2_MASK, MT6328_PMIC_AUXADC_DIG0_RSV2_SHIFT},
	{PMIC_AUXADC_DIG1_RSV2, MT6328_PMIC_AUXADC_DIG1_RSV2_ADDR,
	 MT6328_PMIC_AUXADC_DIG1_RSV2_MASK, MT6328_PMIC_AUXADC_DIG1_RSV2_SHIFT},
	{PMIC_AUXADC_DAC_EXTD, MT6328_PMIC_AUXADC_DAC_EXTD_ADDR, MT6328_PMIC_AUXADC_DAC_EXTD_MASK,
	 MT6328_PMIC_AUXADC_DAC_EXTD_SHIFT},
	{PMIC_AUXADC_DAC_EXTD_EN, MT6328_PMIC_AUXADC_DAC_EXTD_EN_ADDR,
	 MT6328_PMIC_AUXADC_DAC_EXTD_EN_MASK, MT6328_PMIC_AUXADC_DAC_EXTD_EN_SHIFT},
	{PMIC_AUXADC_PMU_THR_PDN_SW, MT6328_PMIC_AUXADC_PMU_THR_PDN_SW_ADDR,
	 MT6328_PMIC_AUXADC_PMU_THR_PDN_SW_MASK, MT6328_PMIC_AUXADC_PMU_THR_PDN_SW_SHIFT},
	{PMIC_AUXADC_PMU_THR_PDN_SEL, MT6328_PMIC_AUXADC_PMU_THR_PDN_SEL_ADDR,
	 MT6328_PMIC_AUXADC_PMU_THR_PDN_SEL_MASK, MT6328_PMIC_AUXADC_PMU_THR_PDN_SEL_SHIFT},
	{PMIC_AUXADC_PMU_THR_PDN_STATUS, MT6328_PMIC_AUXADC_PMU_THR_PDN_STATUS_ADDR,
	 MT6328_PMIC_AUXADC_PMU_THR_PDN_STATUS_MASK, MT6328_PMIC_AUXADC_PMU_THR_PDN_STATUS_SHIFT},
	{PMIC_AUXADC_DIG0_RSV1, MT6328_PMIC_AUXADC_DIG0_RSV1_ADDR,
	 MT6328_PMIC_AUXADC_DIG0_RSV1_MASK, MT6328_PMIC_AUXADC_DIG0_RSV1_SHIFT},
	{PMIC_AUXADC_START_SHADE_NUM, MT6328_PMIC_AUXADC_START_SHADE_NUM_ADDR,
	 MT6328_PMIC_AUXADC_START_SHADE_NUM_MASK, MT6328_PMIC_AUXADC_START_SHADE_NUM_SHIFT},
	{PMIC_AUXADC_START_SHADE_EN, MT6328_PMIC_AUXADC_START_SHADE_EN_ADDR,
	 MT6328_PMIC_AUXADC_START_SHADE_EN_MASK, MT6328_PMIC_AUXADC_START_SHADE_EN_SHIFT},
	{PMIC_AUXADC_START_SHADE_SEL, MT6328_PMIC_AUXADC_START_SHADE_SEL_ADDR,
	 MT6328_PMIC_AUXADC_START_SHADE_SEL_MASK, MT6328_PMIC_AUXADC_START_SHADE_SEL_SHIFT},
	{PMIC_AUXADC_AUTORPT_PRD, MT6328_PMIC_AUXADC_AUTORPT_PRD_ADDR,
	 MT6328_PMIC_AUXADC_AUTORPT_PRD_MASK, MT6328_PMIC_AUXADC_AUTORPT_PRD_SHIFT},
	{PMIC_AUXADC_AUTORPT_EN, MT6328_PMIC_AUXADC_AUTORPT_EN_ADDR,
	 MT6328_PMIC_AUXADC_AUTORPT_EN_MASK, MT6328_PMIC_AUXADC_AUTORPT_EN_SHIFT},
	{PMIC_AUXADC_LBAT_DEBT_MAX, MT6328_PMIC_AUXADC_LBAT_DEBT_MAX_ADDR,
	 MT6328_PMIC_AUXADC_LBAT_DEBT_MAX_MASK, MT6328_PMIC_AUXADC_LBAT_DEBT_MAX_SHIFT},
	{PMIC_AUXADC_LBAT_DEBT_MIN, MT6328_PMIC_AUXADC_LBAT_DEBT_MIN_ADDR,
	 MT6328_PMIC_AUXADC_LBAT_DEBT_MIN_MASK, MT6328_PMIC_AUXADC_LBAT_DEBT_MIN_SHIFT},
	{PMIC_AUXADC_LBAT_DET_PRD_15_0, MT6328_PMIC_AUXADC_LBAT_DET_PRD_15_0_ADDR,
	 MT6328_PMIC_AUXADC_LBAT_DET_PRD_15_0_MASK, MT6328_PMIC_AUXADC_LBAT_DET_PRD_15_0_SHIFT},
	{PMIC_AUXADC_LBAT_DET_PRD_19_16, MT6328_PMIC_AUXADC_LBAT_DET_PRD_19_16_ADDR,
	 MT6328_PMIC_AUXADC_LBAT_DET_PRD_19_16_MASK, MT6328_PMIC_AUXADC_LBAT_DET_PRD_19_16_SHIFT},
	{PMIC_AUXADC_LBAT_VOLT_MAX, MT6328_PMIC_AUXADC_LBAT_VOLT_MAX_ADDR,
	 MT6328_PMIC_AUXADC_LBAT_VOLT_MAX_MASK, MT6328_PMIC_AUXADC_LBAT_VOLT_MAX_SHIFT},
	{PMIC_AUXADC_LBAT_IRQ_EN_MAX, MT6328_PMIC_AUXADC_LBAT_IRQ_EN_MAX_ADDR,
	 MT6328_PMIC_AUXADC_LBAT_IRQ_EN_MAX_MASK, MT6328_PMIC_AUXADC_LBAT_IRQ_EN_MAX_SHIFT},
	{PMIC_AUXADC_LBAT_EN_MAX, MT6328_PMIC_AUXADC_LBAT_EN_MAX_ADDR,
	 MT6328_PMIC_AUXADC_LBAT_EN_MAX_MASK, MT6328_PMIC_AUXADC_LBAT_EN_MAX_SHIFT},
	{PMIC_AUXADC_LBAT_MAX_IRQ_B, MT6328_PMIC_AUXADC_LBAT_MAX_IRQ_B_ADDR,
	 MT6328_PMIC_AUXADC_LBAT_MAX_IRQ_B_MASK, MT6328_PMIC_AUXADC_LBAT_MAX_IRQ_B_SHIFT},
	{PMIC_AUXADC_LBAT_VOLT_MIN, MT6328_PMIC_AUXADC_LBAT_VOLT_MIN_ADDR,
	 MT6328_PMIC_AUXADC_LBAT_VOLT_MIN_MASK, MT6328_PMIC_AUXADC_LBAT_VOLT_MIN_SHIFT},
	{PMIC_AUXADC_LBAT_IRQ_EN_MIN, MT6328_PMIC_AUXADC_LBAT_IRQ_EN_MIN_ADDR,
	 MT6328_PMIC_AUXADC_LBAT_IRQ_EN_MIN_MASK, MT6328_PMIC_AUXADC_LBAT_IRQ_EN_MIN_SHIFT},
	{PMIC_AUXADC_LBAT_EN_MIN, MT6328_PMIC_AUXADC_LBAT_EN_MIN_ADDR,
	 MT6328_PMIC_AUXADC_LBAT_EN_MIN_MASK, MT6328_PMIC_AUXADC_LBAT_EN_MIN_SHIFT},
	{PMIC_AUXADC_LBAT_MIN_IRQ_B, MT6328_PMIC_AUXADC_LBAT_MIN_IRQ_B_ADDR,
	 MT6328_PMIC_AUXADC_LBAT_MIN_IRQ_B_MASK, MT6328_PMIC_AUXADC_LBAT_MIN_IRQ_B_SHIFT},
	{PMIC_AUXADC_LBAT_DEBOUNCE_COUNT_MAX, MT6328_PMIC_AUXADC_LBAT_DEBOUNCE_COUNT_MAX_ADDR,
	 MT6328_PMIC_AUXADC_LBAT_DEBOUNCE_COUNT_MAX_MASK,
	 MT6328_PMIC_AUXADC_LBAT_DEBOUNCE_COUNT_MAX_SHIFT},
	{PMIC_AUXADC_LBAT_DEBOUNCE_COUNT_MIN, MT6328_PMIC_AUXADC_LBAT_DEBOUNCE_COUNT_MIN_ADDR,
	 MT6328_PMIC_AUXADC_LBAT_DEBOUNCE_COUNT_MIN_MASK,
	 MT6328_PMIC_AUXADC_LBAT_DEBOUNCE_COUNT_MIN_SHIFT},
	{PMIC_AUXADC_ACCDET_AUTO_SPL, MT6328_PMIC_AUXADC_ACCDET_AUTO_SPL_ADDR,
	 MT6328_PMIC_AUXADC_ACCDET_AUTO_SPL_MASK, MT6328_PMIC_AUXADC_ACCDET_AUTO_SPL_SHIFT},
	{PMIC_AUXADC_ACCDET_AUTO_RQST_CLR, MT6328_PMIC_AUXADC_ACCDET_AUTO_RQST_CLR_ADDR,
	 MT6328_PMIC_AUXADC_ACCDET_AUTO_RQST_CLR_MASK,
	 MT6328_PMIC_AUXADC_ACCDET_AUTO_RQST_CLR_SHIFT},
	{PMIC_AUXADC_ACCDET_DIG1_RSV0, MT6328_PMIC_AUXADC_ACCDET_DIG1_RSV0_ADDR,
	 MT6328_PMIC_AUXADC_ACCDET_DIG1_RSV0_MASK, MT6328_PMIC_AUXADC_ACCDET_DIG1_RSV0_SHIFT},
	{PMIC_AUXADC_ACCDET_DIG0_RSV0, MT6328_PMIC_AUXADC_ACCDET_DIG0_RSV0_ADDR,
	 MT6328_PMIC_AUXADC_ACCDET_DIG0_RSV0_MASK, MT6328_PMIC_AUXADC_ACCDET_DIG0_RSV0_SHIFT},
	{PMIC_AUXADC_THR_DEBT_MAX, MT6328_PMIC_AUXADC_THR_DEBT_MAX_ADDR,
	 MT6328_PMIC_AUXADC_THR_DEBT_MAX_MASK, MT6328_PMIC_AUXADC_THR_DEBT_MAX_SHIFT},
	{PMIC_AUXADC_THR_DEBT_MIN, MT6328_PMIC_AUXADC_THR_DEBT_MIN_ADDR,
	 MT6328_PMIC_AUXADC_THR_DEBT_MIN_MASK, MT6328_PMIC_AUXADC_THR_DEBT_MIN_SHIFT},
	{PMIC_AUXADC_THR_DET_PRD_15_0, MT6328_PMIC_AUXADC_THR_DET_PRD_15_0_ADDR,
	 MT6328_PMIC_AUXADC_THR_DET_PRD_15_0_MASK, MT6328_PMIC_AUXADC_THR_DET_PRD_15_0_SHIFT},
	{PMIC_AUXADC_THR_DET_PRD_19_16, MT6328_PMIC_AUXADC_THR_DET_PRD_19_16_ADDR,
	 MT6328_PMIC_AUXADC_THR_DET_PRD_19_16_MASK, MT6328_PMIC_AUXADC_THR_DET_PRD_19_16_SHIFT},
	{PMIC_AUXADC_THR_VOLT_MAX, MT6328_PMIC_AUXADC_THR_VOLT_MAX_ADDR,
	 MT6328_PMIC_AUXADC_THR_VOLT_MAX_MASK, MT6328_PMIC_AUXADC_THR_VOLT_MAX_SHIFT},
	{PMIC_AUXADC_THR_IRQ_EN_MAX, MT6328_PMIC_AUXADC_THR_IRQ_EN_MAX_ADDR,
	 MT6328_PMIC_AUXADC_THR_IRQ_EN_MAX_MASK, MT6328_PMIC_AUXADC_THR_IRQ_EN_MAX_SHIFT},
	{PMIC_AUXADC_THR_EN_MAX, MT6328_PMIC_AUXADC_THR_EN_MAX_ADDR,
	 MT6328_PMIC_AUXADC_THR_EN_MAX_MASK, MT6328_PMIC_AUXADC_THR_EN_MAX_SHIFT},
	{PMIC_AUXADC_THR_MAX_IRQ_B, MT6328_PMIC_AUXADC_THR_MAX_IRQ_B_ADDR,
	 MT6328_PMIC_AUXADC_THR_MAX_IRQ_B_MASK, MT6328_PMIC_AUXADC_THR_MAX_IRQ_B_SHIFT},
	{PMIC_AUXADC_THR_VOLT_MIN, MT6328_PMIC_AUXADC_THR_VOLT_MIN_ADDR,
	 MT6328_PMIC_AUXADC_THR_VOLT_MIN_MASK, MT6328_PMIC_AUXADC_THR_VOLT_MIN_SHIFT},
	{PMIC_AUXADC_THR_IRQ_EN_MIN, MT6328_PMIC_AUXADC_THR_IRQ_EN_MIN_ADDR,
	 MT6328_PMIC_AUXADC_THR_IRQ_EN_MIN_MASK, MT6328_PMIC_AUXADC_THR_IRQ_EN_MIN_SHIFT},
	{PMIC_AUXADC_THR_EN_MIN, MT6328_PMIC_AUXADC_THR_EN_MIN_ADDR,
	 MT6328_PMIC_AUXADC_THR_EN_MIN_MASK, MT6328_PMIC_AUXADC_THR_EN_MIN_SHIFT},
	{PMIC_AUXADC_THR_MIN_IRQ_B, MT6328_PMIC_AUXADC_THR_MIN_IRQ_B_ADDR,
	 MT6328_PMIC_AUXADC_THR_MIN_IRQ_B_MASK, MT6328_PMIC_AUXADC_THR_MIN_IRQ_B_SHIFT},
	{PMIC_AUXADC_THR_DEBOUNCE_COUNT_MAX, MT6328_PMIC_AUXADC_THR_DEBOUNCE_COUNT_MAX_ADDR,
	 MT6328_PMIC_AUXADC_THR_DEBOUNCE_COUNT_MAX_MASK,
	 MT6328_PMIC_AUXADC_THR_DEBOUNCE_COUNT_MAX_SHIFT},
	{PMIC_AUXADC_THR_DEBOUNCE_COUNT_MIN, MT6328_PMIC_AUXADC_THR_DEBOUNCE_COUNT_MIN_ADDR,
	 MT6328_PMIC_AUXADC_THR_DEBOUNCE_COUNT_MIN_MASK,
	 MT6328_PMIC_AUXADC_THR_DEBOUNCE_COUNT_MIN_SHIFT},
	{PMIC_EFUSE_GAIN_CH4_TRIM, MT6328_PMIC_EFUSE_GAIN_CH4_TRIM_ADDR,
	 MT6328_PMIC_EFUSE_GAIN_CH4_TRIM_MASK, MT6328_PMIC_EFUSE_GAIN_CH4_TRIM_SHIFT},
	{PMIC_EFUSE_OFFSET_CH4_TRIM, MT6328_PMIC_EFUSE_OFFSET_CH4_TRIM_ADDR,
	 MT6328_PMIC_EFUSE_OFFSET_CH4_TRIM_MASK, MT6328_PMIC_EFUSE_OFFSET_CH4_TRIM_SHIFT},
	{PMIC_EFUSE_GAIN_CH0_TRIM, MT6328_PMIC_EFUSE_GAIN_CH0_TRIM_ADDR,
	 MT6328_PMIC_EFUSE_GAIN_CH0_TRIM_MASK, MT6328_PMIC_EFUSE_GAIN_CH0_TRIM_SHIFT},
	{PMIC_EFUSE_OFFSET_CH0_TRIM, MT6328_PMIC_EFUSE_OFFSET_CH0_TRIM_ADDR,
	 MT6328_PMIC_EFUSE_OFFSET_CH0_TRIM_MASK, MT6328_PMIC_EFUSE_OFFSET_CH0_TRIM_SHIFT},
	{PMIC_EFUSE_GAIN_CH7_TRIM, MT6328_PMIC_EFUSE_GAIN_CH7_TRIM_ADDR,
	 MT6328_PMIC_EFUSE_GAIN_CH7_TRIM_MASK, MT6328_PMIC_EFUSE_GAIN_CH7_TRIM_SHIFT},
	{PMIC_EFUSE_OFFSET_CH7_TRIM, MT6328_PMIC_EFUSE_OFFSET_CH7_TRIM_ADDR,
	 MT6328_PMIC_EFUSE_OFFSET_CH7_TRIM_MASK, MT6328_PMIC_EFUSE_OFFSET_CH7_TRIM_SHIFT},
	{PMIC_AUXADC_FGADC_START_SW, MT6328_PMIC_AUXADC_FGADC_START_SW_ADDR,
	 MT6328_PMIC_AUXADC_FGADC_START_SW_MASK, MT6328_PMIC_AUXADC_FGADC_START_SW_SHIFT},
	{PMIC_AUXADC_FGADC_START_SEL, MT6328_PMIC_AUXADC_FGADC_START_SEL_ADDR,
	 MT6328_PMIC_AUXADC_FGADC_START_SEL_MASK, MT6328_PMIC_AUXADC_FGADC_START_SEL_SHIFT},
	{PMIC_AUXADC_FGADC_R_SW, MT6328_PMIC_AUXADC_FGADC_R_SW_ADDR,
	 MT6328_PMIC_AUXADC_FGADC_R_SW_MASK, MT6328_PMIC_AUXADC_FGADC_R_SW_SHIFT},
	{PMIC_AUXADC_FGADC_R_SEL, MT6328_PMIC_AUXADC_FGADC_R_SEL_ADDR,
	 MT6328_PMIC_AUXADC_FGADC_R_SEL_MASK, MT6328_PMIC_AUXADC_FGADC_R_SEL_SHIFT},
	{PMIC_AUXADC_DBG_DIG0_RSV2, MT6328_PMIC_AUXADC_DBG_DIG0_RSV2_ADDR,
	 MT6328_PMIC_AUXADC_DBG_DIG0_RSV2_MASK, MT6328_PMIC_AUXADC_DBG_DIG0_RSV2_SHIFT},
	{PMIC_AUXADC_DBG_DIG1_RSV2, MT6328_PMIC_AUXADC_DBG_DIG1_RSV2_ADDR,
	 MT6328_PMIC_AUXADC_DBG_DIG1_RSV2_MASK, MT6328_PMIC_AUXADC_DBG_DIG1_RSV2_SHIFT},
	{PMIC_AUXADC_IMPEDANCE_CNT, MT6328_PMIC_AUXADC_IMPEDANCE_CNT_ADDR,
	 MT6328_PMIC_AUXADC_IMPEDANCE_CNT_MASK, MT6328_PMIC_AUXADC_IMPEDANCE_CNT_SHIFT},
	{PMIC_AUXADC_IMPEDANCE_CHSEL, MT6328_PMIC_AUXADC_IMPEDANCE_CHSEL_ADDR,
	 MT6328_PMIC_AUXADC_IMPEDANCE_CHSEL_MASK, MT6328_PMIC_AUXADC_IMPEDANCE_CHSEL_SHIFT},
	{PMIC_AUXADC_IMPEDANCE_IRQ_CLR, MT6328_PMIC_AUXADC_IMPEDANCE_IRQ_CLR_ADDR,
	 MT6328_PMIC_AUXADC_IMPEDANCE_IRQ_CLR_MASK, MT6328_PMIC_AUXADC_IMPEDANCE_IRQ_CLR_SHIFT},
	{PMIC_AUXADC_IMPEDANCE_IRQ_STATUS, MT6328_PMIC_AUXADC_IMPEDANCE_IRQ_STATUS_ADDR,
	 MT6328_PMIC_AUXADC_IMPEDANCE_IRQ_STATUS_MASK,
	 MT6328_PMIC_AUXADC_IMPEDANCE_IRQ_STATUS_SHIFT},
	{PMIC_AUXADC_CLR_IMP_CNT_STOP, MT6328_PMIC_AUXADC_CLR_IMP_CNT_STOP_ADDR,
	 MT6328_PMIC_AUXADC_CLR_IMP_CNT_STOP_MASK, MT6328_PMIC_AUXADC_CLR_IMP_CNT_STOP_SHIFT},
	{PMIC_AUXADC_IMPEDANCE_MODE, MT6328_PMIC_AUXADC_IMPEDANCE_MODE_ADDR,
	 MT6328_PMIC_AUXADC_IMPEDANCE_MODE_MASK, MT6328_PMIC_AUXADC_IMPEDANCE_MODE_SHIFT},
	{PMIC_AUXADC_IMP_AUTORPT_PRD, MT6328_PMIC_AUXADC_IMP_AUTORPT_PRD_ADDR,
	 MT6328_PMIC_AUXADC_IMP_AUTORPT_PRD_MASK, MT6328_PMIC_AUXADC_IMP_AUTORPT_PRD_SHIFT},
	{PMIC_AUXADC_IMP_AUTORPT_EN, MT6328_PMIC_AUXADC_IMP_AUTORPT_EN_ADDR,
	 MT6328_PMIC_AUXADC_IMP_AUTORPT_EN_MASK, MT6328_PMIC_AUXADC_IMP_AUTORPT_EN_SHIFT},
	{PMIC_AUXADC_VISMPS0_DEBT_MAX, MT6328_PMIC_AUXADC_VISMPS0_DEBT_MAX_ADDR,
	 MT6328_PMIC_AUXADC_VISMPS0_DEBT_MAX_MASK, MT6328_PMIC_AUXADC_VISMPS0_DEBT_MAX_SHIFT},
	{PMIC_AUXADC_VISMPS0_DEBT_MIN, MT6328_PMIC_AUXADC_VISMPS0_DEBT_MIN_ADDR,
	 MT6328_PMIC_AUXADC_VISMPS0_DEBT_MIN_MASK, MT6328_PMIC_AUXADC_VISMPS0_DEBT_MIN_SHIFT},
	{PMIC_AUXADC_VISMPS0_DET_PRD_15_0, MT6328_PMIC_AUXADC_VISMPS0_DET_PRD_15_0_ADDR,
	 MT6328_PMIC_AUXADC_VISMPS0_DET_PRD_15_0_MASK,
	 MT6328_PMIC_AUXADC_VISMPS0_DET_PRD_15_0_SHIFT},
	{PMIC_AUXADC_VISMPS0_DET_PRD_19_16, MT6328_PMIC_AUXADC_VISMPS0_DET_PRD_19_16_ADDR,
	 MT6328_PMIC_AUXADC_VISMPS0_DET_PRD_19_16_MASK,
	 MT6328_PMIC_AUXADC_VISMPS0_DET_PRD_19_16_SHIFT},
	{PMIC_AUXADC_VISMPS0_VOLT_MAX, MT6328_PMIC_AUXADC_VISMPS0_VOLT_MAX_ADDR,
	 MT6328_PMIC_AUXADC_VISMPS0_VOLT_MAX_MASK, MT6328_PMIC_AUXADC_VISMPS0_VOLT_MAX_SHIFT},
	{PMIC_AUXADC_VISMPS0_IRQ_EN_MAX, MT6328_PMIC_AUXADC_VISMPS0_IRQ_EN_MAX_ADDR,
	 MT6328_PMIC_AUXADC_VISMPS0_IRQ_EN_MAX_MASK, MT6328_PMIC_AUXADC_VISMPS0_IRQ_EN_MAX_SHIFT},
	{PMIC_AUXADC_VISMPS0_EN_MAX, MT6328_PMIC_AUXADC_VISMPS0_EN_MAX_ADDR,
	 MT6328_PMIC_AUXADC_VISMPS0_EN_MAX_MASK, MT6328_PMIC_AUXADC_VISMPS0_EN_MAX_SHIFT},
	{PMIC_AUXADC_VISMPS0_MAX_IRQ_B, MT6328_PMIC_AUXADC_VISMPS0_MAX_IRQ_B_ADDR,
	 MT6328_PMIC_AUXADC_VISMPS0_MAX_IRQ_B_MASK, MT6328_PMIC_AUXADC_VISMPS0_MAX_IRQ_B_SHIFT},
	{PMIC_AUXADC_VISMPS0_VOLT_MIN, MT6328_PMIC_AUXADC_VISMPS0_VOLT_MIN_ADDR,
	 MT6328_PMIC_AUXADC_VISMPS0_VOLT_MIN_MASK, MT6328_PMIC_AUXADC_VISMPS0_VOLT_MIN_SHIFT},
	{PMIC_AUXADC_VISMPS0_IRQ_EN_MIN, MT6328_PMIC_AUXADC_VISMPS0_IRQ_EN_MIN_ADDR,
	 MT6328_PMIC_AUXADC_VISMPS0_IRQ_EN_MIN_MASK, MT6328_PMIC_AUXADC_VISMPS0_IRQ_EN_MIN_SHIFT},
	{PMIC_AUXADC_VISMPS0_EN_MIN, MT6328_PMIC_AUXADC_VISMPS0_EN_MIN_ADDR,
	 MT6328_PMIC_AUXADC_VISMPS0_EN_MIN_MASK, MT6328_PMIC_AUXADC_VISMPS0_EN_MIN_SHIFT},
	{PMIC_AUXADC_VISMPS0_MIN_IRQ_B, MT6328_PMIC_AUXADC_VISMPS0_MIN_IRQ_B_ADDR,
	 MT6328_PMIC_AUXADC_VISMPS0_MIN_IRQ_B_MASK, MT6328_PMIC_AUXADC_VISMPS0_MIN_IRQ_B_SHIFT},
	{PMIC_AUXADC_VISMPS0_DEBOUNCE_COUNT_MAX, MT6328_PMIC_AUXADC_VISMPS0_DEBOUNCE_COUNT_MAX_ADDR,
	 MT6328_PMIC_AUXADC_VISMPS0_DEBOUNCE_COUNT_MAX_MASK,
	 MT6328_PMIC_AUXADC_VISMPS0_DEBOUNCE_COUNT_MAX_SHIFT},
	{PMIC_AUXADC_VISMPS0_DEBOUNCE_COUNT_MIN, MT6328_PMIC_AUXADC_VISMPS0_DEBOUNCE_COUNT_MIN_ADDR,
	 MT6328_PMIC_AUXADC_VISMPS0_DEBOUNCE_COUNT_MIN_MASK,
	 MT6328_PMIC_AUXADC_VISMPS0_DEBOUNCE_COUNT_MIN_SHIFT},
	{PMIC_AUXADC_LBAT2_DEBT_MAX, MT6328_PMIC_AUXADC_LBAT2_DEBT_MAX_ADDR,
	 MT6328_PMIC_AUXADC_LBAT2_DEBT_MAX_MASK, MT6328_PMIC_AUXADC_LBAT2_DEBT_MAX_SHIFT},
	{PMIC_AUXADC_LBAT2_DEBT_MIN, MT6328_PMIC_AUXADC_LBAT2_DEBT_MIN_ADDR,
	 MT6328_PMIC_AUXADC_LBAT2_DEBT_MIN_MASK, MT6328_PMIC_AUXADC_LBAT2_DEBT_MIN_SHIFT},
	{PMIC_AUXADC_LBAT2_DET_PRD_15_0, MT6328_PMIC_AUXADC_LBAT2_DET_PRD_15_0_ADDR,
	 MT6328_PMIC_AUXADC_LBAT2_DET_PRD_15_0_MASK, MT6328_PMIC_AUXADC_LBAT2_DET_PRD_15_0_SHIFT},
	{PMIC_AUXADC_LBAT2_DET_PRD_19_16, MT6328_PMIC_AUXADC_LBAT2_DET_PRD_19_16_ADDR,
	 MT6328_PMIC_AUXADC_LBAT2_DET_PRD_19_16_MASK, MT6328_PMIC_AUXADC_LBAT2_DET_PRD_19_16_SHIFT},
	{PMIC_AUXADC_LBAT2_VOLT_MAX, MT6328_PMIC_AUXADC_LBAT2_VOLT_MAX_ADDR,
	 MT6328_PMIC_AUXADC_LBAT2_VOLT_MAX_MASK, MT6328_PMIC_AUXADC_LBAT2_VOLT_MAX_SHIFT},
	{PMIC_AUXADC_LBAT2_IRQ_EN_MAX, MT6328_PMIC_AUXADC_LBAT2_IRQ_EN_MAX_ADDR,
	 MT6328_PMIC_AUXADC_LBAT2_IRQ_EN_MAX_MASK, MT6328_PMIC_AUXADC_LBAT2_IRQ_EN_MAX_SHIFT},
	{PMIC_AUXADC_LBAT2_EN_MAX, MT6328_PMIC_AUXADC_LBAT2_EN_MAX_ADDR,
	 MT6328_PMIC_AUXADC_LBAT2_EN_MAX_MASK, MT6328_PMIC_AUXADC_LBAT2_EN_MAX_SHIFT},
	{PMIC_AUXADC_LBAT2_MAX_IRQ_B, MT6328_PMIC_AUXADC_LBAT2_MAX_IRQ_B_ADDR,
	 MT6328_PMIC_AUXADC_LBAT2_MAX_IRQ_B_MASK, MT6328_PMIC_AUXADC_LBAT2_MAX_IRQ_B_SHIFT},
	{PMIC_AUXADC_LBAT2_VOLT_MIN, MT6328_PMIC_AUXADC_LBAT2_VOLT_MIN_ADDR,
	 MT6328_PMIC_AUXADC_LBAT2_VOLT_MIN_MASK, MT6328_PMIC_AUXADC_LBAT2_VOLT_MIN_SHIFT},
	{PMIC_AUXADC_LBAT2_IRQ_EN_MIN, MT6328_PMIC_AUXADC_LBAT2_IRQ_EN_MIN_ADDR,
	 MT6328_PMIC_AUXADC_LBAT2_IRQ_EN_MIN_MASK, MT6328_PMIC_AUXADC_LBAT2_IRQ_EN_MIN_SHIFT},
	{PMIC_AUXADC_LBAT2_EN_MIN, MT6328_PMIC_AUXADC_LBAT2_EN_MIN_ADDR,
	 MT6328_PMIC_AUXADC_LBAT2_EN_MIN_MASK, MT6328_PMIC_AUXADC_LBAT2_EN_MIN_SHIFT},
	{PMIC_AUXADC_LBAT2_MIN_IRQ_B, MT6328_PMIC_AUXADC_LBAT2_MIN_IRQ_B_ADDR,
	 MT6328_PMIC_AUXADC_LBAT2_MIN_IRQ_B_MASK, MT6328_PMIC_AUXADC_LBAT2_MIN_IRQ_B_SHIFT},
	{PMIC_AUXADC_LBAT2_DEBOUNCE_COUNT_MAX, MT6328_PMIC_AUXADC_LBAT2_DEBOUNCE_COUNT_MAX_ADDR,
	 MT6328_PMIC_AUXADC_LBAT2_DEBOUNCE_COUNT_MAX_MASK,
	 MT6328_PMIC_AUXADC_LBAT2_DEBOUNCE_COUNT_MAX_SHIFT},
	{PMIC_AUXADC_LBAT2_DEBOUNCE_COUNT_MIN, MT6328_PMIC_AUXADC_LBAT2_DEBOUNCE_COUNT_MIN_ADDR,
	 MT6328_PMIC_AUXADC_LBAT2_DEBOUNCE_COUNT_MIN_MASK,
	 MT6328_PMIC_AUXADC_LBAT2_DEBOUNCE_COUNT_MIN_SHIFT},
	{PMIC_AUXADC_MDBG_DET_PRD, MT6328_PMIC_AUXADC_MDBG_DET_PRD_ADDR,
	 MT6328_PMIC_AUXADC_MDBG_DET_PRD_MASK, MT6328_PMIC_AUXADC_MDBG_DET_PRD_SHIFT},
	{PMIC_AUXADC_MDBG_DET_EN, MT6328_PMIC_AUXADC_MDBG_DET_EN_ADDR,
	 MT6328_PMIC_AUXADC_MDBG_DET_EN_MASK, MT6328_PMIC_AUXADC_MDBG_DET_EN_SHIFT},
	{PMIC_AUXADC_MDBG_R_PTR, MT6328_PMIC_AUXADC_MDBG_R_PTR_ADDR,
	 MT6328_PMIC_AUXADC_MDBG_R_PTR_MASK, MT6328_PMIC_AUXADC_MDBG_R_PTR_SHIFT},
	{PMIC_AUXADC_MDBG_W_PTR, MT6328_PMIC_AUXADC_MDBG_W_PTR_ADDR,
	 MT6328_PMIC_AUXADC_MDBG_W_PTR_MASK, MT6328_PMIC_AUXADC_MDBG_W_PTR_SHIFT},
	{PMIC_AUXADC_MDBG_BUF_LENGTH, MT6328_PMIC_AUXADC_MDBG_BUF_LENGTH_ADDR,
	 MT6328_PMIC_AUXADC_MDBG_BUF_LENGTH_MASK, MT6328_PMIC_AUXADC_MDBG_BUF_LENGTH_SHIFT},
	{PMIC_AUXADC_MDRT_DET_PRD, MT6328_PMIC_AUXADC_MDRT_DET_PRD_ADDR,
	 MT6328_PMIC_AUXADC_MDRT_DET_PRD_MASK, MT6328_PMIC_AUXADC_MDRT_DET_PRD_SHIFT},
	{PMIC_AUXADC_MDRT_DET_EN, MT6328_PMIC_AUXADC_MDRT_DET_EN_ADDR,
	 MT6328_PMIC_AUXADC_MDRT_DET_EN_MASK, MT6328_PMIC_AUXADC_MDRT_DET_EN_SHIFT},
	{PMIC_AUXADC_MDRT_DET_WKUP_START_CNT, MT6328_PMIC_AUXADC_MDRT_DET_WKUP_START_CNT_ADDR,
	 MT6328_PMIC_AUXADC_MDRT_DET_WKUP_START_CNT_MASK,
	 MT6328_PMIC_AUXADC_MDRT_DET_WKUP_START_CNT_SHIFT},
	{PMIC_AUXADC_MDRT_DET_WKUP_START_CLR, MT6328_PMIC_AUXADC_MDRT_DET_WKUP_START_CLR_ADDR,
	 MT6328_PMIC_AUXADC_MDRT_DET_WKUP_START_CLR_MASK,
	 MT6328_PMIC_AUXADC_MDRT_DET_WKUP_START_CLR_SHIFT},
	{PMIC_AUXADC_MDRT_DET_WKUP_START, MT6328_PMIC_AUXADC_MDRT_DET_WKUP_START_ADDR,
	 MT6328_PMIC_AUXADC_MDRT_DET_WKUP_START_MASK, MT6328_PMIC_AUXADC_MDRT_DET_WKUP_START_SHIFT},
	{PMIC_AUXADC_MDRT_DET_WKUP_START_SEL, MT6328_PMIC_AUXADC_MDRT_DET_WKUP_START_SEL_ADDR,
	 MT6328_PMIC_AUXADC_MDRT_DET_WKUP_START_SEL_MASK,
	 MT6328_PMIC_AUXADC_MDRT_DET_WKUP_START_SEL_SHIFT},
	{PMIC_AUXADC_MDRT_DET_WKUP_EN, MT6328_PMIC_AUXADC_MDRT_DET_WKUP_EN_ADDR,
	 MT6328_PMIC_AUXADC_MDRT_DET_WKUP_EN_MASK, MT6328_PMIC_AUXADC_MDRT_DET_WKUP_EN_SHIFT},
	{PMIC_RG_AUDACCDETVTHBCAL, MT6328_PMIC_RG_AUDACCDETVTHBCAL_ADDR,
	 MT6328_PMIC_RG_AUDACCDETVTHBCAL_MASK, MT6328_PMIC_RG_AUDACCDETVTHBCAL_SHIFT},
	{PMIC_RG_AUDACCDETVTHACAL, MT6328_PMIC_RG_AUDACCDETVTHACAL_ADDR,
	 MT6328_PMIC_RG_AUDACCDETVTHACAL_MASK, MT6328_PMIC_RG_AUDACCDETVTHACAL_SHIFT},
	{PMIC_RG_AUDACCDETANASWCTRLENB, MT6328_PMIC_RG_AUDACCDETANASWCTRLENB_ADDR,
	 MT6328_PMIC_RG_AUDACCDETANASWCTRLENB_MASK, MT6328_PMIC_RG_AUDACCDETANASWCTRLENB_SHIFT},
	{PMIC_RG_ACCDETSEL, MT6328_PMIC_RG_ACCDETSEL_ADDR, MT6328_PMIC_RG_ACCDETSEL_MASK,
	 MT6328_PMIC_RG_ACCDETSEL_SHIFT},
	{PMIC_RG_AUDACCDETSWCTRL, MT6328_PMIC_RG_AUDACCDETSWCTRL_ADDR,
	 MT6328_PMIC_RG_AUDACCDETSWCTRL_MASK, MT6328_PMIC_RG_AUDACCDETSWCTRL_SHIFT},
	{PMIC_RG_AUDACCDETMICBIAS1PULLLOW, MT6328_PMIC_RG_AUDACCDETMICBIAS1PULLLOW_ADDR,
	 MT6328_PMIC_RG_AUDACCDETMICBIAS1PULLLOW_MASK,
	 MT6328_PMIC_RG_AUDACCDETMICBIAS1PULLLOW_SHIFT},
	{PMIC_RG_AUDACCDETTVDET, MT6328_PMIC_RG_AUDACCDETTVDET_ADDR,
	 MT6328_PMIC_RG_AUDACCDETTVDET_MASK, MT6328_PMIC_RG_AUDACCDETTVDET_SHIFT},
	{PMIC_RG_AUDACCDETVIN1PULLLOW, MT6328_PMIC_RG_AUDACCDETVIN1PULLLOW_ADDR,
	 MT6328_PMIC_RG_AUDACCDETVIN1PULLLOW_MASK, MT6328_PMIC_RG_AUDACCDETVIN1PULLLOW_SHIFT},
	{PMIC_AUDACCDETAUXADCSWCTRL, MT6328_PMIC_AUDACCDETAUXADCSWCTRL_ADDR,
	 MT6328_PMIC_AUDACCDETAUXADCSWCTRL_MASK, MT6328_PMIC_AUDACCDETAUXADCSWCTRL_SHIFT},
	{PMIC_AUDACCDETAUXADCSWCTRL_SEL, MT6328_PMIC_AUDACCDETAUXADCSWCTRL_SEL_ADDR,
	 MT6328_PMIC_AUDACCDETAUXADCSWCTRL_SEL_MASK, MT6328_PMIC_AUDACCDETAUXADCSWCTRL_SEL_SHIFT},
	{PMIC_RG_AUDACCDETMICBIAS0PULLLOW, MT6328_PMIC_RG_AUDACCDETMICBIAS0PULLLOW_ADDR,
	 MT6328_PMIC_RG_AUDACCDETMICBIAS0PULLLOW_MASK,
	 MT6328_PMIC_RG_AUDACCDETMICBIAS0PULLLOW_SHIFT},
	{PMIC_RG_AUDACCDETRSV, MT6328_PMIC_RG_AUDACCDETRSV_ADDR, MT6328_PMIC_RG_AUDACCDETRSV_MASK,
	 MT6328_PMIC_RG_AUDACCDETRSV_SHIFT},
	{PMIC_ACCDET_EN, MT6328_PMIC_ACCDET_EN_ADDR, MT6328_PMIC_ACCDET_EN_MASK,
	 MT6328_PMIC_ACCDET_EN_SHIFT},
	{PMIC_ACCDET_SEQ_INIT, MT6328_PMIC_ACCDET_SEQ_INIT_ADDR, MT6328_PMIC_ACCDET_SEQ_INIT_MASK,
	 MT6328_PMIC_ACCDET_SEQ_INIT_SHIFT},
	{PMIC_ACCDET_EINTDET_EN, MT6328_PMIC_ACCDET_EINTDET_EN_ADDR,
	 MT6328_PMIC_ACCDET_EINTDET_EN_MASK, MT6328_PMIC_ACCDET_EINTDET_EN_SHIFT},
	{PMIC_ACCDET_EINT_SEQ_INIT, MT6328_PMIC_ACCDET_EINT_SEQ_INIT_ADDR,
	 MT6328_PMIC_ACCDET_EINT_SEQ_INIT_MASK, MT6328_PMIC_ACCDET_EINT_SEQ_INIT_SHIFT},
	{PMIC_ACCDET_NEGVDET_EN, MT6328_PMIC_ACCDET_NEGVDET_EN_ADDR,
	 MT6328_PMIC_ACCDET_NEGVDET_EN_MASK, MT6328_PMIC_ACCDET_NEGVDET_EN_SHIFT},
	{PMIC_ACCDET_NEGVDET_EN_CTRL, MT6328_PMIC_ACCDET_NEGVDET_EN_CTRL_ADDR,
	 MT6328_PMIC_ACCDET_NEGVDET_EN_CTRL_MASK, MT6328_PMIC_ACCDET_NEGVDET_EN_CTRL_SHIFT},
	{PMIC_ACCDET_ANASWCTRL_SEL, MT6328_PMIC_ACCDET_ANASWCTRL_SEL_ADDR,
	 MT6328_PMIC_ACCDET_ANASWCTRL_SEL_MASK, MT6328_PMIC_ACCDET_ANASWCTRL_SEL_SHIFT},
	{PMIC_ACCDET_CMP_PWM_EN, MT6328_PMIC_ACCDET_CMP_PWM_EN_ADDR,
	 MT6328_PMIC_ACCDET_CMP_PWM_EN_MASK, MT6328_PMIC_ACCDET_CMP_PWM_EN_SHIFT},
	{PMIC_ACCDET_VTH_PWM_EN, MT6328_PMIC_ACCDET_VTH_PWM_EN_ADDR,
	 MT6328_PMIC_ACCDET_VTH_PWM_EN_MASK, MT6328_PMIC_ACCDET_VTH_PWM_EN_SHIFT},
	{PMIC_ACCDET_MBIAS_PWM_EN, MT6328_PMIC_ACCDET_MBIAS_PWM_EN_ADDR,
	 MT6328_PMIC_ACCDET_MBIAS_PWM_EN_MASK, MT6328_PMIC_ACCDET_MBIAS_PWM_EN_SHIFT},
	{PMIC_ACCDET_EINT_PWM_EN, MT6328_PMIC_ACCDET_EINT_PWM_EN_ADDR,
	 MT6328_PMIC_ACCDET_EINT_PWM_EN_MASK, MT6328_PMIC_ACCDET_EINT_PWM_EN_SHIFT},
	{PMIC_ACCDET_CMP_PWM_IDLE, MT6328_PMIC_ACCDET_CMP_PWM_IDLE_ADDR,
	 MT6328_PMIC_ACCDET_CMP_PWM_IDLE_MASK, MT6328_PMIC_ACCDET_CMP_PWM_IDLE_SHIFT},
	{PMIC_ACCDET_VTH_PWM_IDLE, MT6328_PMIC_ACCDET_VTH_PWM_IDLE_ADDR,
	 MT6328_PMIC_ACCDET_VTH_PWM_IDLE_MASK, MT6328_PMIC_ACCDET_VTH_PWM_IDLE_SHIFT},
	{PMIC_ACCDET_MBIAS_PWM_IDLE, MT6328_PMIC_ACCDET_MBIAS_PWM_IDLE_ADDR,
	 MT6328_PMIC_ACCDET_MBIAS_PWM_IDLE_MASK, MT6328_PMIC_ACCDET_MBIAS_PWM_IDLE_SHIFT},
	{PMIC_ACCDET_EINT_PWM_IDLE, MT6328_PMIC_ACCDET_EINT_PWM_IDLE_ADDR,
	 MT6328_PMIC_ACCDET_EINT_PWM_IDLE_MASK, MT6328_PMIC_ACCDET_EINT_PWM_IDLE_SHIFT},
	{PMIC_ACCDET_PWM_WIDTH, MT6328_PMIC_ACCDET_PWM_WIDTH_ADDR,
	 MT6328_PMIC_ACCDET_PWM_WIDTH_MASK, MT6328_PMIC_ACCDET_PWM_WIDTH_SHIFT},
	{PMIC_ACCDET_PWM_THRESH, MT6328_PMIC_ACCDET_PWM_THRESH_ADDR,
	 MT6328_PMIC_ACCDET_PWM_THRESH_MASK, MT6328_PMIC_ACCDET_PWM_THRESH_SHIFT},
	{PMIC_ACCDET_RISE_DELAY, MT6328_PMIC_ACCDET_RISE_DELAY_ADDR,
	 MT6328_PMIC_ACCDET_RISE_DELAY_MASK, MT6328_PMIC_ACCDET_RISE_DELAY_SHIFT},
	{PMIC_ACCDET_FALL_DELAY, MT6328_PMIC_ACCDET_FALL_DELAY_ADDR,
	 MT6328_PMIC_ACCDET_FALL_DELAY_MASK, MT6328_PMIC_ACCDET_FALL_DELAY_SHIFT},
	{PMIC_ACCDET_DEBOUNCE0, MT6328_PMIC_ACCDET_DEBOUNCE0_ADDR,
	 MT6328_PMIC_ACCDET_DEBOUNCE0_MASK, MT6328_PMIC_ACCDET_DEBOUNCE0_SHIFT},
	{PMIC_ACCDET_DEBOUNCE1, MT6328_PMIC_ACCDET_DEBOUNCE1_ADDR,
	 MT6328_PMIC_ACCDET_DEBOUNCE1_MASK, MT6328_PMIC_ACCDET_DEBOUNCE1_SHIFT},
	{PMIC_ACCDET_DEBOUNCE2, MT6328_PMIC_ACCDET_DEBOUNCE2_ADDR,
	 MT6328_PMIC_ACCDET_DEBOUNCE2_MASK, MT6328_PMIC_ACCDET_DEBOUNCE2_SHIFT},
	{PMIC_ACCDET_DEBOUNCE3, MT6328_PMIC_ACCDET_DEBOUNCE3_ADDR,
	 MT6328_PMIC_ACCDET_DEBOUNCE3_MASK, MT6328_PMIC_ACCDET_DEBOUNCE3_SHIFT},
	{PMIC_ACCDET_DEBOUNCE4, MT6328_PMIC_ACCDET_DEBOUNCE4_ADDR,
	 MT6328_PMIC_ACCDET_DEBOUNCE4_MASK, MT6328_PMIC_ACCDET_DEBOUNCE4_SHIFT},
	{PMIC_ACCDET_IVAL_CUR_IN, MT6328_PMIC_ACCDET_IVAL_CUR_IN_ADDR,
	 MT6328_PMIC_ACCDET_IVAL_CUR_IN_MASK, MT6328_PMIC_ACCDET_IVAL_CUR_IN_SHIFT},
	{PMIC_ACCDET_EINT_IVAL_CUR_IN, MT6328_PMIC_ACCDET_EINT_IVAL_CUR_IN_ADDR,
	 MT6328_PMIC_ACCDET_EINT_IVAL_CUR_IN_MASK, MT6328_PMIC_ACCDET_EINT_IVAL_CUR_IN_SHIFT},
	{PMIC_ACCDET_IVAL_SAM_IN, MT6328_PMIC_ACCDET_IVAL_SAM_IN_ADDR,
	 MT6328_PMIC_ACCDET_IVAL_SAM_IN_MASK, MT6328_PMIC_ACCDET_IVAL_SAM_IN_SHIFT},
	{PMIC_ACCDET_EINT_IVAL_SAM_IN, MT6328_PMIC_ACCDET_EINT_IVAL_SAM_IN_ADDR,
	 MT6328_PMIC_ACCDET_EINT_IVAL_SAM_IN_MASK, MT6328_PMIC_ACCDET_EINT_IVAL_SAM_IN_SHIFT},
	{PMIC_ACCDET_IVAL_MEM_IN, MT6328_PMIC_ACCDET_IVAL_MEM_IN_ADDR,
	 MT6328_PMIC_ACCDET_IVAL_MEM_IN_MASK, MT6328_PMIC_ACCDET_IVAL_MEM_IN_SHIFT},
	{PMIC_ACCDET_EINT_IVAL_MEM_IN, MT6328_PMIC_ACCDET_EINT_IVAL_MEM_IN_ADDR,
	 MT6328_PMIC_ACCDET_EINT_IVAL_MEM_IN_MASK, MT6328_PMIC_ACCDET_EINT_IVAL_MEM_IN_SHIFT},
	{PMIC_ACCDET_EINT_IVAL_SEL, MT6328_PMIC_ACCDET_EINT_IVAL_SEL_ADDR,
	 MT6328_PMIC_ACCDET_EINT_IVAL_SEL_MASK, MT6328_PMIC_ACCDET_EINT_IVAL_SEL_SHIFT},
	{PMIC_ACCDET_IVAL_SEL, MT6328_PMIC_ACCDET_IVAL_SEL_ADDR, MT6328_PMIC_ACCDET_IVAL_SEL_MASK,
	 MT6328_PMIC_ACCDET_IVAL_SEL_SHIFT},
	{PMIC_ACCDET_IRQ, MT6328_PMIC_ACCDET_IRQ_ADDR, MT6328_PMIC_ACCDET_IRQ_MASK,
	 MT6328_PMIC_ACCDET_IRQ_SHIFT},
	{PMIC_ACCDET_NEGV_IRQ, MT6328_PMIC_ACCDET_NEGV_IRQ_ADDR, MT6328_PMIC_ACCDET_NEGV_IRQ_MASK,
	 MT6328_PMIC_ACCDET_NEGV_IRQ_SHIFT},
	{PMIC_ACCDET_EINT_IRQ, MT6328_PMIC_ACCDET_EINT_IRQ_ADDR, MT6328_PMIC_ACCDET_EINT_IRQ_MASK,
	 MT6328_PMIC_ACCDET_EINT_IRQ_SHIFT},
	{PMIC_ACCDET_IRQ_CLR, MT6328_PMIC_ACCDET_IRQ_CLR_ADDR, MT6328_PMIC_ACCDET_IRQ_CLR_MASK,
	 MT6328_PMIC_ACCDET_IRQ_CLR_SHIFT},
	{PMIC_ACCDET_NEGV_IRQ_CLR, MT6328_PMIC_ACCDET_NEGV_IRQ_CLR_ADDR,
	 MT6328_PMIC_ACCDET_NEGV_IRQ_CLR_MASK, MT6328_PMIC_ACCDET_NEGV_IRQ_CLR_SHIFT},
	{PMIC_ACCDET_EINT_IRQ_CLR, MT6328_PMIC_ACCDET_EINT_IRQ_CLR_ADDR,
	 MT6328_PMIC_ACCDET_EINT_IRQ_CLR_MASK, MT6328_PMIC_ACCDET_EINT_IRQ_CLR_SHIFT},
	{PMIC_ACCDET_EINT_IRQ_POLARITY, MT6328_PMIC_ACCDET_EINT_IRQ_POLARITY_ADDR,
	 MT6328_PMIC_ACCDET_EINT_IRQ_POLARITY_MASK, MT6328_PMIC_ACCDET_EINT_IRQ_POLARITY_SHIFT},
	{PMIC_ACCDET_TEST_MODE0, MT6328_PMIC_ACCDET_TEST_MODE0_ADDR,
	 MT6328_PMIC_ACCDET_TEST_MODE0_MASK, MT6328_PMIC_ACCDET_TEST_MODE0_SHIFT},
	{PMIC_ACCDET_TEST_MODE1, MT6328_PMIC_ACCDET_TEST_MODE1_ADDR,
	 MT6328_PMIC_ACCDET_TEST_MODE1_MASK, MT6328_PMIC_ACCDET_TEST_MODE1_SHIFT},
	{PMIC_ACCDET_TEST_MODE2, MT6328_PMIC_ACCDET_TEST_MODE2_ADDR,
	 MT6328_PMIC_ACCDET_TEST_MODE2_MASK, MT6328_PMIC_ACCDET_TEST_MODE2_SHIFT},
	{PMIC_ACCDET_TEST_MODE3, MT6328_PMIC_ACCDET_TEST_MODE3_ADDR,
	 MT6328_PMIC_ACCDET_TEST_MODE3_MASK, MT6328_PMIC_ACCDET_TEST_MODE3_SHIFT},
	{PMIC_ACCDET_TEST_MODE4, MT6328_PMIC_ACCDET_TEST_MODE4_ADDR,
	 MT6328_PMIC_ACCDET_TEST_MODE4_MASK, MT6328_PMIC_ACCDET_TEST_MODE4_SHIFT},
	{PMIC_ACCDET_TEST_MODE5, MT6328_PMIC_ACCDET_TEST_MODE5_ADDR,
	 MT6328_PMIC_ACCDET_TEST_MODE5_MASK, MT6328_PMIC_ACCDET_TEST_MODE5_SHIFT},
	{PMIC_ACCDET_PWM_SEL, MT6328_PMIC_ACCDET_PWM_SEL_ADDR, MT6328_PMIC_ACCDET_PWM_SEL_MASK,
	 MT6328_PMIC_ACCDET_PWM_SEL_SHIFT},
	{PMIC_ACCDET_IN_SW, MT6328_PMIC_ACCDET_IN_SW_ADDR, MT6328_PMIC_ACCDET_IN_SW_MASK,
	 MT6328_PMIC_ACCDET_IN_SW_SHIFT},
	{PMIC_ACCDET_CMP_EN_SW, MT6328_PMIC_ACCDET_CMP_EN_SW_ADDR,
	 MT6328_PMIC_ACCDET_CMP_EN_SW_MASK, MT6328_PMIC_ACCDET_CMP_EN_SW_SHIFT},
	{PMIC_ACCDET_VTH_EN_SW, MT6328_PMIC_ACCDET_VTH_EN_SW_ADDR,
	 MT6328_PMIC_ACCDET_VTH_EN_SW_MASK, MT6328_PMIC_ACCDET_VTH_EN_SW_SHIFT},
	{PMIC_ACCDET_MBIAS_EN_SW, MT6328_PMIC_ACCDET_MBIAS_EN_SW_ADDR,
	 MT6328_PMIC_ACCDET_MBIAS_EN_SW_MASK, MT6328_PMIC_ACCDET_MBIAS_EN_SW_SHIFT},
	{PMIC_ACCDET_PWM_EN_SW, MT6328_PMIC_ACCDET_PWM_EN_SW_ADDR,
	 MT6328_PMIC_ACCDET_PWM_EN_SW_MASK, MT6328_PMIC_ACCDET_PWM_EN_SW_SHIFT},
	{PMIC_ACCDET_IN, MT6328_PMIC_ACCDET_IN_ADDR, MT6328_PMIC_ACCDET_IN_MASK,
	 MT6328_PMIC_ACCDET_IN_SHIFT},
	{PMIC_ACCDET_CUR_IN, MT6328_PMIC_ACCDET_CUR_IN_ADDR, MT6328_PMIC_ACCDET_CUR_IN_MASK,
	 MT6328_PMIC_ACCDET_CUR_IN_SHIFT},
	{PMIC_ACCDET_SAM_IN, MT6328_PMIC_ACCDET_SAM_IN_ADDR, MT6328_PMIC_ACCDET_SAM_IN_MASK,
	 MT6328_PMIC_ACCDET_SAM_IN_SHIFT},
	{PMIC_ACCDET_MEM_IN, MT6328_PMIC_ACCDET_MEM_IN_ADDR, MT6328_PMIC_ACCDET_MEM_IN_MASK,
	 MT6328_PMIC_ACCDET_MEM_IN_SHIFT},
	{PMIC_ACCDET_STATE, MT6328_PMIC_ACCDET_STATE_ADDR, MT6328_PMIC_ACCDET_STATE_MASK,
	 MT6328_PMIC_ACCDET_STATE_SHIFT},
	{PMIC_ACCDET_MBIAS_CLK, MT6328_PMIC_ACCDET_MBIAS_CLK_ADDR,
	 MT6328_PMIC_ACCDET_MBIAS_CLK_MASK, MT6328_PMIC_ACCDET_MBIAS_CLK_SHIFT},
	{PMIC_ACCDET_VTH_CLK, MT6328_PMIC_ACCDET_VTH_CLK_ADDR, MT6328_PMIC_ACCDET_VTH_CLK_MASK,
	 MT6328_PMIC_ACCDET_VTH_CLK_SHIFT},
	{PMIC_ACCDET_CMP_CLK, MT6328_PMIC_ACCDET_CMP_CLK_ADDR, MT6328_PMIC_ACCDET_CMP_CLK_MASK,
	 MT6328_PMIC_ACCDET_CMP_CLK_SHIFT},
	{PMIC_DA_AUDACCDETAUXADCSWCTRL, MT6328_PMIC_DA_AUDACCDETAUXADCSWCTRL_ADDR,
	 MT6328_PMIC_DA_AUDACCDETAUXADCSWCTRL_MASK, MT6328_PMIC_DA_AUDACCDETAUXADCSWCTRL_SHIFT},
	{PMIC_ACCDET_EINT_DEB_SEL, MT6328_PMIC_ACCDET_EINT_DEB_SEL_ADDR,
	 MT6328_PMIC_ACCDET_EINT_DEB_SEL_MASK, MT6328_PMIC_ACCDET_EINT_DEB_SEL_SHIFT},
	{PMIC_ACCDET_EINT_DEBOUNCE, MT6328_PMIC_ACCDET_EINT_DEBOUNCE_ADDR,
	 MT6328_PMIC_ACCDET_EINT_DEBOUNCE_MASK, MT6328_PMIC_ACCDET_EINT_DEBOUNCE_SHIFT},
	{PMIC_ACCDET_EINT_PWM_THRESH, MT6328_PMIC_ACCDET_EINT_PWM_THRESH_ADDR,
	 MT6328_PMIC_ACCDET_EINT_PWM_THRESH_MASK, MT6328_PMIC_ACCDET_EINT_PWM_THRESH_SHIFT},
	{PMIC_ACCDET_EINT_PWM_WIDTH, MT6328_PMIC_ACCDET_EINT_PWM_WIDTH_ADDR,
	 MT6328_PMIC_ACCDET_EINT_PWM_WIDTH_MASK, MT6328_PMIC_ACCDET_EINT_PWM_WIDTH_SHIFT},
	{PMIC_ACCDET_NEGV_THRESH, MT6328_PMIC_ACCDET_NEGV_THRESH_ADDR,
	 MT6328_PMIC_ACCDET_NEGV_THRESH_MASK, MT6328_PMIC_ACCDET_NEGV_THRESH_SHIFT},
	{PMIC_ACCDET_EINT_PWM_FALL_DELAY, MT6328_PMIC_ACCDET_EINT_PWM_FALL_DELAY_ADDR,
	 MT6328_PMIC_ACCDET_EINT_PWM_FALL_DELAY_MASK, MT6328_PMIC_ACCDET_EINT_PWM_FALL_DELAY_SHIFT},
	{PMIC_ACCDET_EINT_PWM_RISE_DELAY, MT6328_PMIC_ACCDET_EINT_PWM_RISE_DELAY_ADDR,
	 MT6328_PMIC_ACCDET_EINT_PWM_RISE_DELAY_MASK, MT6328_PMIC_ACCDET_EINT_PWM_RISE_DELAY_SHIFT},
	{PMIC_ACCDET_TEST_MODE13, MT6328_PMIC_ACCDET_TEST_MODE13_ADDR,
	 MT6328_PMIC_ACCDET_TEST_MODE13_MASK, MT6328_PMIC_ACCDET_TEST_MODE13_SHIFT},
	{PMIC_ACCDET_TEST_MODE12, MT6328_PMIC_ACCDET_TEST_MODE12_ADDR,
	 MT6328_PMIC_ACCDET_TEST_MODE12_MASK, MT6328_PMIC_ACCDET_TEST_MODE12_SHIFT},
	{PMIC_ACCDET_NVDETECTOUT_SW, MT6328_PMIC_ACCDET_NVDETECTOUT_SW_ADDR,
	 MT6328_PMIC_ACCDET_NVDETECTOUT_SW_MASK, MT6328_PMIC_ACCDET_NVDETECTOUT_SW_SHIFT},
	{PMIC_ACCDET_TEST_MODE11, MT6328_PMIC_ACCDET_TEST_MODE11_ADDR,
	 MT6328_PMIC_ACCDET_TEST_MODE11_MASK, MT6328_PMIC_ACCDET_TEST_MODE11_SHIFT},
	{PMIC_ACCDET_TEST_MODE10, MT6328_PMIC_ACCDET_TEST_MODE10_ADDR,
	 MT6328_PMIC_ACCDET_TEST_MODE10_MASK, MT6328_PMIC_ACCDET_TEST_MODE10_SHIFT},
	{PMIC_ACCDET_EINTCMPOUT_SW, MT6328_PMIC_ACCDET_EINTCMPOUT_SW_ADDR,
	 MT6328_PMIC_ACCDET_EINTCMPOUT_SW_MASK, MT6328_PMIC_ACCDET_EINTCMPOUT_SW_SHIFT},
	{PMIC_ACCDET_TEST_MODE9, MT6328_PMIC_ACCDET_TEST_MODE9_ADDR,
	 MT6328_PMIC_ACCDET_TEST_MODE9_MASK, MT6328_PMIC_ACCDET_TEST_MODE9_SHIFT},
	{PMIC_ACCDET_TEST_MODE8, MT6328_PMIC_ACCDET_TEST_MODE8_ADDR,
	 MT6328_PMIC_ACCDET_TEST_MODE8_MASK, MT6328_PMIC_ACCDET_TEST_MODE8_SHIFT},
	{PMIC_ACCDET_AUXADC_CTRL_SW, MT6328_PMIC_ACCDET_AUXADC_CTRL_SW_ADDR,
	 MT6328_PMIC_ACCDET_AUXADC_CTRL_SW_MASK, MT6328_PMIC_ACCDET_AUXADC_CTRL_SW_SHIFT},
	{PMIC_ACCDET_TEST_MODE7, MT6328_PMIC_ACCDET_TEST_MODE7_ADDR,
	 MT6328_PMIC_ACCDET_TEST_MODE7_MASK, MT6328_PMIC_ACCDET_TEST_MODE7_SHIFT},
	{PMIC_ACCDET_TEST_MODE6, MT6328_PMIC_ACCDET_TEST_MODE6_ADDR,
	 MT6328_PMIC_ACCDET_TEST_MODE6_MASK, MT6328_PMIC_ACCDET_TEST_MODE6_SHIFT},
	{PMIC_ACCDET_EINTCMP_EN_SW, MT6328_PMIC_ACCDET_EINTCMP_EN_SW_ADDR,
	 MT6328_PMIC_ACCDET_EINTCMP_EN_SW_MASK, MT6328_PMIC_ACCDET_EINTCMP_EN_SW_SHIFT},
	{PMIC_RG_NVCMPSWEN, MT6328_PMIC_RG_NVCMPSWEN_ADDR, MT6328_PMIC_RG_NVCMPSWEN_MASK,
	 MT6328_PMIC_RG_NVCMPSWEN_SHIFT},
	{PMIC_RG_NVMODSEL, MT6328_PMIC_RG_NVMODSEL_ADDR, MT6328_PMIC_RG_NVMODSEL_MASK,
	 MT6328_PMIC_RG_NVMODSEL_SHIFT},
	{PMIC_RG_SWBUFSWEN, MT6328_PMIC_RG_SWBUFSWEN_ADDR, MT6328_PMIC_RG_SWBUFSWEN_MASK,
	 MT6328_PMIC_RG_SWBUFSWEN_SHIFT},
	{PMIC_RG_SWBUFMODSEL, MT6328_PMIC_RG_SWBUFMODSEL_ADDR, MT6328_PMIC_RG_SWBUFMODSEL_MASK,
	 MT6328_PMIC_RG_SWBUFMODSEL_SHIFT},
	{PMIC_RG_NVDETVTH, MT6328_PMIC_RG_NVDETVTH_ADDR, MT6328_PMIC_RG_NVDETVTH_MASK,
	 MT6328_PMIC_RG_NVDETVTH_SHIFT},
	{PMIC_RG_NVDETCMPEN, MT6328_PMIC_RG_NVDETCMPEN_ADDR, MT6328_PMIC_RG_NVDETCMPEN_MASK,
	 MT6328_PMIC_RG_NVDETCMPEN_SHIFT},
	{PMIC_RG_EINTCONFIGACCDET, MT6328_PMIC_RG_EINTCONFIGACCDET_ADDR,
	 MT6328_PMIC_RG_EINTCONFIGACCDET_MASK, MT6328_PMIC_RG_EINTCONFIGACCDET_SHIFT},
	{PMIC_RG_EINTCOMPVTH, MT6328_PMIC_RG_EINTCOMPVTH_ADDR, MT6328_PMIC_RG_EINTCOMPVTH_MASK,
	 MT6328_PMIC_RG_EINTCOMPVTH_SHIFT},
	{PMIC_ACCDET_EINT_STATE, MT6328_PMIC_ACCDET_EINT_STATE_ADDR,
	 MT6328_PMIC_ACCDET_EINT_STATE_MASK, MT6328_PMIC_ACCDET_EINT_STATE_SHIFT},
	{PMIC_ACCDET_AUXADC_DEBOUNCE_END, MT6328_PMIC_ACCDET_AUXADC_DEBOUNCE_END_ADDR,
	 MT6328_PMIC_ACCDET_AUXADC_DEBOUNCE_END_MASK, MT6328_PMIC_ACCDET_AUXADC_DEBOUNCE_END_SHIFT},
	{PMIC_ACCDET_AUXADC_CONNECT_PRE, MT6328_PMIC_ACCDET_AUXADC_CONNECT_PRE_ADDR,
	 MT6328_PMIC_ACCDET_AUXADC_CONNECT_PRE_MASK, MT6328_PMIC_ACCDET_AUXADC_CONNECT_PRE_SHIFT},
	{PMIC_ACCDET_EINT_CUR_IN, MT6328_PMIC_ACCDET_EINT_CUR_IN_ADDR,
	 MT6328_PMIC_ACCDET_EINT_CUR_IN_MASK, MT6328_PMIC_ACCDET_EINT_CUR_IN_SHIFT},
	{PMIC_ACCDET_EINT_SAM_IN, MT6328_PMIC_ACCDET_EINT_SAM_IN_ADDR,
	 MT6328_PMIC_ACCDET_EINT_SAM_IN_MASK, MT6328_PMIC_ACCDET_EINT_SAM_IN_SHIFT},
	{PMIC_ACCDET_EINT_MEM_IN, MT6328_PMIC_ACCDET_EINT_MEM_IN_ADDR,
	 MT6328_PMIC_ACCDET_EINT_MEM_IN_MASK, MT6328_PMIC_ACCDET_EINT_MEM_IN_SHIFT},
	{PMIC_NVDETECTOUT, MT6328_PMIC_NVDETECTOUT_ADDR, MT6328_PMIC_NVDETECTOUT_MASK,
	 MT6328_PMIC_NVDETECTOUT_SHIFT},
	{PMIC_EINTCMPOUT, MT6328_PMIC_EINTCMPOUT_ADDR, MT6328_PMIC_EINTCMPOUT_MASK,
	 MT6328_PMIC_EINTCMPOUT_SHIFT},
	{PMIC_NI_EINTCMPEN, MT6328_PMIC_NI_EINTCMPEN_ADDR, MT6328_PMIC_NI_EINTCMPEN_MASK,
	 MT6328_PMIC_NI_EINTCMPEN_SHIFT},
	{PMIC_ACCDET_NEGV_COUNT_IN, MT6328_PMIC_ACCDET_NEGV_COUNT_IN_ADDR,
	 MT6328_PMIC_ACCDET_NEGV_COUNT_IN_MASK, MT6328_PMIC_ACCDET_NEGV_COUNT_IN_SHIFT},
	{PMIC_ACCDET_NEGV_EN_FINAL, MT6328_PMIC_ACCDET_NEGV_EN_FINAL_ADDR,
	 MT6328_PMIC_ACCDET_NEGV_EN_FINAL_MASK, MT6328_PMIC_ACCDET_NEGV_EN_FINAL_SHIFT},
	{PMIC_ACCDET_NEGV_COUNT_END, MT6328_PMIC_ACCDET_NEGV_COUNT_END_ADDR,
	 MT6328_PMIC_ACCDET_NEGV_COUNT_END_MASK, MT6328_PMIC_ACCDET_NEGV_COUNT_END_SHIFT},
	{PMIC_ACCDET_NEGV_MINU, MT6328_PMIC_ACCDET_NEGV_MINU_ADDR,
	 MT6328_PMIC_ACCDET_NEGV_MINU_MASK, MT6328_PMIC_ACCDET_NEGV_MINU_SHIFT},
	{PMIC_ACCDET_NEGV_ADD, MT6328_PMIC_ACCDET_NEGV_ADD_ADDR, MT6328_PMIC_ACCDET_NEGV_ADD_MASK,
	 MT6328_PMIC_ACCDET_NEGV_ADD_SHIFT},
	{PMIC_ACCDET_NEGV_CMP, MT6328_PMIC_ACCDET_NEGV_CMP_ADDR, MT6328_PMIC_ACCDET_NEGV_CMP_MASK,
	 MT6328_PMIC_ACCDET_NEGV_CMP_SHIFT},
	{PMIC_ACCDET_CUR_DEB, MT6328_PMIC_ACCDET_CUR_DEB_ADDR, MT6328_PMIC_ACCDET_CUR_DEB_MASK,
	 MT6328_PMIC_ACCDET_CUR_DEB_SHIFT},
	{PMIC_ACCDET_EINT_CUR_DEB, MT6328_PMIC_ACCDET_EINT_CUR_DEB_ADDR,
	 MT6328_PMIC_ACCDET_EINT_CUR_DEB_MASK, MT6328_PMIC_ACCDET_EINT_CUR_DEB_SHIFT},
	{PMIC_ACCDET_RSV_CON0, MT6328_PMIC_ACCDET_RSV_CON0_ADDR, MT6328_PMIC_ACCDET_RSV_CON0_MASK,
	 MT6328_PMIC_ACCDET_RSV_CON0_SHIFT},
	{PMIC_ACCDET_RSV_CON1, MT6328_PMIC_ACCDET_RSV_CON1_ADDR, MT6328_PMIC_ACCDET_RSV_CON1_MASK,
	 MT6328_PMIC_ACCDET_RSV_CON1_SHIFT},
	{PMIC_ACCDET_AUXADC_CONNECT_TIME, MT6328_PMIC_ACCDET_AUXADC_CONNECT_TIME_ADDR,
	 MT6328_PMIC_ACCDET_AUXADC_CONNECT_TIME_MASK, MT6328_PMIC_ACCDET_AUXADC_CONNECT_TIME_SHIFT},
	{PMIC_RG_VCDT_HV_EN, MT6328_PMIC_RG_VCDT_HV_EN_ADDR, MT6328_PMIC_RG_VCDT_HV_EN_MASK,
	 MT6328_PMIC_RG_VCDT_HV_EN_SHIFT},
	{PMIC_RGS_CHR_LDO_DET, MT6328_PMIC_RGS_CHR_LDO_DET_ADDR, MT6328_PMIC_RGS_CHR_LDO_DET_MASK,
	 MT6328_PMIC_RGS_CHR_LDO_DET_SHIFT},
	{PMIC_RG_PCHR_AUTOMODE, MT6328_PMIC_RG_PCHR_AUTOMODE_ADDR,
	 MT6328_PMIC_RG_PCHR_AUTOMODE_MASK, MT6328_PMIC_RG_PCHR_AUTOMODE_SHIFT},
	{PMIC_RG_CSDAC_EN, MT6328_PMIC_RG_CSDAC_EN_ADDR, MT6328_PMIC_RG_CSDAC_EN_MASK,
	 MT6328_PMIC_RG_CSDAC_EN_SHIFT},
	{PMIC_RG_CHR_EN, MT6328_PMIC_RG_CHR_EN_ADDR, MT6328_PMIC_RG_CHR_EN_MASK,
	 MT6328_PMIC_RG_CHR_EN_SHIFT},
	{PMIC_RGS_CHRDET, MT6328_PMIC_RGS_CHRDET_ADDR, MT6328_PMIC_RGS_CHRDET_MASK,
	 MT6328_PMIC_RGS_CHRDET_SHIFT},
	{PMIC_RGS_VCDT_LV_DET, MT6328_PMIC_RGS_VCDT_LV_DET_ADDR, MT6328_PMIC_RGS_VCDT_LV_DET_MASK,
	 MT6328_PMIC_RGS_VCDT_LV_DET_SHIFT},
	{PMIC_RGS_VCDT_HV_DET, MT6328_PMIC_RGS_VCDT_HV_DET_ADDR, MT6328_PMIC_RGS_VCDT_HV_DET_MASK,
	 MT6328_PMIC_RGS_VCDT_HV_DET_SHIFT},
	{PMIC_RG_VCDT_LV_VTH, MT6328_PMIC_RG_VCDT_LV_VTH_ADDR, MT6328_PMIC_RG_VCDT_LV_VTH_MASK,
	 MT6328_PMIC_RG_VCDT_LV_VTH_SHIFT},
	{PMIC_RG_VCDT_HV_VTH, MT6328_PMIC_RG_VCDT_HV_VTH_ADDR, MT6328_PMIC_RG_VCDT_HV_VTH_MASK,
	 MT6328_PMIC_RG_VCDT_HV_VTH_SHIFT},
	{PMIC_RG_VBAT_CV_EN, MT6328_PMIC_RG_VBAT_CV_EN_ADDR, MT6328_PMIC_RG_VBAT_CV_EN_MASK,
	 MT6328_PMIC_RG_VBAT_CV_EN_SHIFT},
	{PMIC_RG_VBAT_CC_EN, MT6328_PMIC_RG_VBAT_CC_EN_ADDR, MT6328_PMIC_RG_VBAT_CC_EN_MASK,
	 MT6328_PMIC_RG_VBAT_CC_EN_SHIFT},
	{PMIC_RG_CS_EN, MT6328_PMIC_RG_CS_EN_ADDR, MT6328_PMIC_RG_CS_EN_MASK,
	 MT6328_PMIC_RG_CS_EN_SHIFT},
	{PMIC_RGS_CS_DET, MT6328_PMIC_RGS_CS_DET_ADDR, MT6328_PMIC_RGS_CS_DET_MASK,
	 MT6328_PMIC_RGS_CS_DET_SHIFT},
	{PMIC_RGS_VBAT_CV_DET, MT6328_PMIC_RGS_VBAT_CV_DET_ADDR, MT6328_PMIC_RGS_VBAT_CV_DET_MASK,
	 MT6328_PMIC_RGS_VBAT_CV_DET_SHIFT},
	{PMIC_RGS_VBAT_CC_DET, MT6328_PMIC_RGS_VBAT_CC_DET_ADDR, MT6328_PMIC_RGS_VBAT_CC_DET_MASK,
	 MT6328_PMIC_RGS_VBAT_CC_DET_SHIFT},
	{PMIC_RG_VBAT_CV_VTH, MT6328_PMIC_RG_VBAT_CV_VTH_ADDR, MT6328_PMIC_RG_VBAT_CV_VTH_MASK,
	 MT6328_PMIC_RG_VBAT_CV_VTH_SHIFT},
	{PMIC_RG_VBAT_CC_VTH, MT6328_PMIC_RG_VBAT_CC_VTH_ADDR, MT6328_PMIC_RG_VBAT_CC_VTH_MASK,
	 MT6328_PMIC_RG_VBAT_CC_VTH_SHIFT},
	{PMIC_RG_CS_VTH, MT6328_PMIC_RG_CS_VTH_ADDR, MT6328_PMIC_RG_CS_VTH_MASK,
	 MT6328_PMIC_RG_CS_VTH_SHIFT},
	{PMIC_RG_PCHR_TOHTC, MT6328_PMIC_RG_PCHR_TOHTC_ADDR, MT6328_PMIC_RG_PCHR_TOHTC_MASK,
	 MT6328_PMIC_RG_PCHR_TOHTC_SHIFT},
	{PMIC_RG_PCHR_TOLTC, MT6328_PMIC_RG_PCHR_TOLTC_ADDR, MT6328_PMIC_RG_PCHR_TOLTC_MASK,
	 MT6328_PMIC_RG_PCHR_TOLTC_SHIFT},
	{PMIC_RG_VBAT_OV_EN, MT6328_PMIC_RG_VBAT_OV_EN_ADDR, MT6328_PMIC_RG_VBAT_OV_EN_MASK,
	 MT6328_PMIC_RG_VBAT_OV_EN_SHIFT},
	{PMIC_RG_VBAT_OV_VTH, MT6328_PMIC_RG_VBAT_OV_VTH_ADDR, MT6328_PMIC_RG_VBAT_OV_VTH_MASK,
	 MT6328_PMIC_RG_VBAT_OV_VTH_SHIFT},
	{PMIC_RG_VBAT_OV_DEG, MT6328_PMIC_RG_VBAT_OV_DEG_ADDR, MT6328_PMIC_RG_VBAT_OV_DEG_MASK,
	 MT6328_PMIC_RG_VBAT_OV_DEG_SHIFT},
	{PMIC_RGS_VBAT_OV_DET, MT6328_PMIC_RGS_VBAT_OV_DET_ADDR, MT6328_PMIC_RGS_VBAT_OV_DET_MASK,
	 MT6328_PMIC_RGS_VBAT_OV_DET_SHIFT},
	{PMIC_RG_BATON_EN, MT6328_PMIC_RG_BATON_EN_ADDR, MT6328_PMIC_RG_BATON_EN_MASK,
	 MT6328_PMIC_RG_BATON_EN_SHIFT},
	{PMIC_RG_BATON_HT_EN_RSV0, MT6328_PMIC_RG_BATON_HT_EN_RSV0_ADDR,
	 MT6328_PMIC_RG_BATON_HT_EN_RSV0_MASK, MT6328_PMIC_RG_BATON_HT_EN_RSV0_SHIFT},
	{PMIC_BATON_TDET_EN, MT6328_PMIC_BATON_TDET_EN_ADDR, MT6328_PMIC_BATON_TDET_EN_MASK,
	 MT6328_PMIC_BATON_TDET_EN_SHIFT},
	{PMIC_RG_BATON_HT_TRIM, MT6328_PMIC_RG_BATON_HT_TRIM_ADDR,
	 MT6328_PMIC_RG_BATON_HT_TRIM_MASK, MT6328_PMIC_RG_BATON_HT_TRIM_SHIFT},
	{PMIC_RG_BATON_HT_TRIM_SET, MT6328_PMIC_RG_BATON_HT_TRIM_SET_ADDR,
	 MT6328_PMIC_RG_BATON_HT_TRIM_SET_MASK, MT6328_PMIC_RG_BATON_HT_TRIM_SET_SHIFT},
	{PMIC_RG_BATON_TDET_EN, MT6328_PMIC_RG_BATON_TDET_EN_ADDR,
	 MT6328_PMIC_RG_BATON_TDET_EN_MASK, MT6328_PMIC_RG_BATON_TDET_EN_SHIFT},
	{PMIC_RG_CSDAC_DATA, MT6328_PMIC_RG_CSDAC_DATA_ADDR, MT6328_PMIC_RG_CSDAC_DATA_MASK,
	 MT6328_PMIC_RG_CSDAC_DATA_SHIFT},
	{PMIC_RG_FRC_CSVTH_USBDL, MT6328_PMIC_RG_FRC_CSVTH_USBDL_ADDR,
	 MT6328_PMIC_RG_FRC_CSVTH_USBDL_MASK, MT6328_PMIC_RG_FRC_CSVTH_USBDL_SHIFT},
	{PMIC_RGS_PCHR_FLAG_OUT, MT6328_PMIC_RGS_PCHR_FLAG_OUT_ADDR,
	 MT6328_PMIC_RGS_PCHR_FLAG_OUT_MASK, MT6328_PMIC_RGS_PCHR_FLAG_OUT_SHIFT},
	{PMIC_RG_PCHR_FLAG_EN, MT6328_PMIC_RG_PCHR_FLAG_EN_ADDR, MT6328_PMIC_RG_PCHR_FLAG_EN_MASK,
	 MT6328_PMIC_RG_PCHR_FLAG_EN_SHIFT},
	{PMIC_RG_OTG_BVALID_EN, MT6328_PMIC_RG_OTG_BVALID_EN_ADDR,
	 MT6328_PMIC_RG_OTG_BVALID_EN_MASK, MT6328_PMIC_RG_OTG_BVALID_EN_SHIFT},
	{PMIC_RGS_OTG_BVALID_DET, MT6328_PMIC_RGS_OTG_BVALID_DET_ADDR,
	 MT6328_PMIC_RGS_OTG_BVALID_DET_MASK, MT6328_PMIC_RGS_OTG_BVALID_DET_SHIFT},
	{PMIC_RG_PCHR_FLAG_SEL, MT6328_PMIC_RG_PCHR_FLAG_SEL_ADDR,
	 MT6328_PMIC_RG_PCHR_FLAG_SEL_MASK, MT6328_PMIC_RG_PCHR_FLAG_SEL_SHIFT},
	{PMIC_RG_PCHR_TESTMODE, MT6328_PMIC_RG_PCHR_TESTMODE_ADDR,
	 MT6328_PMIC_RG_PCHR_TESTMODE_MASK, MT6328_PMIC_RG_PCHR_TESTMODE_SHIFT},
	{PMIC_RG_CSDAC_TESTMODE, MT6328_PMIC_RG_CSDAC_TESTMODE_ADDR,
	 MT6328_PMIC_RG_CSDAC_TESTMODE_MASK, MT6328_PMIC_RG_CSDAC_TESTMODE_SHIFT},
	{PMIC_RG_PCHR_RST, MT6328_PMIC_RG_PCHR_RST_ADDR, MT6328_PMIC_RG_PCHR_RST_MASK,
	 MT6328_PMIC_RG_PCHR_RST_SHIFT},
	{PMIC_RG_PCHR_FT_CTRL, MT6328_PMIC_RG_PCHR_FT_CTRL_ADDR, MT6328_PMIC_RG_PCHR_FT_CTRL_MASK,
	 MT6328_PMIC_RG_PCHR_FT_CTRL_SHIFT},
	{PMIC_RG_CHRWDT_TD, MT6328_PMIC_RG_CHRWDT_TD_ADDR, MT6328_PMIC_RG_CHRWDT_TD_MASK,
	 MT6328_PMIC_RG_CHRWDT_TD_SHIFT},
	{PMIC_RG_CHRWDT_EN, MT6328_PMIC_RG_CHRWDT_EN_ADDR, MT6328_PMIC_RG_CHRWDT_EN_MASK,
	 MT6328_PMIC_RG_CHRWDT_EN_SHIFT},
	{PMIC_RG_CHRWDT_WR, MT6328_PMIC_RG_CHRWDT_WR_ADDR, MT6328_PMIC_RG_CHRWDT_WR_MASK,
	 MT6328_PMIC_RG_CHRWDT_WR_SHIFT},
	{PMIC_RG_PCHR_RV, MT6328_PMIC_RG_PCHR_RV_ADDR, MT6328_PMIC_RG_PCHR_RV_MASK,
	 MT6328_PMIC_RG_PCHR_RV_SHIFT},
	{PMIC_RG_CHRWDT_INT_EN, MT6328_PMIC_RG_CHRWDT_INT_EN_ADDR,
	 MT6328_PMIC_RG_CHRWDT_INT_EN_MASK, MT6328_PMIC_RG_CHRWDT_INT_EN_SHIFT},
	{PMIC_RG_CHRWDT_FLAG_WR, MT6328_PMIC_RG_CHRWDT_FLAG_WR_ADDR,
	 MT6328_PMIC_RG_CHRWDT_FLAG_WR_MASK, MT6328_PMIC_RG_CHRWDT_FLAG_WR_SHIFT},
	{PMIC_RGS_CHRWDT_OUT, MT6328_PMIC_RGS_CHRWDT_OUT_ADDR, MT6328_PMIC_RGS_CHRWDT_OUT_MASK,
	 MT6328_PMIC_RGS_CHRWDT_OUT_SHIFT},
	{PMIC_RG_USBDL_RST, MT6328_PMIC_RG_USBDL_RST_ADDR, MT6328_PMIC_RG_USBDL_RST_MASK,
	 MT6328_PMIC_RG_USBDL_RST_SHIFT},
	{PMIC_RG_USBDL_SET, MT6328_PMIC_RG_USBDL_SET_ADDR, MT6328_PMIC_RG_USBDL_SET_MASK,
	 MT6328_PMIC_RG_USBDL_SET_SHIFT},
	{PMIC_RG_ADCIN_VSEN_MUX_EN, MT6328_PMIC_RG_ADCIN_VSEN_MUX_EN_ADDR,
	 MT6328_PMIC_RG_ADCIN_VSEN_MUX_EN_MASK, MT6328_PMIC_RG_ADCIN_VSEN_MUX_EN_SHIFT},
	{PMIC_RG_ADCIN_VSEN_EXT_BATON_EN, MT6328_PMIC_RG_ADCIN_VSEN_EXT_BATON_EN_ADDR,
	 MT6328_PMIC_RG_ADCIN_VSEN_EXT_BATON_EN_MASK, MT6328_PMIC_RG_ADCIN_VSEN_EXT_BATON_EN_SHIFT},
	{PMIC_RG_ADCIN_VBAT_EN, MT6328_PMIC_RG_ADCIN_VBAT_EN_ADDR,
	 MT6328_PMIC_RG_ADCIN_VBAT_EN_MASK, MT6328_PMIC_RG_ADCIN_VBAT_EN_SHIFT},
	{PMIC_RG_ADCIN_VSEN_EN, MT6328_PMIC_RG_ADCIN_VSEN_EN_ADDR,
	 MT6328_PMIC_RG_ADCIN_VSEN_EN_MASK, MT6328_PMIC_RG_ADCIN_VSEN_EN_SHIFT},
	{PMIC_RG_ADCIN_CHR_EN, MT6328_PMIC_RG_ADCIN_CHR_EN_ADDR, MT6328_PMIC_RG_ADCIN_CHR_EN_MASK,
	 MT6328_PMIC_RG_ADCIN_CHR_EN_SHIFT},
	{PMIC_RG_UVLO_VTHL, MT6328_PMIC_RG_UVLO_VTHL_ADDR, MT6328_PMIC_RG_UVLO_VTHL_MASK,
	 MT6328_PMIC_RG_UVLO_VTHL_SHIFT},
	{PMIC_RG_UVLO_VH_LAT, MT6328_PMIC_RG_UVLO_VH_LAT_ADDR, MT6328_PMIC_RG_UVLO_VH_LAT_MASK,
	 MT6328_PMIC_RG_UVLO_VH_LAT_SHIFT},
	{PMIC_RG_LBAT_INT_VTH, MT6328_PMIC_RG_LBAT_INT_VTH_ADDR, MT6328_PMIC_RG_LBAT_INT_VTH_MASK,
	 MT6328_PMIC_RG_LBAT_INT_VTH_SHIFT},
	{PMIC_RG_BGR_RSEL, MT6328_PMIC_RG_BGR_RSEL_ADDR, MT6328_PMIC_RG_BGR_RSEL_MASK,
	 MT6328_PMIC_RG_BGR_RSEL_SHIFT},
	{PMIC_RG_BGR_UNCHOP_PH, MT6328_PMIC_RG_BGR_UNCHOP_PH_ADDR,
	 MT6328_PMIC_RG_BGR_UNCHOP_PH_MASK, MT6328_PMIC_RG_BGR_UNCHOP_PH_SHIFT},
	{PMIC_RG_BGR_UNCHOP, MT6328_PMIC_RG_BGR_UNCHOP_ADDR, MT6328_PMIC_RG_BGR_UNCHOP_MASK,
	 MT6328_PMIC_RG_BGR_UNCHOP_SHIFT},
	{PMIC_RG_BC11_BB_CTRL, MT6328_PMIC_RG_BC11_BB_CTRL_ADDR, MT6328_PMIC_RG_BC11_BB_CTRL_MASK,
	 MT6328_PMIC_RG_BC11_BB_CTRL_SHIFT},
	{PMIC_RG_BC11_RST, MT6328_PMIC_RG_BC11_RST_ADDR, MT6328_PMIC_RG_BC11_RST_MASK,
	 MT6328_PMIC_RG_BC11_RST_SHIFT},
	{PMIC_RG_BC11_VSRC_EN, MT6328_PMIC_RG_BC11_VSRC_EN_ADDR, MT6328_PMIC_RG_BC11_VSRC_EN_MASK,
	 MT6328_PMIC_RG_BC11_VSRC_EN_SHIFT},
	{PMIC_RGS_BC11_CMP_OUT, MT6328_PMIC_RGS_BC11_CMP_OUT_ADDR,
	 MT6328_PMIC_RGS_BC11_CMP_OUT_MASK, MT6328_PMIC_RGS_BC11_CMP_OUT_SHIFT},
	{PMIC_RG_BC11_VREF_VTH, MT6328_PMIC_RG_BC11_VREF_VTH_ADDR,
	 MT6328_PMIC_RG_BC11_VREF_VTH_MASK, MT6328_PMIC_RG_BC11_VREF_VTH_SHIFT},
	{PMIC_RG_BC11_CMP_EN, MT6328_PMIC_RG_BC11_CMP_EN_ADDR, MT6328_PMIC_RG_BC11_CMP_EN_MASK,
	 MT6328_PMIC_RG_BC11_CMP_EN_SHIFT},
	{PMIC_RG_BC11_IPD_EN, MT6328_PMIC_RG_BC11_IPD_EN_ADDR, MT6328_PMIC_RG_BC11_IPD_EN_MASK,
	 MT6328_PMIC_RG_BC11_IPD_EN_SHIFT},
	{PMIC_RG_BC11_IPU_EN, MT6328_PMIC_RG_BC11_IPU_EN_ADDR, MT6328_PMIC_RG_BC11_IPU_EN_MASK,
	 MT6328_PMIC_RG_BC11_IPU_EN_SHIFT},
	{PMIC_RG_BC11_BIAS_EN, MT6328_PMIC_RG_BC11_BIAS_EN_ADDR, MT6328_PMIC_RG_BC11_BIAS_EN_MASK,
	 MT6328_PMIC_RG_BC11_BIAS_EN_SHIFT},
	{PMIC_RG_CSDAC_STP_INC, MT6328_PMIC_RG_CSDAC_STP_INC_ADDR,
	 MT6328_PMIC_RG_CSDAC_STP_INC_MASK, MT6328_PMIC_RG_CSDAC_STP_INC_SHIFT},
	{PMIC_RG_CSDAC_STP_DEC, MT6328_PMIC_RG_CSDAC_STP_DEC_ADDR,
	 MT6328_PMIC_RG_CSDAC_STP_DEC_MASK, MT6328_PMIC_RG_CSDAC_STP_DEC_SHIFT},
	{PMIC_RG_CSDAC_DLY, MT6328_PMIC_RG_CSDAC_DLY_ADDR, MT6328_PMIC_RG_CSDAC_DLY_MASK,
	 MT6328_PMIC_RG_CSDAC_DLY_SHIFT},
	{PMIC_RG_CSDAC_STP, MT6328_PMIC_RG_CSDAC_STP_ADDR, MT6328_PMIC_RG_CSDAC_STP_MASK,
	 MT6328_PMIC_RG_CSDAC_STP_SHIFT},
	{PMIC_RG_LOW_ICH_DB, MT6328_PMIC_RG_LOW_ICH_DB_ADDR, MT6328_PMIC_RG_LOW_ICH_DB_MASK,
	 MT6328_PMIC_RG_LOW_ICH_DB_SHIFT},
	{PMIC_RG_CHRIND_ON, MT6328_PMIC_RG_CHRIND_ON_ADDR, MT6328_PMIC_RG_CHRIND_ON_MASK,
	 MT6328_PMIC_RG_CHRIND_ON_SHIFT},
	{PMIC_RG_CHRIND_DIMMING, MT6328_PMIC_RG_CHRIND_DIMMING_ADDR,
	 MT6328_PMIC_RG_CHRIND_DIMMING_MASK, MT6328_PMIC_RG_CHRIND_DIMMING_SHIFT},
	{PMIC_RG_CV_MODE, MT6328_PMIC_RG_CV_MODE_ADDR, MT6328_PMIC_RG_CV_MODE_MASK,
	 MT6328_PMIC_RG_CV_MODE_SHIFT},
	{PMIC_RG_VCDT_MODE, MT6328_PMIC_RG_VCDT_MODE_ADDR, MT6328_PMIC_RG_VCDT_MODE_MASK,
	 MT6328_PMIC_RG_VCDT_MODE_SHIFT},
	{PMIC_RG_CSDAC_MODE, MT6328_PMIC_RG_CSDAC_MODE_ADDR, MT6328_PMIC_RG_CSDAC_MODE_MASK,
	 MT6328_PMIC_RG_CSDAC_MODE_SHIFT},
	{PMIC_RG_TRACKING_EN, MT6328_PMIC_RG_TRACKING_EN_ADDR, MT6328_PMIC_RG_TRACKING_EN_MASK,
	 MT6328_PMIC_RG_TRACKING_EN_SHIFT},
	{PMIC_RG_HWCV_EN, MT6328_PMIC_RG_HWCV_EN_ADDR, MT6328_PMIC_RG_HWCV_EN_MASK,
	 MT6328_PMIC_RG_HWCV_EN_SHIFT},
	{PMIC_RG_ULC_DET_EN, MT6328_PMIC_RG_ULC_DET_EN_ADDR, MT6328_PMIC_RG_ULC_DET_EN_MASK,
	 MT6328_PMIC_RG_ULC_DET_EN_SHIFT},
	{PMIC_RG_BGR_TRIM_EN, MT6328_PMIC_RG_BGR_TRIM_EN_ADDR, MT6328_PMIC_RG_BGR_TRIM_EN_MASK,
	 MT6328_PMIC_RG_BGR_TRIM_EN_SHIFT},
	{PMIC_RG_ICHRG_TRIM, MT6328_PMIC_RG_ICHRG_TRIM_ADDR, MT6328_PMIC_RG_ICHRG_TRIM_MASK,
	 MT6328_PMIC_RG_ICHRG_TRIM_SHIFT},
	{PMIC_RG_BGR_TRIM, MT6328_PMIC_RG_BGR_TRIM_ADDR, MT6328_PMIC_RG_BGR_TRIM_MASK,
	 MT6328_PMIC_RG_BGR_TRIM_SHIFT},
	{PMIC_RG_OVP_TRIM, MT6328_PMIC_RG_OVP_TRIM_ADDR, MT6328_PMIC_RG_OVP_TRIM_MASK,
	 MT6328_PMIC_RG_OVP_TRIM_SHIFT},
	{PMIC_RG_CHR_OSC_TRIM, MT6328_PMIC_RG_CHR_OSC_TRIM_ADDR, MT6328_PMIC_RG_CHR_OSC_TRIM_MASK,
	 MT6328_PMIC_RG_CHR_OSC_TRIM_SHIFT},
	{PMIC_QI_BGR_EXT_BUF_EN, MT6328_PMIC_QI_BGR_EXT_BUF_EN_ADDR,
	 MT6328_PMIC_QI_BGR_EXT_BUF_EN_MASK, MT6328_PMIC_QI_BGR_EXT_BUF_EN_SHIFT},
	{PMIC_RG_BGR_TEST_EN, MT6328_PMIC_RG_BGR_TEST_EN_ADDR, MT6328_PMIC_RG_BGR_TEST_EN_MASK,
	 MT6328_PMIC_RG_BGR_TEST_EN_SHIFT},
	{PMIC_RG_BGR_TEST_RSTB, MT6328_PMIC_RG_BGR_TEST_RSTB_ADDR,
	 MT6328_PMIC_RG_BGR_TEST_RSTB_MASK, MT6328_PMIC_RG_BGR_TEST_RSTB_SHIFT},
	{PMIC_RG_DAC_USBDL_MAX, MT6328_PMIC_RG_DAC_USBDL_MAX_ADDR,
	 MT6328_PMIC_RG_DAC_USBDL_MAX_MASK, MT6328_PMIC_RG_DAC_USBDL_MAX_SHIFT},
	{PMIC_RG_CM_VDEC_TRIG, MT6328_PMIC_RG_CM_VDEC_TRIG_ADDR, MT6328_PMIC_RG_CM_VDEC_TRIG_MASK,
	 MT6328_PMIC_RG_CM_VDEC_TRIG_SHIFT},
	{PMIC_PCHR_CM_VDEC_STATUS, MT6328_PMIC_PCHR_CM_VDEC_STATUS_ADDR,
	 MT6328_PMIC_PCHR_CM_VDEC_STATUS_MASK, MT6328_PMIC_PCHR_CM_VDEC_STATUS_SHIFT},
	{PMIC_RG_CM_VINC_TRIG, MT6328_PMIC_RG_CM_VINC_TRIG_ADDR, MT6328_PMIC_RG_CM_VINC_TRIG_MASK,
	 MT6328_PMIC_RG_CM_VINC_TRIG_SHIFT},
	{PMIC_PCHR_CM_VINC_STATUS, MT6328_PMIC_PCHR_CM_VINC_STATUS_ADDR,
	 MT6328_PMIC_PCHR_CM_VINC_STATUS_MASK, MT6328_PMIC_PCHR_CM_VINC_STATUS_SHIFT},
	{PMIC_RG_CM_VDEC_HPRD1, MT6328_PMIC_RG_CM_VDEC_HPRD1_ADDR,
	 MT6328_PMIC_RG_CM_VDEC_HPRD1_MASK, MT6328_PMIC_RG_CM_VDEC_HPRD1_SHIFT},
	{PMIC_RG_CM_VDEC_HPRD2, MT6328_PMIC_RG_CM_VDEC_HPRD2_ADDR,
	 MT6328_PMIC_RG_CM_VDEC_HPRD2_MASK, MT6328_PMIC_RG_CM_VDEC_HPRD2_SHIFT},
	{PMIC_RG_CM_VDEC_HPRD3, MT6328_PMIC_RG_CM_VDEC_HPRD3_ADDR,
	 MT6328_PMIC_RG_CM_VDEC_HPRD3_MASK, MT6328_PMIC_RG_CM_VDEC_HPRD3_SHIFT},
	{PMIC_RG_CM_VDEC_HPRD4, MT6328_PMIC_RG_CM_VDEC_HPRD4_ADDR,
	 MT6328_PMIC_RG_CM_VDEC_HPRD4_MASK, MT6328_PMIC_RG_CM_VDEC_HPRD4_SHIFT},
	{PMIC_RG_CM_VDEC_HPRD5, MT6328_PMIC_RG_CM_VDEC_HPRD5_ADDR,
	 MT6328_PMIC_RG_CM_VDEC_HPRD5_MASK, MT6328_PMIC_RG_CM_VDEC_HPRD5_SHIFT},
	{PMIC_RG_CM_VDEC_HPRD6, MT6328_PMIC_RG_CM_VDEC_HPRD6_ADDR,
	 MT6328_PMIC_RG_CM_VDEC_HPRD6_MASK, MT6328_PMIC_RG_CM_VDEC_HPRD6_SHIFT},
	{PMIC_RG_CM_VINC_HPRD1, MT6328_PMIC_RG_CM_VINC_HPRD1_ADDR,
	 MT6328_PMIC_RG_CM_VINC_HPRD1_MASK, MT6328_PMIC_RG_CM_VINC_HPRD1_SHIFT},
	{PMIC_RG_CM_VINC_HPRD2, MT6328_PMIC_RG_CM_VINC_HPRD2_ADDR,
	 MT6328_PMIC_RG_CM_VINC_HPRD2_MASK, MT6328_PMIC_RG_CM_VINC_HPRD2_SHIFT},
	{PMIC_RG_CM_VINC_HPRD3, MT6328_PMIC_RG_CM_VINC_HPRD3_ADDR,
	 MT6328_PMIC_RG_CM_VINC_HPRD3_MASK, MT6328_PMIC_RG_CM_VINC_HPRD3_SHIFT},
	{PMIC_RG_CM_VINC_HPRD4, MT6328_PMIC_RG_CM_VINC_HPRD4_ADDR,
	 MT6328_PMIC_RG_CM_VINC_HPRD4_MASK, MT6328_PMIC_RG_CM_VINC_HPRD4_SHIFT},
	{PMIC_RG_CM_VINC_HPRD5, MT6328_PMIC_RG_CM_VINC_HPRD5_ADDR,
	 MT6328_PMIC_RG_CM_VINC_HPRD5_MASK, MT6328_PMIC_RG_CM_VINC_HPRD5_SHIFT},
	{PMIC_RG_CM_VINC_HPRD6, MT6328_PMIC_RG_CM_VINC_HPRD6_ADDR,
	 MT6328_PMIC_RG_CM_VINC_HPRD6_MASK, MT6328_PMIC_RG_CM_VINC_HPRD6_SHIFT},
	{PMIC_RG_CM_LPRD, MT6328_PMIC_RG_CM_LPRD_ADDR, MT6328_PMIC_RG_CM_LPRD_MASK,
	 MT6328_PMIC_RG_CM_LPRD_SHIFT},
	{PMIC_RG_CM_CS_VTHL, MT6328_PMIC_RG_CM_CS_VTHL_ADDR, MT6328_PMIC_RG_CM_CS_VTHL_MASK,
	 MT6328_PMIC_RG_CM_CS_VTHL_SHIFT},
	{PMIC_RG_CM_CS_VTHH, MT6328_PMIC_RG_CM_CS_VTHH_ADDR, MT6328_PMIC_RG_CM_CS_VTHH_MASK,
	 MT6328_PMIC_RG_CM_CS_VTHH_SHIFT},
	{PMIC_RGS_BATON_UNDET, MT6328_PMIC_RGS_BATON_UNDET_ADDR, MT6328_PMIC_RGS_BATON_UNDET_MASK,
	 MT6328_PMIC_RGS_BATON_UNDET_SHIFT},
	{PMIC_RG_PCHR_RSV, MT6328_PMIC_RG_PCHR_RSV_ADDR, MT6328_PMIC_RG_PCHR_RSV_MASK,
	 MT6328_PMIC_RG_PCHR_RSV_SHIFT},
	{PMIC_RG_ENVTEM_D, MT6328_PMIC_RG_ENVTEM_D_ADDR, MT6328_PMIC_RG_ENVTEM_D_MASK,
	 MT6328_PMIC_RG_ENVTEM_D_SHIFT},
	{PMIC_RG_ENVTEM_EN, MT6328_PMIC_RG_ENVTEM_EN_ADDR, MT6328_PMIC_RG_ENVTEM_EN_MASK,
	 MT6328_PMIC_RG_ENVTEM_EN_SHIFT},
	{PMIC_RG_BATON_HT_EN, MT6328_PMIC_RG_BATON_HT_EN_ADDR, MT6328_PMIC_RG_BATON_HT_EN_MASK,
	 MT6328_PMIC_RG_BATON_HT_EN_SHIFT},
	{PMIC_RG_BATON_HT_EN_DLY_TIME, MT6328_PMIC_RG_BATON_HT_EN_DLY_TIME_ADDR,
	 MT6328_PMIC_RG_BATON_HT_EN_DLY_TIME_MASK, MT6328_PMIC_RG_BATON_HT_EN_DLY_TIME_SHIFT},
	{PMIC_QI_BATON_HT_EN, MT6328_PMIC_QI_BATON_HT_EN_ADDR, MT6328_PMIC_QI_BATON_HT_EN_MASK,
	 MT6328_PMIC_QI_BATON_HT_EN_SHIFT},
	{PMIC_RGS_BATON_HV, MT6328_PMIC_RGS_BATON_HV_ADDR, MT6328_PMIC_RGS_BATON_HV_MASK,
	 MT6328_PMIC_RGS_BATON_HV_SHIFT},
	{PMIC_RG_HW_VTH_CTRL, MT6328_PMIC_RG_HW_VTH_CTRL_ADDR, MT6328_PMIC_RG_HW_VTH_CTRL_MASK,
	 MT6328_PMIC_RG_HW_VTH_CTRL_SHIFT},
	{PMIC_RG_HW_VTH2, MT6328_PMIC_RG_HW_VTH2_ADDR, MT6328_PMIC_RG_HW_VTH2_MASK,
	 MT6328_PMIC_RG_HW_VTH2_SHIFT},
	{PMIC_RG_HW_VTH1, MT6328_PMIC_RG_HW_VTH1_ADDR, MT6328_PMIC_RG_HW_VTH1_MASK,
	 MT6328_PMIC_RG_HW_VTH1_SHIFT},
	{PMIC_RG_CM_VDEC_INT_EN, MT6328_PMIC_RG_CM_VDEC_INT_EN_ADDR,
	 MT6328_PMIC_RG_CM_VDEC_INT_EN_MASK, MT6328_PMIC_RG_CM_VDEC_INT_EN_SHIFT},
	{PMIC_RG_CM_VINC_INT_EN, MT6328_PMIC_RG_CM_VINC_INT_EN_ADDR,
	 MT6328_PMIC_RG_CM_VINC_INT_EN_MASK, MT6328_PMIC_RG_CM_VINC_INT_EN_SHIFT},
	{PMIC_EOSC_CALI_START, MT6328_PMIC_EOSC_CALI_START_ADDR, MT6328_PMIC_EOSC_CALI_START_MASK,
	 MT6328_PMIC_EOSC_CALI_START_SHIFT},
	{PMIC_EOSC_CALI_TD, MT6328_PMIC_EOSC_CALI_TD_ADDR, MT6328_PMIC_EOSC_CALI_TD_MASK,
	 MT6328_PMIC_EOSC_CALI_TD_SHIFT},
	{PMIC_EOSC_CALI_TEST, MT6328_PMIC_EOSC_CALI_TEST_ADDR, MT6328_PMIC_EOSC_CALI_TEST_MASK,
	 MT6328_PMIC_EOSC_CALI_TEST_SHIFT},
	{PMIC_FRC_VTCXO0_ON, MT6328_PMIC_FRC_VTCXO0_ON_ADDR, MT6328_PMIC_FRC_VTCXO0_ON_MASK,
	 MT6328_PMIC_FRC_VTCXO0_ON_SHIFT},
	{PMIC_EOSC_CALI_RSV, MT6328_PMIC_EOSC_CALI_RSV_ADDR, MT6328_PMIC_EOSC_CALI_RSV_MASK,
	 MT6328_PMIC_EOSC_CALI_RSV_SHIFT},
	{PMIC_VRTC_PWM_MODE, MT6328_PMIC_VRTC_PWM_MODE_ADDR, MT6328_PMIC_VRTC_PWM_MODE_MASK,
	 MT6328_PMIC_VRTC_PWM_MODE_SHIFT},
	{PMIC_VRTC_PWM_RSV, MT6328_PMIC_VRTC_PWM_RSV_ADDR, MT6328_PMIC_VRTC_PWM_RSV_MASK,
	 MT6328_PMIC_VRTC_PWM_RSV_SHIFT},
	{PMIC_VRTC_PWM_L_DUTY, MT6328_PMIC_VRTC_PWM_L_DUTY_ADDR, MT6328_PMIC_VRTC_PWM_L_DUTY_MASK,
	 MT6328_PMIC_VRTC_PWM_L_DUTY_SHIFT},
	{PMIC_VRTC_PWM_H_DUTY, MT6328_PMIC_VRTC_PWM_H_DUTY_ADDR, MT6328_PMIC_VRTC_PWM_H_DUTY_MASK,
	 MT6328_PMIC_VRTC_PWM_H_DUTY_SHIFT},
	{PMIC_VRTC_CAP_SEL, MT6328_PMIC_VRTC_CAP_SEL_ADDR, MT6328_PMIC_VRTC_CAP_SEL_MASK,
	 MT6328_PMIC_VRTC_CAP_SEL_SHIFT},

};


unsigned short mt6328_set_register_value(PMU_FLAGS_LIST_ENUM flagname, unsigned int val)
{
	const PMU_FLAG_TABLE_ENTRY *pFlag = &pmu_flags_table[flagname];
	unsigned int ret = 0;


	if (pFlag->flagname != flagname) {
		pr_notice("[pmu_set_register_value]pmic flag idx error\n");
		return 1;
	}

	ret = pmic_config_interface((pFlag->offset),
				    (unsigned int) (val),
				    (unsigned int) (pFlag->mask), (unsigned int) (pFlag->shift)
	    );

	return 0;
}


unsigned short mt6328_get_register_value(PMU_FLAGS_LIST_ENUM flagname)
{
	const PMU_FLAG_TABLE_ENTRY *pFlag = &pmu_flags_table[flagname];
	unsigned int val;
	unsigned int ret;

	ret =
	    pmic_read_interface((unsigned int) pFlag->offset, &val, (unsigned int) (pFlag->mask),
				(unsigned int) (pFlag->shift));

	return val;
}


unsigned short pmic_set_register_value(PMU_FLAGS_LIST_ENUM flagname, unsigned int val)
{
	return mt6328_set_register_value(flagname, val);
}


unsigned short pmic_get_register_value(PMU_FLAGS_LIST_ENUM flagname)
{
	return mt6328_get_register_value(flagname);
}



unsigned short bc11_set_register_value(PMU_FLAGS_LIST_ENUM flagname, unsigned int val)
{
	return mt6328_set_register_value(flagname, val);
}


unsigned short bc11_get_register_value(PMU_FLAGS_LIST_ENUM flagname)
{
	return mt6328_get_register_value(flagname);
}
