#ifndef __PMIC_WRAP_REGS_2_H__
#define __PMIC_WRAP_REGS_2_H__


#define PMIC_WRAP_MUX_SEL               ((unsigned int *)(PMIC_WRAP_BASE+0x0))
#define PMIC_WRAP_WRAP_EN               ((unsigned int *)(PMIC_WRAP_BASE+0x4))
#define PMIC_WRAP_DIO_EN                ((unsigned int *)(PMIC_WRAP_BASE+0x8))
#define PMIC_WRAP_SIDLY                 ((unsigned int *)(PMIC_WRAP_BASE+0xC))
#define PMIC_WRAP_RDDMY                 ((unsigned int *)(PMIC_WRAP_BASE+0x10))
#define PMIC_WRAP_SI_CK_CON             ((unsigned int *)(PMIC_WRAP_BASE+0x14))
#define PMIC_WRAP_CSHEXT_WRITE          ((unsigned int *)(PMIC_WRAP_BASE+0x18))
#define PMIC_WRAP_CSHEXT_READ           ((unsigned int *)(PMIC_WRAP_BASE+0x1C))
#define PMIC_WRAP_CSLEXT_START          ((unsigned int *)(PMIC_WRAP_BASE+0x20))
#define PMIC_WRAP_CSLEXT_END            ((unsigned int *)(PMIC_WRAP_BASE+0x24))
#define PMIC_WRAP_STAUPD_PRD            ((unsigned int *)(PMIC_WRAP_BASE+0x28))
#define PMIC_WRAP_STAUPD_GRPEN          ((unsigned int *)(PMIC_WRAP_BASE+0x2C))
#define PMIC_WRAP_EINT_STA0_ADR         ((unsigned int *)(PMIC_WRAP_BASE+0x30))
#define PMIC_WRAP_EINT_STA1_ADR         ((unsigned int *)(PMIC_WRAP_BASE+0x34))
#define PMIC_WRAP_EINT_STA              ((unsigned int *)(PMIC_WRAP_BASE+0x38))
#define PMIC_WRAP_EINT_CLR              ((unsigned int *)(PMIC_WRAP_BASE+0x3C))
#define PMIC_WRAP_STAUPD_MAN_TRIG       ((unsigned int *)(PMIC_WRAP_BASE+0x40))
#define PMIC_WRAP_STAUPD_STA            ((unsigned int *)(PMIC_WRAP_BASE+0x44))
#define PMIC_WRAP_WRAP_STA              ((unsigned int *)(PMIC_WRAP_BASE+0x48))
#define PMIC_WRAP_HARB_INIT             ((unsigned int *)(PMIC_WRAP_BASE+0x4C))
#define PMIC_WRAP_HARB_HPRIO            ((unsigned int *)(PMIC_WRAP_BASE+0x50))
#define PMIC_WRAP_HIPRIO_ARB_EN         ((unsigned int *)(PMIC_WRAP_BASE+0x54))
#define PMIC_WRAP_HARB_STA0             ((unsigned int *)(PMIC_WRAP_BASE+0x58))
#define PMIC_WRAP_HARB_STA1             ((unsigned int *)(PMIC_WRAP_BASE+0x5C))
#define PMIC_WRAP_MAN_EN                ((unsigned int *)(PMIC_WRAP_BASE+0x60))
#define PMIC_WRAP_MAN_CMD               ((unsigned int *)(PMIC_WRAP_BASE+0x64))
#define PMIC_WRAP_MAN_RDATA             ((unsigned int *)(PMIC_WRAP_BASE+0x68))
#define PMIC_WRAP_MAN_VLDCLR            ((unsigned int *)(PMIC_WRAP_BASE+0x6C))
#define PMIC_WRAP_WACS0_EN              ((unsigned int *)(PMIC_WRAP_BASE+0x70))
#define PMIC_WRAP_INIT_DONE0            ((unsigned int *)(PMIC_WRAP_BASE+0x74))
#define PMIC_WRAP_WACS0_CMD             ((unsigned int *)(PMIC_WRAP_BASE+0x78))
#define PMIC_WRAP_WACS0_RDATA           ((unsigned int *)(PMIC_WRAP_BASE+0x7C))
#define PMIC_WRAP_WACS0_VLDCLR          ((unsigned int *)(PMIC_WRAP_BASE+0x80))
#define PMIC_WRAP_WACS1_EN              ((unsigned int *)(PMIC_WRAP_BASE+0x84))
#define PMIC_WRAP_INIT_DONE1            ((unsigned int *)(PMIC_WRAP_BASE+0x88))
#define PMIC_WRAP_WACS1_CMD             ((unsigned int *)(PMIC_WRAP_BASE+0x8C))
#define PMIC_WRAP_WACS1_RDATA           ((unsigned int *)(PMIC_WRAP_BASE+0x90))
#define PMIC_WRAP_WACS1_VLDCLR          ((unsigned int *)(PMIC_WRAP_BASE+0x94))
#define PMIC_WRAP_WACS2_EN              ((unsigned int *)(PMIC_WRAP_BASE+0x98))
#define PMIC_WRAP_INIT_DONE2            ((unsigned int *)(PMIC_WRAP_BASE+0x9C))
#define PMIC_WRAP_WACS2_CMD             ((unsigned int *)(PMIC_WRAP_BASE+0xA0))
#define PMIC_WRAP_WACS2_RDATA           ((unsigned int *)(PMIC_WRAP_BASE+0xA4))
#define PMIC_WRAP_WACS2_VLDCLR          ((unsigned int *)(PMIC_WRAP_BASE+0xA8))
#define PMIC_WRAP_INT_EN                ((unsigned int *)(PMIC_WRAP_BASE+0xAC))
#define PMIC_WRAP_INT_FLG_RAW           ((unsigned int *)(PMIC_WRAP_BASE+0xB0))
#define PMIC_WRAP_INT_FLG               ((unsigned int *)(PMIC_WRAP_BASE+0xB4))
#define PMIC_WRAP_INT_CLR               ((unsigned int *)(PMIC_WRAP_BASE+0xB8))
#define PMIC_WRAP_SIG_ADR               ((unsigned int *)(PMIC_WRAP_BASE+0xBC))
#define PMIC_WRAP_SIG_MODE              ((unsigned int *)(PMIC_WRAP_BASE+0xC0))
#define PMIC_WRAP_SIG_VALUE             ((unsigned int *)(PMIC_WRAP_BASE+0xC4))
#define PMIC_WRAP_SIG_ERRVAL            ((unsigned int *)(PMIC_WRAP_BASE+0xC8))
#define PMIC_WRAP_CRC_EN                ((unsigned int *)(PMIC_WRAP_BASE+0xCC))
#define PMIC_WRAP_TIMER_EN              ((unsigned int *)(PMIC_WRAP_BASE+0xD0))
#define PMIC_WRAP_TIMER_STA             ((unsigned int *)(PMIC_WRAP_BASE+0xD4))
#define PMIC_WRAP_WDT_UNIT              ((unsigned int *)(PMIC_WRAP_BASE+0xD8))
#define PMIC_WRAP_WDT_SRC_EN            ((unsigned int *)(PMIC_WRAP_BASE+0xDC))
#define PMIC_WRAP_WDT_FLG               ((unsigned int *)(PMIC_WRAP_BASE+0xE0))
#define PMIC_WRAP_DEBUG_INT_SEL         ((unsigned int *)(PMIC_WRAP_BASE+0xE4))
#define PMIC_WRAP_DVFS_ADR0             ((unsigned int *)(PMIC_WRAP_BASE+0xE8))
#define PMIC_WRAP_DVFS_WDATA0           ((unsigned int *)(PMIC_WRAP_BASE+0xEC))
#define PMIC_WRAP_DVFS_ADR1             ((unsigned int *)(PMIC_WRAP_BASE+0xF0))
#define PMIC_WRAP_DVFS_WDATA1           ((unsigned int *)(PMIC_WRAP_BASE+0xF4))
#define PMIC_WRAP_DVFS_ADR2             ((unsigned int *)(PMIC_WRAP_BASE+0xF8))
#define PMIC_WRAP_DVFS_WDATA2           ((unsigned int *)(PMIC_WRAP_BASE+0xFC))
#define PMIC_WRAP_DVFS_ADR3             ((unsigned int *)(PMIC_WRAP_BASE+0x100))
#define PMIC_WRAP_DVFS_WDATA3           ((unsigned int *)(PMIC_WRAP_BASE+0x104))
#define PMIC_WRAP_DVFS_ADR4             ((unsigned int *)(PMIC_WRAP_BASE+0x108))
#define PMIC_WRAP_DVFS_WDATA4           ((unsigned int *)(PMIC_WRAP_BASE+0x10C))
#define PMIC_WRAP_DVFS_ADR5             ((unsigned int *)(PMIC_WRAP_BASE+0x110))
#define PMIC_WRAP_DVFS_WDATA5           ((unsigned int *)(PMIC_WRAP_BASE+0x114))
#define PMIC_WRAP_DVFS_ADR6             ((unsigned int *)(PMIC_WRAP_BASE+0x118))
#define PMIC_WRAP_DVFS_WDATA6           ((unsigned int *)(PMIC_WRAP_BASE+0x11C))
#define PMIC_WRAP_DVFS_ADR7             ((unsigned int *)(PMIC_WRAP_BASE+0x120))
#define PMIC_WRAP_DVFS_WDATA7           ((unsigned int *)(PMIC_WRAP_BASE+0x124))
#define PMIC_WRAP_DVFS_ADR8             ((unsigned int *)(PMIC_WRAP_BASE+0x128))
#define PMIC_WRAP_DVFS_WDATA8           ((unsigned int *)(PMIC_WRAP_BASE+0x12C))
#define PMIC_WRAP_DVFS_ADR9             ((unsigned int *)(PMIC_WRAP_BASE+0x130))
#define PMIC_WRAP_DVFS_WDATA9           ((unsigned int *)(PMIC_WRAP_BASE+0x134))
#define PMIC_WRAP_DVFS_ADR10            ((unsigned int *)(PMIC_WRAP_BASE+0x138))
#define PMIC_WRAP_DVFS_WDATA10          ((unsigned int *)(PMIC_WRAP_BASE+0x13C))
#define PMIC_WRAP_DVFS_ADR11            ((unsigned int *)(PMIC_WRAP_BASE+0x140))
#define PMIC_WRAP_DVFS_WDATA11          ((unsigned int *)(PMIC_WRAP_BASE+0x144))
#define PMIC_WRAP_DVFS_ADR12            ((unsigned int *)(PMIC_WRAP_BASE+0x148))
#define PMIC_WRAP_DVFS_WDATA12          ((unsigned int *)(PMIC_WRAP_BASE+0x14C))
#define PMIC_WRAP_DVFS_ADR13            ((unsigned int *)(PMIC_WRAP_BASE+0x150))
#define PMIC_WRAP_DVFS_WDATA13          ((unsigned int *)(PMIC_WRAP_BASE+0x154))
#define PMIC_WRAP_DVFS_ADR14            ((unsigned int *)(PMIC_WRAP_BASE+0x158))
#define PMIC_WRAP_DVFS_WDATA14          ((unsigned int *)(PMIC_WRAP_BASE+0x15C))
#define PMIC_WRAP_DVFS_ADR15            ((unsigned int *)(PMIC_WRAP_BASE+0x160))
#define PMIC_WRAP_DVFS_WDATA15          ((unsigned int *)(PMIC_WRAP_BASE+0x164))
#define PMIC_WRAP_SPMINF_STA            ((unsigned int *)(PMIC_WRAP_BASE+0x168))
#define PMIC_WRAP_CIPHER_KEY_SEL        ((unsigned int *)(PMIC_WRAP_BASE+0x16C))
#define PMIC_WRAP_CIPHER_IV_SEL         ((unsigned int *)(PMIC_WRAP_BASE+0x170))
#define PMIC_WRAP_CIPHER_EN             ((unsigned int *)(PMIC_WRAP_BASE+0x174))
#define PMIC_WRAP_CIPHER_RDY            ((unsigned int *)(PMIC_WRAP_BASE+0x178))
#define PMIC_WRAP_CIPHER_MODE           ((unsigned int *)(PMIC_WRAP_BASE+0x17C))
#define PMIC_WRAP_CIPHER_SWRST          ((unsigned int *)(PMIC_WRAP_BASE+0x180))
#define PMIC_WRAP_DCM_EN                ((unsigned int *)(PMIC_WRAP_BASE+0x184))
#define PMIC_WRAP_DCM_DBC_PRD           ((unsigned int *)(PMIC_WRAP_BASE+0x188))
#define PMIC_WRAP_EXT_CK                ((unsigned int *)(PMIC_WRAP_BASE+0x18C))
#define PMIC_WRAP_ADC_CMD_ADDR          ((unsigned int *)(PMIC_WRAP_BASE+0x190))
#define PMIC_WRAP_PWRAP_ADC_CMD         ((unsigned int *)(PMIC_WRAP_BASE+0x194))
#define PMIC_WRAP_ADC_RDATA_ADDR        ((unsigned int *)(PMIC_WRAP_BASE+0x198))
#define PMIC_WRAP_GPS_STA               ((unsigned int *)(PMIC_WRAP_BASE+0x19C))
#define PMIC_WRAP_SWRST                 ((unsigned int *)(PMIC_WRAP_BASE+0x1A0))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR_LATEST  ((unsigned int *)(PMIC_WRAP_BASE+0x1A4))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR_WP  ((unsigned int *)(PMIC_WRAP_BASE+0x1A8))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR0    ((unsigned int *)(PMIC_WRAP_BASE+0x1AC))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR1    ((unsigned int *)(PMIC_WRAP_BASE+0x1B0))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR2    ((unsigned int *)(PMIC_WRAP_BASE+0x1B4))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR3    ((unsigned int *)(PMIC_WRAP_BASE+0x1B8))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR4    ((unsigned int *)(PMIC_WRAP_BASE+0x1BC))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR5    ((unsigned int *)(PMIC_WRAP_BASE+0x1C0))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR6    ((unsigned int *)(PMIC_WRAP_BASE+0x1C4))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR7    ((unsigned int *)(PMIC_WRAP_BASE+0x1C8))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR8    ((unsigned int *)(PMIC_WRAP_BASE+0x1CC))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR9    ((unsigned int *)(PMIC_WRAP_BASE+0x1D0))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR10   ((unsigned int *)(PMIC_WRAP_BASE+0x1D4))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR11   ((unsigned int *)(PMIC_WRAP_BASE+0x1D8))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR12   ((unsigned int *)(PMIC_WRAP_BASE+0x1DC))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR13   ((unsigned int *)(PMIC_WRAP_BASE+0x1E0))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR14   ((unsigned int *)(PMIC_WRAP_BASE+0x1E4))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR15   ((unsigned int *)(PMIC_WRAP_BASE+0x1E8))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR16   ((unsigned int *)(PMIC_WRAP_BASE+0x1EC))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR17   ((unsigned int *)(PMIC_WRAP_BASE+0x1F0))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR18   ((unsigned int *)(PMIC_WRAP_BASE+0x1F4))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR19   ((unsigned int *)(PMIC_WRAP_BASE+0x1F8))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR20   ((unsigned int *)(PMIC_WRAP_BASE+0x1FC))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR21   ((unsigned int *)(PMIC_WRAP_BASE+0x200))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR22   ((unsigned int *)(PMIC_WRAP_BASE+0x204))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR23   ((unsigned int *)(PMIC_WRAP_BASE+0x208))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR24   ((unsigned int *)(PMIC_WRAP_BASE+0x20C))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR25   ((unsigned int *)(PMIC_WRAP_BASE+0x210))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR26   ((unsigned int *)(PMIC_WRAP_BASE+0x214))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR27   ((unsigned int *)(PMIC_WRAP_BASE+0x218))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR28   ((unsigned int *)(PMIC_WRAP_BASE+0x21C))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR29   ((unsigned int *)(PMIC_WRAP_BASE+0x220))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR30   ((unsigned int *)(PMIC_WRAP_BASE+0x224))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR31   ((unsigned int *)(PMIC_WRAP_BASE+0x228))
#define PMIC_WRAP_MD_ADC_STA0           ((unsigned int *)(PMIC_WRAP_BASE+0x22C))
#define PMIC_WRAP_MD_ADC_STA1           ((unsigned int *)(PMIC_WRAP_BASE+0x230))
#define PMIC_WRAP_MD_ADC_STA2           ((unsigned int *)(PMIC_WRAP_BASE+0x234))



/*-----macro for wrapper  regsister------------------------*/
#define GET_STAUPD_DLE_CNT(x)        ((x>>0)  & 0x00000007)
#define GET_STAUPD_ALE_CNT(x)        ((x>>3)  & 0x00000007)
#define GET_STAUPD_FSM(x)            ((x>>6)  & 0x00000007)
#define GET_WRAP_CH_DLE_RESTCNT(x)   ((x>>0)  & 0x00000007)
#define GET_WRAP_CH_ALE_RESTCNT(x)   ((x>>3)  & 0x00000003)
#define GET_WRAP_AG_DLE_RESTCNT(x)   ((x>>5)  & 0x00000003)
#define GET_WRAP_CH_W(x)             ((x>>7)  & 0x00000001)
#define GET_WRAP_CH_REQ(x)           ((x>>8)  & 0x00000001)
#define GET_AG_WRAP_W(x)             ((x>>9)  & 0x00000001)
#define GET_AG_WRAP_REQ(x)           ((x>>10) & 0x00000001)
#define GET_WRAP_FSM(x)              ((x>>11) & 0x0000000f)
#define GET_HARB_WRAP_WDATA(x)       ((x>>0)  & 0x0000ffff)
#define GET_HARB_WRAP_ADR(x)         ((x>>16) & 0x00007fff)
#define GET_HARB_WRAP_REQ(x)         ((x>>31) & 0x00000001)
#define GET_HARB_DLE_EMPTY(x)        ((x>>0)  & 0x00000001)
#define GET_HARB_DLE_FULL(x)         ((x>>1)  & 0x00000001)
#define GET_HARB_VLD(x)              ((x>>2)  & 0x00000001)
#define GET_HARB_DLE_OWN(x)          ((x>>3)  & 0x00000007)
#define GET_HARB_OWN(x)              ((x>>6)  & 0x00000007)
#define GET_HARB_DLE_RESTCNT(x)      ((x>>9)  & 0x00000007)
#define GET_AG_HARB_REQ(x)           ((x>>12) & 0x000000ff)
#define GET_HARB_WRAP_W(x)           ((x>>20) & 0x00000001)
#define GET_HARB_WRAP_REQ0(x)        ((x>>21) & 0x00000001)
#define GET_SPI_WDATA(x)             ((x>>0)  & 0x000000ff)
#define GET_SPI_OP(x)                ((x>>8)  & 0x0000001f)
#define GET_SPI_W(x)                 ((x>>13) & 0x00000001)
#define GET_MAN_RDATA(x)             ((x>>0)  & 0x000000ff)
#define GET_MAN_FSM(x)               ((x>>8)  & 0x00000007)
#define GET_MAN_REQ(x)               ((x>>11) & 0x00000001)
#define GET_WACS0_WDATA(x)           ((x>>0)  & 0x0000ffff)
#define GET_WACS0_ADR(x)             ((x>>16) & 0x00007fff)
#define GET_WACS0_WRITE(x)           ((x>>31) & 0x00000001)
#define GET_WACS0_RDATA(x)           ((x>>0)  & 0x0000ffff)
#define GET_WACS0_FSM(x)             ((x>>16) & 0x00000007)
#define GET_WACS0_REQ(x)             ((x>>19) & 0x00000001)
#define GET_SYNC_IDLE0(x)            ((x>>20) & 0x00000001)
#define GET_INIT_DONE0(x)            ((x>>21) & 0x00000001)
#define GET_SYS_IDLE0(x)             ((x>>22) & 0x00000001)
#define GET_WACS0_FIFO_FILLCNT(x)    ((x>>24) & 0x0000000f)
#define GET_WACS0_FIFO_FREECNT(x)    ((x>>28) & 0x0000000f)
#define GET_WACS1_WDATA(x)           ((x>>0)  & 0x0000ffff)
#define GET_WACS1_ADR(x)             ((x>>16) & 0x00007fff)
#define GET_WACS1_WRITE(x)           ((x>>31) & 0x00000001)
#define GET_WACS1_RDATA(x)           ((x>>0)  & 0x0000ffff)
#define GET_WACS1_FSM(x)             ((x>>16) & 0x00000007)
#define GET_WACS1_REQ(x)             ((x>>19) & 0x00000001)
#define GET_SYNC_IDLE1(x)            ((x>>20) & 0x00000001)
#define GET_INIT_DONE1(x)            ((x>>21) & 0x00000001)
#define GET_SYS_IDLE1(x)             ((x>>22) & 0x00000001)
#define GET_WACS1_FIFO_FILLCNT(x)    ((x>>24) & 0x0000000f)
#define GET_WACS1_FIFO_FREECNT(x)    ((x>>28) & 0x0000000f)
#define GET_WACS2_WDATA(x)           ((x>>0)  & 0x0000ffff)
#define GET_WACS2_ADR(x)             ((x>>16) & 0x00007fff)
#define GET_WACS2_WRITE(x)           ((x>>31) & 0x00000001)
#define GET_WACS2_RDATA(x)           ((x>>0)  & 0x0000ffff)
#define GET_WACS2_FSM(x)             ((x>>16) & 0x00000007)
#define GET_WACS2_REQ(x)             ((x>>19) & 0x00000001)
#define GET_SYNC_IDLE2(x)            ((x>>20) & 0x00000001)
#define GET_INIT_DONE2(x)            ((x>>21) & 0x00000001)
#define GET_SYS_IDLE2(x)             ((x>>22) & 0x00000001)
#define GET_WACS2_FIFO_FILLCNT(x)    ((x>>24) & 0x0000000f)
#define GET_WACS2_FIFO_FREECNT(x)    ((x>>28) & 0x0000000f)
#define GET_PWRAP_GPS_ACK(x)         ((x>>0)  & 0x00000001)
#define GET_GPS_PWRAP_REQ(x)         ((x>>1)  & 0x00000001)
#define GET_GPSINF_DLE_CNT(x)        ((x>>4)  & 0x00000003)
#define GET_GPSINF_ALE_CNT(x)        ((x>>6)  & 0x00000003)
#define GET_GPS_INF_FSM(x)           ((x>>8)  & 0x00000007)
#define GET_PWRAP_GPS_WDATA(x)       ((x>>17) & 0x00007fff)
#define GET_PWRAP_MD_ADC_NORM_DATA(x)  ((x>>0)  & 0x0000ffff)
#define GET_PWRAP_MD_ADC_INIT_DATA(x)  ((x>>16) & 0x0000ffff)
#define GET_BUF_MD_ADC_RDATA(x)      ((x>>0)  & 0x0000ffff)
#define GET_MD_ADC_BUF_WDATA(x)      ((x>>16) & 0x0000ffff)

#endif

