#ifndef __PMIC_WRAP_REGS_H__
#define __PMIC_WRAP_REGS_H__
#ifndef CONFIG_OF
#include <mach/mt_reg_base.h>
#include <mach/mt_irq.h>
#endif

#include "mt-plat/sync_write.h"

#define PMIC_WRAP_DEBUG

#define PWRAPTAG                "[PWRAP] "
#ifdef PMIC_WRAP_DEBUG
#define PWRAPDEB(fmt, arg...)     printk(PWRAPTAG "cpuid=%d," fmt, raw_smp_processor_id(), ##arg)
  /* #define PWRAPLOG(fmt, arg...)   printk(PWRAPTAG fmt,##arg) */
#define PWRAPFUC(fmt, arg...)     printk(PWRAPTAG "cpuid=%d,%s\n", raw_smp_processor_id(), __func__)
  /* #define PWRAPFUC(fmt, arg...)   printk(PWRAPTAG "%s\n", __FUNCTION__) */
#endif
/* typedef unsigned int        u32; */
/* typedef signed int          s32; */
#define PWRAPLOG(fmt, arg...)   printk(PWRAPTAG fmt, ##arg)
#define PWRAPERR(fmt, arg...)   printk(PWRAPTAG "ERROR,line=%d " fmt, __LINE__, ##arg)
#define PWRAPREG(fmt, arg...)   printk(PWRAPTAG fmt, ##arg)

/************************ROME BringUp *********************/
/* #define PMIC_WRAP_NO_PMIC   ///TODO: Fix me //if BringUp doesn't had PMIC, need open this */
/**********************************************************/
#define SLV_6328
/* #define SLV_6332 */

#ifdef CONFIG_OF
extern void __iomem *pwrap_base;
#define PMIC_WRAP_BASE		(pwrap_base)
#define MT_PMIC_WRAP_IRQ_ID	(pwrap_irq)
#define INFRACFG_AO_REG_BASE	(infracfg_ao_base)
#define TOPCKGEN_BASE		(topckgen_base)

#else
#define PMIC_WRAP_BASE (PWRAP_BASE)	/* 0x1000D000 */
#define MT_PMIC_WRAP_IRQ_ID PMIC_WRAP_ERR_IRQ_BIT_ID
#define INFRACFG_AO_REG_BASE	(INFRACFG_AO_BASE)
#define TOPCKGEN_BASE		(CKSYS_BASE)
#endif

/* #define CKSYS_BASE              (INFRA_BASE) */

#define PMIC_WRAP_REG_RANGE   85.5
#define PMIC_WRAP_REG_MAX     0xF000F154

/* -------macro for timeout setting-------------------------------- */
/******************************************************************************
global variable and  sys interface
******************************************************************************/
#define TIMEOUT_RESET	    0x7D0	/* 2000us */
#define TIMEOUT_READ	    0x7D0	/* 2000us */
#define TIMEOUT_WAIT_IDLE	0x7D0	/* 2000us */

/* -------macro for spi clock config-------------------------------- */
#define CLK_CFG_4_CLR                       (TOPCKGEN_BASE+0x088)	/* 6582 */
#define CLK_CFG_5_CLR                       (TOPCKGEN_BASE+0x098)	/* 6593 */
#define CLK_SPI_CK_26M	0x70000

/* -------macro for spi clock config-------------------------------- */
/* #define CLK_CFG_8                       (AP_RGU_BASE+0x164) //6585 */
/* #define CLK_CFG_4                       (TOPRGU_BASE+0x150) //6582 */

/* #define PMIC_WRAP_RDDMY1                ((PMIC_WRAP_BASE+0x14)) */
/* #define PMIC_WRAP_SIG_ADR1              ((PMIC_WRAP_BASE+0xD0)) */
/* #define PMIC_WRAP_SIG_MODE1             ((PMIC_WRAP_BASE+0xD4)) */
/* #define PMIC_WRAP_SIG_VALUE1            ((PMIC_WRAP_BASE+0xD8)) */
/* #define PMIC_WRAP_SIG_ERRVAL1           ((PMIC_WRAP_BASE+0xDC)) */
/* #define PMIC_WRAP_PMIC_IRQ_ADR          ((PMIC_WRAP_BASE+0x13C)) */
/* #define PMIC_WRAP_PMIC_IRQ_MASK         ((PMIC_WRAP_BASE+0x140)) */
#if defined(CONFIG_ARCH_MT6735M)

#include "pwrap_hal_d2.h"

#else
#define PMIC_WRAP_MUX_SEL               ((unsigned int *)(PMIC_WRAP_BASE+0x0))
#define PMIC_WRAP_WRAP_EN               ((unsigned int *)(PMIC_WRAP_BASE+0x4))
#define PMIC_WRAP_DIO_EN                ((unsigned int *)(PMIC_WRAP_BASE+0x8))
#define PMIC_WRAP_SIDLY                 ((unsigned int *)(PMIC_WRAP_BASE+0xC))
#define PMIC_WRAP_RDDMY                 ((unsigned int *)(PMIC_WRAP_BASE+0x10))
#define PMIC_WRAP_SI_CK_CON             ((unsigned int *)(PMIC_WRAP_BASE+0x14))
#define PMIC_WRAP_CSHEXT_WRITE          ((unsigned int *)(PMIC_WRAP_BASE+0x18))
#define PMIC_WRAP_CSHEXT_READ           ((unsigned int *)(PMIC_WRAP_BASE+0x1C))
#define PMIC_WRAP_CSLEXT_START          ((unsigned int *)(PMIC_WRAP_BASE+0x20))
#define PMIC_WRAP_CSLEXT_END            ((unsigned int *)(PMIC_WRAP_BASE+0x24))
#define PMIC_WRAP_STAUPD_PRD            ((unsigned int *)(PMIC_WRAP_BASE+0x28))
#define PMIC_WRAP_STAUPD_GRPEN          ((unsigned int *)(PMIC_WRAP_BASE+0x2C))
#define PMIC_WRAP_EINT_STA0_ADR         ((unsigned int *)(PMIC_WRAP_BASE+0x30))
#define PMIC_WRAP_EINT_STA1_ADR         ((unsigned int *)(PMIC_WRAP_BASE+0x34))
#define PMIC_WRAP_EINT_STA              ((unsigned int *)(PMIC_WRAP_BASE+0x38))
#define PMIC_WRAP_EINT_CLR              ((unsigned int *)(PMIC_WRAP_BASE+0x3C))
#define PMIC_WRAP_STAUPD_MAN_TRIG       ((unsigned int *)(PMIC_WRAP_BASE+0x40))
#define PMIC_WRAP_STAUPD_STA            ((unsigned int *)(PMIC_WRAP_BASE+0x44))
#define PMIC_WRAP_WRAP_STA              ((unsigned int *)(PMIC_WRAP_BASE+0x48))
#define PMIC_WRAP_HARB_INIT             ((unsigned int *)(PMIC_WRAP_BASE+0x4C))
#define PMIC_WRAP_HARB_HPRIO            ((unsigned int *)(PMIC_WRAP_BASE+0x50))
#define PMIC_WRAP_HIPRIO_ARB_EN         ((unsigned int *)(PMIC_WRAP_BASE+0x54))
#define PMIC_WRAP_HARB_STA0             ((unsigned int *)(PMIC_WRAP_BASE+0x58))
#define PMIC_WRAP_HARB_STA1             ((unsigned int *)(PMIC_WRAP_BASE+0x5C))
#define PMIC_WRAP_MAN_EN                ((unsigned int *)(PMIC_WRAP_BASE+0x60))
#define PMIC_WRAP_MAN_CMD               ((unsigned int *)(PMIC_WRAP_BASE+0x64))
#define PMIC_WRAP_MAN_RDATA             ((unsigned int *)(PMIC_WRAP_BASE+0x68))
#define PMIC_WRAP_MAN_VLDCLR            ((unsigned int *)(PMIC_WRAP_BASE+0x6C))
#define PMIC_WRAP_WACS0_EN              ((unsigned int *)(PMIC_WRAP_BASE+0x70))
#define PMIC_WRAP_INIT_DONE0            ((unsigned int *)(PMIC_WRAP_BASE+0x74))
#define PMIC_WRAP_WACS0_CMD             ((unsigned int *)(PMIC_WRAP_BASE+0x78))
#define PMIC_WRAP_WACS0_RDATA           ((unsigned int *)(PMIC_WRAP_BASE+0x7C))
#define PMIC_WRAP_WACS0_VLDCLR          ((unsigned int *)(PMIC_WRAP_BASE+0x80))
#define PMIC_WRAP_WACS1_EN              ((unsigned int *)(PMIC_WRAP_BASE+0x84))
#define PMIC_WRAP_INIT_DONE1            ((unsigned int *)(PMIC_WRAP_BASE+0x88))
#define PMIC_WRAP_WACS1_CMD             ((unsigned int *)(PMIC_WRAP_BASE+0x8C))
#define PMIC_WRAP_WACS1_RDATA           ((unsigned int *)(PMIC_WRAP_BASE+0x90))
#define PMIC_WRAP_WACS1_VLDCLR          ((unsigned int *)(PMIC_WRAP_BASE+0x94))
#define PMIC_WRAP_WACS2_EN              ((unsigned int *)(PMIC_WRAP_BASE+0x98))
#define PMIC_WRAP_INIT_DONE2            ((unsigned int *)(PMIC_WRAP_BASE+0x9C))
#define PMIC_WRAP_WACS2_CMD             ((unsigned int *)(PMIC_WRAP_BASE+0xA0))
#define PMIC_WRAP_WACS2_RDATA           ((unsigned int *)(PMIC_WRAP_BASE+0xA4))
#define PMIC_WRAP_WACS2_VLDCLR          ((unsigned int *)(PMIC_WRAP_BASE+0xA8))
#define PMIC_WRAP_WACS3_EN              ((unsigned int *)(PMIC_WRAP_BASE+0xAC))
#define PMIC_WRAP_INIT_DONE3            ((unsigned int *)(PMIC_WRAP_BASE+0xB0))
#define PMIC_WRAP_WACS3_CMD             ((unsigned int *)(PMIC_WRAP_BASE+0xB4))
#define PMIC_WRAP_WACS3_RDATA           ((unsigned int *)(PMIC_WRAP_BASE+0xB8))
#define PMIC_WRAP_WACS3_VLDCLR          ((unsigned int *)(PMIC_WRAP_BASE+0xBC))
#define PMIC_WRAP_INT_EN                ((unsigned int *)(PMIC_WRAP_BASE+0xC0))
#define PMIC_WRAP_INT_FLG_RAW           ((unsigned int *)(PMIC_WRAP_BASE+0xC4))
#define PMIC_WRAP_INT_FLG               ((unsigned int *)(PMIC_WRAP_BASE+0xC8))
#define PMIC_WRAP_INT_CLR               ((unsigned int *)(PMIC_WRAP_BASE+0xCC))
#define PMIC_WRAP_SIG_ADR               ((unsigned int *)(PMIC_WRAP_BASE+0xD0))
#define PMIC_WRAP_SIG_MODE              ((unsigned int *)(PMIC_WRAP_BASE+0xD4))
#define PMIC_WRAP_SIG_VALUE             ((unsigned int *)(PMIC_WRAP_BASE+0xD8))
#define PMIC_WRAP_SIG_ERRVAL            ((unsigned int *)(PMIC_WRAP_BASE+0xDC))
#define PMIC_WRAP_CRC_EN                ((unsigned int *)(PMIC_WRAP_BASE+0xE0))
#define PMIC_WRAP_TIMER_EN              ((unsigned int *)(PMIC_WRAP_BASE+0xE4))
#define PMIC_WRAP_TIMER_STA             ((unsigned int *)(PMIC_WRAP_BASE+0xE8))
#define PMIC_WRAP_WDT_UNIT              ((unsigned int *)(PMIC_WRAP_BASE+0xEC))
#define PMIC_WRAP_WDT_SRC_EN            ((unsigned int *)(PMIC_WRAP_BASE+0xF0))
#define PMIC_WRAP_WDT_FLG               ((unsigned int *)(PMIC_WRAP_BASE+0xF4))
#define PMIC_WRAP_DEBUG_INT_SEL         ((unsigned int *)(PMIC_WRAP_BASE+0xF8))
#define PMIC_WRAP_DVFS_ADR0             ((unsigned int *)(PMIC_WRAP_BASE+0xFC))
#define PMIC_WRAP_DVFS_WDATA0           ((unsigned int *)(PMIC_WRAP_BASE+0x100))
#define PMIC_WRAP_DVFS_ADR1             ((unsigned int *)(PMIC_WRAP_BASE+0x104))
#define PMIC_WRAP_DVFS_WDATA1           ((unsigned int *)(PMIC_WRAP_BASE+0x108))
#define PMIC_WRAP_DVFS_ADR2             ((unsigned int *)(PMIC_WRAP_BASE+0x10C))
#define PMIC_WRAP_DVFS_WDATA2           ((unsigned int *)(PMIC_WRAP_BASE+0x110))
#define PMIC_WRAP_DVFS_ADR3             ((unsigned int *)(PMIC_WRAP_BASE+0x114))
#define PMIC_WRAP_DVFS_WDATA3           ((unsigned int *)(PMIC_WRAP_BASE+0x118))
#define PMIC_WRAP_DVFS_ADR4             ((unsigned int *)(PMIC_WRAP_BASE+0x11C))
#define PMIC_WRAP_DVFS_WDATA4           ((unsigned int *)(PMIC_WRAP_BASE+0x120))
#define PMIC_WRAP_DVFS_ADR5             ((unsigned int *)(PMIC_WRAP_BASE+0x124))
#define PMIC_WRAP_DVFS_WDATA5           ((unsigned int *)(PMIC_WRAP_BASE+0x128))
#define PMIC_WRAP_DVFS_ADR6             ((unsigned int *)(PMIC_WRAP_BASE+0x12C))
#define PMIC_WRAP_DVFS_WDATA6           ((unsigned int *)(PMIC_WRAP_BASE+0x130))
#define PMIC_WRAP_DVFS_ADR7             ((unsigned int *)(PMIC_WRAP_BASE+0x134))
#define PMIC_WRAP_DVFS_WDATA7           ((unsigned int *)(PMIC_WRAP_BASE+0x138))
#define PMIC_WRAP_DVFS_ADR8             ((unsigned int *)(PMIC_WRAP_BASE+0x13C))
#define PMIC_WRAP_DVFS_WDATA8           ((unsigned int *)(PMIC_WRAP_BASE+0x140))
#define PMIC_WRAP_DVFS_ADR9             ((unsigned int *)(PMIC_WRAP_BASE+0x144))
#define PMIC_WRAP_DVFS_WDATA9           ((unsigned int *)(PMIC_WRAP_BASE+0x148))
#define PMIC_WRAP_DVFS_ADR10            ((unsigned int *)(PMIC_WRAP_BASE+0x14C))
#define PMIC_WRAP_DVFS_WDATA10          ((unsigned int *)(PMIC_WRAP_BASE+0x150))
#define PMIC_WRAP_DVFS_ADR11            ((unsigned int *)(PMIC_WRAP_BASE+0x154))
#define PMIC_WRAP_DVFS_WDATA11          ((unsigned int *)(PMIC_WRAP_BASE+0x158))
#define PMIC_WRAP_DVFS_ADR12            ((unsigned int *)(PMIC_WRAP_BASE+0x15C))
#define PMIC_WRAP_DVFS_WDATA12          ((unsigned int *)(PMIC_WRAP_BASE+0x160))
#define PMIC_WRAP_DVFS_ADR13            ((unsigned int *)(PMIC_WRAP_BASE+0x164))
#define PMIC_WRAP_DVFS_WDATA13          ((unsigned int *)(PMIC_WRAP_BASE+0x168))
#define PMIC_WRAP_DVFS_ADR14            ((unsigned int *)(PMIC_WRAP_BASE+0x16C))
#define PMIC_WRAP_DVFS_WDATA14          ((unsigned int *)(PMIC_WRAP_BASE+0x170))
#define PMIC_WRAP_DVFS_ADR15            ((unsigned int *)(PMIC_WRAP_BASE+0x174))
#define PMIC_WRAP_DVFS_WDATA15          ((unsigned int *)(PMIC_WRAP_BASE+0x178))
#define PMIC_WRAP_SPMINF_STA            ((unsigned int *)(PMIC_WRAP_BASE+0x17C))
#define PMIC_WRAP_CIPHER_KEY_SEL        ((unsigned int *)(PMIC_WRAP_BASE+0x180))
#define PMIC_WRAP_CIPHER_IV_SEL         ((unsigned int *)(PMIC_WRAP_BASE+0x184))
#define PMIC_WRAP_CIPHER_EN             ((unsigned int *)(PMIC_WRAP_BASE+0x188))
#define PMIC_WRAP_CIPHER_RDY            ((unsigned int *)(PMIC_WRAP_BASE+0x18C))
#define PMIC_WRAP_CIPHER_MODE           ((unsigned int *)(PMIC_WRAP_BASE+0x190))
#define PMIC_WRAP_CIPHER_SWRST          ((unsigned int *)(PMIC_WRAP_BASE+0x194))
#define PMIC_WRAP_DCM_EN                ((unsigned int *)(PMIC_WRAP_BASE+0x198))
#define PMIC_WRAP_DCM_DBC_PRD           ((unsigned int *)(PMIC_WRAP_BASE+0x19C))
#define PMIC_WRAP_EXT_CK                ((unsigned int *)(PMIC_WRAP_BASE+0x1A0))
#define PMIC_WRAP_ADC_CMD_ADDR          ((unsigned int *)(PMIC_WRAP_BASE+0x1A4))
#define PMIC_WRAP_PWRAP_ADC_CMD         ((unsigned int *)(PMIC_WRAP_BASE+0x1A8))
#define PMIC_WRAP_ADC_RDATA_ADDR        ((unsigned int *)(PMIC_WRAP_BASE+0x1AC))
#define PMIC_WRAP_GPS_STA               ((unsigned int *)(PMIC_WRAP_BASE+0x1B0))
#define PMIC_WRAP_SWRST                 ((unsigned int *)(PMIC_WRAP_BASE+0x1B4))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR_LATEST  ((unsigned int *)(PMIC_WRAP_BASE+0x1B8))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR_WP  ((unsigned int *)(PMIC_WRAP_BASE+0x1BC))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR0    ((unsigned int *)(PMIC_WRAP_BASE+0x1C0))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR1    ((unsigned int *)(PMIC_WRAP_BASE+0x1C4))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR2    ((unsigned int *)(PMIC_WRAP_BASE+0x1C8))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR3    ((unsigned int *)(PMIC_WRAP_BASE+0x1CC))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR4    ((unsigned int *)(PMIC_WRAP_BASE+0x1D0))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR5    ((unsigned int *)(PMIC_WRAP_BASE+0x1D4))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR6    ((unsigned int *)(PMIC_WRAP_BASE+0x1D8))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR7    ((unsigned int *)(PMIC_WRAP_BASE+0x1DC))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR8    ((unsigned int *)(PMIC_WRAP_BASE+0x1E0))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR9    ((unsigned int *)(PMIC_WRAP_BASE+0x1E4))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR10   ((unsigned int *)(PMIC_WRAP_BASE+0x1E8))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR11   ((unsigned int *)(PMIC_WRAP_BASE+0x1EC))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR12   ((unsigned int *)(PMIC_WRAP_BASE+0x1F0))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR13   ((unsigned int *)(PMIC_WRAP_BASE+0x1F4))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR14   ((unsigned int *)(PMIC_WRAP_BASE+0x1F8))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR15   ((unsigned int *)(PMIC_WRAP_BASE+0x1FC))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR16   ((unsigned int *)(PMIC_WRAP_BASE+0x200))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR17   ((unsigned int *)(PMIC_WRAP_BASE+0x204))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR18   ((unsigned int *)(PMIC_WRAP_BASE+0x208))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR19   ((unsigned int *)(PMIC_WRAP_BASE+0x20C))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR20   ((unsigned int *)(PMIC_WRAP_BASE+0x210))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR21   ((unsigned int *)(PMIC_WRAP_BASE+0x214))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR22   ((unsigned int *)(PMIC_WRAP_BASE+0x218))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR23   ((unsigned int *)(PMIC_WRAP_BASE+0x21C))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR24   ((unsigned int *)(PMIC_WRAP_BASE+0x220))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR25   ((unsigned int *)(PMIC_WRAP_BASE+0x224))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR26   ((unsigned int *)(PMIC_WRAP_BASE+0x228))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR27   ((unsigned int *)(PMIC_WRAP_BASE+0x22C))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR28   ((unsigned int *)(PMIC_WRAP_BASE+0x230))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR29   ((unsigned int *)(PMIC_WRAP_BASE+0x234))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR30   ((unsigned int *)(PMIC_WRAP_BASE+0x238))
#define PMIC_WRAP_MD_ADC_RDATA_ADDR31   ((unsigned int *)(PMIC_WRAP_BASE+0x23C))
#define PMIC_WRAP_MD_ADC_STA0           ((unsigned int *)(PMIC_WRAP_BASE+0x240))
#define PMIC_WRAP_MD_ADC_STA1           ((unsigned int *)(PMIC_WRAP_BASE+0x244))
#define PMIC_WRAP_MD_ADC_STA2           ((unsigned int *)(PMIC_WRAP_BASE+0x248))



/* -----macro for wrapper  regsister-------------------------------------------------------- */
#define GET_STAUPD_DLE_CNT(x)        ((x>>0)  & 0x00000007)
#define GET_STAUPD_ALE_CNT(x)        ((x>>3)  & 0x00000007)
#define GET_STAUPD_FSM(x)            ((x>>6)  & 0x00000007)
#define GET_WRAP_CH_DLE_RESTCNT(x)   ((x>>0)  & 0x00000007)
#define GET_WRAP_CH_ALE_RESTCNT(x)   ((x>>3)  & 0x00000003)
#define GET_WRAP_AG_DLE_RESTCNT(x)   ((x>>5)  & 0x00000003)
#define GET_WRAP_CH_W(x)             ((x>>7)  & 0x00000001)
#define GET_WRAP_CH_REQ(x)           ((x>>8)  & 0x00000001)
#define GET_AG_WRAP_W(x)             ((x>>9)  & 0x00000001)
#define GET_AG_WRAP_REQ(x)           ((x>>10) & 0x00000001)
#define GET_WRAP_FSM(x)              ((x>>11) & 0x0000000f)
#define GET_HARB_WRAP_WDATA(x)       ((x>>0)  & 0x0000ffff)
#define GET_HARB_WRAP_ADR(x)         ((x>>16) & 0x00007fff)
#define GET_HARB_WRAP_REQ(x)         ((x>>31) & 0x00000001)
#define GET_HARB_DLE_EMPTY(x)        ((x>>0)  & 0x00000001)
#define GET_HARB_DLE_FULL(x)         ((x>>1)  & 0x00000001)
#define GET_HARB_VLD(x)              ((x>>2)  & 0x00000001)
#define GET_HARB_DLE_OWN(x)          ((x>>3)  & 0x0000000f)
#define GET_HARB_OWN(x)              ((x>>7)  & 0x0000000f)
#define GET_HARB_DLE_RESTCNT(x)      ((x>>11) & 0x0000000f)
#define GET_AG_HARB_REQ(x)           ((x>>15) & 0x000003ff)
#define GET_HARB_WRAP_W(x)           ((x>>25) & 0x00000001)
#define GET_HARB_WRAP_REQ0(x)        ((x>>26) & 0x00000001)
#define GET_SPI_WDATA(x)             ((x>>0)  & 0x000000ff)
#define GET_SPI_OP(x)                ((x>>8)  & 0x0000001f)
#define GET_SPI_W(x)                 ((x>>13) & 0x00000001)
#define GET_MAN_RDATA(x)             ((x>>0)  & 0x000000ff)
#define GET_MAN_FSM(x)               ((x>>8)  & 0x00000007)
#define GET_MAN_REQ(x)               ((x>>11) & 0x00000001)
#define GET_WACS0_WDATA(x)           ((x>>0)  & 0x0000ffff)
#define GET_WACS0_ADR(x)             ((x>>16) & 0x00007fff)
#define GET_WACS0_WRITE(x)           ((x>>31) & 0x00000001)
#define GET_WACS0_RDATA(x)           ((x>>0)  & 0x0000ffff)
#define GET_WACS0_FSM(x)             ((x>>16) & 0x00000007)
#define GET_WACS0_REQ(x)             ((x>>19) & 0x00000001)
#define GET_SYNC_IDLE0(x)            ((x>>20) & 0x00000001)
#define GET_INIT_DONE0(x)            ((x>>21) & 0x00000001)
#define GET_SYS_IDLE0(x)             ((x>>22) & 0x00000001)
#define GET_WACS0_FIFO_FILLCNT(x)    ((x>>24) & 0x0000000f)
#define GET_WACS0_FIFO_FREECNT(x)    ((x>>28) & 0x0000000f)
#define GET_WACS1_WDATA(x)           ((x>>0)  & 0x0000ffff)
#define GET_WACS1_ADR(x)             ((x>>16) & 0x00007fff)
#define GET_WACS1_WRITE(x)           ((x>>31) & 0x00000001)
#define GET_WACS1_RDATA(x)           ((x>>0)  & 0x0000ffff)
#define GET_WACS1_FSM(x)             ((x>>16) & 0x00000007)
#define GET_WACS1_REQ(x)             ((x>>19) & 0x00000001)
#define GET_SYNC_IDLE1(x)            ((x>>20) & 0x00000001)
#define GET_INIT_DONE1(x)            ((x>>21) & 0x00000001)
#define GET_SYS_IDLE1(x)             ((x>>22) & 0x00000001)
#define GET_WACS1_FIFO_FILLCNT(x)    ((x>>24) & 0x0000000f)
#define GET_WACS1_FIFO_FREECNT(x)    ((x>>28) & 0x0000000f)
#define GET_WACS2_WDATA(x)           ((x>>0)  & 0x0000ffff)
#define GET_WACS2_ADR(x)             ((x>>16) & 0x00007fff)
#define GET_WACS2_WRITE(x)           ((x>>31) & 0x00000001)
#define GET_WACS2_RDATA(x)           ((x>>0)  & 0x0000ffff)
#define GET_WACS2_FSM(x)             ((x>>16) & 0x00000007)
#define GET_WACS2_REQ(x)             ((x>>19) & 0x00000001)
#define GET_SYNC_IDLE2(x)            ((x>>20) & 0x00000001)
#define GET_INIT_DONE2(x)            ((x>>21) & 0x00000001)
#define GET_SYS_IDLE2(x)             ((x>>22) & 0x00000001)
#define GET_WACS2_FIFO_FILLCNT(x)    ((x>>24) & 0x0000000f)
#define GET_WACS2_FIFO_FREECNT(x)    ((x>>28) & 0x0000000f)
#define GET_WACS3_WDATA(x)           ((x>>0)  & 0x0000ffff)
#define GET_WACS3_ADR(x)             ((x>>16) & 0x00007fff)
#define GET_WACS3_WRITE(x)           ((x>>31) & 0x00000001)
#define GET_WACS3_RDATA(x)           ((x>>0)  & 0x0000ffff)
#define GET_WACS3_FSM(x)             ((x>>16) & 0x00000007)
#define GET_WACS3_REQ(x)             ((x>>19) & 0x00000001)
#define GET_SYNC_IDLE3(x)            ((x>>20) & 0x00000001)
#define GET_INIT_DONE3(x)            ((x>>21) & 0x00000001)
#define GET_SYS_IDLE3(x)             ((x>>22) & 0x00000001)
#define GET_WACS3_FIFO_FILLCNT(x)    ((x>>24) & 0x0000000f)
#define GET_WACS3_FIFO_FREECNT(x)    ((x>>28) & 0x0000000f)
#define GET_PWRAP_GPS_ACK(x)         ((x>>0)  & 0x00000001)
#define GET_GPS_PWRAP_REQ(x)         ((x>>1)  & 0x00000001)
#define GET_GPSINF_DLE_CNT(x)        ((x>>4)  & 0x00000003)
#define GET_GPSINF_ALE_CNT(x)        ((x>>6)  & 0x00000003)
#define GET_GPS_INF_FSM(x)           ((x>>8)  & 0x00000007)
#define GET_PWRAP_GPS_WDATA(x)       ((x>>17) & 0x00007fff)
#define GET_PWRAP_MD_ADC_NORM_DATA(x)  ((x>>0)  & 0x0000ffff)
#define GET_PWRAP_MD_ADC_INIT_DATA(x)  ((x>>16) & 0x0000ffff)
#define GET_BUF_MD_ADC_RDATA(x)      ((x>>0)  & 0x0000ffff)
#define GET_MD_ADC_BUF_WDATA(x)      ((x>>16) & 0x0000ffff)
#endif
/* Macros */
#define ENABLE	1
#define DISABLE 0
#define DISABLE_ALL 0

/* #define PWRAP_ENABLE_DCM              WRAP_WR32(PMIC_WRAP_DCM_EN, ENABLE) */
/* #define PWRAP_DISABLE_DCM             WRAP_WR32(PMIC_WRAP_DCM_EN, DISABLE) */
/* #define PWRAP_DISABLE_DCM_DBC_PRD     WRAP_WR32(PMIC_WRAP_DCM_DBC_PRD, DISABLE) */
/* #define PWRAP_SET_DCM_DBC_PRD(x)      WRAP_WR32(PMIC_WRAP_DCM_DBC_PRD, x) */
/*  */
/* #define PWRAP_ENABLE                  WRAP_WR32(PMIC_WRAP_WRAP_EN,ENABLE) //enable wrap */
/* #define PWRAP_DISABLE                 WRAP_WR32(PMIC_WRAP_WRAP_EN,DISABLE) //disable wrap */

/* HIPRIS_ARB */
#define MDINF		(1 << 0)
#define WACS0		(1 << 1)
#define WACS1		(1 << 2)
#if defined(CONFIG_ARCH_MT6735M)
#define WACS2		(1 << 4)
#else
#define WACS2		(1 << 5)
#endif
#define DVFSINF		(1 << 3)
#define STAUPD		(1 << 5)
#define GPSINF		(1 << 6)
/* #define PWRAP_HIPRIO_ARB_EN(x)        WRAP_WR32(PMIC_WRAP_HIPRIO_ARB_EN,x)//need read back reg */
/* #define PWRAP_ENABLE_WACS2            WRAP_WR32(PMIC_WRAP_WACS2_EN,ENABLE) */

/* MUX SEL */
#define	WRAPPER_MODE	0
#define	MANUAL_MODE		1

/* OP TYPE */
#define OP_TYPE_CK	0	/* for MT6323 */
#define OP_TYPE_CSL	1	/* for MT6320 */
#define MSB		1	/* for MT6323 */
#define LSB		0	/* for MT6320 */

/* SIG mode */
#define CHECK_CRC	0
#define CHECK_SIG	1



/* macro for staupd sta fsm */
#define STAUPD_FSM_IDLE               (0x00)
#define STAUPD_FSM_REQ                (0x02)
#define STAUPD_FSM_WFDLE              (0x04)	/* wait for dle,wait for read data done, */

/* macro for WRAP_STA  FSM */
/* #define WRAP_STA_FSM_IDLE               (0x00) */
/* #define WRAP_STA_IDLE               (0x00) */

/* macro for MAN_RDATA  FSM */
#define MAN_FSM_NO_REQ             (0x00)
#define MAN_FSM_IDLE               (0x00)
#define MAN_FSM_REQ                (0x02)
#define MAN_FSM_WFDLE              (0x04)	/* wait for dle,wait for read data done, */
#define MAN_FSM_WFVLDCLR           (0x06)

/* macro for WACS_FSM */
#define WACS_FSM_IDLE               (0x00)
#define WACS_FSM_REQ                (0x02)
#define WACS_FSM_WFDLE              (0x04)	/* wait for dle,wait for read data done, */
#define WACS_FSM_WFVLDCLR           (0x06)	/* finish read data , wait for valid flag clearing */
#define WACS_INIT_DONE              (0x01)
#define WACS_SYNC_IDLE              (0x01)
#define WACS_SYNC_BUSY              (0x00)



/* -----macro for  regsister@PMIC ------------------------------------------------- */
#define SWCHR_REG_BASE (0x8000)

#define MT6332_DEW_DIO_EN         ((SWCHR_REG_BASE+0x00F6))
#define MT6332_DEW_READ_TEST      ((SWCHR_REG_BASE+0x00F8))
#define MT6332_DEW_WRITE_TEST     ((SWCHR_REG_BASE+0x00FA))
#define MT6332_DEW_CRC_SWRST      ((SWCHR_REG_BASE+0x00FC))
#define MT6332_DEW_CRC_EN         ((SWCHR_REG_BASE+0x00FE))
#define MT6332_DEW_CRC_VAL        ((SWCHR_REG_BASE+0x0100))
#define MT6332_DEW_DBG_MON_SEL    ((SWCHR_REG_BASE+0x0102))
#define MT6332_DEW_CIPHER_KEY_SEL ((SWCHR_REG_BASE+0x0104))
#define MT6332_DEW_CIPHER_IV_SEL  ((SWCHR_REG_BASE+0x0106))
#define MT6332_DEW_CIPHER_EN      ((SWCHR_REG_BASE+0x0108))
#define MT6332_DEW_CIPHER_RDY     ((SWCHR_REG_BASE+0x010A))
#define MT6332_DEW_CIPHER_MODE    ((SWCHR_REG_BASE+0x010C))
#define MT6332_DEW_CIPHER_SWRST   ((SWCHR_REG_BASE+0x010E))
#define MT6332_DEW_RDDMY_NO       ((SWCHR_REG_BASE+0x0110))

/*
#define MT6328_PMIC_REG_BASE (0x0000)

#define MT6328_DEW_DIO_EN            ((unsigned int)(MT6328_PMIC_REG_BASE+0x02D4))
#define MT6328_DEW_READ_TEST         ((unsigned int)(MT6328_PMIC_REG_BASE+0x02D6))
#define MT6328_DEW_WRITE_TEST        ((unsigned int)(MT6328_PMIC_REG_BASE+0x02D8))
#define MT6328_DEW_CRC_SWRST         ((unsigned int)(MT6328_PMIC_REG_BASE+0x02DA))
#define MT6328_DEW_CRC_EN            ((unsigned int)(MT6328_PMIC_REG_BASE+0x02DC))
#define MT6328_DEW_CRC_VAL           ((unsigned int)(MT6328_PMIC_REG_BASE+0x02DE))
#define MT6328_DEW_DBG_MON_SEL       ((unsigned int)(MT6328_PMIC_REG_BASE+0x02E0))
#define MT6328_DEW_CIPHER_KEY_SEL    ((unsigned int)(MT6328_PMIC_REG_BASE+0x02E2))
#define MT6328_DEW_CIPHER_IV_SEL     ((unsigned int)(MT6328_PMIC_REG_BASE+0x02E4))
#define MT6328_DEW_CIPHER_EN         ((unsigned int)(MT6328_PMIC_REG_BASE+0x02E6))
#define MT6328_DEW_CIPHER_RDY        ((unsigned int)(MT6328_PMIC_REG_BASE+0x02E8))
#define MT6328_DEW_CIPHER_MODE       ((unsigned int)(MT6328_PMIC_REG_BASE+0x02EA))
#define MT6328_DEW_CIPHER_SWRST      ((unsigned int)(MT6328_PMIC_REG_BASE+0x02EC))
#define MT6328_DEW_RDDMY_NO          ((unsigned int)(MT6328_PMIC_REG_BASE+0x02EE))
*/

#define MT6328_PMIC_REG_BASE (0x0000)

#define MT6328_STRUP_CON0            ((unsigned int)(MT6328_PMIC_REG_BASE+0x0000))
#define MT6328_STRUP_CON2            ((unsigned int)(MT6328_PMIC_REG_BASE+0x0002))
#define MT6328_STRUP_CON3            ((unsigned int)(MT6328_PMIC_REG_BASE+0x0004))
#define MT6328_STRUP_CON4            ((unsigned int)(MT6328_PMIC_REG_BASE+0x0006))
#define MT6328_STRUP_CON5            ((unsigned int)(MT6328_PMIC_REG_BASE+0x0008))
#define MT6328_STRUP_CON6            ((unsigned int)(MT6328_PMIC_REG_BASE+0x000A))
#define MT6328_STRUP_CON7            ((unsigned int)(MT6328_PMIC_REG_BASE+0x000C))
#define MT6328_STRUP_CON8            ((unsigned int)(MT6328_PMIC_REG_BASE+0x000E))
#define MT6328_STRUP_CON9            ((unsigned int)(MT6328_PMIC_REG_BASE+0x0010))
#define MT6328_STRUP_CON10           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0012))
#define MT6328_STRUP_CON11           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0014))
#define MT6328_STRUP_CON12           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0016))
#define MT6328_STRUP_CON13           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0018))
#define MT6328_STRUP_CON14           ((unsigned int)(MT6328_PMIC_REG_BASE+0x001A))
#define MT6328_STRUP_CON15           ((unsigned int)(MT6328_PMIC_REG_BASE+0x001C))
#define MT6328_STRUP_CON16           ((unsigned int)(MT6328_PMIC_REG_BASE+0x001E))
#define MT6328_STRUP_CON17           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0020))
#define MT6328_STRUP_CON18           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0022))
#define MT6328_STRUP_CON19           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0024))
#define MT6328_STRUP_CON20           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0026))
#define MT6328_STRUP_CON21           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0028))
#define MT6328_STRUP_CON22           ((unsigned int)(MT6328_PMIC_REG_BASE+0x002A))
#define MT6328_STRUP_CON23           ((unsigned int)(MT6328_PMIC_REG_BASE+0x002C))
#define MT6328_STRUP_CON24           ((unsigned int)(MT6328_PMIC_REG_BASE+0x002E))
#define MT6328_STRUP_CON25           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0030))
#define MT6328_STRUP_CON26           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0032))
#define MT6328_STRUP_CON27           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0034))
#define MT6328_STRUP_CON28           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0036))
#define MT6328_STRUP_CON29           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0038))
#define MT6328_STRUP_CON30           ((unsigned int)(MT6328_PMIC_REG_BASE+0x003A))
#define MT6328_STRUP_CON31           ((unsigned int)(MT6328_PMIC_REG_BASE+0x003C))
#define MT6328_STRUP_CON32           ((unsigned int)(MT6328_PMIC_REG_BASE+0x003E))
#define MT6328_STRUP_ANA_CON0        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0040))
#define MT6328_HWCID                 ((unsigned int)(MT6328_PMIC_REG_BASE+0x0200))
#define MT6328_SWCID                 ((unsigned int)(MT6328_PMIC_REG_BASE+0x0202))
#define MT6328_TOP_CON               ((unsigned int)(MT6328_PMIC_REG_BASE+0x0204))
#define MT6328_TEST_OUT              ((unsigned int)(MT6328_PMIC_REG_BASE+0x0206))
#define MT6328_TEST_CON0             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0208))
#define MT6328_TEST_CON1             ((unsigned int)(MT6328_PMIC_REG_BASE+0x020A))
#define MT6328_TESTMODE_SW           ((unsigned int)(MT6328_PMIC_REG_BASE+0x020C))
#define MT6328_EN_STATUS0            ((unsigned int)(MT6328_PMIC_REG_BASE+0x020E))
#define MT6328_EN_STATUS1            ((unsigned int)(MT6328_PMIC_REG_BASE+0x0210))
#define MT6328_EN_STATUS2            ((unsigned int)(MT6328_PMIC_REG_BASE+0x0212))
#define MT6328_OCSTATUS0             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0214))
#define MT6328_OCSTATUS1             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0216))
#define MT6328_OCSTATUS2             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0218))
#define MT6328_PGDEBSTATUS           ((unsigned int)(MT6328_PMIC_REG_BASE+0x021A))
#define MT6328_PGSTATUS              ((unsigned int)(MT6328_PMIC_REG_BASE+0x021C))
#define MT6328_THERMALSTATUS         ((unsigned int)(MT6328_PMIC_REG_BASE+0x021E))
#define MT6328_TOPSTATUS             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0220))
#define MT6328_TDSEL_CON             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0222))
#define MT6328_RDSEL_CON             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0224))
#define MT6328_SMT_CON0              ((unsigned int)(MT6328_PMIC_REG_BASE+0x0226))
#define MT6328_SMT_CON1              ((unsigned int)(MT6328_PMIC_REG_BASE+0x0228))
#define MT6328_SMT_CON2              ((unsigned int)(MT6328_PMIC_REG_BASE+0x022A))
#define MT6328_DRV_CON0              ((unsigned int)(MT6328_PMIC_REG_BASE+0x022C))
#define MT6328_DRV_CON1              ((unsigned int)(MT6328_PMIC_REG_BASE+0x022E))
#define MT6328_DRV_CON2              ((unsigned int)(MT6328_PMIC_REG_BASE+0x0230))
#define MT6328_DRV_CON3              ((unsigned int)(MT6328_PMIC_REG_BASE+0x0232))
#define MT6328_TOP_STATUS            ((unsigned int)(MT6328_PMIC_REG_BASE+0x0234))
#define MT6328_TOP_STATUS_SET        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0236))
#define MT6328_TOP_STATUS_CLR        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0238))
#define MT6328_RGS_ANA_MON           ((unsigned int)(MT6328_PMIC_REG_BASE+0x023A))
#define MT6328_TOP_CKPDN_CON0        ((unsigned int)(MT6328_PMIC_REG_BASE+0x023C))
#define MT6328_TOP_CKPDN_CON0_SET    ((unsigned int)(MT6328_PMIC_REG_BASE+0x023E))
#define MT6328_TOP_CKPDN_CON0_CLR    ((unsigned int)(MT6328_PMIC_REG_BASE+0x0240))
#define MT6328_TOP_CKPDN_CON1        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0242))
#define MT6328_TOP_CKPDN_CON1_SET    ((unsigned int)(MT6328_PMIC_REG_BASE+0x0244))
#define MT6328_TOP_CKPDN_CON1_CLR    ((unsigned int)(MT6328_PMIC_REG_BASE+0x0246))
#define MT6328_TOP_CKPDN_CON2        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0248))
#define MT6328_TOP_CKPDN_CON2_SET    ((unsigned int)(MT6328_PMIC_REG_BASE+0x024A))
#define MT6328_TOP_CKPDN_CON2_CLR    ((unsigned int)(MT6328_PMIC_REG_BASE+0x024C))
#define MT6328_TOP_CKPDN_CON3        ((unsigned int)(MT6328_PMIC_REG_BASE+0x024E))
#define MT6328_TOP_CKPDN_CON3_SET    ((unsigned int)(MT6328_PMIC_REG_BASE+0x0250))
#define MT6328_TOP_CKPDN_CON3_CLR    ((unsigned int)(MT6328_PMIC_REG_BASE+0x0252))
#define MT6328_TOP_CKPDN_CON4        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0254))
#define MT6328_TOP_CKPDN_CON4_SET    ((unsigned int)(MT6328_PMIC_REG_BASE+0x0256))
#define MT6328_TOP_CKPDN_CON4_CLR    ((unsigned int)(MT6328_PMIC_REG_BASE+0x0258))
#define MT6328_TOP_CKSEL_CON0        ((unsigned int)(MT6328_PMIC_REG_BASE+0x025A))
#define MT6328_TOP_CKSEL_CON0_SET    ((unsigned int)(MT6328_PMIC_REG_BASE+0x025C))
#define MT6328_TOP_CKSEL_CON0_CLR    ((unsigned int)(MT6328_PMIC_REG_BASE+0x025E))
#define MT6328_TOP_CKSEL_CON1        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0260))
#define MT6328_TOP_CKSEL_CON1_SET    ((unsigned int)(MT6328_PMIC_REG_BASE+0x0262))
#define MT6328_TOP_CKSEL_CON1_CLR    ((unsigned int)(MT6328_PMIC_REG_BASE+0x0264))
#define MT6328_TOP_CKSEL_CON2        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0266))
#define MT6328_TOP_CKSEL_CON2_SET    ((unsigned int)(MT6328_PMIC_REG_BASE+0x0268))
#define MT6328_TOP_CKSEL_CON2_CLR    ((unsigned int)(MT6328_PMIC_REG_BASE+0x026A))
#define MT6328_TOP_CKDIVSEL_CON0     ((unsigned int)(MT6328_PMIC_REG_BASE+0x026C))
#define MT6328_TOP_CKDIVSEL_CON0_SET ((unsigned int)(MT6328_PMIC_REG_BASE+0x026E))
#define MT6328_TOP_CKDIVSEL_CON0_CLR ((unsigned int)(MT6328_PMIC_REG_BASE+0x0270))
#define MT6328_TOP_CKDIVSEL_CON1     ((unsigned int)(MT6328_PMIC_REG_BASE+0x0272))
#define MT6328_TOP_CKDIVSEL_CON1_SET ((unsigned int)(MT6328_PMIC_REG_BASE+0x0274))
#define MT6328_TOP_CKDIVSEL_CON1_CLR ((unsigned int)(MT6328_PMIC_REG_BASE+0x0276))
#define MT6328_TOP_CKHWEN_CON0       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0278))
#define MT6328_TOP_CKHWEN_CON0_SET   ((unsigned int)(MT6328_PMIC_REG_BASE+0x027A))
#define MT6328_TOP_CKHWEN_CON0_CLR   ((unsigned int)(MT6328_PMIC_REG_BASE+0x027C))
#define MT6328_TOP_CKHWEN_CON1       ((unsigned int)(MT6328_PMIC_REG_BASE+0x027E))
#define MT6328_TOP_CKHWEN_CON1_SET   ((unsigned int)(MT6328_PMIC_REG_BASE+0x0280))
#define MT6328_TOP_CKHWEN_CON1_CLR   ((unsigned int)(MT6328_PMIC_REG_BASE+0x0282))
#define MT6328_TOP_CKTST_CON0        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0284))
#define MT6328_TOP_CKTST_CON1        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0286))
#define MT6328_TOP_CKTST_CON2        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0288))
#define MT6328_TOP_CLKSQ             ((unsigned int)(MT6328_PMIC_REG_BASE+0x028A))
#define MT6328_TOP_CLKSQ_SET         ((unsigned int)(MT6328_PMIC_REG_BASE+0x028C))
#define MT6328_TOP_CLKSQ_CLR         ((unsigned int)(MT6328_PMIC_REG_BASE+0x028E))
#define MT6328_TOP_CLKSQ_RTC         ((unsigned int)(MT6328_PMIC_REG_BASE+0x0290))
#define MT6328_TOP_CLKSQ_RTC_SET     ((unsigned int)(MT6328_PMIC_REG_BASE+0x0292))
#define MT6328_TOP_CLKSQ_RTC_CLR     ((unsigned int)(MT6328_PMIC_REG_BASE+0x0294))
#define MT6328_TOP_CLK_TRIM          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0296))
#define MT6328_TOP_RST_CON0          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0298))
#define MT6328_TOP_RST_CON0_SET      ((unsigned int)(MT6328_PMIC_REG_BASE+0x029A))
#define MT6328_TOP_RST_CON0_CLR      ((unsigned int)(MT6328_PMIC_REG_BASE+0x029C))
#define MT6328_TOP_RST_CON1          ((unsigned int)(MT6328_PMIC_REG_BASE+0x029E))
#define MT6328_TOP_RST_MISC          ((unsigned int)(MT6328_PMIC_REG_BASE+0x02A0))
#define MT6328_TOP_RST_MISC_SET      ((unsigned int)(MT6328_PMIC_REG_BASE+0x02A2))
#define MT6328_TOP_RST_MISC_CLR      ((unsigned int)(MT6328_PMIC_REG_BASE+0x02A4))
#define MT6328_TOP_RST_STATUS        ((unsigned int)(MT6328_PMIC_REG_BASE+0x02A6))
#define MT6328_TOP_RST_STATUS_SET    ((unsigned int)(MT6328_PMIC_REG_BASE+0x02A8))
#define MT6328_TOP_RST_STATUS_CLR    ((unsigned int)(MT6328_PMIC_REG_BASE+0x02AA))
#define MT6328_INT_CON0              ((unsigned int)(MT6328_PMIC_REG_BASE+0x02AC))
#define MT6328_INT_CON0_SET          ((unsigned int)(MT6328_PMIC_REG_BASE+0x02AE))
#define MT6328_INT_CON0_CLR          ((unsigned int)(MT6328_PMIC_REG_BASE+0x02B0))
#define MT6328_INT_CON1              ((unsigned int)(MT6328_PMIC_REG_BASE+0x02B2))
#define MT6328_INT_CON1_SET          ((unsigned int)(MT6328_PMIC_REG_BASE+0x02B4))
#define MT6328_INT_CON1_CLR          ((unsigned int)(MT6328_PMIC_REG_BASE+0x02B6))
#define MT6328_INT_CON2              ((unsigned int)(MT6328_PMIC_REG_BASE+0x02B8))
#define MT6328_INT_CON2_SET          ((unsigned int)(MT6328_PMIC_REG_BASE+0x02BA))
#define MT6328_INT_CON2_CLR          ((unsigned int)(MT6328_PMIC_REG_BASE+0x02BC))
#define MT6328_INT_MISC_CON          ((unsigned int)(MT6328_PMIC_REG_BASE+0x02BE))
#define MT6328_INT_MISC_CON_SET      ((unsigned int)(MT6328_PMIC_REG_BASE+0x02C0))
#define MT6328_INT_MISC_CON_CLR      ((unsigned int)(MT6328_PMIC_REG_BASE+0x02C2))
#define MT6328_INT_STATUS0           ((unsigned int)(MT6328_PMIC_REG_BASE+0x02C4))
#define MT6328_INT_STATUS1           ((unsigned int)(MT6328_PMIC_REG_BASE+0x02C6))
#define MT6328_INT_STATUS2           ((unsigned int)(MT6328_PMIC_REG_BASE+0x02C8))
#define MT6328_OC_GEAR_0             ((unsigned int)(MT6328_PMIC_REG_BASE+0x02CA))
#define MT6328_FQMTR_CON0            ((unsigned int)(MT6328_PMIC_REG_BASE+0x02CC))
#define MT6328_FQMTR_CON1            ((unsigned int)(MT6328_PMIC_REG_BASE+0x02CE))
#define MT6328_FQMTR_CON2            ((unsigned int)(MT6328_PMIC_REG_BASE+0x02D0))
#define MT6328_RG_SPI_CON            ((unsigned int)(MT6328_PMIC_REG_BASE+0x02D2))
#define MT6328_DEW_DIO_EN            ((unsigned int)(MT6328_PMIC_REG_BASE+0x02D4))
#define MT6328_DEW_READ_TEST         ((unsigned int)(MT6328_PMIC_REG_BASE+0x02D6))
#define MT6328_DEW_WRITE_TEST        ((unsigned int)(MT6328_PMIC_REG_BASE+0x02D8))
#define MT6328_DEW_CRC_SWRST         ((unsigned int)(MT6328_PMIC_REG_BASE+0x02DA))
#define MT6328_DEW_CRC_EN            ((unsigned int)(MT6328_PMIC_REG_BASE+0x02DC))
#define MT6328_DEW_CRC_VAL           ((unsigned int)(MT6328_PMIC_REG_BASE+0x02DE))
#define MT6328_DEW_DBG_MON_SEL       ((unsigned int)(MT6328_PMIC_REG_BASE+0x02E0))
#define MT6328_DEW_CIPHER_KEY_SEL    ((unsigned int)(MT6328_PMIC_REG_BASE+0x02E2))
#define MT6328_DEW_CIPHER_IV_SEL     ((unsigned int)(MT6328_PMIC_REG_BASE+0x02E4))
#define MT6328_DEW_CIPHER_EN         ((unsigned int)(MT6328_PMIC_REG_BASE+0x02E6))
#define MT6328_DEW_CIPHER_RDY        ((unsigned int)(MT6328_PMIC_REG_BASE+0x02E8))
#define MT6328_DEW_CIPHER_MODE       ((unsigned int)(MT6328_PMIC_REG_BASE+0x02EA))
#define MT6328_DEW_CIPHER_SWRST      ((unsigned int)(MT6328_PMIC_REG_BASE+0x02EC))
#define MT6328_DEW_RDDMY_NO          ((unsigned int)(MT6328_PMIC_REG_BASE+0x02EE))
#define MT6328_INT_TYPE_CON0         ((unsigned int)(MT6328_PMIC_REG_BASE+0x02F0))
#define MT6328_INT_TYPE_CON0_SET     ((unsigned int)(MT6328_PMIC_REG_BASE+0x02F2))
#define MT6328_INT_TYPE_CON0_CLR     ((unsigned int)(MT6328_PMIC_REG_BASE+0x02F4))
#define MT6328_INT_TYPE_CON1         ((unsigned int)(MT6328_PMIC_REG_BASE+0x02F6))
#define MT6328_INT_TYPE_CON1_SET     ((unsigned int)(MT6328_PMIC_REG_BASE+0x02F8))
#define MT6328_INT_TYPE_CON1_CLR     ((unsigned int)(MT6328_PMIC_REG_BASE+0x02FA))
#define MT6328_INT_TYPE_CON2         ((unsigned int)(MT6328_PMIC_REG_BASE+0x02FC))
#define MT6328_INT_TYPE_CON2_SET     ((unsigned int)(MT6328_PMIC_REG_BASE+0x02FE))
#define MT6328_INT_TYPE_CON2_CLR     ((unsigned int)(MT6328_PMIC_REG_BASE+0x0300))
#define MT6328_INT_STA               ((unsigned int)(MT6328_PMIC_REG_BASE+0x0302))
#define MT6328_BUCK_ALL_CON0         ((unsigned int)(MT6328_PMIC_REG_BASE+0x0400))
#define MT6328_BUCK_ALL_CON1         ((unsigned int)(MT6328_PMIC_REG_BASE+0x0402))
#define MT6328_BUCK_ALL_CON2         ((unsigned int)(MT6328_PMIC_REG_BASE+0x0404))
#define MT6328_BUCK_ALL_CON3         ((unsigned int)(MT6328_PMIC_REG_BASE+0x0406))
#define MT6328_BUCK_ALL_CON4         ((unsigned int)(MT6328_PMIC_REG_BASE+0x0408))
#define MT6328_BUCK_ALL_CON5         ((unsigned int)(MT6328_PMIC_REG_BASE+0x040A))
#define MT6328_BUCK_ALL_CON6         ((unsigned int)(MT6328_PMIC_REG_BASE+0x040C))
#define MT6328_BUCK_ALL_CON9         ((unsigned int)(MT6328_PMIC_REG_BASE+0x040E))
#define MT6328_BUCK_ALL_CON12        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0410))
#define MT6328_BUCK_ALL_CON13        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0412))
#define MT6328_BUCK_ALL_CON14        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0414))
#define MT6328_BUCK_ALL_CON16        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0416))
#define MT6328_BUCK_ALL_CON18        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0418))
#define MT6328_BUCK_ALL_CON19        ((unsigned int)(MT6328_PMIC_REG_BASE+0x041A))
#define MT6328_BUCK_ALL_CON20        ((unsigned int)(MT6328_PMIC_REG_BASE+0x041C))
#define MT6328_BUCK_ALL_CON21        ((unsigned int)(MT6328_PMIC_REG_BASE+0x041E))
#define MT6328_BUCK_ALL_CON22        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0420))
#define MT6328_BUCK_ALL_CON23        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0422))
#define MT6328_BUCK_ALL_CON24        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0424))
#define MT6328_BUCK_ALL_CON25        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0426))
#define MT6328_BUCK_ALL_CON26        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0428))
#define MT6328_BUCK_ALL_CON27        ((unsigned int)(MT6328_PMIC_REG_BASE+0x042A))
#define MT6328_BUCK_ALL_CON28        ((unsigned int)(MT6328_PMIC_REG_BASE+0x042C))
#define MT6328_SMPS_TOP_ANA_CON0     ((unsigned int)(MT6328_PMIC_REG_BASE+0x042E))
#define MT6328_SMPS_TOP_ANA_CON1     ((unsigned int)(MT6328_PMIC_REG_BASE+0x0430))
#define MT6328_SMPS_TOP_ANA_CON2     ((unsigned int)(MT6328_PMIC_REG_BASE+0x0432))
#define MT6328_SMPS_TOP_ANA_CON3     ((unsigned int)(MT6328_PMIC_REG_BASE+0x0434))
#define MT6328_SMPS_TOP_ANA_CON4     ((unsigned int)(MT6328_PMIC_REG_BASE+0x0436))
#define MT6328_SMPS_TOP_ANA_CON5     ((unsigned int)(MT6328_PMIC_REG_BASE+0x0438))
#define MT6328_SMPS_TOP_ANA_CON6     ((unsigned int)(MT6328_PMIC_REG_BASE+0x043A))
#define MT6328_SMPS_TOP_ANA_CON7     ((unsigned int)(MT6328_PMIC_REG_BASE+0x043C))
#define MT6328_SMPS_TOP_ANA_CON8     ((unsigned int)(MT6328_PMIC_REG_BASE+0x043E))
#define MT6328_VCORE_ANA_CON0        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0440))
#define MT6328_VCORE_ANA_CON1        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0442))
#define MT6328_VCORE_ANA_CON2        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0444))
#define MT6328_VCORE_ANA_CON3        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0446))
#define MT6328_VCORE_ANA_CON4        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0448))
#define MT6328_VSYS22_ANA_CON0       ((unsigned int)(MT6328_PMIC_REG_BASE+0x044A))
#define MT6328_VSYS22_ANA_CON1       ((unsigned int)(MT6328_PMIC_REG_BASE+0x044C))
#define MT6328_VSYS22_ANA_CON2       ((unsigned int)(MT6328_PMIC_REG_BASE+0x044E))
#define MT6328_VSYS22_ANA_CON3       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0450))
#define MT6328_VSYS22_ANA_CON4       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0452))
#define MT6328_VPROC_ANA_CON0        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0454))
#define MT6328_VPROC_ANA_CON1        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0456))
#define MT6328_VPROC_ANA_CON2        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0458))
#define MT6328_VPROC_ANA_CON3        ((unsigned int)(MT6328_PMIC_REG_BASE+0x045A))
#define MT6328_VPROC_ANA_CON4        ((unsigned int)(MT6328_PMIC_REG_BASE+0x045C))
#define MT6328_OSC32_ANA_CON0        ((unsigned int)(MT6328_PMIC_REG_BASE+0x045E))
#define MT6328_OSC32_ANA_CON1        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0460))
#define MT6328_VPA_ANA_CON0          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0462))
#define MT6328_VPA_ANA_CON1          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0464))
#define MT6328_VPA_ANA_CON2          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0466))
#define MT6328_VPA_ANA_CON3          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0468))
#define MT6328_VLTE_ANA_CON0         ((unsigned int)(MT6328_PMIC_REG_BASE+0x046A))
#define MT6328_VLTE_ANA_CON1         ((unsigned int)(MT6328_PMIC_REG_BASE+0x046C))
#define MT6328_VLTE_ANA_CON2         ((unsigned int)(MT6328_PMIC_REG_BASE+0x046E))
#define MT6328_VLTE_ANA_CON3         ((unsigned int)(MT6328_PMIC_REG_BASE+0x0470))
#define MT6328_VLTE_ANA_CON4         ((unsigned int)(MT6328_PMIC_REG_BASE+0x0472))
#define MT6328_VPROC_CON0            ((unsigned int)(MT6328_PMIC_REG_BASE+0x0474))
#define MT6328_VPROC_CON7            ((unsigned int)(MT6328_PMIC_REG_BASE+0x0482))
#define MT6328_VPROC_CON8            ((unsigned int)(MT6328_PMIC_REG_BASE+0x0484))
#define MT6328_VPROC_CON9            ((unsigned int)(MT6328_PMIC_REG_BASE+0x0486))
#define MT6328_VPROC_CON10           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0488))
#define MT6328_VPROC_CON11           ((unsigned int)(MT6328_PMIC_REG_BASE+0x048A))
#define MT6328_VPROC_CON12           ((unsigned int)(MT6328_PMIC_REG_BASE+0x048C))
#define MT6328_VPROC_CON13           ((unsigned int)(MT6328_PMIC_REG_BASE+0x048E))
#define MT6328_VPROC_CON14           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0490))
#define MT6328_VPROC_CON15           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0492))
#define MT6328_VPROC_CON16           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0494))
#define MT6328_VPROC_CON17           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0496))
#define MT6328_VPROC_CON18           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0498))
#define MT6328_VPROC_CON19           ((unsigned int)(MT6328_PMIC_REG_BASE+0x049A))
#define MT6328_VSRAM_CON0            ((unsigned int)(MT6328_PMIC_REG_BASE+0x049C))
#define MT6328_VSRAM_CON7            ((unsigned int)(MT6328_PMIC_REG_BASE+0x04AA))
#define MT6328_VSRAM_CON8            ((unsigned int)(MT6328_PMIC_REG_BASE+0x04AC))
#define MT6328_VSRAM_CON9            ((unsigned int)(MT6328_PMIC_REG_BASE+0x04AE))
#define MT6328_VSRAM_CON10           ((unsigned int)(MT6328_PMIC_REG_BASE+0x04B0))
#define MT6328_VSRAM_CON11           ((unsigned int)(MT6328_PMIC_REG_BASE+0x04B2))
#define MT6328_VSRAM_CON12           ((unsigned int)(MT6328_PMIC_REG_BASE+0x04B4))
#define MT6328_VSRAM_CON13           ((unsigned int)(MT6328_PMIC_REG_BASE+0x04B6))
#define MT6328_VSRAM_CON14           ((unsigned int)(MT6328_PMIC_REG_BASE+0x04B8))
#define MT6328_VSRAM_CON18           ((unsigned int)(MT6328_PMIC_REG_BASE+0x04C0))
#define MT6328_VSRAM_CON19           ((unsigned int)(MT6328_PMIC_REG_BASE+0x04C2))
#define MT6328_VLTE_CON0             ((unsigned int)(MT6328_PMIC_REG_BASE+0x04C4))
#define MT6328_VLTE_CON7             ((unsigned int)(MT6328_PMIC_REG_BASE+0x04D2))
#define MT6328_VLTE_CON8             ((unsigned int)(MT6328_PMIC_REG_BASE+0x04D4))
#define MT6328_VLTE_CON9             ((unsigned int)(MT6328_PMIC_REG_BASE+0x04D6))
#define MT6328_VLTE_CON10            ((unsigned int)(MT6328_PMIC_REG_BASE+0x04D8))
#define MT6328_VLTE_CON11            ((unsigned int)(MT6328_PMIC_REG_BASE+0x04DA))
#define MT6328_VLTE_CON12            ((unsigned int)(MT6328_PMIC_REG_BASE+0x04DC))
#define MT6328_VLTE_CON13            ((unsigned int)(MT6328_PMIC_REG_BASE+0x04DE))
#define MT6328_VLTE_CON14            ((unsigned int)(MT6328_PMIC_REG_BASE+0x04E0))
#define MT6328_VLTE_CON15            ((unsigned int)(MT6328_PMIC_REG_BASE+0x04E2))
#define MT6328_VLTE_CON16            ((unsigned int)(MT6328_PMIC_REG_BASE+0x04E4))
#define MT6328_VLTE_CON17            ((unsigned int)(MT6328_PMIC_REG_BASE+0x04E6))
#define MT6328_VLTE_CON18            ((unsigned int)(MT6328_PMIC_REG_BASE+0x04E8))
#define MT6328_VLTE_CON19            ((unsigned int)(MT6328_PMIC_REG_BASE+0x04EA))
#define MT6328_VCORE1_CON0           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0600))
#define MT6328_VCORE1_CON7           ((unsigned int)(MT6328_PMIC_REG_BASE+0x060E))
#define MT6328_VCORE1_CON8           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0610))
#define MT6328_VCORE1_CON9           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0612))
#define MT6328_VCORE1_CON10          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0614))
#define MT6328_VCORE1_CON11          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0616))
#define MT6328_VCORE1_CON12          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0618))
#define MT6328_VCORE1_CON13          ((unsigned int)(MT6328_PMIC_REG_BASE+0x061A))
#define MT6328_VCORE1_CON14          ((unsigned int)(MT6328_PMIC_REG_BASE+0x061C))
#define MT6328_VCORE1_CON15          ((unsigned int)(MT6328_PMIC_REG_BASE+0x061E))
#define MT6328_VCORE1_CON16          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0620))
#define MT6328_VCORE1_CON17          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0622))
#define MT6328_VCORE1_CON18          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0624))
#define MT6328_VCORE1_CON19          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0626))
#define MT6328_VSYS22_CON0           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0628))
#define MT6328_VSYS22_CON7           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0636))
#define MT6328_VSYS22_CON8           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0638))
#define MT6328_VSYS22_CON9           ((unsigned int)(MT6328_PMIC_REG_BASE+0x063A))
#define MT6328_VSYS22_CON10          ((unsigned int)(MT6328_PMIC_REG_BASE+0x063C))
#define MT6328_VSYS22_CON11          ((unsigned int)(MT6328_PMIC_REG_BASE+0x063E))
#define MT6328_VSYS22_CON12          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0640))
#define MT6328_VSYS22_CON13          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0642))
#define MT6328_VSYS22_CON14          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0644))
#define MT6328_VSYS22_CON15          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0646))
#define MT6328_VSYS22_CON16          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0648))
#define MT6328_VSYS22_CON17          ((unsigned int)(MT6328_PMIC_REG_BASE+0x064A))
#define MT6328_VSYS22_CON18          ((unsigned int)(MT6328_PMIC_REG_BASE+0x064C))
#define MT6328_VSYS22_CON19          ((unsigned int)(MT6328_PMIC_REG_BASE+0x064E))
#define MT6328_VPA_CON0              ((unsigned int)(MT6328_PMIC_REG_BASE+0x0650))
#define MT6328_VPA_CON7              ((unsigned int)(MT6328_PMIC_REG_BASE+0x065E))
#define MT6328_VPA_CON8              ((unsigned int)(MT6328_PMIC_REG_BASE+0x0660))
#define MT6328_VPA_CON9              ((unsigned int)(MT6328_PMIC_REG_BASE+0x0662))
#define MT6328_VPA_CON10             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0664))
#define MT6328_VPA_CON11             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0666))
#define MT6328_VPA_CON12             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0668))
#define MT6328_VPA_CON13             ((unsigned int)(MT6328_PMIC_REG_BASE+0x066A))
#define MT6328_VPA_CON14             ((unsigned int)(MT6328_PMIC_REG_BASE+0x066C))
#define MT6328_VPA_CON15             ((unsigned int)(MT6328_PMIC_REG_BASE+0x066E))
#define MT6328_VPA_CON16             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0670))
#define MT6328_VPA_CON17             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0672))
#define MT6328_VPA_CON18             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0674))
#define MT6328_VPA_CON19             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0676))
#define MT6328_VPA_CON20             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0678))
#define MT6328_VPA_CON21             ((unsigned int)(MT6328_PMIC_REG_BASE+0x067A))
#define MT6328_VPA_CON22             ((unsigned int)(MT6328_PMIC_REG_BASE+0x067C))
#define MT6328_VPA_CON23             ((unsigned int)(MT6328_PMIC_REG_BASE+0x067E))
#define MT6328_VPA_CON24             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0680))
#define MT6328_BUCK_K_CON0           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0682))
#define MT6328_BUCK_K_CON1           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0684))
#define MT6328_BUCK_K_CON2           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0686))
#define MT6328_BUCK_K_CON3           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0688))
#define MT6328_ZCD_CON0              ((unsigned int)(MT6328_PMIC_REG_BASE+0x0800))
#define MT6328_ZCD_CON1              ((unsigned int)(MT6328_PMIC_REG_BASE+0x0802))
#define MT6328_ZCD_CON2              ((unsigned int)(MT6328_PMIC_REG_BASE+0x0804))
#define MT6328_ZCD_CON3              ((unsigned int)(MT6328_PMIC_REG_BASE+0x0806))
#define MT6328_ZCD_CON4              ((unsigned int)(MT6328_PMIC_REG_BASE+0x0808))
#define MT6328_ZCD_CON5              ((unsigned int)(MT6328_PMIC_REG_BASE+0x080A))
#define MT6328_ISINK0_CON0           ((unsigned int)(MT6328_PMIC_REG_BASE+0x080C))
#define MT6328_ISINK0_CON1           ((unsigned int)(MT6328_PMIC_REG_BASE+0x080E))
#define MT6328_ISINK0_CON2           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0810))
#define MT6328_ISINK0_CON3           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0812))
#define MT6328_ISINK1_CON0           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0814))
#define MT6328_ISINK1_CON1           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0816))
#define MT6328_ISINK1_CON2           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0818))
#define MT6328_ISINK1_CON3           ((unsigned int)(MT6328_PMIC_REG_BASE+0x081A))
#define MT6328_ISINK2_CON1           ((unsigned int)(MT6328_PMIC_REG_BASE+0x081C))
#define MT6328_ISINK3_CON1           ((unsigned int)(MT6328_PMIC_REG_BASE+0x081E))
#define MT6328_ISINK_ANA0            ((unsigned int)(MT6328_PMIC_REG_BASE+0x0820))
#define MT6328_ISINK_ANA1            ((unsigned int)(MT6328_PMIC_REG_BASE+0x0822))
#define MT6328_ISINK_PHASE_DLY       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0824))
#define MT6328_ISINK_SFSTR           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0826))
#define MT6328_ISINK_EN_CTRL         ((unsigned int)(MT6328_PMIC_REG_BASE+0x0828))
#define MT6328_ISINK_MODE_CTRL       ((unsigned int)(MT6328_PMIC_REG_BASE+0x082A))
#define MT6328_VTCXO_0_CON0          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A00))
#define MT6328_VTCXO_1_CON0          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A02))
#define MT6328_VAUD28_CON0           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A04))
#define MT6328_VAUX18_CON0           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A06))
#define MT6328_VRF18_0_CON0          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A08))
#define MT6328_VRF18_0_CON1          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A0A))
#define MT6328_VCAMA_CON0            ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A0C))
#define MT6328_VCN28_CON0            ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A0E))
#define MT6328_VCN33_CON0            ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A10))
#define MT6328_VCN33_CON1            ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A12))
#define MT6328_VCN33_CON2            ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A14))
#define MT6328_VRF18_1_CON0          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A16))
#define MT6328_VRF18_1_CON1          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A18))
#define MT6328_VUSB33_CON0           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A1A))
#define MT6328_VMCH_CON0             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A1C))
#define MT6328_VMCH_CON1             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A1E))
#define MT6328_VMC_CON0              ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A20))
#define MT6328_VMC_CON1              ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A22))
#define MT6328_VEMC_3V3_CON0         ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A24))
#define MT6328_VEMC_3V3_CON1         ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A26))
#define MT6328_VIO28_CON0            ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A28))
#define MT6328_VCAMAF_CON0           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A2A))
#define MT6328_VGP1_CON0             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A2C))
#define MT6328_VGP1_CON1             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A2E))
#define MT6328_VEFUSE_CON0           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A30))
#define MT6328_VSIM1_CON0            ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A32))
#define MT6328_VSIM2_CON0            ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A34))
#define MT6328_VIO18_CON0            ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A36))
#define MT6328_VIBR_CON0             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A38))
#define MT6328_VCN18_CON0            ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A3A))
#define MT6328_VCAM_CON0             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A3C))
#define MT6328_VCAMIO_CON0           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A3E))
#define MT6328_LDO_VSRAM_CON0        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A40))
#define MT6328_LDO_VSRAM_CON1        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A42))
#define MT6328_VTREF_CON0            ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A44))
#define MT6328_VM_CON0               ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A46))
#define MT6328_VM_CON1               ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A48))
#define MT6328_VRTC_CON0             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A4A))
#define MT6328_LDO_OCFB0             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A4C))
#define MT6328_ALDO_ANA_CON0         ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A4E))
#define MT6328_ADLDO_ANA_CON1        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A50))
#define MT6328_ADLDO_ANA_CON2        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A52))
#define MT6328_ADLDO_ANA_CON3        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A54))
#define MT6328_ADLDO_ANA_CON4        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A56))
#define MT6328_ADLDO_ANA_CON5        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A58))
#define MT6328_ADLDO_ANA_CON6        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A5A))
#define MT6328_ADLDO_ANA_CON7        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A5C))
#define MT6328_ADLDO_ANA_CON8        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A5E))
#define MT6328_ADLDO_ANA_CON9        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A60))
#define MT6328_ADLDO_ANA_CON10       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A62))
#define MT6328_ADLDO_ANA_CON11       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A64))
#define MT6328_ADLDO_ANA_CON12       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A66))
#define MT6328_ADLDO_ANA_CON13       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A68))
#define MT6328_DLDO_ANA_CON0         ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A6A))
#define MT6328_DLDO_ANA_CON1         ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A6C))
#define MT6328_DLDO_ANA_CON2         ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A6E))
#define MT6328_DLDO_ANA_CON3         ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A70))
#define MT6328_DLDO_ANA_CON4         ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A72))
#define MT6328_DLDO_ANA_CON5         ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A74))
#define MT6328_SLDO_ANA_CON0         ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A76))
#define MT6328_SLDO_ANA_CON1         ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A78))
#define MT6328_SLDO_ANA_CON2         ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A7A))
#define MT6328_SLDO_ANA_CON3         ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A7C))
#define MT6328_SLDO_ANA_CON4         ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A7E))
#define MT6328_SLDO_ANA_CON5         ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A80))
#define MT6328_SLDO_ANA_CON6         ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A82))
#define MT6328_SLDO_ANA_CON7         ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A84))
#define MT6328_SLDO_ANA_CON8         ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A86))
#define MT6328_SLDO_ANA_CON9         ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A88))
#define MT6328_SLDO_ANA_CON10        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A8A))
#define MT6328_LDO_RSV_CON0          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A8C))
#define MT6328_LDO_RSV_CON1          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A8E))
#define MT6328_SPK_CON0              ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A90))
#define MT6328_SPK_CON1              ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A92))
#define MT6328_SPK_CON2              ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A94))
#define MT6328_SPK_CON3              ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A96))
#define MT6328_SPK_CON4              ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A98))
#define MT6328_SPK_CON5              ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A9A))
#define MT6328_SPK_CON6              ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A9C))
#define MT6328_SPK_CON7              ((unsigned int)(MT6328_PMIC_REG_BASE+0x0A9E))
#define MT6328_SPK_CON8              ((unsigned int)(MT6328_PMIC_REG_BASE+0x0AA0))
#define MT6328_SPK_CON9              ((unsigned int)(MT6328_PMIC_REG_BASE+0x0AA2))
#define MT6328_SPK_CON10             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0AA4))
#define MT6328_SPK_CON11             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0AA6))
#define MT6328_SPK_CON12             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0AA8))
#define MT6328_SPK_CON13             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0AAA))
#define MT6328_SPK_CON14             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0AAC))
#define MT6328_SPK_CON15             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0AAE))
#define MT6328_SPK_CON16             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0AB0))
#define MT6328_SPK_ANA_CON0          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0AB2))
#define MT6328_SPK_ANA_CON1          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0AB4))
#define MT6328_SPK_ANA_CON3          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0AB6))
#define MT6328_OTP_CON0              ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C00))
#define MT6328_OTP_CON1              ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C02))
#define MT6328_OTP_CON2              ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C04))
#define MT6328_OTP_CON3              ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C06))
#define MT6328_OTP_CON4              ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C08))
#define MT6328_OTP_CON5              ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C0A))
#define MT6328_OTP_CON6              ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C0C))
#define MT6328_OTP_CON7              ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C0E))
#define MT6328_OTP_CON8              ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C10))
#define MT6328_OTP_CON9              ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C12))
#define MT6328_OTP_CON10             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C14))
#define MT6328_OTP_CON11             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C16))
#define MT6328_OTP_CON12             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C18))
#define MT6328_OTP_CON13             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C1A))
#define MT6328_OTP_CON14             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C1C))
#define MT6328_OTP_DOUT_0_15         ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C1E))
#define MT6328_OTP_DOUT_16_31        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C20))
#define MT6328_OTP_DOUT_32_47        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C22))
#define MT6328_OTP_DOUT_48_63        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C24))
#define MT6328_OTP_DOUT_64_79        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C26))
#define MT6328_OTP_DOUT_80_95        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C28))
#define MT6328_OTP_DOUT_96_111       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C2A))
#define MT6328_OTP_DOUT_112_127      ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C2C))
#define MT6328_OTP_DOUT_128_143      ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C2E))
#define MT6328_OTP_DOUT_144_159      ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C30))
#define MT6328_OTP_DOUT_160_175      ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C32))
#define MT6328_OTP_DOUT_176_191      ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C34))
#define MT6328_OTP_DOUT_192_207      ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C36))
#define MT6328_OTP_DOUT_208_223      ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C38))
#define MT6328_OTP_DOUT_224_239      ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C3A))
#define MT6328_OTP_DOUT_240_255      ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C3C))
#define MT6328_OTP_DOUT_256_271      ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C3E))
#define MT6328_OTP_DOUT_272_287      ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C40))
#define MT6328_OTP_DOUT_288_303      ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C42))
#define MT6328_OTP_DOUT_304_319      ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C44))
#define MT6328_OTP_DOUT_320_335      ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C46))
#define MT6328_OTP_DOUT_336_351      ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C48))
#define MT6328_OTP_DOUT_352_367      ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C4A))
#define MT6328_OTP_DOUT_368_383      ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C4C))
#define MT6328_OTP_DOUT_384_399      ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C4E))
#define MT6328_OTP_DOUT_400_415      ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C50))
#define MT6328_OTP_DOUT_416_431      ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C52))
#define MT6328_OTP_DOUT_432_447      ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C54))
#define MT6328_OTP_DOUT_448_463      ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C56))
#define MT6328_OTP_DOUT_464_479      ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C58))
#define MT6328_OTP_DOUT_480_495      ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C5A))
#define MT6328_OTP_DOUT_496_511      ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C5C))
#define MT6328_OTP_VAL_0_15          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C5E))
#define MT6328_OTP_VAL_16_31         ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C60))
#define MT6328_OTP_VAL_32_47         ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C62))
#define MT6328_OTP_VAL_48_63         ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C64))
#define MT6328_OTP_VAL_64_79         ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C66))
#define MT6328_OTP_VAL_80_95         ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C68))
#define MT6328_OTP_VAL_96_111        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C6A))
#define MT6328_OTP_VAL_112_127       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C6C))
#define MT6328_OTP_VAL_128_143       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C6E))
#define MT6328_OTP_VAL_144_159       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C70))
#define MT6328_OTP_VAL_160_175       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C72))
#define MT6328_OTP_VAL_176_191       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C74))
#define MT6328_OTP_VAL_192_207       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C76))
#define MT6328_OTP_VAL_208_223       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C78))
#define MT6328_OTP_VAL_224_239       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C7A))
#define MT6328_OTP_VAL_240_255       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C7C))
#define MT6328_OTP_VAL_256_271       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C7E))
#define MT6328_OTP_VAL_272_287       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C80))
#define MT6328_OTP_VAL_288_303       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C82))
#define MT6328_OTP_VAL_304_319       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C84))
#define MT6328_OTP_VAL_320_335       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C86))
#define MT6328_OTP_VAL_336_351       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C88))
#define MT6328_OTP_VAL_352_367       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C8A))
#define MT6328_OTP_VAL_368_383       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C8C))
#define MT6328_OTP_VAL_384_399       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C8E))
#define MT6328_OTP_VAL_400_415       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C90))
#define MT6328_OTP_VAL_416_431       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C92))
#define MT6328_OTP_VAL_432_447       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C94))
#define MT6328_OTP_VAL_448_463       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C96))
#define MT6328_OTP_VAL_464_479       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C98))
#define MT6328_OTP_VAL_480_495       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C9A))
#define MT6328_OTP_VAL_496_511       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C9C))
#define MT6328_RTC_MIX_CON0          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0C9E))
#define MT6328_RTC_MIX_CON1          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0CA0))
#define MT6328_RTC_MIX_CON2          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0CA2))
#define MT6328_FGADC_CON0            ((unsigned int)(MT6328_PMIC_REG_BASE+0x0CA4))
#define MT6328_FGADC_CON1            ((unsigned int)(MT6328_PMIC_REG_BASE+0x0CA6))
#define MT6328_FGADC_CON2            ((unsigned int)(MT6328_PMIC_REG_BASE+0x0CA8))
#define MT6328_FGADC_CON3            ((unsigned int)(MT6328_PMIC_REG_BASE+0x0CAA))
#define MT6328_FGADC_CON4            ((unsigned int)(MT6328_PMIC_REG_BASE+0x0CAC))
#define MT6328_FGADC_CON5            ((unsigned int)(MT6328_PMIC_REG_BASE+0x0CAE))
#define MT6328_FGADC_CON6            ((unsigned int)(MT6328_PMIC_REG_BASE+0x0CB0))
#define MT6328_FGADC_CON7            ((unsigned int)(MT6328_PMIC_REG_BASE+0x0CB2))
#define MT6328_FGADC_CON8            ((unsigned int)(MT6328_PMIC_REG_BASE+0x0CB4))
#define MT6328_FGADC_CON9            ((unsigned int)(MT6328_PMIC_REG_BASE+0x0CB6))
#define MT6328_FGADC_CON10           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0CB8))
#define MT6328_FGADC_CON11           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0CBA))
#define MT6328_FGADC_CON12           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0CBC))
#define MT6328_FGADC_CON13           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0CBE))
#define MT6328_FGADC_CON14           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0CC0))
#define MT6328_FGADC_CON15           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0CC2))
#define MT6328_FGADC_CON16           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0CC4))
#define MT6328_FGADC_CON17           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0CC6))
#define MT6328_FGADC_CON18           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0CC8))
#define MT6328_FGADC_CON19           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0CCA))
#define MT6328_FGADC_CON20           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0CCC))
#define MT6328_FGADC_CON21           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0CCE))
#define MT6328_FGADC_CON22           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0CD0))
#define MT6328_FGADC_CON23           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0CD2))
#define MT6328_FGADC_CON24           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0CD4))
#define MT6328_FGADC_CON25           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0CD6))
#define MT6328_FGADC_CON26           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0CD8))
#define MT6328_FGADC_CON27           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0CDA))
#define MT6328_AUDDEC_ANA_CON0       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0CDC))
#define MT6328_AUDDEC_ANA_CON1       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0CDE))
#define MT6328_AUDDEC_ANA_CON2       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0CE0))
#define MT6328_AUDDEC_ANA_CON3       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0CE2))
#define MT6328_AUDDEC_ANA_CON4       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0CE4))
#define MT6328_AUDDEC_ANA_CON5       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0CE6))
#define MT6328_AUDDEC_ANA_CON6       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0CE8))
#define MT6328_AUDDEC_ANA_CON7       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0CEA))
#define MT6328_AUDDEC_ANA_CON8       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0CEC))
#define MT6328_AUDENC_ANA_CON0       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0CEE))
#define MT6328_AUDENC_ANA_CON1       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0CF0))
#define MT6328_AUDENC_ANA_CON2       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0CF2))
#define MT6328_AUDENC_ANA_CON3       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0CF4))
#define MT6328_AUDENC_ANA_CON4       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0CF6))
#define MT6328_AUDENC_ANA_CON5       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0CF8))
#define MT6328_AUDENC_ANA_CON6       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0CFA))
#define MT6328_AUDENC_ANA_CON7       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0CFC))
#define MT6328_AUDENC_ANA_CON8       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0CFE))
#define MT6328_AUDENC_ANA_CON9       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0D00))
#define MT6328_AUDENC_ANA_CON10      ((unsigned int)(MT6328_PMIC_REG_BASE+0x0D02))
#define MT6328_AUDNCP_CLKDIV_CON0    ((unsigned int)(MT6328_PMIC_REG_BASE+0x0D04))
#define MT6328_AUDNCP_CLKDIV_CON1    ((unsigned int)(MT6328_PMIC_REG_BASE+0x0D06))
#define MT6328_AUDNCP_CLKDIV_CON2    ((unsigned int)(MT6328_PMIC_REG_BASE+0x0D08))
#define MT6328_AUDNCP_CLKDIV_CON3    ((unsigned int)(MT6328_PMIC_REG_BASE+0x0D0A))
#define MT6328_AUDNCP_CLKDIV_CON4    ((unsigned int)(MT6328_PMIC_REG_BASE+0x0D0C))
#define MT6328_AUXADC_ADC0           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E00))
#define MT6328_AUXADC_ADC1           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E02))
#define MT6328_AUXADC_ADC2           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E04))
#define MT6328_AUXADC_ADC3           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E06))
#define MT6328_AUXADC_ADC4           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E08))
#define MT6328_AUXADC_ADC5           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E0A))
#define MT6328_AUXADC_ADC6           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E0C))
#define MT6328_AUXADC_ADC7           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E0E))
#define MT6328_AUXADC_ADC8           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E10))
#define MT6328_AUXADC_ADC9           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E12))
#define MT6328_AUXADC_ADC10          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E14))
#define MT6328_AUXADC_ADC11          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E16))
#define MT6328_AUXADC_ADC12          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E18))
#define MT6328_AUXADC_ADC13          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E1A))
#define MT6328_AUXADC_ADC14          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E1C))
#define MT6328_AUXADC_ADC15          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E1E))
#define MT6328_AUXADC_ADC16          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E20))
#define MT6328_AUXADC_ADC17          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E22))
#define MT6328_AUXADC_ADC18          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E24))
#define MT6328_AUXADC_ADC19          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E26))
#define MT6328_AUXADC_ADC20          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E28))
#define MT6328_AUXADC_ADC21          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E2A))
#define MT6328_AUXADC_ADC22          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E2C))
#define MT6328_AUXADC_ADC23          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E2E))
#define MT6328_AUXADC_ADC24          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E30))
#define MT6328_AUXADC_ADC25          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E32))
#define MT6328_AUXADC_ADC26          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E34))
#define MT6328_AUXADC_ADC27          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E36))
#define MT6328_AUXADC_ADC28          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E38))
#define MT6328_AUXADC_ADC29          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E3A))
#define MT6328_AUXADC_ADC30          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E3C))
#define MT6328_AUXADC_ADC31          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E3E))
#define MT6328_AUXADC_ADC32          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E40))
#define MT6328_AUXADC_ADC33          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E42))
#define MT6328_AUXADC_BUF0           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E44))
#define MT6328_AUXADC_BUF1           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E46))
#define MT6328_AUXADC_BUF2           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E48))
#define MT6328_AUXADC_BUF3           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E4A))
#define MT6328_AUXADC_BUF4           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E4C))
#define MT6328_AUXADC_BUF5           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E4E))
#define MT6328_AUXADC_BUF6           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E50))
#define MT6328_AUXADC_BUF7           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E52))
#define MT6328_AUXADC_BUF8           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E54))
#define MT6328_AUXADC_BUF9           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E56))
#define MT6328_AUXADC_BUF10          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E58))
#define MT6328_AUXADC_BUF11          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E5A))
#define MT6328_AUXADC_BUF12          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E5C))
#define MT6328_AUXADC_BUF13          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E5E))
#define MT6328_AUXADC_BUF14          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E60))
#define MT6328_AUXADC_BUF15          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E62))
#define MT6328_AUXADC_BUF16          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E64))
#define MT6328_AUXADC_BUF17          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E66))
#define MT6328_AUXADC_BUF18          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E68))
#define MT6328_AUXADC_BUF19          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E6A))
#define MT6328_AUXADC_BUF20          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E6C))
#define MT6328_AUXADC_BUF21          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E6E))
#define MT6328_AUXADC_BUF22          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E70))
#define MT6328_AUXADC_BUF23          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E72))
#define MT6328_AUXADC_BUF24          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E74))
#define MT6328_AUXADC_BUF25          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E76))
#define MT6328_AUXADC_BUF26          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E78))
#define MT6328_AUXADC_BUF27          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E7A))
#define MT6328_AUXADC_BUF28          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E7C))
#define MT6328_AUXADC_BUF29          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E7E))
#define MT6328_AUXADC_BUF30          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E80))
#define MT6328_AUXADC_BUF31          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E82))
#define MT6328_AUXADC_STA0           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E84))
#define MT6328_AUXADC_STA1           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E86))
#define MT6328_AUXADC_RQST0          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E88))
#define MT6328_AUXADC_RQST0_SET      ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E8A))
#define MT6328_AUXADC_RQST0_CLR      ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E8C))
#define MT6328_AUXADC_RQST1          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E8E))
#define MT6328_AUXADC_RQST1_SET      ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E90))
#define MT6328_AUXADC_RQST1_CLR      ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E92))
#define MT6328_AUXADC_CON0           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E94))
#define MT6328_AUXADC_CON0_SET       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E96))
#define MT6328_AUXADC_CON0_CLR       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E98))
#define MT6328_AUXADC_CON1           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E9A))
#define MT6328_AUXADC_CON2           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E9C))
#define MT6328_AUXADC_CON3           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0E9E))
#define MT6328_AUXADC_CON4           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0EA0))
#define MT6328_AUXADC_CON5           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0EA2))
#define MT6328_AUXADC_CON6           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0EA4))
#define MT6328_AUXADC_CON7           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0EA6))
#define MT6328_AUXADC_CON8           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0EA8))
#define MT6328_AUXADC_CON9           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0EAA))
#define MT6328_AUXADC_CON10          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0EAC))
#define MT6328_AUXADC_CON11          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0EAE))
#define MT6328_AUXADC_CON12          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0EB0))
#define MT6328_AUXADC_CON13          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0EB2))
#define MT6328_AUXADC_CON14          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0EB4))
#define MT6328_AUXADC_CON15          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0EB6))
#define MT6328_AUXADC_CON16          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0EB8))
#define MT6328_AUXADC_AUTORPT0       ((unsigned int)(MT6328_PMIC_REG_BASE+0x0EBA))
#define MT6328_AUXADC_LBAT0          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0EBC))
#define MT6328_AUXADC_LBAT1          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0EBE))
#define MT6328_AUXADC_LBAT2          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0EC0))
#define MT6328_AUXADC_LBAT3          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0EC2))
#define MT6328_AUXADC_LBAT4          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0EC4))
#define MT6328_AUXADC_LBAT5          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0EC6))
#define MT6328_AUXADC_LBAT6          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0EC8))
#define MT6328_AUXADC_ACCDET         ((unsigned int)(MT6328_PMIC_REG_BASE+0x0ECA))
#define MT6328_AUXADC_THR0           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0ECC))
#define MT6328_AUXADC_THR1           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0ECE))
#define MT6328_AUXADC_THR2           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0ED0))
#define MT6328_AUXADC_THR3           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0ED2))
#define MT6328_AUXADC_THR4           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0ED4))
#define MT6328_AUXADC_THR5           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0ED6))
#define MT6328_AUXADC_THR6           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0ED8))
#define MT6328_AUXADC_EFUSE0         ((unsigned int)(MT6328_PMIC_REG_BASE+0x0EDA))
#define MT6328_AUXADC_EFUSE1         ((unsigned int)(MT6328_PMIC_REG_BASE+0x0EDC))
#define MT6328_AUXADC_EFUSE2         ((unsigned int)(MT6328_PMIC_REG_BASE+0x0EDE))
#define MT6328_AUXADC_EFUSE3         ((unsigned int)(MT6328_PMIC_REG_BASE+0x0EE0))
#define MT6328_AUXADC_EFUSE4         ((unsigned int)(MT6328_PMIC_REG_BASE+0x0EE2))
#define MT6328_AUXADC_EFUSE5         ((unsigned int)(MT6328_PMIC_REG_BASE+0x0EE4))
#define MT6328_AUXADC_DBG0           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0EE6))
#define MT6328_AUXADC_IMP0           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0EE8))
#define MT6328_AUXADC_IMP1           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0EEA))
#define MT6328_AUXADC_VISMPS0_1      ((unsigned int)(MT6328_PMIC_REG_BASE+0x0EEC))
#define MT6328_AUXADC_VISMPS0_2      ((unsigned int)(MT6328_PMIC_REG_BASE+0x0EEE))
#define MT6328_AUXADC_VISMPS0_3      ((unsigned int)(MT6328_PMIC_REG_BASE+0x0EF0))
#define MT6328_AUXADC_VISMPS0_4      ((unsigned int)(MT6328_PMIC_REG_BASE+0x0EF2))
#define MT6328_AUXADC_VISMPS0_5      ((unsigned int)(MT6328_PMIC_REG_BASE+0x0EF4))
#define MT6328_AUXADC_VISMPS0_6      ((unsigned int)(MT6328_PMIC_REG_BASE+0x0EF6))
#define MT6328_AUXADC_VISMPS0_7      ((unsigned int)(MT6328_PMIC_REG_BASE+0x0EF8))
#define MT6328_AUXADC_LBAT2_1        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0EFA))
#define MT6328_AUXADC_LBAT2_2        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0EFC))
#define MT6328_AUXADC_LBAT2_3        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0EFE))
#define MT6328_AUXADC_LBAT2_4        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F00))
#define MT6328_AUXADC_LBAT2_5        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F02))
#define MT6328_AUXADC_LBAT2_6        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F04))
#define MT6328_AUXADC_LBAT2_7        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F06))
#define MT6328_AUXADC_MDBG_0         ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F08))
#define MT6328_AUXADC_MDBG_1         ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F0A))
#define MT6328_AUXADC_MDBG_2         ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F0C))
#define MT6328_AUXADC_MDRT_0         ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F0E))
#define MT6328_AUXADC_MDRT_1         ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F10))
#define MT6328_AUXADC_MDRT_2         ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F12))
#define MT6328_ACCDET_CON0           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F14))
#define MT6328_ACCDET_CON1           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F16))
#define MT6328_ACCDET_CON2           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F18))
#define MT6328_ACCDET_CON3           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F1A))
#define MT6328_ACCDET_CON4           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F1C))
#define MT6328_ACCDET_CON5           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F1E))
#define MT6328_ACCDET_CON6           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F20))
#define MT6328_ACCDET_CON7           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F22))
#define MT6328_ACCDET_CON8           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F24))
#define MT6328_ACCDET_CON9           ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F26))
#define MT6328_ACCDET_CON10          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F28))
#define MT6328_ACCDET_CON11          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F2A))
#define MT6328_ACCDET_CON12          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F2C))
#define MT6328_ACCDET_CON13          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F2E))
#define MT6328_ACCDET_CON14          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F30))
#define MT6328_ACCDET_CON15          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F32))
#define MT6328_ACCDET_CON16          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F34))
#define MT6328_ACCDET_CON17          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F36))
#define MT6328_ACCDET_CON18          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F38))
#define MT6328_ACCDET_CON19          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F3A))
#define MT6328_ACCDET_CON20          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F3C))
#define MT6328_ACCDET_CON21          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F3E))
#define MT6328_ACCDET_CON22          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F40))
#define MT6328_ACCDET_CON23          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F42))
#define MT6328_ACCDET_CON24          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F44))
#define MT6328_ACCDET_CON25          ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F46))
#define MT6328_CHR_CON0              ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F48))
#define MT6328_CHR_CON1              ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F4A))
#define MT6328_CHR_CON2              ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F4C))
#define MT6328_CHR_CON3              ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F4E))
#define MT6328_CHR_CON4              ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F50))
#define MT6328_CHR_CON5              ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F52))
#define MT6328_CHR_CON6              ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F54))
#define MT6328_CHR_CON7              ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F56))
#define MT6328_CHR_CON8              ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F58))
#define MT6328_CHR_CON9              ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F5A))
#define MT6328_CHR_CON10             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F5C))
#define MT6328_CHR_CON11             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F5E))
#define MT6328_CHR_CON12             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F60))
#define MT6328_CHR_CON13             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F62))
#define MT6328_CHR_CON14             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F64))
#define MT6328_CHR_CON15             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F66))
#define MT6328_CHR_CON16             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F68))
#define MT6328_CHR_CON17             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F6A))
#define MT6328_CHR_CON18             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F6C))
#define MT6328_CHR_CON19             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F6E))
#define MT6328_CHR_CON20             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F70))
#define MT6328_CHR_CON21             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F72))
#define MT6328_CHR_CON22             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F74))
#define MT6328_CHR_CON23             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F76))
#define MT6328_CHR_CON24             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F78))
#define MT6328_CHR_CON25             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F7A))
#define MT6328_CHR_CON26             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F7C))
#define MT6328_CHR_CON27             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F7E))
#define MT6328_CHR_CON28             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F80))
#define MT6328_CHR_CON29             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F82))
#define MT6328_CHR_CON30             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F84))
#define MT6328_CHR_CON31             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F86))
#define MT6328_CHR_CON32             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F88))
#define MT6328_CHR_CON33             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F8A))
#define MT6328_CHR_CON34             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F8C))
#define MT6328_CHR_CON35             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F8E))
#define MT6328_CHR_CON36             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F90))
#define MT6328_CHR_CON37             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F92))
#define MT6328_CHR_CON38             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F94))
#define MT6328_CHR_CON39             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F96))
#define MT6328_CHR_CON40             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F98))
#define MT6328_CHR_CON41             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F9A))
#define MT6328_CHR_CON42             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F9C))
#define MT6328_BATON_CON0            ((unsigned int)(MT6328_PMIC_REG_BASE+0x0F9E))
#define MT6328_CHR_CON43             ((unsigned int)(MT6328_PMIC_REG_BASE+0x0FA0))
#define MT6328_EOSC_CALI_CON0        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0FAA))
#define MT6328_EOSC_CALI_CON1        ((unsigned int)(MT6328_PMIC_REG_BASE+0x0FAC))
#define MT6328_VRTC_PWM_CON0         ((unsigned int)(MT6328_PMIC_REG_BASE+0x0FAE))



/* -----PMIC_WRAP INT register for PMIC ------------------------------------------------- */
/* #define MT6328_INT_STA         (PMIC_REG_BASE+0x01B4) //0x01B4 */
#define MT6328_INT_STA               ((unsigned int)(MT6328_PMIC_REG_BASE+0x0302))

#define MT6332_INT_STA         (SWCHR_REG_BASE+0x0112)	/* 0x8112 */
/* ///////////////////////////////////////////////////////////////////////////////////////// */

/*
#define AUXADC_CON21       (PMIC_REG_BASE+0x076C)
#define AUXADC_ADC12       (PMIC_REG_BASE+0x072C)
#define AUXADC_ADC13       (PMIC_REG_BASE+0x072E)
#define AUXADC_ADC14       (PMIC_REG_BASE+0x0730)
#define AUXADC_CON2        (PMIC_REG_BASE+0x0746)
#define AUXADC_CON3        (PMIC_REG_BASE+0x0748)

#define EFUSE_VAL_0_15     (PMIC_REG_BASE+0x060E)
#define EFUSE_VAL_16_31    (PMIC_REG_BASE+0x0610)
#define EFUSE_VAL_32_47    (PMIC_REG_BASE+0x0612)
#define EFUSE_VAL_48_63    (PMIC_REG_BASE+0x0614)
#define EFUSE_VAL_64_79    (PMIC_REG_BASE+0x0616)
*/
/* -----macro for dewrapper defaule value------------------------------------------------------- */
#define MT6328_DEFAULT_VALUE_READ_TEST      0x5aa5
#define WRITE_TEST_DEFAULT_VALUE		    0x0
#define WRITE_TEST_EXT_DEFAULT_VALUE	0x0
#define MT6332_DEFAULT_VALUE_READ_TEST     0xa55a
#define MT6328_WRITE_TEST_VALUE            0x1234
#define MT6332_WRITE_TEST_VALUE            0x4321
#define WRAP_ACCESS_TEST_REG			MT6328_DEW_WRITE_TEST
#define WRAP_ACCESS_TEST_EXT_REG		MT6332_DEW_WRITE_TEST

/* -----macro for manual commnd -------------------------------------------------------- */
#define OP_WR    (0x1)
#define OP_RD    (0x0)

#define OP_CSH   (0x0)
#define OP_CSL   (0x1)
#define OP_CK    (0x2)

#define OP_OUTS  (0x8)
#define OP_OUTD  (0x9)
#define OP_OUTQ  (0xA)

#define OP_INS   (0xC)
#define OP_INS0  (0xD)
#define OP_IND   (0xE)
#define OP_INQ   (0xF)

#define OP_OS2IS (0x10)
#define OP_OS2ID (0x11)
#define OP_OS2IQ (0x12)
#define OP_OD2IS (0x13)
#define OP_OD2ID (0x14)
#define OP_OD2IQ (0x15)
#define OP_OQ2IS (0x16)
#define OP_OQ2ID (0x17)
#define OP_OQ2IQ (0x18)

#define OP_OSNIS (0x19)
#define OP_ODNID (0x1A)

#define E_PWR_INVALID_ARG               1
#define E_PWR_INVALID_RW                2
#define E_PWR_INVALID_ADDR              3
#define E_PWR_INVALID_WDAT              4
#define E_PWR_INVALID_OP_MANUAL         5
#define E_PWR_NOT_IDLE_STATE            6
#define E_PWR_NOT_INIT_DONE             7
#define E_PWR_NOT_INIT_DONE_READ        8
#define E_PWR_WAIT_IDLE_TIMEOUT         9
#define E_PWR_WAIT_IDLE_TIMEOUT_READ    10
#define E_PWR_INIT_SIDLY_FAIL           11
#define E_PWR_RESET_TIMEOUT             12
#define E_PWR_TIMEOUT                   13

#define E_PWR_INIT_RESET_SPI            20
#define E_PWR_INIT_SIDLY                21
#define E_PWR_INIT_REG_CLOCK            22
#define E_PWR_INIT_ENABLE_PMIC          23
#define E_PWR_INIT_DIO                  24
#define E_PWR_INIT_CIPHER               25
#define E_PWR_INIT_WRITE_TEST           26
#define E_PWR_INIT_ENABLE_CRC           27
#define E_PWR_INIT_ENABLE_DEWRAP        28

#define E_PWR_READ_TEST_FAIL            30
#define E_PWR_WRITE_TEST_FAIL           31
#define E_PWR_SWITCH_DIO                32

/* -----macro for read/write register -------------------------------------------------------- */

/* #define WRAP_RD32(addr)            (*(volatile u32 *)(addr)) */
/* #define WRAP_WR32(addr,data)       ((*(volatile u32 *)(addr)) = (u32)data) */

/* #define WRAP_SET_BIT(BS,REG)       ((*(volatile u32*)(REG)) |= (u32)(BS)) */
/* #define WRAP_CLR_BIT(BS,REG)       ((*(volatile u32*)(REG)) &= ~((u32)(BS))) */

#define WRAP_RD32(addr)            __raw_readl((void *)addr)
#define WRAP_WR32(addr, val)        mt_reg_sync_writel((val), ((void *)addr))

#define WRAP_SET_BIT(BS, REG)       mt_reg_sync_writel((__raw_readl((void *)REG) | (u32)(BS)), ((void *)REG))
#define WRAP_CLR_BIT(BS, REG)       mt_reg_sync_writel((__raw_readl((void *)REG) & (~(u32)(BS))), ((void *)REG))

/* -----------------soft reset -------------------------------------------------------- */
#define INFRA_GLOBALCON_RST0               (INFRACFG_AO_REG_BASE+0x030)
#define INFRA_GLOBALCON_RST1               (INFRACFG_AO_REG_BASE+0x034)


#define PWRAP_SOFT_RESET                   WRAP_SET_BIT(1<<7, INFRA_GLOBALCON_RST0)
#define PWRAP_CLEAR_SOFT_RESET_BIT         WRAP_CLR_BIT(1<<7, INFRA_GLOBALCON_RST1)
#define PERI_GLOBALCON_RST1                (PERICFG_BASE+0x004)

#endif /* __PMIC_WRAP_REGS_H__ */
