//modify@zte.com.cn add at 20160311 begin
#ifndef BUILD_LK
#include <linux/string.h>
#endif
#include "lcm_drv.h"

//modify@zte.com.cn modify at 20160218 begin

#ifdef BUILD_LK
#include <platform/gpio_const.h>
#include <platform/mt_gpio.h>
#include <platform/upmu_common.h>
#include <cust_gpio_usage.h>
#else
#include <mach/gpio_const.h>
#include <mt-plat/mt_gpio.h>
//#include <cust_gpio_usage.h>
#include <linux/string.h>
#endif
//modify@zte.com.cn modify at 20160218 end
//modify@zte.com.cn modify at 20160328 begin
#define LCM_ID_OTM1287 		0x1287
#define LCM_ID_R68200 0x80	//modify@zte.com.cn 20151125
//modify@zte.com.cn modify at 20160328 end
const static unsigned char LCD_MODULE_ID = 0x00; //0x05 modify@zte.com.cn 20151207
static unsigned char  lcd_typpe_id= 0; //modify@zte.com.cn 20150702
// ---------------------------------------------------------------------------
//  Local Constants
// ---------------------------------------------------------------------------
#define LCM_DSI_CMD_MODE									0
#define FRAME_WIDTH  										(720)
#define FRAME_HEIGHT 										(1280)


#define REGFLAG_DELAY             								0xFC
#define REGFLAG_END_OF_TABLE      							0xFD   // END OF REGISTERS MARKER

#ifndef TRUE
    #define TRUE 1
#endif

#ifndef FALSE
    #define FALSE 0
#endif

//static unsigned int lcm_esd_test = FALSE;      ///only for ESD test
// ---------------------------------------------------------------------------
//  Local Variables
// ---------------------------------------------------------------------------


static LCM_UTIL_FUNCS lcm_util;

#define __SAME_IC_COMPATIBLE__

#define GPIO_LCM_PWR_EN   (119 | 0x80000000)
#define SET_RESET_PIN(v)    								(lcm_util.set_reset_pin((v)))
#define MDELAY(n) 											(lcm_util.mdelay(n))

// ---------------------------------------------------------------------------
//  Local Functions
// ---------------------------------------------------------------------------

#define dsi_set_cmdq_V2(cmd, count, ppara, force_update)	lcm_util.dsi_set_cmdq_V2(cmd, count, ppara, force_update)
#define dsi_set_cmdq(pdata, queue_size, force_update)		lcm_util.dsi_set_cmdq(pdata, queue_size, force_update)
#define wrtie_cmd(cmd)										lcm_util.dsi_write_cmd(cmd)
#define write_regs(addr, pdata, byte_nums)					lcm_util.dsi_write_regs(addr, pdata, byte_nums)
#define read_reg											lcm_util.dsi_read_reg()
#define read_reg_v2(cmd, buffer, buffer_size)				lcm_util.dsi_dcs_read_lcm_reg_v2(cmd, buffer, buffer_size)

 struct LCM_setting_table {
    unsigned cmd;
    unsigned char count;
    unsigned char para_list[64];
};

/* wenggaojian@wind -mobi.com 20150702 begin */
//init code for otp module
#if 0
static struct LCM_setting_table lcm_initialization_setting_otp[] = {
	{0x00,1,{0x00}},
	{0xff,3,{0x12,0x85,0x01}},//EXTC=1

	{0x00,1,{0x80}},//Orise,mode,enable
	{0xff,2,{0x12,0x85}},

	{0x00,1,{0x80}},//TCON,Setting,(RTN,
	{0xc0,2,{0x00,0x7F}},

	{0x00,1,{0x82}},//TCON,Setting,(VFP,VBP,
	{0xc0,3,{0x00,0x0c,0x08}},

	{0x00,1,{0x90}},//,Oscillator,Divided,mclk/pclk=6+1=7,(defaul=8+1=9,
	{0xc1,1,{0x55}},

	{0x00,1,{0xB3}},
	{0xc0,1,{0x33}},//(0xc0,0x33,0x10}},//180

	{0x00,1,{0x80}},//,Oscillator,idle/norm/pwron/vdo,64.61MHz
	{0xc1,4,{0x11,0x11,0x11,0x11}},

	{0x00,1,{0x90}},
	{0xc2,10,{0x86,0x20,0x00,0x0F,0x00,0x87,0x20,0x00,0x0F,0x00}},//CKV1/2,shift,switch,width,chop_t1,shift_t2

	{0x00,1,{0xec}},//duty,block,block,width?
	{0xc2,1,{0x00}},

	{0x00,1,{0x80}},//,LTPS,STV,Setting
	{0xc2,4,{0x82,0x01,0x08,0x08}},

	{0x00,1,{0xa0}},
	{0xc0,7,{0x00,0x0f,0x00,0x00,0x0a,0x1A,0x00}},//CKH

	{0x00,1,{0xfb}},//PCH_SET
	{0xc2,1,{0x80}},


	{0x00,1,{0x80}},
	{0xcc,12,{0x03,0x04,0x01,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b}},//Step1:SIGIN_SEL,U2D

	{0x00,1,{0xb0}},
	{0xcc,12,{0x04,0x03,0x01,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b}},//Step1:(add,SIGIN_SEL,D2U
	{0x00,1,{0x80}},
	{0xcd,15,{0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x15,0x0B,0x0b,0x12,0x13,0x14,0x0b,0x0b,0x0b}},//Step1:SIGIN_SEL
	{0x00,1,{0xc0}},
	{0xcb,15,{0x05,0x05,0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},//try,Step2:ENMODE,(address,1-27åœ¨å„?stateç‹€æ…‹,
	{0x00,1,{0xd0}},
	{0xcb,15,{0x00,0x00,0x00,0x0A,0x05,0x00,0x05,0x05,0x05,0x00,0x00,0x00,0x00,0x00,0x00}},//Step2:ENMODE,(address,1-27åœ¨å„?stateç‹€æ…‹,
	{0x00,1,{0xe0}},
	{0xcc,4,{0x00,0x00,0x00,0x00}},//Step3:Hi-Z,mask,(è‹¥reg_hiz,=,0ï¼Œå‰‡ç¶­æŒSTEP2çš„è¨­å®š,
	{0x00,1,{0xd0}},
	{0xcd,15,{0x01,0x02,0x04,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f}},//Step4:æ±ºå®šaddress1-27,mapping,åˆ°,R_CGOUT1-15
	{0x00,1,{0xe0}},
	{0xcd,12,{0x10,0x11,0x12,0x13,0x03,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b}},//Step4:æ±ºå®šaddress1-27,mapping,åˆ°,R_CGOUT16-27
	{0x00,1,{0xa0}},
	{0xcd,15,{0x01,0x02,0x04,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f}},//(add,Step4:æ±ºå®šaddress1-27,mapping,åˆ°,L_CGOUT1-15
	{0x00,1,{0xb0}},
	{0xcd,12,{0x10,0x11,0x12,0x13,0x03,0x15,0x16,0x17,0x18,0x19,0x1a,0x1b}},//(add,Step4:æ±ºå®šaddress1-27,mapping,åˆ°,L_CGOUT16-27

	{0x00,1,{0x00}},//,set,GVDD/NGVDD=+/-4.8V(measure=+/-,
	{0xD8,2,{0x34,0x34}},

	{0x00,1,{0x90}},//,power,control,setting,for,normal,mode}},,(set,AVDD,VGL,VGH,AVDD,NAVDD,
	{0xC5,6,{0xB2,0xD6,0xA0,0x0F,0xA0,0x14}},//,AVDD,clamp,at,6V,AVDD=2VCI}},,VGH=4xVCI,VGHS=,8.1V}},VGL_DM=3xVCI,VGLS=,-8V
	{0x00,1,{0x96}},
	{0xc5,4,{0xa0,0x0d,0xaa,0x0c}},
	{0x00,1,{0xc2}},
	{0xc5,1,{0x08}},

	{0x00,1,{0xA8}},
	{0xc4,1,{0x11}},

	{0x00,1,{0xc1}},
	{0xc5,1,{0x33}},//VDD_18/LVDSVDD=1.6V
	{0x00,1,{0xa3}},
	{0xc5,1,{0x0f}},
	{0x00,1,{0xa5}},
	{0xc5,5,{0x0f,0xa0,0x0d,0xaa,0x0c}},


	{0x00,1,{0x90}},
	{0xf5,14,{0x03,0x15,0x09,0x15,0x07,0x15,0x0c,0x15,0x0a,0x15,0x09,0x15,0x0a,0x15}},
	{0x00,1,{0xa0}},
	{0xf5,14,{0x12,0x11,0x03,0x15,0x09,0x15,0x11,0x15,0x08,0x15,0x07,0x15,0x09,0x15}},
	{0x00,1,{0xc0}},
	{0xf5,14,{0x0e,0x15,0x0e,0x15,0x00,0x15,0x00,0x15,0x0e,0x15,0x14,0x11,0x00,0x15}},
	{0x00,1,{0xd0}},
	{0xf5,15,{0x07,0x15,0x0a,0x15,0x10,0x11,0x00,0x10,0x90,0x90,0x90,0x02,0x90,0x00,0x00}},

	{0x00,1,{0x80}},
	{0xC4,1,{0x00}},
	/* modify@zte.com.cn 2015.6.9 begin */
	{0x00, 1 , {0x81}},   
	{0xC4,  1 ,{0x24}},

	{0x00, 1 , {0x9D}},
	{0xC5,  1 ,{0xAA}},

	{0x00, 1 , {0x92}},
	{0xE9,  1 ,{0x10}},
	/* modify@zte.com.cn 2015.6.9 end */
	{0x00,1,{0x00}},	
	{0xE1,24,{0x00,0x5f,0x62,0x69,0x6e,0x73,0x7b,0x88,0x8d,0x9c,0xa3,0xa9,0x52,0x4e,0x4d,0x41,0x35,0x26,0x1e,0x18,0x12,0x0a,0x06,0x01}},	
	{0x00,1,{0x00}},	
	{0xE2,24,{0x00,0x5f,0x62,0x69,0x6e,0x73,0x7b,0x88,0x8d,0x9c,0xa3,0xa9,0x52,0x4e,0x4d,0x41,0x35,0x26,0x1e,0x18,0x12,0x0a,0x06,0x01}},		
	{0x00,1,{0x00}},	
	{0xE3,24,{0x76,0x79,0x7b,0x7e,0x81,0x85,0x8a,0x94,0x96,0xa2,0xa8,0xac,0x50,0x4d,0x4d,0x41,0x35,0x26,0x1e,0x18,0x12,0x0a,0x06,0x01}},	
	{0x00,1,{0x00}},	
	{0xE4,24,{0x76,0x79,0x7b,0x7e,0x81,0x85,0x8a,0x94,0x96,0xa2,0xa8,0xac,0x50,0x4d,0x4d,0x41,0x35,0x26,0x1e,0x18,0x12,0x0a,0x06,0x01}},	
	{0x00,1,{0x00}},
	{0xE5,24,{0x76,0x79,0x7b,0x7e,0x81,0x85,0x8a,0x94,0x96,0xa2,0xa8,0xac,0x50,0x4d,0x4d,0x41,0x35,0x26,0x1e,0x18,0x12,0x0a,0x06,0x01}},	
	{0x00,1,{0x00}},	
	{0xE6,24,{0x76,0x79,0x7b,0x7e,0x81,0x85,0x8a,0x94,0x96,0xa2,0xa8,0xac,0x50,0x4d,0x4d,0x41,0x35,0x26,0x1e,0x18,0x12,0x0a,0x06,0x01}},	

	{0x00,1,{0x00}},
	{0xff,3,{0x00,0x00,0x00}},
	{0x36,1,{0x01}},
	{0x11,	1,		{0x00}},       
	{REGFLAG_DELAY, 120, {}},		
	{0x29,	1,		{0x00}},	        
	{REGFLAG_DELAY, 20, {}},	      
	{REGFLAG_END_OF_TABLE, 0x00, {}}

};
#endif
/* wenggaojian@wind -mobi.com 20150702 end */

static struct LCM_setting_table lcm_initialization_setting[] = {
#if 0
		{0x00, 1, {0x00}},
		{0x00, 0, {0x00}},
	
		{0x00, 1, {0x00}},
		{0xff, 3, {0x12,0x87,0x01}},
	
		{0x00, 1, {0x80}},
		{0xff, 2, {0x12,0x87}},
	
		{0x00, 1, {0x92}},
		{0xff, 2, {0x30,0x02}},
	
		{0x00, 1, {0x80}},
		{0xc0, 9, {0x00,0x64,0x00,0x0f,0x11,0x00,0x64,0x0f,0x11}},
	
		{0x00, 1, {0x90}},
		{0xc0, 6, {0x00,0x5c,0x00,0x01,0x00,0x04}},
	
		{0x00, 1, {0xa4}},
		{0xc0, 1, {0x00}},
	
		{0x00, 1, {0xb3}},
		{0xc0, 2, {0x00,0x55}},
	
		{0x00, 1, {0x81}},
		{0xc1, 1, {0x55}},
	
		{0x00, 1, {0x90}},
		{0xf5, 4, {0x02,0x11,0x02,0x15}},
	
		{0x00, 1, {0x90}},
		{0xc5, 1, {0x50}},
	
		{0x00, 1, {0x94}},
		{0xc5, 1, {0x66}},
	
		{0x00, 1, {0xb2}},
		{0xf5, 2, {0x00,0x00}},
	
		{0x00, 1, {0xb6}},
		{0xf5, 2, {0x00,0x00}},
	
		{0x00, 1, {0x94}},
		{0xf5, 2, {0x00,0x00}},
	
		{0x00, 1, {0xd2}},
		{0xf5, 2, {0x06,0x15}},
	
		{0x00, 1, {0xb4}},
		{0xc5, 1, {0xcc}},
	
		{0x00, 1, {0xa0}},
		{0xc4, 14, {0x05,0x10,0x06,0x02,0x05,0x15,0x10,0x05,0x10,0x07,0x02,0x05,0x15,0x10}},
	
		{0x00, 1, {0xb0}},
		{0xc4, 2, {0x00,0x00}},
	
		{0x00, 1, {0x91}},
		{0xc5, 2, {0x16,0x52}},
	
		{0x00, 1, {0x00}},
		{0xd8, 2, {0x73,0x73}},
	
		{0x00, 1, {0xb3}},
		{0xc5, 1, {0x84}},
	
		{0x00, 1, {0xbb}},
		{0xc5, 1, {0x8a}},
	
		{0x00, 1, {0x82}},
		{0xc4, 1, {0x0a}},
	
		{0x00, 1, {0xc6}},
		{0xb0, 1, {0x03}},
	
		{0x00, 1, {0xb2}},
		{0xc5, 1, {0x80}},
	
		{0x00, 1, {0x00}},
		{0xe1, 20, {0x0a,0x13,0x1a,0x22,0x2f,0x3a,0x3a,0x64,0x57,0x72,0x8f,0x78,0x87,0x5d,0x57,0x46,0x34,0x24,0x08,0x05}},
	
		{0x00, 1, {0x00}},
		{0xe2, 20, {0x0a,0x13,0x1b,0x22,0x2f,0x3a,0x3a,0x65,0x57,0x72,0x8f,0x78,0x87,0x5d,0x57,0x46,0x34,0x24,0x08,0x05}},
	
		{0x00, 1, {0x00}},
		{0xd9, 1, {0x55}},
	
		{0x00, 1, {0x80}},
		{0xcb, 11, {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
	
		{0x00, 1, {0x90}},
		{0xcb, 15, {0x00,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
	
		{0x00, 1, {0xa0}},
		{0xcb, 15, {0x00,0x00,0x00,0x00,0x00,0xff,0x05,0x00,0x05,0x05,0x05,0x05,0x05,0x05,0x05}},
	
		{0x00, 1, {0xb0}},
		{0xcb, 14, {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x05}},
	
		{0x00, 1, {0xc0}},
		{0xcb, 15, {0x00,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
	
		{0x00, 1, {0xd0}},
		{0xcb, 15, {0x00,0x00,0x00,0x00,0x00,0xff,0x05,0x00,0x05,0x05,0x05,0x05,0x05,0x05,0x05}},
	
		{0x00, 1, {0xe0}},
		{0xcb, 14, {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x05}},
	
		{0x00, 1, {0xf0}},
		{0xcb, 11, {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff}},
	
		{0x00, 1, {0x80}},
		{0xcc, 15, {0x00,0x2d,0x04,0x02,0x0e,0x10,0x0a,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
	
		{0x00, 1, {0x90}},
		{0xcc, 15, {0x00,0x00,0x00,0x00,0x00,0x00,0x2e,0x00,0x2d,0x03,0x01,0x0d,0x0f,0x09,0x0b}},
	
		{0x00, 1, {0xa0}},
		{0xcc, 14, {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x2e}},
	
		{0x00, 1, {0xb0}},
		{0xcc, 15, {0x00,0x2e,0x01,0x03,0x0a,0x09,0x0f,0x0d,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
	
		{0x00, 1, {0xc0}},
		{0xcc, 15, {0x00,0x00,0x00,0x00,0x00,0x00,0x2d,0x00,0x2e,0x02,0x04,0x0c,0x0b,0x10,0x0e}},
	
		{0x00, 1, {0xd0}},
		{0xcc, 14, {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x2d}},
	
		{0x00, 1, {0x80}},
		{0xce, 12, {0x89,0x03,0x29,0x88,0x03,0x29,0x87,0x03,0x29,0x86,0x03,0x29}},
	
		{0x00, 1, {0x90}},
		{0xce, 14, {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
	
		{0x00, 1, {0xa0}},
		{0xce, 14, {0x38,0x07,0x04,0xfc,0x00,0x29,0x00,0x38,0x06,0x04,0xfd,0x00,0x29,0x00}},
	
		{0x00, 1, {0xb0}},
		{0xce, 14, {0x38,0x05,0x04,0xfe,0x00,0x29,0x00,0x38,0x04,0x04,0xff,0x00,0x29,0x00}},
	
		{0x00, 1, {0xc0}},
		{0xce, 14, {0x38,0x03,0x05,0x00,0x00,0x29,0x00,0x38,0x02,0x05,0x01,0x00,0x29,0x00}},
	
		{0x00, 1, {0xd0}},
		{0xce, 14, {0x38,0x01,0x05,0x02,0x00,0x29,0x00,0x38,0x00,0x05,0x03,0x00,0x29,0x00}},
	
		{0x00, 1, {0x80}},
		{0xcf, 14, {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
	
		{0x00, 1, {0x90}},
		{0xcf, 14, {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
	
		{0x00, 1, {0xa0}},
		{0xcf, 14, {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
	
		{0x00, 1, {0xb0}},
		{0xcf, 14, {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
	
		{0x00, 1, {0xc0}},
		{0xcf, 11, {0x01,0x01,0x20,0x20,0x00,0x00,0x01,0x00,0x00,0x00,0x10}},
	
		{0x00, 1, {0xb5}},
		{0xc5, 6, {0x3c,0x01,0xff,0x3c,0x01,0xff}},
	
		{0x00, 1, {0x00}},
		{0xff, 3, {0xff,0xff,0xff}},
	
		{0x11,	1,		{0x00}},	   
		{REGFLAG_DELAY, 120, {}},		
		{0x29,	1,		{0x00}},	
#else
	{0x00, 1 , {0x00}},
	{0xFF,	3 ,{0x12,0x87,0x01}},
	
	{0x00, 1 , {0x80}},
	{0xFF,	2 ,{0x12,0x87}},
	
	{0x00, 1 , {0x92}},
	{0xFF,	2 ,{0x30,0x02}},
	
	{0x00, 1 , {0x91}},
	{0xB0,	1 ,{0x92}},
	
	{0x00, 1 , {0x80}},
	{0xC0,	9 ,{0x00,0x64,0x00,0x0F,0x11,0x00,0x64,0x0F,0x11}},
	
	{0x00, 1 , {0x90}},
	{0xC0,	6 ,{0x00,0x5C,0x00,0x01,0x00,0x04}},
	
	{0x00, 1 , {0xA4}},
	{0xC0,	1 ,{0x00}},
	
	{0x00, 1 , {0xB3}},
	{0xC0,	2 ,{0x00,0x55}},
	
	{0x00, 1 , {0x81}},
	{0xC1,	1 ,{0x55}},
	
	{0x00, 1 , {0x90}},
	{0xF5,	4 ,{0x02,0x11,0x02,0x15}},
	
	{0x00, 1 , {0x90}},
	{0xC5,	1 ,{0x50}},
	
	{0x00, 1 , {0x94}},
	{0xC5,	1 ,{0x66}},
	
	{0x00, 1 , {0xB2}},
	{0xF5,	2 ,{0x00,0x00}},
	
	{0x00, 1 , {0xB6}},
	{0xF5,	2 ,{0x00,0x00}},
	
	{0x00, 1 , {0x94}},
	{0xF5,	2 ,{0x00,0x00}},
	
	{0x00, 1 , {0xD2}},
	{0xF5,	2 ,{0x06,0x15}},
	
	{0x00, 1 , {0xB4}},
	{0xC5,	1 ,{0xCC}},
	
	{0x00, 1 , {0xA0}},
	{0xC4, 14 ,{0x05,0x10,0x06,0x02,0x05,0x15,0x10,0x05,0x10,0x07,0x02,0x05,0x15,0x10}},
	
	{0x00, 1 , {0xB0}},
	{0xC4,	2 ,{0x00,0x00}},
	
	{0x00, 1 , {0x91}},
	{0xC5,	2 ,{0x19,0x52}},
	
	{0x00, 1 , {0x00}},
	{0xD8,	2 ,{0x9C,0x9C}},//modify@zte.com.cn 20160616
	
	{0x00, 1 , {0xB3}},
	{0xC5,	1 ,{0x84}},
	
	{0x00, 1 , {0xBB}},
	{0xC5,	1 ,{0x8A}},
	
	{0x00, 1 , {0xB2}},
	{0xC5,	1 ,{0x40}},
	
	{0x00, 1 , {0x81}},
	{0xC4,	2 ,{0x82,0x0A}},
	
	{0x00, 1 , {0xC6}},
	{0xB0,	1 ,{0x03}},
	
	{0x00, 1 , {0x83}}, 
	{0xC1, 2 ,{0x30,0x70}}, 
	
	{0x00, 1 , {0x85}}, 
	{0xC1, 1 ,{0x03}},
	
	{0x00, 1 , {0x00}},
{0xE1, 20 ,{0x05,0x34,0x40,0x4f,0x5d,0x6a,0x6c,0x94,0x83,0x9b,0x6b,0x57,0x6b,0x49,0x48,0x3a,0x2c,0x1d,0x11,0x09}}, //modify@zte.com.cn modify at 20160328
	
	{0x00, 1 , {0x00}},
{0xE2, 20 ,{0x05,0x34,0x40,0x4f,0x5d,0x6a,0x6c,0x94,0x83,0x9b,0x6b,0x57,0x6b,0x49,0x48,0x3a,0x2c,0x1d,0x11,0x09}}, //modify@zte.com.cn modify at 20160328
	
	{0x00, 1 , {0x80}},
	{0xCB, 11 ,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
	
	{0x00, 1 , {0x90}},
	{0xCB, 15 ,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
	
	{0x00, 1 , {0xA0}},
	{0xCB, 15 ,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
	
	{0x00, 1 , {0xB0}},
	{0xCB, 15 ,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
	
	{0x00, 1 , {0xC0}},
	{0xCB, 15 ,{0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x00,0x00,0x00,0x00,0x00,0x00}},
	
	{0x00, 1 , {0xD0}},
	{0xCB, 15 ,{0x00,0x00,0x00,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05,0x05}},
	
	{0x00, 1 , {0xE0}},
	{0xCB, 14 ,{0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x05,0x05,0x05}},
	
	{0x00, 1 , {0xF0}},
	{0xCB, 11 ,{0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF}},
	
	{0x00, 1 , {0x80}},
	{0xCC, 15 ,{0x2D,0x2D,0x0A,0x0C,0x0E,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
	
	{0x00, 1 , {0x90}},
	{0xCC, 15 ,{0x00,0x00,0x00,0x2E,0x2E,0x02,0x04,0x2D,0x2D,0x09,0x0B,0x0D,0x0F,0x00,0x00}},
	
	{0x00, 1 , {0xA0}},
	{0xCC, 14 ,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x2E,0x2E,0x01,0x03}},
	
	{0x00, 1 , {0xB0}},
	{0xCC, 15 ,{0x2D,0x2E,0x0F,0x0D,0x0B,0x09,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
	
	{0x00, 1 , {0xC0}},
	{0xCC, 15 ,{0x00,0x00,0x00,0x2E,0x2D,0x03,0x01,0x2D,0x2E,0x10,0x0E,0x0C,0x0A,0x00,0x00}},
	
	{0x00, 1 , {0xD0}},
	{0xCC, 14 ,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x2E,0x2D,0x04,0x02}},
	
	{0x00, 1 , {0x80}},
	{0xCE, 12 ,{0x8D,0x03,0x29,0x8C,0x03,0x29,0x8B,0x03,0x29,0x8A,0x03,0x29}},
	
	{0x00, 1 , {0x90}},
	{0xCE, 14 ,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
	
	{0x00, 1 , {0xA0}},
	{0xCE, 14 ,{0x38,0x0B,0x8D,0x00,0x8D,0x29,0x00,0x38,0x0A,0x8D,0x01,0x8D,0x29,0x00}},
	
	{0x00, 1 , {0xB0}},
	{0xCE, 14 ,{0x38,0x09,0x8D,0x02,0x8D,0x29,0x00,0x38,0x08,0x8D,0x03,0x8D,0x29,0x00}},
	
	{0x00, 1 , {0xC0}},
	{0xCE, 14 ,{0x38,0x07,0x8D,0x04,0x8D,0x29,0x00,0x38,0x06,0x8D,0x05,0x8D,0x29,0x00}},
	
	{0x00, 1 , {0xD0}},
	{0xCE, 14 ,{0x38,0x05,0x8D,0x06,0x8D,0x29,0x00,0x38,0x04,0x8D,0x07,0x8D,0x29,0x00}},
	
	{0x00, 1 , {0x80}},
	{0xCF, 14 ,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
	
	{0x00, 1 , {0x90}},
	{0xCF, 14 ,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
	
	{0x00, 1 , {0xA0}},
	{0xCF, 14 ,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
	
	{0x00, 1 , {0xB0}},
	{0xCF, 14 ,{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}},
	
	{0x00, 1 , {0xC0}},
	{0xCF, 11 ,{0x01,0x01,0x20,0x20,0x00,0x00,0x01,0x01,0x00,0x00,0x00}},
	
	{0x00, 1 , {0xB5}},
	{0xC5,	6 ,{0x3C,0x01,0xFF,0x3C,0x01,0xFF}},
	
	{0x00, 1 , {0xA0}},
	{0xD6, 12 ,{0x01,0x0D,0x01,0x0D,0x01,0x66,0x01,0xC0,0x01,0xC0,0x01,0xC0}},
	
	{0x00, 1 , {0xB0}},
	{0xD6, 12 ,{0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0,0x01,0xC0}},
	
	{0x00, 1 , {0xC0}},
	{0xD6, 12 ,{0x26,0x11,0x09,0x80,0x11,0x80,0x80,0x11,0x80,0x80,0x11,0x80}},
	
	{0x00, 1 , {0xD0}},
	{0xD6,	6 ,{0x80,0x11,0x80,0x80,0x11,0x80}},
	
	{0x00, 1 , {0xE0}},
	{0xD6, 12 ,{0x22,0x11,0x40,0x40,0x11,0x40,0x40,0x11,0x40,0x40,0x11,0x40}},
	
	{0x00, 1 , {0xF0}},
	{0xD6,	6 ,{0x40,0x11,0x40,0x40,0x11,0x40}},
	
	{0x00, 1 , {0xD0}},
	{0xD9,	2 ,{0xAA,0xAA}},
	
	{0x00, 1 , {0xB1}},
	{0xC6,	1 ,{0x01}},
	
	{0x00, 1 , {0xB4}},
	{0xC6,	1 ,{0x10}},
	//modify@zte.com.cn modify at 20160328 begin
	{0x00, 1 , {0xA0}},
	{0xC1,  1 ,{0x02}},
	//modify@zte.com.cn modify at 20160328 end
	{0x00, 1 , {0xA2}},
	{0xC1,	1 ,{0x08}},
	
	{0x00, 1 , {0xA4}},
	{0xC1,	1 ,{0xF0}},
	
	{0x00, 1 , {0x92}},
	{0xB3,	1 ,{0x02}},
	
	{0x00, 1 , {0x96}},
	{0xB6,	1 ,{0xB6}},
	
//modify@zte.com.cn 20160616 start
{0x00, 1 , {0x87}},
{0xc4,  1 ,{0x18}},	
//modify@zte.com.cn 20160616 end
	{0x00, 1 , {0x80}},
	{0xFF,	2 ,{0xFF,0xFF}},
	
	{0x00, 1 , {0x00}},
	{0xFF,	3 ,{0xFF,0xFF,0xFF}},
	
	{0x00, 1 , {0x00}},
	{0x81,	1 ,{0x81}},
	
	{0x00, 1 , {0x00}},
	{0x35,  1 ,{0x00}},	//modify@zte.com.cn modify at 20160328
	
	{0x00, 1 , {0x00}}, //modify@zte.com.cn modify at 20160328
	{0x11, 1 , {0x00}},
	{REGFLAG_DELAY, 120, {}},		
	
	{0x00, 1 , {0x00}},
	{0x29, 1 , {0x00}},
	
#endif

	{REGFLAG_DELAY, 20, {}},	      
	{REGFLAG_END_OF_TABLE, 0x00, {}}

};
#if 0
static struct LCM_setting_table lcm_sleep_out_setting[] = {
    //Sleep Out
    {0x11, 1, {0x00}},
    {REGFLAG_DELAY, 120, {}},

    // Display ON
    {0x29, 1, {0x00}},
    {REGFLAG_DELAY, 20, {}},
    {REGFLAG_END_OF_TABLE, 0x00, {}}
};
#endif

static struct LCM_setting_table lcm_deep_sleep_mode_in_setting[] = {
    // Display off sequence
    {0x28, 1, {0x00}},
    {REGFLAG_DELAY, 20, {}},

    // Sleep Mode On
    {0x10, 1, {0x00}},
    {REGFLAG_DELAY, 120, {}},
    {REGFLAG_END_OF_TABLE, 0x00, {}}
};

static void push_table(struct LCM_setting_table *table, unsigned int count, unsigned char force_update)
{
    unsigned int i;

    for(i = 0; i < count; i++)
    {
        unsigned cmd;
        cmd = table[i].cmd;

        switch (cmd) {
			
            case REGFLAG_DELAY :
                MDELAY(table[i].count);
                break;
				
            case REGFLAG_END_OF_TABLE :
                break;

            default:
                dsi_set_cmdq_V2(cmd, table[i].count, table[i].para_list, force_update);
        }
    }
}

// ---------------------------------------------------------------------------
//  LCM Driver Implementations
// ---------------------------------------------------------------------------

static void lcm_set_util_funcs(const LCM_UTIL_FUNCS *util)
{
    	memcpy(&lcm_util, util, sizeof(LCM_UTIL_FUNCS));
}

static void lcm_get_params(LCM_PARAMS *params)
{
	memset(params, 0, sizeof(LCM_PARAMS));
	params->type   = LCM_TYPE_DSI;

	params->width  = FRAME_WIDTH;
	params->height = FRAME_HEIGHT;

	params->dbi.te_mode				= LCM_DBI_TE_MODE_VSYNC_ONLY;
	//LCM_DBI_TE_MODE_DISABLED;
	//LCM_DBI_TE_MODE_VSYNC_ONLY;  
	params->dbi.te_edge_polarity		= LCM_POLARITY_RISING; 
	/////////////////////   
	//if(params->dsi.lcm_int_te_monitor)  
	//params->dsi.vertical_frontporch *=2;  
	//params->dsi.lcm_ext_te_monitor= 0;//TRUE;
	//modify@zte.com.cn begin
//	params->dsi.noncont_clock= TRUE;//FALSE;    //modify yudengwu
//	params->dsi.noncont_clock_period=2;    //modify yudengwu
	params->dsi.cont_clock=1;    // modify@zte.com.cn add 20160411
	//modify@zte.com.cn end
	////////////////////          
	params->dsi.mode   = SYNC_PULSE_VDO_MODE;  
	// DSI    /* Command mode setting */  
	params->dsi.LANE_NUM				= LCM_FOUR_LANE;      
	//The following defined the fomat for data coming from LCD engine.  
	params->dsi.data_format.color_order = LCM_COLOR_ORDER_RGB;   
	params->dsi.data_format.trans_seq	= LCM_DSI_TRANS_SEQ_MSB_FIRST; 
	params->dsi.data_format.padding 	= LCM_DSI_PADDING_ON_LSB;    
	params->dsi.data_format.format	  = LCM_DSI_FORMAT_RGB888;       
	// Video mode setting		   
	params->dsi.intermediat_buffer_num = 2;  
	params->dsi.PS=LCM_PACKED_PS_24BIT_RGB888;  
	params->dsi.packet_size=256;    
	// params->dsi.word_count=480*3;	
	//DSI CMD mode need set these two bellow params, different to 6577   
	// params->dsi.vertical_active_line=800;   
	params->dsi.vertical_sync_active				= 8; //4   
	params->dsi.vertical_backporch				       = 16;  //14  
	params->dsi.vertical_frontporch				       = 16;  //16  
	params->dsi.vertical_active_line				       = FRAME_HEIGHT;     
	params->dsi.horizontal_sync_active				= 8;   //4
	//modify@zte.com.cn modify at 20160328 begin
	params->dsi.horizontal_backporch				= 90;  //60   
	params->dsi.horizontal_frontporch				= 90;    //60
	params->dsi.horizontal_blanking_pixel				= 60;   
	params->dsi.horizontal_active_pixel				= FRAME_WIDTH;  

	//	params->dsi.pll_div1=1;		   
	//	params->dsi.pll_div2=1;		   
	//	params->dsi.fbk_div =28;//28	
	//modify@zte.com.cn 20140820 beign
	// To fix boot error
	//modify@zte.com.cn remove at 20160411 begin
	params->dsi.PLL_CLOCK = 195;	   // 217 
//	params->dsi.ssc_disable= 0;
//	params->dsi.ssc_range= 4;
	//modify@zte.com.cn remove at 20160411 end

	//params->dsi.ss
	//params->dsi.CLK_TRAIL = 17;

	//modify@zte.com.cn 20140820 end
	params->dsi.esd_check_enable = 1;
	params->dsi.customization_esd_check_enable = 1;
	params->dsi.lcm_esd_check_table[0].cmd                  = 0x0a;
	params->dsi.lcm_esd_check_table[0].count                = 1;
	params->dsi.lcm_esd_check_table[0].para_list[0] = 0x9C;
	
	params->dsi.lcm_esd_check_table[1].cmd                  = 0x0e;
	params->dsi.lcm_esd_check_table[1].count                = 1;
	params->dsi.lcm_esd_check_table[1].para_list[0] = 0x80;	
	//modify@zte.com.cn modify at 20160328 end
}

//modify@zte.com.cn modify at 20160328 begin
static unsigned int lcm_compare_id(void)
{
	unsigned int id = 0;
	unsigned int id1 = 0;
	unsigned int id2 = 0;
	unsigned char buffer[4];
	unsigned int array[16];
//	unsigned char LCD_ID_value = 0;
	mt_set_gpio_mode(GPIO_LCM_PWR_EN, GPIO_MODE_00);
	mt_set_gpio_dir(GPIO_LCM_PWR_EN, GPIO_DIR_OUT);
	mt_set_gpio_out(GPIO_LCM_PWR_EN, GPIO_OUT_ONE);
	MDELAY(10);
		
	SET_RESET_PIN(1);  //NOTE:should reset LCM firstly
	SET_RESET_PIN(0);
	MDELAY(1);
	SET_RESET_PIN(1);
	MDELAY(150);


	array[0] = 0x00043700;// read id return two byte,version and id

	dsi_set_cmdq(array, 1, 1);

	read_reg_v2(0xA1, buffer, 4); //IC id:0XA1

	id1 = buffer[2]; //we only need ID
	id2 = buffer[3];

	id=(id1<<8)|id2;
	lcd_typpe_id = buffer[0]; //modify@zte.com.cn 20150702
#ifdef BUILD_LK
	printf("%s,%s,  lk --- id otm1287a= 0x%08x,id1=0x%x,id2=0x%x\n", __FILE__,__func__, id,id1,id2);
#endif


	if(LCM_ID_OTM1287 == id)  //modify@zte.com.cn 20160302
	{
			return 1;

	}
	else
	{
		return 0;
	}
}
//modify@zte.com.cn modify at 20160328 end

static void lcm_init(void)
{
	
	mt_set_gpio_mode(GPIO_LCM_PWR_EN, GPIO_MODE_00);
	mt_set_gpio_dir(GPIO_LCM_PWR_EN, GPIO_DIR_OUT);
	mt_set_gpio_out(GPIO_LCM_PWR_EN, GPIO_OUT_ONE);

	MDELAY(10);
	SET_RESET_PIN(1);
	MDELAY(1);
	SET_RESET_PIN(0);
	MDELAY(10);
	SET_RESET_PIN(1);
	MDELAY(120);
/* wenggaojian@wind -mobi.com 20150702 begin */
	//if(lcd_typpe_id == 0x40)
		push_table(lcm_initialization_setting, sizeof(lcm_initialization_setting) / sizeof(struct LCM_setting_table), 1); 
	//else
	//	push_table(lcm_initialization_setting_otp, sizeof(lcm_initialization_setting_otp) / sizeof(struct LCM_setting_table), 1);
/* wenggaojian@wind -mobi.com 20150720 end */ 
	
} 
static void lcm_suspend(void)
{
	push_table(lcm_deep_sleep_mode_in_setting, sizeof(lcm_deep_sleep_mode_in_setting) / sizeof(struct LCM_setting_table), 1);
	
	mt_set_gpio_mode(GPIO_LCM_PWR_EN, GPIO_MODE_00);
	mt_set_gpio_dir(GPIO_LCM_PWR_EN, GPIO_DIR_OUT);
	mt_set_gpio_out(GPIO_LCM_PWR_EN, GPIO_OUT_ZERO);
	MDELAY(10);
}

static void lcm_resume(void)
{

	lcm_init();
}

#if 0
static void lcm_update(unsigned int x, unsigned int y,
                       unsigned int width, unsigned int height)
{
	unsigned int x0 = x;
	unsigned int y0 = y;
	unsigned int x1 = x0 + width - 1;
	unsigned int y1 = y0 + height - 1;

	unsigned char x0_MSB = ((x0>>8)&0xFF);
	unsigned char x0_LSB = (x0&0xFF);
	unsigned char x1_MSB = ((x1>>8)&0xFF);
	unsigned char x1_LSB = (x1&0xFF);
	unsigned char y0_MSB = ((y0>>8)&0xFF);
	unsigned char y0_LSB = (y0&0xFF);
	unsigned char y1_MSB = ((y1>>8)&0xFF);
	unsigned char y1_LSB = (y1&0xFF);

	unsigned int data_array[16];

	data_array[0]= 0x00053902;
	data_array[1]= (x1_MSB<<24)|(x0_LSB<<16)|(x0_MSB<<8)|0x2a;
	data_array[2]= (x1_LSB);
	dsi_set_cmdq(data_array, 3, 1);
	
	data_array[0]= 0x00053902;
	data_array[1]= (y1_MSB<<24)|(y0_LSB<<16)|(y0_MSB<<8)|0x2b;
	data_array[2]= (y1_LSB);
	dsi_set_cmdq(data_array, 3, 1);
	
	data_array[0]= 0x002c3909;
	dsi_set_cmdq(data_array, 1, 0);	
}
#endif

LCM_DRIVER otm1287a_hd720_dsi_vdo_by_lcm_drv = 
{
	.name		= "otm1287a_hd720_dsi_vdo_by",
	.set_util_funcs = lcm_set_util_funcs,
	.get_params     = lcm_get_params,
	.init           = lcm_init,
	.suspend        = lcm_suspend,
	.resume         = lcm_resume,
	.compare_id     = lcm_compare_id,
//	.init_power		= lcm_init_power,
//  .resume_power = lcm_resume_power,
//  .suspend_power = lcm_suspend_power,
//	.set_backlight	= lcm_setbacklight,
#if (LCM_DSI_CMD_MODE)
    .update         = lcm_update,
#endif
};
//modify@zte.com.cn add at 20160311 begin