//modify@zte.com.cn 20160408 begin
/* BEGIN PN: , Added by guohongjin, 2014.08.13*/


//#ifdef BUILD_LK
//	#include <platform/mt_gpio.h>
//#elif defined(BUILD_UBOOT)
//	#include <asm/arch/mt_gpio.h>
//#else
//	#include <mach/mt_gpio.h>
//#endif

#ifdef BUILD_LK
#include <platform/gpio_const.h>
#include <platform/mt_gpio.h>
#include <platform/upmu_common.h>
#else
	#include <linux/string.h>
	#if defined(BUILD_UBOOT)
		#include <asm/arch/mt_gpio.h>
	#else
		#include <mt-plat/mt_gpio.h>
		#include <mach/gpio_const.h>
    #endif
#endif


#include "lcm_drv.h"


// ---------------------------------------------------------------------------
//  Local Constants
// ---------------------------------------------------------------------------
#define LCM_DSI_CMD_MODE									0
#define FRAME_WIDTH  										(720)
#define FRAME_HEIGHT 										(1280)
#define LCM_ID_ILI9881                                                              (0x9800)   

#define REGFLAG_DELAY             								0xFC
#define REGFLAG_END_OF_TABLE      							0xFD   // END OF REGISTERS MARKER

#ifndef TRUE
    #define TRUE 1
#endif

#ifndef FALSE
    #define FALSE 0
#endif

//modify@zte.com.cn at 20160408 begin
#define GPIO_LCD_BIAS_ENP_PIN         (GPIO119 | 0x80000000)
//modify@zte.com.cn at 20160408 end
static unsigned int lcm_esd_test = FALSE;      ///only for ESD test
// ---------------------------------------------------------------------------
//  Local Variables
// ---------------------------------------------------------------------------

static LCM_UTIL_FUNCS lcm_util;

#define __SAME_IC_COMPATIBLE__

#define SET_RESET_PIN(v)    								(lcm_util.set_reset_pin((v)))
#define MDELAY(n) 											(lcm_util.mdelay(n))

// ---------------------------------------------------------------------------
//  Local Functions
// ---------------------------------------------------------------------------

#define dsi_set_cmdq_V2(cmd, count, ppara, force_update)	lcm_util.dsi_set_cmdq_V2(cmd, count, ppara, force_update)
#define dsi_set_cmdq(pdata, queue_size, force_update)		lcm_util.dsi_set_cmdq(pdata, queue_size, force_update)
#define wrtie_cmd(cmd)										lcm_util.dsi_write_cmd(cmd)
#define write_regs(addr, pdata, byte_nums)					lcm_util.dsi_write_regs(addr, pdata, byte_nums)
#define read_reg											lcm_util.dsi_read_reg()
#define read_reg_v2(cmd, buffer, buffer_size)				lcm_util.dsi_dcs_read_lcm_reg_v2(cmd, buffer, buffer_size)


 struct LCM_setting_table {
    unsigned cmd;
    unsigned char count;
    unsigned char para_list[64];
};
//modify@zte.com.cn 201600815 begin
//modify@zte.com.cn modify igd timing at 20160818 begin
#if defined(CONFIG_WIND_LCM_ROTATION180)
static struct LCM_setting_table lcm_initialization_setting1[] = {
	//CCMON
	/*
	Note :

	Data ID will depends on the following rule.
	
		count of parameters > 1	=> Data ID = 0x39
		count of parameters = 1	=> Data ID = 0x15
		count of parameters = 0	=> Data ID = 0x05

	Structure Format :

	{DCS command, count of parameters, {parameter list}}
	{REGFLAG_DELAY, milliseconds of time, {}},

	...
 
	Setting ending by predefined flag
	
	{REGFLAG_END_OF_TABLE, 0x00, {}}
	*/
{0xFF,0x03,{0x98,0x81,0x03}},

//GIP_1

{0x01,0x01,{0x00}},
{0x02,0x01,{0x00}},
{0x03,0x01,{0x73}},  //0x72
{0x04,0x01,{0x00}},
{0x05,0x01,{0x00}},
{0x06,0x01,{0x0a}},  //0x09
{0x07,0x01,{0x00}},
{0x08,0x01,{0x00}},
{0x09,0x01,{0x01}},
{0x0a,0x01,{0x00}},
{0x0b,0x01,{0x00}},
{0x0c,0x01,{0x01}},
{0x0d,0x01,{0x00}},
{0x0e,0x01,{0x00}},
{0x0f,0x01,{0x1d}}, //0x00
          
{0x10,0x01,{0x1d}}, //0x00
{0x11,0x01,{0x00}},
{0x12,0x01,{0x00}},
{0x13,0x01,{0x00}},
{0x14,0x01,{0x00}},
        
        
        
{0x15,0x01,{0x00}}, //0x04
{0x16,0x01,{0x00}}, //0x01
{0x17,0x01,{0x00}}, //0x01
         
         
         
{0x18,0x01,{0x00}},
{0x19,0x01,{0x00}},
{0x1a,0x01,{0x00}},
{0x1b,0x01,{0x00}},
{0x1c,0x01,{0x00}},
{0x1d,0x01,{0x00}},
{0x1e,0x01,{0x40}},
{0x1f,0x01,{0x80}},
        
{0x20,0x01,{0x06}}, //0x05
{0x21,0x01,{0x02}},
{0x22,0x01,{0x00}},
{0x23,0x01,{0x00}},
{0x24,0x01,{0x00}},
{0x25,0x01,{0x00}},
{0x26,0x01,{0x00}},
{0x27,0x01,{0x00}},
{0x28,0x01,{0x33}},
{0x29,0x01,{0x03}}, //0x02
{0x2a,0x01,{0x00}},
{0x2b,0x01,{0x00}},
{0x2c,0x01,{0x00}},
{0x2d,0x01,{0x00}},
{0x2e,0x01,{0x00}},
{0x2f,0x01,{0x00}},
        
{0x30,0x01,{0x00}},
{0x31,0x01,{0x00}},
{0x32,0x01,{0x00}},
{0x33,0x01,{0x00}},
{0x34,0x01,{0x04}},
{0x35,0x01,{0x00}},
{0x36,0x01,{0x00}},
{0x37,0x01,{0x00}},
{0x38,0x01,{0x3C}},
{0x39,0x01,{0x00}},
{0x3a,0x01,{0x40}},
{0x3b,0x01,{0x40}},
{0x3c,0x01,{0x00}},
{0x3d,0x01,{0x00}},
{0x3e,0x01,{0x00}},
{0x3f,0x01,{0x00}},
         
{0x40,0x01,{0x00}},
{0x41,0x01,{0x00}},
{0x42,0x01,{0x00}},
{0x43,0x01,{0x00}},
{0x44,0x01,{0x00}},
        
        
//GIP_2  ,
{0x50,0x01,{0x01}},
{0x51,0x01,{0x23}},
{0x52,0x01,{0x45}},
{0x53,0x01,{0x67}},
{0x54,0x01,{0x89}},
{0x55,0x01,{0xab}},
{0x56,0x01,{0x01}},
{0x57,0x01,{0x23}},
{0x58,0x01,{0x45}},
{0x59,0x01,{0x67}},
{0x5a,0x01,{0x89}},
{0x5b,0x01,{0xab}},
{0x5c,0x01,{0xcd}},
{0x5d,0x01,{0xef}},
       
//GIP_3  
{0x5e,0x01,{0x11}},
{0x5f,0x01,{0x01}},
         
{0x60,0x01,{0x00}},
{0x61,0x01,{0x15}},
{0x62,0x01,{0x14}},
{0x63,0x01,{0x0E}},
{0x64,0x01,{0x0F}},
{0x65,0x01,{0x0C}},
{0x66,0x01,{0x0D}},
{0x67,0x01,{0x06}},
{0x68,0x01,{0x02}},
{0x69,0x01,{0x07}},
{0x6a,0x01,{0x02}},
{0x6b,0x01,{0x02}},
{0x6c,0x01,{0x02}},
{0x6d,0x01,{0x02}},
{0x6e,0x01,{0x02}},
{0x6f,0x01,{0x02}},
        
{0x70,0x01,{0x02}},
{0x71,0x01,{0x02}},
{0x72,0x01,{0x02}},
{0x73,0x01,{0x02}},
{0x74,0x01,{0x02}},
{0x75,0x01,{0x01}},
{0x76,0x01,{0x00}},
{0x77,0x01,{0x14}},
{0x78,0x01,{0x15}},
{0x79,0x01,{0x0E}},
{0x7a,0x01,{0x0F}},
{0x7b,0x01,{0x0C}},
{0x7c,0x01,{0x0D}},
{0x7d,0x01,{0x06}},
{0x7e,0x01,{0x02}},
{0x7f,0x01,{0x07}},
         
{0x80,0x01,{0x02}},
{0x81,0x01,{0x02}},
{0x82,0x01,{0x02}},
{0x83,0x01,{0x02}},
{0x84,0x01,{0x02}},
{0x85,0x01,{0x02}},
{0x86,0x01,{0x02}},
{0x87,0x01,{0x02}},
{0x88,0x01,{0x02}},
{0x89,0x01,{0x02}},
{0x8A,0x01,{0x02}},

//CMD_Page 4
{0xFF,0x03,{0x98,0x81,0x04}},
{0x6C,0x01,{0x15}},             //Set VCORE voltage =1.5V
{0x6E,0x01,{0x2B}},             //di_pwr_reg=0 for power mode 2A //VGH clamp 15V
{0x6F,0x01,{0x33}},             // reg vcl + pumping ratio VGH=3x VGL=-2.5x
         
{0x8D,0x01,{0x14}},            //VGL clamp -10
{0x87,0x01,{0xBA}},            //ESD               
{0x26,0x01,{0x76}},             //ESD            
{0xB2,0x01,{0xD1}},            //ESD
{0xB5,0x01,{0x06}},            //ESD
          
          
{0x3A,0x01,{0x94}}, //0x24
{0x35,0x01,{0x1F}},        


//CMD_Page 1
{0xFF,0x03,{0x98,0x81,0x01}},
{0x22,0x01,{0x09}},//BGR, GS
{0x31,0x01,{0x00}},//column inversion
{0x40,0x01,{0x33}},
{0x53,0x01,{0x97}},//VCOM1
{0x55,0x01,{0x92}},//VCOM2
         
{0x50,0x01,{0xA5}},//VREG1OUT=4.7V
{0x51,0x01,{0xA0}},//VREG2OUT=-4.7V
{0x60,0x01,{0x22}},              //SDT
{0x61,0x01,{0x00}},               //CRT
{0x62,0x01,{0x19}},               //EQT
        
{0x63,0x01,{0x10}},               //PCT 0x00
        
        
{0xA0,0x01,{0x08}},//VP255	Gamma P
{0xA1,0x01,{0x13}},            //VP251        
{0xA2,0x01,{0x1D}},            //VP247        
{0xA3,0x01,{0x0F}},            //VP243        
{0xA4,0x01,{0x11}},            //VP239        
{0xA5,0x01,{0x22}},            //VP231        
{0xA6,0x01,{0x18}},            //VP219        
{0xA7,0x01,{0x1A}},            //VP203        
{0xA8,0x01,{0x62}},            //VP175        
{0xA9,0x01,{0x1B}},            //VP144        
{0xAA,0x01,{0x27}},            //VP111        
{0xAB,0x01,{0x59}},           //VP80         
{0xAC,0x01,{0x1A}},            //VP52         
{0xAD,0x01,{0x19}},            //VP36         
{0xAE,0x01,{0x4D}},            //VP24         
{0xAF,0x01,{0x21}},            //VP16         
{0xB0,0x01,{0x28}},            //VP12         
{0xB1,0x01,{0x4E}},            //VP8          
{0xB2,0x01,{0x61}},            //VP4          
{0xB3,0x01,{0x39}},            //VP0          
                                           
{0xC0,0x01,{0x08}},//VN255 GAMMA N
{0xC1,0x01,{0x13}},            //VN251        
{0xC2,0x01,{0x1D}},            //VN247        
{0xC3,0x01,{0x0F}},            //VN243        
{0xC4,0x01,{0x11}},            //VN239        
{0xC5,0x01,{0x22}},            //VN231        
{0xC6,0x01,{0x17}},           //VN219        
{0xC7,0x01,{0x1A}},            //VN203        
{0xC8,0x01,{0x62}},            //VN175        
{0xC9,0x01,{0x1B}},           //VN144        
{0xCA,0x01,{0x27}},            //VN111        
{0xCB,0x01,{0x59}},            //VN80         
{0xCC,0x01,{0x1A}},            //VN52         
{0xCD,0x01,{0x19}},           //VN36         
{0xCE,0x01,{0x4D}},            //VN24         
{0xCF,0x01,{0x21}},            //VN16         
{0xD0,0x01,{0x28}},            //VN12         
{0xD1,0x01,{0x4D}},            //VN8          
{0xD2,0x01,{0x61}},            //VN4          
{0xD3,0x01,{0x39}},            //VN0

//CMD_Page 0
{0xFF,0x03,{0x98,0x81,0x00}},

{0x11,0x01,{0x00}},	//sleep out
{REGFLAG_DELAY,120,{0x00}},
{0x29,0x01,{0x00}},	//display on
{REGFLAG_DELAY,20,{0x00}},
{0x35,0x01,{0x00}},	//TE on
	
	
	
	
	
/*
		{0x51,1,{0xFF}},   //CABC
		{0x53,1,{0x24}},
		{0x55,1,{0x00}},
		{0x11,1,{0x00}},  //sleep out
		{REGFLAG_DELAY, 120, {}},		//120
		{0x29,1,{0x00}}, //display on
		{0x35,1,{0x00}},  //TE on
		{REGFLAG_END_OF_TABLE, 0x00, {}}
*/
};
#else
static struct LCM_setting_table lcm_initialization_setting1[] = {
	//CCMON
	/*
	Note :

	Data ID will depends on the following rule.
	
		count of parameters > 1	=> Data ID = 0x39
		count of parameters = 1	=> Data ID = 0x15
		count of parameters = 0	=> Data ID = 0x05

	Structure Format :

	{DCS command, count of parameters, {parameter list}}
	{REGFLAG_DELAY, milliseconds of time, {}},

	...
 
	Setting ending by predefined flag
	
	{REGFLAG_END_OF_TABLE, 0x00, {}}
	*/
{0xFF,0x03,{0x98,0x81,0x03}},

//GIP_1

{0x01,0x01,{0x00}},
{0x02,0x01,{0x00}},
{0x03,0x01,{0x72}},
{0x04,0x01,{0x00}},
{0x05,0x01,{0x00}},
{0x06,0x01,{0x09}},
{0x07,0x01,{0x00}},
{0x08,0x01,{0x00}},
{0x09,0x01,{0x01}},
{0x0a,0x01,{0x00}},
{0x0b,0x01,{0x00}},
{0x0c,0x01,{0x01}},
{0x0d,0x01,{0x00}},
{0x0e,0x01,{0x00}},
{0x0f,0x01,{0x00}},
          
{0x10,0x01,{0x00}},
{0x11,0x01,{0x00}},
{0x12,0x01,{0x00}},
{0x13,0x01,{0x00}},
{0x14,0x01,{0x00}},
        
        
        
{0x15,0x01,{0x04}},
{0x16,0x01,{0x01}},
{0x17,0x01,{0x01}},
         
         
         
{0x18,0x01,{0x00}},
{0x19,0x01,{0x00}},
{0x1a,0x01,{0x00}},
{0x1b,0x01,{0x00}},
{0x1c,0x01,{0x00}},
{0x1d,0x01,{0x00}},
{0x1e,0x01,{0x40}},
{0x1f,0x01,{0x80}},
        
{0x20,0x01,{0x05}},
{0x21,0x01,{0x02}},
{0x22,0x01,{0x00}},
{0x23,0x01,{0x00}},
{0x24,0x01,{0x00}},
{0x25,0x01,{0x00}},
{0x26,0x01,{0x00}},
{0x27,0x01,{0x00}},
{0x28,0x01,{0x33}},
{0x29,0x01,{0x02}},
{0x2a,0x01,{0x00}},
{0x2b,0x01,{0x00}},
{0x2c,0x01,{0x00}},
{0x2d,0x01,{0x00}},
{0x2e,0x01,{0x00}},
{0x2f,0x01,{0x00}},
        
{0x30,0x01,{0x00}},
{0x31,0x01,{0x00}},
{0x32,0x01,{0x00}},
{0x33,0x01,{0x00}},
{0x34,0x01,{0x04}},
{0x35,0x01,{0x00}},
{0x36,0x01,{0x00}},
{0x37,0x01,{0x00}},
{0x38,0x01,{0x3C}},
{0x39,0x01,{0x00}},
{0x3a,0x01,{0x40}},
{0x3b,0x01,{0x40}},
{0x3c,0x01,{0x00}},
{0x3d,0x01,{0x00}},
{0x3e,0x01,{0x00}},
{0x3f,0x01,{0x00}},
         
{0x40,0x01,{0x00}},
{0x41,0x01,{0x00}},
{0x42,0x01,{0x00}},
{0x43,0x01,{0x00}},
{0x44,0x01,{0x00}},
        
        
//GIP_2  ,
{0x50,0x01,{0x01}},
{0x51,0x01,{0x23}},
{0x52,0x01,{0x45}},
{0x53,0x01,{0x67}},
{0x54,0x01,{0x89}},
{0x55,0x01,{0xab}},
{0x56,0x01,{0x01}},
{0x57,0x01,{0x23}},
{0x58,0x01,{0x45}},
{0x59,0x01,{0x67}},
{0x5a,0x01,{0x89}},
{0x5b,0x01,{0xab}},
{0x5c,0x01,{0xcd}},
{0x5d,0x01,{0xef}},
       
//GIP_3  
{0x5e,0x01,{0x11}},
{0x5f,0x01,{0x01}},
         
{0x60,0x01,{0x00}},
{0x61,0x01,{0x15}},
{0x62,0x01,{0x14}},
{0x63,0x01,{0x0E}},
{0x64,0x01,{0x0F}},
{0x65,0x01,{0x0C}},
{0x66,0x01,{0x0D}},
{0x67,0x01,{0x06}},
{0x68,0x01,{0x02}},
{0x69,0x01,{0x07}},
{0x6a,0x01,{0x02}},
{0x6b,0x01,{0x02}},
{0x6c,0x01,{0x02}},
{0x6d,0x01,{0x02}},
{0x6e,0x01,{0x02}},
{0x6f,0x01,{0x02}},
        
{0x70,0x01,{0x02}},
{0x71,0x01,{0x02}},
{0x72,0x01,{0x02}},
{0x73,0x01,{0x02}},
{0x74,0x01,{0x02}},
{0x75,0x01,{0x01}},
{0x76,0x01,{0x00}},
{0x77,0x01,{0x14}},
{0x78,0x01,{0x15}},
{0x79,0x01,{0x0E}},
{0x7a,0x01,{0x0F}},
{0x7b,0x01,{0x0C}},
{0x7c,0x01,{0x0D}},
{0x7d,0x01,{0x06}},
{0x7e,0x01,{0x02}},
{0x7f,0x01,{0x07}},
         
{0x80,0x01,{0x02}},
{0x81,0x01,{0x02}},
{0x82,0x01,{0x02}},
{0x83,0x01,{0x02}},
{0x84,0x01,{0x02}},
{0x85,0x01,{0x02}},
{0x86,0x01,{0x02}},
{0x87,0x01,{0x02}},
{0x88,0x01,{0x02}},
{0x89,0x01,{0x02}},
{0x8A,0x01,{0x02}},

//CMD_Page 4
{0xFF,0x03,{0x98,0x81,0x04}},
{0x6C,0x01,{0x15}},             //Set VCORE voltage =1.5V
{0x6E,0x01,{0x2B}},             //di_pwr_reg=0 for power mode 2A //VGH clamp 15V
{0x6F,0x01,{0x33}},             // reg vcl + pumping ratio VGH=3x VGL=-2.5x
         
{0x8D,0x01,{0x14}},            //VGL clamp -10
{0x87,0x01,{0xBA}},            //ESD               
{0x26,0x01,{0x76}},             //ESD            
{0xB2,0x01,{0xD1}},            //ESD
{0xB5,0x01,{0x06}},            //ESD
          
          
{0x3A,0x01,{0x24}},
{0x35,0x01,{0x1F}},        


//CMD_Page 1
{0xFF,0x03,{0x98,0x81,0x01}},
{0x22,0x01,{0x0A}},//BGR, GS
{0x31,0x01,{0x00}},//column inversion
{0x40,0x01,{0x33}},
{0x53,0x01,{0x97}},//VCOM1
{0x55,0x01,{0x92}},//VCOM2
         
{0x50,0x01,{0xA5}},//VREG1OUT=4.7V
{0x51,0x01,{0xA0}},//VREG2OUT=-4.7V
{0x60,0x01,{0x22}},              //SDT
{0x61,0x01,{0x00}},               //CRT
{0x62,0x01,{0x19}},               //EQT
        
{0x63,0x01,{0x00}},               //PCT
        
        
{0xA0,0x01,{0x08}},//VP255	Gamma P
{0xA1,0x01,{0x13}},            //VP251        
{0xA2,0x01,{0x1D}},            //VP247        
{0xA3,0x01,{0x0F}},            //VP243        
{0xA4,0x01,{0x11}},            //VP239        
{0xA5,0x01,{0x22}},            //VP231        
{0xA6,0x01,{0x18}},            //VP219        
{0xA7,0x01,{0x1A}},            //VP203        
{0xA8,0x01,{0x62}},            //VP175        
{0xA9,0x01,{0x1B}},            //VP144        
{0xAA,0x01,{0x27}},            //VP111        
{0xAB,0x01,{0x59}},           //VP80         
{0xAC,0x01,{0x1A}},            //VP52         
{0xAD,0x01,{0x19}},            //VP36         
{0xAE,0x01,{0x4D}},            //VP24         
{0xAF,0x01,{0x21}},            //VP16         
{0xB0,0x01,{0x28}},            //VP12         
{0xB1,0x01,{0x4E}},            //VP8          
{0xB2,0x01,{0x61}},            //VP4          
{0xB3,0x01,{0x39}},            //VP0          
                                           
{0xC0,0x01,{0x08}},//VN255 GAMMA N
{0xC1,0x01,{0x13}},            //VN251        
{0xC2,0x01,{0x1D}},            //VN247        
{0xC3,0x01,{0x0F}},            //VN243        
{0xC4,0x01,{0x11}},            //VN239        
{0xC5,0x01,{0x22}},            //VN231        
{0xC6,0x01,{0x17}},           //VN219        
{0xC7,0x01,{0x1A}},            //VN203        
{0xC8,0x01,{0x62}},            //VN175        
{0xC9,0x01,{0x1B}},           //VN144        
{0xCA,0x01,{0x27}},            //VN111        
{0xCB,0x01,{0x59}},            //VN80         
{0xCC,0x01,{0x1A}},            //VN52         
{0xCD,0x01,{0x19}},           //VN36         
{0xCE,0x01,{0x4D}},            //VN24         
{0xCF,0x01,{0x21}},            //VN16         
{0xD0,0x01,{0x28}},            //VN12         
{0xD1,0x01,{0x4D}},            //VN8          
{0xD2,0x01,{0x61}},            //VN4          
{0xD3,0x01,{0x39}},            //VN0

//CMD_Page 0
{0xFF,0x03,{0x98,0x81,0x00}},

{0x11,0x01,{0x00}},	//sleep out
{REGFLAG_DELAY,120,{0x00}},
{0x29,0x01,{0x00}},	//display on
{REGFLAG_DELAY,20,{0x00}},
{0x35,0x01,{0x00}},	//TE on
	
	
	
	
	
/*
		{0x51,1,{0xFF}},   //CABC
		{0x53,1,{0x24}},
		{0x55,1,{0x00}},
		{0x11,1,{0x00}},  //sleep out
		{REGFLAG_DELAY, 120, {}},		//120
		{0x29,1,{0x00}}, //display on
		{0x35,1,{0x00}},  //TE on
		{REGFLAG_END_OF_TABLE, 0x00, {}}
*/
};
#endif
//modify@zte.com.cn modify igd timing at 20160818 end
//modify@zte.com.cn 201600815 end
#if 0
static struct LCM_setting_table lcm_sleep_out_setting[] = {
    //Sleep Out
    {0x11, 1, {0x00}},
    {REGFLAG_DELAY, 120, {}},

    // Display ON
    {0x29, 1, {0x00}},
    {REGFLAG_DELAY, 20, {}},
    {REGFLAG_END_OF_TABLE, 0x00, {}}
};
#endif
static struct LCM_setting_table lcm_deep_sleep_mode_in_setting[] = {
    // Display off sequence
    {0x28, 1, {0x00}},
    {REGFLAG_DELAY, 20, {}},

    // Sleep Mode On
    {0x10, 1, {0x00}},
    {REGFLAG_DELAY, 120, {}},
    {0xFF,	3,		{0x98,0x81,0x01}},
    {0x58, 1, {0x01}},
    {REGFLAG_DELAY, 20, {}},
    {REGFLAG_END_OF_TABLE, 0x00, {}}
};

static void push_table(struct LCM_setting_table *table, unsigned int count, unsigned char force_update)
{
    unsigned int i;

    for(i = 0; i < count; i++)
    {
        unsigned cmd;
        cmd = table[i].cmd;

        switch (cmd) {
			
            case REGFLAG_DELAY :
                MDELAY(table[i].count);
                break;
				
            case REGFLAG_END_OF_TABLE :
                break;

            default:
                dsi_set_cmdq_V2(cmd, table[i].count, table[i].para_list, force_update);
        }
    }
}

// ---------------------------------------------------------------------------
//  LCM Driver Implementations
// ---------------------------------------------------------------------------

static void lcm_set_util_funcs(const LCM_UTIL_FUNCS *util)
{
    	memcpy(&lcm_util, util, sizeof(LCM_UTIL_FUNCS));
}

static void lcm_get_params(LCM_PARAMS *params)
{

		memset(params, 0, sizeof(LCM_PARAMS));
		params->type   = LCM_TYPE_DSI;

		params->width  = FRAME_WIDTH;
		params->height = FRAME_HEIGHT;

		params->dbi.te_mode				= LCM_DBI_TE_MODE_VSYNC_ONLY;
		//LCM_DBI_TE_MODE_DISABLED;
		//LCM_DBI_TE_MODE_VSYNC_ONLY;  
		params->dbi.te_edge_polarity		= LCM_POLARITY_RISING; 
		/////////////////////   
		//if(params->dsi.lcm_int_te_monitor)  
		//params->dsi.vertical_frontporch *=2;  
		//params->dsi.lcm_ext_te_monitor= 0;//TRUE; 
	//	params->dsi.noncont_clock= TRUE;//FALSE;   
	//	params->dsi.noncont_clock_period=2;
		params->dsi.cont_clock=1;
		////////////////////          
		params->dsi.mode   = SYNC_PULSE_VDO_MODE;  
		// DSI    /* Command mode setting */  
		params->dsi.LANE_NUM				= LCM_FOUR_LANE;      
		//The following defined the fomat for data coming from LCD engine.  
		params->dsi.data_format.color_order = LCM_COLOR_ORDER_RGB;   
		params->dsi.data_format.trans_seq	= LCM_DSI_TRANS_SEQ_MSB_FIRST; 
		params->dsi.data_format.padding 	= LCM_DSI_PADDING_ON_LSB;    
		params->dsi.data_format.format	  = LCM_DSI_FORMAT_RGB888;       
		// Video mode setting		   
		params->dsi.intermediat_buffer_num = 2;  
		params->dsi.PS=LCM_PACKED_PS_24BIT_RGB888;  
		params->dsi.packet_size=256;    
		// params->dsi.word_count=480*3;	
		//DSI CMD mode need set these two bellow params, different to 6577   
		// params->dsi.vertical_active_line=800;   
		params->dsi.vertical_sync_active				= 6; //4   
		params->dsi.vertical_backporch				       = 20;  //14  
		params->dsi.vertical_frontporch				       = 14;  //16  
		params->dsi.vertical_active_line				       = FRAME_HEIGHT;     
		params->dsi.horizontal_sync_active				= 10;   //60
		params->dsi.horizontal_backporch				= 80;  //100 
		params->dsi.horizontal_frontporch				= 80;    //100
		params->dsi.horizontal_blanking_pixel				= 60;   
		params->dsi.horizontal_active_pixel				= FRAME_WIDTH;  
		params->dsi.HS_TRAIL 							= 15;	////modify@zte.com.cn add at 20160818
		
	//	params->dsi.pll_div1=1;		   
	//	params->dsi.pll_div2=1;		   
	//	params->dsi.fbk_div =28;//28	
//modify@zte.com.cn 20150327 beign
// To fix rf
		params->dsi.PLL_CLOCK = 212;	   // 245;

	//	params->dsi.ss

//		params->dsi.CLK_TRAIL = 17;
			
//modify@zte.com.cn 20140820 end

		params->dsi.esd_check_enable = 1;
        params->dsi.customization_esd_check_enable = 1;
        params->dsi.lcm_esd_check_table[0].cmd                  = 0x0a;
        params->dsi.lcm_esd_check_table[0].count                = 1;
        params->dsi.lcm_esd_check_table[0].para_list[0] = 0x9C;
}

static void lcm_init(void)
{
#ifdef GPIO_LCD_BIAS_ENP_PIN
	mt_set_gpio_mode(GPIO_LCD_BIAS_ENP_PIN, GPIO_MODE_00);
	mt_set_gpio_dir(GPIO_LCD_BIAS_ENP_PIN, GPIO_DIR_OUT);
	mt_set_gpio_out(GPIO_LCD_BIAS_ENP_PIN, GPIO_OUT_ONE);
#endif
	MDELAY(10);

	SET_RESET_PIN(1);
	MDELAY(1);
	SET_RESET_PIN(0);
	MDELAY(10);
	SET_RESET_PIN(1);
	MDELAY(120);
	
	push_table(lcm_initialization_setting1, sizeof(lcm_initialization_setting1) / sizeof(struct LCM_setting_table), 1); 

		  
}

static void lcm_suspend(void) 
{



	// when phone sleep , config output low, disable backlight drv chip  
	push_table(lcm_deep_sleep_mode_in_setting, sizeof(lcm_deep_sleep_mode_in_setting) / sizeof(struct LCM_setting_table), 1);
	
#ifdef GPIO_LCD_BIAS_ENP_PIN
	mt_set_gpio_mode(GPIO_LCD_BIAS_ENP_PIN, GPIO_MODE_00);
	mt_set_gpio_dir(GPIO_LCD_BIAS_ENP_PIN, GPIO_DIR_OUT);
	mt_set_gpio_out(GPIO_LCD_BIAS_ENP_PIN, GPIO_OUT_ZERO);
#endif
	MDELAY(10);

}

static void lcm_resume(void)
{


	lcm_init();

}

extern unsigned char which_lcd_module_triple_cust(void); //modify@zte.com.cn 20160527

static unsigned int lcm_compare_id(void)
{
	unsigned int id=0,id1=0,id2=0;
	unsigned char buffer[3];
	unsigned int array[16];  
	
//modify@zte.com.cn 20160315 begin
	unsigned char idpin=0;
//modify@zte.com.cn 20160315 end

#ifdef GPIO_LCD_BIAS_ENP_PIN
	mt_set_gpio_mode(GPIO_LCD_BIAS_ENP_PIN, GPIO_MODE_00);
	mt_set_gpio_dir(GPIO_LCD_BIAS_ENP_PIN, GPIO_DIR_OUT);
	mt_set_gpio_out(GPIO_LCD_BIAS_ENP_PIN, GPIO_OUT_ONE);
#endif
//modify@zte.com.cn 20160315 end
	SET_RESET_PIN(1);  //NOTE:should reset LCM firstly
	MDELAY(10);
	//SET_RESET_PIN(1);
	SET_RESET_PIN(0);
	MDELAY(10);
	
	SET_RESET_PIN(1);
	MDELAY(120); 


    array[0]=0x00053902;
    array[1]=0x8198FFFF;
    array[2]=0x00000001;
    dsi_set_cmdq(array, 3, 1);
    MDELAY(10); 
    
    array[0] = 0x00023700;// read id return two byte,version and id
    dsi_set_cmdq(array, 1, 1);
    MDELAY(10); 
    
    read_reg_v2(0x00, buffer, 1);
    id1 = buffer[0]; 
    
    read_reg_v2(0x01, buffer, 1);
    id2 = buffer[1];  
    
	id = (id1 << 8) | id2;

    #ifdef BUILD_LK
		printf("%s, LK ili9881 debug: ili9881 id = %x,%x,%x\n", __func__, id,id1,id2);
    #else
		printk("%s, kernel ili9881 horse debug: ili9881 id = 0x%08x\n", __func__, id);
    #endif
	
	if(id == LCM_ID_ILI9881){
	idpin=which_lcd_module_triple_cust();
	if(0x10==idpin)
	return 1;
	else
	return 0;	
	}else 
		return 0;
}
//static int err_count = 0;
static unsigned int lcm_esd_check(void)
{
  #ifndef BUILD_LK
    unsigned char buffer[8] = {0};

    unsigned int array[4];

	if(lcm_esd_test)
	{
		lcm_esd_test = FALSE;
		return TRUE;
	}

    array[0] = 0x00013700;    

    dsi_set_cmdq(array, 1,1);

    read_reg_v2(0x0A, buffer,8);

	printk( "ili9881 lcm_esd_check: buffer[0] = %d,buffer[1] = %d,buffer[2] = %d,buffer[3] = %d,buffer[4] = %d,buffer[5] = %d,buffer[6] = %d,buffer[7] = %d\n",buffer[0],buffer[1],buffer[2],buffer[3],buffer[4],buffer[5],buffer[6],buffer[7]);

    if((buffer[0] != 0x9C))/*LCD work status error,need re-initalize*/

    {

        printk( "ili9881 lcm_esd_check buffer[0] = %d\n",buffer[0]);

        return TRUE;

    }

    else

    {

#if 0
        if(buffer[3] != 0x02) //error data type is 0x02

        {
		//  is not 02, 
             err_count = 0;

        }

        else

        {
		// is 02, so ,
             if((buffer[4] == 0x40) || (buffer[5] == 0x80))
             {
			 // buffer[4] is not 0, || (huo),buffer[5] is 0x80.
			   err_count = 0;
             }
             else

             {
			// is  0,0x80,  
			   err_count++;
             }             

             if(err_count >=2 )
             {
			
                 err_count = 0;

                 printk( "ili9881 lcm_esd_check buffer[4] = %d , buffer[5] = %d\n",buffer[4],buffer[5]);

                 return TRUE;

             }

        }
#endif
        return FALSE;

    }
#endif
	
}
static unsigned int lcm_esd_recover(void)
{
    #ifndef BUILD_LK
    printk( "ili9881 lcm_esd_recover\n");
    #endif
	lcm_init();
//	lcm_resume();

	return TRUE;
}
LCM_DRIVER ili9881_hd720_dsi_vdo_yassy_hsd_lcm_drv =
{
    .name           	= "ili9881_hd720_dsi_vdo_txd_hsd", //modify@zte.com.cn at 20160621
    .set_util_funcs 	= lcm_set_util_funcs,
    .get_params     	= lcm_get_params,
    .init           	= lcm_init,
    .suspend        	= lcm_suspend,
    .resume         	= lcm_resume,
    .compare_id     	= lcm_compare_id,
	.esd_check = lcm_esd_check,
	.esd_recover = lcm_esd_recover,
};
//late_initcall(lcm_init);
/* END PN: , Added by guohongjin, 2014.08.13*/
//modify@zte.com.cn 20160408 end
