#include <linux/init.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/spinlock.h>
#include <linux/delay.h>
#include <linux/string.h>
#include <mt-plat/aee.h>
#include <linux/i2c.h>
#include <linux/of_fdt.h>
#include <asm/setup.h>
#include <linux/lockdep.h>
#include <linux/irqchip/mt-gic.h>
/* #include <mach/mt_cirq.h> */
#include "mt_spm_sleep.h"
#include "mach/mt_clkmgr.h"
#include "mt_cpuidle.h"
#include <mach/wd_api.h>
/* #include <mach/eint.h> */
/* #include <mach/mtk_ccci_helper.h> */
#include <mt-plat/mt_ccci_common.h>
#include "mt_cpufreq.h"
#include "mt_power_gs-v1.h"
/* #include <mt-plat/upmu_common.h> */
/* #include <mt-plat/upmu_sw.h> */
/* #include <mt-plat/upmu_hw.h> */

/* #include "mach/mt_pmic_wrap.h" */

/* #include <mt_i2c.h> */

#include "mt_spm_internal.h"
#if !defined(CONFIG_ARCH_MT6580)
#include "pwrap_hal.h"
#include "mt_vcore_dvfs.h"
/* #include <mach/mt_dramc.h> */
#endif

/* for MP0,1 AXI_CONFIG */
#ifdef CONFIG_OF
#include <linux/of.h>
#include <linux/of_irq.h>
#include <linux/of_address.h>
#endif

#if defined(CONFIG_ARCH_MT6580)
#define DISABLE_DLPT_FEATURE
#endif
/**************************************
 * only for internal debug
 **************************************/
#ifdef CONFIG_MTK_LDVT
#define SPM_PWAKE_EN            0
#define SPM_PCMWDT_EN           0
#define SPM_BYPASS_SYSPWREQ     1
#else
#define SPM_PWAKE_EN            1
#define SPM_PCMWDT_EN           1
#define SPM_BYPASS_SYSPWREQ     0
#endif
#define SPM_PCMTIMER_DIS        0


#define I2C_CHANNEL 2

int spm_dormant_sta = 0;	/* MT_CPU_DORMANT_RESET */
int spm_ap_mdsrc_req_cnt = 0;
u32 spm_suspend_flag = 0;

struct wake_status suspend_info[20];
u32 log_wakesta_cnt = 0;
u32 log_wakesta_index = 0;
u8 spm_snapshot_golden_setting = 0;

struct wake_status spm_wakesta;	/* record last wakesta */
/* please put firmware to vendor/mediatek/proprietary/hardware/spm/mtxxxx/ */
/* todo: dyna load SPM FW */
/*
#if defined(CONFIG_ARCH_MT6580)
#define USE_DYNA_LOAD_SUSPEND
#endif
*/
#ifndef USE_DYNA_LOAD_SUSPEND
/**********************************************************
 * PCM code for suspend
 **********************************************************/
#if defined(CONFIG_ARCH_MT6735)
static const u32 suspend_binary[] = {
	0x81429801, 0xd80001e5, 0x17c07c1f, 0x18c0001f, 0x10001138, 0x1910001f,
	0x10001138, 0xa1108404, 0xe0c00004, 0x1910001f, 0x10001138, 0x1a00001f,
	0x10006604, 0xc0c03de0, 0xe2200007, 0x1a00001f, 0x100062c4, 0x1890001f,
	0x100062c4, 0xa0940402, 0x1b00001f, 0x10000001, 0x1910001f, 0x10006310,
	0x80c39001, 0xd8200443, 0xe2000002, 0x80c10001, 0x1b00001f, 0xbf7ce7ff,
	0xd8200443, 0x17c07c1f, 0x1b00001f, 0x7f7ce7ff, 0xf0000000, 0x17c07c1f,
	0x81429801, 0xd8000665, 0x17c07c1f, 0x18c0001f, 0x10001138, 0x1910001f,
	0x10001138, 0x81308404, 0xe0c00004, 0x1910001f, 0x10001138, 0x1a00001f,
	0x10006604, 0xc0c03de0, 0xe2200007, 0x1a00001f, 0x100062c4, 0x1890001f,
	0x100062c4, 0x80b40402, 0x1b00001f, 0x00801001, 0x1910001f, 0x10006310,
	0x80c39001, 0xd82008c3, 0xe2000002, 0x80c10001, 0x1b00001f, 0x6ffcf7ff,
	0xd80008c3, 0x17c07c1f, 0x1b00001f, 0xaffce7ff, 0xf0000000, 0x17c07c1f,
	0x81f58407, 0x81f68407, 0x1800001f, 0x17cf0f3f, 0x1b80001f, 0x20000000,
	0x1800001f, 0x17cf0f16, 0xa1d28407, 0x81f20407, 0x81409801, 0xd8000b25,
	0x17c07c1f, 0x18c0001f, 0x10006234, 0xc0c02960, 0x1200041f, 0x80310400,
	0x1b80001f, 0x2000000a, 0xa0110400, 0x81f00407, 0xa1dd0407, 0x18c0001f,
	0x100062d8, 0xc0c02c20, 0x1200041f, 0x81fd0407, 0xc2803ec0, 0x1290041f,
	0x1b00001f, 0x6ffcf7ff, 0xf0000000, 0x17c07c1f, 0x1b00001f, 0x2f7ce7ff,
	0x1b80001f, 0x20000004, 0xd80013ec, 0x17c07c1f, 0x1880001f, 0x10006320,
	0xc0c02f40, 0xe080000f, 0xd8200f43, 0x17c07c1f, 0x1b00001f, 0x6ffcf7ff,
	0xd00013e0, 0x17c07c1f, 0xe080001f, 0x81409801, 0xd80011c5, 0x17c07c1f,
	0x18c0001f, 0x10214094, 0x1910001f, 0x1020e374, 0xe0c00004, 0x18c0001f,
	0x10214098, 0x1910001f, 0x1020e378, 0xe0c00004, 0x1910001f, 0x10213378,
	0x18c0001f, 0x10006234, 0xc0c02b40, 0x17c07c1f, 0x18c0001f, 0x100062d8,
	0xc0c02d40, 0x17c07c1f, 0xc2803ec0, 0x1290841f, 0xa1d20407, 0x81f28407,
	0xa1d68407, 0x1800001f, 0x17cf0f3f, 0x1800001f, 0x17ff0f3f, 0x19c0001f,
	0x001c2397, 0x1b00001f, 0x2f7cefff, 0xf0000000, 0x17c07c1f, 0x1910001f,
	0x102135cc, 0x81411801, 0xd8001585, 0x17c07c1f, 0x18c0001f, 0x10006240,
	0xe0e00016, 0xe0e0001e, 0xe0e0000e, 0xe0e0000f, 0x803e0400, 0x1b80001f,
	0x20000222, 0x80380400, 0x1b80001f, 0x20000280, 0x803b0400, 0x1b80001f,
	0x2000001a, 0x803d0400, 0x1b80001f, 0x20000208, 0x80340400, 0x80310400,
	0xe8208000, 0x10210044, 0x00000100, 0x1b80001f, 0x20000068, 0x1b80001f,
	0x2000000a, 0x18c0001f, 0x10006240, 0xe0e0000d, 0xd8001c45, 0x17c07c1f,
	0x1b80001f, 0x20000020, 0x18c0001f, 0x102130f0, 0x1910001f, 0x102130f0,
	0xa9000004, 0x10000000, 0xe0c00004, 0x1b80001f, 0x2000000a, 0x89000004,
	0xefffffff, 0xe0c00004, 0x18c0001f, 0x102140f4, 0x1910001f, 0x102140f4,
	0xa9000004, 0x02000000, 0xe0c00004, 0x1b80001f, 0x2000000a, 0x89000004,
	0xfdffffff, 0xe0c00004, 0x1910001f, 0x102140f4, 0x81fa0407, 0x81f08407,
	0xe8208000, 0x10006354, 0x001fdaa3, 0xa9c00007, 0x60010000, 0xc2803ec0,
	0x1291041f, 0x1b00001f, 0xbf7ce7ff, 0x1950001f, 0x100062c4, 0x80c41401,
	0xd8001e83, 0x17c07c1f, 0x1b00001f, 0xaffce7ff, 0xf0000000, 0x17c07c1f,
	0x1b80001f, 0x20000fdf, 0x1a50001f, 0x10006608, 0x80c9a401, 0x810ba401,
	0x10920c1f, 0xa0979002, 0x80ca2401, 0xa0938c02, 0x8080080d, 0xd82022e2,
	0x17c07c1f, 0x81f08407, 0xa9c00007, 0x60010000, 0x1b00001f, 0x2f7ce7ff,
	0x1b80001f, 0x20000004, 0xd800292c, 0x17c07c1f, 0x1b00001f, 0xbf7ce7ff,
	0x1950001f, 0x100062c4, 0x80c41401, 0xd8002923, 0x17c07c1f, 0x1b00001f,
	0xaffce7ff, 0xd0002920, 0x17c07c1f, 0x89c00007, 0x9ffeffff, 0x1900001f,
	0x40000000, 0x18d0001f, 0x40000000, 0xe1000003, 0xc0c03060, 0x1080041f,
	0x1880001f, 0x10006320, 0xc0c02de0, 0xe080000f, 0xd8002063, 0x17c07c1f,
	0xe080001f, 0xa1da0407, 0xe8208000, 0x10210048, 0x00000100, 0x1b80001f,
	0x20000068, 0xa0110400, 0xa0140400, 0xa0180400, 0xa01b0400, 0xa01d0400,
	0x1b80001f, 0x20000068, 0xa01e0400, 0x1b80001f, 0x20000104, 0x81411801,
	0xd80027c5, 0x17c07c1f, 0x18c0001f, 0x10006240, 0xc0c02d40, 0x17c07c1f,
	0xc2803ec0, 0x1291841f, 0x1b00001f, 0x6ffcf7ff, 0x1950001f, 0x100062c4,
	0x80c41401, 0xd8202923, 0x17c07c1f, 0x1b00001f, 0x7f7ce7ff, 0xf0000000,
	0x17c07c1f, 0xe0f07f16, 0x1380201f, 0xe0f07f1e, 0x1380201f, 0xe0f07f0e,
	0x1b80001f, 0x20000100, 0xe0f07f0c, 0xe0f07f0d, 0xe0f07e0d, 0xe0f07c0d,
	0xe0f0780d, 0xe0f0700d, 0xf0000000, 0x17c07c1f, 0xe0f07f0d, 0xe0f07f1d,
	0xe0f07f1f, 0xe0f07f1e, 0xe0f07f12, 0xf0000000, 0x17c07c1f, 0xe0e00016,
	0x1380201f, 0xe0e0001e, 0x1380201f, 0xe0e0000e, 0xe0e0000c, 0xe0e0000d,
	0xf0000000, 0x17c07c1f, 0xe0e0000f, 0xe0e0001e, 0xe0e00012, 0xf0000000,
	0x17c07c1f, 0x1112841f, 0xa1d08407, 0xd8202ea4, 0x80eab401, 0xd8002e23,
	0x01200404, 0x1a00001f, 0x10006814, 0xe2000003, 0xf0000000, 0x17c07c1f,
	0xa1d00407, 0x1b80001f, 0x20000100, 0x80ea3401, 0x1a00001f, 0x10006814,
	0xe2000003, 0xf0000000, 0x17c07c1f, 0x81499801, 0xd82031c5, 0x17c07c1f,
	0xd82036e2, 0x17c07c1f, 0x18d0001f, 0x40000000, 0x18d0001f, 0x70000000,
	0xd80030c2, 0x00a00402, 0x814a1801, 0xd8203325, 0x17c07c1f, 0xd82036e2,
	0x17c07c1f, 0x18d0001f, 0x40000000, 0x18d0001f, 0x80000000, 0xd8003222,
	0x00a00402, 0x814a9801, 0xd8203485, 0x17c07c1f, 0xd82036e2, 0x17c07c1f,
	0x18d0001f, 0x40000000, 0x18d0001f, 0xc0000000, 0xd8003382, 0x00a00402,
	0x814c1801, 0xd82035e5, 0x17c07c1f, 0xd82036e2, 0x17c07c1f, 0x18d0001f,
	0x40000000, 0x18d0001f, 0xa0000000, 0xd80034e2, 0x00a00402, 0xd82036e2,
	0x17c07c1f, 0x18d0001f, 0x40000000, 0x18d0001f, 0x40000000, 0xd80035e2,
	0x00a00402, 0xf0000000, 0x17c07c1f, 0x81441801, 0xd8203945, 0x17c07c1f,
	0x1a00001f, 0x10006604, 0xc0c03de0, 0xe2200004, 0xc0c03060, 0x1093041f,
	0xc0c03de0, 0xe2200003, 0xc0c03060, 0x1093041f, 0xc0c03de0, 0xe2200002,
	0xc0c03060, 0x1093041f, 0x1a00001f, 0x100062c4, 0x1890001f, 0x100062c4,
	0xa0908402, 0xe2000002, 0x1b00001f, 0x00801001, 0xf0000000, 0x17c07c1f,
	0x1a00001f, 0x100062c4, 0x1890001f, 0x100062c4, 0x80b08402, 0xe2000002,
	0x81441801, 0xd8203d65, 0x17c07c1f, 0x1a00001f, 0x10006604, 0xc0c03de0,
	0xe2200003, 0xc0c03060, 0x1093041f, 0xc0c03de0, 0xe2200004, 0xc0c03060,
	0x1093041f, 0xc0c03de0, 0xe2200005, 0xc0c03060, 0x1093041f, 0x1b00001f,
	0x00000801, 0xf0000000, 0x17c07c1f, 0x18d0001f, 0x10006604, 0x10cf8c1f,
	0xd8203de3, 0x17c07c1f, 0xf0000000, 0x17c07c1f, 0x18c0001f, 0x10006b18,
	0x1910001f, 0x10006b18, 0xa1002804, 0xe0c00004, 0xf0000000, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x1840001f, 0x00000001, 0xa1d48407, 0x1990001f,
	0x10006b08, 0xe8208000, 0x10006b18, 0x00000000, 0x81441801, 0xd8204565,
	0x17c07c1f, 0x1910001f, 0x100062c4, 0x80849001, 0x1a00001f, 0x10006b0c,
	0x1950001f, 0x10006b0c, 0xa1508805, 0xe2000005, 0x18c0001f, 0x2f7ce7ff,
	0x80809001, 0x81600801, 0xa0d59403, 0xa0d60803, 0xd8004465, 0x17c07c1f,
	0x80841001, 0x81600801, 0xa0db9403, 0xa0de0803, 0xd8004465, 0x17c07c1f,
	0x80f60403, 0xe8208000, 0x10006310, 0x0b160c38, 0x13000c1f, 0x1b80001f,
	0xd00f0000, 0xd00045a0, 0x17c07c1f, 0x1b00001f, 0x2f7ce7ff, 0x81469801,
	0xd8204705, 0x17c07c1f, 0x1b80001f, 0xd00f0000, 0x8880000c, 0x2f7ce7ff,
	0xd80069e2, 0x17c07c1f, 0xd0004740, 0x17c07c1f, 0x1b80001f, 0x500f0000,
	0xe8208000, 0x10006354, 0x001fdaa3, 0xc0c07900, 0x81401801, 0xd8004c65,
	0x17c07c1f, 0x81f60407, 0x18c0001f, 0x10006200, 0xc0c07780, 0x12807c1f,
	0xe8208000, 0x1000625c, 0x00000001, 0x1b80001f, 0x20000080, 0xc0c07780,
	0x1280041f, 0x18c0001f, 0x10006208, 0xc0c07780, 0x12807c1f, 0xe8208000,
	0x10006244, 0x00000001, 0x1b80001f, 0x20000080, 0xc0c07780, 0x1280041f,
	0x18c0001f, 0x10006290, 0xc0c07780, 0x12807c1f, 0xc0c07780, 0x1280041f,
	0x18c0001f, 0x100062dc, 0xe0c00001, 0xc2803ec0, 0x1292041f, 0x81469801,
	0xd8004d45, 0x17c07c1f, 0x8880000c, 0x2f7ce7ff, 0xd8006542, 0x17c07c1f,
	0xc0c079a0, 0x17c07c1f, 0x18c0001f, 0x10006294, 0xe0f07fff, 0xe0e00fff,
	0xe0e000ff, 0x81449801, 0xd8005045, 0x17c07c1f, 0x1a00001f, 0x10006604,
	0xe2200001, 0xc0c03de0, 0x17c07c1f, 0xe2200006, 0x18c0001f, 0x10001130,
	0x1910001f, 0x10001130, 0xa1108404, 0xe0c00004, 0xc0c03de0, 0x17c07c1f,
	0xa1d38407, 0xa1d98407, 0xa0108400, 0xa0120400, 0xa0148400, 0xa0150400,
	0xa0158400, 0xa01b8400, 0xa01c0400, 0xa01c8400, 0xa0188400, 0xa0190400,
	0xa0198400, 0x81441801, 0xd82054e5, 0x17c07c1f, 0x1910001f, 0x10006b0c,
	0x1a00001f, 0x100062c4, 0x1950001f, 0x100062c4, 0x80809001, 0x81748405,
	0xa1548805, 0xe2000005, 0x1a00001f, 0x10006b0c, 0x80c51801, 0x81308404,
	0xa1108c04, 0xe2000004, 0x1b00001f, 0x2f7ce7ff, 0x80c09401, 0xc8e03723,
	0x17c07c1f, 0xe8208000, 0x10006310, 0x0b1603f8, 0x1950001f, 0x100062c4,
	0x80841401, 0x81600801, 0x18c0001f, 0xaf7ce7ff, 0xa0de0803, 0xa0db9403,
	0x13000c1f, 0xe8208000, 0x1000110c, 0x00000454, 0xe8208000, 0x10001110,
	0x00003e62, 0xe8208000, 0x10001114, 0x00000454, 0xe8208000, 0x10001118,
	0x00002262, 0x1a00001f, 0x10006604, 0xc0c03de0, 0xe2200002, 0x1b80001f,
	0x90100000, 0x80c00001, 0xc8c00903, 0x17c07c1f, 0x18d0001f, 0x10006284,
	0x80810c01, 0xd8205c62, 0x17c07c1f, 0x18d0001f, 0x100062c4, 0x80840c01,
	0xd8005c62, 0x17c07c1f, 0x18c0001f, 0x10001138, 0x1910001f, 0x10001138,
	0xa1108404, 0xe0c00004, 0x1910001f, 0x10001138, 0x1a00001f, 0x10006604,
	0xe2200007, 0x1a00001f, 0x100062c4, 0x1890001f, 0x100062c4, 0xa0940402,
	0xe2000002, 0x80c10001, 0xc8c01423, 0x17c07c1f, 0x1b00001f, 0x2f7ce7ff,
	0x18c0001f, 0x10006294, 0xe0e001fe, 0xe0e003fc, 0xe0e007f8, 0xe0e00ff0,
	0x1b80001f, 0x20000020, 0xe0f07ff0, 0xe0f07f00, 0x81449801, 0xd80060e5,
	0x17c07c1f, 0x1a00001f, 0x10006604, 0xe2200006, 0xc0c03de0, 0x17c07c1f,
	0xe2200000, 0x18c0001f, 0x10001130, 0x1910001f, 0x10001130, 0x81308404,
	0xe0c00004, 0xc0c03de0, 0x17c07c1f, 0x1b80001f, 0x200016a8, 0xc0c03de0,
	0xe2200003, 0x1880001f, 0x1000110c, 0xe0a00618, 0x1880001f, 0x10001114,
	0xe0a00618, 0x18d0001f, 0x10006b6c, 0x1880001f, 0x10001110, 0xe0800003,
	0x1880001f, 0x10001118, 0x11080c1f, 0xe0800004, 0x80388400, 0x80390400,
	0x80398400, 0x1b80001f, 0x20000300, 0x803b8400, 0x803c0400, 0x803c8400,
	0x1b80001f, 0x20000300, 0x80348400, 0x80350400, 0x80358400, 0x1b80001f,
	0x20000104, 0x10007c1f, 0x81f38407, 0x81f98407, 0x81f90407, 0x81f40407,
	0x81401801, 0xd80069e5, 0x17c07c1f, 0x18c0001f, 0x100062dc, 0xe0c0001f,
	0x18c0001f, 0x10006290, 0x1212841f, 0xc0c07500, 0x12807c1f, 0xc0c07500,
	0x1280041f, 0x18c0001f, 0x10006208, 0x1212841f, 0xc0c07500, 0x12807c1f,
	0xe8208000, 0x10006244, 0x00000000, 0x1b80001f, 0x20000080, 0xc0c07500,
	0x1280041f, 0x18c0001f, 0x10006200, 0x1212841f, 0xc0c07500, 0x12807c1f,
	0xe8208000, 0x1000625c, 0x00000000, 0x1b80001f, 0x20000080, 0xc0c07500,
	0x1280041f, 0xe8208000, 0x10006824, 0x000f0000, 0x81f48407, 0xa1d60407,
	0x81f10407, 0xa1db0407, 0xe8208000, 0x10006310, 0x0b160008, 0xc2803ec0,
	0x1293841f, 0x18c0001f, 0x10006b14, 0xe0c0000c, 0x18c0001f, 0x10006b68,
	0x1950001f, 0x100063c0, 0xe0c00005, 0x81441801, 0xd8207085, 0x10c0041f,
	0x1910001f, 0x100062c4, 0x80849001, 0x1a00001f, 0x10006b0c, 0x1910001f,
	0x10006b0c, 0xa0908804, 0xe2000002, 0x81441801, 0xd8207085, 0x10c0041f,
	0x1910001f, 0x100062c4, 0x80809001, 0x81600801, 0xa0d59403, 0xa0d60803,
	0xd8007025, 0x17c07c1f, 0x80841001, 0x81600801, 0xa0db9403, 0xa0de0803,
	0xd8007025, 0x17c07c1f, 0x80f60403, 0xe8208000, 0x10006310, 0x0b160c38,
	0x13000c1f, 0x1b80001f, 0x900a0000, 0x88900001, 0x10006814, 0xd8206de2,
	0x17c07c1f, 0x18d0001f, 0x10006b6c, 0x78a00003, 0x0000beef, 0xd80072a2,
	0x17c07c1f, 0xc0c07a40, 0x17c07c1f, 0xd0006de0, 0x17c07c1f, 0x1910001f,
	0x10006b0c, 0x1a00001f, 0x100062c4, 0x1950001f, 0x100062c4, 0x80809001,
	0x81748405, 0xa1548805, 0xe2000005, 0x80841401, 0xd8007482, 0x8204b401,
	0xc8c00008, 0x17c07c1f, 0x1ac0001f, 0x55aa55aa, 0x10007c1f, 0xf0000000,
	0xd800760a, 0x17c07c1f, 0xe2e00036, 0x17c07c1f, 0x17c07c1f, 0xe2e0003e,
	0x1380201f, 0xe2e0003c, 0xd820774a, 0x17c07c1f, 0x1b80001f, 0x20000018,
	0xe2e0007c, 0x1b80001f, 0x20000003, 0xe2e0005c, 0xe2e0004c, 0xe2e0004d,
	0xf0000000, 0x17c07c1f, 0xd800782a, 0x17c07c1f, 0xe2e0004f, 0xe2e0006f,
	0xe2e0002f, 0xd82078ca, 0x17c07c1f, 0xe2e0002e, 0xe2e0003e, 0xe2e00032,
	0xf0000000, 0x17c07c1f, 0xa1d10407, 0x1b80001f, 0x20000020, 0xf0000000,
	0x17c07c1f, 0xa1d40407, 0x1391841f, 0xa1d90407, 0xf0000000, 0x17c07c1f,
	0x1900001f, 0x10006014, 0x1950001f, 0x10006014, 0xa1508405, 0xe1000005,
	0x1900001f, 0x10006814, 0xe100001f, 0x812ab401, 0xd8007b64, 0x17c07c1f,
	0x1880001f, 0x10006284, 0x18d0001f, 0x10006284, 0x80f20403, 0xe0800003,
	0x80f08403, 0xe0800003, 0x1900001f, 0x10006014, 0x1950001f, 0x10006014,
	0x81708405, 0xe1000005, 0x1900001f, 0x10006b6c, 0xe100001f, 0x81441801,
	0xd8007fa5, 0x17c07c1f, 0x18c0001f, 0x10001138, 0x1910001f, 0x10001138,
	0xa1108404, 0xe0c00004, 0x1910001f, 0x10001138, 0x1a00001f, 0x10006604,
	0xe2200007, 0xf0000000, 0x17c07c1f
};
static struct pcm_desc suspend_pcm = {
	.version	= "pcm_suspend_v34.5.11.3.3.8_20160128-dummy_read",
	.base		= suspend_binary,
	.size		= 1023,
	.sess		= 2,
	.replace	= 0,
	.vec0		= EVENT_VEC(23, 1, 0, 0),	/* FUNC_MD_VRF18_WAKEUP */
	.vec1		= EVENT_VEC(28, 1, 0, 36),	/* FUNC_MD_VRF18_SLEEP */
	.vec2		= EVENT_VEC(11, 1, 0, 72),	/* FUNC_26M_WAKEUP */
	.vec3		= EVENT_VEC(12, 1, 0, 106),	/* FUNC_26M_SLEEP */
	.vec4		= EVENT_VEC(30, 1, 0, 161),	/* FUNC_APSRC_WAKEUP */
	.vec5		= EVENT_VEC(31, 1, 0, 246),	/* FUNC_APSRC_SLEEP */
	.vec6		= EVENT_VEC(11, 1, 0, 441),	/* FUNC_VCORE_HIGH */
	.vec7		= EVENT_VEC(12, 1, 0, 468),	/* FUNC_VCORE_LOW */
};



#elif defined(CONFIG_ARCH_MT6735M)
static const u32 suspend_binary[] = {
	0x81429801, 0xd80001e5, 0x17c07c1f, 0x18c0001f, 0x10001124, 0x1910001f,
	0x10001124, 0xa1108404, 0xe0c00004, 0x1910001f, 0x10001124, 0x1a00001f,
	0x10006604, 0xc0c03da0, 0xe2200007, 0x1a00001f, 0x100062c4, 0x1890001f,
	0x100062c4, 0xa0940402, 0x1b00001f, 0x10000001, 0x1910001f, 0x10006310,
	0x80c39001, 0xd8200443, 0xe2000002, 0x80c10001, 0x1b00001f, 0xbf7ce7ff,
	0xd8200443, 0x17c07c1f, 0x1b00001f, 0x7f7ce7ff, 0xf0000000, 0x17c07c1f,
	0x81429801, 0xd8000665, 0x17c07c1f, 0x18c0001f, 0x10001124, 0x1910001f,
	0x10001124, 0x81308404, 0xe0c00004, 0x1910001f, 0x10001124, 0x1a00001f,
	0x10006604, 0xc0c03da0, 0xe2200007, 0x1a00001f, 0x100062c4, 0x1890001f,
	0x100062c4, 0x80b40402, 0x1b00001f, 0x00801001, 0x1910001f, 0x10006310,
	0x80c39001, 0xd82008c3, 0xe2000002, 0x80c10001, 0x1b00001f, 0x6ffcf7ff,
	0xd80008c3, 0x17c07c1f, 0x1b00001f, 0xaffce7ff, 0xf0000000, 0x17c07c1f,
	0x81f58407, 0x81f68407, 0x1800001f, 0x17cf0f3f, 0x1b80001f, 0x20000000,
	0x1800001f, 0x17cf0f16, 0xa1d28407, 0x81f20407, 0x81409801, 0xd8000b25,
	0x17c07c1f, 0x18c0001f, 0x10006234, 0xc0c02920, 0x1200041f, 0x80310400,
	0x1b80001f, 0x2000000a, 0xa0110400, 0x81f00407, 0xa1dd0407, 0x18c0001f,
	0x100062d8, 0xc0c02be0, 0x1200041f, 0x81fd0407, 0xc2803e80, 0x1290041f,
	0x1b00001f, 0x6ffcf7ff, 0xf0000000, 0x17c07c1f, 0x1b00001f, 0x2f7ce7ff,
	0x1b80001f, 0x20000004, 0xd80013ec, 0x17c07c1f, 0x1880001f, 0x10006320,
	0xc0c02f00, 0xe080000f, 0xd8200f43, 0x17c07c1f, 0x1b00001f, 0x6ffcf7ff,
	0xd00013e0, 0x17c07c1f, 0xe080001f, 0x81409801, 0xd80011c5, 0x17c07c1f,
	0x18c0001f, 0x10214094, 0x1910001f, 0x1020e374, 0xe0c00004, 0x18c0001f,
	0x10214098, 0x1910001f, 0x1020e378, 0xe0c00004, 0x1910001f, 0x10213378,
	0x18c0001f, 0x10006234, 0xc0c02b00, 0x17c07c1f, 0x18c0001f, 0x100062d8,
	0xc0c02d00, 0x17c07c1f, 0xc2803e80, 0x1290841f, 0xa1d20407, 0x81f28407,
	0xa1d68407, 0x1800001f, 0x17cf0f3f, 0x1800001f, 0x17ff0f3f, 0x19c0001f,
	0x001c2397, 0x1b00001f, 0x2f7cefff, 0xf0000000, 0x17c07c1f, 0x81411801,
	0xd8001545, 0x17c07c1f, 0x18c0001f, 0x10006240, 0xe0e00016, 0xe0e0001e,
	0xe0e0000e, 0xe0e0000f, 0x803e0400, 0x1b80001f, 0x20000222, 0x80380400,
	0x1b80001f, 0x20000280, 0x803b0400, 0x1b80001f, 0x2000001a, 0x803d0400,
	0x1b80001f, 0x20000208, 0x80340400, 0x80310400, 0xe8208000, 0x10210044,
	0x00000100, 0x1b80001f, 0x20000068, 0x1b80001f, 0x2000000a, 0x18c0001f,
	0x10006240, 0xe0e0000d, 0xd8001c05, 0x17c07c1f, 0x1b80001f, 0x20000020,
	0x18c0001f, 0x102130f0, 0x1910001f, 0x102130f0, 0xa9000004, 0x10000000,
	0xe0c00004, 0x1b80001f, 0x2000000a, 0x89000004, 0xefffffff, 0xe0c00004,
	0x18c0001f, 0x102140f4, 0x1910001f, 0x102140f4, 0xa9000004, 0x02000000,
	0xe0c00004, 0x1b80001f, 0x2000000a, 0x89000004, 0xfdffffff, 0xe0c00004,
	0x1910001f, 0x102140f4, 0x81fa0407, 0x81f08407, 0xe8208000, 0x10006354,
	0x001fdaa3, 0xa9c00007, 0x60010000, 0xc2803e80, 0x1291041f, 0x1b00001f,
	0xbf7ce7ff, 0x1950001f, 0x100062c4, 0x80c41401, 0xd8001e43, 0x17c07c1f,
	0x1b00001f, 0xaffce7ff, 0xf0000000, 0x17c07c1f, 0x1b80001f, 0x20000fdf,
	0x1a50001f, 0x10006608, 0x80c9a401, 0x810ba401, 0x10920c1f, 0xa0979002,
	0x80ca2401, 0xa0938c02, 0x8080080d, 0xd82022a2, 0x17c07c1f, 0x81f08407,
	0xa9c00007, 0x60010000, 0x1b00001f, 0x2f7ce7ff, 0x1b80001f, 0x20000004,
	0xd80028ec, 0x17c07c1f, 0x1b00001f, 0xbf7ce7ff, 0x1950001f, 0x100062c4,
	0x80c41401, 0xd80028e3, 0x17c07c1f, 0x1b00001f, 0xaffce7ff, 0xd00028e0,
	0x17c07c1f, 0x89c00007, 0x9ffeffff, 0x1900001f, 0x40000000, 0x18d0001f,
	0x40000000, 0xe1000003, 0xc0c03020, 0x1080041f, 0x1880001f, 0x10006320,
	0xc0c02da0, 0xe080000f, 0xd8002023, 0x17c07c1f, 0xe080001f, 0xa1da0407,
	0xe8208000, 0x10210048, 0x00000100, 0x1b80001f, 0x20000068, 0xa0110400,
	0xa0140400, 0xa0180400, 0xa01b0400, 0xa01d0400, 0x1b80001f, 0x20000068,
	0xa01e0400, 0x1b80001f, 0x20000104, 0x81411801, 0xd8002785, 0x17c07c1f,
	0x18c0001f, 0x10006240, 0xc0c02d00, 0x17c07c1f, 0xc2803e80, 0x1291841f,
	0x1b00001f, 0x6ffcf7ff, 0x1950001f, 0x100062c4, 0x80c41401, 0xd82028e3,
	0x17c07c1f, 0x1b00001f, 0x7f7ce7ff, 0xf0000000, 0x17c07c1f, 0xe0f07f16,
	0x1380201f, 0xe0f07f1e, 0x1380201f, 0xe0f07f0e, 0x1b80001f, 0x20000100,
	0xe0f07f0c, 0xe0f07f0d, 0xe0f07e0d, 0xe0f07c0d, 0xe0f0780d, 0xe0f0700d,
	0xf0000000, 0x17c07c1f, 0xe0f07f0d, 0xe0f07f1d, 0xe0f07f1f, 0xe0f07f1e,
	0xe0f07f12, 0xf0000000, 0x17c07c1f, 0xe0e00016, 0x1380201f, 0xe0e0001e,
	0x1380201f, 0xe0e0000e, 0xe0e0000c, 0xe0e0000d, 0xf0000000, 0x17c07c1f,
	0xe0e0000f, 0xe0e0001e, 0xe0e00012, 0xf0000000, 0x17c07c1f, 0x1112841f,
	0xa1d08407, 0xd8202e64, 0x80eab401, 0xd8002de3, 0x01200404, 0x1a00001f,
	0x10006814, 0xe2000003, 0xf0000000, 0x17c07c1f, 0xa1d00407, 0x1b80001f,
	0x20000100, 0x80ea3401, 0x1a00001f, 0x10006814, 0xe2000003, 0xf0000000,
	0x17c07c1f, 0x81499801, 0xd8203185, 0x17c07c1f, 0xd82036a2, 0x17c07c1f,
	0x18d0001f, 0x40000000, 0x18d0001f, 0x70000000, 0xd8003082, 0x00a00402,
	0x814a1801, 0xd82032e5, 0x17c07c1f, 0xd82036a2, 0x17c07c1f, 0x18d0001f,
	0x40000000, 0x18d0001f, 0x80000000, 0xd80031e2, 0x00a00402, 0x814a9801,
	0xd8203445, 0x17c07c1f, 0xd82036a2, 0x17c07c1f, 0x18d0001f, 0x40000000,
	0x18d0001f, 0xc0000000, 0xd8003342, 0x00a00402, 0x814c1801, 0xd82035a5,
	0x17c07c1f, 0xd82036a2, 0x17c07c1f, 0x18d0001f, 0x40000000, 0x18d0001f,
	0xa0000000, 0xd80034a2, 0x00a00402, 0xd82036a2, 0x17c07c1f, 0x18d0001f,
	0x40000000, 0x18d0001f, 0x40000000, 0xd80035a2, 0x00a00402, 0xf0000000,
	0x17c07c1f, 0x81441801, 0xd8203905, 0x17c07c1f, 0x1a00001f, 0x10006604,
	0xc0c03da0, 0xe2200004, 0xc0c03020, 0x1093041f, 0xc0c03da0, 0xe2200003,
	0xc0c03020, 0x1093041f, 0xc0c03da0, 0xe2200002, 0xc0c03020, 0x1093041f,
	0x1a00001f, 0x100062c4, 0x1890001f, 0x100062c4, 0xa0908402, 0xe2000002,
	0x1b00001f, 0x00801001, 0xf0000000, 0x17c07c1f, 0x1a00001f, 0x100062c4,
	0x1890001f, 0x100062c4, 0x80b08402, 0xe2000002, 0x81441801, 0xd8203d25,
	0x17c07c1f, 0x1a00001f, 0x10006604, 0xc0c03da0, 0xe2200003, 0xc0c03020,
	0x1093041f, 0xc0c03da0, 0xe2200004, 0xc0c03020, 0x1093041f, 0xc0c03da0,
	0xe2200005, 0xc0c03020, 0x1093041f, 0x1b00001f, 0x00000801, 0xf0000000,
	0x17c07c1f, 0x18d0001f, 0x10006604, 0x10cf8c1f, 0xd8203da3, 0x17c07c1f,
	0xf0000000, 0x17c07c1f, 0x18c0001f, 0x10006b18, 0x1910001f, 0x10006b18,
	0xa1002804, 0xe0c00004, 0xf0000000, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x1840001f, 0x00000001, 0xa1d48407, 0x1990001f,
	0x10006b08, 0xe8208000, 0x10006b18, 0x00000000, 0x81441801, 0xd8204565,
	0x17c07c1f, 0x1910001f, 0x100062c4, 0x80849001, 0x1a00001f, 0x10006b0c,
	0x1950001f, 0x10006b0c, 0xa1508805, 0xe2000005, 0x18c0001f, 0x2f7ce7ff,
	0x80809001, 0x81600801, 0xa0d59403, 0xa0d60803, 0xd8004465, 0x17c07c1f,
	0x80841001, 0x81600801, 0xa0db9403, 0xa0de0803, 0xd8004465, 0x17c07c1f,
	0x80f60403, 0xe8208000, 0x10006310, 0x0b160c38, 0x13000c1f, 0x1b80001f,
	0xd00f0000, 0xd00045a0, 0x17c07c1f, 0x1b00001f, 0x2f7ce7ff, 0x81469801,
	0xd8204705, 0x17c07c1f, 0x1b80001f, 0xd00f0000, 0x8880000c, 0x2f7ce7ff,
	0xd80069e2, 0x17c07c1f, 0xd0004740, 0x17c07c1f, 0x1b80001f, 0x500f0000,
	0xe8208000, 0x10006354, 0x001fdaa3, 0xc0c07900, 0x81401801, 0xd8004c65,
	0x17c07c1f, 0x81f60407, 0x18c0001f, 0x10006200, 0xc0c07780, 0x12807c1f,
	0xe8208000, 0x1000625c, 0x00000001, 0x1b80001f, 0x20000080, 0xc0c07780,
	0x1280041f, 0x18c0001f, 0x10006208, 0xc0c07780, 0x12807c1f, 0xe8208000,
	0x10006244, 0x00000001, 0x1b80001f, 0x20000080, 0xc0c07780, 0x1280041f,
	0x18c0001f, 0x10006290, 0xc0c07780, 0x12807c1f, 0xc0c07780, 0x1280041f,
	0x18c0001f, 0x100062dc, 0xe0c00001, 0xc2803e80, 0x1292041f, 0x81469801,
	0xd8004d45, 0x17c07c1f, 0x8880000c, 0x2f7ce7ff, 0xd8006542, 0x17c07c1f,
	0xc0c079a0, 0x17c07c1f, 0x18c0001f, 0x10006294, 0xe0f07fff, 0xe0e00fff,
	0xe0e000ff, 0x81449801, 0xd8005045, 0x17c07c1f, 0x1a00001f, 0x10006604,
	0xe2200001, 0xc0c03da0, 0x17c07c1f, 0xe2200006, 0x18c0001f, 0x1000111c,
	0x1910001f, 0x1000111c, 0xa1108404, 0xe0c00004, 0xc0c03da0, 0x17c07c1f,
	0xa1d38407, 0xa1d98407, 0xa0108400, 0xa0120400, 0xa0148400, 0xa0150400,
	0xa0158400, 0xa01b8400, 0xa01c0400, 0xa01c8400, 0xa0188400, 0xa0190400,
	0xa0198400, 0x81441801, 0xd82054e5, 0x17c07c1f, 0x1910001f, 0x10006b0c,
	0x1a00001f, 0x100062c4, 0x1950001f, 0x100062c4, 0x80809001, 0x81748405,
	0xa1548805, 0xe2000005, 0x1a00001f, 0x10006b0c, 0x80c51801, 0x81308404,
	0xa1108c04, 0xe2000004, 0x1b00001f, 0x2f7ce7ff, 0x80c09401, 0xc8e036e3,
	0x17c07c1f, 0xe8208000, 0x10006310, 0x0b1603f8, 0x1950001f, 0x100062c4,
	0x80841401, 0x81600801, 0x18c0001f, 0xaf7ce7ff, 0xa0de0803, 0xa0db9403,
	0x13000c1f, 0xe8208000, 0x100010f8, 0x00000454, 0xe8208000, 0x100010fc,
	0x00003e62, 0xe8208000, 0x10001100, 0x00000454, 0xe8208000, 0x10001104,
	0x00002262, 0x1a00001f, 0x10006604, 0xc0c03da0, 0xe2200002, 0x1b80001f,
	0x90100000, 0x80c00001, 0xc8c00903, 0x17c07c1f, 0x18d0001f, 0x10006284,
	0x80810c01, 0xd8205c62, 0x17c07c1f, 0x18d0001f, 0x100062c4, 0x80840c01,
	0xd8005c62, 0x17c07c1f, 0x18c0001f, 0x10001124, 0x1910001f, 0x10001124,
	0xa1108404, 0xe0c00004, 0x1910001f, 0x10001124, 0x1a00001f, 0x10006604,
	0xe2200007, 0x1a00001f, 0x100062c4, 0x1890001f, 0x100062c4, 0xa0940402,
	0xe2000002, 0x80c10001, 0xc8c01423, 0x17c07c1f, 0x1b00001f, 0x2f7ce7ff,
	0x18c0001f, 0x10006294, 0xe0e001fe, 0xe0e003fc, 0xe0e007f8, 0xe0e00ff0,
	0x1b80001f, 0x20000020, 0xe0f07ff0, 0xe0f07f00, 0x81449801, 0xd80060e5,
	0x17c07c1f, 0x1a00001f, 0x10006604, 0xe2200006, 0xc0c03da0, 0x17c07c1f,
	0xe2200000, 0x18c0001f, 0x1000111c, 0x1910001f, 0x1000111c, 0x81308404,
	0xe0c00004, 0xc0c03da0, 0x17c07c1f, 0x1b80001f, 0x200016a8, 0xc0c03da0,
	0xe2200003, 0x1880001f, 0x100010f8, 0xe0a00618, 0x1880001f, 0x10001100,
	0xe0a00618, 0x18d0001f, 0x10006b6c, 0x1880001f, 0x100010fc, 0xe0800003,
	0x1880001f, 0x10001104, 0x11080c1f, 0xe0800004, 0x80388400, 0x80390400,
	0x80398400, 0x1b80001f, 0x20000300, 0x803b8400, 0x803c0400, 0x803c8400,
	0x1b80001f, 0x20000300, 0x80348400, 0x80350400, 0x80358400, 0x1b80001f,
	0x20000104, 0x10007c1f, 0x81f38407, 0x81f98407, 0x81f90407, 0x81f40407,
	0x81401801, 0xd80069e5, 0x17c07c1f, 0x18c0001f, 0x100062dc, 0xe0c0001f,
	0x18c0001f, 0x10006290, 0x1212841f, 0xc0c07500, 0x12807c1f, 0xc0c07500,
	0x1280041f, 0x18c0001f, 0x10006208, 0x1212841f, 0xc0c07500, 0x12807c1f,
	0xe8208000, 0x10006244, 0x00000000, 0x1b80001f, 0x20000080, 0xc0c07500,
	0x1280041f, 0x18c0001f, 0x10006200, 0x1212841f, 0xc0c07500, 0x12807c1f,
	0xe8208000, 0x1000625c, 0x00000000, 0x1b80001f, 0x20000080, 0xc0c07500,
	0x1280041f, 0xe8208000, 0x10006824, 0x000f0000, 0x81f48407, 0xa1d60407,
	0x81f10407, 0xa1db0407, 0xe8208000, 0x10006310, 0x0b160008, 0xc2803e80,
	0x1293841f, 0x18c0001f, 0x10006b14, 0xe0c0000c, 0x18c0001f, 0x10006b68,
	0x1950001f, 0x100063c0, 0xe0c00005, 0x81441801, 0xd8207085, 0x10c0041f,
	0x1910001f, 0x100062c4, 0x80849001, 0x1a00001f, 0x10006b0c, 0x1910001f,
	0x10006b0c, 0xa0908804, 0xe2000002, 0x81441801, 0xd8207085, 0x10c0041f,
	0x1910001f, 0x100062c4, 0x80809001, 0x81600801, 0xa0d59403, 0xa0d60803,
	0xd8007025, 0x17c07c1f, 0x80841001, 0x81600801, 0xa0db9403, 0xa0de0803,
	0xd8007025, 0x17c07c1f, 0x80f60403, 0xe8208000, 0x10006310, 0x0b160c38,
	0x13000c1f, 0x1b80001f, 0x900a0000, 0x88900001, 0x10006814, 0xd8206de2,
	0x17c07c1f, 0x18d0001f, 0x10006b6c, 0x78a00003, 0x0000beef, 0xd80072a2,
	0x17c07c1f, 0xc0c07a40, 0x17c07c1f, 0xd0006de0, 0x17c07c1f, 0x1910001f,
	0x10006b0c, 0x1a00001f, 0x100062c4, 0x1950001f, 0x100062c4, 0x80809001,
	0x81748405, 0xa1548805, 0xe2000005, 0x80841401, 0xd8007482, 0x8204b401,
	0xc8c00008, 0x17c07c1f, 0x1ac0001f, 0x55aa55aa, 0x10007c1f, 0xf0000000,
	0xd800760a, 0x17c07c1f, 0xe2e00036, 0x17c07c1f, 0x17c07c1f, 0xe2e0003e,
	0x1380201f, 0xe2e0003c, 0xd820774a, 0x17c07c1f, 0x1b80001f, 0x20000018,
	0xe2e0007c, 0x1b80001f, 0x20000003, 0xe2e0005c, 0xe2e0004c, 0xe2e0004d,
	0xf0000000, 0x17c07c1f, 0xd800782a, 0x17c07c1f, 0xe2e0004f, 0xe2e0006f,
	0xe2e0002f, 0xd82078ca, 0x17c07c1f, 0xe2e0002e, 0xe2e0003e, 0xe2e00032,
	0xf0000000, 0x17c07c1f, 0xa1d10407, 0x1b80001f, 0x20000020, 0xf0000000,
	0x17c07c1f, 0xa1d40407, 0x1391841f, 0xa1d90407, 0xf0000000, 0x17c07c1f,
	0x1900001f, 0x10006014, 0x1950001f, 0x10006014, 0xa1508405, 0xe1000005,
	0x1900001f, 0x10006814, 0xe100001f, 0x812ab401, 0xd8007b64, 0x17c07c1f,
	0x1880001f, 0x10006284, 0x18d0001f, 0x10006284, 0x80f20403, 0xe0800003,
	0x80f08403, 0xe0800003, 0x1900001f, 0x10006014, 0x1950001f, 0x10006014,
	0x81708405, 0xe1000005, 0x1900001f, 0x10006b6c, 0xe100001f, 0x81441801,
	0xd8007fa5, 0x17c07c1f, 0x18c0001f, 0x10001124, 0x1910001f, 0x10001124,
	0xa1108404, 0xe0c00004, 0x1910001f, 0x10001124, 0x1a00001f, 0x10006604,
	0xe2200007, 0xf0000000, 0x17c07c1f
};
static struct pcm_desc suspend_pcm = {
	.version	= "pcm_suspend_v0.5.4.5_20160311-dummy_read",
	.base		= suspend_binary,
	.size		= 1023,
	.sess		= 2,
	.replace	= 0,
	.vec0		= EVENT_VEC(23, 1, 0, 0),	/* FUNC_MD_VRF18_WAKEUP */
	.vec1		= EVENT_VEC(28, 1, 0, 36),	/* FUNC_MD_VRF18_SLEEP */
	.vec2		= EVENT_VEC(11, 1, 0, 72),	/* FUNC_26M_WAKEUP */
	.vec3		= EVENT_VEC(12, 1, 0, 106),	/* FUNC_26M_SLEEP */
	.vec4		= EVENT_VEC(30, 1, 0, 161),	/* FUNC_APSRC_WAKEUP */
	.vec5		= EVENT_VEC(31, 1, 0, 244),	/* FUNC_APSRC_SLEEP */
	.vec6		= EVENT_VEC(11, 1, 0, 439),	/* FUNC_VCORE_HIGH */
	.vec7		= EVENT_VEC(12, 1, 0, 466),	/* FUNC_VCORE_LOW */
};



#elif defined(CONFIG_ARCH_MT6753)
static const u32 suspend_binary[] = {
	0x81429801, 0xd80000e5, 0x17c07c1f, 0x1a00001f, 0x10006604, 0xc0c03e00,
	0xe2200007, 0x1a00001f, 0x100062c4, 0x1890001f, 0x100062c4, 0xa0940402,
	0xe2000002, 0x10c0041f, 0x81008801, 0x81601001, 0xa0d59403, 0xa0d61003,
	0xa0de0403, 0x1910001f, 0x10006310, 0x81439001, 0xd82003e5, 0x13000c1f,
	0x80c10001, 0x1b00001f, 0xbf7ce7ff, 0xd82003e3, 0x17c07c1f, 0x1b00001f,
	0x7f7ce7ff, 0xf0000000, 0x17c07c1f, 0x81429801, 0xd8000505, 0x17c07c1f,
	0x1a00001f, 0x10006604, 0xc0c03e00, 0xe2200009, 0x1a00001f, 0x100062c4,
	0x1890001f, 0x100062c4, 0x80b40402, 0xe2000002, 0x10c0041f, 0x81008801,
	0x81601001, 0xa0d59403, 0xa0d61003, 0xa0db8403, 0x1910001f, 0x10006310,
	0x81439001, 0xd8200805, 0x13000c1f, 0x80c10001, 0x1b00001f, 0x6ffcf7ff,
	0xd8000803, 0x17c07c1f, 0x1b00001f, 0xaffce7ff, 0xf0000000, 0x17c07c1f,
	0x81f58407, 0x81f68407, 0x1800001f, 0x17cf0f3f, 0x1b80001f, 0x20000000,
	0x1800001f, 0x17cf0f16, 0xa1d28407, 0x81f20407, 0x81409801, 0xd8000a65,
	0x17c07c1f, 0x18c0001f, 0x10006234, 0xc0c02840, 0x1200041f, 0x80310400,
	0x1b80001f, 0x2000000a, 0xa0110400, 0x81f00407, 0xa1dd0407, 0x18c0001f,
	0x100062d8, 0xc0c02b00, 0x1200041f, 0x81fd0407, 0xc2803ee0, 0x1290041f,
	0x1b00001f, 0x6ffcf7ff, 0xf0000000, 0x17c07c1f, 0x1b00001f, 0x2f7ce7ff,
	0x1b80001f, 0x20000004, 0xd800132c, 0x17c07c1f, 0x1880001f, 0x10006320,
	0xc0c02e20, 0xe080000f, 0xd8200e83, 0x17c07c1f, 0x1b00001f, 0x6ffcf7ff,
	0xd0001320, 0x17c07c1f, 0xe080001f, 0x81409801, 0xd8001105, 0x17c07c1f,
	0x18c0001f, 0x10214094, 0x1910001f, 0x1020e374, 0xe0c00004, 0x18c0001f,
	0x10214098, 0x1910001f, 0x1020e378, 0xe0c00004, 0x1910001f, 0x10213378,
	0x18c0001f, 0x10006234, 0xc0c02a20, 0x17c07c1f, 0x18c0001f, 0x100062d8,
	0xc0c02c20, 0x17c07c1f, 0xc2803ee0, 0x1290841f, 0xa1d20407, 0x81f28407,
	0xa1d68407, 0x1800001f, 0x17cf0f3f, 0x1800001f, 0x17ff0f3f, 0x19c0001f,
	0x001c2397, 0x1b00001f, 0x2f7cefff, 0xf0000000, 0x17c07c1f, 0x81411801,
	0xd8001485, 0x17c07c1f, 0x18c0001f, 0x10006240, 0xe0e00016, 0xe0e0001e,
	0xe0e0000e, 0xe0e0000f, 0x803e0400, 0x1b80001f, 0x20000222, 0x80380400,
	0x1b80001f, 0x20000280, 0x803b0400, 0x1b80001f, 0x2000001a, 0x803d0400,
	0x1b80001f, 0x20000208, 0x80340400, 0x80310400, 0xe8208000, 0x10210044,
	0x00000100, 0x1b80001f, 0x20000068, 0x1b80001f, 0x2000000a, 0x18c0001f,
	0x10006240, 0xe0e0000d, 0xd8001b45, 0x17c07c1f, 0x1b80001f, 0x20000020,
	0x18c0001f, 0x102130f0, 0x1910001f, 0x102130f0, 0xa9000004, 0x10000000,
	0xe0c00004, 0x1b80001f, 0x2000000a, 0x89000004, 0xefffffff, 0xe0c00004,
	0x18c0001f, 0x102140f4, 0x1910001f, 0x102140f4, 0xa9000004, 0x02000000,
	0xe0c00004, 0x1b80001f, 0x2000000a, 0x89000004, 0xfdffffff, 0xe0c00004,
	0x1910001f, 0x102140f4, 0x81fa0407, 0x81f08407, 0xe8208000, 0x10006354,
	0x001fdaa3, 0xa9c00007, 0x60010000, 0xc2803ee0, 0x1291041f, 0x1b00001f,
	0xbf7ce7ff, 0x1950001f, 0x100062c4, 0x80c41401, 0xd8001d83, 0x17c07c1f,
	0x1b00001f, 0xaffce7ff, 0xf0000000, 0x17c07c1f, 0x1b80001f, 0x20000fdf,
	0x1a50001f, 0x10006608, 0x80c9a401, 0x810ba401, 0x10920c1f, 0xa0979002,
	0x80ca2401, 0xa0938c02, 0x8080080d, 0xd82021e2, 0x17c07c1f, 0x81f08407,
	0xa9c00007, 0x60010000, 0x1b00001f, 0x2f7ce7ff, 0x1b80001f, 0x20000004,
	0xd800280c, 0x17c07c1f, 0x1b00001f, 0xbf7ce7ff, 0x1950001f, 0x100062c4,
	0x80c41401, 0xd8002803, 0x17c07c1f, 0x1b00001f, 0xaffce7ff, 0xd0002800,
	0x17c07c1f, 0x89c00007, 0x9ffeffff, 0x1900001f, 0x40000000, 0x18d0001f,
	0x40000000, 0xe1000003, 0xc0c02f40, 0x1080041f, 0x1880001f, 0x10006320,
	0xc0c02cc0, 0xe080000f, 0xd8001f63, 0x17c07c1f, 0xe080001f, 0xa1da0407,
	0xe8208000, 0x10210048, 0x00000100, 0x1b80001f, 0x20000068, 0xa0110400,
	0xa0140400, 0xa8000000, 0x04410000, 0x1b80001f, 0x20000068, 0xa01e0400,
	0x1b80001f, 0x20000104, 0x81411801, 0xd80026a5, 0x17c07c1f, 0x18c0001f,
	0x10006240, 0xc0c02c20, 0x17c07c1f, 0xc2803ee0, 0x1291841f, 0x1b00001f,
	0x6ffcf7ff, 0x1950001f, 0x100062c4, 0x80c41401, 0xd8202803, 0x17c07c1f,
	0x1b00001f, 0x7f7ce7ff, 0xf0000000, 0x17c07c1f, 0xe0f07f16, 0x1380201f,
	0xe0f07f1e, 0x1380201f, 0xe0f07f0e, 0x1b80001f, 0x20000100, 0xe0f07f0c,
	0xe0f07f0d, 0xe0f07e0d, 0xe0f07c0d, 0xe0f0780d, 0xe0f0700d, 0xf0000000,
	0x17c07c1f, 0xe0f07f0d, 0xe0f07f1d, 0xe0f07f1f, 0xe0f07f1e, 0xe0f07f12,
	0xf0000000, 0x17c07c1f, 0xe0e00016, 0x1380201f, 0xe0e0001e, 0x1380201f,
	0xe0e0000e, 0xe0e0000c, 0xe0e0000d, 0xf0000000, 0x17c07c1f, 0xe0e0000f,
	0xe0e0001e, 0xe0e00012, 0xf0000000, 0x17c07c1f, 0x1112841f, 0xa1d08407,
	0xd8202d84, 0x80eab401, 0xd8002d03, 0x01200404, 0x1a00001f, 0x10006814,
	0xe2000003, 0xf0000000, 0x17c07c1f, 0xa1d00407, 0x1b80001f, 0x20000100,
	0x80ea3401, 0x1a00001f, 0x10006814, 0xe2000003, 0xf0000000, 0x17c07c1f,
	0x81499801, 0xd82030a5, 0x17c07c1f, 0xd82035c2, 0x17c07c1f, 0x18d0001f,
	0x40000000, 0x18d0001f, 0x70000000, 0xd8002fa2, 0x00a00402, 0x814a1801,
	0xd8203205, 0x17c07c1f, 0xd82035c2, 0x17c07c1f, 0x18d0001f, 0x40000000,
	0x18d0001f, 0x80000000, 0xd8003102, 0x00a00402, 0x814a9801, 0xd8203365,
	0x17c07c1f, 0xd82035c2, 0x17c07c1f, 0x18d0001f, 0x40000000, 0x18d0001f,
	0xc0000000, 0xd8003262, 0x00a00402, 0x814c1801, 0xd82034c5, 0x17c07c1f,
	0xd82035c2, 0x17c07c1f, 0x18d0001f, 0x40000000, 0x18d0001f, 0xa0000000,
	0xd80033c2, 0x00a00402, 0xd82035c2, 0x17c07c1f, 0x18d0001f, 0x40000000,
	0x18d0001f, 0x40000000, 0xd80034c2, 0x00a00402, 0xf0000000, 0x17c07c1f,
	0x81441801, 0xd8203825, 0x17c07c1f, 0x1a00001f, 0x10006604, 0xc0c03e00,
	0xe2200004, 0xc0c02f40, 0x1093041f, 0xc0c03e00, 0xe2200003, 0xc0c02f40,
	0x1093041f, 0xc0c03e00, 0xe2200002, 0xc0c02f40, 0x1093041f, 0x1a00001f,
	0x100062c4, 0x1890001f, 0x100062c4, 0xa0908402, 0xe2000002, 0x10c0041f,
	0x81040801, 0x81601001, 0xa0db9403, 0xa0de1003, 0xa0d60403, 0x13000c1f,
	0xf0000000, 0x17c07c1f, 0x1a00001f, 0x100062c4, 0x1890001f, 0x100062c4,
	0x80b08402, 0xe2000002, 0x81441801, 0xd8203ce5, 0x17c07c1f, 0x1a00001f,
	0x10006604, 0xc0c03e00, 0xe2200003, 0xc0c02f40, 0x1093041f, 0xc0c03e00,
	0xe2200004, 0xc0c02f40, 0x1093041f, 0xc0c03e00, 0xe2200005, 0xc0c02f40,
	0x1093041f, 0x10c0041f, 0x81040801, 0x81601001, 0xa0db9403, 0xa0de1003,
	0xa0d58403, 0x13000c1f, 0xf0000000, 0x17c07c1f, 0x18d0001f, 0x10006604,
	0x10cf8c1f, 0xd8203e03, 0x17c07c1f, 0xf0000000, 0x17c07c1f, 0x18c0001f,
	0x10006b18, 0x1910001f, 0x10006b18, 0xa1002804, 0xe0c00004, 0xf0000000,
	0x17c07c1f, 0x17c07c1f, 0x1840001f, 0x00000001, 0xa1d48407, 0x1990001f,
	0x10006b08, 0xe8208000, 0x10006b18, 0x00000000, 0x81441801, 0xd8204445,
	0x17c07c1f, 0x1910001f, 0x100062c4, 0x80849001, 0x1a00001f, 0x10006b0c,
	0x1950001f, 0x10006b0c, 0xa1508805, 0xe2000005, 0x18c0001f, 0x2f7ce7ff,
	0x80841001, 0x81600801, 0xa0db9403, 0xa0de0803, 0xe8208000, 0x10006310,
	0x0b160038, 0x13000c1f, 0x1b80001f, 0xd00f0000, 0xd0004480, 0x17c07c1f,
	0x1b00001f, 0x2f7ce7ff, 0x81469801, 0xd82045e5, 0x17c07c1f, 0x1b80001f,
	0xd00f0000, 0x8880000c, 0x2f7ce7ff, 0xd8006382, 0x17c07c1f, 0xd0004620,
	0x17c07c1f, 0x1b80001f, 0x500f0000, 0xe8208000, 0x10006354, 0x001fdaa3,
	0xc0c07400, 0x81401801, 0xd8004b45, 0x17c07c1f, 0x81f60407, 0x18c0001f,
	0x10006200, 0xc0c07280, 0x12807c1f, 0xe8208000, 0x1000625c, 0x00000001,
	0x1b80001f, 0x20000080, 0xc0c07280, 0x1280041f, 0x18c0001f, 0x10006208,
	0xc0c07280, 0x12807c1f, 0xe8208000, 0x10006244, 0x00000001, 0x1b80001f,
	0x20000080, 0xc0c07280, 0x1280041f, 0x18c0001f, 0x10006290, 0xc0c07280,
	0x12807c1f, 0xc0c07280, 0x1280041f, 0x18c0001f, 0x100062dc, 0xe0c00001,
	0xc2803ee0, 0x1292041f, 0x81469801, 0xd8004c25, 0x17c07c1f, 0x8880000c,
	0x2f7ce7ff, 0xd8005ee2, 0x17c07c1f, 0x18c0001f, 0x10006294, 0xe0f07fff,
	0xe0e00fff, 0xe0e000ff, 0x81449801, 0xd8004fa5, 0x17c07c1f, 0x1a00001f,
	0x10006604, 0x814d1801, 0xd8204ee5, 0x17c07c1f, 0xe2200006, 0xc0c07540,
	0x12807c1f, 0xc0c03e00, 0x17c07c1f, 0xc2803ee0, 0x1294041f, 0xd0004fa0,
	0x17c07c1f, 0xc0c03e00, 0xe2200001, 0xc0c03e00, 0xe2200006, 0xc0c03e00,
	0xe220000a, 0xc0c074a0, 0x17c07c1f, 0xa1d38407, 0xa1d98407, 0x1800001f,
	0x00000012, 0x1800001f, 0x00000e12, 0x1800001f, 0x03800e12, 0x1800001f,
	0x038e0e12, 0x81441801, 0xd8205385, 0x17c07c1f, 0x1910001f, 0x10006b0c,
	0x1a00001f, 0x100062c4, 0x1950001f, 0x100062c4, 0x80809001, 0x81748405,
	0xa1548805, 0xe2000005, 0x1a00001f, 0x10006b0c, 0x80c51801, 0x81308404,
	0xa1108c04, 0xe2000004, 0xe8208000, 0x10006310, 0x0b1603f8, 0x1950001f,
	0x100062c4, 0x80841401, 0x81600801, 0x18c0001f, 0xaf7ce7ff, 0xa0de0803,
	0xa0db9403, 0x13000c1f, 0x1b80001f, 0x90100000, 0x80c00001, 0xc8c00843,
	0x17c07c1f, 0x18d0001f, 0x10006284, 0x80810c01, 0xd82057c2, 0x17c07c1f,
	0x18d0001f, 0x100062c4, 0x80840c01, 0xd80057c2, 0x17c07c1f, 0x1a00001f,
	0x10006604, 0xe2200007, 0x1a00001f, 0x100062c4, 0xa0940403, 0xe2000002,
	0x80c10001, 0xc8c01363, 0x17c07c1f, 0x1b00001f, 0x2f7ce7ff, 0x18c0001f,
	0x10006294, 0xe0e001fe, 0xe0e003fc, 0xe0e007f8, 0xe0e00ff0, 0x1b80001f,
	0x20000020, 0xe0f07ff0, 0xe0f07f00, 0x1800001f, 0x03800e12, 0x1b80001f,
	0x20000300, 0x1800001f, 0x00000e12, 0x1b80001f, 0x20000300, 0x1800001f,
	0x00000012, 0x1b80001f, 0x20000104, 0x10007c1f, 0x81f38407, 0x81f98407,
	0x81f90407, 0x81f40407, 0x81449801, 0xd8005ee5, 0x17c07c1f, 0x1a00001f,
	0x10006604, 0x814d1801, 0xd8205de5, 0x17c07c1f, 0xe2200008, 0xc0c07540,
	0x1280041f, 0xc0c03e00, 0x17c07c1f, 0x1b80001f, 0x20001c70, 0xd0005ee0,
	0x17c07c1f, 0xc0c03e00, 0xe2200008, 0xc0c03e00, 0xe2200000, 0x1b80001f,
	0x200016a8, 0xc0c03e00, 0xe220000b, 0x81401801, 0xd8006385, 0x17c07c1f,
	0x18c0001f, 0x100062dc, 0xe0c0001f, 0x18c0001f, 0x10006290, 0x1212841f,
	0xc0c07000, 0x12807c1f, 0xc0c07000, 0x1280041f, 0x18c0001f, 0x10006208,
	0x1212841f, 0xc0c07000, 0x12807c1f, 0xe8208000, 0x10006244, 0x00000000,
	0x1b80001f, 0x20000080, 0xc0c07000, 0x1280041f, 0x18c0001f, 0x10006200,
	0x1212841f, 0xc0c07000, 0x12807c1f, 0xe8208000, 0x1000625c, 0x00000000,
	0x1b80001f, 0x20000080, 0xc0c07000, 0x1280041f, 0xe8208000, 0x10006824,
	0x000f0000, 0x81f48407, 0xa1d60407, 0x81f10407, 0xa1db0407, 0xe8208000,
	0x10006310, 0x0b160008, 0xc2803ee0, 0x1293841f, 0x18c0001f, 0x10006b14,
	0xe0c0000c, 0x18c0001f, 0x10006b68, 0x1950001f, 0x100063c0, 0xe0c00005,
	0x81441801, 0xd8206ac5, 0x10c0041f, 0x1910001f, 0x100062c4, 0x80849001,
	0x1a00001f, 0x10006b0c, 0x1910001f, 0x10006b0c, 0xa0908804, 0xe2000002,
	0x89000002, 0xfffffe43, 0xe2000004, 0x1a00001f, 0x10006608, 0x1890001f,
	0x10006608, 0x89000002, 0xfd67ffff, 0xe2000004, 0x81441801, 0xd8206ac5,
	0x10c0041f, 0x1910001f, 0x100062c4, 0x80809001, 0x81600801, 0xa0d59403,
	0xa0d60803, 0x80841001, 0x81600801, 0xa0db9403, 0xa0de0803, 0xe8208000,
	0x10006310, 0x0b160c38, 0x81469801, 0xd8206b85, 0x17c07c1f, 0xe8208000,
	0x100063e0, 0x00000001, 0x13000c1f, 0x1b80001f, 0x900a0000, 0x88900001,
	0x10006814, 0xd82068c2, 0x17c07c1f, 0x18d0001f, 0x10006b6c, 0x78a00003,
	0x0000beef, 0xd8006da2, 0x17c07c1f, 0xc0c07bc0, 0x17c07c1f, 0xd00068c0,
	0x17c07c1f, 0x1910001f, 0x10006b0c, 0x1a00001f, 0x100062c4, 0x1950001f,
	0x100062c4, 0x80809001, 0x81748405, 0xa1548805, 0xe2000005, 0x80841401,
	0xd8006f82, 0x8204b401, 0xc8c00008, 0x17c07c1f, 0x1ac0001f, 0x55aa55aa,
	0x10007c1f, 0xf0000000, 0xd800710a, 0x17c07c1f, 0xe2e00036, 0x17c07c1f,
	0x17c07c1f, 0xe2e0003e, 0x1380201f, 0xe2e0003c, 0xd820724a, 0x17c07c1f,
	0x1b80001f, 0x20000018, 0xe2e0007c, 0x1b80001f, 0x20000003, 0xe2e0005c,
	0xe2e0004c, 0xe2e0004d, 0xf0000000, 0x17c07c1f, 0xd800732a, 0x17c07c1f,
	0xe2e0004f, 0xe2e0006f, 0xe2e0002f, 0xd82073ca, 0x17c07c1f, 0xe2e0002e,
	0xe2e0003e, 0xe2e00032, 0xf0000000, 0x17c07c1f, 0xa1d10407, 0x1b80001f,
	0x20000020, 0xf0000000, 0x17c07c1f, 0xa1d40407, 0x1391841f, 0xa1d90407,
	0xf0000000, 0x17c07c1f, 0xe8208000, 0x11012014, 0x00000002, 0xe8208000,
	0x11012020, 0x00000001, 0xe8208000, 0x11012004, 0x000000d6, 0xe8208000,
	0x11012040, 0x00000000, 0x1a00001f, 0x11012000, 0xd820798a, 0x17c07c1f,
	0xe220000a, 0xe22000f6, 0xe8208000, 0x11012024, 0x00000001, 0x1890001f,
	0x11012024, 0x1b80001f, 0x20000158, 0xe220008a, 0xe2200001, 0xe8208000,
	0x11012024, 0x00000001, 0x1b80001f, 0x20000158, 0xd0007b80, 0x17c07c1f,
	0xe220008a, 0xe2200000, 0xe8208000, 0x11012024, 0x00000001, 0x1890001f,
	0x11012024, 0x1b80001f, 0x20000158, 0xe220000a, 0xe22000f4, 0xe8208000,
	0x11012024, 0x00000001, 0x1b80001f, 0x20000158, 0xf0000000, 0x17c07c1f,
	0x1900001f, 0x10006014, 0x1950001f, 0x10006014, 0xa1508405, 0xe1000005,
	0x1900001f, 0x10006814, 0xe100001f, 0x812ab401, 0xd8007ce4, 0x17c07c1f,
	0x1880001f, 0x10006284, 0x18d0001f, 0x10006284, 0x80f20403, 0xe0800003,
	0x80f08403, 0xe0800003, 0x1900001f, 0x10006014, 0x1950001f, 0x10006014,
	0x81708405, 0xe1000005, 0x1900001f, 0x10006b6c, 0xe100001f, 0xf0000000,
	0x17c07c1f
};
static struct pcm_desc suspend_pcm = {
	.version	= "pcm_suspend_v0.2.4.1.6.4.1_20151216",
	.base		= suspend_binary,
	.size		= 1021,
	.sess		= 2,
	.replace	= 0,
	.vec0		= EVENT_VEC(23, 1, 0, 0),	/* FUNC_MD_VRF18_WAKEUP */
	.vec1		= EVENT_VEC(28, 1, 0, 33),	/* FUNC_MD_VRF18_SLEEP */
	.vec2		= EVENT_VEC(11, 1, 0, 66),	/* FUNC_26M_WAKEUP */
	.vec3		= EVENT_VEC(12, 1, 0, 100),	/* FUNC_26M_SLEEP */
	.vec4		= EVENT_VEC(30, 1, 0, 155),	/* FUNC_APSRC_WAKEUP */
	.vec5		= EVENT_VEC(31, 1, 0, 238),	/* FUNC_APSRC_SLEEP */
	.vec6		= EVENT_VEC(11, 1, 0, 432),	/* FUNC_VCORE_HIGH */
	.vec7		= EVENT_VEC(12, 1, 0, 464),	/* FUNC_VCORE_LOW */
};
#elif defined(CONFIG_ARCH_MT6580)

static const u32 suspend_binary[] = {
	0xa1d58407, 0x81f68407, 0x803a0400, 0x1b80001f, 0x20000000, 0x80300400,
	0x80328400, 0xa1d28407, 0x81f20407, 0xe8208000, 0x10006b04, 0x20000000,
	0x80318400, 0x81409801, 0xd8000285, 0x17c07c1f, 0x18c0001f, 0x10006234,
	0xc0c02580, 0x1200041f, 0x80310400, 0x1b80001f, 0x2000000a, 0xa0110400,
	0xe8208000, 0x10006b04, 0x40000000, 0x81f00407, 0xe8208000, 0x10006b04,
	0x00000000, 0xc2803220, 0x1290041f, 0x1b00001f, 0x7fffd7ff, 0xf0000000,
	0x17c07c1f, 0x1b00001f, 0x3fffc7ff, 0x1b80001f, 0x20000004, 0xd8000b0c,
	0x17c07c1f, 0x1880001f, 0x10006320, 0xc0c02b40, 0xe080000f, 0xd82006a3,
	0x17c07c1f, 0x1b00001f, 0x7fffd7ff, 0xd0000b00, 0x17c07c1f, 0xe080001f,
	0x81409801, 0xd8000925, 0x17c07c1f, 0x18c0001f, 0x10207094, 0x1910001f,
	0x10206374, 0xe0c00004, 0x18c0001f, 0x10207098, 0x1910001f, 0x10206378,
	0xe0c00004, 0x1910001f, 0x10206378, 0x18c0001f, 0x10006234, 0xc0c02760,
	0x17c07c1f, 0xe8208000, 0x10006b04, 0x10000000, 0xc2803220, 0x1290841f,
	0xa1d20407, 0x81f28407, 0xa1d68407, 0xa0100400, 0xa0128400, 0xa0118400,
	0xa01a0400, 0x81f58407, 0x1b00001f, 0x3fffcfff, 0xf0000000, 0x17c07c1f,
	0x81491801, 0xd8000ca5, 0x17c07c1f, 0x18c0001f, 0x102085cc, 0x1910001f,
	0x102085cc, 0x813f8404, 0xe0c00004, 0x1910001f, 0x102085cc, 0x18c0001f,
	0x1000627c, 0xe0e00ff0, 0x1b80001f, 0x20000020, 0xe0f07ff0, 0xe0f07f00,
	0x81f30407, 0x81411801, 0xd8000ec5, 0x17c07c1f, 0x18c0001f, 0x10006240,
	0xe0e00016, 0xe0e0001e, 0xe0e0000e, 0xe0e0000f, 0x803e0400, 0x1b80001f,
	0x20000222, 0x80380400, 0x1b80001f, 0x20000280, 0x803b0400, 0x1b80001f,
	0x2000001a, 0x803d0400, 0x1b80001f, 0x20000208, 0x80340400, 0x80310400,
	0x1910001f, 0x10000000, 0x18c0001f, 0x10000000, 0xa1108404, 0xe0c00004,
	0x1b80001f, 0x20000068, 0x1b80001f, 0x2000000a, 0x18c0001f, 0x10006240,
	0xe0e0000d, 0xd80015e5, 0x17c07c1f, 0x1b80001f, 0x20000020, 0x18c0001f,
	0x102080f0, 0x1910001f, 0x102080f0, 0xa9000004, 0x10000000, 0xe0c00004,
	0x1b80001f, 0x2000000a, 0x89000004, 0xefffffff, 0xe0c00004, 0x18c0001f,
	0x102070f4, 0x1910001f, 0x102070f4, 0xa9000004, 0x02000000, 0xe0c00004,
	0x1b80001f, 0x2000000a, 0x89000004, 0xfdffffff, 0xe0c00004, 0x1910001f,
	0x102070f4, 0x81fa0407, 0x81f08407, 0xe8208000, 0x10006354, 0xfffffc23,
	0xa1d80407, 0xa1df0407, 0xc2803220, 0x1291041f, 0x81491801, 0xd8001865,
	0x17c07c1f, 0x18c0001f, 0x102085cc, 0x1910001f, 0x102085cc, 0xa11f8404,
	0xe0c00004, 0x1910001f, 0x102085cc, 0x1b00001f, 0xbfffc7ff, 0xf0000000,
	0x17c07c1f, 0x1b80001f, 0x20000fdf, 0x1a50001f, 0x10006608, 0x80c9a401,
	0x810ba401, 0x10920c1f, 0xa0979002, 0x8080080d, 0xd8201be2, 0x17c07c1f,
	0x81f08407, 0xa1d80407, 0xa1df0407, 0x1b00001f, 0x3fffc7ff, 0x1b80001f,
	0x20000004, 0xd800254c, 0x17c07c1f, 0x1b00001f, 0xbfffc7ff, 0xd0002540,
	0x17c07c1f, 0x81f80407, 0x81ff0407, 0x1880001f, 0x10006320, 0xc0c029e0,
	0xe080000f, 0xd8001a43, 0x17c07c1f, 0xe080001f, 0xa1da0407, 0x18c0001f,
	0x110040d8, 0x1910001f, 0x110040d8, 0xa11f8404, 0xe0c00004, 0x1910001f,
	0x110040d8, 0xa1d30407, 0x1910001f, 0x10000000, 0x18c0001f, 0x10000000,
	0x81308404, 0xe0c00004, 0x81491801, 0xd8002065, 0x17c07c1f, 0x18c0001f,
	0x102085cc, 0x1910001f, 0x102085cc, 0x813f8404, 0xe0c00004, 0x1910001f,
	0x102085cc, 0x1b80001f, 0x20000068, 0xa0110400, 0xa0140400, 0xa0180400,
	0xa01b0400, 0xa01d0400, 0x17c07c1f, 0x17c07c1f, 0xa01e0400, 0x17c07c1f,
	0x17c07c1f, 0x81491801, 0xd8002345, 0x17c07c1f, 0x18c0001f, 0x102085cc,
	0x1910001f, 0x102085cc, 0xa11f8404, 0xe0c00004, 0x1910001f, 0x102085cc,
	0x81411801, 0xd8002425, 0x17c07c1f, 0x18c0001f, 0x10006240, 0xc0c02940,
	0x17c07c1f, 0x18c0001f, 0x1000627c, 0xe0f07ff0, 0xe0e00ff0, 0xe0e000f0,
	0xc2803220, 0x1291841f, 0x1b00001f, 0x7fffd7ff, 0xf0000000, 0x17c07c1f,
	0xe0f07f16, 0x1380201f, 0xe0f07f1e, 0x1380201f, 0xe0f07f0e, 0x1b80001f,
	0x20000100, 0xe0f07f0c, 0xe0f07f0d, 0xe0f07e0d, 0xe0f07c0d, 0xe0f0780d,
	0xe0f0700d, 0xf0000000, 0x17c07c1f, 0xe0f07f0d, 0xe0f07f0f, 0xe0f07f1e,
	0xe0f07f12, 0xf0000000, 0x17c07c1f, 0xe0e00016, 0x1380201f, 0xe0e0001e,
	0x1380201f, 0xe0e0000e, 0xe0e0000c, 0xe0e0000d, 0xf0000000, 0x17c07c1f,
	0xe0e0000f, 0xe0e0001e, 0xe0e00012, 0xf0000000, 0x17c07c1f, 0x1112841f,
	0xa1d08407, 0xd8202aa4, 0x80eab401, 0xd8002a23, 0x01200404, 0x1a00001f,
	0x10006814, 0xe2000003, 0xf0000000, 0x17c07c1f, 0xa1d00407, 0x1b80001f,
	0x20000100, 0x80ea3401, 0x1a00001f, 0x10006814, 0xe2000003, 0xf0000000,
	0x17c07c1f, 0xd8002d2a, 0x17c07c1f, 0xe2e00036, 0xe2e0003e, 0x1380201f,
	0xe2e0003c, 0xd8202e6a, 0x17c07c1f, 0x1b80001f, 0x20000018, 0xe2e0007c,
	0x1b80001f, 0x20000003, 0xe2e0005c, 0xe2e0004c, 0xe2e0004d, 0xf0000000,
	0x17c07c1f, 0xa1d10407, 0x1b80001f, 0x20000020, 0xf0000000, 0x17c07c1f,
	0xa1d40407, 0x1391841f, 0xf0000000, 0x17c07c1f, 0xd800306a, 0x17c07c1f,
	0xe2e0004f, 0xe2e0006f, 0xe2e0002f, 0xd820310a, 0x17c07c1f, 0xe2e0002e,
	0xe2e0003e, 0xe2e00032, 0xf0000000, 0x17c07c1f, 0x18d0001f, 0x10006604,
	0x10cf8c1f, 0xd8203143, 0x17c07c1f, 0xf0000000, 0x17c07c1f, 0x18c0001f,
	0x10006b18, 0x1910001f, 0x10006b18, 0xa1002804, 0xe0c00004, 0xf0000000,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x1840001f, 0x00000001, 0xa1d48407, 0x1990001f,
	0x10006b08, 0xe8208000, 0x10006b18, 0x00000000, 0x1b00001f, 0x3fffc7ff,
	0x1b80001f, 0xd00f0000, 0x8880000c, 0x3fffc7ff, 0xd8005522, 0x17c07c1f,
	0xe8208000, 0x10006354, 0xfffffc23, 0xc0c02ea0, 0x81401801, 0xd80046c5,
	0x17c07c1f, 0x81f60407, 0x18c0001f, 0x10006200, 0xc0c02fc0, 0x12807c1f,
	0xe8208000, 0x1000625c, 0x00000001, 0x1b80001f, 0x20000080, 0xc0c02fc0,
	0x1280041f, 0x18c0001f, 0x10006208, 0xc0c02fc0, 0x12807c1f, 0xe8208000,
	0x10006244, 0x00000001, 0x1b80001f, 0x20000080, 0xc0c02fc0, 0x1280041f,
	0x18c0001f, 0x10006290, 0xc0c02fc0, 0x12807c1f, 0xc0c02fc0, 0x1280041f,
	0xc2803220, 0x1292041f, 0x18c0001f, 0x10006294, 0xe0f07fff, 0xe0e00fff,
	0xe0e000ff, 0xc0c02f40, 0x17c07c1f, 0xa1d38407, 0xa1d98407, 0x18c0001f,
	0x11004078, 0x1910001f, 0x11004078, 0xa11f8404, 0xe0c00004, 0x1910001f,
	0x11004078, 0x18c0001f, 0x11004098, 0x1910001f, 0x11004098, 0xa11f8404,
	0xe0c00004, 0x1910001f, 0x11004098, 0xa0108400, 0xa0120400, 0xa0148400,
	0xa0150400, 0xa0158400, 0xa01b8400, 0xa01c0400, 0xa01c8400, 0xa0188400,
	0xa0190400, 0xa0198400, 0xe8208000, 0x10006310, 0x0b1600f8, 0x1b00001f,
	0xbfffc7ff, 0x1b80001f, 0x90100000, 0x80c00001, 0xc8c00003, 0x17c07c1f,
	0x80c10001, 0xc8c00b43, 0x17c07c1f, 0x1b00001f, 0x3fffc7ff, 0x18c0001f,
	0x10006294, 0xe0e001fe, 0xe0e003fc, 0xe0e007f8, 0xe0e00ff0, 0x1b80001f,
	0x20000020, 0xe0f07ff0, 0xe0f07f00, 0x80388400, 0x80390400, 0x80398400,
	0x1b80001f, 0x20000300, 0x803b8400, 0x803c0400, 0x803c8400, 0x1b80001f,
	0x20000300, 0x80348400, 0x80350400, 0x80358400, 0x1b80001f, 0x20000104,
	0x80308400, 0x80320400, 0x81f38407, 0x81f98407, 0x81f40407, 0x81401801,
	0xd8005525, 0x17c07c1f, 0x18c0001f, 0x10006290, 0x1212841f, 0xc0c02c60,
	0x12807c1f, 0xc0c02c60, 0x1280041f, 0x18c0001f, 0x10006208, 0x1212841f,
	0xc0c02c60, 0x12807c1f, 0xe8208000, 0x10006244, 0x00000000, 0x1b80001f,
	0x20000080, 0xc0c02c60, 0x1280041f, 0x18c0001f, 0x10006200, 0x1212841f,
	0xc0c02c60, 0x12807c1f, 0xe8208000, 0x1000625c, 0x00000000, 0x1b80001f,
	0x20000080, 0xc0c02c60, 0x1280041f, 0xe8208000, 0x10006824, 0x000f0000,
	0xa1db0407, 0x81f10407, 0x81f48407, 0xa1d60407, 0x1ac0001f, 0x55aa55aa,
	0x10007c1f, 0xf0000000
};

static struct pcm_desc suspend_pcm = {
	.version = "pcm_suspend_v14.0_new",
	.base = suspend_binary,
	.size = 692,
	.sess = 2,
	.replace = 0,
	.vec0 = EVENT_VEC(11, 1, 0, 0),	/* FUNC_26M_WAKEUP */
	.vec1 = EVENT_VEC(12, 1, 0, 37),	/* FUNC_26M_SLEEP */
	.vec2 = EVENT_VEC(30, 1, 0, 90),	/* FUNC_APSRC_WAKEUP */
	.vec3 = EVENT_VEC(31, 1, 0, 199),	/* FUNC_APSRC_SLEEP */
};

#else
/* ERROR */
#endif

#endif				/* !defined(USE_DYNA_LOAD_SUSPEND) */


/**************************************
 * SW code for suspend
 **************************************/
#define SPM_SYSCLK_SETTLE       99	/* 3ms */

#define WAIT_UART_ACK_TIMES     10	/* 10 * 10us */

#define SPM_WAKE_PERIOD         600	/* sec */

#if defined(CONFIG_ARCH_MT6580)

#define WAKE_SRC_FOR_SUSPEND \
	(WAKE_SRC_KP | WAKE_SRC_EINT |  WAKE_SRC_CONN_WDT  |  WAKE_SRC_CCIF0_MD | WAKE_SRC_CONN2AP | \
	WAKE_SRC_USB_CD | WAKE_SRC_USB_PDN |  WAKE_SRC_SEJ | \
	WAKE_SRC_SYSPWREQ | WAKE_SRC_MD1_WDT)

#define spm_is_wakesrc_invalid(wakesrc)     (!!((u32)(wakesrc) & 0xFC7F3A9B))

#else

#if defined(CONFIG_MICROTRUST_TEE_SUPPORT)
#define WAKE_SRC_FOR_SUSPEND \
	(WAKE_SRC_KP | WAKE_SRC_EINT | WAKE_SRC_CONN_WDT | WAKE_SRC_CCIF0_MD | WAKE_SRC_CCIF1_MD | WAKE_SRC_CONN2AP | \
	WAKE_SRC_USB_CD | WAKE_SRC_USB_PDN | \
	 /*WAKE_SRC_SYSPWREQ |*/ WAKE_SRC_MD_WDT | WAKE_SRC_C2K_WDT | WAKE_SRC_CLDMA_MD)
#else
#define WAKE_SRC_FOR_SUSPEND \
	(WAKE_SRC_KP | WAKE_SRC_EINT | WAKE_SRC_CONN_WDT | WAKE_SRC_CCIF0_MD | WAKE_SRC_CCIF1_MD | WAKE_SRC_CONN2AP | \
	WAKE_SRC_USB_CD | WAKE_SRC_USB_PDN | WAKE_SRC_SEJ |\
	 /*WAKE_SRC_SYSPWREQ |*/ WAKE_SRC_MD_WDT | WAKE_SRC_C2K_WDT | WAKE_SRC_CLDMA_MD)
#endif

#define spm_is_wakesrc_invalid(wakesrc)     (!!((u32)(wakesrc) & 0xc0003803))

#endif

#define WAKE_SRC_FOR_MD32  0                                          \
				/* (WAKE_SRC_AUD_MD32) */



#define reg_read(addr)         __raw_readl((void __force __iomem *)(addr))
#define reg_write(addr, val)   mt_reg_sync_writel((val), ((void *)addr))

/*
#if defined(CONFIG_OF)
extern void __iomem *_mcucfg_base;
extern void __iomem *_mcucfg_phys_base;
#undef MCUCFG_BASE
#define MCUCFG_BASE             (_mcucfg_base)
#else
#undef MCUCFG_BASE
#define MCUCFG_BASE             0xF0200000
#endif		 */
/* MCUCFG registers */
/*
#define SPM_MP0_AXI_CONFIG       (MCUCFG_BASE + 0x2C)
#define SPM_MP0_AXI_CONFIG_PHYS  (_mcucfg_phys_base + 0x2C)
#define SPM_MP1_AXI_CONFIG       (MCUCFG_BASE + 0x22C)
#define SPM_MP1_AXI_CONFIG_PHYS  (_mcucfg_phys_base + 0x22C)
#define ACINACTM                (1<<4)
*/

#if defined(CONFIG_ARM_PSCI) || defined(CONFIG_MTK_PSCI)
#define MCUSYS_SMC_WRITE(addr, val)  mcusys_smc_write_phy(addr##_PHYS, val)
#else
#define MCUSYS_SMC_WRITE(addr, val)  mcusys_smc_write(addr, val)
#endif

#ifdef CONFIG_MTK_RAM_CONSOLE
#define SPM_AEE_RR_REC 1
#else
#define SPM_AEE_RR_REC 0
#endif

#if SPM_AEE_RR_REC
enum spm_suspend_step {
	SPM_SUSPEND_ENTER = 0,
	SPM_SUSPEND_ENTER_WFI,
	SPM_SUSPEND_LEAVE_WFI,
	SPM_SUSPEND_LEAVE
};
/* extern void aee_rr_rec_spm_suspend_val(u32 val); */
/* extern u32 aee_rr_curr_spm_suspend_val(void); */
void __attribute__ ((weak)) aee_rr_rec_spm_suspend_val(u32 val)
{
}

u32 __attribute__ ((weak)) aee_rr_curr_spm_suspend_val(void)
{
	return 0;
}
#endif

/* FIXME: Denali early porting */
#if 1
int __attribute__ ((weak)) exec_ccci_kern_func_by_md_id(int md_id, unsigned int id, char *buf,
							unsigned int len)
{
	return 0;
}

int __attribute__ ((weak)) get_dynamic_period(int first_use, int first_wakeup_time,
					      int battery_capacity_level)
{
	return 0;
}

/*
#else
extern int get_dynamic_period(int first_use, int first_wakeup_time, int battery_capacity_level);
*/
#endif
void __attribute__ ((weak)) mt_cirq_clone_gic(void)
{
}

void __attribute__ ((weak)) mt_cirq_enable(void)
{
}

void __attribute__ ((weak)) mt_cirq_flush(void)
{
}

void __attribute__ ((weak)) mt_cirq_disable(void)
{
}

int __attribute__ ((weak)) request_uart_to_sleep(void)
{
	return 0;
}

int __attribute__ ((weak)) request_uart_to_wakeup(void)
{
	return 0;
}

void __attribute__ ((weak)) mtk_uart_restore(void)
{
}

void __attribute__ ((weak)) mt_eint_print_status(void)
{
}

/*
extern int mt_irq_mask_all(struct mtk_irq_mask *mask);
extern int mt_irq_mask_restore(struct mtk_irq_mask *mask);
extern void mt_irq_unmask_for_sleep(unsigned int irq);


extern int request_uart_to_sleep(void);
extern int request_uart_to_wakeup(void);
extern void mtk_uart_restore(void);
extern void dump_uart_reg(void);
*/

#if defined(CONFIG_ARCH_MT6580)

static struct pwr_ctrl suspend_ctrl = {
	.wake_src = WAKE_SRC_FOR_SUSPEND,
	.wake_src_md32 = WAKE_SRC_FOR_MD32,
	.r0_ctrl_en = 1,
	.r7_ctrl_en = 1,
	.infra_dcm_lock = 1,
	.wfi_op = WFI_OP_AND,

	.ca7top_idle_mask = 0,
	.ca15top_idle_mask = 1,
	.mcusys_idle_mask = 0,
	.disp_req_mask = 0,
	.mfg_req_mask = 0,
	.gce_req_mask = 1,
	.md1_req_mask = 0,
	.md2_req_mask = 0,
	.md32_req_mask = 1,
	.md_apsrc_sel = 0,
	.md2_apsrc_sel = 0,
	.lte_mask = 1,
	.conn_mask = 0,
#ifdef CONFIG_MTK_NFC
	.srclkenai_mask = 0,	/* unmask for NFC use */
#else
	.srclkenai_mask = 1,	/* mask for gpio/i2c use */
#endif
#if 0
	/* use for birng-up */
	.ccif0_to_ap_mask = 1,
	.ccif0_to_md_mask = 1,
	.ccif1_to_ap_mask = 1,
	.ccif1_to_md_mask = 1,
	.ccifmd_md1_event_mask = 1,
	.ccifmd_md2_event_mask = 1,
#endif
	/* .pcm_apsrc_req = 1, */

	/* .pcm_f26m_req = 1, */

	.ca7_wfi0_en = 1,
	.ca7_wfi1_en = 1,
	.ca7_wfi2_en = 1,
	.ca7_wfi3_en = 1,
	.ca15_wfi0_en = 0,
	.ca15_wfi1_en = 0,
	.ca15_wfi2_en = 0,
	.ca15_wfi3_en = 0,

#if SPM_BYPASS_SYSPWREQ
	.syspwreq_mask = 1,
#endif
};

#else

static struct pwr_ctrl suspend_ctrl = {
	.wake_src = WAKE_SRC_FOR_SUSPEND,
	.wake_src_md32 = WAKE_SRC_FOR_MD32,
	.r0_ctrl_en = 1,
	.r7_ctrl_en = 1,
	.infra_dcm_lock = 1,
	.wfi_op = WFI_OP_AND,

	.ca7top_idle_mask = 0,
	.ca15top_idle_mask = 0,
	.mcusys_idle_mask = 0,
	.disp_req_mask = 0,
	.mfg_req_mask = 0,
	.md1_req_mask = 0,
	.md2_req_mask = 0,
	.md32_req_mask = 0,
	.md_apsrc_sel = 0,
	.md2_apsrc_sel = 0,
	.lte_mask = 1,
	.conn_mask = 0,
#if 0
	.ccif0_to_ap_mask = 1,
	.ccif0_to_md_mask = 1,
	.ccif1_to_ap_mask = 1,
	.ccif1_to_md_mask = 1,
	.ccifmd_md1_event_mask = 1,
	.ccifmd_md2_event_mask = 1,
#endif
	/* .pcm_f26m_req = 1, */

	.ca7_wfi0_en = 1,
	.ca7_wfi1_en = 1,
	.ca7_wfi2_en = 1,
	.ca7_wfi3_en = 1,
	.ca15_wfi0_en = 1,
	.ca15_wfi1_en = 1,
	.ca15_wfi2_en = 1,
	.ca15_wfi3_en = 1,

#if SPM_BYPASS_SYSPWREQ
	.syspwreq_mask = 1,
#endif
};

#endif

struct spm_lp_scen __spm_suspend = {
#ifndef USE_DYNA_LOAD_SUSPEND
	.pcmdesc = &suspend_pcm,
#endif
	.pwrctrl = &suspend_ctrl,
	.wakestatus = &suspend_info[0],
};

void spm_i2c_control(u32 channel, bool onoff)
{
	return;
#if 0
	/* static int pdn = 0; */
	static bool i2c_onoff;

#ifdef CONFIG_OF
	void __iomem *base;
#else
	u32 base;		/* , i2c_clk; */
#endif
	switch (channel) {
	case 0:
		base = SPM_I2C0_BASE;
		/* i2c_clk = MT_CG_INFRA_I2C0; */
		break;
	case 1:
		base = SPM_I2C1_BASE;
		/* i2c_clk = MT_CG_INFRA_I2C1; */
		break;
	case 2:
		base = SPM_I2C2_BASE;
		/* i2c_clk = MT_CG_INFRA_I2C2; */
		break;
	default:
		base = SPM_I2C2_BASE;
		break;
	}

	if ((1 == onoff) && (0 == i2c_onoff)) {
		i2c_onoff = 1;
#if 0
#if 1
		pdn = spm_read(INFRA_PDN_STA0) & (1U << i2c_clk);
		spm_write(INFRA_PDN_CLR0, pdn);	/* power on I2C */
#else
		pdn = clock_is_on(i2c_clk);
		if (!pdn)
			enable_clock(i2c_clk, "spm_i2c");
#endif
#endif
		spm_write(base + OFFSET_CONTROL, 0x0);	/* init I2C_CONTROL */
		spm_write(base + OFFSET_TRANSAC_LEN, 0x1);	/* init I2C_TRANSAC_LEN */
		spm_write(base + OFFSET_EXT_CONF, 0x0);	/* init I2C_EXT_CONF */
		spm_write(base + OFFSET_IO_CONFIG, 0x0);	/* init I2C_IO_CONFIG */
		spm_write(base + OFFSET_HS, 0x102);	/* init I2C_HS */
	} else if ((0 == onoff) && (1 == i2c_onoff)) {
		i2c_onoff = 0;
#if 0
#if 1
		spm_write(INFRA_PDN_SET0, pdn);	/* restore I2C power */
#else
		if (!pdn)
			disable_clock(i2c_clk, "spm_i2c");
#endif
#endif
	} else
		ASSERT(1);
#endif
}


/* extern unsigned int mt_get_clk_mem_sel(void); */
/*
static bool spm_set_suspend_pcm_ver(u32 *suspend_flags)
{
    u32 flag;

    flag = *suspend_flags;

    if(mt_get_clk_mem_sel()==MEMPLL3PLL)
    {
	__spm_suspend.pcmdesc = &suspend_pcm_3pll;
	flag |= SPM_VCORE_DVS_DIS;
    }
    else if(mt_get_clk_mem_sel()==MEMPLL1PLL)

    {
	__spm_suspend.pcmdesc = &suspend_pcm_1pll;
	flag &= ~SPM_VCORE_DVS_DIS;
    }
    else
	return false;

    *suspend_flags = flag;
    return true;

}
*/
#if 0
static void spm_suspend_pre_process(struct pwr_ctrl *pwrctrl)
{
#if 0
	u32 rdata1 = 0, rdata2 = 0;
#endif

	/* set PMIC WRAP table for suspend power control */
	mt_cpufreq_set_pmic_phase(PMIC_WRAP_PHASE_SUSPEND);

	spm_i2c_control(I2C_CHANNEL, 1);

#if 0
	/* for infra pdn (emi driving) */
	spm_write(0xF0004000, spm_read(0xF0004000) | (1 << 24));

	/* MEMPLL control for SPM */
	spm_write(0xF000F5C8, 0x3010F030);
	spm_write(0xF000F5CC, 0x50101010);
#endif
	/* spm_write(0xF0001070 , spm_read(0xF0001070) | (1 << 21)); // 26:26 enable */
	/* spm_write(0xF0000204 , spm_read(0xF0000204) | (1 << 0));  // BUS 26MHz enable */
	/* spm_write(0xF0001108 , 0x0); */

#ifdef CONFIG_MD32_SUPPORT
	/* spm_write(MD32_BASE+0x2C, (spm_read(MD32_BASE+0x2C) & ~0xFFFF) | 0xcafe); */
#endif

#if 0
	pwrap_read(0x2c2, &rdata1);
	pwrap_write(0x2c2, 0x0123);
	pwrap_read(0x2c2, &rdata2);
	if (rdata2 != 0x0123) {
		spm_crit2("suspend pmic wrapper 0x2c2, rdata1 = 0x%x, rdata2 = 0x%x\n", rdata1,
			  rdata2);
		BUG();
	}
#endif
}
#endif
#if 0
static void spm_suspend_post_process(struct pwr_ctrl *pwrctrl)
{
#if 0
	u32 rdata1 = 0, rdata2 = 0;

	pwrap_read(0x2c2, &rdata1);
	pwrap_write(0x2c2, 0x3210);
	pwrap_read(0x2c2, &rdata2);
	if (rdata2 != 0x3210) {
		spm_crit2("resume pmic wrapper 0x2c2, rdata1 = 0x%x, rdata2 = 0x%x\n", rdata1,
			  rdata2);
		BUG();
	}
#endif

#ifdef CONFIG_MD32_SUPPORT
	/* spm_write(MD32_BASE+0x2C, spm_read(MD32_BASE+0x2C) & ~0xFFFF); */
#endif

	/* set PMIC WRAP table for normal power control */
	mt_cpufreq_set_pmic_phase(PMIC_WRAP_PHASE_NORMAL);

	spm_i2c_control(I2C_CHANNEL, 0);
}
#endif
static void spm_set_sysclk_settle(void)
{
	u32 md_settle, settle;

	/* get MD SYSCLK settle */
	spm_write(SPM_CLK_CON, spm_read(SPM_CLK_CON) | CC_SYSSETTLE_SEL);
	spm_write(SPM_CLK_SETTLE, 0);
	md_settle = spm_read(SPM_CLK_SETTLE);

	/* SYSCLK settle = MD SYSCLK settle but set it again for MD PDN */
	spm_write(SPM_CLK_SETTLE, SPM_SYSCLK_SETTLE - md_settle);
	settle = spm_read(SPM_CLK_SETTLE);

	spm_warn("md_settle = %u, settle = %u\n", md_settle, settle);
}

static void spm_kick_pcm_to_run(struct pwr_ctrl *pwrctrl)
{
	/* enable PCM WDT (normal mode) to start count if needed */
#if SPM_PCMWDT_EN
	{
		u32 con1;

		con1 = spm_read(SPM_PCM_CON1) & ~(CON1_PCM_WDT_WAKE_MODE | CON1_PCM_WDT_EN);
		spm_write(SPM_PCM_CON1, CON1_CFG_KEY | con1);

		if (spm_read(SPM_PCM_TIMER_VAL) > PCM_TIMER_MAX)
			spm_write(SPM_PCM_TIMER_VAL, PCM_TIMER_MAX);
		spm_write(SPM_PCM_WDT_TIMER_VAL, spm_read(SPM_PCM_TIMER_VAL) + PCM_WDT_TIMEOUT);
		spm_write(SPM_PCM_CON1, con1 | CON1_CFG_KEY | CON1_PCM_WDT_EN);
	}
#endif

#if SPM_PCMTIMER_DIS
	{
		u32 con1;

		con1 = spm_read(SPM_PCM_CON1) & ~(CON1_PCM_TIMER_EN);
		spm_write(SPM_PCM_CON1, con1 | CON1_CFG_KEY);
	}
#endif

	/* init PCM_PASR_DPD_0 for DPD */
	spm_write(SPM_PCM_PASR_DPD_0, 0);

/* FIXME: for K2 fpga early porting */
#if 0
	/* make MD32 work in suspend: fscp_ck = CLK26M */
	clkmux_sel(MT_MUX_SCP, 0, "SPM-Sleep");
#endif

	__spm_kick_pcm_to_run(pwrctrl);
}

static void spm_trigger_wfi_for_sleep(struct pwr_ctrl *pwrctrl)
{
/* FIXME: for K2 fpga early porting */
#if 0
	sync_hw_gating_value();	/* for Vcore DVFS */
#endif

	if (is_cpu_pdn(pwrctrl->pcm_flags)) {
		spm_dormant_sta = mt_cpu_dormant(CPU_SHUTDOWN_MODE /* | DORMANT_SKIP_WFI */);
		switch (spm_dormant_sta) {
		case MT_CPU_DORMANT_RESET:
			break;
		case MT_CPU_DORMANT_ABORT:
			break;
		case MT_CPU_DORMANT_BREAK:
			break;
		case MT_CPU_DORMANT_BYPASS:
			break;
		}
	} else {
		spm_dormant_sta = -1;
		/* spm_write(MP0_AXI_CONFIG, spm_read(MP0_AXI_CONFIG) | ACINACTM); */
		wfi_with_sync();
		/* spm_write(MP0_AXI_CONFIG, spm_read(MP0_AXI_CONFIG) & ~ACINACTM); */
	}

	if (is_infra_pdn(pwrctrl->pcm_flags))
		mtk_uart_restore();
}

static void spm_clean_after_wakeup(void)
{
	/* disable PCM WDT to stop count if needed */
#if SPM_PCMWDT_EN
	spm_write(SPM_PCM_CON1, CON1_CFG_KEY | (spm_read(SPM_PCM_CON1) & ~CON1_PCM_WDT_EN));
#endif

#if SPM_PCMTIMER_DIS
	spm_write(SPM_PCM_CON1, CON1_CFG_KEY | (spm_read(SPM_PCM_CON1) | CON1_PCM_TIMER_EN));
#endif

	__spm_clean_after_wakeup();

/* FIXME: for K2 fpga early porting */
#if 0
	/* restore clock mux: fscp_ck = SYSPLL1_D2 */
	clkmux_sel(MT_MUX_SCP, 1, "SPM-Sleep");
#endif
}

static wake_reason_t spm_output_wake_reason(struct wake_status *wakesta, struct pcm_desc *pcmdesc)
{
	wake_reason_t wr;
	u32 md32_flag = 0;
	u32 md32_flag2 = 0;

	wr = __spm_output_wake_reason(wakesta, pcmdesc, true);

#if 1
	memcpy(&suspend_info[log_wakesta_cnt], wakesta, sizeof(struct wake_status));
	suspend_info[log_wakesta_cnt].log_index = log_wakesta_index;

	if (10 <= log_wakesta_cnt) {
		log_wakesta_cnt = 0;
		spm_snapshot_golden_setting = 0;
	} else {
		log_wakesta_cnt++;
		log_wakesta_index++;
	}

	if (0xFFFFFFF0 <= log_wakesta_index)
		log_wakesta_index = 0;
#endif

#ifdef CONFIG_MD32_SUPPORT
	md32_flag = spm_read(MD32_BASE + 0x2C);
	md32_flag2 = spm_read(MD32_BASE + 0x30);
#endif
	spm_warn("suspend dormant state = %d, md32_flag = 0x%x, md32_flag2 = %d\n",
		  spm_dormant_sta, md32_flag, md32_flag2);
	spm_warn("log_wakesta_index = %d\n", log_wakesta_index);
	if (0 != spm_ap_mdsrc_req_cnt)
		spm_warn("warning: spm_ap_mdsrc_req_cnt = %d, r7[ap_mdsrc_req] = 0x%x\n",
			  spm_ap_mdsrc_req_cnt, spm_read(SPM_POWER_ON_VAL1) & (1 << 17));

	if (wakesta->r12 & WAKE_SRC_EINT)
		mt_eint_print_status();

#if 0
	if (wakesta->debug_flag & (1 << 18)) {
		spm_crit2("MD32 suspned pmic wrapper error");
		BUG();
	}

	if (wakesta->debug_flag & (1 << 19)) {
		spm_crit2("MD32 resume pmic wrapper error");
		BUG();
	}
#endif

#if !defined(CONFIG_ARCH_MT6580)
#ifdef CONFIG_MTK_CCCI_DEVICES
	if (wakesta->r13 & 0x18) {
		spm_warn("dump ID_DUMP_MD_SLEEP_MODE");
		exec_ccci_kern_func_by_md_id(0, ID_DUMP_MD_SLEEP_MODE, NULL, 0);
	}
#endif

	if (wakesta->r12 & WAKE_SRC_CLDMA_MD)
		exec_ccci_kern_func_by_md_id(0, ID_GET_MD_WAKEUP_SRC, NULL, 0);

#endif				/* !defined(CONFIG_ARCH_MT6580) */

	return wr;
}

#if SPM_PWAKE_EN
static u32 spm_get_wake_period(int pwake_time, wake_reason_t last_wr)
{
	int period = SPM_WAKE_PERIOD;
#if 1
	if (pwake_time < 0) {
		/* use FG to get the period of 1% battery decrease */
		period = get_dynamic_period(last_wr != WR_PCM_TIMER ? 1 : 0, SPM_WAKE_PERIOD, 1);
		if (period <= 0) {
			spm_warn("CANNOT GET PERIOD FROM FUEL GAUGE\n");
			period = SPM_WAKE_PERIOD;
		}
	} else {
		period = pwake_time;
		spm_crit2("pwake = %d\n", pwake_time);
	}

	if (period > 36 * 3600)	/* max period is 36.4 hours */
		period = 36 * 3600;
#endif
	return period;
}
#endif

/*
 * wakesrc: WAKE_SRC_XXX
 * enable : enable or disable @wakesrc
 * replace: if true, will replace the default setting
 */
int spm_set_sleep_wakesrc(u32 wakesrc, bool enable, bool replace)
{
	unsigned long flags;

	if (spm_is_wakesrc_invalid(wakesrc))
		return -EINVAL;

	spin_lock_irqsave(&__spm_lock, flags);
	if (enable) {
		if (replace)
			__spm_suspend.pwrctrl->wake_src = wakesrc;
		else
			__spm_suspend.pwrctrl->wake_src |= wakesrc;
	} else {
		if (replace)
			__spm_suspend.pwrctrl->wake_src = 0;
		else
			__spm_suspend.pwrctrl->wake_src &= ~wakesrc;
	}
	spin_unlock_irqrestore(&__spm_lock, flags);

	return 0;
}

/*
 * wakesrc: WAKE_SRC_XXX
 */
u32 spm_get_sleep_wakesrc(void)
{
	return __spm_suspend.pwrctrl->wake_src;
}

#if 0
static void uart_mhl_gpio_sleep_ctrl(bool suspend)
{
	static int mhl_ws_gpio_mode;
	static int mhl_ck_gpio_mode;
	static int mhl_dat_gpio_mode;

	if (suspend == true) {
#ifdef GPIO_MHL_I2S_OUT_WS_PIN
		mhl_ws_gpio_mode = mt_get_gpio_mode(GPIO_MHL_I2S_OUT_WS_PIN);
		mhl_ck_gpio_mode = mt_get_gpio_mode(GPIO_MHL_I2S_OUT_CK_PIN);
		mhl_dat_gpio_mode = mt_get_gpio_mode(GPIO_MHL_I2S_OUT_DAT_PIN);
		mt_set_gpio_mode(GPIO_MHL_I2S_OUT_WS_PIN, GPIO_MODE_GPIO);
		mt_set_gpio_mode(GPIO_MHL_I2S_OUT_CK_PIN, GPIO_MODE_01);
		mt_set_gpio_mode(GPIO_MHL_I2S_OUT_DAT_PIN, GPIO_MODE_02);

		mt_set_gpio_mode(GPIO_MHL_I2S_OUT_WS_PIN, GPIO_MODE_00);
		mt_set_gpio_dir(GPIO_MHL_I2S_OUT_WS_PIN, GPIO_DIR_IN);
		mt_set_gpio_pull_enable(GPIO_MHL_I2S_OUT_WS_PIN, GPIO_PULL_ENABLE);
		mt_set_gpio_pull_select(GPIO_MHL_I2S_OUT_WS_PIN, GPIO_PULL_DOWN);

		mt_set_gpio_mode(GPIO_MHL_I2S_OUT_CK_PIN, GPIO_MODE_00);
		mt_set_gpio_dir(GPIO_MHL_I2S_OUT_CK_PIN, GPIO_DIR_IN);
		mt_set_gpio_pull_enable(GPIO_MHL_I2S_OUT_CK_PIN, GPIO_PULL_ENABLE);
		mt_set_gpio_pull_select(GPIO_MHL_I2S_OUT_CK_PIN, GPIO_PULL_DOWN);

		mt_set_gpio_mode(GPIO_MHL_I2S_OUT_DAT_PIN, GPIO_MODE_00);
		mt_set_gpio_dir(GPIO_MHL_I2S_OUT_DAT_PIN, GPIO_DIR_IN);
		mt_set_gpio_pull_enable(GPIO_MHL_I2S_OUT_DAT_PIN, GPIO_PULL_ENABLE);
		mt_set_gpio_pull_select(GPIO_MHL_I2S_OUT_DAT_PIN, GPIO_PULL_DOWN);

#endif

	} else {
#ifdef GPIO_MHL_I2S_OUT_WS_PIN
		mt_set_gpio_mode(GPIO_MHL_I2S_OUT_WS_PIN, mhl_ws_gpio_mode);
		mt_set_gpio_mode(GPIO_MHL_I2S_OUT_CK_PIN, mhl_ck_gpio_mode);
		mt_set_gpio_mode(GPIO_MHL_I2S_OUT_DAT_PIN, mhl_dat_gpio_mode);
#endif
	}
}
#endif

#if SPM_AEE_RR_REC
void spm_suspend_aee_init(void)
{
	aee_rr_rec_spm_suspend_val(0);
}
#endif

/* #include <cust_pmic.h> */
#ifndef DISABLE_DLPT_FEATURE
/* extern int get_dlpt_imix_spm(void); */
int __attribute__ ((weak)) get_dlpt_imix_spm(void)
{
	return 0;
}
#endif

wake_reason_t spm_go_to_sleep(u32 spm_flags, u32 spm_data)
{
	u32 sec = 2;
	int wd_ret;
	/* struct wake_status wakesta; */
	unsigned long flags;
#if defined(CONFIG_ARCH_MT6735) || defined(CONFIG_ARCH_MT6735M)
	unsigned long temp_a, temp_b;
#endif
#if 0
	unsigned int temp_c;
#endif
	struct mtk_irq_mask mask;
	struct wd_api *wd_api;
	static wake_reason_t last_wr = WR_NONE;
	struct pcm_desc *pcmdesc;
	struct pwr_ctrl *pwrctrl;

#ifndef DISABLE_DLPT_FEATURE
	get_dlpt_imix_spm();
#endif

#if SPM_AEE_RR_REC
	spm_suspend_aee_init();
	aee_rr_rec_spm_suspend_val(1 << SPM_SUSPEND_ENTER);
#endif
/*
    if(spm_set_suspend_pcm_ver(&spm_flags)==false) {
	spm_crit2("mempll setting error %x\n",mt_get_clk_mem_sel());
	last_wr = WR_UNKNOWN;
	return last_wr;
    }
*/
#ifndef USE_DYNA_LOAD_SUSPEND
	pcmdesc = __spm_suspend.pcmdesc;
	pwrctrl = __spm_suspend.pwrctrl;
#else
	pwrctrl = __spm_suspend.pwrctrl;

	if (dyna_load_pcm[DYNA_LOAD_PCM_SUSPEND].ready)
		pcmdesc = &(dyna_load_pcm[DYNA_LOAD_PCM_SUSPEND].desc);
	else
		BUG();
#endif
	set_pwrctrl_pcm_flags(pwrctrl, spm_flags);
	set_pwrctrl_pcm_data(pwrctrl, spm_data);

#if SPM_PWAKE_EN
	sec = spm_get_wake_period(-1 /* FIXME */ , last_wr);
#endif
	pwrctrl->timer_val = sec * 32768;

	wd_ret = get_wd_api(&wd_api);
	if (!wd_ret)
		wd_api->wd_suspend_notify();

	mt_power_gs_dump_suspend();

	/* spm_suspend_pre_process(pwrctrl); */
	lockdep_off();
	spin_lock_irqsave(&__spm_lock, flags);
	mt_irq_mask_all(&mask);
	mt_irq_unmask_for_sleep(SPM_IRQ0_ID);

	mt_cirq_clone_gic();
	mt_cirq_enable();

	spm_set_sysclk_settle();

#if defined(CONFIG_ARCH_MT6753)
	__spm_enable_i2c4_clk();

	if (vcorefs_get_curr_voltage() == VCORE_1_P_25_UV)
		vcorefs_list_kicker_request();
#endif

	spm_warn("sec = %u, wakesrc = 0x%x (%u)(%u)\n",
		  sec, pwrctrl->wake_src, is_cpu_pdn(pwrctrl->pcm_flags),
		  is_infra_pdn(pwrctrl->pcm_flags));

	if (request_uart_to_sleep()) {
		last_wr = WR_UART_BUSY;
		goto RESTORE_IRQ;
	}


	__spm_reset_and_init_pcm(pcmdesc);

	__spm_kick_im_to_fetch(pcmdesc);

	__spm_init_pcm_register();

	__spm_init_event_vector(pcmdesc);

	__spm_set_power_control(pwrctrl);

	__spm_set_wakeup_event(pwrctrl);

#if !defined(CONFIG_ARCH_MT6580)
	mt_cpufreq_set_pmic_phase(PMIC_WRAP_PHASE_SUSPEND);
#endif
#if 0
	temp_a = spm_read(PMIC_WRAP_DVFS_WDATA5);
	temp_b = spm_read(PMIC_WRAP_DVFS_WDATA4);
	spm_write(SPM_PCM_PASR_DPD_3, (temp_a << 16) | temp_b);
	temp_a = spm_read(PMIC_WRAP_DVFS_WDATA3);
	temp_b = spm_read(PMIC_WRAP_DVFS_WDATA2);
	spm_write(SPM_PCM_PASR_DPD_2, (temp_a << 16) | temp_b);
#endif
#if defined(CONFIG_ARCH_MT6735)
	temp_a = spm_read(PMIC_WRAP_DVFS_WDATA2);
	temp_b = spm_read(PMIC_WRAP_DVFS_WDATA3);
	spm_write(SPM_PCM_PASR_DPD_3, (temp_b << 16) | temp_a);

#elif defined(CONFIG_ARCH_MT6735M)
	temp_a = spm_read(PMIC_WRAP_DVFS_WDATA2);
	temp_b = spm_read(PMIC_WRAP_DVFS_WDATA3);
	spm_write(SPM_PCM_PASR_DPD_3, (temp_b << 16) | temp_a);

#elif defined(CONFIG_ARCH_MT6753)
	spm_write(PMIC_WRAP_DVFS_ADR10, 0x454);
	spm_write(PMIC_WRAP_DVFS_WDATA10, 0x3E62);
	spm_write(PMIC_WRAP_DVFS_ADR11, 0x454);
	spm_write(PMIC_WRAP_DVFS_WDATA11, 0x2262);

#else
#endif
	spm_kick_pcm_to_run(pwrctrl);

#if SPM_AEE_RR_REC
	aee_rr_rec_spm_suspend_val(aee_rr_curr_spm_suspend_val() | (1 << SPM_SUSPEND_ENTER_WFI));
#endif

#if defined(CONFIG_ARCH_MT6580)
	gic_set_primask();
#endif
	spm_trigger_wfi_for_sleep(pwrctrl);
#if defined(CONFIG_ARCH_MT6580)
	gic_clear_primask();
#endif

#if !defined(CONFIG_ARCH_MT6580)
	mt_cpufreq_set_pmic_phase(PMIC_WRAP_PHASE_NORMAL);
#endif

#if SPM_AEE_RR_REC
	aee_rr_rec_spm_suspend_val(aee_rr_curr_spm_suspend_val() | (1 << SPM_SUSPEND_LEAVE_WFI));
#endif

	/* record last wakesta */
	/* __spm_get_wakeup_status(&wakesta); */
	__spm_get_wakeup_status(&spm_wakesta);

	spm_clean_after_wakeup();



	request_uart_to_wakeup();

	/* record last wakesta */
	/* last_wr = spm_output_wake_reason(&wakesta, pcmdesc); */
	last_wr = spm_output_wake_reason(&spm_wakesta, pcmdesc);
#if 0
	pmic_read_interface_nolock(MT6328_VRF18_0_CON0, &temp_c, 0xFFFF, 0);
	spm_crit2("VRF18_0 = 0x%x\n", temp_c);
#endif

#if defined(CONFIG_ARCH_MT6753)
	if (vcorefs_get_curr_voltage() == VCORE_1_P_25_UV)
		vcorefs_list_kicker_request();

	__spm_disable_i2c4_clk();
#endif

RESTORE_IRQ:
	mt_cirq_flush();
	mt_cirq_disable();

	mt_irq_mask_restore(&mask);
	spin_unlock_irqrestore(&__spm_lock, flags);
	lockdep_on();
	/* spm_suspend_post_process(pwrctrl); */

	if (!wd_ret)
		wd_api->wd_resume_notify();
#if SPM_AEE_RR_REC
	aee_rr_rec_spm_suspend_val(aee_rr_curr_spm_suspend_val() | (1 << SPM_SUSPEND_LEAVE));
#endif

	return last_wr;
}

bool spm_is_md_sleep(void)
{
	return !((spm_read(SPM_PCM_REG13_DATA) & R13_MD1_SRCLKENA) |
		 (spm_read(SPM_PCM_REG13_DATA) & R13_MD2_SRCLKENA));
}

bool spm_is_md1_sleep(void)
{
	return !(spm_read(SPM_PCM_REG13_DATA) & R13_MD1_SRCLKENA);
}

bool spm_is_md2_sleep(void)
{
	return !(spm_read(SPM_PCM_REG13_DATA) & R13_MD2_SRCLKENA);
}

bool spm_is_conn_sleep(void)
{
	return !(spm_read(SPM_PCM_REG13_DATA) & R13_CONN_SRCLKENA);
}

void spm_set_wakeup_src_check(void)
{
	/* clean wakeup event raw status */
	spm_write(SPM_SLEEP_WAKEUP_EVENT_MASK, 0xFFFFFFFF);

	/* set wakeup event */
	spm_write(SPM_SLEEP_WAKEUP_EVENT_MASK, ~WAKE_SRC_FOR_SUSPEND);
}

bool spm_check_wakeup_src(void)
{
	u32 wakeup_src;

	/* check wanek event raw status */
	wakeup_src = spm_read(SPM_SLEEP_ISR_RAW_STA);

	if (wakeup_src) {
		spm_crit2("WARNING: spm_check_wakeup_src = 0x%x", wakeup_src);
		return 1;
	} else
		return 0;
}

void spm_poweron_config_set(void)
{
	unsigned long flags;

	spin_lock_irqsave(&__spm_lock, flags);
	/* enable register control */
	spm_write(SPM_POWERON_CONFIG_SET, (SPM_PROJECT_CODE << 16) | (1U << 0));
	spin_unlock_irqrestore(&__spm_lock, flags);
}

void spm_md32_sram_con(u32 value)
{
	unsigned long flags;

	spin_lock_irqsave(&__spm_lock, flags);
	/* enable register control */
	spm_write(SPM_MD32_SRAM_CON, value);
	spin_unlock_irqrestore(&__spm_lock, flags);
}

/* FIXME: for K2 fpga early porting */
#if 0
#define hw_spin_lock_for_ddrdfs()           \
do {                                        \
	spm_write(0xF0050090, 0x8000);          \
} while (!(spm_read(0xF0050090) & 0x8000))

#define hw_spin_unlock_for_ddrdfs()         \
	spm_write(0xF0050090, 0x8000)
#else
#define hw_spin_lock_for_ddrdfs()
#define hw_spin_unlock_for_ddrdfs()
#endif

void spm_ap_mdsrc_req(u8 set)
{
	unsigned long flags;
	u32 i = 0;
	u32 md_sleep = 0;

	if (set) {
		spin_lock_irqsave(&__spm_lock, flags);

		if (spm_ap_mdsrc_req_cnt < 0) {
			spm_crit2("warning: set = %d, spm_ap_mdsrc_req_cnt = %d\n", set,
				  spm_ap_mdsrc_req_cnt);
			/* goto AP_MDSRC_REC_CNT_ERR; */
			spin_unlock_irqrestore(&__spm_lock, flags);
		} else {
			spm_ap_mdsrc_req_cnt++;

			hw_spin_lock_for_ddrdfs();
			spm_write(SPM_POWER_ON_VAL1, spm_read(SPM_POWER_ON_VAL1) | (1 << 17));
			hw_spin_unlock_for_ddrdfs();

			spin_unlock_irqrestore(&__spm_lock, flags);

			/* if md_apsrc_req = 1'b0, wait 26M settling time (3ms) */
			if (0 == (spm_read(SPM_PCM_REG13_DATA) & R13_MD1_APSRC_REQ)) {
				md_sleep = 1;
				mdelay(3);
			}

			/* Check ap_mdsrc_ack = 1'b1 */
			while (0 == (spm_read(SPM_PCM_REG13_DATA) & R13_AP_MD1SRC_ACK)) {
				if (10 > i++) {
					mdelay(1);
				} else {
					spm_crit2
					    ("WARNING: MD SLEEP = %d, spm_ap_mdsrc_req CAN NOT polling AP_MD1SRC_ACK\n",
					     md_sleep);
					/* goto AP_MDSRC_REC_CNT_ERR; */
					break;
				}
			}
		}
	} else {
		spin_lock_irqsave(&__spm_lock, flags);

		spm_ap_mdsrc_req_cnt--;

		if (spm_ap_mdsrc_req_cnt < 0) {
			spm_crit2("warning: set = %d, spm_ap_mdsrc_req_cnt = %d\n", set,
				  spm_ap_mdsrc_req_cnt);
			/* goto AP_MDSRC_REC_CNT_ERR; */
		} else {
			if (0 == spm_ap_mdsrc_req_cnt) {
				hw_spin_lock_for_ddrdfs();
				spm_write(SPM_POWER_ON_VAL1,
					  spm_read(SPM_POWER_ON_VAL1) & ~(1 << 17));
				hw_spin_unlock_for_ddrdfs();
			}
		}

		spin_unlock_irqrestore(&__spm_lock, flags);
	}

/* AP_MDSRC_REC_CNT_ERR: */
/* spin_unlock_irqrestore(&__spm_lock, flags); */
}

void spm_output_sleep_option(void)
{
	spm_notice("PWAKE_EN:%d, PCMWDT_EN:%d, BYPASS_SYSPWREQ:%d, I2C_CHANNEL:%d\n",
		   SPM_PWAKE_EN, SPM_PCMWDT_EN, SPM_BYPASS_SYSPWREQ, I2C_CHANNEL);
}

/* record last wakesta */
u32 spm_get_last_wakeup_src(void)
{
	return spm_wakesta.r12;
}

u32 spm_get_last_wakeup_misc(void)
{
	return spm_wakesta.wake_misc;
}

#if defined(CONFIG_ARCH_MT6580)
uint32_t get_suspend_debug_flag(void)
{
	uint32_t value = 0;

	value = spm_read(SPM_PCM_WDT_LATCH);
	spm_crit("PCM_WDT_LATCH=0x%x\n", spm_read(SPM_PCM_WDT_LATCH));
	return value;
}
EXPORT_SYMBOL(get_suspend_debug_flag);
#endif

MODULE_DESCRIPTION("SPM-Sleep Driver v0.1");
