#include <linux/init.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/spinlock.h>
#include <linux/delay.h>
#include <linux/of_fdt.h>
#include <linux/lockdep.h>
#include <linux/irqchip/mt-gic.h>

#ifdef CONFIG_OF
#include <linux/of.h>
#include <linux/of_irq.h>
#include <linux/of_address.h>
#endif

#include <mach/wd_api.h>
#if defined(CONFIG_ARCH_MT6753)
#include <mach/mt_secure_api.h>
#endif
#include <mt-plat/upmu_common.h>
#include <mt-plat/mt_cirq.h>
#include <mt-plat/mt_ccci_common.h>

#include "mt_spm_idle.h"
#include "mt_cpufreq.h"
#include "mt_cpuidle.h"

#include "mt_spm_internal.h"

/*
 * only for internal debug
 */
#define DPIDLE_TAG     "[DP] "
#define dpidle_dbg(fmt, args...)	pr_debug(DPIDLE_TAG fmt, ##args)

#define SPM_PWAKE_EN            0
#define SPM_BYPASS_SYSPWREQ     1

#if defined(CONFIG_ARCH_MT6735)
#define WAKE_SRC_FOR_DPIDLE \
	(WAKE_SRC_KP | WAKE_SRC_GPT | WAKE_SRC_EINT | WAKE_SRC_CONN_WDT | \
	WAKE_SRC_CCIF0_MD | WAKE_SRC_CCIF1_MD | WAKE_SRC_CONN2AP | WAKE_SRC_USB_CD | \
	WAKE_SRC_USB_PDN | WAKE_SRC_SEJ | WAKE_SRC_AFE | WAKE_SRC_CIRQ | WAKE_SRC_MD1_VRF18_WAKE | \
	WAKE_SRC_SYSPWREQ | WAKE_SRC_MD_WDT | WAKE_SRC_C2K_WDT | WAKE_SRC_CLDMA_MD)
#elif defined(CONFIG_ARCH_MT6735M)
#define WAKE_SRC_FOR_DPIDLE \
	(WAKE_SRC_KP | WAKE_SRC_GPT | WAKE_SRC_EINT | WAKE_SRC_CONN_WDT | \
	WAKE_SRC_CCIF0_MD | WAKE_SRC_CCIF1_MD | WAKE_SRC_CONN2AP | WAKE_SRC_USB_CD | \
	WAKE_SRC_USB_PDN | WAKE_SRC_SEJ | WAKE_SRC_AFE | WAKE_SRC_CIRQ | WAKE_SRC_MD1_VRF18_WAKE | \
	WAKE_SRC_SYSPWREQ | WAKE_SRC_MD_WDT | WAKE_SRC_CLDMA_MD)
#elif defined(CONFIG_ARCH_MT6753)

#if defined(CONFIG_MICROTRUST_TEE_SUPPORT)
#define WAKE_SRC_FOR_DPIDLE \
	(WAKE_SRC_KP | WAKE_SRC_GPT | WAKE_SRC_EINT | WAKE_SRC_CONN_WDT | \
	WAKE_SRC_CCIF0_MD | WAKE_SRC_CCIF1_MD | WAKE_SRC_CONN2AP | WAKE_SRC_USB_CD | \
	WAKE_SRC_USB_PDN | WAKE_SRC_AFE | WAKE_SRC_CIRQ | WAKE_SRC_MD1_VRF18_WAKE | \
	WAKE_SRC_SYSPWREQ | WAKE_SRC_MD_WDT | WAKE_SRC_C2K_WDT | WAKE_SRC_CLDMA_MD)
#else
#define WAKE_SRC_FOR_DPIDLE \
	(WAKE_SRC_KP | WAKE_SRC_GPT | WAKE_SRC_EINT | WAKE_SRC_CONN_WDT | \
	WAKE_SRC_CCIF0_MD | WAKE_SRC_CCIF1_MD | WAKE_SRC_CONN2AP | WAKE_SRC_USB_CD | \
	WAKE_SRC_USB_PDN | WAKE_SRC_SEJ | WAKE_SRC_AFE | WAKE_SRC_CIRQ | WAKE_SRC_MD1_VRF18_WAKE | \
	WAKE_SRC_SYSPWREQ | WAKE_SRC_MD_WDT | WAKE_SRC_C2K_WDT | WAKE_SRC_CLDMA_MD)
#endif
	
#elif defined(CONFIG_ARCH_MT6580)
#define WAKE_SRC_FOR_DPIDLE \
	(WAKE_SRC_KP | WAKE_SRC_GPT | WAKE_SRC_EINT | WAKE_SRC_CONN_WDT| \
	WAKE_SRC_CCIF0_MD | WAKE_SRC_CONN2AP | WAKE_SRC_USB_CD | WAKE_SRC_USB_PDN | \
	WAKE_SRC_AFE | WAKE_SRC_SYSPWREQ | WAKE_SRC_MD1_WDT | WAKE_SRC_SEJ)
#else
#error "Does not support!"
#endif

#define WAKE_SRC_FOR_MD32  0

#define I2C_CHANNEL 2

#define spm_is_wakesrc_invalid(wakesrc)     (!!((u32)(wakesrc) & 0xc0003803))

#if defined(CONFIG_ARCH_MT6753)
#define reg_read(addr)         __raw_readl(IOMEM(addr))
#define reg_write(addr, val)   mt_reg_sync_writel((val), ((void *)addr))

#if defined(CONFIG_OF)
#define MCUCFG_NODE "mediatek,MCUCFG"
static unsigned long mcucfg_base;
static unsigned long mcucfg_phys_base;
#undef MCUCFG_BASE
#define MCUCFG_BASE             (mcucfg_base)

#else				/* #if defined(CONFIG_OF) */
#undef MCUCFG_BASE
#define MCUCFG_BASE             0xF0200000
#endif				/* #if defined(CONFIG_OF) */

/* MCUCFG registers */
#define MP0_AXI_CONFIG       (MCUCFG_BASE + 0x2C)
#define MP0_AXI_CONFIG_PHYS  (mcucfg_phys_base + 0x2C)
#define MP1_AXI_CONFIG       (MCUCFG_BASE + 0x22C)
#define MP1_AXI_CONFIG_PHYS  (mcucfg_phys_base + 0x22C)
#define ACINACTM                (1 << 4)

#if defined(CONFIG_ARM_PSCI) || defined(CONFIG_MTK_PSCI)
#define MCUSYS_SMC_WRITE(addr, val)  mcusys_smc_write_phy(addr##_PHYS, val)
#else
#define MCUSYS_SMC_WRITE(addr, val)  mcusys_smc_write(addr, val)
#endif
#endif				/* #if defined(CONFIG_ARCH_MT6753) */

#ifdef CONFIG_MTK_RAM_CONSOLE
#define SPM_AEE_RR_REC 1
#else
#define SPM_AEE_RR_REC 0
#endif
#define SPM_USE_TWAM_DEBUG	0

#define	DPIDLE_LOG_PRINT_TIMEOUT_CRITERIA	20
#define	DPIDLE_LOG_DISCARD_CRITERIA			5000	/* ms */

#if SPM_AEE_RR_REC
enum spm_deepidle_step {
	SPM_DEEPIDLE_ENTER = 0,
	SPM_DEEPIDLE_ENTER_UART_SLEEP,
	SPM_DEEPIDLE_ENTER_WFI,
	SPM_DEEPIDLE_LEAVE_WFI,
	SPM_DEEPIDLE_ENTER_UART_AWAKE,
	SPM_DEEPIDLE_LEAVE
};
#endif

#if defined(CONFIG_ARCH_MT6735)
/*
 * PCM code for deep idle
 */
static const u32 dpidle_binary[] = {
	0x81429801, 0xd80001e5, 0x17c07c1f, 0x18c0001f, 0x10001138, 0x1910001f,
	0x10001138, 0xa1108404, 0xe0c00004, 0x1910001f, 0x10001138, 0x1a00001f,
	0x10006604, 0xc0c03580, 0xe2200007, 0x1a00001f, 0x100062c4, 0x1890001f,
	0x100062c4, 0xa0940402, 0x1b00001f, 0x10000001, 0x1910001f, 0x10006310,
	0x80c39001, 0xd8200443, 0xe2000002, 0x80c10001, 0x1b00001f, 0xbf7ce7ff,
	0xd8200443, 0x17c07c1f, 0x1b00001f, 0x7f7ce7ff, 0xf0000000, 0x17c07c1f,
	0x81429801, 0xd8000665, 0x17c07c1f, 0x18c0001f, 0x10001138, 0x1910001f,
	0x10001138, 0x81308404, 0xe0c00004, 0x1910001f, 0x10001138, 0x1a00001f,
	0x10006604, 0xc0c03580, 0xe2200007, 0x1a00001f, 0x100062c4, 0x1890001f,
	0x100062c4, 0x80b40402, 0x1b00001f, 0x00801001, 0x1910001f, 0x10006310,
	0x80c39001, 0xd82008c3, 0xe2000002, 0x80c10001, 0x1b00001f, 0x6ffcf7ff,
	0xd80008c3, 0x17c07c1f, 0x1b00001f, 0xaffce7ff, 0xf0000000, 0x17c07c1f,
	0x81459801, 0xd8000a05, 0x17c07c1f, 0x1a00001f, 0x10006604, 0xe2200002,
	0xc0c03580, 0x17c07c1f, 0x80328400, 0xc2803480, 0x1290041f, 0x1b00001f,
	0x6ffcf7ff, 0xf0000000, 0x17c07c1f, 0x1b00001f, 0x2f7ce7ff, 0x1b80001f,
	0x20000004, 0xd8000d4c, 0x17c07c1f, 0xa0128400, 0xc2803480, 0x1290841f,
	0x81459801, 0xd8000d05, 0x17c07c1f, 0x1a00001f, 0x10006604, 0xe2200005,
	0xc0c03580, 0x17c07c1f, 0x1b00001f, 0x2f7cefff, 0xf0000000, 0x17c07c1f,
	0x18c0001f, 0x102135cc, 0x1910001f, 0x102135cc, 0x813f8404, 0xe0c00004,
	0x1910001f, 0x102135cc, 0x81411801, 0xd8000fa5, 0x17c07c1f, 0x18c0001f,
	0x10006240, 0xe0e00016, 0xe0e0001e, 0xe0e0000e, 0xe0e0000f, 0x803e0400,
	0x1b80001f, 0x20000222, 0x80380400, 0x1b80001f, 0x20000280, 0x803b0400,
	0x1b80001f, 0x2000001a, 0x803d0400, 0x1b80001f, 0x20000208, 0x80340400,
	0x80310400, 0x1b80001f, 0x2000000a, 0x18c0001f, 0x10006240, 0xe0e0000d,
	0xd80015c5, 0x17c07c1f, 0x1b80001f, 0x20000020, 0x18c0001f, 0x102130f0,
	0x1910001f, 0x102130f0, 0xa9000004, 0x10000000, 0xe0c00004, 0x1b80001f,
	0x2000000a, 0x89000004, 0xefffffff, 0xe0c00004, 0x18c0001f, 0x102140f4,
	0x1910001f, 0x102140f4, 0xa9000004, 0x02000000, 0xe0c00004, 0x1b80001f,
	0x2000000a, 0x89000004, 0xfdffffff, 0xe0c00004, 0x1910001f, 0x102140f4,
	0x81fa0407, 0x81f08407, 0xe8208000, 0x10006354, 0x001fdaa3, 0xa1d80407,
	0xa1de8407, 0xa1df0407, 0xc2803480, 0x1291041f, 0x1b00001f, 0xbf7ce7ff,
	0x1950001f, 0x100062c4, 0x80c41401, 0xd8001823, 0x17c07c1f, 0x1b00001f,
	0xaffce7ff, 0xf0000000, 0x17c07c1f, 0x1b80001f, 0x20000fdf, 0x1a50001f,
	0x10006608, 0x80c9a401, 0x810ba401, 0x10920c1f, 0xa0979002, 0x80ca2401,
	0xa0938c02, 0x8080080d, 0xd8201ca2, 0x17c07c1f, 0x81f08407, 0xa1d80407,
	0xa1de8407, 0xa1df0407, 0x1b00001f, 0x2f7ce7ff, 0x1b80001f, 0x20000004,
	0xd800232c, 0x17c07c1f, 0x1b00001f, 0xbf7ce7ff, 0x1950001f, 0x100062c4,
	0x80c41401, 0xd8002323, 0x17c07c1f, 0x1b00001f, 0xaffce7ff, 0xd0002320,
	0x17c07c1f, 0x81f80407, 0x81fe8407, 0x81ff0407, 0x1900001f, 0x40000000,
	0x18d0001f, 0x40000000, 0xe1000003, 0xc0c03660, 0x1080041f, 0x1880001f,
	0x10006320, 0xc0c02cc0, 0xe080000f, 0xd8001a03, 0x17c07c1f, 0xe080001f,
	0xa1da0407, 0xa0110400, 0xa0140400, 0xa0180400, 0xa01b0400, 0xa01d0400,
	0x1b80001f, 0x20000068, 0xa01e0400, 0x1b80001f, 0x20000104, 0x18c0001f,
	0x102135cc, 0x1910001f, 0x102135cc, 0xa11f8404, 0xe0c00004, 0x81411801,
	0xd80021c5, 0x17c07c1f, 0x18c0001f, 0x10006240, 0xc0c02c00, 0x17c07c1f,
	0xc2803480, 0x1291841f, 0x1b00001f, 0x6ffcf7ff, 0x1950001f, 0x100062c4,
	0x80c41401, 0xd8202323, 0x17c07c1f, 0x1b00001f, 0x7f7ce7ff, 0xf0000000,
	0x17c07c1f, 0x81441801, 0xd8202585, 0x17c07c1f, 0x1a00001f, 0x10006604,
	0xc0c03580, 0xe2200004, 0xc0c03660, 0x1093041f, 0xc0c03580, 0xe2200003,
	0xc0c03660, 0x1093041f, 0xc0c03580, 0xe2200002, 0xc0c03660, 0x1093041f,
	0x1a00001f, 0x100062c4, 0x1890001f, 0x100062c4, 0xa0908402, 0xe2000002,
	0x1b00001f, 0x00801001, 0xf0000000, 0x17c07c1f, 0x1a00001f, 0x100062c4,
	0x1890001f, 0x100062c4, 0x80b08402, 0xe2000002, 0x81441801, 0xd82029a5,
	0x17c07c1f, 0x1a00001f, 0x10006604, 0xc0c03580, 0xe2200003, 0xc0c03660,
	0x1093041f, 0xc0c03580, 0xe2200004, 0xc0c03660, 0x1093041f, 0xc0c03580,
	0xe2200005, 0xc0c03660, 0x1093041f, 0x1b00001f, 0x00000801, 0xf0000000,
	0x17c07c1f, 0xe0f07f16, 0x1380201f, 0xe0f07f1e, 0x1380201f, 0xe0f07f0e,
	0x1b80001f, 0x20000100, 0xe0f07f0c, 0xe0f07f0d, 0xe0f07e0d, 0xe0f07c0d,
	0xe0f0780d, 0xe0f0700d, 0xf0000000, 0x17c07c1f, 0xe0f07f0d, 0xe0f07f0f,
	0xe0f07f1e, 0xe0f07f12, 0xf0000000, 0x17c07c1f, 0x1112841f, 0xa1d08407,
	0xd8202d84, 0x80eab401, 0xd8002d03, 0x01200404, 0x1a00001f, 0x10006814,
	0xe2000003, 0xf0000000, 0x17c07c1f, 0xa1d00407, 0x1b80001f, 0x20000100,
	0x80ea3401, 0x1a00001f, 0x10006814, 0xe2000003, 0xf0000000, 0x17c07c1f,
	0xd800304a, 0x17c07c1f, 0xe2e00036, 0x17c07c1f, 0x17c07c1f, 0xe2e0003e,
	0x1380201f, 0xe2e0003c, 0xd820318a, 0x17c07c1f, 0x1b80001f, 0x20000018,
	0xe2e0007c, 0x1b80001f, 0x20000003, 0xe2e0005c, 0xe2e0004c, 0xe2e0004d,
	0xf0000000, 0x17c07c1f, 0xa1d10407, 0x1b80001f, 0x20000020, 0xf0000000,
	0x17c07c1f, 0xa1d40407, 0x1391841f, 0xa1d90407, 0xf0000000, 0x17c07c1f,
	0xd80033aa, 0x17c07c1f, 0xe2e0004f, 0xe2e0006f, 0xe2e0002f, 0xd820344a,
	0x17c07c1f, 0xe2e0002e, 0xe2e0003e, 0xe2e00032, 0xf0000000, 0x17c07c1f,
	0x18c0001f, 0x10006b18, 0x1910001f, 0x10006b18, 0xa1002804, 0xe0c00004,
	0xf0000000, 0x17c07c1f, 0x18d0001f, 0x10006604, 0x10cf8c1f, 0xd8203583,
	0x17c07c1f, 0xf0000000, 0x17c07c1f, 0x81499801, 0xd82037c5, 0x17c07c1f,
	0xd8203ce2, 0x17c07c1f, 0x18d0001f, 0x40000000, 0x18d0001f, 0x70000000,
	0xd80036c2, 0x00a00402, 0x814a1801, 0xd8203925, 0x17c07c1f, 0xd8203ce2,
	0x17c07c1f, 0x18d0001f, 0x40000000, 0x18d0001f, 0x80000000, 0xd8003822,
	0x00a00402, 0x814a9801, 0xd8203a85, 0x17c07c1f, 0xd8203ce2, 0x17c07c1f,
	0x18d0001f, 0x40000000, 0x18d0001f, 0xc0000000, 0xd8003982, 0x00a00402,
	0x814c1801, 0xd8203be5, 0x17c07c1f, 0xd8203ce2, 0x17c07c1f, 0x18d0001f,
	0x40000000, 0x18d0001f, 0xa0000000, 0xd8003ae2, 0x00a00402, 0xd8203ce2,
	0x17c07c1f, 0x18d0001f, 0x40000000, 0x18d0001f, 0x40000000, 0xd8003be2,
	0x00a00402, 0xf0000000, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x1840001f, 0x00000001, 0xa1d48407, 0x1990001f,
	0x10006b08, 0xe8208000, 0x10006b18, 0x00000000, 0x81441801, 0xd8204565,
	0x17c07c1f, 0x1910001f, 0x100062c4, 0x80849001, 0x1a00001f, 0x10006b0c,
	0x1950001f, 0x10006b0c, 0xa1508805, 0xe2000005, 0x18c0001f, 0x2f7ce7ff,
	0x80809001, 0x81600801, 0xa0d59403, 0xa0d60803, 0xd8004465, 0x17c07c1f,
	0x80841001, 0x81600801, 0xa0db9403, 0xa0de0803, 0xd8004465, 0x17c07c1f,
	0x80f60403, 0xe8208000, 0x10006310, 0x0b160c38, 0x13000c1f, 0x1b80001f,
	0xd00f0000, 0xd00045a0, 0x17c07c1f, 0x1b00001f, 0x2f7ce7ff, 0x81469801,
	0xd8204705, 0x17c07c1f, 0x1b80001f, 0xd00f0000, 0x8880000c, 0x2f7ce7ff,
	0xd8006502, 0x17c07c1f, 0xd0004740, 0x17c07c1f, 0x1b80001f, 0x500f0000,
	0xe8208000, 0x10006354, 0x001fdaa3, 0xc0c031c0, 0x81401801, 0xd8004c65,
	0x17c07c1f, 0x81f60407, 0x18c0001f, 0x10006200, 0xc0c03300, 0x12807c1f,
	0xe8208000, 0x1000625c, 0x00000001, 0x1b80001f, 0x20000080, 0xc0c03300,
	0x1280041f, 0x18c0001f, 0x10006208, 0xc0c03300, 0x12807c1f, 0xe8208000,
	0x10006248, 0x00000000, 0x1b80001f, 0x20000080, 0xc0c03300, 0x1280041f,
	0x18c0001f, 0x10006290, 0xc0c03300, 0x12807c1f, 0xc0c03300, 0x1280041f,
	0x18c0001f, 0x100062dc, 0xe0c00001, 0xc2803480, 0x1292041f, 0x81469801,
	0xd8004d45, 0x17c07c1f, 0x8880000c, 0x2f7ce7ff, 0xd8006062, 0x17c07c1f,
	0xc0c03260, 0x17c07c1f, 0x18c0001f, 0x10006294, 0xe0f07fff, 0xe0e00fff,
	0xe0e000ff, 0x81449801, 0xd8005065, 0x17c07c1f, 0x1a00001f, 0x10006604,
	0xe2200006, 0xc0c03580, 0x17c07c1f, 0x1a00001f, 0x10006604, 0xe2200001,
	0xc0c03580, 0x17c07c1f, 0x18c0001f, 0x10001130, 0x1910001f, 0x10006b14,
	0xe0c00004, 0xa1d38407, 0xa1d98407, 0xa0108400, 0xa0120400, 0xa0148400,
	0xa0150400, 0xa0158400, 0xa01b8400, 0xa01c0400, 0xa01c8400, 0xa0188400,
	0xa0190400, 0xa0198400, 0x81441801, 0xd8205465, 0x17c07c1f, 0x1910001f,
	0x10006b0c, 0x1a00001f, 0x100062c4, 0x1950001f, 0x100062c4, 0x80809001,
	0x81748405, 0xa1548805, 0xe2000005, 0x1a00001f, 0x10006b0c, 0x80c51801,
	0x81308404, 0xa1108c04, 0xe2000004, 0xe8208000, 0x10006310, 0x0b1603f8,
	0x1950001f, 0x100062c4, 0x80841401, 0x81600801, 0x18c0001f, 0xaf7ce7ff,
	0xa0de0803, 0xa0db9403, 0x13000c1f, 0x1b80001f, 0x90100000, 0x80c28001,
	0xc8c00903, 0x17c07c1f, 0x80c10001, 0xc8c00d83, 0x17c07c1f, 0x1a00001f,
	0x100062c4, 0x1890001f, 0x100062c4, 0xa0908402, 0xe2000002, 0x18d0001f,
	0x10006284, 0x80810c01, 0xd8205b02, 0x17c07c1f, 0x18d0001f, 0x100062c4,
	0x80840c01, 0xd8005b02, 0x17c07c1f, 0x18c0001f, 0x10001138, 0x1910001f,
	0x10001138, 0xa1108404, 0xe0c00004, 0x1910001f, 0x10001138, 0x1a00001f,
	0x10006604, 0xe2200007, 0x1a00001f, 0x100062c4, 0x1890001f, 0x100062c4,
	0xa0940402, 0xe2000002, 0x1b00001f, 0x2f7ce7ff, 0x18c0001f, 0x10006294,
	0xe0e001fe, 0xe0e003fc, 0xe0e007f8, 0xe0e00ff0, 0x1b80001f, 0x20000020,
	0xe0f07ff0, 0xe0f07f00, 0x81449801, 0xd8005de5, 0x17c07c1f, 0x1a00001f,
	0x10006604, 0xe2200006, 0xc0c03580, 0x17c07c1f, 0xe2200000, 0xc0c03580,
	0x17c07c1f, 0x80388400, 0x80390400, 0x80398400, 0x1b80001f, 0x20000300,
	0x803b8400, 0x803c0400, 0x803c8400, 0x1b80001f, 0x20000300, 0x80348400,
	0x80350400, 0x80358400, 0x1b80001f, 0x20000104, 0x10007c1f, 0x81f38407,
	0x81f98407, 0x81f90407, 0x81f40407, 0x81401801, 0xd8006505, 0x17c07c1f,
	0x18c0001f, 0x100062dc, 0xe0c0001f, 0x18c0001f, 0x10006290, 0x1212841f,
	0xc0c02f40, 0x12807c1f, 0xc0c02f40, 0x1280041f, 0x18c0001f, 0x10006208,
	0x1212841f, 0xc0c02f40, 0x12807c1f, 0xe8208000, 0x10006248, 0x00000001,
	0x1b80001f, 0x20000080, 0xc0c02f40, 0x1280041f, 0x18c0001f, 0x10006200,
	0x1212841f, 0xc0c02f40, 0x12807c1f, 0xe8208000, 0x1000625c, 0x00000000,
	0x1b80001f, 0x20000080, 0xc0c02f40, 0x1280041f, 0x19c0001f, 0x60415820,
	0xe8208000, 0x10006310, 0x0b160008, 0xc2803480, 0x1293841f, 0x18c0001f,
	0x10006b14, 0xe0c0000c, 0x18c0001f, 0x10006b68, 0x1950001f, 0x100063c0,
	0xe0c00005, 0x81441801, 0xd8206b05, 0x10c0041f, 0x1910001f, 0x100062c4,
	0x80849001, 0x1a00001f, 0x10006b0c, 0x1910001f, 0x10006b0c, 0xa0908804,
	0xe2000002, 0x81441801, 0xd8206b05, 0x10c0041f, 0x1910001f, 0x100062c4,
	0x80809001, 0x81600801, 0xa0d59403, 0xa0d60803, 0xd8006aa5, 0x17c07c1f,
	0x80841001, 0x81600801, 0xa0db9403, 0xa0de0803, 0xd8006aa5, 0x17c07c1f,
	0x80f60403, 0xe8208000, 0x10006310, 0x0b160c38, 0x13000c1f, 0x1b80001f,
	0x900a0000, 0x88900001, 0x10006814, 0xd8206862, 0x17c07c1f, 0x18d0001f,
	0x10006b6c, 0x78a00003, 0x0000beef, 0xd8006d22, 0x17c07c1f, 0xc0c06f80,
	0x17c07c1f, 0xd0006860, 0x17c07c1f, 0x1910001f, 0x10006b0c, 0x1a00001f,
	0x100062c4, 0x1950001f, 0x100062c4, 0x80809001, 0x81748405, 0xa1548805,
	0xe2000005, 0x80841401, 0xd8006f02, 0x8204b401, 0xc8c00008, 0x17c07c1f,
	0x1ac0001f, 0x55aa55aa, 0x10007c1f, 0xf0000000, 0x1900001f, 0x10006014,
	0x1950001f, 0x10006014, 0xa1508405, 0xe1000005, 0x1900001f, 0x10006814,
	0xe100001f, 0x812ab401, 0xd80070a4, 0x17c07c1f, 0x1880001f, 0x10006284,
	0x18d0001f, 0x10006284, 0x80f20403, 0xe0800003, 0x80f08403, 0xe0800003,
	0x1900001f, 0x10006014, 0x1950001f, 0x10006014, 0x81708405, 0xe1000005,
	0x1900001f, 0x10006b6c, 0xe100001f, 0x81441801, 0xd80074e5, 0x17c07c1f,
	0x18c0001f, 0x10001138, 0x1910001f, 0x10001138, 0xa1108404, 0xe0c00004,
	0x1910001f, 0x10001138, 0x1a00001f, 0x10006604, 0xe2200007, 0xf0000000,
	0x17c07c1f
};
static struct pcm_desc dpidle_pcm = {
	.version	= "pcm_deepidle_v28.10.10.5.4_20160125-dummy_read",
	.base		= dpidle_binary,
	.size		= 937,
	.sess		= 2,
	.replace	= 0,
	.vec0		= EVENT_VEC(23, 1, 0, 0),	/* FUNC_MD_VRF18_WAKEUP */
	.vec1		= EVENT_VEC(28, 1, 0, 36),	/* FUNC_MD_VRF18_SLEEP */
	.vec2		= EVENT_VEC(11, 1, 0, 72),	/* FUNC_26M_WAKEUP */
	.vec3		= EVENT_VEC(12, 1, 0, 87),	/* FUNC_26M_SLEEP */
	.vec4		= EVENT_VEC(30, 1, 0, 108),	/* FUNC_APSRC_WAKEUP */
	.vec5		= EVENT_VEC(31, 1, 0, 195),	/* FUNC_APSRC_SLEEP */
	.vec6		= EVENT_VEC(11, 1, 0, 283),	/* FUNC_VCORE_HIGH */
	.vec7		= EVENT_VEC(12, 1, 0, 310),	/* FUNC_VCORE_LOW */
};

static struct pwr_ctrl dpidle_ctrl = {
	.wake_src = WAKE_SRC_FOR_DPIDLE,
	.wake_src_md32 = WAKE_SRC_FOR_MD32,
	.r0_ctrl_en = 1,
	.r7_ctrl_en = 1,
	.infra_dcm_lock = 1,
	.wfi_op = WFI_OP_AND,
	.ca15_wfi0_en = 1,
	.ca15_wfi1_en = 1,
	.ca15_wfi2_en = 1,
	.ca15_wfi3_en = 1,
	.ca7_wfi0_en = 1,
	.ca7_wfi1_en = 1,
	.ca7_wfi2_en = 1,
	.ca7_wfi3_en = 1,
	.disp_req_mask = 1,
	.mfg_req_mask = 1,
	.lte_mask = 1,
	.syspwreq_mask = 1,
};
#elif defined(CONFIG_ARCH_MT6735M)
/*
 * PCM code for deep idle
 */
static const u32 dpidle_binary[] = {
	0x81429801, 0xd80001e5, 0x17c07c1f, 0x18c0001f, 0x10001124, 0x1910001f,
	0x10001124, 0xa1108404, 0xe0c00004, 0x1910001f, 0x10001124, 0x1a00001f,
	0x10006604, 0xc0c035a0, 0xe2200007, 0x1a00001f, 0x100062c4, 0x1890001f,
	0x100062c4, 0xa0940402, 0x1b00001f, 0x10000001, 0x1910001f, 0x10006310,
	0x80c39001, 0xd8200443, 0xe2000002, 0x80c10001, 0x1b00001f, 0xbf7ce7ff,
	0xd8200443, 0x17c07c1f, 0x1b00001f, 0x7f7ce7ff, 0xf0000000, 0x17c07c1f,
	0x81429801, 0xd8000665, 0x17c07c1f, 0x18c0001f, 0x10001124, 0x1910001f,
	0x10001124, 0x81308404, 0xe0c00004, 0x1910001f, 0x10001124, 0x1a00001f,
	0x10006604, 0xc0c035a0, 0xe2200007, 0x1a00001f, 0x100062c4, 0x1890001f,
	0x100062c4, 0x80b40402, 0x1b00001f, 0x00801001, 0x1910001f, 0x10006310,
	0x80c39001, 0xd82008c3, 0xe2000002, 0x80c10001, 0x1b00001f, 0x6ffcf7ff,
	0xd80008c3, 0x17c07c1f, 0x1b00001f, 0xaffce7ff, 0xf0000000, 0x17c07c1f,
	0x81459801, 0xd8000a05, 0x17c07c1f, 0x1a00001f, 0x10006604, 0xe2200002,
	0xc0c035a0, 0x17c07c1f, 0x80328400, 0x80318400, 0xc28034a0, 0x1290041f,
	0x1b00001f, 0x6ffcf7ff, 0xf0000000, 0x17c07c1f, 0x1b00001f, 0x2f7ce7ff,
	0x1b80001f, 0x20000004, 0xd8000d6c, 0x17c07c1f, 0xa0128400, 0xc28034a0,
	0x1290841f, 0x81459801, 0xd8000d25, 0x17c07c1f, 0x1a00001f, 0x10006604,
	0xe2200005, 0xc0c035a0, 0x17c07c1f, 0x1b00001f, 0x2f7cefff, 0xf0000000,
	0x17c07c1f, 0x18c0001f, 0x102135cc, 0x1910001f, 0x102135cc, 0x813f8404,
	0xe0c00004, 0x1910001f, 0x102135cc, 0x81411801, 0xd8000fc5, 0x17c07c1f,
	0x18c0001f, 0x10006240, 0xe0e00016, 0xe0e0001e, 0xe0e0000e, 0xe0e0000f,
	0x803e0400, 0x1b80001f, 0x20000222, 0x80380400, 0x1b80001f, 0x20000280,
	0x803b0400, 0x1b80001f, 0x2000001a, 0x803d0400, 0x1b80001f, 0x20000208,
	0x80340400, 0x80310400, 0x1b80001f, 0x2000000a, 0x18c0001f, 0x10006240,
	0xe0e0000d, 0xd80015e5, 0x17c07c1f, 0x1b80001f, 0x20000020, 0x18c0001f,
	0x102130f0, 0x1910001f, 0x102130f0, 0xa9000004, 0x10000000, 0xe0c00004,
	0x1b80001f, 0x2000000a, 0x89000004, 0xefffffff, 0xe0c00004, 0x18c0001f,
	0x102140f4, 0x1910001f, 0x102140f4, 0xa9000004, 0x02000000, 0xe0c00004,
	0x1b80001f, 0x2000000a, 0x89000004, 0xfdffffff, 0xe0c00004, 0x1910001f,
	0x102140f4, 0x81fa0407, 0x81f08407, 0xe8208000, 0x10006354, 0x001fdaa3,
	0xa1d80407, 0xa1de8407, 0xa1df0407, 0xc28034a0, 0x1291041f, 0x1b00001f,
	0xbf7ce7ff, 0x1950001f, 0x100062c4, 0x80c41401, 0xd8001843, 0x17c07c1f,
	0x1b00001f, 0xaffce7ff, 0xf0000000, 0x17c07c1f, 0x1b80001f, 0x20000fdf,
	0x1a50001f, 0x10006608, 0x80c9a401, 0x810ba401, 0x10920c1f, 0xa0979002,
	0x80ca2401, 0xa0938c02, 0x8080080d, 0xd8201cc2, 0x17c07c1f, 0x81f08407,
	0xa1d80407, 0xa1de8407, 0xa1df0407, 0x1b00001f, 0x2f7ce7ff, 0x1b80001f,
	0x20000004, 0xd800234c, 0x17c07c1f, 0x1b00001f, 0xbf7ce7ff, 0x1950001f,
	0x100062c4, 0x80c41401, 0xd8002343, 0x17c07c1f, 0x1b00001f, 0xaffce7ff,
	0xd0002340, 0x17c07c1f, 0x81f80407, 0x81fe8407, 0x81ff0407, 0x1900001f,
	0x40000000, 0x18d0001f, 0x40000000, 0xe1000003, 0xc0c03680, 0x1080041f,
	0x1880001f, 0x10006320, 0xc0c02ce0, 0xe080000f, 0xd8001a23, 0x17c07c1f,
	0xe080001f, 0xa1da0407, 0xa0110400, 0xa0140400, 0xa0180400, 0xa01b0400,
	0xa01d0400, 0x1b80001f, 0x20000068, 0xa01e0400, 0x1b80001f, 0x20000104,
	0x18c0001f, 0x102135cc, 0x1910001f, 0x102135cc, 0xa11f8404, 0xe0c00004,
	0x81411801, 0xd80021e5, 0x17c07c1f, 0x18c0001f, 0x10006240, 0xc0c02c20,
	0x17c07c1f, 0xc28034a0, 0x1291841f, 0x1b00001f, 0x6ffcf7ff, 0x1950001f,
	0x100062c4, 0x80c41401, 0xd8202343, 0x17c07c1f, 0x1b00001f, 0x7f7ce7ff,
	0xf0000000, 0x17c07c1f, 0x81441801, 0xd82025a5, 0x17c07c1f, 0x1a00001f,
	0x10006604, 0xc0c035a0, 0xe2200004, 0xc0c03680, 0x1093041f, 0xc0c035a0,
	0xe2200003, 0xc0c03680, 0x1093041f, 0xc0c035a0, 0xe2200002, 0xc0c03680,
	0x1093041f, 0x1a00001f, 0x100062c4, 0x1890001f, 0x100062c4, 0xa0908402,
	0xe2000002, 0x1b00001f, 0x00801001, 0xf0000000, 0x17c07c1f, 0x1a00001f,
	0x100062c4, 0x1890001f, 0x100062c4, 0x80b08402, 0xe2000002, 0x81441801,
	0xd82029c5, 0x17c07c1f, 0x1a00001f, 0x10006604, 0xc0c035a0, 0xe2200003,
	0xc0c03680, 0x1093041f, 0xc0c035a0, 0xe2200004, 0xc0c03680, 0x1093041f,
	0xc0c035a0, 0xe2200005, 0xc0c03680, 0x1093041f, 0x1b00001f, 0x00000801,
	0xf0000000, 0x17c07c1f, 0xe0f07f16, 0x1380201f, 0xe0f07f1e, 0x1380201f,
	0xe0f07f0e, 0x1b80001f, 0x20000100, 0xe0f07f0c, 0xe0f07f0d, 0xe0f07e0d,
	0xe0f07c0d, 0xe0f0780d, 0xe0f0700d, 0xf0000000, 0x17c07c1f, 0xe0f07f0d,
	0xe0f07f0f, 0xe0f07f1e, 0xe0f07f12, 0xf0000000, 0x17c07c1f, 0x1112841f,
	0xa1d08407, 0xd8202da4, 0x80eab401, 0xd8002d23, 0x01200404, 0x1a00001f,
	0x10006814, 0xe2000003, 0xf0000000, 0x17c07c1f, 0xa1d00407, 0x1b80001f,
	0x20000100, 0x80ea3401, 0x1a00001f, 0x10006814, 0xe2000003, 0xf0000000,
	0x17c07c1f, 0xd800306a, 0x17c07c1f, 0xe2e00036, 0x17c07c1f, 0x17c07c1f,
	0xe2e0003e, 0x1380201f, 0xe2e0003c, 0xd82031aa, 0x17c07c1f, 0x1b80001f,
	0x20000018, 0xe2e0007c, 0x1b80001f, 0x20000003, 0xe2e0005c, 0xe2e0004c,
	0xe2e0004d, 0xf0000000, 0x17c07c1f, 0xa1d10407, 0x1b80001f, 0x20000020,
	0xf0000000, 0x17c07c1f, 0xa1d40407, 0x1391841f, 0xa1d90407, 0xf0000000,
	0x17c07c1f, 0xd80033ca, 0x17c07c1f, 0xe2e0004f, 0xe2e0006f, 0xe2e0002f,
	0xd820346a, 0x17c07c1f, 0xe2e0002e, 0xe2e0003e, 0xe2e00032, 0xf0000000,
	0x17c07c1f, 0x18c0001f, 0x10006b18, 0x1910001f, 0x10006b18, 0xa1002804,
	0xe0c00004, 0xf0000000, 0x17c07c1f, 0x18d0001f, 0x10006604, 0x10cf8c1f,
	0xd82035a3, 0x17c07c1f, 0xf0000000, 0x17c07c1f, 0x81499801, 0xd82037e5,
	0x17c07c1f, 0xd8203d02, 0x17c07c1f, 0x18d0001f, 0x40000000, 0x18d0001f,
	0x70000000, 0xd80036e2, 0x00a00402, 0x814a1801, 0xd8203945, 0x17c07c1f,
	0xd8203d02, 0x17c07c1f, 0x18d0001f, 0x40000000, 0x18d0001f, 0x80000000,
	0xd8003842, 0x00a00402, 0x814a9801, 0xd8203aa5, 0x17c07c1f, 0xd8203d02,
	0x17c07c1f, 0x18d0001f, 0x40000000, 0x18d0001f, 0xc0000000, 0xd80039a2,
	0x00a00402, 0x814c1801, 0xd8203c05, 0x17c07c1f, 0xd8203d02, 0x17c07c1f,
	0x18d0001f, 0x40000000, 0x18d0001f, 0xa0000000, 0xd8003b02, 0x00a00402,
	0xd8203d02, 0x17c07c1f, 0x18d0001f, 0x40000000, 0x18d0001f, 0x40000000,
	0xd8003c02, 0x00a00402, 0xf0000000, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x1840001f, 0x00000001, 0xa1d48407, 0x1990001f,
	0x10006b08, 0xe8208000, 0x10006b18, 0x00000000, 0x81441801, 0xd8204565,
	0x17c07c1f, 0x1910001f, 0x100062c4, 0x80849001, 0x1a00001f, 0x10006b0c,
	0x1950001f, 0x10006b0c, 0xa1508805, 0xe2000005, 0x18c0001f, 0x2f7ce7ff,
	0x80809001, 0x81600801, 0xa0d59403, 0xa0d60803, 0xd8004465, 0x17c07c1f,
	0x80841001, 0x81600801, 0xa0db9403, 0xa0de0803, 0xd8004465, 0x17c07c1f,
	0x80f60403, 0xe8208000, 0x10006310, 0x0b160c38, 0x13000c1f, 0x1b80001f,
	0xd00f0000, 0xd00045a0, 0x17c07c1f, 0x1b00001f, 0x2f7ce7ff, 0x81469801,
	0xd8204705, 0x17c07c1f, 0x1b80001f, 0xd00f0000, 0x8880000c, 0x2f7ce7ff,
	0xd8006502, 0x17c07c1f, 0xd0004740, 0x17c07c1f, 0x1b80001f, 0x500f0000,
	0xe8208000, 0x10006354, 0x001fdaa3, 0xc0c031e0, 0x81401801, 0xd8004c65,
	0x17c07c1f, 0x81f60407, 0x18c0001f, 0x10006200, 0xc0c03320, 0x12807c1f,
	0xe8208000, 0x1000625c, 0x00000001, 0x1b80001f, 0x20000080, 0xc0c03320,
	0x1280041f, 0x18c0001f, 0x10006208, 0xc0c03320, 0x12807c1f, 0xe8208000,
	0x10006248, 0x00000000, 0x1b80001f, 0x20000080, 0xc0c03320, 0x1280041f,
	0x18c0001f, 0x10006290, 0xc0c03320, 0x12807c1f, 0xc0c03320, 0x1280041f,
	0x18c0001f, 0x100062dc, 0xe0c00001, 0xc28034a0, 0x1292041f, 0x81469801,
	0xd8004d45, 0x17c07c1f, 0x8880000c, 0x2f7ce7ff, 0xd8006062, 0x17c07c1f,
	0xc0c03280, 0x17c07c1f, 0x18c0001f, 0x10006294, 0xe0f07fff, 0xe0e00fff,
	0xe0e000ff, 0x81449801, 0xd8005065, 0x17c07c1f, 0x1a00001f, 0x10006604,
	0xe2200006, 0xc0c035a0, 0x17c07c1f, 0x1a00001f, 0x10006604, 0xe2200001,
	0xc0c035a0, 0x17c07c1f, 0x18c0001f, 0x1000111c, 0x1910001f, 0x10006b14,
	0xe0c00004, 0xa1d38407, 0xa1d98407, 0xa0108400, 0xa0120400, 0xa0148400,
	0xa0150400, 0xa0158400, 0xa01b8400, 0xa01c0400, 0xa01c8400, 0xa0188400,
	0xa0190400, 0xa0198400, 0x81441801, 0xd8205465, 0x17c07c1f, 0x1910001f,
	0x10006b0c, 0x1a00001f, 0x100062c4, 0x1950001f, 0x100062c4, 0x80809001,
	0x81748405, 0xa1548805, 0xe2000005, 0x1a00001f, 0x10006b0c, 0x80c51801,
	0x81308404, 0xa1108c04, 0xe2000004, 0xe8208000, 0x10006310, 0x0b1603f8,
	0x1950001f, 0x100062c4, 0x80841401, 0x81600801, 0x18c0001f, 0xaf7ce7ff,
	0xa0de0803, 0xa0db9403, 0x13000c1f, 0x1b80001f, 0x90100000, 0x80c28001,
	0xc8c00903, 0x17c07c1f, 0x80c10001, 0xc8c00da3, 0x17c07c1f, 0x1a00001f,
	0x100062c4, 0x1890001f, 0x100062c4, 0xa0908402, 0xe2000002, 0x18d0001f,
	0x10006284, 0x80810c01, 0xd8205b02, 0x17c07c1f, 0x18d0001f, 0x100062c4,
	0x80840c01, 0xd8005b02, 0x17c07c1f, 0x18c0001f, 0x10001124, 0x1910001f,
	0x10001124, 0xa1108404, 0xe0c00004, 0x1910001f, 0x10001124, 0x1a00001f,
	0x10006604, 0xe2200007, 0x1a00001f, 0x100062c4, 0x1890001f, 0x100062c4,
	0xa0940402, 0xe2000002, 0x1b00001f, 0x2f7ce7ff, 0x18c0001f, 0x10006294,
	0xe0e001fe, 0xe0e003fc, 0xe0e007f8, 0xe0e00ff0, 0x1b80001f, 0x20000020,
	0xe0f07ff0, 0xe0f07f00, 0x81449801, 0xd8005de5, 0x17c07c1f, 0x1a00001f,
	0x10006604, 0xe2200006, 0xc0c035a0, 0x17c07c1f, 0xe2200000, 0xc0c035a0,
	0x17c07c1f, 0x80388400, 0x80390400, 0x80398400, 0x1b80001f, 0x20000300,
	0x803b8400, 0x803c0400, 0x803c8400, 0x1b80001f, 0x20000300, 0x80348400,
	0x80350400, 0x80358400, 0x1b80001f, 0x20000104, 0x10007c1f, 0x81f38407,
	0x81f98407, 0x81f90407, 0x81f40407, 0x81401801, 0xd8006505, 0x17c07c1f,
	0x18c0001f, 0x100062dc, 0xe0c0001f, 0x18c0001f, 0x10006290, 0x1212841f,
	0xc0c02f60, 0x12807c1f, 0xc0c02f60, 0x1280041f, 0x18c0001f, 0x10006208,
	0x1212841f, 0xc0c02f60, 0x12807c1f, 0xe8208000, 0x10006248, 0x00000001,
	0x1b80001f, 0x20000080, 0xc0c02f60, 0x1280041f, 0x18c0001f, 0x10006200,
	0x1212841f, 0xc0c02f60, 0x12807c1f, 0xe8208000, 0x1000625c, 0x00000000,
	0x1b80001f, 0x20000080, 0xc0c02f60, 0x1280041f, 0x19c0001f, 0x60415820,
	0xe8208000, 0x10006310, 0x0b160008, 0xc28034a0, 0x1293841f, 0x18c0001f,
	0x10006b14, 0xe0c0000c, 0x18c0001f, 0x10006b68, 0x1950001f, 0x100063c0,
	0xe0c00005, 0x81441801, 0xd8206b05, 0x10c0041f, 0x1910001f, 0x100062c4,
	0x80849001, 0x1a00001f, 0x10006b0c, 0x1910001f, 0x10006b0c, 0xa0908804,
	0xe2000002, 0x81441801, 0xd8206b05, 0x10c0041f, 0x1910001f, 0x100062c4,
	0x80809001, 0x81600801, 0xa0d59403, 0xa0d60803, 0xd8006aa5, 0x17c07c1f,
	0x80841001, 0x81600801, 0xa0db9403, 0xa0de0803, 0xd8006aa5, 0x17c07c1f,
	0x80f60403, 0xe8208000, 0x10006310, 0x0b160c38, 0x13000c1f, 0x1b80001f,
	0x900a0000, 0x88900001, 0x10006814, 0xd8206862, 0x17c07c1f, 0x18d0001f,
	0x10006b6c, 0x78a00003, 0x0000beef, 0xd8006d22, 0x17c07c1f, 0xc0c06f80,
	0x17c07c1f, 0xd0006860, 0x17c07c1f, 0x1910001f, 0x10006b0c, 0x1a00001f,
	0x100062c4, 0x1950001f, 0x100062c4, 0x80809001, 0x81748405, 0xa1548805,
	0xe2000005, 0x80841401, 0xd8006f02, 0x8204b401, 0xc8c00008, 0x17c07c1f,
	0x1ac0001f, 0x55aa55aa, 0x10007c1f, 0xf0000000, 0x1900001f, 0x10006014,
	0x1950001f, 0x10006014, 0xa1508405, 0xe1000005, 0x1900001f, 0x10006814,
	0xe100001f, 0x812ab401, 0xd80070a4, 0x17c07c1f, 0x1880001f, 0x10006284,
	0x18d0001f, 0x10006284, 0x80f20403, 0xe0800003, 0x80f08403, 0xe0800003,
	0x1900001f, 0x10006014, 0x1950001f, 0x10006014, 0x81708405, 0xe1000005,
	0x1900001f, 0x10006b6c, 0xe100001f, 0x81441801, 0xd80074e5, 0x17c07c1f,
	0x18c0001f, 0x10001124, 0x1910001f, 0x10001124, 0xa1108404, 0xe0c00004,
	0x1910001f, 0x10001124, 0x1a00001f, 0x10006604, 0xe2200007, 0xf0000000,
	0x17c07c1f
};
static struct pcm_desc dpidle_pcm = {
	.version	= "pcm_deepidle_v0.5.10.3_20160311-dummy_read",
	.base		= dpidle_binary,
	.size		= 937,
	.sess		= 2,
	.replace	= 0,
	.vec0		= EVENT_VEC(23, 1, 0, 0),	/* FUNC_MD_VRF18_WAKEUP */
	.vec1		= EVENT_VEC(28, 1, 0, 36),	/* FUNC_MD_VRF18_SLEEP */
	.vec2		= EVENT_VEC(11, 1, 0, 72),	/* FUNC_26M_WAKEUP */
	.vec3		= EVENT_VEC(12, 1, 0, 88),	/* FUNC_26M_SLEEP */
	.vec4		= EVENT_VEC(30, 1, 0, 109),	/* FUNC_APSRC_WAKEUP */
	.vec5		= EVENT_VEC(31, 1, 0, 196),	/* FUNC_APSRC_SLEEP */
	.vec6		= EVENT_VEC(11, 1, 0, 284),	/* FUNC_VCORE_HIGH */
	.vec7		= EVENT_VEC(12, 1, 0, 311),	/* FUNC_VCORE_LOW */
};


static struct pwr_ctrl dpidle_ctrl = {
	.wake_src = WAKE_SRC_FOR_DPIDLE,
	.wake_src_md32 = WAKE_SRC_FOR_MD32,
	.r0_ctrl_en = 1,
	.r7_ctrl_en = 1,
	.infra_dcm_lock = 1,
	.wfi_op = WFI_OP_AND,
	.ca15_wfi0_en = 1,
	.ca15_wfi1_en = 1,
	.ca15_wfi2_en = 1,
	.ca15_wfi3_en = 1,
	.ca7_wfi0_en = 1,
	.ca7_wfi1_en = 1,
	.ca7_wfi2_en = 1,
	.ca7_wfi3_en = 1,
	.md2_req_mask = 1,
	.disp_req_mask = 1,
	.mfg_req_mask = 1,
	.lte_mask = 1,
	.syspwreq_mask = 1,
};
#elif defined(CONFIG_ARCH_MT6753)
/*
 * PCM code for deep idle
 */
static const u32 dpidle_binary[] = {
	0x81429801, 0xd80000e5, 0x17c07c1f, 0x1a00001f, 0x10006604, 0xc0c03700,
	0xe2200007, 0x1a00001f, 0x100062c4, 0x1890001f, 0x100062c4, 0xa0940402,
	0xe2000002, 0x10c0041f, 0x81008801, 0x81601001, 0xa0d59403, 0xa0d61003,
	0xa0de0403, 0x1910001f, 0x10006310, 0x81439001, 0xd82003e5, 0x13000c1f,
	0x80c10001, 0x1b00001f, 0xbf7ce7ff, 0xd82003e3, 0x17c07c1f, 0x1b00001f,
	0x7f7ce7ff, 0xf0000000, 0x17c07c1f, 0x81429801, 0xd8000505, 0x17c07c1f,
	0x1a00001f, 0x10006604, 0xc0c03700, 0xe2200009, 0x1a00001f, 0x100062c4,
	0x1890001f, 0x100062c4, 0x80b40402, 0xe2000002, 0x10c0041f, 0x81008801,
	0x81601001, 0xa0d59403, 0xa0d61003, 0xa0db8403, 0x1910001f, 0x10006310,
	0x81439001, 0xd8200805, 0x13000c1f, 0x80c10001, 0x1b00001f, 0x6ffcf7ff,
	0xd8000803, 0x17c07c1f, 0x1b00001f, 0xaffce7ff, 0xf0000000, 0x17c07c1f,
	0x81459801, 0xd8000a05, 0x17c07c1f, 0x1a00001f, 0x10006604, 0xc0c03700,
	0xe2200005, 0x1950001f, 0x100062c4, 0x80809401, 0xd8200a02, 0x17c07c1f,
	0xc0c03700, 0xe2200002, 0x80328400, 0x80318400, 0xc2803600, 0x1290041f,
	0x1b00001f, 0x6ffcf7ff, 0xf0000000, 0x17c07c1f, 0x1b00001f, 0x2f7ce7ff,
	0x1b80001f, 0x20000004, 0xd8000d8c, 0x17c07c1f, 0xa0118400, 0xa0128400,
	0xc2803600, 0x1290841f, 0x81459801, 0xd8000d45, 0x17c07c1f, 0x1a00001f,
	0x10006604, 0xe220000a, 0xc0c03700, 0x17c07c1f, 0x1b00001f, 0x2f7cefff,
	0xf0000000, 0x17c07c1f, 0x18c0001f, 0x102135cc, 0x1910001f, 0x102135cc,
	0x813f8404, 0xe0c00004, 0x1910001f, 0x102135cc, 0x81411801, 0xd8000fe5,
	0x17c07c1f, 0x18c0001f, 0x10006240, 0xe0e00016, 0xe0e0001e, 0xe0e0000e,
	0xe0e0000f, 0x803e0400, 0x1b80001f, 0x20000222, 0x80380400, 0x1b80001f,
	0x20000280, 0x803b0400, 0x1b80001f, 0x2000001a, 0x803d0400, 0x1b80001f,
	0x20000208, 0x80340400, 0x80310400, 0x1b80001f, 0x2000000a, 0x18c0001f,
	0x10006240, 0xe0e0000d, 0xd8001605, 0x17c07c1f, 0x1b80001f, 0x20000020,
	0x18c0001f, 0x102130f0, 0x1910001f, 0x102130f0, 0xa9000004, 0x10000000,
	0xe0c00004, 0x1b80001f, 0x2000000a, 0x89000004, 0xefffffff, 0xe0c00004,
	0x18c0001f, 0x102140f4, 0x1910001f, 0x102140f4, 0xa9000004, 0x02000000,
	0xe0c00004, 0x1b80001f, 0x2000000a, 0x89000004, 0xfdffffff, 0xe0c00004,
	0x1910001f, 0x102140f4, 0x81fa0407, 0x81f08407, 0xe8208000, 0x10006354,
	0x001fdaa3, 0xa1d80407, 0xa1de8407, 0xa1df0407, 0xc2803600, 0x1291041f,
	0x1b00001f, 0xbf7ce7ff, 0x1950001f, 0x100062c4, 0x80c41401, 0xd8001863,
	0x17c07c1f, 0x1b00001f, 0xaffce7ff, 0xf0000000, 0x17c07c1f, 0x1b80001f,
	0x20000fdf, 0x1a50001f, 0x10006608, 0x80c9a401, 0x810ba401, 0x10920c1f,
	0xa0979002, 0x80ca2401, 0xa0938c02, 0x8080080d, 0xd8201ce2, 0x17c07c1f,
	0x81f08407, 0xa1d80407, 0xa1de8407, 0xa1df0407, 0x1b00001f, 0x2f7ce7ff,
	0x1b80001f, 0x20000004, 0xd800236c, 0x17c07c1f, 0x1b00001f, 0xbf7ce7ff,
	0x1950001f, 0x100062c4, 0x80c41401, 0xd8002363, 0x17c07c1f, 0x1b00001f,
	0xaffce7ff, 0xd0002360, 0x17c07c1f, 0x81f80407, 0x81fe8407, 0x81ff0407,
	0x1900001f, 0x40000000, 0x18d0001f, 0x40000000, 0xe1000003, 0xc0c037e0,
	0x1080041f, 0x1880001f, 0x10006320, 0xc0c02e40, 0xe080000f, 0xd8001a43,
	0x17c07c1f, 0xe080001f, 0xa1da0407, 0xa0110400, 0xa0140400, 0xa0180400,
	0xa01b0400, 0xa01d0400, 0x1b80001f, 0x20000068, 0xa01e0400, 0x1b80001f,
	0x20000104, 0x18c0001f, 0x102135cc, 0x1910001f, 0x102135cc, 0xa11f8404,
	0xe0c00004, 0x81411801, 0xd8002205, 0x17c07c1f, 0x18c0001f, 0x10006240,
	0xc0c02d80, 0x17c07c1f, 0xc2803600, 0x1291841f, 0x1b00001f, 0x6ffcf7ff,
	0x1950001f, 0x100062c4, 0x80c41401, 0xd8202363, 0x17c07c1f, 0x1b00001f,
	0x7f7ce7ff, 0xf0000000, 0x17c07c1f, 0x81441801, 0xd82025c5, 0x17c07c1f,
	0x1a00001f, 0x10006604, 0xc0c03700, 0xe2200004, 0xc0c037e0, 0x1093041f,
	0xc0c03700, 0xe2200003, 0xc0c037e0, 0x1093041f, 0xc0c03700, 0xe2200002,
	0xc0c037e0, 0x1093041f, 0x1a00001f, 0x100062c4, 0x1890001f, 0x100062c4,
	0xa0908402, 0xe2000002, 0x10c0041f, 0x81040801, 0x81601001, 0xa0db9403,
	0xa0de1003, 0xa0d60403, 0x13000c1f, 0xf0000000, 0x17c07c1f, 0x1a00001f,
	0x100062c4, 0x1890001f, 0x100062c4, 0x80b08402, 0xe2000002, 0x81441801,
	0xd8202a85, 0x17c07c1f, 0x1a00001f, 0x10006604, 0xc0c03700, 0xe2200003,
	0xc0c037e0, 0x1093041f, 0xc0c03700, 0xe2200004, 0xc0c037e0, 0x1093041f,
	0xc0c03700, 0xe2200005, 0xc0c037e0, 0x1093041f, 0x10c0041f, 0x81040801,
	0x81601001, 0xa0db9403, 0xa0de1003, 0xa0d58403, 0x13000c1f, 0xf0000000,
	0x17c07c1f, 0xe0f07f16, 0x1380201f, 0xe0f07f1e, 0x1380201f, 0xe0f07f0e,
	0x1b80001f, 0x20000100, 0xe0f07f0c, 0xe0f07f0d, 0xe0f07e0d, 0xe0f07c0d,
	0xe0f0780d, 0xe0f0700d, 0xf0000000, 0x17c07c1f, 0xe0f07f0d, 0xe0f07f0f,
	0xe0f07f1e, 0xe0f07f12, 0xf0000000, 0x17c07c1f, 0x1112841f, 0xa1d08407,
	0xd8202f04, 0x80eab401, 0xd8002e83, 0x01200404, 0x1a00001f, 0x10006814,
	0xe2000003, 0xf0000000, 0x17c07c1f, 0xa1d00407, 0x1b80001f, 0x20000100,
	0x80ea3401, 0x1a00001f, 0x10006814, 0xe2000003, 0xf0000000, 0x17c07c1f,
	0xd80031ca, 0x17c07c1f, 0xe2e00036, 0x17c07c1f, 0x17c07c1f, 0xe2e0003e,
	0x1380201f, 0xe2e0003c, 0xd820330a, 0x17c07c1f, 0x1b80001f, 0x20000018,
	0xe2e0007c, 0x1b80001f, 0x20000003, 0xe2e0005c, 0xe2e0004c, 0xe2e0004d,
	0xf0000000, 0x17c07c1f, 0xa1d10407, 0x1b80001f, 0x20000020, 0xf0000000,
	0x17c07c1f, 0xa1d40407, 0x1391841f, 0xa1d90407, 0xf0000000, 0x17c07c1f,
	0xd800352a, 0x17c07c1f, 0xe2e0004f, 0xe2e0006f, 0xe2e0002f, 0xd82035ca,
	0x17c07c1f, 0xe2e0002e, 0xe2e0003e, 0xe2e00032, 0xf0000000, 0x17c07c1f,
	0x18c0001f, 0x10006b18, 0x1910001f, 0x10006b18, 0xa1002804, 0xe0c00004,
	0xf0000000, 0x17c07c1f, 0x18d0001f, 0x10006604, 0x10cf8c1f, 0xd8203703,
	0x17c07c1f, 0xf0000000, 0x17c07c1f, 0x81499801, 0xd8203945, 0x17c07c1f,
	0xd8203e62, 0x17c07c1f, 0x18d0001f, 0x40000000, 0x18d0001f, 0x70000000,
	0xd8003842, 0x00a00402, 0x814a1801, 0xd8203aa5, 0x17c07c1f, 0xd8203e62,
	0x17c07c1f, 0x18d0001f, 0x40000000, 0x18d0001f, 0x80000000, 0xd80039a2,
	0x00a00402, 0x814a9801, 0xd8203c05, 0x17c07c1f, 0xd8203e62, 0x17c07c1f,
	0x18d0001f, 0x40000000, 0x18d0001f, 0xc0000000, 0xd8003b02, 0x00a00402,
	0x814c1801, 0xd8203d65, 0x17c07c1f, 0xd8203e62, 0x17c07c1f, 0x18d0001f,
	0x40000000, 0x18d0001f, 0xa0000000, 0xd8003c62, 0x00a00402, 0xd8203e62,
	0x17c07c1f, 0x18d0001f, 0x40000000, 0x18d0001f, 0x40000000, 0xd8003d62,
	0x00a00402, 0xf0000000, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x1840001f, 0x00000001, 0xa1d48407, 0x1990001f,
	0x10006b08, 0xe8208000, 0x10006b18, 0x00000000, 0x81441801, 0xd82046c5,
	0x17c07c1f, 0x1910001f, 0x100062c4, 0x80849001, 0x1a00001f, 0x10006b0c,
	0x1950001f, 0x10006b0c, 0x1900001f, 0x10006b14, 0xe1000005, 0xa1508805,
	0xe2000005, 0x89000005, 0xfffffe43, 0xe2000004, 0x1940001f, 0x10006b68,
	0x1a00001f, 0x10006608, 0x1890001f, 0x10006608, 0xe1400002, 0x89000002,
	0xfd67ffff, 0xe2000004, 0x18c0001f, 0x2f7ce7ff, 0x80809001, 0x81600801,
	0xa0d59403, 0xa0d60803, 0x80841001, 0x81600801, 0xa0db9403, 0xa0de0803,
	0xe8208000, 0x10006310, 0x0b160c38, 0x13000c1f, 0x1b80001f, 0xd00f0000,
	0xd0004700, 0x17c07c1f, 0x1b00001f, 0x2f7ce7ff, 0x81469801, 0xd8204865,
	0x17c07c1f, 0x1b80001f, 0xd00f0000, 0x8880000c, 0x2f7ce7ff, 0xd8006802,
	0x17c07c1f, 0xd00048a0, 0x17c07c1f, 0x1b80001f, 0x500f0000, 0xe8208000,
	0x10006354, 0x001fdaa3, 0xc0c03340, 0x81401801, 0xd8004dc5, 0x17c07c1f,
	0x81f60407, 0x18c0001f, 0x10006200, 0xc0c03480, 0x12807c1f, 0xe8208000,
	0x1000625c, 0x00000001, 0x1b80001f, 0x20000080, 0xc0c03480, 0x1280041f,
	0x18c0001f, 0x10006208, 0xc0c03480, 0x12807c1f, 0xe8208000, 0x10006248,
	0x00000000, 0x1b80001f, 0x20000080, 0xc0c03480, 0x1280041f, 0x18c0001f,
	0x10006290, 0xc0c03480, 0x12807c1f, 0xc0c03480, 0x1280041f, 0x18c0001f,
	0x100062dc, 0xe0c00001, 0xc2803600, 0x1292041f, 0x81469801, 0xd8004ea5,
	0x17c07c1f, 0x8880000c, 0x2f7ce7ff, 0xd8006362, 0x17c07c1f, 0xc0c033e0,
	0x17c07c1f, 0x18c0001f, 0x10006294, 0xe0f07fff, 0xe0e00fff, 0xe0e000ff,
	0x81449801, 0xd8005225, 0x17c07c1f, 0x1a00001f, 0x10006604, 0x814d1801,
	0xd82051a5, 0x17c07c1f, 0xe220000b, 0xc0c07880, 0x12807c1f, 0xc0c03700,
	0x17c07c1f, 0xc2803600, 0x1294041f, 0xd0005220, 0x17c07c1f, 0xc0c03700,
	0xe2200006, 0xc0c03700, 0xe2200001, 0xa1d38407, 0xa1d98407, 0xa0108400,
	0xa0120400, 0xa0148400, 0xa0150400, 0xa0158400, 0xa01b8400, 0xa01c0400,
	0xa01c8400, 0xa0188400, 0xa0190400, 0xa0198400, 0x81441801, 0xd8205765,
	0x17c07c1f, 0x1910001f, 0x10006b0c, 0x1a00001f, 0x100062c4, 0x1950001f,
	0x100062c4, 0x80809001, 0x81748405, 0xa1548805, 0xe2000005, 0x1910001f,
	0x10006b14, 0x1a00001f, 0x10006b0c, 0xe2000004, 0x1950001f, 0x10006b68,
	0x1a00001f, 0x10006608, 0xe2000005, 0x1a00001f, 0x10006b0c, 0x80c51801,
	0x81308404, 0xa1108c04, 0xe2000004, 0xe8208000, 0x10006310, 0x0b1603f8,
	0x1950001f, 0x100062c4, 0x80841401, 0x81600801, 0x18c0001f, 0xaf7ce7ff,
	0xa0de0803, 0xa0db9403, 0x13000c1f, 0x1b80001f, 0x90100000, 0x80c18001,
	0xc8c00843, 0x17c07c1f, 0x80c10001, 0xc8c00dc3, 0x17c07c1f, 0x18d0001f,
	0x10006284, 0x80810c01, 0xd8205c42, 0x17c07c1f, 0x18d0001f, 0x100062c4,
	0x80840c01, 0xd8005c42, 0x17c07c1f, 0x1a00001f, 0x10006604, 0xe2200007,
	0x1a00001f, 0x100062c4, 0x1890001f, 0x100062c4, 0xa0940402, 0xe2000002,
	0x1b00001f, 0x2f7ce7ff, 0x18c0001f, 0x10006294, 0xe0e001fe, 0xe0e003fc,
	0xe0e007f8, 0xe0e00ff0, 0x1b80001f, 0x20000020, 0xe0f07ff0, 0xe0f07f00,
	0x80388400, 0x80390400, 0x80398400, 0x1b80001f, 0x20000300, 0x803b8400,
	0x803c0400, 0x803c8400, 0x1b80001f, 0x20000300, 0x80348400, 0x80350400,
	0x80358400, 0x1b80001f, 0x20000104, 0x10007c1f, 0x81f38407, 0x81f98407,
	0x81f90407, 0x81f40407, 0x81449801, 0xd8006365, 0x17c07c1f, 0x1a00001f,
	0x10006604, 0x814d1801, 0xd82062a5, 0x17c07c1f, 0x1b80001f, 0x2000001a,
	0xe220000c, 0xc0c07880, 0x1280041f, 0xc0c03700, 0x17c07c1f, 0x1b80001f,
	0x20000618, 0xd0006360, 0x17c07c1f, 0xc0c03700, 0xe2200008, 0xc0c03700,
	0xe2200000, 0x1b80001f, 0x2000049c, 0x81401801, 0xd8006805, 0x17c07c1f,
	0x18c0001f, 0x100062dc, 0xe0c0001f, 0x18c0001f, 0x10006290, 0x1212841f,
	0xc0c030c0, 0x12807c1f, 0xc0c030c0, 0x1280041f, 0x18c0001f, 0x10006208,
	0x1212841f, 0xc0c030c0, 0x12807c1f, 0xe8208000, 0x10006248, 0x00000001,
	0x1b80001f, 0x20000080, 0xc0c030c0, 0x1280041f, 0x18c0001f, 0x10006200,
	0x1212841f, 0xc0c030c0, 0x12807c1f, 0xe8208000, 0x1000625c, 0x00000000,
	0x1b80001f, 0x20000080, 0xc0c030c0, 0x1280041f, 0x19c0001f, 0x60415820,
	0xe8208000, 0x10006310, 0x0b160008, 0xc2803600, 0x1293841f, 0x18c0001f,
	0x10006b14, 0xe0c0000c, 0x18c0001f, 0x10006b68, 0x1950001f, 0x100063c0,
	0xe0c00005, 0x81441801, 0xd8206ea5, 0x10c0041f, 0x1910001f, 0x100062c4,
	0x80849001, 0x1a00001f, 0x10006b0c, 0x1910001f, 0x10006b0c, 0xa0908804,
	0xe2000002, 0x89000002, 0xfffffe43, 0xe2000004, 0x1a00001f, 0x10006608,
	0x1890001f, 0x10006608, 0x89000002, 0xfd67ffff, 0xe2000004, 0x81441801,
	0xd8206ea5, 0x10c0041f, 0x1910001f, 0x100062c4, 0x80809001, 0x81600801,
	0xa0d59403, 0xa0d60803, 0x80841001, 0x81600801, 0xa0db9403, 0xa0de0803,
	0xe8208000, 0x10006310, 0x0b160c38, 0x81469801, 0xd8206f65, 0x17c07c1f,
	0xe8208000, 0x100063e0, 0x00000001, 0x13000c1f, 0x1b80001f, 0x900a0000,
	0x88900001, 0x10006814, 0xd8206ca2, 0x17c07c1f, 0x18d0001f, 0x10006b6c,
	0x78a00003, 0x0000beef, 0xd8007182, 0x17c07c1f, 0xc0c073e0, 0x17c07c1f,
	0xd0006ca0, 0x17c07c1f, 0x1910001f, 0x10006b0c, 0x1a00001f, 0x100062c4,
	0x1950001f, 0x100062c4, 0x80809001, 0x81748405, 0xa1548805, 0xe2000005,
	0x80841401, 0xd8007362, 0x8204b401, 0xc8c00008, 0x17c07c1f, 0x1ac0001f,
	0x55aa55aa, 0x10007c1f, 0xf0000000, 0x1900001f, 0x10006014, 0x1950001f,
	0x10006014, 0xa1508405, 0xe1000005, 0x1900001f, 0x10006814, 0xe100001f,
	0x812ab401, 0xd8007504, 0x17c07c1f, 0x1880001f, 0x10006284, 0x18d0001f,
	0x10006284, 0x80f20403, 0xe0800003, 0x80f08403, 0xe0800003, 0x1900001f,
	0x10006014, 0x1950001f, 0x10006014, 0x81708405, 0xe1000005, 0x1900001f,
	0x10006b6c, 0xe100001f, 0x81441801, 0xd8007845, 0x17c07c1f, 0x1a00001f,
	0x10006604, 0xe2200007, 0xf0000000, 0x17c07c1f, 0xe8208000, 0x11012014,
	0x00000002, 0xe8208000, 0x11012020, 0x00000001, 0xe8208000, 0x11012004,
	0x000000d6, 0xe8208000, 0x11012040, 0x00000000, 0x1a00001f, 0x11012000,
	0xd8207baa, 0x17c07c1f, 0xe2200088, 0xe2200002, 0xe8208000, 0x11012024,
	0x00000001, 0x1b80001f, 0x20000158, 0xd0007c80, 0x17c07c1f, 0xe2200088,
	0xe2200000, 0xe8208000, 0x11012024, 0x00000001, 0x1b80001f, 0x20000158,
	0xf0000000, 0x17c07c1f
};
static struct pcm_desc dpidle_pcm = {
	.version	= "pcm_deepidle_v0.2.5.6.4.1_20160311-dummy_read",
	.base		= dpidle_binary,
	.size		= 998,
	.sess		= 2,
	.replace	= 0,
	.vec0		= EVENT_VEC(23, 1, 0, 0),	/* FUNC_MD_VRF18_WAKEUP */
	.vec1		= EVENT_VEC(28, 1, 0, 33),	/* FUNC_MD_VRF18_SLEEP */
	.vec2		= EVENT_VEC(11, 1, 0, 66),	/* FUNC_26M_WAKEUP */
	.vec3		= EVENT_VEC(12, 1, 0, 88),	/* FUNC_26M_SLEEP */
	.vec4		= EVENT_VEC(30, 1, 0, 110),	/* FUNC_APSRC_WAKEUP */
	.vec5		= EVENT_VEC(31, 1, 0, 197),	/* FUNC_APSRC_SLEEP */
	.vec6		= EVENT_VEC(11, 1, 0, 285),	/* FUNC_VCORE_HIGH */
	.vec7		= EVENT_VEC(12, 1, 0, 317),	/* FUNC_VCORE_LOW */
};


static struct pwr_ctrl dpidle_ctrl = {
	.wake_src = WAKE_SRC_FOR_DPIDLE,
	.wake_src_md32 = WAKE_SRC_FOR_MD32,
	.r0_ctrl_en = 1,
	.r7_ctrl_en = 1,
	.infra_dcm_lock = 1,
	.wfi_op = WFI_OP_AND,
	.ca15_wfi0_en = 1,
	.ca15_wfi1_en = 1,
	.ca15_wfi2_en = 1,
	.ca15_wfi3_en = 1,
	.ca7_wfi0_en = 1,
	.ca7_wfi1_en = 1,
	.ca7_wfi2_en = 1,
	.ca7_wfi3_en = 1,
	.disp_req_mask = 1,
	.mfg_req_mask = 1,
	.lte_mask = 1,
	.syspwreq_mask = 1,

	.pcm_apsrc_req = 0,
	.md1_req_mask = 0,
	.md2_req_mask = 0,
};
#elif defined(CONFIG_ARCH_MT6580)
/**********************************************************
 * PCM code for deep idle
 **********************************************************/
static const u32 dpidle_binary[] = {
	0x80318400, 0x80328400, 0xc2802e80, 0x1290041f, 0x1b00001f, 0x7fffd7ff,
	0xf0000000, 0x17c07c1f, 0x1b00001f, 0x3fffc7ff, 0x1b80001f, 0x20000004,
	0xd80002cc, 0x17c07c1f, 0xa0128400, 0xa0118400, 0xc2802e80, 0x1290841f,
	0xc2802e80, 0x129f041f, 0x1b00001f, 0x3fffcfff, 0xf0000000, 0x17c07c1f,
	0x81449801, 0xd8000405, 0x17c07c1f, 0x1a00001f, 0x10006604, 0xe2200000,
	0xc0c02da0, 0x17c07c1f, 0x81491801, 0xd8000565, 0x17c07c1f, 0x18c0001f,
	0x102085cc, 0x1910001f, 0x102085cc, 0x813f8404, 0xe0c00004, 0x1910001f,
	0x102085cc, 0x81411801, 0xd8000685, 0x17c07c1f, 0x18c0001f, 0x10006240,
	0xe0e00016, 0xe0e0001e, 0xe0e0000e, 0xe0e0000f, 0x803e0400, 0x1b80001f,
	0x20000222, 0x80380400, 0x1b80001f, 0x20000280, 0x803b0400, 0x1b80001f,
	0x2000001a, 0x803d0400, 0x1b80001f, 0x20000208, 0x80340400, 0x80310400,
	0x1b80001f, 0x2000000a, 0x18c0001f, 0x10006240, 0xe0e0000d, 0xd8000ca5,
	0x17c07c1f, 0x1b80001f, 0x20000020, 0x18c0001f, 0x102080f0, 0x1910001f,
	0x102080f0, 0xa9000004, 0x10000000, 0xe0c00004, 0x1b80001f, 0x2000000a,
	0x89000004, 0xefffffff, 0xe0c00004, 0x18c0001f, 0x102070f4, 0x1910001f,
	0x102070f4, 0xa9000004, 0x02000000, 0xe0c00004, 0x1b80001f, 0x2000000a,
	0x89000004, 0xfdffffff, 0xe0c00004, 0x1910001f, 0x102070f4, 0x81fa0407,
	0x81f08407, 0xe8208000, 0x10006354, 0xfffffc23, 0xa1d80407, 0xa1df0407,
	0xc2802e80, 0x1291041f, 0x81491801, 0xd8000f25, 0x17c07c1f, 0x18c0001f,
	0x102085cc, 0x1910001f, 0x102085cc, 0xa11f8404, 0xe0c00004, 0x1910001f,
	0x102085cc, 0x1b00001f, 0xbfffc7ff, 0xf0000000, 0x17c07c1f, 0x1b80001f,
	0x20000fdf, 0x1a50001f, 0x10006608, 0x80c9a401, 0x810ba401, 0x10920c1f,
	0xa0979002, 0x8080080d, 0xd82012a2, 0x17c07c1f, 0x81f08407, 0xa1d80407,
	0xa1df0407, 0x1b00001f, 0x3fffc7ff, 0x1b80001f, 0x20000004, 0xd8001b4c,
	0x17c07c1f, 0x1b00001f, 0xbfffc7ff, 0xd0001b40, 0x17c07c1f, 0x81f80407,
	0x81ff0407, 0x1880001f, 0x10006320, 0xc0c02640, 0xe080000f, 0xd8001103,
	0x17c07c1f, 0xe080001f, 0xa1da0407, 0x18c0001f, 0x110040d8, 0x1910001f,
	0x110040d8, 0xa11f8404, 0xe0c00004, 0x1910001f, 0x110040d8, 0x81491801,
	0xd8001645, 0x17c07c1f, 0x18c0001f, 0x102085cc, 0x1910001f, 0x102085cc,
	0x813f8404, 0xe0c00004, 0x1910001f, 0x102085cc, 0xa0110400, 0xa0140400,
	0xa0180400, 0xa01b0400, 0xa01d0400, 0x17c07c1f, 0x17c07c1f, 0xa01e0400,
	0x17c07c1f, 0x17c07c1f, 0x81491801, 0xd80018e5, 0x17c07c1f, 0x18c0001f,
	0x102085cc, 0x1910001f, 0x102085cc, 0xa11f8404, 0xe0c00004, 0x1910001f,
	0x102085cc, 0x81411801, 0xd80019c5, 0x17c07c1f, 0x18c0001f, 0x10006240,
	0xc0c025a0, 0x17c07c1f, 0x81449801, 0xd8001ac5, 0x17c07c1f, 0x1a00001f,
	0x10006604, 0xe2200001, 0xc0c02da0, 0x17c07c1f, 0xc2802e80, 0x1291841f,
	0x1b00001f, 0x7fffd7ff, 0xf0000000, 0x17c07c1f, 0x18c0001f, 0x10006b6c,
	0xe0f03eef, 0x80318400, 0x80328400, 0xa1de0407, 0x80390400, 0x1b80001f,
	0x20000300, 0x803c0400, 0x1b80001f, 0x20000300, 0x80350400, 0x1b80001f,
	0x20000104, 0x81f40407, 0x18c0001f, 0x111403a8, 0xe0c00001, 0x18c0001f,
	0x10006810, 0x1910001f, 0x10006810, 0x81308404, 0xe0c00004, 0x1b00001f,
	0x7fffcfff, 0xf0000000, 0x17c07c1f, 0x81fe0407, 0x18c0001f, 0x10006810,
	0x1910001f, 0x10006810, 0xa1108404, 0xe0c00004, 0x18c0001f, 0x10006b6c,
	0xe0f05ead, 0x1b00001f, 0xffffcfff, 0x80dd040d, 0xd82020a3, 0x17c07c1f,
	0xc0c02ba0, 0x17c07c1f, 0xa0150400, 0xa01c0400, 0xa0190400, 0xf0000000,
	0x17c07c1f, 0xe0f07f16, 0x1380201f, 0xe0f07f1e, 0x1380201f, 0xe0f07f0e,
	0x1b80001f, 0x20000100, 0xe0f07f0c, 0xe0f07f0d, 0xe0f07e0d, 0xe0f07c0d,
	0xe0f0780d, 0xe0f0700d, 0xf0000000, 0x17c07c1f, 0xe0f07f0d, 0xe0f07f0f,
	0xe0f07f1e, 0xe0f07f12, 0xf0000000, 0x17c07c1f, 0xe0e00016, 0x1380201f,
	0xe0e0001e, 0x1380201f, 0xe0e0000e, 0xe0e0000c, 0xe0e0000d, 0xf0000000,
	0x17c07c1f, 0xe0e0000f, 0xe0e0001e, 0xe0e00012, 0xf0000000, 0x17c07c1f,
	0x1112841f, 0xa1d08407, 0xd8202704, 0x80eab401, 0xd8002683, 0x01200404,
	0x1a00001f, 0x10006814, 0xe2000003, 0xf0000000, 0x17c07c1f, 0xa1d00407,
	0x1b80001f, 0x20000100, 0x80ea3401, 0x1a00001f, 0x10006814, 0xe2000003,
	0xf0000000, 0x17c07c1f, 0xd800298a, 0x17c07c1f, 0xe2e00036, 0xe2e0003e,
	0x1380201f, 0xe2e0003c, 0xd8202aca, 0x17c07c1f, 0x1b80001f, 0x20000018,
	0xe2e0007c, 0x1b80001f, 0x20000003, 0xe2e0005c, 0xe2e0004c, 0xe2e0004d,
	0xf0000000, 0x17c07c1f, 0xa1d10407, 0x1b80001f, 0x20000020, 0xf0000000,
	0x17c07c1f, 0xa1d40407, 0x1391841f, 0xf0000000, 0x17c07c1f, 0xd8002cca,
	0x17c07c1f, 0xe2e0004f, 0xe2e0006f, 0xe2e0002f, 0xd8202d6a, 0x17c07c1f,
	0xe2e0002e, 0xe2e0003e, 0xe2e00032, 0xf0000000, 0x17c07c1f, 0x18d0001f,
	0x10006604, 0x10cf8c1f, 0xd8202da3, 0x17c07c1f, 0xf0000000, 0x17c07c1f,
	0x18c0001f, 0x10006b18, 0x1910001f, 0x10006b18, 0xa1002804, 0xe0c00004,
	0xf0000000, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f, 0x17c07c1f,
	0x17c07c1f, 0x17c07c1f, 0x1840001f, 0x00000001, 0xa1d48407, 0x1990001f,
	0x10006b08, 0xe8208000, 0x10006b18, 0x00000000, 0x1b00001f, 0x3fffc7ff,
	0x1b80001f, 0xd00f0000, 0x8880000c, 0x3fffc7ff, 0xd8005522, 0x17c07c1f,
	0xe8208000, 0x10006354, 0xfffffc23, 0xc0c02b00, 0x81401801, 0xd80046c5,
	0x17c07c1f, 0x81f60407, 0x18c0001f, 0x10006200, 0xc0c02c20, 0x12807c1f,
	0xe8208000, 0x1000625c, 0x00000001, 0x1b80001f, 0x20000080, 0xc0c02c20,
	0x1280041f, 0x18c0001f, 0x10006208, 0xc0c02c20, 0x12807c1f, 0xe8208000,
	0x10006248, 0x00000000, 0x1b80001f, 0x20000080, 0xc0c02c20, 0x1280041f,
	0x18c0001f, 0x10006290, 0xc0c02c20, 0x12807c1f, 0xc0c02c20, 0x1280041f,
	0xc2802e80, 0x1292041f, 0x18c0001f, 0x10006294, 0xe0f07fff, 0xe0e00fff,
	0xe0e000ff, 0xc0c02ba0, 0x17c07c1f, 0xa1d38407, 0xa1d98407, 0x18c0001f,
	0x11004078, 0x1910001f, 0x11004078, 0xa11f8404, 0xe0c00004, 0x1910001f,
	0x11004078, 0x18c0001f, 0x11004098, 0x1910001f, 0x11004098, 0xa11f8404,
	0xe0c00004, 0x1910001f, 0x11004098, 0xa0108400, 0xa0120400, 0xa0148400,
	0xa0150400, 0xa0158400, 0xa01b8400, 0xa01c0400, 0xa01c8400, 0xa0188400,
	0xa0190400, 0xa0198400, 0xe8208000, 0x10006310, 0x0b1600f8, 0x1b00001f,
	0xbfffc7ff, 0x1b80001f, 0x90100000, 0x80c18001, 0xc8c00003, 0x17c07c1f,
	0x80c10001, 0xc8c00303, 0x17c07c1f, 0x1b00001f, 0x3fffc7ff, 0x18c0001f,
	0x10006294, 0xe0e001fe, 0xe0e003fc, 0xe0e007f8, 0xe0e00ff0, 0x1b80001f,
	0x20000020, 0xe0f07ff0, 0xe0f07f00, 0x80388400, 0x80390400, 0x80398400,
	0x1b80001f, 0x20000300, 0x803b8400, 0x803c0400, 0x803c8400, 0x1b80001f,
	0x20000300, 0x80348400, 0x80350400, 0x80358400, 0x1b80001f, 0x20000104,
	0x80308400, 0x80320400, 0x81f38407, 0x81f98407, 0x81f40407, 0x81401801,
	0xd8005525, 0x17c07c1f, 0x18c0001f, 0x10006290, 0x1212841f, 0xc0c028c0,
	0x12807c1f, 0xc0c028c0, 0x1280041f, 0x18c0001f, 0x10006208, 0x1212841f,
	0xc0c028c0, 0x12807c1f, 0xe8208000, 0x10006248, 0x00000001, 0x1b80001f,
	0x20000080, 0xc0c028c0, 0x1280041f, 0x18c0001f, 0x10006200, 0x1212841f,
	0xc0c028c0, 0x12807c1f, 0xe8208000, 0x1000625c, 0x00000000, 0x1b80001f,
	0x20000080, 0xc0c028c0, 0x1280041f, 0x81f10407, 0x81f48407, 0xa1d60407,
	0x1ac0001f, 0x55aa55aa, 0x10007c1f, 0xf0000000
};

static struct pcm_desc dpidle_pcm = {
	.version = "pcm_deepidle_v14.0_new",
	.base = dpidle_binary,
	.size = 688,
	.sess = 2,
	.replace = 0,
	.vec0 = EVENT_VEC(11, 1, 0, 0),	/* FUNC_26M_WAKEUP */
	.vec1 = EVENT_VEC(12, 1, 0, 8),	/* FUNC_26M_SLEEP */
	.vec2 = EVENT_VEC(30, 1, 0, 24),	/* FUNC_APSRC_WAKEUP */
	.vec3 = EVENT_VEC(31, 1, 0, 125),	/* FUNC_APSRC_SLEEP */
	.vec4 = EVENT_VEC(20, 1, 0, 220),	/* FUNC_AUDIO_REQ_WAKEUP */
	.vec5 = EVENT_VEC(1, 1, 0, 249),	/* FUNC_AUDIO_REQ_SLEEP */
};

static struct pwr_ctrl dpidle_ctrl = {
	.wake_src = WAKE_SRC_FOR_DPIDLE,
	.wake_src_md32 = WAKE_SRC_FOR_MD32,
	.r0_ctrl_en = 1,
	.r7_ctrl_en = 1,
	.infra_dcm_lock = 1,
	.wfi_op = WFI_OP_AND,
	.ca15_wfi0_en = 1,
	.ca15_wfi1_en = 1,
	.ca15_wfi2_en = 1,
	.ca15_wfi3_en = 1,
	.ca7_wfi0_en = 1,
	.ca7_wfi1_en = 1,
	.ca7_wfi2_en = 1,
	.ca7_wfi3_en = 1,
	.disp_req_mask = 1,
	.mfg_req_mask = 1,
	.lte_mask = 1,
	.syspwreq_mask = 1,
};
#else
#error "Does not support!"
#endif

static unsigned int dpidle_log_discard_cnt;
static unsigned int dpidle_log_print_prev_time;

struct spm_lp_scen __spm_dpidle = {
	.pcmdesc = &dpidle_pcm,
	.pwrctrl = &dpidle_ctrl,
};

int __attribute__ ((weak)) request_uart_to_sleep(void)
{
	return 0;
}

int __attribute__ ((weak)) request_uart_to_wakeup(void)
{
	return 0;
}

#if SPM_AEE_RR_REC
void __attribute__ ((weak)) aee_rr_rec_deepidle_val(u32 val)
{
}

u32 __attribute__ ((weak)) aee_rr_curr_deepidle_val(void)
{
	return 0;
}
#endif

void __attribute__ ((weak)) mt_cirq_clone_gic(void)
{
}

void __attribute__ ((weak)) mt_cirq_enable(void)
{
}

void __attribute__ ((weak)) mt_cirq_flush(void)
{
}

void __attribute__ ((weak)) mt_cirq_disable(void)
{
}

int __attribute__ ((weak)) exec_ccci_kern_func_by_md_id(int md_id, unsigned int id, char *buf,
							unsigned int len)
{
	return 0;
}

u32 __attribute__ ((weak)) spm_get_sleep_wakesrc(void)
{
	return 0;
}

void __attribute__ ((weak)) mt_cpufreq_set_pmic_phase(enum pmic_wrap_phase_id phase)
{
}

static long int idle_get_current_time_ms(void)
{
	struct timeval t;

	do_gettimeofday(&t);
	return ((t.tv_sec & 0xFFF) * 1000000 + t.tv_usec) / 1000;
}

static void spm_trigger_wfi_for_dpidle(struct pwr_ctrl *pwrctrl)
{
#if defined(CONFIG_ARCH_MT6753)
	u32 v0, v1;
#endif

	if (is_cpu_pdn(pwrctrl->pcm_flags)) {
		mt_cpu_dormant(CPU_DEEPIDLE_MODE);
	} else {
		/*
		 * MT6735/MT6735M: Mp0_axi_config[4] is one by default. No need to program it before entering deepidle.
		 * MT6753:         Have to program it before entering deepidle.
		 */
#if defined(CONFIG_ARM_MT6735) || defined(CONFIG_ARM_MT6735M) || defined(CONFIG_ARCH_MT6580)
		wfi_with_sync();
#elif defined(CONFIG_ARCH_MT6753)
		/* backup MPx_AXI_CONFIG */
		v0 = reg_read(MP0_AXI_CONFIG);
		v1 = reg_read(MP1_AXI_CONFIG);

		/* disable snoop function */
		MCUSYS_SMC_WRITE(MP0_AXI_CONFIG, v0 | ACINACTM);
		MCUSYS_SMC_WRITE(MP1_AXI_CONFIG, v1 | ACINACTM);

		wfi_with_sync();

		/* restore MP0_AXI_CONFIG */
		MCUSYS_SMC_WRITE(MP0_AXI_CONFIG, v0);
		MCUSYS_SMC_WRITE(MP1_AXI_CONFIG, v1);
#endif
	}
}

/*
 * wakesrc: WAKE_SRC_XXX
 * enable : enable or disable @wakesrc
 * replace: if true, will replace the default setting
 */
int spm_set_dpidle_wakesrc(u32 wakesrc, bool enable, bool replace)
{
	unsigned long flags;

	if (spm_is_wakesrc_invalid(wakesrc))
		return -EINVAL;

	spin_lock_irqsave(&__spm_lock, flags);
	if (enable) {
		if (replace)
			__spm_dpidle.pwrctrl->wake_src = wakesrc;
		else
			__spm_dpidle.pwrctrl->wake_src |= wakesrc;
	} else {
		if (replace)
			__spm_dpidle.pwrctrl->wake_src = 0;
		else
			__spm_dpidle.pwrctrl->wake_src &= ~wakesrc;
	}
	spin_unlock_irqrestore(&__spm_lock, flags);

	return 0;
}

static wake_reason_t spm_output_wake_reason(struct wake_status *wakesta, struct pcm_desc *pcmdesc, u32 dump_log)
{
	wake_reason_t wr = WR_NONE;
	unsigned long int dpidle_log_print_curr_time = 0;
	bool log_print = false;
	static bool timer_out_too_short;

	if (dump_log == DEEPIDLE_LOG_FULL) {
		wr = __spm_output_wake_reason(wakesta, pcmdesc, false);
	} else if (dump_log == DEEPIDLE_LOG_REDUCED) {
		/* Determine print SPM log or not */
		dpidle_log_print_curr_time = idle_get_current_time_ms();

		if (wakesta->assert_pc != 0)
			log_print = true;
#if 0
		/* Not wakeup by GPT */
		else if ((wakesta->r12 & (0x1 << 4)) == 0)
			log_print = true;
		else if (wakesta->timer_out <= DPIDLE_LOG_PRINT_TIMEOUT_CRITERIA)
			log_print = true;
#endif
		else if ((dpidle_log_print_curr_time - dpidle_log_print_prev_time) >
			 DPIDLE_LOG_DISCARD_CRITERIA)
			log_print = true;

		if (wakesta->timer_out <= DPIDLE_LOG_PRINT_TIMEOUT_CRITERIA)
			timer_out_too_short = true;

		/* Print SPM log */
		if (log_print == true) {
			dpidle_dbg("dpidle_log_discard_cnt = %d, timer_out_too_short = %d\n",
						dpidle_log_discard_cnt,
						timer_out_too_short);
			wr = __spm_output_wake_reason(wakesta, pcmdesc, false);

			dpidle_log_print_prev_time = dpidle_log_print_curr_time;
			dpidle_log_discard_cnt = 0;
			timer_out_too_short = false;
		} else {
			dpidle_log_discard_cnt++;

			wr = WR_NONE;
		}
	}
#if !defined(CONFIG_ARCH_MT6580)
	if (wakesta->r12 & WAKE_SRC_CLDMA_MD)
		exec_ccci_kern_func_by_md_id(0, ID_GET_MD_WAKEUP_SRC, NULL, 0);
#endif

	return wr;
}

#if defined(CONFIG_ARM_MT6735) || defined(CONFIG_ARM_MT6735M) || defined(CONFIG_ARCH_MT6753)
static u32 vsram_vosel_on_lb;
#endif
static void spm_dpidle_pre_process(void)
{
	/* set PMIC WRAP table for deepidle power control */
	mt_cpufreq_set_pmic_phase(PMIC_WRAP_PHASE_DEEPIDLE);
#if defined(CONFIG_ARM_MT6735) || defined(CONFIG_ARM_MT6735M) || defined(CONFIG_ARCH_MT6753)
	vsram_vosel_on_lb = __spm_dpidle_sodi_set_pmic_setting();
#endif
}

static void spm_dpidle_post_process(void)
{
#if defined(CONFIG_ARM_MT6735) || defined(CONFIG_ARM_MT6735M) || defined(CONFIG_ARCH_MT6753)
	__spm_dpidle_sodi_restore_pmic_setting(vsram_vosel_on_lb);
#endif
	/* set PMIC WRAP table for normal power control */
	mt_cpufreq_set_pmic_phase(PMIC_WRAP_PHASE_NORMAL);
}

wake_reason_t spm_go_to_dpidle(u32 spm_flags, u32 spm_data, u32 dump_log)
{
	struct wake_status wakesta;
	unsigned long flags;
	struct mtk_irq_mask mask;
	wake_reason_t wr = WR_NONE;
	struct pcm_desc *pcmdesc = __spm_dpidle.pcmdesc;
	struct pwr_ctrl *pwrctrl = __spm_dpidle.pwrctrl;

#if SPM_AEE_RR_REC
	aee_rr_rec_deepidle_val(1 << SPM_DEEPIDLE_ENTER);
#endif

	set_pwrctrl_pcm_flags(pwrctrl, spm_flags);

	spm_dpidle_before_wfi();

	lockdep_off();
	spin_lock_irqsave(&__spm_lock, flags);
	mt_irq_mask_all(&mask);
	mt_irq_unmask_for_sleep(SPM_IRQ0_ID);
	mt_cirq_clone_gic();
	mt_cirq_enable();

#if defined(CONFIG_ARCH_MT6753)
	__spm_enable_i2c4_clk();
#endif

#if SPM_AEE_RR_REC
	aee_rr_rec_deepidle_val(aee_rr_curr_deepidle_val() | (1 << SPM_DEEPIDLE_ENTER_UART_SLEEP));
#endif

#if !defined(CONFIG_ARCH_MT6580)
	if (request_uart_to_sleep()) {
		wr = WR_UART_BUSY;
		goto RESTORE_IRQ;
	}
#endif

	__spm_reset_and_init_pcm(pcmdesc);

	__spm_kick_im_to_fetch(pcmdesc);

	__spm_init_pcm_register();

	__spm_init_event_vector(pcmdesc);

	__spm_set_power_control(pwrctrl);

	__spm_set_wakeup_event(pwrctrl);

	spm_dpidle_pre_process();

	__spm_kick_pcm_to_run(pwrctrl);

#if SPM_AEE_RR_REC
	aee_rr_rec_deepidle_val(aee_rr_curr_deepidle_val() | (1 << SPM_DEEPIDLE_ENTER_WFI));
#endif

#ifdef SPM_DEEPIDLE_PROFILE_TIME
	gpt_get_cnt(SPM_PROFILE_APXGPT, &dpidle_profile[1]);
#endif
#if defined(CONFIG_ARCH_MT6580)
	gic_set_primask();
#endif
	spm_trigger_wfi_for_dpidle(pwrctrl);

#if defined(CONFIG_ARCH_MT6580)
	gic_clear_primask();
#endif
#ifdef SPM_DEEPIDLE_PROFILE_TIME
	gpt_get_cnt(SPM_PROFILE_APXGPT, &dpidle_profile[2]);
#endif

#if SPM_AEE_RR_REC
	aee_rr_rec_deepidle_val(aee_rr_curr_deepidle_val() | (1 << SPM_DEEPIDLE_LEAVE_WFI));
#endif

	spm_dpidle_post_process();

	__spm_get_wakeup_status(&wakesta);

	__spm_clean_after_wakeup();

#if SPM_AEE_RR_REC
	aee_rr_rec_deepidle_val(aee_rr_curr_deepidle_val() | (1 << SPM_DEEPIDLE_ENTER_UART_AWAKE));
#endif

#if !defined(CONFIG_ARCH_MT6580)
	request_uart_to_wakeup();
#endif

	wr = spm_output_wake_reason(&wakesta, pcmdesc, dump_log);

#if defined(CONFIG_ARCH_MT6753)
	__spm_disable_i2c4_clk();
#endif
#if !defined(CONFIG_ARCH_MT6580)
RESTORE_IRQ:
#endif
	mt_cirq_flush();
	mt_cirq_disable();
	mt_irq_mask_restore(&mask);
	spin_unlock_irqrestore(&__spm_lock, flags);
	lockdep_on();
	spm_dpidle_after_wfi();

#if SPM_AEE_RR_REC
	aee_rr_rec_deepidle_val(0);
#endif
	return wr;
}

/*
 * cpu_pdn:
 *    true  = CPU dormant
 *    false = CPU standby
 * pwrlevel:
 *    0 = AXI is off
 *    1 = AXI is 26M
 * pwake_time:
 *    >= 0  = specific wakeup period
 */
wake_reason_t spm_go_to_sleep_dpidle(u32 spm_flags, u32 spm_data)
{
	u32 sec = 0;
	int wd_ret;
	struct wake_status wakesta;
	unsigned long flags;
	struct mtk_irq_mask mask;
	struct wd_api *wd_api;
	static wake_reason_t last_wr = WR_NONE;
	struct pcm_desc *pcmdesc = __spm_dpidle.pcmdesc;
	struct pwr_ctrl *pwrctrl = __spm_dpidle.pwrctrl;

	set_pwrctrl_pcm_flags(pwrctrl, spm_flags);

#if SPM_PWAKE_EN
	sec = spm_get_wake_period(-1 /* FIXME */ , last_wr);
#endif
	pwrctrl->timer_val = sec * 32768;

	pwrctrl->wake_src = spm_get_sleep_wakesrc();

	wd_ret = get_wd_api(&wd_api);
	if (!wd_ret)
		wd_api->wd_suspend_notify();

	spin_lock_irqsave(&__spm_lock, flags);

	mt_irq_mask_all(&mask);
	mt_irq_unmask_for_sleep(SPM_IRQ0_ID);

	mt_cirq_clone_gic();
	mt_cirq_enable();

	/* set PMIC WRAP table for deepidle power control */
	mt_cpufreq_set_pmic_phase(PMIC_WRAP_PHASE_DEEPIDLE);

	spm_crit2("sleep_deepidle, sec = %u, wakesrc = 0x%x [%u]\n",
		  sec, pwrctrl->wake_src, is_cpu_pdn(pwrctrl->pcm_flags));

	__spm_reset_and_init_pcm(pcmdesc);

	__spm_kick_im_to_fetch(pcmdesc);

	if (request_uart_to_sleep()) {
		last_wr = WR_UART_BUSY;
		goto RESTORE_IRQ;
	}

	__spm_init_pcm_register();

	__spm_init_event_vector(pcmdesc);

	__spm_set_power_control(pwrctrl);

	__spm_set_wakeup_event(pwrctrl);

	__spm_kick_pcm_to_run(pwrctrl);

	spm_dpidle_pre_process();

	spm_trigger_wfi_for_dpidle(pwrctrl);

	spm_dpidle_post_process();

	__spm_get_wakeup_status(&wakesta);

	__spm_clean_after_wakeup();

	request_uart_to_wakeup();

	last_wr = __spm_output_wake_reason(&wakesta, pcmdesc, true);

RESTORE_IRQ:

	/* set PMIC WRAP table for normal power control */
	mt_cpufreq_set_pmic_phase(PMIC_WRAP_PHASE_NORMAL);

	mt_cirq_flush();
	mt_cirq_disable();

	mt_irq_mask_restore(&mask);

	spin_unlock_irqrestore(&__spm_lock, flags);

	if (!wd_ret)
		wd_api->wd_resume_notify();

	return last_wr;
}

#if SPM_USE_TWAM_DEBUG
#define SPM_TWAM_MONITOR_TICK 333333


static void twam_handler(struct twam_sig *twamsig)
{
	spm_crit("sig_high = %u%%  %u%%  %u%%  %u%%, r13 = 0x%x\n",
		 get_percent(twamsig->sig0, SPM_TWAM_MONITOR_TICK),
		 get_percent(twamsig->sig1, SPM_TWAM_MONITOR_TICK),
		 get_percent(twamsig->sig2, SPM_TWAM_MONITOR_TICK),
		 get_percent(twamsig->sig3, SPM_TWAM_MONITOR_TICK), spm_read(SPM_PCM_REG13_DATA));
}
#endif

void spm_deepidle_init(void)
{
#if defined(CONFIG_ARCH_MT6753)
#if defined(CONFIG_OF)
	struct device_node *node;
	struct resource r;

	/* mcucfg */
	node = of_find_compatible_node(NULL, NULL, MCUCFG_NODE);
	if (!node) {
		spm_err("error: cannot find node " MCUCFG_NODE);
		BUG();
	}

	mcucfg_base = (unsigned long)of_iomap(node, 0);
	if (!mcucfg_base) {
		spm_err("error: cannot iomap " MCUCFG_NODE);
		BUG();
	}
	if (of_address_to_resource(node, 0, &r)) {
		spm_err("error: cannot get phys addr" MCUCFG_NODE);
		BUG();
	}
	mcucfg_phys_base = r.start;

	pr_debug("[%s] mcucfg_base = 0x%u\n", __func__, (unsigned int)mcucfg_base);
#endif
#endif

#if SPM_USE_TWAM_DEBUG
	unsigned long flags;
	struct twam_sig twamsig = {
		.sig0 = 26,	/* md1_srcclkena */
		.sig1 = 22,	/* md_apsrc_req_mux */
		.sig2 = 25,	/* md2_srcclkena */
		.sig3 = 21,	/* md2_apsrc_req_mux */
	};

	spm_twam_register_handler(twam_handler);
	spm_twam_enable_monitor(&twamsig, false, SPM_TWAM_MONITOR_TICK);
#endif
}

MODULE_DESCRIPTION("SPM-DPIdle Driver v0.1");
